/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$EmptyBody$;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyFutureExecutor$;

public final class NettyBodyWriter$ {
    public static final NettyBodyWriter$ MODULE$ = new NettyBodyWriter$();

    public ZIO<Object, Throwable, Object> write(Body body, ChannelHandlerContext ctx) {
        ZIO zIO;
        if (body instanceof NettyBody.ByteBufBody) {
            NettyBody.ByteBufBody byteBufBody = (NettyBody.ByteBufBody)body;
            zIO = ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                ctx.write((Object)byteBufBody.byteBuf());
                return false;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:34)");
        } else if (body instanceof Body.FileBody) {
            Body.FileBody fileBody = (Body.FileBody)body;
            zIO = ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                File file = fileBody.file();
                ctx.write((Object)new DefaultFileRegion(file, 0L, file.length()));
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                return true;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:39)");
        } else if (body instanceof NettyBody.AsyncBody) {
            Function1<NettyBody.UnsafeAsync, BoxedUnit> async = ((NettyBody.AsyncBody)body).unsafeAsync();
            zIO = ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                async.apply((ctx, msg, isLast) -> {
                    ctx.writeAndFlush((Object)msg);
                    if (isLast) {
                        ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                    }
                });
                return true;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:49)");
        } else if (body instanceof NettyBody.AsciiStringBody) {
            AsciiString asciiString = ((NettyBody.AsciiStringBody)body).asciiString();
            zIO = ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                ctx.write((Object)Unpooled.wrappedBuffer((byte[])asciiString.array()));
                return false;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:57)");
        } else if (body instanceof Body.StreamBody) {
            zIO = ((Body.StreamBody)body).stream().runForeachChunk((Function1 & Serializable)chunk -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])((byte[])chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte()))))), "zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:64)"), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:63)").zipRight((Function0 & Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT), "zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:69)").as((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:71)"), (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:68)");
        } else if (body instanceof Body.ChunkBody) {
            Chunk<Object> data = ((Body.ChunkBody)body).data();
            zIO = ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                ctx.write((Object)Unpooled.wrappedBuffer((byte[])((byte[])data.toArray((ClassTag)ClassTag$.MODULE$.Byte()))));
                return false;
            }, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:74)");
        } else if (Body$EmptyBody$.MODULE$.equals(body)) {
            zIO = ZIO$.MODULE$.succeed((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Object)"zio.http.netty.NettyBodyWriter.write(NettyBodyWriter.scala:78)");
        } else {
            throw new MatchError((Object)body);
        }
        return zIO;
    }

    private NettyBodyWriter$() {
    }
}

