/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Cookie;
import zio.http.Cookie$SameSite$Lax$;
import zio.http.Cookie$SameSite$None$;
import zio.http.Cookie$SameSite$Strict$;
import zio.http.Path;
import zio.http.Path$;
import zio.http.internal.CookieEncoding;

public final class NettyCookieEncoding$
implements CookieEncoding {
    public static final NettyCookieEncoding$ MODULE$ = new NettyCookieEncoding$();

    @Override
    public final String encodeRequestCookie(Cookie.Request cookie, boolean validate2) {
        ClientCookieEncoder encoder = validate2 ? ClientCookieEncoder.STRICT : ClientCookieEncoder.LAX;
        DefaultCookie builder = new DefaultCookie(cookie.name(), cookie.content());
        return encoder.encode((Cookie)builder);
    }

    @Override
    public final Chunk<Cookie.Request> decodeRequestCookie(String header, boolean validate2) {
        ServerCookieDecoder decoder = validate2 ? ServerCookieDecoder.STRICT : ServerCookieDecoder.LAX;
        return Chunk$.MODULE$.fromJavaIterable((Iterable)decoder.decodeAll(header)).map((Function1 & Serializable)cookie -> new Cookie.Request(cookie.name(), cookie.value()));
    }

    @Override
    public final String encodeResponseCookie(Cookie.Response cookie, boolean validate2) {
        DefaultCookie builder = new DefaultCookie(cookie.name(), cookie.content());
        ServerCookieEncoder encoder = validate2 ? ServerCookieEncoder.STRICT : ServerCookieEncoder.LAX;
        cookie.domain().foreach((Function1 & Serializable)x$1 -> {
            builder.setDomain(x$1);
            return BoxedUnit.UNIT;
        });
        cookie.path().foreach((Function1 & Serializable)i -> {
            builder.setPath(i.encode());
            return BoxedUnit.UNIT;
        });
        cookie.maxAge().foreach((Function1 & Serializable)i -> {
            builder.setMaxAge(i.getSeconds());
            return BoxedUnit.UNIT;
        });
        cookie.sameSite().foreach((Function1 & Serializable)x0$1 -> {
            NettyCookieEncoding$.$anonfun$encodeResponseCookie$4(builder, x0$1);
            return BoxedUnit.UNIT;
        });
        builder.setHttpOnly(cookie.isHttpOnly());
        builder.setSecure(cookie.isSecure());
        return encoder.encode((Cookie)builder);
    }

    @Override
    public final Cookie.Response decodeResponseCookie(String header, boolean validate2) {
        Option option;
        DefaultCookie cookie = (DefaultCookie)(validate2 ? ClientCookieDecoder.STRICT : ClientCookieDecoder.LAX).decode(header);
        String x$12 = cookie.name();
        String x$2 = cookie.value();
        Option x$3 = Option$.MODULE$.apply((Object)cookie.domain());
        Option x$4 = Option$.MODULE$.apply((Object)cookie.path()).map((Function1 & Serializable)path -> Path$.MODULE$.decode((String)path));
        Option x$5 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)cookie.maxAge())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 >= 0L).map((Function1 & Serializable)i -> NettyCookieEncoding$.$anonfun$decodeResponseCookie$3(BoxesRunTime.unboxToLong((Object)i)));
        boolean x$6 = cookie.isSecure();
        boolean x$7 = cookie.isHttpOnly();
        CookieHeaderNames.SameSite sameSite = cookie.sameSite();
        if (CookieHeaderNames.SameSite.Strict.equals(sameSite)) {
            option = Option$.MODULE$.apply((Object)Cookie$SameSite$Strict$.MODULE$);
        } else if (CookieHeaderNames.SameSite.Lax.equals(sameSite)) {
            option = Option$.MODULE$.apply((Object)Cookie$SameSite$Lax$.MODULE$);
        } else if (CookieHeaderNames.SameSite.None.equals(sameSite)) {
            option = Option$.MODULE$.apply((Object)Cookie$SameSite$None$.MODULE$);
        } else if (sameSite == null) {
            option = None$.MODULE$;
        } else {
            throw new MatchError((Object)sameSite);
        }
        return new Cookie.Response(x$12, x$2, (Option<String>)x$3, (Option<Path>)x$4, x$6, x$7, (Option<Duration>)x$5, (Option<Cookie.SameSite>)option);
    }

    public static final /* synthetic */ void $anonfun$encodeResponseCookie$4(DefaultCookie builder$1, Cookie.SameSite x0$1) {
        if (Cookie$SameSite$Strict$.MODULE$.equals(x0$1)) {
            builder$1.setSameSite(CookieHeaderNames.SameSite.Strict);
            return;
        }
        if (Cookie$SameSite$Lax$.MODULE$.equals(x0$1)) {
            builder$1.setSameSite(CookieHeaderNames.SameSite.Lax);
            return;
        }
        if (Cookie$SameSite$None$.MODULE$.equals(x0$1)) {
            builder$1.setSameSite(CookieHeaderNames.SameSite.None);
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ Duration $anonfun$decodeResponseCookie$3(long i) {
        return Duration.ofSeconds(i);
    }

    private NettyCookieEncoding$() {
    }
}

