/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$;
import zio.http.ChannelEvent$UserEvent$HandshakeComplete$;
import zio.http.ChannelEvent$UserEvent$HandshakeTimeout$;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.NettyRuntime$;
import zio.http.socket.SocketApp;
import zio.http.socket.WebSocketFrame;
import zio.http.socket.WebSocketFrame$Binary$;
import zio.http.socket.WebSocketFrame$Continuation$;
import zio.http.socket.WebSocketFrame$Ping$;
import zio.http.socket.WebSocketFrame$Pong$;
import zio.http.socket.WebSocketFrame$Text$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb!\u0002\t\u0012\u0005U9\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011I\u0002!\u0011!Q\u0001\nMB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006Y\u0001\u0011\u0005\u0006\u0019\u0002!\t!\u0014\u0005\b'\u0002\u0011\r\u0011b\u0003U\u0011\u0019I\u0006\u0001)A\u0005+\")!\f\u0001C\u00057\")!\u000e\u0001C!W\")q\u000e\u0001C!a\")!\u000f\u0001C!g\")Q\u000f\u0001C!m\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\n\u0001\u0011%\u0011Q\u0003\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\u00111cV3c'>\u001c7.\u001a;BaBD\u0015M\u001c3mKJT!AE\n\u0002\u000b9,G\u000f^=\u000b\u0005Q)\u0012\u0001\u00025uiBT\u0011AF\u0001\u0004u&|7C\u0001\u0001\u0019!\rIr$I\u0007\u00025)\u00111\u0004H\u0001\bG\"\fgN\\3m\u0015\t\u0011RDC\u0001\u001f\u0003\tIw.\u0003\u0002!5\tY2+[7qY\u0016\u001c\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"A\t\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\u0015],'m]8dW\u0016$\bP\u0003\u0002\u0015M)\u0011q\u0005K\u0001\u0006G>$Wm\u0019\u0006\u0003Sq\tq\u0001[1oI2,'/\u0003\u0002,G\tqq+\u001a2T_\u000e\\W\r\u001e$sC6,\u0017!\u0002>Fq\u0016\u001c7\u0001\u0001\t\u0003_Aj\u0011!E\u0005\u0003cE\u0011ABT3uif\u0014VO\u001c;j[\u0016\f1!\u00199q!\r!t'O\u0007\u0002k)\u0011agE\u0001\u0007g>\u001c7.\u001a;\n\u0005a*$!C*pG.,G/\u00119q!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\r\te._\u0001\u0006iJ\f7-\u001a\t\u0003\u0003&s!AQ$\u000f\u0005\r3U\"\u0001#\u000b\u0005\u0015k\u0013A\u0002\u001fs_>$h(C\u0001\u0017\u0013\tAU#A\u0004qC\u000e\\\u0017mZ3\n\u0005)[%!\u0002+sC\u000e,'B\u0001%\u0016\u0003\u0019a\u0014N\\5u}Q\u0019a*\u0015*\u0015\u0005=\u0003\u0006CA\u0018\u0001\u0011\u0015yD\u0001q\u0001A\u0011\u0015aC\u00011\u0001/\u0011\u0015\u0011D\u00011\u00014\u0003-)hn]1gK\u000ec\u0017m]:\u0016\u0003U\u0003\"AV,\u000e\u0003UI!\u0001W\u000b\u0003\rUs7/\u00194f\u00031)hn]1gK\u000ec\u0017m]:!\u0003!!\u0017n\u001d9bi\u000eDGc\u0001/`IB\u0011!(X\u0005\u0003=n\u0012A!\u00168ji\")\u0001m\u0002a\u0001C\u0006\u00191\r\u001e=\u0011\u0005e\u0011\u0017BA2\u001b\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDQ!Z\u0004A\u0002\u0019\fQ!\u001a<f]R\u0004Ba\u001a5\"C5\t1#\u0003\u0002j'\ta1\t[1o]\u0016dWI^3oi\u0006a1\r[1o]\u0016d'+Z1eaQ\u0019A\f\\7\t\u000b\u0001D\u0001\u0019A1\t\u000b9D\u0001\u0019A\u0011\u0002\u00075\u001cx-A\tdQ\u0006tg.\u001a7SK\u001eL7\u000f^3sK\u0012$\"\u0001X9\t\u000b\u0001L\u0001\u0019A1\u0002'\rD\u0017M\u001c8fYVs'/Z4jgR,'/\u001a3\u0015\u0005q#\b\"\u00021\u000b\u0001\u0004\t\u0017aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\u0007q;\b\u0010C\u0003a\u0017\u0001\u0007\u0011\rC\u0003z\u0017\u0001\u0007!0A\u0003dCV\u001cX\r\u0005\u0002|\u007f:\u0011AP \b\u0003\u0007vL\u0011\u0001P\u0005\u0003\u0011nJA!!\u0001\u0002\u0004\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003\u0011n\n!#^:fe\u00163XM\u001c;Ue&<w-\u001a:fIR)A,!\u0003\u0002\f!)\u0001\r\u0004a\u0001C\"1a\u000e\u0004a\u0001\u0003\u001b\u00012AOA\b\u0013\r\t\tb\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\u0013\rD\u0017M\u001c8fY>3G\u0003BA\f\u0003;\u0001BaZA\rC%\u0019\u00111D\n\u0003\u000f\rC\u0017M\u001c8fY\")\u0001-\u0004a\u0001C\u0006qaM]1nK\u001a\u0013x.\u001c(fiRLH\u0003BA\u0012\u0003O\u00012\u0001NA\u0013\u0013\tYS\u0007\u0003\u0004\u0002*9\u0001\r!I\u0001\u0007U\u001a\u0013\u0018-\\3\u0002\u0019\u0019\u0014\u0018-\\3U_:+G\u000f^=\u0015\u0007\u0005\ny\u0003C\u0004\u00022=\u0001\r!a\t\u0002\u000b\u0019\u0014\u0018-\\3")
public final class WebSocketAppHandler
extends SimpleChannelInboundHandler<io.netty.handler.codec.http.websocketx.WebSocketFrame> {
    private final NettyRuntime zExec;
    private final SocketApp<Object> app;
    private final Object trace;
    private final Unsafe unsafeClass;
    private volatile boolean bitmap$init$0;

    private Unsafe unsafeClass() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/netty/WebSocketAppHandler.scala: 41");
        }
        return this.unsafeClass;
    }

    private void dispatch(ChannelHandlerContext ctx, ChannelEvent<io.netty.handler.codec.http.websocketx.WebSocketFrame, io.netty.handler.codec.http.websocketx.WebSocketFrame> event) {
        Option<Function1<ChannelEvent<WebSocketFrame, WebSocketFrame>, ZIO<Object, Throwable, Object>>> option = this.app.message();
        if (option instanceof Some) {
            Function1 f = (Function1)((Some)option).value();
            this.zExec.runUninterruptible(ctx, NettyRuntime$.MODULE$.noopEnsuring(), (ZIO<Object, Throwable, Object>)((ZIO)f.apply(event.map((Function1 & Serializable)jFrame -> this.frameFromNetty((io.netty.handler.codec.http.websocketx.WebSocketFrame)jFrame)).contramap((Function1 & Serializable)frame -> this.frameToNetty((WebSocketFrame)frame)))), this.unsafeClass(), this.trace);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void channelRead0(ChannelHandlerContext ctx, io.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.channelRead(this.channelOf(ctx), msg));
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.channelRegistered(this.channelOf(ctx)));
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.channelUnregistered(this.channelOf(ctx)));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.exceptionCaught(this.channelOf(ctx), cause));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) {
        boolean bl = msg instanceof WebSocketServerProtocolHandler.HandshakeComplete ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE.equals(msg);
        if (bl) {
            this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(this.channelOf(ctx), ChannelEvent$UserEvent$HandshakeComplete$.MODULE$));
            return;
        }
        boolean bl2 = WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg) ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg);
        if (bl2) {
            this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(this.channelOf(ctx), ChannelEvent$UserEvent$HandshakeTimeout$.MODULE$));
            return;
        }
        super.userEventTriggered(ctx, msg);
    }

    private Channel<io.netty.handler.codec.http.websocketx.WebSocketFrame> channelOf(ChannelHandlerContext ctx) {
        return NettyChannel$.MODULE$.make(ctx.channel());
    }

    private WebSocketFrame frameFromNetty(io.netty.handler.codec.http.websocketx.WebSocketFrame jFrame) {
        WebSocketFrame webSocketFrame;
        if (jFrame instanceof PingWebSocketFrame) {
            webSocketFrame = WebSocketFrame$Ping$.MODULE$;
        } else if (jFrame instanceof PongWebSocketFrame) {
            webSocketFrame = WebSocketFrame$Pong$.MODULE$;
        } else if (jFrame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)jFrame;
            webSocketFrame = WebSocketFrame$Binary$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)binaryWebSocketFrame.content())), binaryWebSocketFrame.isFinalFragment());
        } else if (jFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)jFrame;
            webSocketFrame = WebSocketFrame$Text$.MODULE$.apply(textWebSocketFrame.text(), textWebSocketFrame.isFinalFragment());
        } else if (jFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)jFrame;
            webSocketFrame = new WebSocketFrame.Close(closeWebSocketFrame.statusCode(), (Option<String>)Option$.MODULE$.apply((Object)closeWebSocketFrame.reasonText()));
        } else if (jFrame instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)jFrame;
            webSocketFrame = WebSocketFrame$Continuation$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)continuationWebSocketFrame.content())), continuationWebSocketFrame.isFinalFragment());
        } else {
            webSocketFrame = null;
        }
        return webSocketFrame;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private io.netty.handler.codec.http.websocketx.WebSocketFrame frameToNetty(WebSocketFrame frame) {
        boolean bl = false;
        WebSocketFrame.Close close = null;
        if (frame instanceof WebSocketFrame.Binary) {
            WebSocketFrame.Binary binary = (WebSocketFrame.Binary)frame;
            return new BinaryWebSocketFrame(binary.isFinal(), 0, Unpooled.wrappedBuffer((byte[])((byte[])binary.bytes().toArray((ClassTag)ClassTag$.MODULE$.Byte()))));
        }
        if (frame instanceof WebSocketFrame.Text) {
            WebSocketFrame.Text text = (WebSocketFrame.Text)frame;
            return new TextWebSocketFrame(text.isFinal(), 0, text.text());
        }
        if (frame instanceof WebSocketFrame.Close) {
            bl = true;
            close = (WebSocketFrame.Close)frame;
            int status = close.status();
            Option<String> option = close.reason();
            if (option instanceof Some) {
                String text = (String)((Some)option).value();
                return new CloseWebSocketFrame(status, text);
            }
        }
        if (bl) {
            int status = close.status();
            Option<String> option = close.reason();
            if (None$.MODULE$.equals(option)) {
                return new CloseWebSocketFrame(status, null);
            }
        }
        if (WebSocketFrame$Ping$.MODULE$.equals(frame)) {
            return new PingWebSocketFrame();
        }
        if (WebSocketFrame$Pong$.MODULE$.equals(frame)) {
            return new PongWebSocketFrame();
        }
        if (!(frame instanceof WebSocketFrame.Continuation)) throw new MatchError((Object)frame);
        WebSocketFrame.Continuation continuation = (WebSocketFrame.Continuation)frame;
        return new ContinuationWebSocketFrame(continuation.isFinal(), 0, Unpooled.wrappedBuffer((byte[])((byte[])continuation.buffer().toArray((ClassTag)ClassTag$.MODULE$.Byte()))));
    }

    public WebSocketAppHandler(NettyRuntime zExec, SocketApp<Object> app, Object trace) {
        this.zExec = zExec;
        this.app = app;
        this.trace = trace;
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = true;
    }
}

