/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.TrustManagerFactory;
import scala.MatchError;
import zio.http.ClientSSLConfig;
import zio.http.ClientSSLConfig$Default$;

public final class ClientSSLConverter$ {
    public static final ClientSSLConverter$ MODULE$ = new ClientSSLConverter$();

    private SslContext trustStoreToSslContext(InputStream trustStoreStream, String trustStorePassword) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustStore.load(trustStoreStream, trustStorePassword.toCharArray());
        trustManagerFactory.init(trustStore);
        return SslContextBuilder.forClient().trustManager(trustManagerFactory).build();
    }

    private SslContext certToSslContext(InputStream certStream) {
        return SslContextBuilder.forClient().trustManager(certStream).build();
    }

    public SslContext toNettySSLContext(ClientSSLConfig sslConfig) {
        SslContext sslContext;
        if (ClientSSLConfig$Default$.MODULE$.equals(sslConfig)) {
            sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        } else if (sslConfig instanceof ClientSSLConfig.FromCertFile) {
            String certPath = ((ClientSSLConfig.FromCertFile)sslConfig).certPath();
            FileInputStream certStream = new FileInputStream(certPath);
            sslContext = this.certToSslContext(certStream);
        } else if (sslConfig instanceof ClientSSLConfig.FromCertResource) {
            String certPath = ((ClientSSLConfig.FromCertResource)sslConfig).certPath();
            InputStream certStream = this.getClass().getClassLoader().getResourceAsStream(certPath);
            sslContext = this.certToSslContext(certStream);
        } else if (sslConfig instanceof ClientSSLConfig.FromTrustStoreFile) {
            ClientSSLConfig.FromTrustStoreFile fromTrustStoreFile = (ClientSSLConfig.FromTrustStoreFile)sslConfig;
            String trustStorePath = fromTrustStoreFile.trustStorePath();
            String trustStorePassword = fromTrustStoreFile.trustStorePassword();
            FileInputStream trustStoreStream = new FileInputStream(trustStorePath);
            sslContext = this.trustStoreToSslContext(trustStoreStream, trustStorePassword);
        } else if (sslConfig instanceof ClientSSLConfig.FromTrustStoreResource) {
            ClientSSLConfig.FromTrustStoreResource fromTrustStoreResource = (ClientSSLConfig.FromTrustStoreResource)sslConfig;
            String trustStorePath = fromTrustStoreResource.trustStorePath();
            String trustStorePassword = fromTrustStoreResource.trustStorePassword();
            InputStream trustStoreStream = this.getClass().getClassLoader().getResourceAsStream(trustStorePath);
            sslContext = this.trustStoreToSslContext(trustStoreStream, trustStorePassword);
        } else {
            throw new MatchError((Object)sslConfig);
        }
        return sslContext;
    }

    private ClientSSLConverter$() {
    }
}

