/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit$;
import zio.Promise;
import zio.Queue;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$;
import zio.http.ChannelEvent$UserEvent$HandshakeComplete$;
import zio.http.ChannelEvent$UserEvent$HandshakeTimeout$;
import zio.http.WebSocketFrame;
import zio.http.WebSocketFrame$Binary$;
import zio.http.WebSocketFrame$Continuation$;
import zio.http.WebSocketFrame$Ping$;
import zio.http.WebSocketFrame$Pong$;
import zio.http.WebSocketFrame$Text$;
import zio.http.internal.ChannelState;
import zio.http.internal.ChannelState$Invalid$;
import zio.http.netty.NettyRuntime;

@ScalaSignature(bytes="\u0006\u0005\u0005=c!\u0002\t\u0012\u0005U9\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011I\u0002!\u0011!Q\u0001\nMB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"AQ\r\u0001B\u0001B\u0003-a\rC\u0003m\u0001\u0011\u0005Q\u000eC\u0004v\u0001\t\u0007I1\u0002<\t\ri\u0004\u0001\u0015!\u0003x\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA\"\u0001\u0011%\u0011Q\t\u0002\u0014/\u0016\u00147k\\2lKR\f\u0005\u000f\u001d%b]\u0012dWM\u001d\u0006\u0003%M\tQA\\3uifT!\u0001F\u000b\u0002\t!$H\u000f\u001d\u0006\u0002-\u0005\u0019!0[8\u0014\u0005\u0001A\u0002cA\r C5\t!D\u0003\u0002\u001c9\u000591\r[1o]\u0016d'B\u0001\n\u001e\u0015\u0005q\u0012AA5p\u0013\t\u0001#DA\u000eTS6\u0004H.Z\"iC:tW\r\\%oE>,h\u000e\u001a%b]\u0012dWM\u001d\t\u0003E)j\u0011a\t\u0006\u0003I\u0015\n!b^3cg>\u001c7.\u001a;y\u0015\t!bE\u0003\u0002(Q\u0005)1m\u001c3fG*\u0011\u0011\u0006H\u0001\bQ\u0006tG\r\\3s\u0013\tY3E\u0001\bXK\n\u001cvnY6fi\u001a\u0013\u0018-\\3\u0002\u000bi,\u00050Z2\u0004\u0001A\u0011q\u0006M\u0007\u0002#%\u0011\u0011'\u0005\u0002\r\u001d\u0016$H/\u001f*v]RLW.Z\u0001\u0006cV,W/\u001a\t\u0004iU:T\"A\u000b\n\u0005Y*\"!B)vKV,\u0007C\u0001\u001dC\u001d\tI\u0004I\u0004\u0002;\u007f9\u00111HP\u0007\u0002y)\u0011Q(L\u0001\u0007yI|w\u000e\u001e \n\u0003YI!\u0001F\u000b\n\u0005\u0005\u001b\u0012a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013QcV3c'>\u001c7.\u001a;DQ\u0006tg.\u001a7Fm\u0016tGO\u0003\u0002B'\u0005\u0011\u0002.\u00198eg\"\f7.Z\"p[BdW\r^3e!\u0011!t)S(\n\u0005!+\"a\u0002)s_6L7/\u001a\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\b\u001d>$\b.\u001b8h!\tQ\u0005+\u0003\u0002R\u0017\n9!i\\8mK\u0006t\u0017AC8o\u0007>l\u0007\u000f\\3uKB\u0019!\n\u0016,\n\u0005U[%AB(qi&|g\u000e\u0005\u00035\u000f^{\u0006C\u0001-]\u001d\tI6L\u0004\u0002<5&\tA*\u0003\u0002B\u0017&\u0011QL\u0018\u0002\n)\"\u0014xn^1cY\u0016T!!Q&\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\u001c\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0011\f'\u0001D\"iC:tW\r\\*uCR,\u0017!\u0002;sC\u000e,\u0007CA4j\u001d\tQ\u0004.\u0003\u0002B+%\u0011!n\u001b\u0002\u0006)J\f7-\u001a\u0006\u0003\u0003V\ta\u0001P5oSRtD#\u00028reN$HCA8q!\ty\u0003\u0001C\u0003f\r\u0001\u000fa\rC\u0003-\r\u0001\u0007a\u0006C\u00033\r\u0001\u00071\u0007C\u0003F\r\u0001\u0007a\tC\u0003S\r\u0001\u00071+A\u0006v]N\fg-Z\"mCN\u001cX#A<\u0011\u0005QB\u0018BA=\u0016\u0005\u0019)fn]1gK\u0006aQO\\:bM\u0016\u001cE.Y:tA\u0005AA-[:qCR\u001c\u0007\u000eF\u0002~\u0003\u0003\u0001\"A\u0013@\n\u0005}\\%\u0001B+oSRDq!a\u0001\n\u0001\u0004\t)!A\u0003fm\u0016tG\u000fE\u0003\u0002\b\u0005%\u0011%D\u0001\u0014\u0013\r\tYa\u0005\u0002\r\u0007\"\fgN\\3m\u000bZ,g\u000e^\u0001\rG\"\fgN\\3m%\u0016\fG\r\r\u000b\u0006{\u0006E\u00111\u0004\u0005\b\u0003'Q\u0001\u0019AA\u000b\u0003\r\u0019G\u000f\u001f\t\u00043\u0005]\u0011bAA\r5\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\bBBA\u000f\u0015\u0001\u0007\u0011%A\u0002ng\u001e\f\u0011c\u00195b]:,GNU3hSN$XM]3e)\ri\u00181\u0005\u0005\b\u0003'Y\u0001\u0019AA\u000b\u0003M\u0019\u0007.\u00198oK2,fN]3hSN$XM]3e)\ri\u0018\u0011\u0006\u0005\b\u0003'a\u0001\u0019AA\u000b\u0003=)\u0007pY3qi&|gnQ1vO\"$H#B?\u00020\u0005E\u0002bBA\n\u001b\u0001\u0007\u0011Q\u0003\u0005\u0007\u0003gi\u0001\u0019A,\u0002\u000b\r\fWo]3\u0002%U\u001cXM]#wK:$HK]5hO\u0016\u0014X\r\u001a\u000b\u0006{\u0006e\u00121\b\u0005\b\u0003'q\u0001\u0019AA\u000b\u0011\u001d\tiB\u0004a\u0001\u0003{\u00012ASA \u0013\r\t\te\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\u001d\u0019\u0014\u0018-\\3Ge>lg*\u001a;usR!\u0011qIA&!\u0011\t9!!\u0013\n\u0005-\u001a\u0002BBA'\u001f\u0001\u0007\u0011%\u0001\u0004k\rJ\fW.\u001a")
public final class WebSocketAppHandler
extends SimpleChannelInboundHandler<io.netty.handler.codec.http.websocketx.WebSocketFrame> {
    private final NettyRuntime zExec;
    private final Queue<ChannelEvent<WebSocketFrame>> queue;
    private final Promise<Nothing$, Object> handshakeCompleted;
    private final Option<Promise<Throwable, ChannelState>> onComplete;
    private final Object trace;
    private final Unsafe unsafeClass;
    private volatile boolean bitmap$init$0;

    private Unsafe unsafeClass() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: WebSocketAppHandler.scala: 44");
        }
        return this.unsafeClass;
    }

    private void dispatch(ChannelEvent<io.netty.handler.codec.http.websocketx.WebSocketFrame> event) {
        Boolean cfr_ignored_0 = (Boolean)this.zExec.unsafeRunSync(this.queue.offer(event.map((Function1 & Serializable)jFrame -> this.frameFromNetty((io.netty.handler.codec.http.websocketx.WebSocketFrame)jFrame)), this.trace), this.unsafeClass(), this.trace);
    }

    public void channelRead0(ChannelHandlerContext ctx, io.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        this.dispatch(ChannelEvent$.MODULE$.read(msg));
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.dispatch(ChannelEvent$.MODULE$.registered());
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.dispatch(ChannelEvent$.MODULE$.unregistered());
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            ((Promise)((Some)option).value()).unsafe().done((ZIO)Exit$.MODULE$.succeed((Object)ChannelState$Invalid$.MODULE$), this.unsafeClass());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.dispatch(ChannelEvent$.MODULE$.exceptionCaught(cause));
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            ((Promise)((Some)option).value()).unsafe().done((ZIO)Exit$.MODULE$.fail((Object)cause), this.unsafeClass());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof WebSocketServerProtocolHandler.HandshakeComplete ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE.equals(msg)) {
            this.handshakeCompleted.unsafe().succeed((Object)BoxesRunTime.boxToBoolean((boolean)true), this.trace, this.unsafeClass());
            this.dispatch(ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeComplete$.MODULE$));
            return;
        }
        if (WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg) ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg)) {
            this.handshakeCompleted.unsafe().succeed((Object)BoxesRunTime.boxToBoolean((boolean)false), this.trace, this.unsafeClass());
            this.dispatch(ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeTimeout$.MODULE$));
            return;
        }
        super.userEventTriggered(ctx, msg);
    }

    private WebSocketFrame frameFromNetty(io.netty.handler.codec.http.websocketx.WebSocketFrame jFrame) {
        if (jFrame instanceof PingWebSocketFrame) {
            return WebSocketFrame$Ping$.MODULE$;
        }
        if (jFrame instanceof PongWebSocketFrame) {
            return WebSocketFrame$Pong$.MODULE$;
        }
        if (jFrame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)jFrame;
            return WebSocketFrame$Binary$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)binaryWebSocketFrame.content())), binaryWebSocketFrame.isFinalFragment());
        }
        if (jFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)jFrame;
            return WebSocketFrame$Text$.MODULE$.apply(textWebSocketFrame.text(), textWebSocketFrame.isFinalFragment());
        }
        if (jFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)jFrame;
            return new WebSocketFrame.Close(closeWebSocketFrame.statusCode(), (Option<String>)Option$.MODULE$.apply((Object)closeWebSocketFrame.reasonText()));
        }
        if (jFrame instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)jFrame;
            return WebSocketFrame$Continuation$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)continuationWebSocketFrame.content())), continuationWebSocketFrame.isFinalFragment());
        }
        return null;
    }

    public WebSocketAppHandler(NettyRuntime zExec, Queue<ChannelEvent<WebSocketFrame>> queue, Promise<Nothing$, Object> handshakeCompleted, Option<Promise<Throwable, ChannelState>> onComplete, Object trace) {
        this.zExec = zExec;
        this.queue = queue;
        this.handshakeCompleted = handshakeCompleted;
        this.onComplete = onComplete;
        this.trace = trace;
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = true;
    }
}

