/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Exit;
import zio.Exit$;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ErrorResponseConfig$;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyResponseEncoder$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0005\r=b!B\u001c9\u0005z\u0002\u0005\u0002\u00034\u0001\u0005+\u0007I\u0011A4\t\u0011=\u0004!\u0011#Q\u0001\n!D\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\tu\u0002\u0011\t\u0012)A\u0005e\"A1\u0010\u0001B\u0001B\u0003-A\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u0013\u0005]\u0001A1A\u0005\f\u0005e\u0001\u0002CA\u0012\u0001\u0001\u0006I!a\u0007\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013%\u0011q\u0005\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0004C\u0006\u0002J\u0001\u0001\r\u0011!Q!\n\u0005%\u0002bCA&\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bB1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002Z!Y\u0011Q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA(\u0011%\ty\u0006\u0001b\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA2\u0011%\ti\b\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BAA\u0011%\tI\t\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BAA\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!%\u0001\t\u0013\ty\tC\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u0011Q\u0014\u0001!\u0002\u0013\t9\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\tI\u0010\u0001C\u0005\u0003wDqA!\u0003\u0001\t\u0013\u0011Y\u0001C\u0004\u0003\u001a\u0001!IAa\u0007\t\u000f\t5\u0002\u0001\"\u0003\u00030!9!\u0011\t\u0001\u0005\n\t\r\u0003\"\u0003B$\u0001\u0005\u0005I\u0011\u0001B%\u0011%\u0011\u0019\u0006AI\u0001\n\u0003\u0011)\u0006C\u0005\u0003l\u0001\t\n\u0011\"\u0001\u0003n!I!\u0011\u000f\u0001\u0002\u0002\u0013\u0005#1\u000f\u0005\n\u0005\u0003\u0003\u0011\u0011!C\u0001\u0005\u0007C\u0011Ba#\u0001\u0003\u0003%\tA!$\t\u0013\tE\u0005!!A\u0005B\tM\u0005\"\u0003BQ\u0001\u0005\u0005I\u0011\u0001BR\u0011%\u00119\u000bAA\u0001\n\u0003\u0012I\u000bC\u0005\u0003.\u0002\t\t\u0011\"\u0011\u00030\"I!\u0011\u0017\u0001\u0002\u0002\u0013\u0005#1\u0017\u0005\n\u0005k\u0003\u0011\u0011!C!\u0005o;qAa69\u0011\u0003\u0011IN\u0002\u00048q!\u0005!1\u001c\u0005\b\u0003\u0013\u0001D\u0011\u0001Bv\u0011%\u0011i\u000f\rb\u0001\n\u0003\u0011y\u000f\u0003\u0005\u0004\bA\u0002\u000b\u0011\u0002By\u0011%\u0019I\u0001MA\u0001\n\u0003\u001bY\u0001C\u0005\u0004\u0016A\n\t\u0011\"!\u0004\u0018!I1Q\u0005\u0019\u0002\u0002\u0013%1q\u0005\u0002\u0015'\u0016\u0014h/\u001a:J]\n|WO\u001c3IC:$G.\u001a:\u000b\u0005eR\u0014AB:feZ,'O\u0003\u0002<y\u0005)a.\u001a;us*\u0011QHP\u0001\u0005QR$\bOC\u0001@\u0003\rQ\u0018n\\\n\u0005\u0001\u0005\u001b\u0016\fE\u0002C\u0011*k\u0011a\u0011\u0006\u0003\t\u0016\u000bqa\u00195b]:,GN\u0003\u0002<\r*\tq)\u0001\u0002j_&\u0011\u0011j\u0011\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005-\u000bV\"\u0001'\u000b\u0005uj%B\u0001(P\u0003\u0015\u0019w\u000eZ3d\u0015\t\u0001V)A\u0004iC:$G.\u001a:\n\u0005Ic%A\u0003%uiB|%M[3diB\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n9\u0001K]8ek\u000e$\bC\u0001.d\u001d\tY\u0016M\u0004\u0002]A6\tQL\u0003\u0002_?\u00061AH]8piz\u001a\u0001!C\u0001W\u0013\t\u0011W+A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'\u0001D*fe&\fG.\u001b>bE2,'B\u00012V\u0003\u0019\t\u0007\u000f\u001d*fMV\t\u0001\u000e\u0005\u0002jY:\u0011!n[\u0007\u0002q%\u0011!\rO\u0005\u0003[:\u0014a!\u00119q%\u00164'B\u000129\u0003\u001d\t\u0007\u000f\u001d*fM\u0002\naaY8oM&<W#\u0001:\u0011\u0005M<hB\u0001;v\u001b\u0005a\u0014B\u0001<=\u0003\u0019\u0019VM\u001d<fe&\u0011\u00010\u001f\u0002\u0007\u0007>tg-[4\u000b\u0005Yd\u0014aB2p]\u001aLw\rI\u0001\u0006iJ\f7-\u001a\t\u0004{\u0006\rab\u0001@\u0002\u00029\u0011Al`\u0005\u0002\u007f%\u0011!MP\u0005\u0005\u0003\u000b\t9AA\u0003Ue\u0006\u001cWM\u0003\u0002c}\u00051A(\u001b8jiz\"b!!\u0004\u0002\u0014\u0005UA\u0003BA\b\u0003#\u0001\"A\u001b\u0001\t\u000bm4\u00019\u0001?\t\u000b\u00194\u0001\u0019\u00015\t\u000bA4\u0001\u0019\u0001:\u0002\rUt7/\u00194f+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005}Q\"\u0001 \n\u0007\u0005\u0005bH\u0001\u0004V]N\fg-Z\u0001\bk:\u001c\u0018MZ3!\u0003\r\t\u0007\u000f]\u000b\u0003\u0003S\u0001r\u0001^A\u0016\u0003_\t)$C\u0002\u0002.q\u0012aAU8vi\u0016\u001c\bc\u0001+\u00022%\u0019\u00111G+\u0003\u0007\u0005s\u0017\u0010E\u0002u\u0003oI1!!\u000f=\u0005!\u0011Vm\u001d9p]N,\u0017aB1qa~#S-\u001d\u000b\u0005\u0003\u007f\t)\u0005E\u0002U\u0003\u0003J1!a\u0011V\u0005\u0011)f.\u001b;\t\u0013\u0005\u001d#\"!AA\u0002\u0005%\u0012a\u0001=%c\u0005!\u0011\r\u001d9!\u0003\u001d\u0011XO\u001c;j[\u0016,\"!a\u0014\u0011\t\u0005E\u00131K\u0007\u0002u%\u0019\u0011Q\u000b\u001e\u0003\u00199+G\u000f^=Sk:$\u0018.\\3\u0002\u0017I,h\u000e^5nK~#S-\u001d\u000b\u0005\u0003\u007f\tY\u0006C\u0005\u0002H5\t\t\u00111\u0001\u0002P\u0005A!/\u001e8uS6,\u0007%\u0001\tj]\u001ac\u0017n\u001a5u%\u0016\fX/Z:ugV\u0011\u00111\r\t\u0005\u0003K\n9(\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0019\tGo\\7jG*!\u0011QNA8\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003c\n\u0019(\u0001\u0003vi&d'BAA;\u0003\u0011Q\u0017M^1\n\t\u0005e\u0014q\r\u0002\n\u0019>tw-\u00113eKJ\f\u0011#\u001b8GY&<\u0007\u000e\u001e*fcV,7\u000f^:!\u00039\u0011X-\u00193DY&,g\u000e^\"feR,\"!!!\u0011\u0007Q\u000b\u0019)C\u0002\u0002\u0006V\u0013qAQ8pY\u0016\fg.A\bsK\u0006$7\t\\5f]R\u001cUM\u001d;!\u0003E\tgo\\5e\u0007RD8k^5uG\"LgnZ\u0001\u0013CZ|\u0017\u000eZ\"uqN;\u0018\u000e^2iS:<\u0007%\u0001\u0006sK\u001a\u0014Xm\u001d5BaB$\"!a\u0010\u0002\u0019\u0015t7/\u001e:f\u0011\u0006\u001c\u0018\t\u001d9\u0002\u001dI,G.Z1tKJ+\u0017/^3tiV\u0011\u0011q\u0013\t\u0006)\u0006e\u0015qH\u0005\u0004\u00037+&!\u0003$v]\u000e$\u0018n\u001c81\u0003=\u0011X\r\\3bg\u0016\u0014V-];fgR\u0004\u0013\u0001D2iC:tW\r\u001c*fC\u0012\u0004DCBA \u0003G\u000bi\u000bC\u0004\u0002&f\u0001\r!a*\u0002\u0007\r$\b\u0010E\u0002C\u0003SK1!a+D\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDa!a,\u001a\u0001\u0004Q\u0015aA7tO\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u0002@\u0005U\u0016q\u0017\u0005\b\u0003KS\u0002\u0019AAT\u0011\u001d\tIL\u0007a\u0001\u0003w\u000bQaY1vg\u0016\u00042AWA_\u0013\r\ty,\u001a\u0002\n)\"\u0014xn^1cY\u0016\f1#\u00193e\u0003NLhn\u0019\"pIfD\u0015M\u001c3mKJ$B!!2\u0002LB!\u0011\u0011KAd\u0013\r\tIM\u000f\u0002\u0010\u0003NLhn\u0019\"pIf\u0014V-\u00193fe\"9\u0011QU\u000eA\u0002\u0005\u001d\u0016\u0001E1ui\u0016l\u0007\u000f\u001e$bgR<&/\u001b;f)\u0019\t\t)!5\u0002T\"9\u0011Q\u0015\u000fA\u0002\u0005\u001d\u0006bBAk9\u0001\u0007\u0011QG\u0001\te\u0016\u001c\bo\u001c8tK\u0006\u0001\u0012\r\u001e;f[B$h)\u001e7m/JLG/\u001a\u000b\u000b\u00037\fI/a;\u0002n\u0006=\b#B?\u0002^\u0006\u0005\u0018\u0002BAp\u0003\u000f\u0011A\u0001V1tWB)A+a9\u0002h&\u0019\u0011Q]+\u0003\r=\u0003H/[8o!\u0015i\u0018Q\\A \u0011\u001d\t)+\ba\u0001\u0003OCq!a\u0013\u001e\u0001\u0004\ty\u0005C\u0004\u0002Vv\u0001\r!!\u000e\t\u000f\u0005EX\u00041\u0001\u0002t\u00069!/Z9vKN$\bc\u0001;\u0002v&\u0019\u0011q\u001f\u001f\u0003\u000fI+\u0017/^3ti\u0006)\u0012\r\u001e;f[B$\u0018*\\7fI&\fG/Z,sSR,GCBAA\u0003{\fy\u0010C\u0004\u0002&z\u0001\r!a*\t\u000f\t\u0005a\u00041\u0001\u0003\u0004\u0005!Q\r_5u!)\tiB!\u0002\u00020\u0005U\u0012QG\u0005\u0004\u0005\u000fq$a\u0001.J\u001f\u0006qQ.Y6f5&|'+Z9vKN$HCBAz\u0005\u001b\u0011y\u0001C\u0004\u0002&~\u0001\r!a*\t\u000f\tEq\u00041\u0001\u0003\u0014\u0005Aa.\u001a;usJ+\u0017\u000fE\u0002L\u0005+I1Aa\u0006M\u0005-AE\u000f\u001e9SKF,Xm\u001d;\u0002%U\u0004xM]1eKR{w+\u001a2T_\u000e\\W\r\u001e\u000b\u000b\u0003O\u0014iBa\b\u0003\"\t-\u0002bBASA\u0001\u0007\u0011q\u0015\u0005\b\u0003c\u0004\u0003\u0019AAz\u0011\u001d\u0011\u0019\u0003\ta\u0001\u0005K\tAb^3c'>\u001c7.\u001a;BaB\u0004R\u0001\u001eB\u0014\u0003_I1A!\u000b=\u000519VMY*pG.,G/\u00119q\u0011\u001d\tY\u0005\ta\u0001\u0003\u001f\nQb\u001e:ji\u0016\u0014Vm\u001d9p]N,GC\u0003B\u0019\u0005o\u0011IDa\u000f\u0003>Q!\u0011q\bB\u001a\u0011\u001d\u0011)$\ta\u0001\u0003/\u000bq!\u001a8tkJ,G\rC\u0004\u0002&\u0006\u0002\r!a*\t\u000f\u0005-\u0013\u00051\u0001\u0002P!9!\u0011A\u0011A\u0002\t\r\u0001b\u0002B C\u0001\u0007\u00111_\u0001\u0004e\u0016\f\u0018\u0001G<ji\"$UMZ1vYR,%O]8s%\u0016\u001c\bo\u001c8tKR!\u0011Q\u0007B#\u0011\u001d\tIL\ta\u0001\u0003w\u000bAaY8qsR1!1\nB(\u0005#\"B!a\u0004\u0003N!)1p\ta\u0002y\"9am\tI\u0001\u0002\u0004A\u0007b\u00029$!\u0003\u0005\rA]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119FK\u0002i\u00053Z#Aa\u0017\u0011\t\tu#qM\u0007\u0003\u0005?RAA!\u0019\u0003d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005K*\u0016AC1o]>$\u0018\r^5p]&!!\u0011\u000eB0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yGK\u0002s\u00053\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B;!\u0011\u00119H! \u000e\u0005\te$\u0002\u0002B>\u0003g\nA\u0001\\1oO&!!q\u0010B=\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0011\t\u0004)\n\u001d\u0015b\u0001BE+\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q\u0006BH\u0011%\t9\u0005KA\u0001\u0002\u0004\u0011))A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\n\u0005\u0004\u0003\u0018\nu\u0015qF\u0007\u0003\u00053S1Aa'V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005?\u0013IJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAA\u0005KC\u0011\"a\u0012+\u0003\u0003\u0005\r!a\f\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005k\u0012Y\u000bC\u0005\u0002H-\n\t\u00111\u0001\u0003\u0006\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u0006\u0006AAo\\*ue&tw\r\u0006\u0002\u0003v\u00051Q-];bYN$B!!!\u0003:\"I\u0011q\t\u0018\u0002\u0002\u0003\u0007\u0011q\u0006\u0015\u0004\u0001\tu\u0006\u0003\u0002B`\u0005#tAA!1\u0003N:!!1\u0019Bf\u001d\u0011\u0011)M!3\u000f\u0007q\u00139-C\u0001H\u0013\tYd)\u0003\u0002E\u000b&\u0019!qZ\"\u0002\u001d\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe&!!1\u001bBk\u0005!\u0019\u0006.\u0019:bE2,'b\u0001Bh\u0007\u0006!2+\u001a:wKJLeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"A\u001b\u0019\u0014\u000bA\u0012iNa9\u0011\u0007Q\u0013y.C\u0002\u0003bV\u0013a!\u00118z%\u00164\u0007\u0003\u0002Bs\u0005Sl!Aa:\u000b\u0007\u001d\u000b\u0019(C\u0002e\u0005O$\"A!7\u0002\t1Lg/Z\u000b\u0003\u0005c\u0004\"\"!\b\u0003t\n]8\u0011AA\b\u0013\r\u0011)P\u0010\u0002\u000752\u000b\u00170\u001a:\u0011\u000bu\u0014I\u0010\u001b:\n\t\tm(Q \u0002\u0005I\u0005l\u0007/C\u0002\u0003\u0000z\u0012a#\u00138uKJ\u001cXm\u0019;j_:$\u0016\u0010]3D_6\u0004\u0018\r\u001e\t\u0004)\u000e\r\u0011bAB\u0003+\n9aj\u001c;iS:<\u0017!\u00027jm\u0016\u0004\u0013!B1qa2LHCBB\u0007\u0007#\u0019\u0019\u0002\u0006\u0003\u0002\u0010\r=\u0001\"B>5\u0001\ba\b\"\u000245\u0001\u0004A\u0007\"\u000295\u0001\u0004\u0011\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u00073\u0019\t\u0003E\u0003U\u0003G\u001cY\u0002E\u0003U\u0007;A'/C\u0002\u0004 U\u0013a\u0001V;qY\u0016\u0014\u0004\"CB\u0012k\u0005\u0005\t\u0019AA\b\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007S\u0001BAa\u001e\u0004,%!1Q\u0006B=\u0005\u0019y%M[3di\u0002")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
Serializable {
    private final AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Routes<Object, Response> app;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;
    private final boolean avoidCtxSwitching;
    private final Function0<BoxedUnit> releaseRequest;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Server.Config>> unapply(ServerInboundHandler x$0) {
        return ServerInboundHandler$.MODULE$.unapply(x$0);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return ServerInboundHandler$.MODULE$.apply(appRef, config, trace);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    private Unsafe unsafe() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 49");
        }
        return this.unsafe;
    }

    private Routes<Object, Response> app() {
        return this.app;
    }

    private void app_$eq(Routes<Object, Response> x$1) {
        this.app = x$1;
    }

    private NettyRuntime runtime() {
        return this.runtime;
    }

    private void runtime_$eq(NettyRuntime x$1) {
        this.runtime = x$1;
    }

    public LongAdder inFlightRequests() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 54");
        }
        return this.inFlightRequests;
    }

    private boolean readClientCert() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 55");
        }
        return this.readClientCert;
    }

    private boolean avoidCtxSwitching() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 56");
        }
        return this.avoidCtxSwitching;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.app_$eq((Routes)pair._1());
        this.runtime_$eq(new NettyRuntime((Runtime<Object>)((Runtime)pair._2())));
    }

    private void ensureHasApp() {
        if (this.runtime() == null) {
            this.refreshApp();
            return;
        }
    }

    private Function0<BoxedUnit> releaseRequest() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 71");
        }
        return this.releaseRequest;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.inFlightRequests().increment();
            this.ensureHasApp();
            try {
                if (httpRequest.decoderResult().isFailure()) {
                    Throwable throwable = httpRequest.decoderResult().cause();
                    this.attemptFastWrite(ctx, Response$.MODULE$.fromThrowable(throwable, this.runtime().getRef(ErrorResponseConfig$.MODULE$.configRef())));
                    this.releaseRequest().apply$mcV$sp();
                } else {
                    Request req = this.makeZioRequest(ctx, httpRequest);
                    ZIO<Object, Response, Response> exit = this.app().apply(req, (.less.colon.less<Response, Response>)$less$colon$less$.MODULE$.refl());
                    if (this.attemptImmediateWrite(ctx, exit)) {
                        this.releaseRequest().apply$mcV$sp();
                    } else {
                        this.writeResponse(ctx, this.runtime(), exit, req, this.releaseRequest());
                    }
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)httpRequest);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String msg;
        if (cause instanceof IOException && (msg = ((IOException)cause).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.runtime() != null && this.config().logWarningOnFatalError()) {
            this.runtime().unsafeRunSync(ZIO$.MODULE$.logWarningCause((Function0 & Serializable)() -> "Fatal exception in Netty", (Function0 & Serializable)() -> Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()), this.trace), this.unsafe(), this.trace);
        }
        if (cause instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            try {
                return this.fastEncode$1(response, unsafeBytes.unsafeAsArray(this.unsafe()), ctx);
            }
            catch (Throwable throwable) {
                if (NonFatal$.MODULE$.apply(throwable)) {
                    return this.fastEncode$1(this.withDefaultErrorResponse(throwable), Array$.MODULE$.emptyByteArray(), ctx);
                }
                throw throwable;
            }
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, Request request) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> socketApp = ((Body.WebsocketBody)body).socketApp();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (status != null && status.equals(status$SwitchingProtocols$)) {
                return this.upgradeToWebSocket(ctx, request, socketApp, runtime).as((Function0 & Serializable)() -> None$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(response, this.unsafe());
            if (!(jResponse instanceof FullHttpResponse)) {
                Some some;
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (string == null) {
                            some = None$.MODULE$;
                            break;
                        }
                    }
                    default: {
                        some = new Some((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(string))));
                    }
                }
                Some contentLength = some;
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, $this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, ZIO<Object, Response, Response> exit) {
        Response response;
        if (exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null) {
            return this.attemptFastWrite(ctx, response);
        }
        return false;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version$Http_1_0$ protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            none$2 = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates()));
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<Object> contentTypeHeader = headers.get(Header$ContentType$.MODULE$);
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            Body x$1 = NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content(), contentTypeHeader);
            Method x$3 = Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method());
            URL x$4 = (URL)URL$.MODULE$.decode(fullHttpRequest.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty());
            return new Request(protocolVersion, x$3, x$4, headers, x$1, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.length()));
        AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
        Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable)async -> {
            handler.connect(async);
            return BoxedUnit.UNIT;
        }, (Option<Object>)knownContentLength, contentTypeHeader);
        Method x$10 = Conversions$.MODULE$.methodFromNetty(nettyReq.method());
        URL x$11 = (URL)URL$.MODULE$.decode(nettyReq.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty());
        return new Request(protocolVersion, x$10, x$11, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, Request request, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        return Promise$.MODULE$.make(this.trace).flatMap((Function1 & Serializable)handshakeCompleted -> Queue$.MODULE$.unbounded($this.trace).tap((Function1 & Serializable)queue -> ZIO$.MODULE$.suspend((Function0 & Serializable)() -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx.channel());
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted);
            return webSocketApp.handler().runZIO(webSocketChannel).ignoreLogged($this.trace).forkDaemon($this.trace);
        }, $this.trace), $this.trace).flatMap((Function1 & Serializable)queue -> ZIO$.MODULE$.attempt((Function0 & Serializable)() -> {
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse((Function0 & Serializable)() -> this.config().webSocketConfig())).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, $this.trace));
            DefaultFullHttpRequest jReq = new DefaultFullHttpRequest(Conversions$.MODULE$.versionToNetty(request.version()), Conversions$.MODULE$.methodToNetty(request.method()), Conversions$.MODULE$.urlToNetty(request.url()));
            jReq.headers().setAll(Conversions$.MODULE$.headersToNetty(request.allHeaders()));
            return ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)jReq));
        }, $this.trace).map((Function1 & Serializable)x$6 -> {
            ServerInboundHandler.$anonfun$upgradeToWebSocket$8(x$6);
            return BoxedUnit.UNIT;
        }, $this.trace), $this.trace), this.trace);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Object, Response, Response> exit, Request req, Function0<BoxedUnit> ensured) {
        ZIO program = exit.foldCauseZIO((Function1 & Serializable)x$7 -> {
            boolean bl = false;
            Right right = null;
            Either either = x$7.failureOrCause();
            if (either instanceof Left) {
                Response resp = (Response)((Left)either).value();
                return this.writeResponse$1(resp, ctx, runtime, req);
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                if (((Cause)right.value()).isInterruptedOnly()) {
                    return this.closeChannel$1(ctx);
                }
            }
            if (bl) {
                Cause c = (Cause)right.value();
                return this.writeResponse$1(this.withDefaultErrorResponse((Throwable)new FiberFailure(c)), ctx, runtime, req);
            }
            throw new MatchError((Object)either);
        }, (Function1 & Serializable)response -> this.writeResponse$1((Response)response, ctx, runtime, req), this.trace);
        runtime.run(ctx, ensured, this.avoidCtxSwitching(), (ZIO<Object, Throwable, Object>)program, this.unsafe(), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public String productElementName(int x$1) {
        switch (x$1) {
            case 0: {
                return "appRef";
            }
            case 1: {
                return "config";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof ServerInboundHandler)) break block3;
                ServerInboundHandler serverInboundHandler = (ServerInboundHandler)x$1;
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
                if (atomicReference != null ? !atomicReference.equals(atomicReference2) : atomicReference2 != null) break block3;
                Server.Config config = this.config();
                Server.Config config2 = serverInboundHandler.config();
                if (config != null ? !((Object)config).equals(config2) : config2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final boolean fastEncode$1(Response response, byte[] bytes, ChannelHandlerContext ctx$1) {
        FullHttpResponse djResponse = NettyResponseEncoder$.MODULE$.fastEncode(response, bytes, this.unsafe()).retainedDuplicate();
        ctx$1.writeAndFlush((Object)djResponse, ctx$1.voidPromise());
        return true;
    }

    public static final /* synthetic */ void $anonfun$upgradeToWebSocket$8(Future x$6) {
    }

    private final ZIO closeChannel$1(ChannelHandlerContext ctx$4) {
        return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx$4.channel().close(), this.trace);
    }

    private final ZIO writeResponse$1(Response response, ChannelHandlerContext ctx$4, NettyRuntime runtime$2, Request req$1) {
        if (this.attemptFastWrite(ctx$4, response)) {
            return Exit$.MODULE$.unit();
        }
        return this.attemptFullWrite(ctx$4, runtime$2, response, req$1).foldCauseZIO((Function1 & Serializable)cause -> {
            this.attemptFastWrite(ctx$4, this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
            return Exit$.MODULE$.unit();
        }, (Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return Exit$.MODULE$.unit();
            }
            if (x0$1 instanceof Some) {
                return ((ZIO)((Some)x0$1).value()).orElse((Function0 & Serializable)() -> this.closeChannel$1(ctx$4), CanFail$.MODULE$.canFail(), $this.trace);
            }
            throw new MatchError(x0$1);
        }, this.trace);
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.inFlightRequests = new LongAdder();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.includeClientCert()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.avoidCtxSwitching = config.avoidContextSwitching();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.releaseRequest = (JFunction0.mcV.sp & Serializable)() -> this.inFlightRequests().decrement();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

