/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import java.time.Duration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.control.NonFatal$;
import zio.CanFail;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit;
import zio.Exit$;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.StackTrace;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.Zippable;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Charsets$;
import zio.http.Handler;
import zio.http.Handler$FromFunctionHandler$;
import zio.http.Handler$FromFunctionZIO$;
import zio.http.HandlerAspect;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.HttpApp;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Method;
import zio.http.Path;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$MethodNotAllowed$;
import zio.http.Status$NotFound$;
import zio.http.Status$Ok$;
import zio.http.Status$RequestEntityTooLarge$;
import zio.http.Status$RequestTimeout$;
import zio.http.ToHandler;
import zio.http.WebSocketApp;
import zio.http.WebSocketApp$;
import zio.http.WebSocketFrame;
import zio.http.internal.HeaderModifier;
import zio.http.template.Html;
import zio.http.template.Template$;
import zio.package;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Handler$ {
    public static final Handler$ MODULE$ = new Handler$();
    private static final Handler<Object, Nothing$, Object, BoxedUnit> unit = MODULE$.fromExit((Function0 & Serializable)() -> Exit$.MODULE$.unit());
    private static volatile byte bitmap$init$0 = (byte)(bitmap$init$0 | 1);

    public Handler<Object, Throwable, Object, Chunk<Object>> asChunkBounded(Request request, int limit, Object trace) {
        return this.fromZIO((Function0 & Serializable)() -> request.body().asStream(trace).chunks(trace).runFoldZIO((Function0 & Serializable)() -> Chunk$.MODULE$.empty(), (Function2 & Serializable)(x0$1, x1$1) -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> x0$1.$plus$plus(x1$1), trace).filterOrFail((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)Handler$.$anonfun$asChunkBounded$5(limit, x$32)), (Function0 & Serializable)() -> new Exception("Too large input"), trace), trace));
    }

    public <Out> Handler<Object, Throwable, Object, Out> attempt(Function0<Out> out) {
        return this.fromExit((Function0 & Serializable)() -> {
            try {
                return Exit$.MODULE$.succeed(out.apply());
            }
            catch (Throwable throwable) {
                Option option;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable cause = (Throwable)option.get();
                    return Exit$.MODULE$.fail((Object)cause);
                }
                throw throwable;
            }
        });
    }

    public Handler<Object, Nothing$, Object, Response> badRequest() {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$BadRequest$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, Response> badRequest(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$BadRequest$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Object, Nothing$> die(Function0<Throwable> failure) {
        return this.fromExit((Function0 & Serializable)() -> Exit$.MODULE$.die((Throwable)failure.apply()));
    }

    public Handler<Object, Nothing$, Object, Nothing$> dieMessage(Function0<String> message) {
        return this.die((Function0<Throwable>)(Function0 & Serializable)() -> new RuntimeException((String)message.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status) {
        return this.response((Function0<Response>)(Function0 & Serializable)() -> Response$.MODULE$.error((Status.Error)status.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> error(Function0<Status.Error> status, Function0<String> message) {
        return this.response((Function0<Response>)(Function0 & Serializable)() -> Response$.MODULE$.error((Status.Error)status.apply(), (String)message.apply()));
    }

    public <Err> Handler<Object, Err, Object, Nothing$> fail(Function0<Err> err) {
        return this.fromExit((Function0 & Serializable)() -> Exit$.MODULE$.fail(err.apply()));
    }

    public <Err> Handler<Object, Err, Object, Nothing$> failCause(Function0<Cause<Err>> cause) {
        return this.fromExit((Function0 & Serializable)() -> Exit$.MODULE$.failCause((Cause)cause.apply()));
    }

    public <R, Err, In, Out> Handler<R, Err, In, Out> firstSuccessOf(NonEmptyChunk<Handler<R, Err, In, Out>> handlers, Function1<Cause<Err>, Object> isRecoverable, Object trace) {
        return (Handler)((Chunk)NonEmptyChunk$.MODULE$.toChunk(handlers).tail()).foldLeft(NonEmptyChunk$.MODULE$.toChunk(handlers).head(), (Function2 & Serializable)(acc, handler) -> acc.catchAllCause((Function1 & Serializable)cause -> {
            if (BoxesRunTime.unboxToBoolean((Object)isRecoverable.apply(cause))) {
                return handler;
            }
            return MODULE$.failCause((Function0 & Serializable)() -> cause);
        }, trace));
    }

    public <R, Err, In, Out> Function1<Cause<Err>, Object> firstSuccessOf$default$2() {
        return (Function1 & Serializable)cause -> BoxesRunTime.boxToBoolean((boolean)Handler$.$anonfun$firstSuccessOf$default$2$1(cause));
    }

    public Handler<Object, Nothing$, Object, Response> forbidden() {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$Forbidden$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, Response> forbidden(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$Forbidden$.MODULE$, message);
    }

    public <H> Handler<Object, Object, Object, Object> from(Function0<H> handler, ToHandler<H> h) {
        return h.toHandler(handler);
    }

    public Handler<Object, Nothing$, Object, Response> fromBody(Function0<Body> body) {
        return this.response((Function0<Response>)(Function0 & Serializable)() -> {
            Body x$1 = (Body)body.apply();
            Status x$2 = Response$.MODULE$.apply$default$1();
            Headers x$3 = Response$.MODULE$.apply$default$2();
            return new Response(x$2, x$3, x$1);
        });
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromEither(Function0<Either<Err, Out>> either) {
        return (Handler)((Either)either.apply()).fold((Function1 & Serializable)x$33 -> MODULE$.fail((Function0 & Serializable)() -> x$33), (Function1 & Serializable)x$34 -> MODULE$.succeed((Function0 & Serializable)() -> x$34));
    }

    public <Err, Out> Handler<Object, Err, Object, Out> fromExit(Function0<Exit<Err, Out>> exit) {
        return new Handler<Object, Err, Object, Out>(exit){
            private final Function0 exit$1;

            public <Env1, Ctx, In1> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, BoxedUnit> aspect, .less.colon.less<In1, Request> in, .less.colon.less<Out, Response> out, .less.colon.less<Err, Response> err) {
                return Handler.$at$at$((Handler)this, aspect, in, out, err);
            }

            public <Env1, Ctx, In1> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, Ctx> aspect, Zippable<Ctx, Request> zippable, .less.colon.less<Out, Response> res, Object trace) {
                return Handler.$at$at$((Handler)this, aspect, zippable, res, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $greater$greater$eq(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.$greater$greater$eq$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> $greater$greater$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$greater$greater$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$less$less(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$less$less$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $less$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> $less$times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$times(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$times$greater$(this, that, trace);
            }

            public final <Err1, Out1> Handler<Object, Err1, Object, Out1> absolve(.less.colon.less<Out, Either<Err1, Out1>> ev, Object trace) {
                return Handler.absolve$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> andThen(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.andThen$(this, that, trace);
            }

            public final <Out1> Handler<Object, Err, Object, Out1> as(Out1 out, Object trace) {
                return Handler.as$(this, out, trace);
            }

            public final <R2> Handler<R2, Err, Object, Out> asEnvType(.less.colon.less<R2, Object> ev) {
                return Handler.asEnvType$(this, ev);
            }

            public final <Err2> Handler<Object, Err2, Object, Out> asErrorType(.less.colon.less<Err, Err2> ev) {
                return Handler.asErrorType$(this, ev);
            }

            public final <In2> Handler<Object, Err, In2, Out> asInType(.less.colon.less<In2, Object> ev) {
                return Handler.asInType$(this, ev);
            }

            public final <Out2> Handler<Object, Err, Object, Out2> asOutType(.less.colon.less<Out, Out2> ev) {
                return Handler.asOutType$(this, ev);
            }

            public final Handler<Object, Err, Object, Body> body(.less.colon.less<Out, Response> ev, Object trace) {
                return Handler.body$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAll(Function1<Err, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAll$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllCause(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllCause$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllDefect(Function1<Throwable, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllDefect$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSome(PartialFunction<Err, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSome$(this, pf, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSomeDefect(PartialFunction<Throwable, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSomeDefect$(this, pf, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> compose(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.compose$(this, that, trace);
            }

            public final <In1> Handler<Object, Err, In1, Out> contramap(Function1<In1, Object> f) {
                return Handler.contramap$(this, f);
            }

            public final <R1, Err1, In1> Handler<R1, Err1, In1, Out> contramapZIO(Function1<In1, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.contramapZIO$(this, f, trace);
            }

            public final <In1> Handler<Object, Err, Object, Out> contraFlatMap() {
                return Handler.contraFlatMap$(this);
            }

            public final Handler<Object, Err, Object, Out> delay(Duration duration, Object trace) {
                return Handler.delay$(this, duration, trace);
            }

            public final Handler<Object, Err, Object, Out> delayAfter(Duration duration, Object trace) {
                return Handler.delayAfter$(this, duration, trace);
            }

            public final Handler<Object, Err, Object, Out> delayBefore(Duration duration, Object trace) {
                return Handler.delayBefore$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, Object, Either<Err, Out>> either(CanFail<Err> ev, Object trace) {
                return Handler.either$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatten(.less.colon.less<Out, Handler<R1, Err1, In1, Out1>> ev, Object trace) {
                return Handler.flatten$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatMap(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.flatMap$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldCauseHandler(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldCauseHandler$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldHandler(Function1<Err, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldHandler$(this, onFailure, onSuccess, trace);
            }

            public final Handler<Object, Err, Object, Headers> headers(.less.colon.less<Out, Response> ev, Object trace) {
                return Handler.headers$(this, ev, trace);
            }

            public final Handler<Object, Err, Object, Option<Object>> header(Header.HeaderType headerType, .less.colon.less<Out, Response> ev, Object trace) {
                return Handler.header$(this, headerType, ev, trace);
            }

            public final <Out1> Handler<Object, Err, Object, Out1> map(Function1<Out, Out1> f, Object trace) {
                return Handler.map$(this, f, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> mapError(Function1<Err, Err1> f, Object trace) {
                return Handler.mapError$(this, f, trace);
            }

            public final <Err2> Handler<Object, Err2, Object, Out> mapErrorCause(Function1<Cause<Err>, Err2> f, Object trace) {
                return Handler.mapErrorCause$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, Object, Out1> mapZIO(Function1<Out, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapZIO$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, Object, Out1> mapErrorZIO(Function1<Err, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorZIO$(this, f, trace);
            }

            public final <Err1, Out1> Handler<Object, Nothing$, Object, Out1> merge(.eq.colon.eq<Err1, Out1> ev, Object trace) {
                return Handler.merge$(this, ev, trace);
            }

            public final <In1> Handler<Object, Err, In1, Out> narrow(.less.colon.less<In1, Object> ev) {
                return Handler.narrow$(this, ev);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> onExit(Function1<Exit<Err, Out>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.onExit$(this, f, trace);
            }

            public final Handler<Object, Nothing$, Object, Option<Out>> option(CanFail<Err> ev, Object trace) {
                return Handler.option$(this, ev, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Option<Out>> optional(.less.colon.less<Err, Option<Err1>> ev, Object trace) {
                return Handler.optional$(this, ev, trace);
            }

            public final Handler<Object, Nothing$, Object, Out> orDie(.less.colon.less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.orDie$(this, ev1, ev2, trace);
            }

            public final Handler<Object, Nothing$, Object, Out> orDieWith(Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.orDieWith$(this, f, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> orElse(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.orElse$(this, that, trace);
            }

            public final Handler<Object, Err, Object, Out> provideEnvironment(ZEnvironment<Object> r, Object trace) {
                return Handler.provideEnvironment$(this, r, trace);
            }

            public final <Err1, R0> Handler<R0, Err1, Object, Out> provideLayer(ZLayer<R0, Err1, Object> layer, Object trace) {
                return Handler.provideLayer$(this, layer, trace);
            }

            public final <R1> Handler<R1, Err, Object, Out> provideSomeEnvironment(Function1<ZEnvironment<R1>, ZEnvironment<Object>> f, Object trace) {
                return Handler.provideSomeEnvironment$(this, f, trace);
            }

            public final <R0, R1, Err1> Handler<R0, Err1, Object, Out> provideSomeLayer(ZLayer<R0, Err1, R1> layer, package.Tag<R1> evidence$1, .less.colon.less<R0, Object> ev, Object trace) {
                return Handler.provideSomeLayer$(this, layer, evidence$1, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> race(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.race$(this, that, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> refineOrDie(PartialFunction<Err, Err1> pf, .less.colon.less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.refineOrDie$(this, pf, ev1, ev2, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> refineOrDieWith(PartialFunction<Err, Err1> pf, Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.refineOrDieWith$(this, pf, f, ev, trace);
            }

            public final ZIO<Object, Err, Out> run(Method method, Path path, Headers headers, Body body, .less.colon.less<Request, Object> ev) {
                return Handler.run$(this, method, path, headers, body, ev);
            }

            public final Method run$default$1() {
                return Handler.run$default$1$(this);
            }

            public final Path run$default$2() {
                return Handler.run$default$2$(this);
            }

            public final Headers run$default$3() {
                return Handler.run$default$3$(this);
            }

            public final Body run$default$4() {
                return Handler.run$default$4$(this);
            }

            public final ZIO<Object, Err, Out> runZIO(Object in) {
                return Handler.runZIO$(this, in);
            }

            public final Handler<Object, Response, Object, Out> sandbox(Object trace) {
                return Handler.sandbox$(this, trace);
            }

            public final Handler<Object, Err, Object, Status> status(.less.colon.less<Out, Response> ev, Object trace) {
                return Handler.status$(this, ev, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapAllZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> onFailure, Function1<Out, ZIO<R1, Err1, Object>> onSuccess, Object trace) {
                return Handler.tapAllZIO$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapErrorCauseZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorCauseZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapErrorZIO(Function1<Err, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, Object, Out> tapZIO(Function1<Out, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapZIO$(this, f, trace);
            }

            public Handler<Object, Err, Object, Option<Out>> timeout(Duration duration, Object trace) {
                return Handler.timeout$(this, duration, trace);
            }

            public <Out1> Handler<Object, Err, Object, Out1> timeoutFail(Out1 out, Duration duration, Object trace) {
                return Handler.timeoutFail$(this, out, duration, trace);
            }

            public HttpApp<Object> toHttpApp(.less.colon.less<Err, Response> err, .less.colon.less<Request, Object> in, .less.colon.less<Out, Response> out, Object trace) {
                return Handler.toHttpApp$(this, err, in, out, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> unrefine(PartialFunction<Throwable, Err1> pf, Object trace) {
                return Handler.unrefine$(this, pf, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> unrefineTo(ClassTag<Err1> evidence$2, Object trace) {
                return Handler.unrefineTo$(this, evidence$2, trace);
            }

            public final <Err1> Handler<Object, Err1, Object, Out> unrefineWith(PartialFunction<Throwable, Err1> pf, Function1<Err, Err1> f, Object trace) {
                return Handler.unrefineWith$(this, pf, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, Object, Out1> unwrapZIO(.less.colon.less<Out, ZIO<R1, Err1, Out1>> ev, Object trace) {
                return Handler.unwrapZIO$(this, ev, trace);
            }

            public <Err1, Out1> Handler<Object, Err1, Object, Out1> widen(.less.colon.less<Err, Err1> ev1, .less.colon.less<Out, Out1> ev2) {
                return Handler.widen$(this, ev1, ev2);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> zip(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zip$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out> zipLeft(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipLeft$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> zipRight(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipRight$(this, that, trace);
            }

            public ZIO<Object, Err, Out> apply(Object in) {
                return (ZIO)this.exit$1.apply();
            }
            {
                this.exit$1 = exit$1;
                Handler.$init$(this);
            }
        };
    }

    public <In> BoxedUnit fromFunction() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionHandler() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionExit() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromFunctionZIO() {
        return BoxedUnit.UNIT;
    }

    private Option<MediaType> determineMediaType(String filePath) {
        int n = filePath.lastIndexOf(".");
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        String ext = filePath.substring(n + 1);
        return MediaType$.MODULE$.forFileExtension(ext);
    }

    public <R> Handler<R, Throwable, Object, Response> fromFile(Function0<File> makeFile, Object trace) {
        return this.fromFileZIO(ZIO$.MODULE$.attempt(makeFile, trace), trace);
    }

    public <R> Handler<R, Throwable, Object, Response> fromFileZIO(ZIO<R, Throwable, File> getFile, Object trace) {
        return this.fromZIO((Function0 & Serializable)() -> getFile.flatMap((Function1 & Serializable)file -> ZIO$.MODULE$.suspend((Function0 & Serializable)() -> {
            if (!file.exists()) {
                return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new FileNotFoundException(), trace);
            }
            if (file.isFile() && !file.canRead()) {
                return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new AccessDeniedException(file.getAbsolutePath()), trace);
            }
            if (file.isFile()) {
                Headers length = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentLength(file.length())}));
                Body x$2 = Body$.MODULE$.fromFile((File)file, Body$.MODULE$.fromFile$default$2());
                Status x$3 = Response$.MODULE$.apply$default$1();
                Response response = new Response(x$3, length, x$2);
                String pathName = ((Object)file.toPath()).toString();
                Option<MediaType> option = MODULE$.determineMediaType(pathName);
                if (option instanceof Some) {
                    MediaType mediaType = (MediaType)((Some)option).value();
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> (Response)response.addHeader(new Header.ContentType(mediaType, Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3())), trace);
                }
                if (None$.MODULE$.equals(option)) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> response, trace);
                }
                throw new MatchError(option);
            }
            return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new NotDirectoryException("Found directory instead of a file."), trace);
        }, trace), trace));
    }

    public Handler<Object, Throwable, Object, Response> fromResource(String path, Object trace) {
        return this.fromZIO((Function0 & Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable)() -> MODULE$.getClass().getClassLoader().getResource(path), trace).map((Function1 & Serializable)resource -> {
            if (resource == null) {
                return MODULE$.fail((Function0 & Serializable)() -> new FileNotFoundException(new StringBuilder(19).append("Resource ").append(path).append(" not found").toString()));
            }
            return MODULE$.fromResourceWithURL((URL)resource, trace);
        }, trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public Handler<Object, Throwable, Object, Response> fromResourceWithURL(URL url, Object trace) {
        String string = url.getProtocol();
        switch (string == null ? 0 : string.hashCode()) {
            case 104987: {
                if (!"jar".equals(string)) break;
                String path = new URI(url.getPath()).getPath();
                int bangIndex = path.indexOf(33);
                String filePath = path.substring(0, bangIndex);
                String resourcePath = path.substring(bangIndex + 2);
                Option<MediaType> mediaType = this.determineMediaType(resourcePath);
                ZIO openZip = ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable)() -> new ZipFile(filePath), trace);
                Function1 & Serializable closeZip = (Function1 & Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> jar.close(), trace).ignoreLogged(trace);
                return this.fromZIO((Function0 & Serializable)() -> ZIO.Acquire$.MODULE$.apply$extension(ZIO$.MODULE$.acquireReleaseWith((Function0 & Serializable)() -> openZip), closeZip).apply((Function1 & Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)jar.getEntry(resourcePath)), trace).collect((Function0 & Serializable)() -> Handler$.fileNotFound$1(resourcePath), (PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Option<ZipEntry>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        if (x1 instanceof Some) {
                            return (B1)((ZipEntry)((Some)x1).value());
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Option<ZipEntry> x1) {
                        return x1 instanceof Some;
                    }
                }, trace).flatMap((Function1 & Serializable)entry -> ZIO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> entry.isDirectory(), (Function0 & Serializable)() -> ZIO$.MODULE$.fail((Function0 & Serializable)() -> Handler$.isDirectory$1(resourcePath), trace), trace).map((Function1 & Serializable)x$35 -> {
                    long contentLength = entry.getSize();
                    ZStream inZStream = ZStream$.MODULE$.acquireReleaseWith((Function0 & Serializable)() -> openZip, closeZip, trace).mapZIO((Function1 & Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jar.getEntry(resourcePath)), jar), trace), trace).flatMap((Function1 & Serializable)x0$1 -> {
                        if (x0$1 != null) {
                            ZipEntry entry = (ZipEntry)x0$1._1();
                            ZipFile jar = (ZipFile)x0$1._2();
                            return ZStream$.MODULE$.fromInputStream((Function0 & Serializable)() -> jar.getInputStream(entry), (Function0)(JFunction0.mcI.sp & Serializable)() -> ZStream$.MODULE$.fromInputStream$default$2(), trace);
                        }
                        throw new MatchError(null);
                    }, trace);
                    Body x$1 = Body$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)inZStream);
                    Status x$2 = Response$.MODULE$.apply$default$1();
                    Headers x$3 = Response$.MODULE$.apply$default$2();
                    Response response = new Response(x$2, x$3, x$1);
                    return new Tuple4(x$35, (Object)BoxesRunTime.boxToLong((long)contentLength), (Object)inZStream, (Object)response);
                }, trace).map((Function1 & Serializable)x$36 -> {
                    if (x$36 != null) {
                        long contentLength = BoxesRunTime.unboxToLong((Object)x$36._2());
                        Response response = (Response)x$36._4();
                        return (Response)mediaType.fold((Function0 & Serializable)() -> response, (Function1 & Serializable)t -> (Response)((HeaderModifier)response.addHeader(new Header.ContentType((MediaType)t, Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()))).addHeader(new Header.ContentLength(contentLength)));
                    }
                    throw new MatchError(null);
                }, trace), trace), trace));
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                return this.fromFile((Function0<File>)(Function0 & Serializable)() -> new File(url.getPath()), trace);
            }
        }
        return this.fail((Function0 & Serializable)() -> new IllegalArgumentException(new StringBuilder(22).append("Unsupported protocol: ").append(string).toString()));
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, String> stream, Charset charset, Object trace) {
        return this.fromZIO((Function0 & Serializable)() -> ZIO$.MODULE$.environment(trace).map((Function1 & Serializable)env -> MODULE$.fromBody((Function0<Body>)(Function0 & Serializable)() -> Body$.MODULE$.fromCharSequenceStream((ZStream<Object, Throwable, CharSequence>)stream.provideEnvironment((Function0 & Serializable)() -> env, trace), charset, trace)), trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Handler<R, Throwable, Object, Response> fromStream(ZStream<R, Throwable, Object> stream, Object trace) {
        return this.fromZIO((Function0 & Serializable)() -> ZIO$.MODULE$.environment(trace).map((Function1 & Serializable)env -> MODULE$.fromBody((Function0<Body>)(Function0 & Serializable)() -> Body$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)stream.provideEnvironment((Function0 & Serializable)() -> env, trace))), trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public <R> Charset fromStream$default$2() {
        return Charsets$.MODULE$.Http();
    }

    public <R, Err, Out> Handler<R, Err, Object, Out> fromZIO(Function0<ZIO<R, Err, Out>> zio) {
        return new Handler<R, Err, Object, Out>(zio){
            private final Function0 zio$1;

            public <Env1 extends R, Ctx, In1> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, BoxedUnit> aspect, .less.colon.less<In1, Request> in, .less.colon.less<Out, Response> out, .less.colon.less<Err, Response> err) {
                return Handler.$at$at$((Handler)this, aspect, in, out, err);
            }

            public <Env1 extends R, Ctx, In1> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, Ctx> aspect, Zippable<Ctx, Request> zippable, .less.colon.less<Out, Response> res, Object trace) {
                return Handler.$at$at$((Handler)this, aspect, zippable, res, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $greater$greater$eq(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.$greater$greater$eq$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> $greater$greater$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$greater$greater$greater$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$less$less(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$less$less$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $less$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$greater$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> $less$times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$greater$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> $less$times(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> $times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$times$greater$(this, that, trace);
            }

            public final <Err1, Out1> Handler<R, Err1, Object, Out1> absolve(.less.colon.less<Out, Either<Err1, Out1>> ev, Object trace) {
                return Handler.absolve$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, Object, Out1> andThen(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.andThen$(this, that, trace);
            }

            public final <Out1> Handler<R, Err, Object, Out1> as(Out1 out, Object trace) {
                return Handler.as$(this, out, trace);
            }

            public final <R2> Handler<R2, Err, Object, Out> asEnvType(.less.colon.less<R2, R> ev) {
                return Handler.asEnvType$(this, ev);
            }

            public final <Err2> Handler<R, Err2, Object, Out> asErrorType(.less.colon.less<Err, Err2> ev) {
                return Handler.asErrorType$(this, ev);
            }

            public final <In2> Handler<R, Err, In2, Out> asInType(.less.colon.less<In2, Object> ev) {
                return Handler.asInType$(this, ev);
            }

            public final <Out2> Handler<R, Err, Object, Out2> asOutType(.less.colon.less<Out, Out2> ev) {
                return Handler.asOutType$(this, ev);
            }

            public final Handler<R, Err, Object, Body> body(.less.colon.less<Out, Response> ev, Object trace) {
                return Handler.body$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAll(Function1<Err, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAll$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllCause(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllCause$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchAllDefect(Function1<Throwable, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllDefect$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSome(PartialFunction<Err, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSome$(this, pf, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> catchSomeDefect(PartialFunction<Throwable, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSomeDefect$(this, pf, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> compose(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.compose$(this, that, trace);
            }

            public final <In1> Handler<R, Err, In1, Out> contramap(Function1<In1, Object> f) {
                return Handler.contramap$(this, f);
            }

            public final <R1 extends R, Err1, In1> Handler<R1, Err1, In1, Out> contramapZIO(Function1<In1, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.contramapZIO$(this, f, trace);
            }

            public final <In1> Handler<R, Err, Object, Out> contraFlatMap() {
                return Handler.contraFlatMap$(this);
            }

            public final Handler<R, Err, Object, Out> delay(Duration duration, Object trace) {
                return Handler.delay$(this, duration, trace);
            }

            public final Handler<R, Err, Object, Out> delayAfter(Duration duration, Object trace) {
                return Handler.delayAfter$(this, duration, trace);
            }

            public final Handler<R, Err, Object, Out> delayBefore(Duration duration, Object trace) {
                return Handler.delayBefore$(this, duration, trace);
            }

            public final Handler<R, Nothing$, Object, Either<Err, Out>> either(CanFail<Err> ev, Object trace) {
                return Handler.either$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatten(.less.colon.less<Out, Handler<R1, Err1, In1, Out1>> ev, Object trace) {
                return Handler.flatten$(this, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> flatMap(Function1<Out, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.flatMap$(this, f, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldCauseHandler(Function1<Cause<Err>, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldCauseHandler$(this, onFailure, onSuccess, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> foldHandler(Function1<Err, Handler<R1, Err1, In1, Out1>> onFailure, Function1<Out, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldHandler$(this, onFailure, onSuccess, trace);
            }

            public final Handler<R, Err, Object, Headers> headers(.less.colon.less<Out, Response> ev, Object trace) {
                return Handler.headers$(this, ev, trace);
            }

            public final Handler<R, Err, Object, Option<Object>> header(Header.HeaderType headerType, .less.colon.less<Out, Response> ev, Object trace) {
                return Handler.header$(this, headerType, ev, trace);
            }

            public final <Out1> Handler<R, Err, Object, Out1> map(Function1<Out, Out1> f, Object trace) {
                return Handler.map$(this, f, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> mapError(Function1<Err, Err1> f, Object trace) {
                return Handler.mapError$(this, f, trace);
            }

            public final <Err2> Handler<R, Err2, Object, Out> mapErrorCause(Function1<Cause<Err>, Err2> f, Object trace) {
                return Handler.mapErrorCause$(this, f, trace);
            }

            public final <R1 extends R, Err1, Out1> Handler<R1, Err1, Object, Out1> mapZIO(Function1<Out, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapZIO$(this, f, trace);
            }

            public final <R1 extends R, Err1, Out1> Handler<R1, Err1, Object, Out1> mapErrorZIO(Function1<Err, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorZIO$(this, f, trace);
            }

            public final <Err1, Out1> Handler<R, Nothing$, Object, Out1> merge(.eq.colon.eq<Err1, Out1> ev, Object trace) {
                return Handler.merge$(this, ev, trace);
            }

            public final <In1> Handler<R, Err, In1, Out> narrow(.less.colon.less<In1, Object> ev) {
                return Handler.narrow$(this, ev);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> onExit(Function1<Exit<Err, Out>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.onExit$(this, f, trace);
            }

            public final Handler<R, Nothing$, Object, Option<Out>> option(CanFail<Err> ev, Object trace) {
                return Handler.option$(this, ev, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Option<Out>> optional(.less.colon.less<Err, Option<Err1>> ev, Object trace) {
                return Handler.optional$(this, ev, trace);
            }

            public final Handler<R, Nothing$, Object, Out> orDie(.less.colon.less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.orDie$(this, ev1, ev2, trace);
            }

            public final Handler<R, Nothing$, Object, Out> orDieWith(Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.orDieWith$(this, f, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> orElse(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.orElse$(this, that, trace);
            }

            public final Handler<Object, Err, Object, Out> provideEnvironment(ZEnvironment<R> r, Object trace) {
                return Handler.provideEnvironment$(this, r, trace);
            }

            public final <Err1, R0> Handler<R0, Err1, Object, Out> provideLayer(ZLayer<R0, Err1, R> layer, Object trace) {
                return Handler.provideLayer$(this, layer, trace);
            }

            public final <R1> Handler<R1, Err, Object, Out> provideSomeEnvironment(Function1<ZEnvironment<R1>, ZEnvironment<R>> f, Object trace) {
                return Handler.provideSomeEnvironment$(this, f, trace);
            }

            public final <R0, R1, Err1> Handler<R0, Err1, Object, Out> provideSomeLayer(ZLayer<R0, Err1, R1> layer, package.Tag<R1> evidence$1, .less.colon.less<R0, R> ev, Object trace) {
                return Handler.provideSomeLayer$(this, layer, evidence$1, ev, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> race(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.race$(this, that, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> refineOrDie(PartialFunction<Err, Err1> pf, .less.colon.less<Err, Throwable> ev1, CanFail<Err> ev2, Object trace) {
                return Handler.refineOrDie$(this, pf, ev1, ev2, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> refineOrDieWith(PartialFunction<Err, Err1> pf, Function1<Err, Throwable> f, CanFail<Err> ev, Object trace) {
                return Handler.refineOrDieWith$(this, pf, f, ev, trace);
            }

            public final ZIO<R, Err, Out> run(Method method, Path path, Headers headers, Body body, .less.colon.less<Request, Object> ev) {
                return Handler.run$(this, method, path, headers, body, ev);
            }

            public final Method run$default$1() {
                return Handler.run$default$1$(this);
            }

            public final Path run$default$2() {
                return Handler.run$default$2$(this);
            }

            public final Headers run$default$3() {
                return Handler.run$default$3$(this);
            }

            public final Body run$default$4() {
                return Handler.run$default$4$(this);
            }

            public final ZIO<R, Err, Out> runZIO(Object in) {
                return Handler.runZIO$(this, in);
            }

            public final Handler<R, Response, Object, Out> sandbox(Object trace) {
                return Handler.sandbox$(this, trace);
            }

            public final Handler<R, Err, Object, Status> status(.less.colon.less<Out, Response> ev, Object trace) {
                return Handler.status$(this, ev, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapAllZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> onFailure, Function1<Out, ZIO<R1, Err1, Object>> onSuccess, Object trace) {
                return Handler.tapAllZIO$(this, onFailure, onSuccess, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapErrorCauseZIO(Function1<Cause<Err>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorCauseZIO$(this, f, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapErrorZIO(Function1<Err, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorZIO$(this, f, trace);
            }

            public final <R1 extends R, Err1> Handler<R1, Err1, Object, Out> tapZIO(Function1<Out, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapZIO$(this, f, trace);
            }

            public Handler<R, Err, Object, Option<Out>> timeout(Duration duration, Object trace) {
                return Handler.timeout$(this, duration, trace);
            }

            public <Out1> Handler<R, Err, Object, Out1> timeoutFail(Out1 out, Duration duration, Object trace) {
                return Handler.timeoutFail$(this, out, duration, trace);
            }

            public HttpApp<R> toHttpApp(.less.colon.less<Err, Response> err, .less.colon.less<Request, Object> in, .less.colon.less<Out, Response> out, Object trace) {
                return Handler.toHttpApp$(this, err, in, out, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> unrefine(PartialFunction<Throwable, Err1> pf, Object trace) {
                return Handler.unrefine$(this, pf, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> unrefineTo(ClassTag<Err1> evidence$2, Object trace) {
                return Handler.unrefineTo$(this, evidence$2, trace);
            }

            public final <Err1> Handler<R, Err1, Object, Out> unrefineWith(PartialFunction<Throwable, Err1> pf, Function1<Err, Err1> f, Object trace) {
                return Handler.unrefineWith$(this, pf, f, trace);
            }

            public final <R1 extends R, Err1, Out1> Handler<R1, Err1, Object, Out1> unwrapZIO(.less.colon.less<Out, ZIO<R1, Err1, Out1>> ev, Object trace) {
                return Handler.unwrapZIO$(this, ev, trace);
            }

            public <Err1, Out1> Handler<R, Err1, Object, Out1> widen(.less.colon.less<Err, Err1> ev1, .less.colon.less<Out, Out1> ev2) {
                return Handler.widen$(this, ev1, ev2);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Tuple2<Out, Out1>> zip(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zip$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out> zipLeft(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipLeft$(this, that, trace);
            }

            public final <R1 extends R, Err1, In1, Out1> Handler<R1, Err1, In1, Out1> zipRight(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipRight$(this, that, trace);
            }

            public ZIO<R, Err, Out> apply(Object in) {
                return (ZIO)this.zio$1.apply();
            }
            {
                this.zio$1 = zio$1;
                Handler.$init$(this);
            }
        };
    }

    public Handler<Object, Throwable, Object, URL> getResource(String path, Object trace) {
        return this.fromZIO((Function0 & Serializable)() -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable)() -> MODULE$.getClass().getClassLoader().getResource(path), trace)).flatMap((Function1 & Serializable)resource -> {
            if (resource == null) {
                return MODULE$.fail((Function0 & Serializable)() -> new IllegalArgumentException(new StringBuilder(19).append("Resource ").append(path).append(" not found").toString()));
            }
            return MODULE$.succeed((Function0 & Serializable)() -> resource);
        }, trace);
    }

    public Handler<Object, Throwable, Object, File> getResourceAsFile(String path, Object trace) {
        return this.getResource(path, trace).map((Function1 & Serializable)url -> new File(url.getPath()), trace);
    }

    public Handler<Object, Nothing$, Object, Response> html(Function0<Html> view) {
        return this.response((Function0<Response>)(Function0 & Serializable)() -> Response$.MODULE$.html((Html)view.apply(), Response$.MODULE$.html$default$2()));
    }

    public <A> Handler<Object, Nothing$, A, A> identity() {
        return new Handler<Object, Nothing$, A, A>(){

            public <Env1, Ctx, In1 extends A> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, BoxedUnit> aspect, .less.colon.less<In1, Request> in, .less.colon.less<A, Response> out, .less.colon.less<Nothing$, Response> err) {
                return Handler.$at$at$((Handler)this, aspect, in, out, err);
            }

            public <Env1, Ctx, In1 extends A> Handler<Env1, Response, Request, Response> $at$at(HandlerAspect<Env1, Ctx> aspect, Zippable<Ctx, Request> zippable, .less.colon.less<A, Response> res, Object trace) {
                return Handler.$at$at$((Handler)this, aspect, zippable, res, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> $greater$greater$eq(Function1<A, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.$greater$greater$eq$(this, f, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, A, Out1> $greater$greater$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$greater$greater$greater$(this, that, trace);
            }

            public final <R1, Err1, In1, Out1 extends A> Handler<R1, Err1, In1, A> $less$less$less(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$less$less$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> $less$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$greater$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Tuple2<A, Out1>> $less$times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$greater$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, A> $less$times(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$less$times$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> $times$greater(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.$times$greater$(this, that, trace);
            }

            public final <Err1, Out1> Handler<Object, Err1, A, Out1> absolve(.less.colon.less<A, Either<Err1, Out1>> ev, Object trace) {
                return Handler.absolve$(this, ev, trace);
            }

            public final <R1, Err1, In1, Out1> Handler<R1, Err1, A, Out1> andThen(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.andThen$(this, that, trace);
            }

            public final <Out1> Handler<Object, Nothing$, A, Out1> as(Out1 out, Object trace) {
                return Handler.as$(this, out, trace);
            }

            public final <R2> Handler<R2, Nothing$, A, A> asEnvType(.less.colon.less<R2, Object> ev) {
                return Handler.asEnvType$(this, ev);
            }

            public final <Err2> Handler<Object, Err2, A, A> asErrorType(.less.colon.less<Nothing$, Err2> ev) {
                return Handler.asErrorType$(this, ev);
            }

            public final <In2> Handler<Object, Nothing$, In2, A> asInType(.less.colon.less<In2, A> ev) {
                return Handler.asInType$(this, ev);
            }

            public final <Out2> Handler<Object, Nothing$, A, Out2> asOutType(.less.colon.less<A, Out2> ev) {
                return Handler.asOutType$(this, ev);
            }

            public final Handler<Object, Nothing$, A, Body> body(.less.colon.less<A, Response> ev, Object trace) {
                return Handler.body$(this, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchAll(Function1<Nothing$, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAll$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchAllCause(Function1<Cause<Nothing$>, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllCause$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchAllDefect(Function1<Throwable, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.catchAllDefect$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchSome(PartialFunction<Nothing$, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSome$(this, pf, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> catchSomeDefect(PartialFunction<Throwable, Handler<R1, Err1, In1, Out1>> pf, Object trace) {
                return Handler.catchSomeDefect$(this, pf, trace);
            }

            public final <R1, Err1, In1, Out1 extends A> Handler<R1, Err1, In1, A> compose(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.compose$(this, that, trace);
            }

            public final <In1> Handler<Object, Nothing$, In1, A> contramap(Function1<In1, A> f) {
                return Handler.contramap$(this, f);
            }

            public final <R1, Err1, In1> Handler<R1, Err1, In1, A> contramapZIO(Function1<In1, ZIO<R1, Err1, A>> f, Object trace) {
                return Handler.contramapZIO$(this, f, trace);
            }

            public final <In1> Handler<Object, Nothing$, A, A> contraFlatMap() {
                return Handler.contraFlatMap$(this);
            }

            public final Handler<Object, Nothing$, A, A> delay(Duration duration, Object trace) {
                return Handler.delay$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, A, A> delayAfter(Duration duration, Object trace) {
                return Handler.delayAfter$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, A, A> delayBefore(Duration duration, Object trace) {
                return Handler.delayBefore$(this, duration, trace);
            }

            public final Handler<Object, Nothing$, A, Either<Nothing$, A>> either(CanFail<Nothing$> ev, Object trace) {
                return Handler.either$(this, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> flatten(.less.colon.less<A, Handler<R1, Err1, In1, Out1>> ev, Object trace) {
                return Handler.flatten$(this, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> flatMap(Function1<A, Handler<R1, Err1, In1, Out1>> f, Object trace) {
                return Handler.flatMap$(this, f, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> foldCauseHandler(Function1<Cause<Nothing$>, Handler<R1, Err1, In1, Out1>> onFailure, Function1<A, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldCauseHandler$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> foldHandler(Function1<Nothing$, Handler<R1, Err1, In1, Out1>> onFailure, Function1<A, Handler<R1, Err1, In1, Out1>> onSuccess, Object trace) {
                return Handler.foldHandler$(this, onFailure, onSuccess, trace);
            }

            public final Handler<Object, Nothing$, A, Headers> headers(.less.colon.less<A, Response> ev, Object trace) {
                return Handler.headers$(this, ev, trace);
            }

            public final Handler<Object, Nothing$, A, Option<Object>> header(Header.HeaderType headerType, .less.colon.less<A, Response> ev, Object trace) {
                return Handler.header$(this, headerType, ev, trace);
            }

            public final <Out1> Handler<Object, Nothing$, A, Out1> map(Function1<A, Out1> f, Object trace) {
                return Handler.map$(this, f, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> mapError(Function1<Nothing$, Err1> f, Object trace) {
                return Handler.mapError$(this, f, trace);
            }

            public final <Err2> Handler<Object, Err2, A, A> mapErrorCause(Function1<Cause<Nothing$>, Err2> f, Object trace) {
                return Handler.mapErrorCause$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, A, Out1> mapZIO(Function1<A, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapZIO$(this, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, A, Out1> mapErrorZIO(Function1<Nothing$, ZIO<R1, Err1, Out1>> f, Object trace) {
                return Handler.mapErrorZIO$(this, f, trace);
            }

            public final <Err1, Out1> Handler<Object, Nothing$, A, Out1> merge(.eq.colon.eq<Err1, Out1> ev, Object trace) {
                return Handler.merge$(this, ev, trace);
            }

            public final <In1> Handler<Object, Nothing$, In1, A> narrow(.less.colon.less<In1, A> ev) {
                return Handler.narrow$(this, ev);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> onExit(Function1<Exit<Nothing$, A>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.onExit$(this, f, trace);
            }

            public final Handler<Object, Nothing$, A, Option<A>> option(CanFail<Nothing$> ev, Object trace) {
                return Handler.option$(this, ev, trace);
            }

            public final <Err1> Handler<Object, Err1, A, Option<A>> optional(.less.colon.less<Nothing$, Option<Err1>> ev, Object trace) {
                return Handler.optional$(this, ev, trace);
            }

            public final Handler<Object, Nothing$, A, A> orDie(.less.colon.less<Nothing$, Throwable> ev1, CanFail<Nothing$> ev2, Object trace) {
                return Handler.orDie$(this, ev1, ev2, trace);
            }

            public final Handler<Object, Nothing$, A, A> orDieWith(Function1<Nothing$, Throwable> f, CanFail<Nothing$> ev, Object trace) {
                return Handler.orDieWith$(this, f, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> orElse(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.orElse$(this, that, trace);
            }

            public final Handler<Object, Nothing$, A, A> provideEnvironment(ZEnvironment<Object> r, Object trace) {
                return Handler.provideEnvironment$(this, r, trace);
            }

            public final <Err1, R0> Handler<R0, Err1, A, A> provideLayer(ZLayer<R0, Err1, Object> layer, Object trace) {
                return Handler.provideLayer$(this, layer, trace);
            }

            public final <R1> Handler<R1, Nothing$, A, A> provideSomeEnvironment(Function1<ZEnvironment<R1>, ZEnvironment<Object>> f, Object trace) {
                return Handler.provideSomeEnvironment$(this, f, trace);
            }

            public final <R0, R1, Err1> Handler<R0, Err1, A, A> provideSomeLayer(ZLayer<R0, Err1, R1> layer, package.Tag<R1> evidence$1, .less.colon.less<R0, Object> ev, Object trace) {
                return Handler.provideSomeLayer$(this, layer, evidence$1, ev, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> race(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.race$(this, that, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> refineOrDie(PartialFunction<Nothing$, Err1> pf, .less.colon.less<Nothing$, Throwable> ev1, CanFail<Nothing$> ev2, Object trace) {
                return Handler.refineOrDie$(this, pf, ev1, ev2, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> refineOrDieWith(PartialFunction<Nothing$, Err1> pf, Function1<Nothing$, Throwable> f, CanFail<Nothing$> ev, Object trace) {
                return Handler.refineOrDieWith$(this, pf, f, ev, trace);
            }

            public final ZIO<Object, Nothing$, A> run(Method method, Path path, Headers headers, Body body, .less.colon.less<Request, A> ev) {
                return Handler.run$(this, method, path, headers, body, ev);
            }

            public final Method run$default$1() {
                return Handler.run$default$1$(this);
            }

            public final Path run$default$2() {
                return Handler.run$default$2$(this);
            }

            public final Headers run$default$3() {
                return Handler.run$default$3$(this);
            }

            public final Body run$default$4() {
                return Handler.run$default$4$(this);
            }

            public final ZIO<Object, Nothing$, A> runZIO(A in) {
                return Handler.runZIO$(this, in);
            }

            public final Handler<Object, Response, A, A> sandbox(Object trace) {
                return Handler.sandbox$(this, trace);
            }

            public final Handler<Object, Nothing$, A, Status> status(.less.colon.less<A, Response> ev, Object trace) {
                return Handler.status$(this, ev, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapAllZIO(Function1<Cause<Nothing$>, ZIO<R1, Err1, Object>> onFailure, Function1<A, ZIO<R1, Err1, Object>> onSuccess, Object trace) {
                return Handler.tapAllZIO$(this, onFailure, onSuccess, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapErrorCauseZIO(Function1<Cause<Nothing$>, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorCauseZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapErrorZIO(Function1<Nothing$, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapErrorZIO$(this, f, trace);
            }

            public final <R1, Err1> Handler<R1, Err1, A, A> tapZIO(Function1<A, ZIO<R1, Err1, Object>> f, Object trace) {
                return Handler.tapZIO$(this, f, trace);
            }

            public Handler<Object, Nothing$, A, Option<A>> timeout(Duration duration, Object trace) {
                return Handler.timeout$(this, duration, trace);
            }

            public <Out1> Handler<Object, Nothing$, A, Out1> timeoutFail(Out1 out, Duration duration, Object trace) {
                return Handler.timeoutFail$(this, out, duration, trace);
            }

            public HttpApp<Object> toHttpApp(.less.colon.less<Nothing$, Response> err, .less.colon.less<Request, A> in, .less.colon.less<A, Response> out, Object trace) {
                return Handler.toHttpApp$(this, err, in, out, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> unrefine(PartialFunction<Throwable, Err1> pf, Object trace) {
                return Handler.unrefine$(this, pf, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> unrefineTo(ClassTag<Err1> evidence$2, Object trace) {
                return Handler.unrefineTo$(this, evidence$2, trace);
            }

            public final <Err1> Handler<Object, Err1, A, A> unrefineWith(PartialFunction<Throwable, Err1> pf, Function1<Nothing$, Err1> f, Object trace) {
                return Handler.unrefineWith$(this, pf, f, trace);
            }

            public final <R1, Err1, Out1> Handler<R1, Err1, A, Out1> unwrapZIO(.less.colon.less<A, ZIO<R1, Err1, Out1>> ev, Object trace) {
                return Handler.unwrapZIO$(this, ev, trace);
            }

            public <Err1, Out1> Handler<Object, Err1, A, Out1> widen(.less.colon.less<Nothing$, Err1> ev1, .less.colon.less<A, Out1> ev2) {
                return Handler.widen$(this, ev1, ev2);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Tuple2<A, Out1>> zip(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zip$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, A> zipLeft(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipLeft$(this, that, trace);
            }

            public final <R1, Err1, In1 extends A, Out1> Handler<R1, Err1, In1, Out1> zipRight(Handler<R1, Err1, In1, Out1> that, Object trace) {
                return Handler.zipRight$(this, that, trace);
            }

            public ZIO<Object, Nothing$, A> apply(A in) {
                return Exit$.MODULE$.succeed(in);
            }
            {
                Handler.$init$(this);
            }
        };
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError() {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$InternalServerError$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, Response> internalServerError(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$InternalServerError$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed() {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$MethodNotAllowed$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, Response> methodNotAllowed(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$MethodNotAllowed$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Request, Response> notFound() {
        return Handler$FromFunctionHandler$.MODULE$.apply$extension(this.fromFunctionHandler(), (Function1 & Serializable)request -> MODULE$.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$NotFound$.MODULE$, (Function0<String>)(Function0 & Serializable)() -> request.url().path().encode()));
    }

    public Handler<Object, Nothing$, Object, Response> notFound(Function0<String> message) {
        return this.error((Function0<Status.Error>)(Function0 & Serializable)() -> Status$NotFound$.MODULE$, message);
    }

    public Handler<Object, Nothing$, Object, Response> ok() {
        return this.status((Function0<Status>)(Function0 & Serializable)() -> Status$Ok$.MODULE$);
    }

    public <A> BoxedUnit param() {
        return BoxedUnit.UNIT;
    }

    public Handler<Object, Nothing$, Object, Response> response(Function0<Response> response) {
        return this.succeed(response);
    }

    public <R, Err> Handler<R, Err, Object, Response> responseZIO(ZIO<R, Err, Response> getResponse) {
        return this.fromZIO((Function0 & Serializable)() -> getResponse);
    }

    public Handler<Object, Nothing$, Object, StackTrace> stackTrace(Object trace) {
        return this.fromZIO((Function0 & Serializable)() -> ZIO$.MODULE$.stackTrace(trace));
    }

    public Handler<Object, Nothing$, Object, Response> status(Function0<Status> code) {
        return this.succeed((Function0 & Serializable)() -> new Response((Status)code.apply(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3()));
    }

    public <Out> Handler<Object, Nothing$, Object, Out> succeed(Function0<Out> out) {
        return this.fromExit((Function0 & Serializable)() -> Exit$.MODULE$.succeed(out.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> template(Function0<CharSequence> heading, Html view) {
        return this.response((Function0<Response>)(Function0 & Serializable)() -> Response$.MODULE$.html(Template$.MODULE$.container((CharSequence)heading.apply(), view), Response$.MODULE$.html$default$2()));
    }

    public Handler<Object, Nothing$, Object, Response> text(Function0<CharSequence> text) {
        return this.response((Function0<Response>)(Function0 & Serializable)() -> Response$.MODULE$.text((CharSequence)text.apply()));
    }

    public Handler<Object, Nothing$, Object, Response> timeout(Duration duration, Object trace) {
        return this.status((Function0<Status>)(Function0 & Serializable)() -> Status$RequestTimeout$.MODULE$).delay(duration, trace);
    }

    public Handler<Object, Nothing$, Object, Response> tooLarge() {
        return this.status((Function0<Status>)(Function0 & Serializable)() -> Status$RequestEntityTooLarge$.MODULE$);
    }

    public Handler<Object, Nothing$, Object, BoxedUnit> unit() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/Handler.scala: 1066");
        }
        return unit;
    }

    public final <Env> WebSocketApp<Env> webSocket(Function1<Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>>, ZIO<Env, Throwable, Object>> f) {
        return WebSocketApp$.MODULE$.apply(Handler$FromFunctionZIO$.MODULE$.apply$extension(this.fromFunctionZIO(), f));
    }

    public final <R, Err> Handler.RequestHandlerSyntax<R, Err> RequestHandlerSyntax(Handler<R, Err, Request, Response> self) {
        return new Handler.RequestHandlerSyntax<R, Err>(self);
    }

    public final <R, Err, In> Handler<R, Err, In, Response> ResponseOutputSyntax(Handler<R, Err, In, Response> self) {
        return self;
    }

    public static final /* synthetic */ boolean $anonfun$asChunkBounded$5(int limit$1, Chunk x$32) {
        return x$32.size() < limit$1;
    }

    public static final /* synthetic */ boolean $anonfun$firstSuccessOf$default$2$1(Cause cause) {
        return !cause.isDie();
    }

    private static final FileNotFoundException fileNotFound$1(String resourcePath$1) {
        return new FileNotFoundException(new StringBuilder(19).append("Resource ").append(resourcePath$1).append(" not found").toString());
    }

    private static final IllegalArgumentException isDirectory$1(String resourcePath$1) {
        return new IllegalArgumentException(new StringBuilder(24).append("Resource ").append(resourcePath$1).append(" is a directory").toString());
    }

    private Handler$() {
    }
}

