/*
 * Decompiled with CFR 0.152.
 */
package zio.http.internal;

import scala.MatchError;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt;
import zio.http.internal.CaseMode;
import zio.http.internal.CaseMode$Insensitive$;
import zio.http.internal.CaseMode$Sensitive$;

public final class CharSequenceExtensions$ {
    public static final CharSequenceExtensions$ MODULE$ = new CharSequenceExtensions$();

    public boolean equals(CharSequence left, CharSequence right, CaseMode caseMode) {
        if (left == right) {
            return true;
        }
        return this.compare(left, right, caseMode) == 0;
    }

    public CaseMode equals$default$3() {
        return CaseMode$Sensitive$.MODULE$;
    }

    public int compare(CharSequence left, CharSequence right, CaseMode caseMode) {
        if (left == right) {
            return 0;
        }
        int leftLength = left.length();
        int rightLength = right.length();
        int result = 0;
        if (CaseMode$Sensitive$.MODULE$.equals(caseMode)) {
            int i = 0;
            while (i < leftLength && i < leftLength && i < rightLength) {
                char rightChar;
                char leftChar = left.charAt(i);
                if (leftChar != (rightChar = right.charAt(i))) {
                    result = leftChar - rightChar;
                    i = leftLength;
                    continue;
                }
                ++i;
            }
        } else if (CaseMode$Insensitive$.MODULE$.equals(caseMode)) {
            int i = 0;
            while (i < leftLength && i < leftLength && i < rightLength) {
                char rightChar;
                char leftChar = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(left.charAt(i)));
                if (leftChar != (rightChar = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(right.charAt(i))))) {
                    result = leftChar - rightChar;
                    i = leftLength;
                    continue;
                }
                ++i;
            }
        } else {
            throw new MatchError((Object)caseMode);
        }
        if (result != 0) {
            return result;
        }
        return new RichInt(Predef$.MODULE$.intWrapper(leftLength)).compare((Object)BoxesRunTime.boxToInteger((int)rightLength));
    }

    public CaseMode compare$default$3() {
        return CaseMode$Sensitive$.MODULE$;
    }

    public int hashCode(CharSequence value) {
        int length = value.length();
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            char character = value.charAt(i);
            hash = 31 * hash + (character & 0xFF);
        }
        return hash;
    }

    public boolean contains(CharSequence sequence, CharSequence subsequence, CaseMode caseMode) {
        int subsequenceLength;
        int sequenceLength = sequence.length();
        if (sequenceLength >= (subsequenceLength = subsequence.length()) && subsequenceLength != 0) {
            int maxPossibleStartIndex = sequenceLength - subsequenceLength;
            boolean result = false;
            int i = 0;
            if (CaseMode$Sensitive$.MODULE$.equals(caseMode)) {
                char firstCharacter = subsequence.charAt(0);
                while (i <= maxPossibleStartIndex && !result) {
                    if (sequence.charAt(i) != firstCharacter) {
                        ++i;
                        continue;
                    }
                    int sequenceIndex = i + 1;
                    for (int subsequenceIndex = 1; subsequenceIndex < subsequenceLength && sequence.charAt(sequenceIndex) == subsequence.charAt(subsequenceIndex); ++subsequenceIndex) {
                        ++sequenceIndex;
                    }
                    if (sequenceIndex - i == subsequenceLength) {
                        result = true;
                        continue;
                    }
                    ++i;
                }
            } else if (CaseMode$Insensitive$.MODULE$.equals(caseMode)) {
                char firstCharacter = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(subsequence.charAt(0)));
                while (i <= maxPossibleStartIndex && !result) {
                    if (RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(sequence.charAt(i))) != firstCharacter) {
                        ++i;
                        continue;
                    }
                    int sequenceIndex = i + 1;
                    for (int subsequenceIndex = 1; subsequenceIndex < subsequenceLength && RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(sequence.charAt(sequenceIndex))) == RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(subsequence.charAt(subsequenceIndex))); ++subsequenceIndex) {
                        ++sequenceIndex;
                    }
                    if (sequenceIndex - i == subsequenceLength) {
                        result = true;
                        continue;
                    }
                    ++i;
                }
            } else {
                throw new MatchError((Object)caseMode);
            }
            return result;
        }
        return subsequenceLength == 0;
    }

    public CaseMode contains$default$3() {
        return CaseMode$Sensitive$.MODULE$;
    }

    private CharSequenceExtensions$() {
    }
}

