/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Request;
import zio.http.URL;
import zio.http.netty.model.Conversions$;

public final class NettyRequestEncoder$ {
    public static final NettyRequestEncoder$ MODULE$ = new NettyRequestEncoder$();

    public ZIO<Object, Throwable, HttpRequest> encode(Request req, Object trace) {
        HttpHeaders headers;
        HttpHeaders httpHeaders;
        HttpMethod method = Conversions$.MODULE$.methodToNetty(req.method());
        HttpVersion jVersion = Conversions$.MODULE$.versionToNetty(req.version());
        String path = NettyRequestEncoder$.replaceEmptyPathWithSlash$1(req.url()).relative().addLeadingSlash().encode();
        HttpHeaders encodedReqHeaders = Conversions$.MODULE$.headersToNetty(req.allHeaders());
        Option<String> option = req.url().hostPort();
        if (option instanceof Some) {
            String host = (String)((Some)option).value();
            httpHeaders = encodedReqHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        } else {
            httpHeaders = headers = encodedReqHeaders;
        }
        if (req.body().isComplete()) {
            return req.body().asChunk(trace).map((Function1 & Serializable)chunk -> {
                ByteBuf content = Unpooled.wrappedBuffer((byte[])((byte[])chunk.toArray((ClassTag)ClassTag$.MODULE$.Byte())));
                int writerIndex = content.writerIndex();
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Integer.toString(writerIndex));
                DefaultFullHttpRequest jReq = new DefaultFullHttpRequest(jVersion, method, path, content);
                jReq.headers().set(headers);
                return jReq;
            }, trace);
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> {
            headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
            return new DefaultHttpRequest(jVersion, method, path, headers);
        }, trace);
    }

    private static final URL replaceEmptyPathWithSlash$1(URL url) {
        if (url.path().isEmpty()) {
            return url.addLeadingSlash();
        }
        return url;
    }

    private NettyRequestEncoder$() {
    }
}

