/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Header$Warning$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType$;
import zio.http.Response;
import zio.http.ServerSentEvent;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$GatewayTimeout$;
import zio.http.Status$HttpVersionNotSupported$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$NetworkAuthenticationRequired$;
import zio.http.Status$NotExtended$;
import zio.http.Status$NotFound$;
import zio.http.Status$NotImplemented$;
import zio.http.Status$Ok$;
import zio.http.Status$PermanentRedirect$;
import zio.http.Status$RequestTimeout$;
import zio.http.Status$SeeOther$;
import zio.http.Status$ServiceUnavailable$;
import zio.http.Status$SwitchingProtocols$;
import zio.http.Status$TemporaryRedirect$;
import zio.http.Status$Unauthorized$;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.internal.OutputEncoder$;
import zio.http.template.Html;
import zio.stream.ZStream;

public final class Response$
implements Serializable {
    public static final Response$ MODULE$ = new Response$();
    private static Headers contentTypeJson;
    private static Headers contentTypeHtml;
    private static Headers contentTypeText;
    private static Headers contentTypeEventStream;
    private static volatile boolean bitmap$init$0;
    private static volatile byte bitmap$0;

    public Status $lessinit$greater$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers $lessinit$greater$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body $lessinit$greater$default$3() {
        return Body$.MODULE$.empty();
    }

    public Response badRequest() {
        return this.error(Status$BadRequest$.MODULE$);
    }

    public Response badRequest(String message) {
        return this.error(Status$BadRequest$.MODULE$, message);
    }

    public Response error(Status.Error status, String message) {
        String message2 = OutputEncoder$.MODULE$.encodeHtml(message == null ? status.text() : message);
        return new Response(status, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Warning(status.code(), "ZIO HTTP", message2, Header$Warning$.MODULE$.apply$default$4())})), this.apply$default$3());
    }

    public Response error(Status.Error status) {
        return this.error(status, status.text());
    }

    public Response forbidden() {
        return this.error(Status$Forbidden$.MODULE$);
    }

    public Response forbidden(String message) {
        return this.error(Status$Forbidden$.MODULE$, message);
    }

    public Response fromCause(Cause<Object> cause) {
        while (true) {
            Object failure;
            Object failure2;
            boolean bl = false;
            Left left = null;
            Either either = cause.failureOrCause();
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Object failure3 = left.value();
                if (failure3 instanceof Response) {
                    return (Response)failure3;
                }
            }
            if (bl && (failure2 = left.value()) instanceof Throwable) {
                Throwable throwable = (Throwable)failure2;
                return this.fromThrowable(throwable);
            }
            if (!bl || !((failure = left.value()) instanceof Cause)) break;
            cause = (Cause)failure;
        }
        if (cause.isInterruptedOnly()) {
            return this.error(Status$RequestTimeout$.MODULE$, StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(cause.prettyPrint()), 100));
        }
        return this.error(Status$InternalServerError$.MODULE$, StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(cause.prettyPrint()), 100));
    }

    public <E> Response fromCauseWith(Cause<E> cause, Function1<E, Response> f) {
        Either either = cause.failureOrCause();
        if (either instanceof Left) {
            Object failure = ((Left)either).value();
            return (Response)f.apply(failure);
        }
        if (either instanceof Right) {
            Cause cause2 = (Cause)((Right)either).value();
            return this.fromCause((Cause<Object>)cause2);
        }
        throw new MatchError((Object)either);
    }

    public Response fromServerSentEvents(ZStream<Object, Nothing$, ServerSentEvent> data, Object trace) {
        return new Response(Status$Ok$.MODULE$, this.contentTypeEventStream(), Body$.MODULE$.fromCharSequenceStream((ZStream<Object, Throwable, CharSequence>)data.map((Function1 & Serializable)x$3 -> x$3.encode(), trace), Body$.MODULE$.fromCharSequenceStream$default$2(), trace));
    }

    public <R> ZIO<R, Nothing$, Response> fromSocketApp(WebSocketApp<R> app, Object trace) {
        return ZIO$.MODULE$.environment(trace).map((Function1 & Serializable)env -> new Response(Status$SwitchingProtocols$.MODULE$, Headers$.MODULE$.empty(), Body$.MODULE$.fromSocketApp(app.provideEnvironment((ZEnvironment)env, trace))), trace);
    }

    public Response fromThrowable(Throwable throwable) {
        if (throwable instanceof AccessDeniedException) {
            return this.error(Status$Forbidden$.MODULE$, throwable.getMessage());
        }
        if (throwable instanceof IllegalAccessException) {
            return this.error(Status$Forbidden$.MODULE$, throwable.getMessage());
        }
        if (throwable instanceof IllegalAccessError) {
            return this.error(Status$Forbidden$.MODULE$, throwable.getMessage());
        }
        if (throwable instanceof NotDirectoryException) {
            return this.error(Status$BadRequest$.MODULE$, throwable.getMessage());
        }
        if (throwable instanceof IllegalArgumentException) {
            return this.error(Status$BadRequest$.MODULE$, throwable.getMessage());
        }
        if (throwable instanceof FileNotFoundException) {
            return this.error(Status$NotFound$.MODULE$, throwable.getMessage());
        }
        if (throwable instanceof ConnectException) {
            return this.error(Status$ServiceUnavailable$.MODULE$, throwable.getMessage());
        }
        if (throwable instanceof SocketTimeoutException) {
            return this.error(Status$GatewayTimeout$.MODULE$, throwable.getMessage());
        }
        return this.error(Status$InternalServerError$.MODULE$, throwable.getMessage());
    }

    public Response gatewayTimeout() {
        return this.error(Status$GatewayTimeout$.MODULE$);
    }

    public Response gatewayTimeout(String message) {
        return this.error(Status$GatewayTimeout$.MODULE$, message);
    }

    public Response html(Html data, Status status) {
        return new Response(status, this.contentTypeHtml(), Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2()));
    }

    public Status html$default$2() {
        return Status$Ok$.MODULE$;
    }

    public Response httpVersionNotSupported() {
        return this.error(Status$HttpVersionNotSupported$.MODULE$);
    }

    public Response httpVersionNotSupported(String message) {
        return this.error(Status$HttpVersionNotSupported$.MODULE$, message);
    }

    public Response internalServerError() {
        return this.error(Status$InternalServerError$.MODULE$);
    }

    public Response internalServerError(String message) {
        return this.error(Status$InternalServerError$.MODULE$, message);
    }

    public Response json(CharSequence data) {
        return new Response(Status$Ok$.MODULE$, this.contentTypeJson(), Body$.MODULE$.fromCharSequence(data, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response networkAuthenticationRequired() {
        return this.error(Status$NetworkAuthenticationRequired$.MODULE$);
    }

    public Response networkAuthenticationRequired(String message) {
        return this.error(Status$NetworkAuthenticationRequired$.MODULE$, message);
    }

    public Response notExtended() {
        return this.error(Status$NotExtended$.MODULE$);
    }

    public Response notExtended(String message) {
        return this.error(Status$NotExtended$.MODULE$, message);
    }

    public Response notFound() {
        return this.error(Status$NotFound$.MODULE$);
    }

    public Response notFound(String message) {
        return this.error(Status$NotFound$.MODULE$, message);
    }

    public Response notImplemented() {
        return this.error(Status$NotImplemented$.MODULE$);
    }

    public Response notImplemented(String message) {
        return this.error(Status$NotImplemented$.MODULE$, message);
    }

    public Response ok() {
        return this.status(Status$Ok$.MODULE$);
    }

    public Response redirect(URL location, boolean isPermanent) {
        Status.Redirection status = isPermanent ? Status$PermanentRedirect$.MODULE$ : Status$TemporaryRedirect$.MODULE$;
        return new Response(status, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), this.apply$default$3());
    }

    public boolean redirect$default$2() {
        return false;
    }

    public Response seeOther(URL location) {
        return new Response(Status$SeeOther$.MODULE$, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.Location(location)})), this.apply$default$3());
    }

    public Response serviceUnavailable() {
        return this.error(Status$ServiceUnavailable$.MODULE$);
    }

    public Response serviceUnavailable(String message) {
        return this.error(Status$ServiceUnavailable$.MODULE$, message);
    }

    public Response status(Status status) {
        return new Response(status, this.apply$default$2(), this.apply$default$3());
    }

    public Response text(CharSequence text) {
        return new Response(Status$Ok$.MODULE$, this.contentTypeText(), Body$.MODULE$.fromCharSequence(text, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response unauthorized() {
        return this.error(Status$Unauthorized$.MODULE$);
    }

    public Response unauthorized(String message) {
        return this.error(Status$Unauthorized$.MODULE$, message);
    }

    private Headers contentTypeJson$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 1) == 0) {
                contentTypeJson = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.application().json(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return contentTypeJson;
    }

    private Headers contentTypeJson() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.contentTypeJson$lzycompute();
        }
        return contentTypeJson;
    }

    private Headers contentTypeHtml$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 2) == 0) {
                contentTypeHtml = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().html(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return contentTypeHtml;
    }

    private Headers contentTypeHtml() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.contentTypeHtml$lzycompute();
        }
        return contentTypeHtml;
    }

    private Headers contentTypeText$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 4) == 0) {
                contentTypeText = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().plain(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return contentTypeText;
    }

    private Headers contentTypeText() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.contentTypeText$lzycompute();
        }
        return contentTypeText;
    }

    private Headers contentTypeEventStream$lzycompute() {
        synchronized (this) {
            if ((byte)(bitmap$0 & 8) == 0) {
                contentTypeEventStream = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentType(MediaType$.MODULE$.text().event$minusstream(), Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()).untyped()}));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return contentTypeEventStream;
    }

    private Headers contentTypeEventStream() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.contentTypeEventStream$lzycompute();
        }
        return contentTypeEventStream;
    }

    public Response apply(Status status, Headers headers, Body body) {
        return new Response(status, headers, body);
    }

    public Status apply$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers apply$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body apply$default$3() {
        return Body$.MODULE$.empty();
    }

    public Option<Tuple3<Status, Headers, Body>> unapply(Response x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.status(), (Object)x$0.headers(), (Object)x$0.body()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Response$.class);
    }

    private Response$() {
    }
}

