/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause$;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.http.codec.internal.TextCodec$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.codec.Codec;
import zio.schema.codec.DecodeError;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class TextCodec$ {
    public static final TextCodec$ MODULE$ = new TextCodec$();

    public <A> Codec<String, Object, A> fromSchema(Schema<A> schema) {
        if (!(schema instanceof Schema.Primitive)) {
            return new Codec<String, Object, A>(schema){
                private final Schema schema$1;

                public Either<DecodeError, A> decode(String whole) {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }

                public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }

                public String encode(A value) {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }

                public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                    throw new IllegalArgumentException(new StringBuilder(78).append("Schema ").append(this.schema$1).append(" is not a primitive. Only primitive schemas are supported by TextCodec.").toString());
                }
                {
                    this.schema$1 = schema$1;
                }
            };
        }
        return new Codec<String, Object, A>(schema){
            private final Schema schema$1;

            public String encode(A a) {
                if (this.schema$1 instanceof Schema.Primitive) {
                    return a.toString();
                }
                throw new IllegalArgumentException(new StringBuilder(36).append("Cannot encode ").append(a).append(" of type ").append(a.getClass()).append(" with schema ").append(this.schema$1).toString());
            }

            public Either<DecodeError, A> decode(String s) {
                Schema schema = this.schema$1;
                if (schema instanceof Schema.Primitive) {
                    Right right;
                    StandardType standardType = ((Schema.Primitive)schema).standardType();
                    if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Right().apply((Object)"");
                    } else if (StandardType.StringType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Right().apply((Object)s);
                    } else if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s))).toEither();
                    } else if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0)(JFunction0.mcB.sp & Serializable)() -> StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(s))).toEither();
                    } else if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0)(JFunction0.mcS.sp & Serializable)() -> StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(s))).toEither();
                    } else if (StandardType.IntType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toEither();
                    } else if (StandardType.LongType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s))).toEither();
                    } else if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable)() -> StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s))).toEither();
                    } else if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s))).toEither();
                    } else if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Left().apply((Object)new DecodeError.EmptyContent("Binary is not supported"));
                    } else if (StandardType.CharType$.MODULE$.equals(standardType)) {
                        right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)s.charAt(0)));
                    } else if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> UUID.fromString(s)).toEither();
                    } else if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.BigDecimal().apply(s)).toEither();
                    } else if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> package$.MODULE$.BigInt().apply(s)).toEither();
                    } else if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> DayOfWeek.valueOf(s)).toEither();
                    } else if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> Month.valueOf(s)).toEither();
                    } else if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> MonthDay.parse(s)).toEither();
                    } else if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> Period.parse(s)).toEither();
                    } else if (StandardType.YearType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> Year.parse(s)).toEither();
                    } else if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> YearMonth.parse(s)).toEither();
                    } else if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> ZoneId.of(s)).toEither();
                    } else if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> ZoneOffset.of(s)).toEither();
                    } else if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> Duration.parse(s)).toEither();
                    } else if (StandardType.InstantType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> Instant.parse(s)).toEither();
                    } else if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> LocalDate.parse(s)).toEither();
                    } else if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> LocalTime.parse(s)).toEither();
                    } else if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> LocalDateTime.parse(s)).toEither();
                    } else if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> OffsetTime.parse(s)).toEither();
                    } else if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> OffsetDateTime.parse(s)).toEither();
                    } else if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) {
                        right = Try$.MODULE$.apply((Function0 & Serializable)() -> ZonedDateTime.parse(s)).toEither();
                    } else {
                        throw new MatchError((Object)standardType);
                    }
                    return right.map((Function1 & Serializable)x$10 -> x$10).left().map((Function1 & Serializable)e -> new DecodeError.ReadError(Cause$.MODULE$.fail(e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                }
                return package$.MODULE$.Left().apply((Object)new DecodeError.EmptyContent(new StringBuilder(65).append("Only primitive types are supported for text decoding. But found: ").append(this.schema$1.toString()).toString()));
            }

            public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                return ZPipeline$.MODULE$.map((Function1 & Serializable)a -> Chunk$.MODULE$.fromArray(StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(a.toString()), (ClassTag)ClassTag$.MODULE$.Char())), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamEncoder(MediaTypeCodec.scala:252)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamEncoder(MediaTypeCodec.scala:252)");
            }

            public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                return ZPipeline$.MODULE$.apply((Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(MediaTypeCodec.scala:255)").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToByte((byte)anon.4.$anonfun$streamDecoder$1(BoxesRunTime.unboxToChar((Object)x$11))), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(MediaTypeCodec.scala:255)").$greater$greater$greater((Function0 & Serializable)() -> ZPipeline$.MODULE$.utf8Decode((Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(MediaTypeCodec.scala:255)"), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(MediaTypeCodec.scala:255)").map((Function1 & Serializable)x$12 -> this.decode((String)x$12).fold((Function1 & Serializable)x$13 -> {
                    throw (Throwable)x$13;
                }, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x)), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(MediaTypeCodec.scala:256)").mapErrorCause((Function1 & Serializable)e -> Cause$.MODULE$.fail((Object)new DecodeError.ReadError(e, e.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl())).getMessage()), Cause$.MODULE$.fail$default$2()), (Object)"zio.http.codec.internal.TextCodec.fromSchema.$anon.streamDecoder(MediaTypeCodec.scala:257)");
            }

            public static final /* synthetic */ byte $anonfun$streamDecoder$1(char x$11) {
                return (byte)x$11;
            }
            {
                this.schema$1 = schema$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$1(java.lang.String ), $anonfun$decode$10(java.lang.String ), $anonfun$decode$11(java.lang.String ), $anonfun$decode$12(java.lang.String ), $anonfun$decode$13(java.lang.String ), $anonfun$decode$14(java.lang.String ), $anonfun$decode$15(java.lang.String ), $anonfun$decode$16(java.lang.String ), $anonfun$decode$17(java.lang.String ), $anonfun$decode$18(java.lang.String ), $anonfun$decode$19(java.lang.String ), $anonfun$decode$2(java.lang.String ), $anonfun$decode$20(java.lang.String ), $anonfun$decode$21(java.lang.String ), $anonfun$decode$22(java.lang.String ), $anonfun$decode$23(java.lang.String ), $anonfun$decode$24(java.lang.String ), $anonfun$decode$25(java.lang.String ), $anonfun$decode$26(java.lang.String ), $anonfun$decode$27(java.lang.Object ), $anonfun$decode$28(java.lang.Throwable ), $anonfun$decode$3(java.lang.String ), $anonfun$decode$4(java.lang.String ), $anonfun$decode$5(java.lang.String ), $anonfun$decode$6(java.lang.String ), $anonfun$decode$7(java.lang.String ), $anonfun$decode$8(java.lang.String ), $anonfun$decode$9(java.lang.String ), $anonfun$streamDecoder$1$adapted(java.lang.Object ), $anonfun$streamDecoder$2(), $anonfun$streamDecoder$3(zio.http.codec.internal.TextCodec$$anon$4 java.lang.String ), $anonfun$streamDecoder$4(zio.schema.codec.DecodeError ), $anonfun$streamDecoder$5(java.lang.Object ), $anonfun$streamDecoder$6(zio.Cause ), $anonfun$streamEncoder$1(java.lang.Object )}, serializedLambda);
            }
        };
    }

    private TextCodec$() {
    }
}

