/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$EmptyBody$;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyFutureExecutor$;
import zio.stream.ZStream;

public final class NettyBodyWriter$ {
    public static final NettyBodyWriter$ MODULE$ = new NettyBodyWriter$();

    public Option<ZIO<Object, Throwable, BoxedUnit>> writeAndFlush(Body body, Option<Object> contentLength, ChannelHandlerContext ctx, Object trace) {
        if (body instanceof NettyBody.ByteBufBody) {
            NettyBody.ByteBufBody byteBufBody = (NettyBody.ByteBufBody)body;
            ctx.write((Object)byteBufBody.byteBuf());
            ctx.flush();
            return None$.MODULE$;
        }
        if (body instanceof Body.FileBody) {
            File file = ((Body.FileBody)body).file();
            ctx.write((Object)new DefaultFileRegion(file, 0L, file.length()));
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            return None$.MODULE$;
        }
        if (body instanceof NettyBody.AsyncBody) {
            ((NettyBody.AsyncBody)body).unsafeAsync().apply((Object)new NettyBody.UnsafeAsync(ctx){
                private final ChannelHandlerContext ctx$1;

                public void apply(Chunk<Object> message, boolean isLast) {
                    ByteBuf nettyMsg = message instanceof Chunk.ByteArray ? Unpooled.wrappedBuffer((byte[])((Chunk.ByteArray)message).array()) : Unpooled.wrappedBuffer((byte[])((byte[])message.toArray((ClassTag)ClassTag$.MODULE$.Byte())));
                    this.ctx$1.writeAndFlush((Object)nettyMsg);
                    if (isLast) {
                        this.ctx$1.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                        return;
                    }
                }

                public void fail(Throwable cause) {
                    this.ctx$1.fireExceptionCaught(cause);
                }
                {
                    this.ctx$1 = ctx$1;
                }
            });
            return None$.MODULE$;
        }
        if (body instanceof NettyBody.AsciiStringBody) {
            AsciiString asciiString = ((NettyBody.AsciiStringBody)body).asciiString();
            ctx.write((Object)Unpooled.wrappedBuffer((byte[])asciiString.array()));
            ctx.flush();
            return None$.MODULE$;
        }
        if (body instanceof Body.StreamBody) {
            ZIO zIO;
            ZStream<Object, Throwable, Object> stream = ((Body.StreamBody)body).stream();
            if (contentLength instanceof Some) {
                long length = BoxesRunTime.unboxToLong((Object)((Some)contentLength).value());
                zIO = stream.chunks(trace).runFoldZIO((Function0)(JFunction0.mcJ.sp & Serializable)() -> length, (Function2 & Serializable)(remaining, bytes) -> NettyBodyWriter$.$anonfun$writeAndFlush$2(ctx, trace, BoxesRunTime.unboxToLong((Object)remaining), bytes), trace).flatMap((Function1 & Serializable)x0$1 -> NettyBodyWriter$.$anonfun$writeAndFlush$7(length, trace, ctx, BoxesRunTime.unboxToLong((Object)x0$1)), trace);
            } else if (None$.MODULE$.equals(contentLength)) {
                zIO = stream.chunks(trace).mapZIO((Function1 & Serializable)bytes -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()))))), trace), trace).runDrain(trace).zipRight((Function0 & Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT), trace), trace);
            } else {
                throw new MatchError(contentLength);
            }
            return new Some((Object)zIO);
        }
        if (body instanceof Body.ChunkBody) {
            Chunk<Object> data = ((Body.ChunkBody)body).data();
            ctx.write((Object)Unpooled.wrappedBuffer((byte[])((byte[])data.toArray((ClassTag)ClassTag$.MODULE$.Byte()))));
            ctx.flush();
            return None$.MODULE$;
        }
        if (Body$EmptyBody$.MODULE$.equals(body)) {
            ctx.flush();
            return None$.MODULE$;
        }
        throw new MatchError((Object)body);
    }

    public static final /* synthetic */ ZIO $anonfun$writeAndFlush$2(ChannelHandlerContext ctx$1, Object trace$1, long remaining, Chunk bytes) {
        long l = remaining - (long)bytes.size();
        if (0L == l) {
            return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> {
                ctx$1.write((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte())))));
                return ctx$1.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            }, trace$1).as((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, trace$1);
        }
        return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx$1.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()))))), trace$1).as((Function0)(JFunction0.mcJ.sp & Serializable)() -> l, trace$1);
    }

    public static final /* synthetic */ ZIO $anonfun$writeAndFlush$7(long length$1, Object trace$1, ChannelHandlerContext ctx$1, long x0$1) {
        if (0L == x0$1) {
            return ZIO$.MODULE$.unit();
        }
        long actualLength = length$1 - x0$1;
        return ZIO$.MODULE$.logWarning((Function0 & Serializable)() -> new StringBuilder(44).append("Expected Content-Length of ").append(length$1).append(", but sent ").append(actualLength).append(" bytes").toString(), trace$1).$times$greater((Function0 & Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx$1.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT), trace$1), trace$1);
    }

    private NettyBodyWriter$() {
    }
}

