/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import scala.;
import scala.$less$colon$less$;
import scala.runtime.BoxesRunTime;
import zio.Unsafe;
import zio.http.Body;
import zio.http.Response;
import zio.http.netty.NettyRuntime;
import zio.http.netty.model.Conversions$;

public final class NettyResponseEncoder$ {
    public static final NettyResponseEncoder$ MODULE$ = new NettyResponseEncoder$();

    public HttpResponse encode(ChannelHandlerContext ctx, Response response, NettyRuntime runtime, Unsafe unsafe, Object trace) {
        Body body = response.body();
        if (body.isComplete()) {
            byte[] bytes = (byte[])runtime.runtime(ctx).unsafe().run(body.asArray(trace), trace, unsafe).getOrThrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), unsafe);
            return this.fastEncode(response, bytes, unsafe);
        }
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(response.status());
        if (!jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            jHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        return new DefaultHttpResponse(HttpVersion.HTTP_1_1, jStatus, jHeaders);
    }

    public FullHttpResponse fastEncode(Response response, byte[] bytes, Unsafe unsafe) {
        if (response.encoded() == null) {
            response.encoded_$eq(this.doEncode(response, bytes));
        }
        return (FullHttpResponse)response.encoded();
    }

    private FullHttpResponse doEncode(Response response, byte[] bytes) {
        HttpHeaders jHeaders = Conversions$.MODULE$.headersToNetty(response.headers());
        boolean hasContentLength = jHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        HttpResponseStatus jStatus = Conversions$.MODULE$.statusToNetty(response.status());
        ByteBuf jContent = Unpooled.wrappedBuffer((byte[])bytes);
        DefaultFullHttpResponse jResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, jStatus, jContent, false);
        if (!hasContentLength) {
            jHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)jContent.readableBytes()));
        }
        jResponse.headers().add(jHeaders);
        return jResponse;
    }

    private NettyResponseEncoder$() {
    }
}

