/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.model;

import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import java.io.Serializable;
import java.util.Map;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.UninitializedFieldError;
import scala.collection.AbstractIterator;
import scala.collection.Iterable;
import scala.collection.Iterator;
import zio.http.Header;
import zio.http.Header$SetCookie$;
import zio.http.Headers;
import zio.http.Headers$Empty$;
import zio.http.Method;
import zio.http.Method$ANY$;
import zio.http.Method$CONNECT$;
import zio.http.Method$DELETE$;
import zio.http.Method$GET$;
import zio.http.Method$HEAD$;
import zio.http.Method$OPTIONS$;
import zio.http.Method$PATCH$;
import zio.http.Method$POST$;
import zio.http.Method$PUT$;
import zio.http.Method$TRACE$;
import zio.http.Scheme;
import zio.http.Scheme$HTTP$;
import zio.http.Scheme$HTTPS$;
import zio.http.Scheme$WS$;
import zio.http.Scheme$WSS$;
import zio.http.Server;
import zio.http.Server$Config$CompressionOptions$CompressionType$Deflate$;
import zio.http.Server$Config$CompressionOptions$CompressionType$GZip$;
import zio.http.Status;
import zio.http.Status$Accepted$;
import zio.http.Status$BadGateway$;
import zio.http.Status$BadRequest$;
import zio.http.Status$Conflict$;
import zio.http.Status$Continue$;
import zio.http.Status$Created$;
import zio.http.Status$ExpectationFailed$;
import zio.http.Status$FailedDependency$;
import zio.http.Status$Forbidden$;
import zio.http.Status$Found$;
import zio.http.Status$GatewayTimeout$;
import zio.http.Status$Gone$;
import zio.http.Status$HttpVersionNotSupported$;
import zio.http.Status$InsufficientStorage$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$LengthRequired$;
import zio.http.Status$Locked$;
import zio.http.Status$MethodNotAllowed$;
import zio.http.Status$MisdirectedRequest$;
import zio.http.Status$MovedPermanently$;
import zio.http.Status$MultiStatus$;
import zio.http.Status$MultipleChoices$;
import zio.http.Status$NetworkAuthenticationRequired$;
import zio.http.Status$NoContent$;
import zio.http.Status$NonAuthoritativeInformation$;
import zio.http.Status$NotAcceptable$;
import zio.http.Status$NotExtended$;
import zio.http.Status$NotFound$;
import zio.http.Status$NotImplemented$;
import zio.http.Status$NotModified$;
import zio.http.Status$Ok$;
import zio.http.Status$PartialContent$;
import zio.http.Status$PaymentRequired$;
import zio.http.Status$PermanentRedirect$;
import zio.http.Status$PreconditionFailed$;
import zio.http.Status$PreconditionRequired$;
import zio.http.Status$Processing$;
import zio.http.Status$ProxyAuthenticationRequired$;
import zio.http.Status$RequestEntityTooLarge$;
import zio.http.Status$RequestHeaderFieldsTooLarge$;
import zio.http.Status$RequestTimeout$;
import zio.http.Status$RequestUriTooLong$;
import zio.http.Status$RequestedRangeNotSatisfiable$;
import zio.http.Status$ResetContent$;
import zio.http.Status$SeeOther$;
import zio.http.Status$ServiceUnavailable$;
import zio.http.Status$SwitchingProtocols$;
import zio.http.Status$TemporaryRedirect$;
import zio.http.Status$TooManyRequests$;
import zio.http.Status$Unauthorized$;
import zio.http.Status$UnorderedCollection$;
import zio.http.Status$UnprocessableEntity$;
import zio.http.Status$UnsupportedMediaType$;
import zio.http.Status$UpgradeRequired$;
import zio.http.Status$UseProxy$;
import zio.http.Status$VariantAlsoNegotiates$;
import zio.http.Version;
import zio.http.Version$Default$;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.internal.CaseMode$Insensitive$;
import zio.http.internal.CharSequenceExtensions$;

public final class Conversions$ {
    public static final Conversions$ MODULE$ = new Conversions$();

    public Method methodFromNetty(HttpMethod method2) {
        HttpMethod httpMethod = HttpMethod.OPTIONS;
        if (!(httpMethod != null ? !httpMethod.equals(method2) : method2 != null)) {
            return Method$OPTIONS$.MODULE$;
        }
        HttpMethod httpMethod2 = HttpMethod.GET;
        if (!(httpMethod2 != null ? !httpMethod2.equals(method2) : method2 != null)) {
            return Method$GET$.MODULE$;
        }
        HttpMethod httpMethod3 = HttpMethod.HEAD;
        if (!(httpMethod3 != null ? !httpMethod3.equals(method2) : method2 != null)) {
            return Method$HEAD$.MODULE$;
        }
        HttpMethod httpMethod4 = HttpMethod.POST;
        if (!(httpMethod4 != null ? !httpMethod4.equals(method2) : method2 != null)) {
            return Method$POST$.MODULE$;
        }
        HttpMethod httpMethod5 = HttpMethod.PUT;
        if (!(httpMethod5 != null ? !httpMethod5.equals(method2) : method2 != null)) {
            return Method$PUT$.MODULE$;
        }
        HttpMethod httpMethod6 = HttpMethod.PATCH;
        if (!(httpMethod6 != null ? !httpMethod6.equals(method2) : method2 != null)) {
            return Method$PATCH$.MODULE$;
        }
        HttpMethod httpMethod7 = HttpMethod.DELETE;
        if (!(httpMethod7 != null ? !httpMethod7.equals(method2) : method2 != null)) {
            return Method$DELETE$.MODULE$;
        }
        HttpMethod httpMethod8 = HttpMethod.TRACE;
        if (!(httpMethod8 != null ? !httpMethod8.equals(method2) : method2 != null)) {
            return Method$TRACE$.MODULE$;
        }
        HttpMethod httpMethod9 = HttpMethod.CONNECT;
        if (!(httpMethod9 != null ? !httpMethod9.equals(method2) : method2 != null)) {
            return Method$CONNECT$.MODULE$;
        }
        return new Method.CUSTOM(method2.name());
    }

    public HttpMethod methodToNetty(Method method2) {
        if (Method$OPTIONS$.MODULE$.equals(method2)) {
            return HttpMethod.OPTIONS;
        }
        if (Method$GET$.MODULE$.equals(method2)) {
            return HttpMethod.GET;
        }
        if (Method$HEAD$.MODULE$.equals(method2)) {
            return HttpMethod.HEAD;
        }
        if (Method$POST$.MODULE$.equals(method2)) {
            return HttpMethod.POST;
        }
        if (Method$PUT$.MODULE$.equals(method2)) {
            return HttpMethod.PUT;
        }
        if (Method$PATCH$.MODULE$.equals(method2)) {
            return HttpMethod.PATCH;
        }
        if (Method$DELETE$.MODULE$.equals(method2)) {
            return HttpMethod.DELETE;
        }
        if (Method$TRACE$.MODULE$.equals(method2)) {
            return HttpMethod.TRACE;
        }
        if (Method$CONNECT$.MODULE$.equals(method2)) {
            return HttpMethod.CONNECT;
        }
        if (Method$ANY$.MODULE$.equals(method2)) {
            return HttpMethod.GET;
        }
        if (method2 instanceof Method.CUSTOM) {
            String name = ((Method.CUSTOM)method2).name();
            return new HttpMethod(name);
        }
        throw new MatchError((Object)method2);
    }

    public HttpHeaders headersToNetty(Headers headers) {
        if (headers instanceof Headers.FromIterable) {
            return this.encodeHeaderListToNetty((Iterable<Header>)headers.toList());
        }
        if (headers instanceof Headers.Native) {
            return (HttpHeaders)((Headers.Native)headers).value();
        }
        if (headers instanceof Headers.Concat) {
            return this.encodeHeaderListToNetty((Iterable<Header>)headers.toList());
        }
        if (Headers$Empty$.MODULE$.equals(headers)) {
            return new DefaultHttpHeaders();
        }
        throw new MatchError((Object)headers);
    }

    private Iterator<Header> nettyHeadersIterator(HttpHeaders headers) {
        return new AbstractIterator<Header>(headers){
            private final java.util.Iterator<Map.Entry<CharSequence, CharSequence>> nettyIterator;
            private volatile boolean bitmap$init$0;

            private java.util.Iterator<Map.Entry<CharSequence, CharSequence>> nettyIterator() {
                if (!this.bitmap$init$0) {
                    throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/netty/model/Conversions.scala: 71");
                }
                return this.nettyIterator;
            }

            public boolean hasNext() {
                return this.nettyIterator().hasNext();
            }

            public Header next() {
                Map.Entry<CharSequence, CharSequence> entry = this.nettyIterator().next();
                return new Header.Custom(entry.getKey(), entry.getValue());
            }
            {
                this.nettyIterator = headers$1.iteratorCharSequence();
                this.bitmap$init$0 = true;
            }
        };
    }

    public Headers headersFromNetty(HttpHeaders headers2) {
        return new Headers.Native<HttpHeaders>(headers2, (Function1 & Serializable)headers -> MODULE$.nettyHeadersIterator((HttpHeaders)headers), (Function2 & Serializable)(headers, key) -> {
            java.util.Iterator iterator = headers.iteratorCharSequence();
            String result = null;
            while (iterator.hasNext() && result == null) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!CharSequenceExtensions$.MODULE$.equals((CharSequence)entry.getKey(), (CharSequence)key, CaseMode$Insensitive$.MODULE$)) continue;
                result = entry.getValue().toString();
            }
            return result;
        });
    }

    private HttpHeaders encodeHeaderListToNetty(Iterable<Header> headers) {
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(true);
        headers.foreach((Function1 & Serializable)header -> {
            String string = header.headerName();
            String string2 = Header$SetCookie$.MODULE$.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return nettyHeaders.add(header.headerName(), (Object)header.renderedValueAsCharSequence());
            }
            return nettyHeaders.set(header.headerName(), (Object)header.renderedValueAsCharSequence());
        });
        return nettyHeaders;
    }

    public HttpResponseStatus statusToNetty(Status status) {
        if (Status$Continue$.MODULE$.equals(status)) {
            return HttpResponseStatus.CONTINUE;
        }
        if (Status$SwitchingProtocols$.MODULE$.equals(status)) {
            return HttpResponseStatus.SWITCHING_PROTOCOLS;
        }
        if (Status$Processing$.MODULE$.equals(status)) {
            return HttpResponseStatus.PROCESSING;
        }
        if (Status$Ok$.MODULE$.equals(status)) {
            return HttpResponseStatus.OK;
        }
        if (Status$Created$.MODULE$.equals(status)) {
            return HttpResponseStatus.CREATED;
        }
        if (Status$Accepted$.MODULE$.equals(status)) {
            return HttpResponseStatus.ACCEPTED;
        }
        if (Status$NonAuthoritativeInformation$.MODULE$.equals(status)) {
            return HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION;
        }
        if (Status$NoContent$.MODULE$.equals(status)) {
            return HttpResponseStatus.NO_CONTENT;
        }
        if (Status$ResetContent$.MODULE$.equals(status)) {
            return HttpResponseStatus.RESET_CONTENT;
        }
        if (Status$PartialContent$.MODULE$.equals(status)) {
            return HttpResponseStatus.PARTIAL_CONTENT;
        }
        if (Status$MultiStatus$.MODULE$.equals(status)) {
            return HttpResponseStatus.MULTI_STATUS;
        }
        if (Status$MultipleChoices$.MODULE$.equals(status)) {
            return HttpResponseStatus.MULTIPLE_CHOICES;
        }
        if (Status$MovedPermanently$.MODULE$.equals(status)) {
            return HttpResponseStatus.MOVED_PERMANENTLY;
        }
        if (Status$Found$.MODULE$.equals(status)) {
            return HttpResponseStatus.FOUND;
        }
        if (Status$SeeOther$.MODULE$.equals(status)) {
            return HttpResponseStatus.SEE_OTHER;
        }
        if (Status$NotModified$.MODULE$.equals(status)) {
            return HttpResponseStatus.NOT_MODIFIED;
        }
        if (Status$UseProxy$.MODULE$.equals(status)) {
            return HttpResponseStatus.USE_PROXY;
        }
        if (Status$TemporaryRedirect$.MODULE$.equals(status)) {
            return HttpResponseStatus.TEMPORARY_REDIRECT;
        }
        if (Status$PermanentRedirect$.MODULE$.equals(status)) {
            return HttpResponseStatus.PERMANENT_REDIRECT;
        }
        if (Status$BadRequest$.MODULE$.equals(status)) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (Status$Unauthorized$.MODULE$.equals(status)) {
            return HttpResponseStatus.UNAUTHORIZED;
        }
        if (Status$PaymentRequired$.MODULE$.equals(status)) {
            return HttpResponseStatus.PAYMENT_REQUIRED;
        }
        if (Status$Forbidden$.MODULE$.equals(status)) {
            return HttpResponseStatus.FORBIDDEN;
        }
        if (Status$NotFound$.MODULE$.equals(status)) {
            return HttpResponseStatus.NOT_FOUND;
        }
        if (Status$MethodNotAllowed$.MODULE$.equals(status)) {
            return HttpResponseStatus.METHOD_NOT_ALLOWED;
        }
        if (Status$NotAcceptable$.MODULE$.equals(status)) {
            return HttpResponseStatus.NOT_ACCEPTABLE;
        }
        if (Status$ProxyAuthenticationRequired$.MODULE$.equals(status)) {
            return HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED;
        }
        if (Status$RequestTimeout$.MODULE$.equals(status)) {
            return HttpResponseStatus.REQUEST_TIMEOUT;
        }
        if (Status$Conflict$.MODULE$.equals(status)) {
            return HttpResponseStatus.CONFLICT;
        }
        if (Status$Gone$.MODULE$.equals(status)) {
            return HttpResponseStatus.GONE;
        }
        if (Status$LengthRequired$.MODULE$.equals(status)) {
            return HttpResponseStatus.LENGTH_REQUIRED;
        }
        if (Status$PreconditionFailed$.MODULE$.equals(status)) {
            return HttpResponseStatus.PRECONDITION_FAILED;
        }
        if (Status$RequestEntityTooLarge$.MODULE$.equals(status)) {
            return HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE;
        }
        if (Status$RequestUriTooLong$.MODULE$.equals(status)) {
            return HttpResponseStatus.REQUEST_URI_TOO_LONG;
        }
        if (Status$UnsupportedMediaType$.MODULE$.equals(status)) {
            return HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE;
        }
        if (Status$RequestedRangeNotSatisfiable$.MODULE$.equals(status)) {
            return HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE;
        }
        if (Status$ExpectationFailed$.MODULE$.equals(status)) {
            return HttpResponseStatus.EXPECTATION_FAILED;
        }
        if (Status$MisdirectedRequest$.MODULE$.equals(status)) {
            return HttpResponseStatus.MISDIRECTED_REQUEST;
        }
        if (Status$UnprocessableEntity$.MODULE$.equals(status)) {
            return HttpResponseStatus.UNPROCESSABLE_ENTITY;
        }
        if (Status$Locked$.MODULE$.equals(status)) {
            return HttpResponseStatus.LOCKED;
        }
        if (Status$FailedDependency$.MODULE$.equals(status)) {
            return HttpResponseStatus.FAILED_DEPENDENCY;
        }
        if (Status$UnorderedCollection$.MODULE$.equals(status)) {
            return HttpResponseStatus.UNORDERED_COLLECTION;
        }
        if (Status$UpgradeRequired$.MODULE$.equals(status)) {
            return HttpResponseStatus.UPGRADE_REQUIRED;
        }
        if (Status$PreconditionRequired$.MODULE$.equals(status)) {
            return HttpResponseStatus.PRECONDITION_REQUIRED;
        }
        if (Status$TooManyRequests$.MODULE$.equals(status)) {
            return HttpResponseStatus.TOO_MANY_REQUESTS;
        }
        if (Status$RequestHeaderFieldsTooLarge$.MODULE$.equals(status)) {
            return HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE;
        }
        if (Status$InternalServerError$.MODULE$.equals(status)) {
            return HttpResponseStatus.INTERNAL_SERVER_ERROR;
        }
        if (Status$NotImplemented$.MODULE$.equals(status)) {
            return HttpResponseStatus.NOT_IMPLEMENTED;
        }
        if (Status$BadGateway$.MODULE$.equals(status)) {
            return HttpResponseStatus.BAD_GATEWAY;
        }
        if (Status$ServiceUnavailable$.MODULE$.equals(status)) {
            return HttpResponseStatus.SERVICE_UNAVAILABLE;
        }
        if (Status$GatewayTimeout$.MODULE$.equals(status)) {
            return HttpResponseStatus.GATEWAY_TIMEOUT;
        }
        if (Status$HttpVersionNotSupported$.MODULE$.equals(status)) {
            return HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED;
        }
        if (Status$VariantAlsoNegotiates$.MODULE$.equals(status)) {
            return HttpResponseStatus.VARIANT_ALSO_NEGOTIATES;
        }
        if (Status$InsufficientStorage$.MODULE$.equals(status)) {
            return HttpResponseStatus.INSUFFICIENT_STORAGE;
        }
        if (Status$NotExtended$.MODULE$.equals(status)) {
            return HttpResponseStatus.NOT_EXTENDED;
        }
        if (Status$NetworkAuthenticationRequired$.MODULE$.equals(status)) {
            return HttpResponseStatus.NETWORK_AUTHENTICATION_REQUIRED;
        }
        if (status instanceof Status.Custom) {
            return HttpResponseStatus.valueOf((int)((Status.Custom)status).code());
        }
        throw new MatchError((Object)status);
    }

    public Status statusFromNetty(HttpResponseStatus status) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.CONTINUE;
        if (!(httpResponseStatus != null ? !httpResponseStatus.equals(status) : status != null)) {
            return Status$Continue$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.SWITCHING_PROTOCOLS;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(status) : status != null)) {
            return Status$SwitchingProtocols$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus3 = HttpResponseStatus.PROCESSING;
        if (!(httpResponseStatus3 != null ? !httpResponseStatus3.equals(status) : status != null)) {
            return Status$Processing$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.OK;
        if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(status) : status != null)) {
            return Status$Ok$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus5 = HttpResponseStatus.CREATED;
        if (!(httpResponseStatus5 != null ? !httpResponseStatus5.equals(status) : status != null)) {
            return Status$Created$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus6 = HttpResponseStatus.ACCEPTED;
        if (!(httpResponseStatus6 != null ? !httpResponseStatus6.equals(status) : status != null)) {
            return Status$Accepted$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus7 = HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION;
        if (!(httpResponseStatus7 != null ? !httpResponseStatus7.equals(status) : status != null)) {
            return Status$NonAuthoritativeInformation$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus8 = HttpResponseStatus.NO_CONTENT;
        if (!(httpResponseStatus8 != null ? !httpResponseStatus8.equals(status) : status != null)) {
            return Status$NoContent$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus9 = HttpResponseStatus.RESET_CONTENT;
        if (!(httpResponseStatus9 != null ? !httpResponseStatus9.equals(status) : status != null)) {
            return Status$ResetContent$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus10 = HttpResponseStatus.PARTIAL_CONTENT;
        if (!(httpResponseStatus10 != null ? !httpResponseStatus10.equals(status) : status != null)) {
            return Status$PartialContent$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus11 = HttpResponseStatus.MULTI_STATUS;
        if (!(httpResponseStatus11 != null ? !httpResponseStatus11.equals(status) : status != null)) {
            return Status$MultiStatus$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus12 = HttpResponseStatus.MULTIPLE_CHOICES;
        if (!(httpResponseStatus12 != null ? !httpResponseStatus12.equals(status) : status != null)) {
            return Status$MultipleChoices$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus13 = HttpResponseStatus.MOVED_PERMANENTLY;
        if (!(httpResponseStatus13 != null ? !httpResponseStatus13.equals(status) : status != null)) {
            return Status$MovedPermanently$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus14 = HttpResponseStatus.FOUND;
        if (!(httpResponseStatus14 != null ? !httpResponseStatus14.equals(status) : status != null)) {
            return Status$Found$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus15 = HttpResponseStatus.SEE_OTHER;
        if (!(httpResponseStatus15 != null ? !httpResponseStatus15.equals(status) : status != null)) {
            return Status$SeeOther$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus16 = HttpResponseStatus.NOT_MODIFIED;
        if (!(httpResponseStatus16 != null ? !httpResponseStatus16.equals(status) : status != null)) {
            return Status$NotModified$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus17 = HttpResponseStatus.USE_PROXY;
        if (!(httpResponseStatus17 != null ? !httpResponseStatus17.equals(status) : status != null)) {
            return Status$UseProxy$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus18 = HttpResponseStatus.TEMPORARY_REDIRECT;
        if (!(httpResponseStatus18 != null ? !httpResponseStatus18.equals(status) : status != null)) {
            return Status$TemporaryRedirect$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus19 = HttpResponseStatus.PERMANENT_REDIRECT;
        if (!(httpResponseStatus19 != null ? !httpResponseStatus19.equals(status) : status != null)) {
            return Status$PermanentRedirect$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus20 = HttpResponseStatus.BAD_REQUEST;
        if (!(httpResponseStatus20 != null ? !httpResponseStatus20.equals(status) : status != null)) {
            return Status$BadRequest$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus21 = HttpResponseStatus.UNAUTHORIZED;
        if (!(httpResponseStatus21 != null ? !httpResponseStatus21.equals(status) : status != null)) {
            return Status$Unauthorized$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus22 = HttpResponseStatus.PAYMENT_REQUIRED;
        if (!(httpResponseStatus22 != null ? !httpResponseStatus22.equals(status) : status != null)) {
            return Status$PaymentRequired$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus23 = HttpResponseStatus.FORBIDDEN;
        if (!(httpResponseStatus23 != null ? !httpResponseStatus23.equals(status) : status != null)) {
            return Status$Forbidden$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus24 = HttpResponseStatus.NOT_FOUND;
        if (!(httpResponseStatus24 != null ? !httpResponseStatus24.equals(status) : status != null)) {
            return Status$NotFound$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus25 = HttpResponseStatus.METHOD_NOT_ALLOWED;
        if (!(httpResponseStatus25 != null ? !httpResponseStatus25.equals(status) : status != null)) {
            return Status$MethodNotAllowed$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus26 = HttpResponseStatus.NOT_ACCEPTABLE;
        if (!(httpResponseStatus26 != null ? !httpResponseStatus26.equals(status) : status != null)) {
            return Status$NotAcceptable$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus27 = HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED;
        if (!(httpResponseStatus27 != null ? !httpResponseStatus27.equals(status) : status != null)) {
            return Status$ProxyAuthenticationRequired$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus28 = HttpResponseStatus.REQUEST_TIMEOUT;
        if (!(httpResponseStatus28 != null ? !httpResponseStatus28.equals(status) : status != null)) {
            return Status$RequestTimeout$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus29 = HttpResponseStatus.CONFLICT;
        if (!(httpResponseStatus29 != null ? !httpResponseStatus29.equals(status) : status != null)) {
            return Status$Conflict$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus30 = HttpResponseStatus.GONE;
        if (!(httpResponseStatus30 != null ? !httpResponseStatus30.equals(status) : status != null)) {
            return Status$Gone$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus31 = HttpResponseStatus.LENGTH_REQUIRED;
        if (!(httpResponseStatus31 != null ? !httpResponseStatus31.equals(status) : status != null)) {
            return Status$LengthRequired$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus32 = HttpResponseStatus.PRECONDITION_FAILED;
        if (!(httpResponseStatus32 != null ? !httpResponseStatus32.equals(status) : status != null)) {
            return Status$PreconditionFailed$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus33 = HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE;
        if (!(httpResponseStatus33 != null ? !httpResponseStatus33.equals(status) : status != null)) {
            return Status$RequestEntityTooLarge$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus34 = HttpResponseStatus.REQUEST_URI_TOO_LONG;
        if (!(httpResponseStatus34 != null ? !httpResponseStatus34.equals(status) : status != null)) {
            return Status$RequestUriTooLong$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus35 = HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE;
        if (!(httpResponseStatus35 != null ? !httpResponseStatus35.equals(status) : status != null)) {
            return Status$UnsupportedMediaType$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus36 = HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE;
        if (!(httpResponseStatus36 != null ? !httpResponseStatus36.equals(status) : status != null)) {
            return Status$RequestedRangeNotSatisfiable$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus37 = HttpResponseStatus.EXPECTATION_FAILED;
        if (!(httpResponseStatus37 != null ? !httpResponseStatus37.equals(status) : status != null)) {
            return Status$ExpectationFailed$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus38 = HttpResponseStatus.MISDIRECTED_REQUEST;
        if (!(httpResponseStatus38 != null ? !httpResponseStatus38.equals(status) : status != null)) {
            return Status$MisdirectedRequest$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus39 = HttpResponseStatus.UNPROCESSABLE_ENTITY;
        if (!(httpResponseStatus39 != null ? !httpResponseStatus39.equals(status) : status != null)) {
            return Status$UnprocessableEntity$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus40 = HttpResponseStatus.LOCKED;
        if (!(httpResponseStatus40 != null ? !httpResponseStatus40.equals(status) : status != null)) {
            return Status$Locked$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus41 = HttpResponseStatus.FAILED_DEPENDENCY;
        if (!(httpResponseStatus41 != null ? !httpResponseStatus41.equals(status) : status != null)) {
            return Status$FailedDependency$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus42 = HttpResponseStatus.UNORDERED_COLLECTION;
        if (!(httpResponseStatus42 != null ? !httpResponseStatus42.equals(status) : status != null)) {
            return Status$UnorderedCollection$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus43 = HttpResponseStatus.UPGRADE_REQUIRED;
        if (!(httpResponseStatus43 != null ? !httpResponseStatus43.equals(status) : status != null)) {
            return Status$UpgradeRequired$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus44 = HttpResponseStatus.PRECONDITION_REQUIRED;
        if (!(httpResponseStatus44 != null ? !httpResponseStatus44.equals(status) : status != null)) {
            return Status$PreconditionRequired$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus45 = HttpResponseStatus.TOO_MANY_REQUESTS;
        if (!(httpResponseStatus45 != null ? !httpResponseStatus45.equals(status) : status != null)) {
            return Status$TooManyRequests$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus46 = HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE;
        if (!(httpResponseStatus46 != null ? !httpResponseStatus46.equals(status) : status != null)) {
            return Status$RequestHeaderFieldsTooLarge$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus47 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        if (!(httpResponseStatus47 != null ? !httpResponseStatus47.equals(status) : status != null)) {
            return Status$InternalServerError$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus48 = HttpResponseStatus.NOT_IMPLEMENTED;
        if (!(httpResponseStatus48 != null ? !httpResponseStatus48.equals(status) : status != null)) {
            return Status$NotImplemented$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus49 = HttpResponseStatus.BAD_GATEWAY;
        if (!(httpResponseStatus49 != null ? !httpResponseStatus49.equals(status) : status != null)) {
            return Status$BadGateway$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus50 = HttpResponseStatus.SERVICE_UNAVAILABLE;
        if (!(httpResponseStatus50 != null ? !httpResponseStatus50.equals(status) : status != null)) {
            return Status$ServiceUnavailable$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus51 = HttpResponseStatus.GATEWAY_TIMEOUT;
        if (!(httpResponseStatus51 != null ? !httpResponseStatus51.equals(status) : status != null)) {
            return Status$GatewayTimeout$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus52 = HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED;
        if (!(httpResponseStatus52 != null ? !httpResponseStatus52.equals(status) : status != null)) {
            return Status$HttpVersionNotSupported$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus53 = HttpResponseStatus.VARIANT_ALSO_NEGOTIATES;
        if (!(httpResponseStatus53 != null ? !httpResponseStatus53.equals(status) : status != null)) {
            return Status$VariantAlsoNegotiates$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus54 = HttpResponseStatus.INSUFFICIENT_STORAGE;
        if (!(httpResponseStatus54 != null ? !httpResponseStatus54.equals(status) : status != null)) {
            return Status$InsufficientStorage$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus55 = HttpResponseStatus.NOT_EXTENDED;
        if (!(httpResponseStatus55 != null ? !httpResponseStatus55.equals(status) : status != null)) {
            return Status$NotExtended$.MODULE$;
        }
        HttpResponseStatus httpResponseStatus56 = HttpResponseStatus.NETWORK_AUTHENTICATION_REQUIRED;
        if (!(httpResponseStatus56 != null ? !httpResponseStatus56.equals(status) : status != null)) {
            return Status$NetworkAuthenticationRequired$.MODULE$;
        }
        if (status != null) {
            return new Status.Custom(status.code());
        }
        throw new MatchError(null);
    }

    public Option<HttpScheme> schemeToNetty(Scheme scheme) {
        if (Scheme$HTTP$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)HttpScheme.HTTP);
        }
        if (Scheme$HTTPS$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)HttpScheme.HTTPS);
        }
        return None$.MODULE$;
    }

    public Option<WebSocketScheme> schemeToNettyWebSocketScheme(Scheme scheme) {
        if (Scheme$WS$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)WebSocketScheme.WS);
        }
        if (Scheme$WSS$.MODULE$.equals(scheme)) {
            return Option$.MODULE$.apply((Object)WebSocketScheme.WSS);
        }
        return None$.MODULE$;
    }

    public Option<Scheme> schemeFromNetty(HttpScheme scheme) {
        HttpScheme httpScheme = HttpScheme.HTTPS;
        if (!(httpScheme != null ? !httpScheme.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$HTTPS$.MODULE$);
        }
        HttpScheme httpScheme2 = HttpScheme.HTTP;
        if (!(httpScheme2 != null ? !httpScheme2.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$HTTP$.MODULE$);
        }
        return None$.MODULE$;
    }

    public Option<Scheme> schemeFromNetty(WebSocketScheme scheme) {
        WebSocketScheme webSocketScheme = WebSocketScheme.WSS;
        if (!(webSocketScheme != null ? !webSocketScheme.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$WSS$.MODULE$);
        }
        WebSocketScheme webSocketScheme2 = WebSocketScheme.WS;
        if (!(webSocketScheme2 != null ? !webSocketScheme2.equals(scheme) : scheme != null)) {
            return Option$.MODULE$.apply((Object)Scheme$WS$.MODULE$);
        }
        return None$.MODULE$;
    }

    public DeflateOptions compressionOptionsToNetty(Server.Config.CompressionOptions compressionOptions) {
        Server.Config.CompressionOptions.CompressionType compressionType = compressionOptions.kind();
        if (Server$Config$CompressionOptions$CompressionType$GZip$.MODULE$.equals(compressionType)) {
            return StandardCompressionOptions.gzip((int)compressionOptions.level(), (int)compressionOptions.bits(), (int)compressionOptions.mem());
        }
        if (Server$Config$CompressionOptions$CompressionType$Deflate$.MODULE$.equals(compressionType)) {
            return StandardCompressionOptions.deflate((int)compressionOptions.level(), (int)compressionOptions.bits(), (int)compressionOptions.mem());
        }
        throw new MatchError((Object)compressionType);
    }

    public HttpVersion versionToNetty(Version version) {
        if (Version$Http_1_0$.MODULE$.equals(version)) {
            return HttpVersion.HTTP_1_0;
        }
        if (Version$Http_1_1$.MODULE$.equals(version)) {
            return HttpVersion.HTTP_1_1;
        }
        if (Version$Default$.MODULE$.equals(version)) {
            return HttpVersion.HTTP_1_1;
        }
        throw new MatchError((Object)version);
    }

    private Conversions$() {
    }
}

