/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Config;
import zio.Config$;
import zio.http.Charsets$;
import zio.http.Path;
import zio.http.Path$;
import zio.http.QueryParams;
import zio.http.QueryParams$;
import zio.http.Scheme;
import zio.http.Scheme$;
import zio.http.URL;
import zio.http.URL$Fragment$;
import zio.http.URL$Location$Relative$;
import zio.http.internal.QueryParamEncoding$;

public final class URL$
implements Serializable {
    public static final URL$ MODULE$ = new URL$();
    private static volatile byte bitmap$init$0;

    public URL.Location $lessinit$greater$default$2() {
        return URL$Location$Relative$.MODULE$;
    }

    public QueryParams $lessinit$greater$default$3() {
        return QueryParams$.MODULE$.empty();
    }

    public Option<URL.Fragment> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public URL empty() {
        return new URL(Path$.MODULE$.empty(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public Either<Exception, URL> decode(String string) {
        Left left;
        block4: {
            try {
                Option<URL> url;
                URI uri = new URI(string);
                Option<URL> option = url = uri.isAbsolute() ? this.fromAbsoluteURI(uri) : this.fromRelativeURI(uri);
                if (None$.MODULE$.equals(url)) {
                    left = URL$.invalidURL$1(string);
                    break block4;
                }
                if (url instanceof Some) {
                    URL value = (URL)((Some)url).value();
                    left = new Right((Object)value);
                    break block4;
                }
                throw new MatchError(url);
            }
            catch (Exception e) {
                left = new Left((Object)e);
            }
        }
        return left;
    }

    public Config<URL> config() {
        return Config$.MODULE$.string().mapAttempt((Function1 & Serializable)x$1 -> (URL)MODULE$.decode((String)x$1).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl()).get());
    }

    public Option<URL> fromURI(URI uri) {
        if (uri.isAbsolute()) {
            return this.fromAbsoluteURI(uri);
        }
        return this.fromRelativeURI(uri);
    }

    public URL root() {
        return new URL(Path$.MODULE$.root(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public String zio$http$URL$$encode(URL url) {
        URL.Location location = url.kind();
        if (URL$Location$Relative$.MODULE$.equals(location)) {
            return URL$.path$1(true, url);
        }
        if (location instanceof URL.Location.Absolute) {
            URL.Location.Absolute absolute = (URL.Location.Absolute)location;
            String path2 = URL$.path$1(false, url);
            Option<Object> option = absolute.portIfNotDefault();
            if (None$.MODULE$.equals(option)) {
                return new StringBuilder(3).append(absolute.scheme().encode()).append("://").append(absolute.host()).append(path2).toString();
            }
            if (option instanceof Some) {
                int customPort = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                return new StringBuilder(4).append(absolute.scheme().encode()).append("://").append(absolute.host()).append(":").append(customPort).append(path2).toString();
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)location);
    }

    public Option<URL> fromAbsoluteURI(URI uri) {
        return Scheme$.MODULE$.decode(uri.getScheme()).flatMap((Function1 & Serializable)scheme -> Option$.MODULE$.apply((Object)uri.getHost()).flatMap((Function1 & Serializable)host -> Option$.MODULE$.apply((Object)uri.getRawPath()).map((Function1 & Serializable)path -> {
            Option port = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)uri.getPort())).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 != -1).orElse((Function0 & Serializable)() -> scheme.defaultPort());
            URL.Location.Absolute connection = new URL.Location.Absolute((Scheme)scheme, (String)host, (Option<Object>)port);
            Path path2 = Path$.MODULE$.decode((String)path);
            Path path3 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(path)) ? path2.addLeadingSlash() : path2;
            return new Tuple5(path, (Object)port, (Object)connection, (Object)path2, (Object)path3);
        }).map((Function1 & Serializable)x$4 -> {
            if (x$4 != null) {
                URL.Location.Absolute connection = (URL.Location.Absolute)x$4._3();
                Path path3 = (Path)x$4._5();
                return new URL(path3, connection, QueryParams$.MODULE$.decode(uri.getRawQuery(), QueryParams$.MODULE$.decode$default$2()), URL$Fragment$.MODULE$.fromURI(uri));
            }
            throw new MatchError(null);
        })));
    }

    public Option<URL> fromRelativeURI(URI uri) {
        return Option$.MODULE$.apply((Object)uri.getRawPath()).map((Function1 & Serializable)path -> new URL(Path$.MODULE$.decode((String)path), URL$Location$Relative$.MODULE$, QueryParams$.MODULE$.decode(uri.getRawQuery(), QueryParams$.MODULE$.decode$default$2()), URL$Fragment$.MODULE$.fromURI(uri)));
    }

    public URL apply(Path path, URL.Location kind, QueryParams queryParams2, Option<URL.Fragment> fragment) {
        return new URL(path, kind, queryParams2, fragment);
    }

    public URL.Location apply$default$2() {
        return URL$Location$Relative$.MODULE$;
    }

    public QueryParams apply$default$3() {
        return QueryParams$.MODULE$.empty();
    }

    public Option<URL.Fragment> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Path, URL.Location, QueryParams, Option<URL.Fragment>>> unapply(URL x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.path(), (Object)x$0.kind(), (Object)x$0.queryParams(), x$0.fragment()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(URL$.class);
    }

    private static final Left invalidURL$1(String string) {
        return new Left((Object)new MalformedURLException(new StringBuilder(15).append("Invalid URL: \"").append(string).append("\"").toString()));
    }

    private static final String path$1(boolean relative, URL url$1) {
        return new StringBuilder(0).append(QueryParamEncoding$.MODULE$.default().encode(relative || url$1.path().isEmpty() ? url$1.path().encode() : url$1.path().addLeadingSlash().encode(), url$1.queryParams().normalize(), Charsets$.MODULE$.Http())).append(url$1.fragment().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)f -> new StringBuilder(1).append("#").append(f.raw()).toString())).toString();
    }

    private URL$() {
    }
}

