/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.Chunk;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$EmptyBody$;
import zio.http.Body$StreamBody$;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyFutureExecutor$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class NettyBodyWriter$ {
    public static final NettyBodyWriter$ MODULE$ = new NettyBodyWriter$();

    public Option<ZIO<Object, Throwable, BoxedUnit>> writeAndFlush(Body body, Option<Object> contentLength, ChannelHandlerContext ctx, Object trace) {
        while (body instanceof Body.FileBody) {
            Body.FileBody fileBody = (Body.FileBody)body;
            ZStream stream = ZStream$.MODULE$.fromFile((Function0 & Serializable)() -> fileBody.file(), (Function0)(JFunction0.mcI.sp & Serializable)() -> ZStream$.MODULE$.fromFile$default$2(), trace);
            Body.StreamBody s = new Body.StreamBody((ZStream<Object, Throwable, Object>)stream, (Option<Object>)None$.MODULE$, fileBody.mediaType(), Body$StreamBody$.MODULE$.apply$default$4());
            contentLength = None$.MODULE$;
            body = s;
        }
        if (body instanceof NettyBody.AsyncBody) {
            ((NettyBody.AsyncBody)body).unsafeAsync().apply((Object)new NettyBody.UnsafeAsync(ctx){
                private final ChannelHandlerContext ctx$1;

                public void apply(Chunk<Object> message, boolean isLast) {
                    NettyBodyWriter$.zio$http$netty$NettyBodyWriter$$writeArray$1(message instanceof Chunk.ByteArray ? ((Chunk.ByteArray)message).array() : (byte[])message.toArray((ClassTag)ClassTag$.MODULE$.Byte()), isLast, this.ctx$1);
                }

                public void fail(Throwable cause) {
                    this.ctx$1.fireExceptionCaught(cause);
                }
                {
                    this.ctx$1 = ctx$1;
                }
            });
            return None$.MODULE$;
        }
        if (body instanceof NettyBody.AsciiStringBody) {
            NettyBodyWriter$.zio$http$netty$NettyBodyWriter$$writeArray$1(((NettyBody.AsciiStringBody)body).asciiString().array(), true, ctx);
            return None$.MODULE$;
        }
        if (body instanceof Body.StreamBody) {
            ZIO zIO;
            ZStream<Object, Throwable, Object> stream = ((Body.StreamBody)body).stream();
            Option option = contentLength.orElse((Function0 & Serializable)() -> body.knownContentLength());
            if (option instanceof Some) {
                long length = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                zIO = stream.chunks(trace).runFoldZIO((Function0)(JFunction0.mcJ.sp & Serializable)() -> length, (Function2 & Serializable)(remaining, bytes) -> NettyBodyWriter$.$anonfun$writeAndFlush$5(trace, ctx, BoxesRunTime.unboxToLong((Object)remaining), bytes), trace).flatMap((Function1 & Serializable)x0$1 -> NettyBodyWriter$.$anonfun$writeAndFlush$10(length, trace, ctx, BoxesRunTime.unboxToLong((Object)x0$1)), trace);
            } else if (None$.MODULE$.equals(option)) {
                zIO = stream.chunks(trace).mapZIO((Function1 & Serializable)bytes -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> NettyBodyWriter$.zio$http$netty$NettyBodyWriter$$writeArray$1((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()), false, ctx), trace), trace).runDrain(trace).zipRight((Function0 & Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT), trace), trace);
            } else {
                throw new MatchError((Object)option);
            }
            return new Some((Object)zIO);
        }
        if (body instanceof Body.ArrayBody) {
            NettyBodyWriter$.zio$http$netty$NettyBodyWriter$$writeArray$1(((Body.ArrayBody)body).data(), true, ctx);
            return None$.MODULE$;
        }
        if (body instanceof Body.ChunkBody) {
            NettyBodyWriter$.zio$http$netty$NettyBodyWriter$$writeArray$1((byte[])((Body.ChunkBody)body).data().toArray((ClassTag)ClassTag$.MODULE$.Byte()), true, ctx);
            return None$.MODULE$;
        }
        if (Body$EmptyBody$.MODULE$.equals(body)) {
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            return None$.MODULE$;
        }
        throw new MatchError((Object)body);
    }

    public static final ChannelFuture zio$http$netty$NettyBodyWriter$$writeArray$1(byte[] body, boolean isLast, ChannelHandlerContext ctx$1) {
        DefaultHttpContent content = new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])body));
        if (isLast) {
            ctx$1.write((Object)content);
            return ctx$1.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        return ctx$1.writeAndFlush((Object)content);
    }

    public static final /* synthetic */ ZIO $anonfun$writeAndFlush$5(Object trace$1, ChannelHandlerContext ctx$1, long remaining, Chunk bytes) {
        long l = remaining - (long)bytes.size();
        if (0L == l) {
            return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> NettyBodyWriter$.zio$http$netty$NettyBodyWriter$$writeArray$1((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()), true, ctx$1), trace$1).as((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, trace$1);
        }
        return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> NettyBodyWriter$.zio$http$netty$NettyBodyWriter$$writeArray$1((byte[])bytes.toArray((ClassTag)ClassTag$.MODULE$.Byte()), false, ctx$1), trace$1).as((Function0)(JFunction0.mcJ.sp & Serializable)() -> l, trace$1);
    }

    public static final /* synthetic */ ZIO $anonfun$writeAndFlush$10(long length$1, Object trace$1, ChannelHandlerContext ctx$1, long x0$1) {
        if (0L == x0$1) {
            return ZIO$.MODULE$.unit();
        }
        long actualLength = length$1 - x0$1;
        return ZIO$.MODULE$.logWarning((Function0 & Serializable)() -> new StringBuilder(44).append("Expected Content-Length of ").append(length$1).append(", but sent ").append(actualLength).append(" bytes").toString(), trace$1).$times$greater((Function0 & Serializable)() -> NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx$1.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT), trace$1), trace$1);
    }

    private NettyBodyWriter$() {
    }
}

