/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit$;
import zio.Promise;
import zio.Queue;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$;
import zio.http.ChannelEvent$UserEvent$HandshakeComplete$;
import zio.http.ChannelEvent$UserEvent$HandshakeTimeout$;
import zio.http.WebSocketFrame;
import zio.http.WebSocketFrame$Binary$;
import zio.http.WebSocketFrame$Continuation$;
import zio.http.WebSocketFrame$Ping$;
import zio.http.WebSocketFrame$Pong$;
import zio.http.WebSocketFrame$Text$;
import zio.http.internal.ChannelState;
import zio.http.internal.ChannelState$Invalid$;
import zio.http.netty.NettyRuntime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d!\u0002\t\u0012\u0005U9\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011I\u0002!\u0011!Q\u0001\nMB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t;\u0002\u0011\t\u0011)A\u0006=\")A\r\u0001C\u0001K\"9A\u000e\u0001b\u0001\n\u0017i\u0007BB9\u0001A\u0003%a\u000eC\u0003s\u0001\u0011%1\u000fC\u0005\u0002\u0010\u0001\t\n\u0011\"\u0003\u0002\u0012!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002V\u0001!I!a\u0016\u0003']+'mU8dW\u0016$\u0018\t\u001d9IC:$G.\u001a:\u000b\u0005I\u0019\u0012!\u00028fiRL(B\u0001\u000b\u0016\u0003\u0011AG\u000f\u001e9\u000b\u0003Y\t1A_5p'\t\u0001\u0001\u0004E\u0002\u001a?\u0005j\u0011A\u0007\u0006\u00037q\tqa\u00195b]:,GN\u0003\u0002\u0013;)\ta$\u0001\u0002j_&\u0011\u0001E\u0007\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005\tRS\"A\u0012\u000b\u0005\u0011*\u0013AC<fEN|7m[3uq*\u0011AC\n\u0006\u0003O!\nQaY8eK\u000eT!!\u000b\u000f\u0002\u000f!\fg\u000e\u001a7fe&\u00111f\t\u0002\u000f/\u0016\u00147k\\2lKR4%/Y7f\u0003\u0015QX\t_3d\u0007\u0001\u0001\"a\f\u0019\u000e\u0003EI!!M\t\u0003\u00199+G\u000f^=Sk:$\u0018.\\3\u0002\u000bE,X-^3\u0011\u0007Q*t'D\u0001\u0016\u0013\t1TCA\u0003Rk\u0016,X\r\u0005\u00029\u0005:\u0011\u0011\b\u0011\b\u0003u}r!a\u000f \u000e\u0003qR!!P\u0017\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001\u000b\u0016\u0013\t\t5#A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%!F,fEN{7m[3u\u0007\"\fgN\\3m\u000bZ,g\u000e\u001e\u0006\u0003\u0003N\t!b\u001c8D_6\u0004H.\u001a;f!\r9%\nT\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1q\n\u001d;j_:\u0004B\u0001N'P/&\u0011a*\u0006\u0002\b!J|W.[:f!\t\u0001FK\u0004\u0002R':\u00111HU\u0005\u0002\u0013&\u0011\u0011\tS\u0005\u0003+Z\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005\u0005C\u0005C\u0001-\\\u001b\u0005I&B\u0001.\u0014\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001/Z\u00051\u0019\u0005.\u00198oK2\u001cF/\u0019;f\u0003\u0015!(/Y2f!\ty\u0016M\u0004\u0002;A&\u0011\u0011)F\u0005\u0003E\u000e\u0014Q\u0001\u0016:bG\u0016T!!Q\u000b\u0002\rqJg.\u001b;?)\u00111\u0017N[6\u0015\u0005\u001dD\u0007CA\u0018\u0001\u0011\u0015iV\u0001q\u0001_\u0011\u0015aS\u00011\u0001/\u0011\u0015\u0011T\u00011\u00014\u0011\u0015)U\u00011\u0001G\u0003-)hn]1gK\u000ec\u0017m]:\u0016\u00039\u0004\"\u0001N8\n\u0005A,\"AB+og\u00064W-\u0001\u0007v]N\fg-Z\"mCN\u001c\b%\u0001\u0005eSN\u0004\u0018\r^2i)\u0015!x\u000f`A\u0003!\t9U/\u0003\u0002w\u0011\n!QK\\5u\u0011\u0015A\b\u00021\u0001z\u0003\r\u0019G\u000f\u001f\t\u00033iL!a\u001f\u000e\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")Q\u0010\u0003a\u0001}\u0006)QM^3oiB!q0!\u0001\"\u001b\u0005\u0019\u0012bAA\u0002'\ta1\t[1o]\u0016dWI^3oi\"I\u0011q\u0001\u0005\u0011\u0002\u0003\u0007\u0011\u0011B\u0001\u0006G2|7/\u001a\t\u0004\u000f\u0006-\u0011bAA\u0007\u0011\n9!i\\8mK\u0006t\u0017A\u00053jgB\fGo\u00195%I\u00164\u0017-\u001e7uIM*\"!a\u0005+\t\u0005%\u0011QC\u0016\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0005%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005m!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a1\r[1o]\u0016d'+Z1eaQ)A/a\u000b\u0002.!)\u0001P\u0003a\u0001s\"1\u0011q\u0006\u0006A\u0002\u0005\n1!\\:h\u0003E\u0019\u0007.\u00198oK2\u0014VmZ5ti\u0016\u0014X\r\u001a\u000b\u0004i\u0006U\u0002\"\u0002=\f\u0001\u0004I\u0018aE2iC:tW\r\\+oe\u0016<\u0017n\u001d;fe\u0016$Gc\u0001;\u0002<!)\u0001\u0010\u0004a\u0001s\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000fF\u0003u\u0003\u0003\n\u0019\u0005C\u0003y\u001b\u0001\u0007\u0011\u0010\u0003\u0004\u0002F5\u0001\raT\u0001\u0006G\u0006,8/Z\u0001\u0013kN,'/\u0012<f]R$&/[4hKJ,G\rF\u0003u\u0003\u0017\ni\u0005C\u0003y\u001d\u0001\u0007\u0011\u0010C\u0004\u000209\u0001\r!a\u0014\u0011\u0007\u001d\u000b\t&C\u0002\u0002T!\u0013a!\u00118z%\u00164\u0017A\u00044sC6,gI]8n\u001d\u0016$H/\u001f\u000b\u0005\u00033\ni\u0006E\u0002\u0000\u00037J!aK\n\t\r\u0005}s\u00021\u0001\"\u0003\u0019QgI]1nK\u0002")
public final class WebSocketAppHandler
extends SimpleChannelInboundHandler<io.netty.handler.codec.http.websocketx.WebSocketFrame> {
    private final NettyRuntime zExec;
    private final Queue<ChannelEvent<WebSocketFrame>> queue;
    private final Option<Promise<Throwable, ChannelState>> onComplete;
    private final Object trace;
    private final Unsafe unsafeClass;
    private volatile boolean bitmap$init$0;

    private Unsafe unsafeClass() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: WebSocketAppHandler.scala: 43");
        }
        return this.unsafeClass;
    }

    private void dispatch(ChannelHandlerContext ctx, ChannelEvent<io.netty.handler.codec.http.websocketx.WebSocketFrame> event, boolean close) {
        this.zExec.unsafeRunSync(this.queue.offer(event.map((Function1 & Serializable)jFrame -> this.frameFromNetty((io.netty.handler.codec.http.websocketx.WebSocketFrame)jFrame)), this.trace), this.unsafeClass(), this.trace);
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            Promise promise = (Promise)((Some)option).value();
            if (close) {
                promise.unsafe().done((ZIO)Exit$.MODULE$.succeed((Object)ChannelState$Invalid$.MODULE$), this.unsafeClass());
                return;
            }
        }
    }

    private boolean dispatch$default$3() {
        return false;
    }

    public void channelRead0(ChannelHandlerContext ctx, io.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.read(msg), this.dispatch$default$3());
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.registered(), this.dispatch$default$3());
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.unregistered(), true);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.exceptionCaught(cause), this.dispatch$default$3());
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            ((Promise)((Some)option).value()).unsafe().done((ZIO)Exit$.MODULE$.fail((Object)cause), this.unsafeClass());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof WebSocketServerProtocolHandler.HandshakeComplete ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE.equals(msg)) {
            this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeComplete$.MODULE$), this.dispatch$default$3());
            return;
        }
        if (WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg) ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg)) {
            this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeTimeout$.MODULE$), this.dispatch$default$3());
            return;
        }
        super.userEventTriggered(ctx, msg);
    }

    private WebSocketFrame frameFromNetty(io.netty.handler.codec.http.websocketx.WebSocketFrame jFrame) {
        if (jFrame instanceof PingWebSocketFrame) {
            return WebSocketFrame$Ping$.MODULE$;
        }
        if (jFrame instanceof PongWebSocketFrame) {
            return WebSocketFrame$Pong$.MODULE$;
        }
        if (jFrame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)jFrame;
            return WebSocketFrame$Binary$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)binaryWebSocketFrame.content())), binaryWebSocketFrame.isFinalFragment());
        }
        if (jFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)jFrame;
            return WebSocketFrame$Text$.MODULE$.apply(textWebSocketFrame.text(), textWebSocketFrame.isFinalFragment());
        }
        if (jFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)jFrame;
            return new WebSocketFrame.Close(closeWebSocketFrame.statusCode(), (Option<String>)Option$.MODULE$.apply((Object)closeWebSocketFrame.reasonText()));
        }
        if (jFrame instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)jFrame;
            return WebSocketFrame$Continuation$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)continuationWebSocketFrame.content())), continuationWebSocketFrame.isFinalFragment());
        }
        return null;
    }

    public WebSocketAppHandler(NettyRuntime zExec, Queue<ChannelEvent<WebSocketFrame>> queue, Option<Promise<Throwable, ChannelState>> onComplete, Object trace) {
        this.zExec = zExec;
        this.queue = queue;
        this.onComplete = onComplete;
        this.trace = trace;
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = true;
    }
}

