/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.Queue;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$Unregistered$;
import zio.http.WebSocketFrame;
import zio.http.WebSocketFrame$Ping$;
import zio.http.WebSocketFrame$Pong$;
import zio.http.netty.NettyChannel;
import zio.http.netty.WebSocketChannel$;

public final class WebSocketChannel$ {
    public static final WebSocketChannel$ MODULE$ = new WebSocketChannel$();

    public Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> make(NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel, Queue<ChannelEvent<WebSocketFrame>> queue) {
        return new Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>>(nettyChannel, queue){
            private final NettyChannel nettyChannel$1;
            private final Queue queue$1;

            public final <In2> Channel<In2, ChannelEvent<WebSocketFrame>> contramap(Function1<In2, ChannelEvent<WebSocketFrame>> f) {
                return Channel.contramap$(this, f);
            }

            public final <Out2> Channel<ChannelEvent<WebSocketFrame>, Out2> map(Function1<ChannelEvent<WebSocketFrame>, Out2> f, Object trace) {
                return Channel.map$(this, f, trace);
            }

            public ZIO<Object, Nothing$, BoxedUnit> awaitShutdown(Object trace) {
                return this.nettyChannel$1.awaitClose(trace);
            }

            public ZIO<Object, Throwable, ChannelEvent<WebSocketFrame>> receive(Object trace) {
                return this.queue$1.take(trace);
            }

            public <Env, Err> ZIO<Env, Err, BoxedUnit> receiveAll(Function1<ChannelEvent<WebSocketFrame>, ZIO<Env, Err, Object>> f, Object trace) {
                LazyRef loop$lzy = new LazyRef();
                return this.loop$1(loop$lzy, trace, f);
            }

            public ZIO<Object, Throwable, BoxedUnit> send(ChannelEvent<WebSocketFrame> in, Object trace) {
                if (in instanceof ChannelEvent.Read) {
                    WebSocketFrame message = (WebSocketFrame)((ChannelEvent.Read)in).message();
                    return this.nettyChannel$1.writeAndFlush((Function0 & Serializable)() -> WebSocketChannel$.MODULE$.zio$http$netty$WebSocketChannel$$frameToNetty(message), this.nettyChannel$1.writeAndFlush$default$2(), trace);
                }
                return ZIO$.MODULE$.unit();
            }

            public ZIO<Object, Throwable, BoxedUnit> sendAll(Iterable<ChannelEvent<WebSocketFrame>> in, Object trace) {
                return ZIO$.MODULE$.suspendSucceed((Function0 & Serializable)() -> {
                    Iterator iterator = in.iterator().collect((PartialFunction)new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends ChannelEvent<WebSocketFrame>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            if (x1 instanceof ChannelEvent.Read) {
                                return (B1)((WebSocketFrame)((ChannelEvent.Read)x1).message());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(ChannelEvent<WebSocketFrame> x1) {
                            return x1 instanceof ChannelEvent.Read;
                        }
                    });
                    return ZIO$.MODULE$.whileLoop((Function0)(JFunction0.mcZ.sp & Serializable)() -> iterator.hasNext(), (Function0 & Serializable)() -> {
                        WebSocketFrame message = (WebSocketFrame)iterator.next();
                        if (iterator.hasNext()) {
                            return $this.nettyChannel$1.write(WebSocketChannel$.MODULE$.zio$http$netty$WebSocketChannel$$frameToNetty(message), $this.nettyChannel$1.write$default$2(), trace);
                        }
                        return $this.nettyChannel$1.writeAndFlush((Function0 & Serializable)() -> WebSocketChannel$.MODULE$.zio$http$netty$WebSocketChannel$$frameToNetty(message), $this.nettyChannel$1.writeAndFlush$default$2(), trace);
                    }, (Function1 & Serializable)x$1 -> {
                        anon.1.$anonfun$sendAll$5(x$1);
                        return BoxedUnit.UNIT;
                    }, trace);
                }, trace);
            }

            public ZIO<Object, Nothing$, BoxedUnit> shutdown(Object trace) {
                return this.nettyChannel$1.close(false, trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(), trace);
            }

            private final /* synthetic */ ZIO loop$lzycompute$1(LazyRef loop$lzy$1, Object trace$1, Function1 f$1) {
                synchronized (loop$lzy$1) {
                    ZIO zIO = loop$lzy$1.initialized() ? (ZIO)loop$lzy$1.value() : (ZIO)loop$lzy$1.initialize((Object)this.queue$1.take(trace$1).flatMap((Function1 & Serializable)x0$1 -> {
                        if (x0$1 instanceof ChannelEvent.ExceptionCaught) {
                            ChannelEvent.ExceptionCaught exceptionCaught = (ChannelEvent.ExceptionCaught)x0$1;
                            return ((ZIO)f$1.apply((Object)exceptionCaught)).unit(trace$1);
                        }
                        if (x0$1 == ChannelEvent$Unregistered$.MODULE$) {
                            ChannelEvent$Unregistered$ channelEvent$Unregistered$ = (ChannelEvent$Unregistered$)x0$1;
                            return ((ZIO)f$1.apply((Object)channelEvent$Unregistered$)).unit(trace$1);
                        }
                        return ((ZIO)f$1.apply(x0$1)).$times$greater((Function0 & Serializable)() -> ZIO$.MODULE$.yieldNow(trace$1), trace$1).$times$greater((Function0 & Serializable)() -> this.loop$1(loop$lzy$1, trace$1, f$1), trace$1);
                    }, trace$1));
                    return zIO;
                }
            }

            private final ZIO loop$1(LazyRef loop$lzy$1, Object trace$1, Function1 f$1) {
                if (loop$lzy$1.initialized()) {
                    return (ZIO)loop$lzy$1.value();
                }
                return this.loop$lzycompute$1(loop$lzy$1, trace$1, f$1);
            }

            public static final /* synthetic */ void $anonfun$sendAll$5(BoxedUnit x$1) {
            }
            {
                this.nettyChannel$1 = nettyChannel$1;
                this.queue$1 = queue$1;
                Channel.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$receiveAll$1(zio.http.netty.WebSocketChannel$$anon$1 scala.Function1 java.lang.Object scala.runtime.LazyRef zio.http.ChannelEvent ), $anonfun$receiveAll$2(java.lang.Object ), $anonfun$receiveAll$3(zio.http.netty.WebSocketChannel$$anon$1 scala.runtime.LazyRef java.lang.Object scala.Function1 ), $anonfun$send$1(zio.http.WebSocketFrame ), $anonfun$sendAll$1(zio.http.netty.WebSocketChannel$$anon$1 scala.collection.Iterable java.lang.Object ), $anonfun$sendAll$2(scala.collection.Iterator ), $anonfun$sendAll$3(zio.http.netty.WebSocketChannel$$anon$1 scala.collection.Iterator java.lang.Object ), $anonfun$sendAll$4(zio.http.WebSocketFrame ), $anonfun$sendAll$5$adapted(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
    }

    public io.netty.handler.codec.http.websocketx.WebSocketFrame zio$http$netty$WebSocketChannel$$frameToNetty(WebSocketFrame frame) {
        boolean bl = false;
        WebSocketFrame.Close close = null;
        if (frame instanceof WebSocketFrame.Binary) {
            WebSocketFrame.Binary binary = (WebSocketFrame.Binary)frame;
            return new BinaryWebSocketFrame(binary.isFinal(), 0, Unpooled.wrappedBuffer((byte[])((byte[])binary.bytes().toArray((ClassTag)ClassTag$.MODULE$.Byte()))));
        }
        if (frame instanceof WebSocketFrame.Text) {
            WebSocketFrame.Text text = (WebSocketFrame.Text)frame;
            return new TextWebSocketFrame(text.isFinal(), 0, text.text());
        }
        if (frame instanceof WebSocketFrame.Close) {
            bl = true;
            close = (WebSocketFrame.Close)frame;
            int status = close.status();
            Option<String> option = close.reason();
            if (option instanceof Some) {
                String text = (String)((Some)option).value();
                return new CloseWebSocketFrame(status, text);
            }
        }
        if (bl) {
            int status = close.status();
            Option<String> option = close.reason();
            if (None$.MODULE$.equals(option)) {
                return new CloseWebSocketFrame(status, null);
            }
        }
        if (WebSocketFrame$Ping$.MODULE$.equals(frame)) {
            return new PingWebSocketFrame();
        }
        if (WebSocketFrame$Pong$.MODULE$.equals(frame)) {
            return new PongWebSocketFrame();
        }
        if (frame instanceof WebSocketFrame.Continuation) {
            WebSocketFrame.Continuation continuation = (WebSocketFrame.Continuation)frame;
            return new ContinuationWebSocketFrame(continuation.isFinal(), 0, Unpooled.wrappedBuffer((byte[])((byte[])continuation.buffer().toArray((ClassTag)ClassTag$.MODULE$.Byte()))));
        }
        throw new MatchError((Object)frame);
    }

    private WebSocketChannel$() {
    }
}

