/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Using;
import zio.Config;
import zio.http.ClientSSLCertConfig;
import zio.http.ClientSSLConfig;
import zio.http.ClientSSLConfig$Default$;

public final class ClientSSLConverter$ {
    public static final ClientSSLConverter$ MODULE$ = new ClientSSLConverter$();

    private SslContextBuilder trustStoreToSslContext(InputStream trustStoreStream, Config.Secret trustStorePassword, SslContextBuilder sslContextBuilder) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustStore.load(trustStoreStream, (char[])trustStorePassword.value().toArray((ClassTag)ClassTag$.MODULE$.Char()));
        trustManagerFactory.init(trustStore);
        return sslContextBuilder.trustManager(trustManagerFactory);
    }

    private SslContextBuilder buildNettySslContextBuilder(ClientSSLConfig sslConfig, SslContextBuilder sslContextBuilder) {
        boolean bl = false;
        ClientSSLConfig.FromClientAndServerCert fromClientAndServerCert = null;
        if (ClientSSLConfig$Default$.MODULE$.equals(sslConfig)) {
            return sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        if (sslConfig instanceof ClientSSLConfig.FromCertFile) {
            String certPath = ((ClientSSLConfig.FromCertFile)sslConfig).certPath();
            FileInputStream certStream = new FileInputStream(certPath);
            return sslContextBuilder.trustManager((InputStream)certStream);
        }
        if (sslConfig instanceof ClientSSLConfig.FromCertResource) {
            String certPath = ((ClientSSLConfig.FromCertResource)sslConfig).certPath();
            InputStream certStream = this.getClass().getClassLoader().getResourceAsStream(certPath);
            return sslContextBuilder.trustManager(certStream);
        }
        if (sslConfig instanceof ClientSSLConfig.FromTrustStoreResource) {
            ClientSSLConfig.FromTrustStoreResource fromTrustStoreResource = (ClientSSLConfig.FromTrustStoreResource)sslConfig;
            String trustStorePath = fromTrustStoreResource.trustStorePath();
            Config.Secret trustStorePassword = fromTrustStoreResource.trustStorePassword();
            InputStream trustStoreStream = this.getClass().getClassLoader().getResourceAsStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        if (sslConfig instanceof ClientSSLConfig.FromClientAndServerCert) {
            bl = true;
            fromClientAndServerCert = (ClientSSLConfig.FromClientAndServerCert)sslConfig;
            ClientSSLConfig serverCertConfig = fromClientAndServerCert.serverCertConfig();
            ClientSSLCertConfig clientSSLCertConfig = fromClientAndServerCert.clientCertConfig();
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertFile) {
                ClientSSLCertConfig.FromClientCertFile fromClientCertFile = (ClientSSLCertConfig.FromClientCertFile)clientSSLCertConfig;
                String certPath = fromClientCertFile.certPath();
                String keyPath = fromClientCertFile.keyPath();
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(certPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(keyPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager((InputStream)certInputStream, (InputStream)keyInputStream);
                }).get();
            }
        }
        if (bl) {
            ClientSSLConfig serverCertConfig = fromClientAndServerCert.serverCertConfig();
            ClientSSLCertConfig clientSSLCertConfig = fromClientAndServerCert.clientCertConfig();
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertResource) {
                ClientSSLCertConfig.FromClientCertResource fromClientCertResource = (ClientSSLCertConfig.FromClientCertResource)clientSSLCertConfig;
                String certPath = fromClientCertResource.certPath();
                String keyPath = fromClientCertResource.keyPath();
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    ClassLoader classLoader = MODULE$.getClass().getClassLoader();
                    InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager(certInputStream, keyInputStream);
                }).get();
            }
        }
        if (sslConfig instanceof ClientSSLConfig.FromTrustStoreFile) {
            ClientSSLConfig.FromTrustStoreFile fromTrustStoreFile = (ClientSSLConfig.FromTrustStoreFile)sslConfig;
            String trustStorePath = fromTrustStoreFile.trustStorePath();
            Config.Secret trustStorePassword = fromTrustStoreFile.trustStorePassword();
            FileInputStream trustStoreStream = new FileInputStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        throw new MatchError((Object)sslConfig);
    }

    public SslContext toNettySSLContext(ClientSSLConfig sslConfig) {
        return this.buildNettySslContextBuilder(sslConfig, SslContextBuilder.forClient()).build();
    }

    private ClientSSLConverter$() {
    }
}

