/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause$;
import zio.Exit;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyResponseEncoder$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.client.NettyRequestEncoder$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0005\rmb!B\u001c9\u0005z\u0002\u0005\u0002\u00034\u0001\u0005+\u0007I\u0011A4\t\u0011=\u0004!\u0011#Q\u0001\n!D\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\tu\u0002\u0011\t\u0012)A\u0005e\"A1\u0010\u0001B\u0001B\u0003-A\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u0013\u0005]\u0001A1A\u0005\f\u0005e\u0001\u0002CA\u0012\u0001\u0001\u0006I!a\u0007\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013%\u0011q\u0005\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0004C\u0006\u0002J\u0001\u0001\r\u0011!Q!\n\u0005%\u0002bCA&\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bB1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002Z!Y\u0011Q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA(\u0011%\ty\u0006\u0001b\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA2\u0011%\ti\b\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BAA\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!$\u0001\t\u0013\tY\tC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0003\u0002\u0012\"A\u0011\u0011\u0014\u0001!\u0002\u0013\t\u0019\nC\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0006bBAe\u0001\u0011%\u00111\u001a\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\t)\u0010\u0001C\u0005\u0003oDqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\t%\u0002\u0001\"\u0003\u0003,!9!1\u0007\u0001\u0005\n\tU\u0002b\u0002B#\u0001\u0011%!q\t\u0005\b\u0005'\u0002A\u0011\u0002B+\u0011%\u0011I\u0006AA\u0001\n\u0003\u0011Y\u0006C\u0005\u0003f\u0001\t\n\u0011\"\u0001\u0003h!I!Q\u0010\u0001\u0012\u0002\u0013\u0005!q\u0010\u0005\n\u0005\u0007\u0003\u0011\u0011!C!\u0005\u000bC\u0011Ba%\u0001\u0003\u0003%\tA!&\t\u0013\tu\u0005!!A\u0005\u0002\t}\u0005\"\u0003BR\u0001\u0005\u0005I\u0011\tBS\u0011%\u0011\u0019\fAA\u0001\n\u0003\u0011)\fC\u0005\u0003:\u0002\t\t\u0011\"\u0011\u0003<\"I!q\u0018\u0001\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0005\u0007\u0004\u0011\u0011!C!\u0005\u000bD\u0011Ba2\u0001\u0003\u0003%\tE!3\b\u000f\t%\b\b#\u0001\u0003l\u001a1q\u0007\u000fE\u0001\u0005[Dq!!\u00031\t\u0003\u0011i\u0010C\u0005\u0003\u0000B\u0012\r\u0011\"\u0001\u0004\u0002!A11\u0003\u0019!\u0002\u0013\u0019\u0019\u0001C\u0005\u0004\u0016A\n\t\u0011\"!\u0004\u0018!I1\u0011\u0005\u0019\u0002\u0002\u0013\u000551\u0005\u0005\n\u0007c\u0001\u0014\u0011!C\u0005\u0007g\u0011AcU3sm\u0016\u0014\u0018J\u001c2pk:$\u0007*\u00198eY\u0016\u0014(BA\u001d;\u0003\u0019\u0019XM\u001d<fe*\u00111\bP\u0001\u0006]\u0016$H/\u001f\u0006\u0003{y\nA\u0001\u001b;ua*\tq(A\u0002{S>\u001cB\u0001A!T3B\u0019!\t\u0013&\u000e\u0003\rS!\u0001R#\u0002\u000f\rD\u0017M\u001c8fY*\u00111H\u0012\u0006\u0002\u000f\u0006\u0011\u0011n\\\u0005\u0003\u0013\u000e\u00131dU5na2,7\t[1o]\u0016d\u0017J\u001c2pk:$\u0007*\u00198eY\u0016\u0014\bCA&R\u001b\u0005a%BA\u001fN\u0015\tqu*A\u0003d_\u0012,7M\u0003\u0002Q\u000b\u00069\u0001.\u00198eY\u0016\u0014\u0018B\u0001*M\u0005)AE\u000f\u001e9PE*,7\r\u001e\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\b!J|G-^2u!\tQ6M\u0004\u0002\\C:\u0011A\fY\u0007\u0002;*\u0011alX\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\ta+\u0003\u0002c+\u00069\u0001/Y2lC\u001e,\u0017B\u00013f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0011W+\u0001\u0004baB\u0014VMZ\u000b\u0002QB\u0011\u0011\u000e\u001c\b\u0003U.l\u0011\u0001O\u0005\u0003EbJ!!\u001c8\u0003\r\u0005\u0003\bOU3g\u0015\t\u0011\u0007(A\u0004baB\u0014VM\u001a\u0011\u0002\r\r|gNZ5h+\u0005\u0011\bCA:x\u001d\t!X/D\u0001=\u0013\t1H(\u0001\u0004TKJ4XM]\u0005\u0003qf\u0014aaQ8oM&<'B\u0001<=\u0003\u001d\u0019wN\u001c4jO\u0002\nQ\u0001\u001e:bG\u0016\u00042!`A\u0002\u001d\rq\u0018\u0011\u0001\b\u00039~L\u0011aP\u0005\u0003EzJA!!\u0002\u0002\b\t)AK]1dK*\u0011!MP\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u00055\u00111CA\u000b)\u0011\ty!!\u0005\u0011\u0005)\u0004\u0001\"B>\u0007\u0001\ba\b\"\u00024\u0007\u0001\u0004A\u0007\"\u00029\u0007\u0001\u0004\u0011\u0018AB;og\u00064W-\u0006\u0002\u0002\u001cA!\u0011QDA\u0010\u001b\u0005q\u0014bAA\u0011}\t1QK\\:bM\u0016\fq!\u001e8tC\u001a,\u0007%A\u0002baB,\"!!\u000b\u0011\u000fQ\fY#a\f\u00026%\u0019\u0011Q\u0006\u001f\u0003\rI{W\u000f^3t!\r!\u0016\u0011G\u0005\u0004\u0003g)&aA!osB\u0019A/a\u000e\n\u0007\u0005eBH\u0001\u0005SKN\u0004xN\\:f\u0003\u001d\t\u0007\u000f]0%KF$B!a\u0010\u0002FA\u0019A+!\u0011\n\u0007\u0005\rSK\u0001\u0003V]&$\b\"CA$\u0015\u0005\u0005\t\u0019AA\u0015\u0003\rAH%M\u0001\u0005CB\u0004\b%A\u0004sk:$\u0018.\\3\u0016\u0005\u0005=\u0003\u0003BA)\u0003'j\u0011AO\u0005\u0004\u0003+R$\u0001\u0004(fiRL(+\u001e8uS6,\u0017a\u0003:v]RLW.Z0%KF$B!a\u0010\u0002\\!I\u0011qI\u0007\u0002\u0002\u0003\u0007\u0011qJ\u0001\teVtG/[7fA\u0005\u0001\u0012N\u001c$mS\u001eDGOU3rk\u0016\u001cHo]\u000b\u0003\u0003G\u0002B!!\u001a\u0002x5\u0011\u0011q\r\u0006\u0005\u0003S\nY'\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003[\ny'\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u001d\u0002t\u0005!Q\u000f^5m\u0015\t\t)(\u0001\u0003kCZ\f\u0017\u0002BA=\u0003O\u0012\u0011\u0002T8oO\u0006#G-\u001a:\u0002#%tg\t\\5hQR\u0014V-];fgR\u001c\b%\u0001\bsK\u0006$7\t\\5f]R\u001cUM\u001d;\u0016\u0005\u0005\u0005\u0005c\u0001+\u0002\u0004&\u0019\u0011QQ+\u0003\u000f\t{w\u000e\\3b]\u0006y!/Z1e\u00072LWM\u001c;DKJ$\b%\u0001\u0006sK\u001a\u0014Xm\u001d5BaB$\"!a\u0010\u0002\u0019\u0015t7/\u001e:f\u0011\u0006\u001c\u0018\t\u001d9\u0002\u001dI,G.Z1tKJ+\u0017/^3tiV\u0011\u00111\u0013\t\u0006)\u0006U\u0015qH\u0005\u0004\u0003/+&!\u0003$v]\u000e$\u0018n\u001c81\u0003=\u0011X\r\\3bg\u0016\u0014V-];fgR\u0004\u0013\u0001D2iC:tW\r\u001c*fC\u0012\u0004DCBA \u0003?\u000bI\u000bC\u0004\u0002\"^\u0001\r!a)\u0002\u0007\r$\b\u0010E\u0002C\u0003KK1!a*D\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDa!a+\u0018\u0001\u0004Q\u0015aA7tO\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0004\u0002@\u0005E\u00161\u0017\u0005\b\u0003CC\u0002\u0019AAR\u0011\u001d\t)\f\u0007a\u0001\u0003o\u000bQaY1vg\u0016\u00042AWA]\u0013\r\tY,\u001a\u0002\n)\"\u0014xn^1cY\u0016\f1#\u00193e\u0003NLhn\u0019\"pIfD\u0015M\u001c3mKJ$B!!1\u0002HB!\u0011\u0011KAb\u0013\r\t)M\u000f\u0002\u0010\u0003NLhn\u0019\"pIf\u0014V-\u00193fe\"9\u0011\u0011U\rA\u0002\u0005\r\u0016\u0001E1ui\u0016l\u0007\u000f\u001e$bgR<&/\u001b;f)\u0019\t\t)!4\u0002P\"9\u0011\u0011\u0015\u000eA\u0002\u0005\r\u0006bBAi5\u0001\u0007\u0011QG\u0001\te\u0016\u001c\bo\u001c8tK\u0006\u0001\u0012\r\u001e;f[B$h)\u001e7m/JLG/\u001a\u000b\u000b\u0003/\f)/a:\u0002j\u0006-\b#B?\u0002Z\u0006u\u0017\u0002BAn\u0003\u000f\u0011A\u0001V1tWB)A+a8\u0002d&\u0019\u0011\u0011]+\u0003\r=\u0003H/[8o!\u0015i\u0018\u0011\\A \u0011\u001d\t\tk\u0007a\u0001\u0003GCq!a\u0013\u001c\u0001\u0004\ty\u0005C\u0004\u0002Rn\u0001\r!!\u000e\t\u000f\u000558\u00041\u0001\u0002p\u00069!/Z9vKN$\bc\u0001;\u0002r&\u0019\u00111\u001f\u001f\u0003\u000fI+\u0017/^3ti\u0006)\u0012\r\u001e;f[B$\u0018*\\7fI&\fG/Z,sSR,GCBAA\u0003s\fY\u0010C\u0004\u0002\"r\u0001\r!a)\t\u000f\u0005uH\u00041\u0001\u0002\u0000\u0006!Q\r_5u!)\tiB!\u0001\u00020\u0005U\u0012QG\u0005\u0004\u0005\u0007q$a\u0001.J\u001f\u0006qQ.Y6f5&|'+Z9vKN$HCBAx\u0005\u0013\u0011Y\u0001C\u0004\u0002\"v\u0001\r!a)\t\u000f\t5Q\u00041\u0001\u0003\u0010\u0005Aa.\u001a;usJ+\u0017\u000fE\u0002L\u0005#I1Aa\u0005M\u0005-AE\u000f\u001e9SKF,Xm\u001d;\u0002%U\u0004xM]1eKR{w+\u001a2T_\u000e\\W\r\u001e\u000b\u000b\u0003G\u0014IBa\u0007\u0003\u001e\t\u001d\u0002bBAQ=\u0001\u0007\u00111\u0015\u0005\b\u0003[t\u0002\u0019AAx\u0011\u001d\u0011yB\ba\u0001\u0005C\tAb^3c'>\u001c7.\u001a;BaB\u0004R\u0001\u001eB\u0012\u0003_I1A!\n=\u000519VMY*pG.,G/\u00119q\u0011\u001d\tYE\ba\u0001\u0003\u001f\nQb\u001e:ji\u0016tu\u000e\u001e$pk:$GCBA \u0005[\u0011y\u0003C\u0004\u0002\"~\u0001\r!a)\t\u000f\tEr\u00041\u0001\u0002p\u0006\u0019!/Z9\u0002\u001b]\u0014\u0018\u000e^3SKN\u0004xN\\:f))\u00119D!\u0010\u0003@\t\u0005#1\t\u000b\u0005\u0003\u007f\u0011I\u0004C\u0004\u0003<\u0001\u0002\r!a%\u0002\u000f\u0015t7/\u001e:fI\"9\u0011\u0011\u0015\u0011A\u0002\u0005\r\u0006bBA&A\u0001\u0007\u0011q\n\u0005\b\u0003{\u0004\u0003\u0019AA\u0000\u0011\u001d\u0011\t\u0004\ta\u0001\u0003_\f1\"\u001b8uKJ\u0014X\u000f\u001d;fIR!!\u0011\nB)!)\tiB!\u0001\u00020\t-\u0013q\b\t\u0004)\n5\u0013b\u0001B(+\n9aj\u001c;iS:<\u0007bBAQC\u0001\u0007\u00111U\u0001\u0019o&$\b\u000eR3gCVdG/\u0012:s_J\u0014Vm\u001d9p]N,G\u0003BA\u001b\u0005/Bq!!.#\u0001\u0004\t9,\u0001\u0003d_BLHC\u0002B/\u0005C\u0012\u0019\u0007\u0006\u0003\u0002\u0010\t}\u0003\"B>$\u0001\ba\bb\u00024$!\u0003\u0005\r\u0001\u001b\u0005\ba\u000e\u0002\n\u00111\u0001s\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u001b+\u0007!\u0014Yg\u000b\u0002\u0003nA!!q\u000eB=\u001b\t\u0011\tH\u0003\u0003\u0003t\tU\u0014!C;oG\",7m[3e\u0015\r\u00119(V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B>\u0005c\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!!+\u0007I\u0014Y'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u000f\u0003BA!#\u0003\u00106\u0011!1\u0012\u0006\u0005\u0005\u001b\u000b\u0019(\u0001\u0003mC:<\u0017\u0002\u0002BI\u0005\u0017\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001BL!\r!&\u0011T\u0005\u0004\u00057+&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0018\u0005CC\u0011\"a\u0012)\u0003\u0003\u0005\rAa&\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa*\u0011\r\t%&qVA\u0018\u001b\t\u0011YKC\u0002\u0003.V\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tLa+\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\u00139\fC\u0005\u0002H)\n\t\u00111\u0001\u00020\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u00119I!0\t\u0013\u0005\u001d3&!AA\u0002\t]\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t]\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u001d\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0002\n-\u0007\"CA$]\u0005\u0005\t\u0019AA\u0018Q\r\u0001!q\u001a\t\u0005\u0005#\u0014\u0019O\u0004\u0003\u0003T\n}g\u0002\u0002Bk\u0005;tAAa6\u0003\\:\u0019AL!7\n\u0003\u001dK!a\u000f$\n\u0005\u0011+\u0015b\u0001Bq\u0007\u0006q1\t[1o]\u0016d\u0007*\u00198eY\u0016\u0014\u0018\u0002\u0002Bs\u0005O\u0014\u0001b\u00155be\u0006\u0014G.\u001a\u0006\u0004\u0005C\u001c\u0015\u0001F*feZ,'/\u00138c_VtG\rS1oI2,'\u000f\u0005\u0002kaM)\u0001Ga<\u0003vB\u0019AK!=\n\u0007\tMXK\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005o\u0014Y0\u0004\u0002\u0003z*\u0019q)a\u001d\n\u0007\u0011\u0014I\u0010\u0006\u0002\u0003l\u0006!A.\u001b<f+\t\u0019\u0019\u0001\u0005\u0006\u0002\u001e\r\u00151\u0011\u0002B&\u0003\u001fI1aa\u0002?\u0005\u0019QF*Y=feB)Qpa\u0003ie&!1QBB\b\u0005\u0011!\u0013-\u001c9\n\u0007\rEaH\u0001\fJ]R,'o]3di&|g\u000eV=qK\u000e{W\u000e]1u\u0003\u0015a\u0017N^3!\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0019Ib!\b\u0004 Q!\u0011qBB\u000e\u0011\u0015YH\u0007q\u0001}\u0011\u00151G\u00071\u0001i\u0011\u0015\u0001H\u00071\u0001s\u0003\u001d)h.\u00199qYf$Ba!\n\u0004.A)A+a8\u0004(A)Ak!\u000bie&\u001911F+\u0003\rQ+\b\u000f\\33\u0011%\u0019y#NA\u0001\u0002\u0004\ty!A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\u000e\u0011\t\t%5qG\u0005\u0005\u0007s\u0011YI\u0001\u0004PE*,7\r\u001e")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
Serializable {
    private final AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Routes<Object, Response> app;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;
    private final Function0<BoxedUnit> releaseRequest;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Server.Config>> unapply(ServerInboundHandler x$0) {
        return ServerInboundHandler$.MODULE$.unapply(x$0);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return ServerInboundHandler$.MODULE$.apply(appRef, config, trace);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    private Unsafe unsafe() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 51");
        }
        return this.unsafe;
    }

    private Routes<Object, Response> app() {
        return this.app;
    }

    private void app_$eq(Routes<Object, Response> x$1) {
        this.app = x$1;
    }

    private NettyRuntime runtime() {
        return this.runtime;
    }

    private void runtime_$eq(NettyRuntime x$1) {
        this.runtime = x$1;
    }

    public LongAdder inFlightRequests() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 56");
        }
        return this.inFlightRequests;
    }

    private boolean readClientCert() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 57");
        }
        return this.readClientCert;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.app_$eq((Routes)pair._1());
        this.runtime_$eq(new NettyRuntime((Runtime<Object>)((Runtime)pair._2())));
    }

    private void ensureHasApp() {
        if (this.runtime() == null) {
            this.refreshApp();
            return;
        }
    }

    private Function0<BoxedUnit> releaseRequest() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 72");
        }
        return this.releaseRequest;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.inFlightRequests().increment();
            this.ensureHasApp();
            try {
                if (httpRequest.decoderResult().isFailure()) {
                    Throwable throwable = httpRequest.decoderResult().cause();
                    this.attemptFastWrite(ctx, Response$.MODULE$.fromThrowable(throwable));
                    this.releaseRequest().apply$mcV$sp();
                } else {
                    Request req = this.makeZioRequest(ctx, httpRequest);
                    ZIO<Object, Response, Response> exit = this.app().apply(req, (.less.colon.less<Response, Response>)$less$colon$less$.MODULE$.refl());
                    if (this.attemptImmediateWrite(ctx, exit)) {
                        this.releaseRequest().apply$mcV$sp();
                    } else {
                        this.writeResponse(ctx, this.runtime(), exit, req, this.releaseRequest());
                    }
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)httpRequest);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String msg;
        if (cause instanceof IOException && (msg = ((IOException)cause).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.runtime() != null) {
            NettyRuntime qual$1 = this.runtime();
            JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> {};
            boolean x$3 = qual$1.run$default$3();
            ZIO x$4 = ZIO$.MODULE$.logWarningCause((Function0 & Serializable)() -> "Fatal exception in Netty", (Function0 & Serializable)() -> Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()), this.trace).when((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.config().logWarningOnFatalError(), this.trace);
            qual$1.run(ctx, (Function0<BoxedUnit>)x$2, x$3, (ZIO<Object, Throwable, Object>)x$4, this.unsafe(), this.trace);
        }
        if (cause instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            try {
                return this.fastEncode$1(response, unsafeBytes.unsafeAsArray(this.unsafe()), ctx);
            }
            catch (Throwable throwable) {
                if (NonFatal$.MODULE$.apply(throwable)) {
                    return this.fastEncode$1(this.withDefaultErrorResponse(throwable), Array$.MODULE$.emptyByteArray(), ctx);
                }
                throw throwable;
            }
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, Request request) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> socketApp = ((Body.WebsocketBody)body).socketApp();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (status != null && status.equals(status$SwitchingProtocols$)) {
                return this.upgradeToWebSocket(ctx, request, socketApp, runtime).as((Function0 & Serializable)() -> None$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(response, this.unsafe());
            if (!(jResponse instanceof FullHttpResponse)) {
                Some some;
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (string == null) {
                            some = None$.MODULE$;
                            break;
                        }
                    }
                    default: {
                        some = new Some((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(string))));
                    }
                }
                Some contentLength = some;
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, $this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, ZIO<Object, Response, Response> exit) {
        Response response;
        if (exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null) {
            return this.attemptFastWrite(ctx, response);
        }
        return false;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version$Http_1_0$ protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            none$2 = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates()));
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<String> contentTypeHeader = headers.headers().get(Header$ContentType$.MODULE$.name());
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            Body x$1 = NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content(), contentTypeHeader);
            Method x$3 = Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method());
            URL x$4 = (URL)URL$.MODULE$.decode(fullHttpRequest.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty());
            return new Request(protocolVersion, x$3, x$4, headers, x$1, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.length()));
        AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
        Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable)async -> {
            handler.connect(async);
            return BoxedUnit.UNIT;
        }, (Option<Object>)knownContentLength, contentTypeHeader);
        Method x$10 = Conversions$.MODULE$.methodFromNetty(nettyReq.method());
        URL x$11 = (URL)URL$.MODULE$.decode(nettyReq.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty());
        return new Request(protocolVersion, x$10, x$11, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, Request request, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        return Queue$.MODULE$.unbounded(this.trace).tap((Function1 & Serializable)queue -> ZIO$.MODULE$.suspend((Function0 & Serializable)() -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx.channel());
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue);
            return webSocketApp.handler().runZIO(webSocketChannel).ignoreLogged($this.trace).forkDaemon($this.trace);
        }, $this.trace), this.trace).flatMap((Function1 & Serializable)queue -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse((Function0 & Serializable)() -> this.config().webSocketConfig())).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, $this.trace));
            HttpRequest jReq = NettyRequestEncoder$.MODULE$.encode(request);
            ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)jReq));
        }, $this.trace), this.trace);
    }

    private void writeNotFound(ChannelHandlerContext ctx, Request req) {
        Response response = Response$.MODULE$.notFound(req.url().encode());
        this.attemptFastWrite(ctx, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Object, Response, Response> exit, Request req, Function0<BoxedUnit> ensured) {
        runtime.run(ctx, ensured, runtime.run$default$3(), (ZIO<Object, Throwable, Object>)exit.sandbox(this.trace).catchAll((Function1 & Serializable)error -> (ZIO)error.failureOrCause().fold((Function1 & Serializable)response -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> response, $this.trace), (Function1 & Serializable)cause -> {
            if (cause.isInterruptedOnly()) {
                return this.interrupted(ctx).as((Function0 & Serializable)() -> null, $this.trace);
            }
            return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> this.withDefaultErrorResponse((Throwable)new FiberFailure(cause)), $this.trace);
        }), CanFail$.MODULE$.canFail(), this.trace).flatMap((Function1 & Serializable)response -> ZIO$.MODULE$.suspend((Function0 & Serializable)() -> {
            if (response != null) {
                if (!this.attemptFastWrite(ctx, (Response)response)) {
                    return this.attemptFullWrite(ctx, runtime, (Response)response, req);
                }
                return ZIO$.MODULE$.none();
            }
            if (ctx.channel().isOpen()) {
                this.writeNotFound(ctx, req);
            }
            return ZIO$.MODULE$.none();
        }, $this.trace).foldCauseZIO((Function1 & Serializable)cause -> ZIO$.MODULE$.attempt((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.attemptFastWrite(ctx, this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl())))), $this.trace), (Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return ZIO$.MODULE$.unit();
            }
            if (x0$1 instanceof Some) {
                return ((ZIO)((Some)x0$1).value()).orElse((Function0 & Serializable)() -> ZIO$.MODULE$.attempt((Function0 & Serializable)() -> ctx.close(), $this.trace), CanFail$.MODULE$.canFail(), $this.trace);
            }
            throw new MatchError(x0$1);
        }, $this.trace), this.trace), this.unsafe(), this.trace);
    }

    private ZIO<Object, Nothing$, BoxedUnit> interrupted(ChannelHandlerContext ctx) {
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> ctx.channel().close(), this.trace).unit(this.trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public String productElementName(int x$1) {
        switch (x$1) {
            case 0: {
                return "appRef";
            }
            case 1: {
                return "config";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof ServerInboundHandler)) break block3;
                ServerInboundHandler serverInboundHandler = (ServerInboundHandler)x$1;
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
                if (atomicReference != null ? !atomicReference.equals(atomicReference2) : atomicReference2 != null) break block3;
                Server.Config config = this.config();
                Server.Config config2 = serverInboundHandler.config();
                if (config != null ? !((Object)config).equals(config2) : config2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final boolean fastEncode$1(Response response, byte[] bytes, ChannelHandlerContext ctx$1) {
        FullHttpResponse djResponse = NettyResponseEncoder$.MODULE$.fastEncode(response, bytes, this.unsafe()).retainedDuplicate();
        ctx$1.writeAndFlush((Object)djResponse, ctx$1.voidPromise());
        return true;
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.inFlightRequests = new LongAdder();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.includeClientCert()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.releaseRequest = (JFunction0.mcV.sp & Serializable)() -> this.inFlightRequests().decrement();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

