/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.Unsafe$;
import zio.ZIO$;
import zio.http.codec.TextBinaryCodec$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.annotation.simpleEnum;
import zio.schema.codec.BinaryCodec;
import zio.schema.codec.DecodeError;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class TextBinaryCodec$ {
    public static final TextBinaryCodec$ MODULE$ = new TextBinaryCodec$();

    private <A> BinaryCodec<A> errorCodec(Schema<A> schema) {
        return new BinaryCodec<A>(schema){
            private final Schema schema$1;

            public Either<DecodeError, A> decode(Chunk<Object> whole) {
                throw new IllegalArgumentException(new StringBuilder(44).append("Schema ").append(this.schema$1).append(" is not supported by TextBinaryCodec.").toString());
            }

            public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                throw new IllegalArgumentException(new StringBuilder(44).append("Schema ").append(this.schema$1).append(" is not supported by TextBinaryCodec.").toString());
            }

            public Chunk<Object> encode(A value) {
                throw new IllegalArgumentException(new StringBuilder(44).append("Schema ").append(this.schema$1).append(" is not supported by TextBinaryCodec.").toString());
            }

            public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                throw new IllegalArgumentException(new StringBuilder(44).append("Schema ").append(this.schema$1).append(" is not supported by TextBinaryCodec.").toString());
            }
            {
                this.schema$1 = schema$1;
            }
        };
    }

    public <A> BinaryCodec<A> fromSchema(Schema<A> schema) {
        while (true) {
            boolean bl = false;
            Schema.Enum enum_ = null;
            boolean bl2 = false;
            Schema.Record record = null;
            if (schema instanceof Schema.Optional) {
                Schema schema2 = ((Schema.Optional)schema).schema();
                BinaryCodec<A> codec2 = this.fromSchema(schema2);
                return new BinaryCodec<A>(codec2){
                    private final BinaryCodec codec$1;

                    public Chunk<Object> encode(A a) {
                        if (a instanceof Some) {
                            Object value = ((Some)a).value();
                            return (Chunk)this.codec$1.encode(value);
                        }
                        if (None$.MODULE$.equals(a)) {
                            return Chunk$.MODULE$.empty();
                        }
                        throw new MatchError(a);
                    }

                    public Either<DecodeError, A> decode(Chunk<Object> c) {
                        if (c.isEmpty()) {
                            return new Right((Object)None$.MODULE$);
                        }
                        return this.codec$1.decode(c).map((Function1 & Serializable)x$1 -> new Some(x$1));
                    }

                    public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                        return ZPipeline$.MODULE$.map((Function1 & Serializable)a -> this.encode((A)a), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:50)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:50)");
                    }

                    public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                        return this.codec$1.streamDecoder().map((Function1 & Serializable)v -> new Some(v), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:52)");
                    }
                    {
                        this.codec$1 = codec$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$1(java.lang.Object ), $anonfun$streamDecoder$1(java.lang.Object ), $anonfun$streamEncoder$1(zio.http.codec.TextBinaryCodec$$anon$2 java.lang.Object )}, serializedLambda);
                    }
                };
            }
            if (schema instanceof Schema.Enum) {
                bl = true;
                enum_ = (Schema.Enum)schema;
                if (enum_.annotations().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TextBinaryCodec$.$anonfun$fromSchema$1(x$2)))) {
                    BinaryCodec<A> stringCodec = this.fromSchema((Schema<A>)new Schema.Primitive((StandardType)StandardType.StringType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2()));
                    Map caseMap = enum_.nonTransientCases().map((Function1 & Serializable)case_ -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((Schema.CaseClass0)case_.schema()).defaultConstruct().apply()), (Object)case_.caseName())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    Map reverseCaseMap = (Map)caseMap.map((Function1 & Serializable)x$3 -> x$3.swap());
                    return new BinaryCodec<A>(caseMap, stringCodec, reverseCaseMap, enum_){
                        private final Map caseMap$1;
                        private final BinaryCodec stringCodec$1;
                        private final Map reverseCaseMap$1;
                        private final Schema.Enum x4$1;

                        public Chunk<Object> encode(A a) {
                            String caseName = (String)this.caseMap$1.apply(a);
                            return (Chunk)this.stringCodec$1.encode((Object)caseName);
                        }

                        public Either<DecodeError, A> decode(Chunk<Object> c) {
                            return this.stringCodec$1.decode(c).flatMap((Function1 & Serializable)caseName -> {
                                Option option = $this.reverseCaseMap$1.get(caseName);
                                if (option instanceof Some) {
                                    Object value = ((Some)option).value();
                                    return new Right(value);
                                }
                                if (None$.MODULE$.equals(option)) {
                                    return new Left((Object)new DecodeError.MissingCase(caseName, $this.x4$1));
                                }
                                throw new MatchError((Object)option);
                            });
                        }

                        public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                            return ZPipeline$.MODULE$.map((Function1 & Serializable)a -> this.encode((A)a), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:77)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:77)");
                        }

                        public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                            return this.stringCodec$1.streamDecoder().mapZIO((Function1 & Serializable)caseName -> {
                                Option option = $this.reverseCaseMap$1.get(caseName);
                                if (option instanceof Some) {
                                    Object value = ((Some)option).value();
                                    return ZIO$.MODULE$.succeed((Function0 & Serializable)() -> value, (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:81)");
                                }
                                if (None$.MODULE$.equals(option)) {
                                    return ZIO$.MODULE$.fail((Function0 & Serializable)() -> new DecodeError.MissingCase(caseName, $this.x4$1), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:82)");
                                }
                                throw new MatchError((Object)option);
                            }, (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:79)");
                        }
                        {
                            this.caseMap$1 = caseMap$1;
                            this.stringCodec$1 = stringCodec$1;
                            this.reverseCaseMap$1 = reverseCaseMap$1;
                            this.x4$1 = x4$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$2(zio.http.codec.TextBinaryCodec$$anon$3 java.lang.String ), $anonfun$streamDecoder$2(zio.http.codec.TextBinaryCodec$$anon$3 java.lang.String ), $anonfun$streamDecoder$3(java.lang.Object ), $anonfun$streamDecoder$4(zio.http.codec.TextBinaryCodec$$anon$3 java.lang.String ), $anonfun$streamEncoder$2(zio.http.codec.TextBinaryCodec$$anon$3 java.lang.Object )}, serializedLambda);
                        }
                    };
                }
            }
            if (bl) {
                return this.errorCodec((Schema<A>)enum_);
            }
            if (schema instanceof Schema.Record) {
                bl2 = true;
                record = (Schema.Record)schema;
                if (record.fields().size() == 1) {
                    Schema fieldSchema = ((Schema.Field)record.fields().head()).schema();
                    BinaryCodec<A> codec3 = this.fromSchema(fieldSchema);
                    return new BinaryCodec<A>(codec3, record){
                        private final BinaryCodec codec$2;
                        private final Schema.Record x6$1;

                        public Chunk<Object> encode(A a) {
                            return (Chunk)this.codec$2.encode(((Option)this.x6$1.deconstruct(a, Unsafe$.MODULE$.unsafe()).head()).get());
                        }

                        public Either<DecodeError, A> decode(Chunk<Object> c) {
                            return this.codec$2.decode(c).flatMap((Function1 & Serializable)a -> $this.x6$1.construct(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{a})), Unsafe$.MODULE$.unsafe()).left().map((Function1 & Serializable)s -> new DecodeError.ReadError(Cause$.MODULE$.empty(), s)));
                        }

                        public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                            return ZPipeline$.MODULE$.map((Function1 & Serializable)a -> this.encode((A)a), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:101)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:101)");
                        }

                        public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                            return this.codec$2.streamDecoder().mapZIO((Function1 & Serializable)a -> ZIO$.MODULE$.fromEither((Function0 & Serializable)() -> $this.x6$1.construct(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{a})), Unsafe$.MODULE$.unsafe()).left().map((Function1 & Serializable)s -> new DecodeError.ReadError(Cause$.MODULE$.empty(), s)), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:104)"), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:103)");
                        }
                        {
                            this.codec$2 = codec$2;
                            this.x6$1 = x6$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$3(zio.http.codec.TextBinaryCodec$$anon$4 java.lang.Object ), $anonfun$decode$4(java.lang.String ), $anonfun$streamDecoder$5(zio.http.codec.TextBinaryCodec$$anon$4 java.lang.Object ), $anonfun$streamDecoder$6(zio.http.codec.TextBinaryCodec$$anon$4 java.lang.Object ), $anonfun$streamDecoder$7(java.lang.String ), $anonfun$streamEncoder$3(zio.http.codec.TextBinaryCodec$$anon$4 java.lang.Object )}, serializedLambda);
                        }
                    };
                }
            }
            if (bl2) {
                return this.errorCodec((Schema<A>)record);
            }
            if (schema instanceof Schema.Collection) {
                Schema.Collection collection = (Schema.Collection)schema;
                return this.errorCodec((Schema<A>)collection);
            }
            if (schema instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema;
                Schema schema3 = transform.schema();
                Function1 f = transform.f();
                Function1 g = transform.g();
                BinaryCodec<A> codec4 = this.fromSchema(schema3);
                return new BinaryCodec<A>(codec4, g, f){
                    private final BinaryCodec codec$3;
                    private final Function1 g$1;
                    private final Function1 f$1;

                    public Chunk<Object> encode(A a) {
                        return (Chunk)this.codec$3.encode(((Either)this.g$1.apply(a)).fold((Function1 & Serializable)e -> {
                            throw new Exception((String)e);
                        }, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x)));
                    }

                    public Either<DecodeError, A> decode(Chunk<Object> c) {
                        return this.codec$3.decode(c).flatMap((Function1 & Serializable)x -> ((Either)$this.f$1.apply(x)).left().map((Function1 & Serializable)x$4 -> new DecodeError.ReadError(Cause$.MODULE$.fail((Object)new Exception("Error during decoding"), Cause$.MODULE$.fail$default$2()), x$4)));
                    }

                    public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                        return ZPipeline$.MODULE$.mapChunks((Function1 & Serializable)x$5 -> x$5.flatMap((Function1 & Serializable)a -> this.encode((A)a)), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:122)");
                    }

                    public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                        return this.codec$3.streamDecoder().map((Function1 & Serializable)x -> {
                            Either either = (Either)$this.f$1.apply(x);
                            if (either instanceof Left) {
                                String value = (String)((Left)either).value();
                                throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)new Exception("Error in decoding"), Cause$.MODULE$.fail$default$2()), value);
                            }
                            if (either instanceof Right) {
                                return ((Right)either).value();
                            }
                            throw new MatchError((Object)either);
                        }, (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:123)");
                    }
                    {
                        this.codec$3 = codec$3;
                        this.g$1 = g$1;
                        this.f$1 = f$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$5(zio.http.codec.TextBinaryCodec$$anon$5 java.lang.Object ), $anonfun$decode$6(java.lang.String ), $anonfun$encode$1(java.lang.String ), $anonfun$encode$2(java.lang.Object ), $anonfun$streamDecoder$8(zio.http.codec.TextBinaryCodec$$anon$5 java.lang.Object ), $anonfun$streamEncoder$4(zio.http.codec.TextBinaryCodec$$anon$5 zio.Chunk ), $anonfun$streamEncoder$5(zio.http.codec.TextBinaryCodec$$anon$5 java.lang.Object )}, serializedLambda);
                    }
                };
            }
            if (schema instanceof Schema.Primitive) {
                return new BinaryCodec<A>(schema){
                    private final Function1<String, Either<DecodeError, Object>> decode0;
                    private volatile boolean bitmap$init$0;
                    private final Schema schema$2;

                    private Function1<String, Either<DecodeError, Object>> decode0() {
                        if (!this.bitmap$init$0) {
                            throw new UninitializedFieldError("Uninitialized field: TextBinaryCodec.scala: 132");
                        }
                        return this.decode0;
                    }

                    public Chunk<Object> encode(A a) {
                        if (this.schema$2 instanceof Schema.Primitive) {
                            return Chunk$.MODULE$.fromArray((Object)a.toString().getBytes());
                        }
                        throw new IllegalArgumentException(new StringBuilder(36).append("Cannot encode ").append(a).append(" of type ").append(a.getClass()).append(" with schema ").append(this.schema$2).toString());
                    }

                    public Either<DecodeError, A> decode(Chunk<Object> c) {
                        return ((Either)this.decode0().apply((Object)c.asString(Chunk.IsText$.MODULE$.byteIsText()))).map((Function1 & Serializable)x$9 -> x$9);
                    }

                    public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                        return ZPipeline$.MODULE$.map((Function1 & Serializable)a -> Chunk$.MODULE$.fromArray((Object)a.toString().getBytes()), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:355)").flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamEncoder(TextBinaryCodec.scala:355)");
                    }

                    public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                        return ZPipeline$.MODULE$.apply((Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:358)").$greater$greater$greater((Function0 & Serializable)() -> ZPipeline$.MODULE$.utf8Decode((Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:358)"), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:358)").map((Function1 & Serializable)s -> this.decode((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)s.getBytes())).fold((Function1 & Serializable)x$10 -> {
                            throw (Throwable)x$10;
                        }, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x)), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:359)").mapErrorCause((Function1 & Serializable)e -> Cause$.MODULE$.fail((Object)new DecodeError.ReadError(e, e.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl())).getMessage()), Cause$.MODULE$.fail$default$2()), (Object)"zio.http.codec.TextBinaryCodec.fromSchema.$anon.streamDecoder(TextBinaryCodec.scala:360)");
                    }

                    public static final /* synthetic */ Right $anonfun$decode0$1(Right result$1, String x$6) {
                        return result$1;
                    }

                    public static final /* synthetic */ Left $anonfun$decode0$10(Left result$2, String x$7) {
                        return result$2;
                    }

                    public static final /* synthetic */ Left $anonfun$decode0$32(Left result$3, String x$8) {
                        return result$3;
                    }
                    {
                        Function1 & Serializable intersect;
                        this.schema$2 = schema$2;
                        if (schema$2 instanceof Schema.Primitive) {
                            StandardType standardType = ((Schema.Primitive)schema$2).standardType();
                            if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                                intersect = arg_0 -> anon.6.$anonfun$decode0$1(new Right((Object)""), arg_0);
                            } else if (StandardType.StringType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> new Right(s);
                            } else if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    block14: {
                                        block15: {
                                            String string = s.toLowerCase();
                                            switch (string == null ? 0 : string.hashCode()) {
                                                case 48: {
                                                    if (!"0".equals(string)) break block14;
                                                    break block15;
                                                }
                                                case 49: {
                                                    if ("1".equals(string)) {
                                                        break;
                                                    }
                                                    break block14;
                                                }
                                                case 3521: {
                                                    if (!"no".equals(string)) break block14;
                                                    break block15;
                                                }
                                                case 3551: {
                                                    if ("on".equals(string)) {
                                                        break;
                                                    }
                                                    break block14;
                                                }
                                                case 109935: {
                                                    if (!"off".equals(string)) break block14;
                                                    break block15;
                                                }
                                                case 119527: {
                                                    if ("yes".equals(string)) {
                                                        break;
                                                    }
                                                    break block14;
                                                }
                                                case 3569038: {
                                                    if ("true".equals(string)) {
                                                        break;
                                                    }
                                                    break block14;
                                                }
                                                case 97196323: {
                                                    if (!"false".equals(string)) break block14;
                                                    break block15;
                                                }
                                                default: {
                                                    break block14;
                                                }
                                            }
                                            return new Right((Object)BoxesRunTime.boxToBoolean((boolean)true));
                                        }
                                        return new Right((Object)BoxesRunTime.boxToBoolean((boolean)false));
                                    }
                                    return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s));
                                };
                            } else if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(s))));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(s))));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.IntType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LongType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s))));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s))));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s))));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                                intersect = arg_0 -> anon.6.$anonfun$decode0$10(new Left((Object)new DecodeError.UnsupportedSchema(schema$2, "TextCodec")), arg_0);
                            } else if (StandardType.CharType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> new Right((Object)BoxesRunTime.boxToCharacter((char)s.charAt(0)));
                            } else if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)UUID.fromString(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)package$.MODULE$.BigDecimal().apply(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)package$.MODULE$.BigInt().apply(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)DayOfWeek.valueOf(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)Month.valueOf(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)MonthDay.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)Period.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.YearType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)Year.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)YearMonth.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)ZoneId.of(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)ZoneOffset.of(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)Duration.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.InstantType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)Instant.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)LocalDate.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)LocalTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)LocalDateTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)OffsetTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)OffsetDateTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) {
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)ZonedDateTime.parse(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            } else {
                                if (!StandardType.CurrencyType$.MODULE$.equals(standardType)) throw new MatchError((Object)standardType);
                                intersect = (Function1 & Serializable)s -> {
                                    try {
                                        return new Right((Object)Currency.getInstance(s));
                                    }
                                    catch (Exception e) {
                                        return new Left((Object)new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage()));
                                    }
                                };
                            }
                        } else {
                            intersect = arg_0 -> anon.6.$anonfun$decode0$32(new Left((Object)new DecodeError.UnsupportedSchema(schema$2, "Only primitive types are supported for text decoding.")), arg_0);
                        }
                        this.decode0 = intersect;
                        this.bitmap$init$0 = true;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decode$7(java.lang.Object ), $anonfun$decode0$1(scala.util.Right java.lang.String ), $anonfun$decode0$10(scala.util.Left java.lang.String ), $anonfun$decode0$11(java.lang.String ), $anonfun$decode0$12(java.lang.String ), $anonfun$decode0$13(java.lang.String ), $anonfun$decode0$14(java.lang.String ), $anonfun$decode0$15(java.lang.String ), $anonfun$decode0$16(java.lang.String ), $anonfun$decode0$17(java.lang.String ), $anonfun$decode0$18(java.lang.String ), $anonfun$decode0$19(java.lang.String ), $anonfun$decode0$2(java.lang.String ), $anonfun$decode0$20(java.lang.String ), $anonfun$decode0$21(java.lang.String ), $anonfun$decode0$22(java.lang.String ), $anonfun$decode0$23(java.lang.String ), $anonfun$decode0$24(java.lang.String ), $anonfun$decode0$25(java.lang.String ), $anonfun$decode0$26(java.lang.String ), $anonfun$decode0$27(java.lang.String ), $anonfun$decode0$28(java.lang.String ), $anonfun$decode0$29(java.lang.String ), $anonfun$decode0$3(java.lang.String ), $anonfun$decode0$30(java.lang.String ), $anonfun$decode0$31(java.lang.String ), $anonfun$decode0$32(scala.util.Left java.lang.String ), $anonfun$decode0$4(java.lang.String ), $anonfun$decode0$5(java.lang.String ), $anonfun$decode0$6(java.lang.String ), $anonfun$decode0$7(java.lang.String ), $anonfun$decode0$8(java.lang.String ), $anonfun$decode0$9(java.lang.String ), $anonfun$streamDecoder$10(zio.http.codec.TextBinaryCodec$$anon$6 java.lang.String ), $anonfun$streamDecoder$11(zio.schema.codec.DecodeError ), $anonfun$streamDecoder$12(java.lang.Object ), $anonfun$streamDecoder$13(zio.Cause ), $anonfun$streamDecoder$9(), $anonfun$streamEncoder$6(java.lang.Object )}, serializedLambda);
                    }
                };
            }
            if (!(schema instanceof Schema.Lazy)) break;
            schema = (Schema)((Schema.Lazy)schema).schema0$access$0().apply();
        }
        return this.errorCodec(schema);
    }

    public static final /* synthetic */ boolean $anonfun$fromSchema$1(Object x$2) {
        return x$2 instanceof simpleEnum;
    }

    private TextBinaryCodec$() {
    }
}

