/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Exit;
import zio.Exit$;
import zio.FiberFailure;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ErrorResponseConfig$;
import zio.http.Header;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.NettyResponseEncoder$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0005\rmb!B\u001c9\u0005z\u0002\u0005\u0002\u00034\u0001\u0005+\u0007I\u0011A4\t\u0011=\u0004!\u0011#Q\u0001\n!D\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\tu\u0002\u0011\t\u0012)A\u0005e\"A1\u0010\u0001B\u0001B\u0003-A\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u0013\u0005]\u0001A1A\u0005\f\u0005e\u0001\u0002CA\u0012\u0001\u0001\u0006I!a\u0007\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013%\u0011q\u0005\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0004C\u0006\u0002J\u0001\u0001\r\u0011!Q!\n\u0005%\u0002bCA&\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bB1\"a\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002Z!Y\u0011Q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA(\u0011%\ty\u0006\u0001b\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA2\u0011%\ti\b\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BAA\u0011%\tI\t\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BAA\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!%\u0001\t\u0013\ty\tC\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u0011Q\u0014\u0001!\u0002\u0013\t9\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003C\u0004A\u0011BAr\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqA!\u0006\u0001\t\u0013\u00119\u0002C\u0004\u0003&\u0001!IAa\n\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!Q\n\u0001\u0005\n\t=\u0003\"\u0003B*\u0001\u0005\u0005I\u0011\u0001B+\u0011%\u0011y\u0006AI\u0001\n\u0003\u0011\t\u0007C\u0005\u0003x\u0001\t\n\u0011\"\u0001\u0003z!I!Q\u0010\u0001\u0002\u0002\u0013\u0005#q\u0010\u0005\n\u0005\u001b\u0003\u0011\u0011!C\u0001\u0005\u001fC\u0011Ba&\u0001\u0003\u0003%\tA!'\t\u0013\tu\u0005!!A\u0005B\t}\u0005\"\u0003BW\u0001\u0005\u0005I\u0011\u0001BX\u0011%\u0011\u0019\fAA\u0001\n\u0003\u0012)\fC\u0005\u0003:\u0002\t\t\u0011\"\u0011\u0003<\"I!Q\u0018\u0001\u0002\u0002\u0013\u0005#q\u0018\u0005\n\u0005\u0003\u0004\u0011\u0011!C!\u0005\u0007<qAa99\u0011\u0003\u0011)O\u0002\u00048q!\u0005!q\u001d\u0005\b\u0003\u0013\u0001D\u0011\u0001B|\u0011%\u0011I\u0010\rb\u0001\n\u0003\u0011Y\u0010\u0003\u0005\u0004\u0014A\u0002\u000b\u0011\u0002B\u007f\u0011%\u0019)\u0002MA\u0001\n\u0003\u001b9\u0002C\u0005\u0004\"A\n\t\u0011\"!\u0004$!I1\u0011\u0007\u0019\u0002\u0002\u0013%11\u0007\u0002\u0015'\u0016\u0014h/\u001a:J]\n|WO\u001c3IC:$G.\u001a:\u000b\u0005eR\u0014AB:feZ,'O\u0003\u0002<y\u0005)a.\u001a;us*\u0011QHP\u0001\u0005QR$\bOC\u0001@\u0003\rQ\u0018n\\\n\u0005\u0001\u0005\u001b\u0016\fE\u0002C\u0011*k\u0011a\u0011\u0006\u0003\t\u0016\u000bqa\u00195b]:,GN\u0003\u0002<\r*\tq)\u0001\u0002j_&\u0011\u0011j\u0011\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005-\u000bV\"\u0001'\u000b\u0005uj%B\u0001(P\u0003\u0015\u0019w\u000eZ3d\u0015\t\u0001V)A\u0004iC:$G.\u001a:\n\u0005Ic%A\u0003%uiB|%M[3diB\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n9\u0001K]8ek\u000e$\bC\u0001.d\u001d\tY\u0016M\u0004\u0002]A6\tQL\u0003\u0002_?\u00061AH]8piz\u001a\u0001!C\u0001W\u0013\t\u0011W+A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'\u0001D*fe&\fG.\u001b>bE2,'B\u00012V\u0003\u0019\t\u0007\u000f\u001d*fMV\t\u0001\u000e\u0005\u0002jY:\u0011!n[\u0007\u0002q%\u0011!\rO\u0005\u0003[:\u0014\u0011BU8vi\u0016\u001c(+\u001a4\u000b\u0005\tD\u0014aB1qaJ+g\rI\u0001\u0007G>tg-[4\u0016\u0003I\u0004\"a]<\u000f\u0005Q,X\"\u0001\u001f\n\u0005Yd\u0014AB*feZ,'/\u0003\u0002ys\n11i\u001c8gS\u001eT!A\u001e\u001f\u0002\u000f\r|gNZ5hA\u0005)AO]1dKB\u0019Q0a\u0001\u000f\u0007y\f\tA\u0004\u0002]\u007f&\tq(\u0003\u0002c}%!\u0011QAA\u0004\u0005\u0015!&/Y2f\u0015\t\u0011g(\u0001\u0004=S:LGO\u0010\u000b\u0007\u0003\u001b\t\u0019\"!\u0006\u0015\t\u0005=\u0011\u0011\u0003\t\u0003U\u0002AQa\u001f\u0004A\u0004qDQA\u001a\u0004A\u0002!DQ\u0001\u001d\u0004A\u0002I\fa!\u001e8tC\u001a,WCAA\u000e!\u0011\ti\"a\b\u000e\u0003yJ1!!\t?\u0005\u0019)fn]1gK\u00069QO\\:bM\u0016\u0004\u0013A\u0002:pkR,7/\u0006\u0002\u0002*A9A/a\u000b\u00020\u0005U\u0012bAA\u0017y\t1!k\\;uKN\u00042\u0001VA\u0019\u0013\r\t\u0019$\u0016\u0002\u0004\u0003:L\bc\u0001;\u00028%\u0019\u0011\u0011\b\u001f\u0003\u0011I+7\u000f]8og\u0016\f!B]8vi\u0016\u001cx\fJ3r)\u0011\ty$!\u0012\u0011\u0007Q\u000b\t%C\u0002\u0002DU\u0013A!\u00168ji\"I\u0011q\t\u0006\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0014a\u0002:pkR,7\u000fI\u0001\beVtG/[7f+\t\ty\u0005\u0005\u0003\u0002R\u0005MS\"\u0001\u001e\n\u0007\u0005U#H\u0001\u0007OKR$\u0018PU;oi&lW-A\u0006sk:$\u0018.\\3`I\u0015\fH\u0003BA \u00037B\u0011\"a\u0012\u000e\u0003\u0003\u0005\r!a\u0014\u0002\u0011I,h\u000e^5nK\u0002\n\u0001#\u001b8GY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0016\u0005\u0005\r\u0004\u0003BA3\u0003oj!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0007CR|W.[2\u000b\t\u00055\u0014qN\u0001\u000bG>t7-\u001e:sK:$(\u0002BA9\u0003g\nA!\u001e;jY*\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002z\u0005\u001d$!\u0003'p]\u001e\fE\rZ3s\u0003EIgN\u00127jO\"$(+Z9vKN$8\u000fI\u0001\u000fe\u0016\fGm\u00117jK:$8)\u001a:u+\t\t\t\tE\u0002U\u0003\u0007K1!!\"V\u0005\u001d\u0011un\u001c7fC:\fqB]3bI\u000ec\u0017.\u001a8u\u0007\u0016\u0014H\u000fI\u0001\u0012CZ|\u0017\u000eZ\"uqN;\u0018\u000e^2iS:<\u0017AE1w_&$7\t\u001e=To&$8\r[5oO\u0002\n!B]3ge\u0016\u001c\b.\u00119q)\t\ty$\u0001\u0007f]N,(/\u001a%bg\u0006\u0003\b/\u0001\bsK2,\u0017m]3SKF,Xm\u001d;\u0016\u0005\u0005]\u0005#\u0002+\u0002\u001a\u0006}\u0012bAAN+\nIa)\u001e8di&|g\u000eM\u0001\u0010e\u0016dW-Y:f%\u0016\fX/Z:uA\u0005a1\r[1o]\u0016d'+Z1eaQ1\u0011qHAR\u0003[Cq!!*\u001a\u0001\u0004\t9+A\u0002dib\u00042AQAU\u0013\r\tYk\u0011\u0002\u0016\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0007>tG/\u001a=u\u0011\u0019\ty+\u0007a\u0001\u0015\u0006\u0019Qn]4\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$b!a\u0010\u00026\u0006]\u0006bBAS5\u0001\u0007\u0011q\u0015\u0005\b\u0003sS\u0002\u0019AA^\u0003\u0015\u0019\u0017-^:f!\rQ\u0016QX\u0005\u0004\u0003\u007f+'!\u0003+ie><\u0018M\u00197f\u0003M\tG\rZ!ts:\u001c'i\u001c3z\u0011\u0006tG\r\\3s)\u0011\t)-a3\u0011\t\u0005E\u0013qY\u0005\u0004\u0003\u0013T$aD!ts:\u001c'i\u001c3z%\u0016\fG-\u001a:\t\u000f\u0005\u00156\u00041\u0001\u0002(\u0006\u0001\u0012\r\u001e;f[B$h)Y:u/JLG/\u001a\u000b\t\u0003\u0003\u000b\t.a5\u0002^\"9\u0011Q\u0015\u000fA\u0002\u0005\u001d\u0006bBAk9\u0001\u0007\u0011q[\u0001\u0007[\u0016$\bn\u001c3\u0011\u0007Q\fI.C\u0002\u0002\\r\u0012a!T3uQ>$\u0007bBAp9\u0001\u0007\u0011QG\u0001\te\u0016\u001c\bo\u001c8tK\u0006\u0001\u0012\r\u001e;f[B$h)\u001e7m/JLG/\u001a\u000b\u000b\u0003K\f\u00190!>\u0002x\u0006e\b#B?\u0002h\u0006-\u0018\u0002BAu\u0003\u000f\u0011A\u0001V1tWB)A+!<\u0002r&\u0019\u0011q^+\u0003\r=\u0003H/[8o!\u0015i\u0018q]A \u0011\u001d\t)+\ba\u0001\u0003OCq!a\u0013\u001e\u0001\u0004\ty\u0005C\u0004\u0002`v\u0001\r!!\u000e\t\u000f\u0005mX\u00041\u0001\u0002~\u00069!/Z9vKN$\bc\u0001;\u0002\u0000&\u0019!\u0011\u0001\u001f\u0003\u000fI+\u0017/^3ti\u0006)\u0012\r\u001e;f[B$\u0018*\\7fI&\fG/Z,sSR,G\u0003CAA\u0005\u000f\u0011IAa\u0003\t\u000f\u0005\u0015f\u00041\u0001\u0002(\"9\u0011Q\u001b\u0010A\u0002\u0005]\u0007b\u0002B\u0007=\u0001\u0007!qB\u0001\u0005KbLG\u000f\u0005\u0006\u0002\u001e\tE\u0011qFA\u001b\u0003kI1Aa\u0005?\u0005\rQ\u0016jT\u0001\u000f[\u0006\\WMW5p%\u0016\fX/Z:u)\u0019\tiP!\u0007\u0003\u001c!9\u0011QU\u0010A\u0002\u0005\u001d\u0006b\u0002B\u000f?\u0001\u0007!qD\u0001\t]\u0016$H/\u001f*fcB\u00191J!\t\n\u0007\t\rBJA\u0006IiR\u0004(+Z9vKN$\u0018AE;qOJ\fG-\u001a+p/\u0016\u00147k\\2lKR$\"\"!=\u0003*\t-\"Q\u0006B\u001c\u0011\u001d\t)\u000b\ta\u0001\u0003OCq!a?!\u0001\u0004\ti\u0010C\u0004\u00030\u0001\u0002\rA!\r\u0002\u0019],'mU8dW\u0016$\u0018\t\u001d9\u0011\u000bQ\u0014\u0019$a\f\n\u0007\tUBH\u0001\u0007XK\n\u001cvnY6fi\u0006\u0003\b\u000fC\u0004\u0002L\u0001\u0002\r!a\u0014\u0002\u001b]\u0014\u0018\u000e^3SKN\u0004xN\\:f))\u0011iDa\u0011\u0003F\t\u001d#\u0011\n\u000b\u0005\u0003\u007f\u0011y\u0004C\u0004\u0003B\u0005\u0002\r!a&\u0002\u000f\u0015t7/\u001e:fI\"9\u0011QU\u0011A\u0002\u0005\u001d\u0006bBA&C\u0001\u0007\u0011q\n\u0005\b\u0005\u001b\t\u0003\u0019\u0001B\b\u0011\u001d\u0011Y%\ta\u0001\u0003{\f1A]3r\u0003a9\u0018\u000e\u001e5EK\u001a\fW\u000f\u001c;FeJ|'OU3ta>t7/\u001a\u000b\u0005\u0003k\u0011\t\u0006C\u0004\u0002:\n\u0002\r!a/\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005/\u0012YF!\u0018\u0015\t\u0005=!\u0011\f\u0005\u0006w\u000e\u0002\u001d\u0001 \u0005\bM\u000e\u0002\n\u00111\u0001i\u0011\u001d\u00018\u0005%AA\u0002I\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003d)\u001a\u0001N!\u001a,\u0005\t\u001d\u0004\u0003\u0002B5\u0005gj!Aa\u001b\u000b\t\t5$qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001dV\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005k\u0012YGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003|)\u001a!O!\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\t\t\u0005\u0003\u0003\u0004\n%UB\u0001BC\u0015\u0011\u00119)a\u001d\u0002\t1\fgnZ\u0005\u0005\u0005\u0017\u0013)I\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005#\u00032\u0001\u0016BJ\u0013\r\u0011)*\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003_\u0011Y\nC\u0005\u0002H!\n\t\u00111\u0001\u0003\u0012\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\"B1!1\u0015BU\u0003_i!A!*\u000b\u0007\t\u001dV+\u0001\u0006d_2dWm\u0019;j_:LAAa+\u0003&\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\tI!-\t\u0013\u0005\u001d#&!AA\u0002\u0005=\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!!\u00038\"I\u0011qI\u0016\u0002\u0002\u0003\u0007!\u0011S\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011S\u0001\ti>\u001cFO]5oOR\u0011!\u0011Q\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0005%Q\u0019\u0005\n\u0003\u000fr\u0013\u0011!a\u0001\u0003_A3\u0001\u0001Be!\u0011\u0011YM!8\u000f\t\t5'\u0011\u001c\b\u0005\u0005\u001f\u00149N\u0004\u0003\u0003R\nUgb\u0001/\u0003T&\tq)\u0003\u0002<\r&\u0011A)R\u0005\u0004\u00057\u001c\u0015AD\"iC:tW\r\u001c%b]\u0012dWM]\u0005\u0005\u0005?\u0014\tO\u0001\u0005TQ\u0006\u0014\u0018M\u00197f\u0015\r\u0011YnQ\u0001\u0015'\u0016\u0014h/\u001a:J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005)\u00044#\u0002\u0019\u0003j\n=\bc\u0001+\u0003l&\u0019!Q^+\u0003\r\u0005s\u0017PU3g!\u0011\u0011\tP!>\u000e\u0005\tM(bA$\u0002t%\u0019AMa=\u0015\u0005\t\u0015\u0018\u0001\u00027jm\u0016,\"A!@\u0011\u0015\u0005u!q`B\u0002\u0007\u001b\ty!C\u0002\u0004\u0002y\u0012aA\u0017'bs\u0016\u0014\b#B?\u0004\u0006!\u0014\u0018\u0002BB\u0004\u0007\u0013\u0011A\u0001J1na&\u001911\u0002 \u0003-%sG/\u001a:tK\u000e$\u0018n\u001c8UsB,7i\\7qCR\u00042\u0001VB\b\u0013\r\u0019\t\"\u0016\u0002\b\u001d>$\b.\u001b8h\u0003\u0015a\u0017N^3!\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0019Ib!\b\u0004 Q!\u0011qBB\u000e\u0011\u0015YH\u0007q\u0001}\u0011\u00151G\u00071\u0001i\u0011\u0015\u0001H\u00071\u0001s\u0003\u001d)h.\u00199qYf$Ba!\n\u0004.A)A+!<\u0004(A)Ak!\u000bie&\u001911F+\u0003\rQ+\b\u000f\\33\u0011%\u0019y#NA\u0001\u0002\u0004\ty!A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\u000e\u0011\t\t\r5qG\u0005\u0005\u0007s\u0011)I\u0001\u0004PE*,7\r\u001e")
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
Serializable {
    private final AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Routes<Object, Response> routes;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;
    private final boolean avoidCtxSwitching;
    private final Function0<BoxedUnit> releaseRequest;
    private volatile byte bitmap$init$0;

    public static Option<Tuple2<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Server.Config>> unapply(ServerInboundHandler x$0) {
        return ServerInboundHandler$.MODULE$.unapply(x$0);
    }

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return ServerInboundHandler$.MODULE$.apply(appRef, config, trace);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    private Unsafe unsafe() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 49");
        }
        return this.unsafe;
    }

    private Routes<Object, Response> routes() {
        return this.routes;
    }

    private void routes_$eq(Routes<Object, Response> x$1) {
        this.routes = x$1;
    }

    private NettyRuntime runtime() {
        return this.runtime;
    }

    private void runtime_$eq(NettyRuntime x$1) {
        this.runtime = x$1;
    }

    public LongAdder inFlightRequests() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 54");
        }
        return this.inFlightRequests;
    }

    private boolean readClientCert() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 55");
        }
        return this.readClientCert;
    }

    private boolean avoidCtxSwitching() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 56");
        }
        return this.avoidCtxSwitching;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.routes_$eq((Routes)pair._1());
        this.runtime_$eq(new NettyRuntime((Runtime<Object>)((Runtime)pair._2())));
    }

    private void ensureHasApp() {
        if (this.runtime() == null) {
            this.refreshApp();
            return;
        }
    }

    private Function0<BoxedUnit> releaseRequest() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ServerInboundHandler.scala: 71");
        }
        return this.releaseRequest;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.inFlightRequests().increment();
            this.ensureHasApp();
            try {
                if (httpRequest.decoderResult().isFailure()) {
                    Throwable throwable = httpRequest.decoderResult().cause();
                    this.attemptFastWrite(ctx, Conversions$.MODULE$.methodFromNetty(httpRequest.method()), Response$.MODULE$.fromThrowable(throwable, this.runtime().getRef(ErrorResponseConfig$.MODULE$.configRef())));
                    this.releaseRequest().apply$mcV$sp();
                } else {
                    Request req = this.makeZioRequest(ctx, httpRequest);
                    ZIO<Object, Response, Response> exit = this.routes().apply(req, (.less.colon.less<Response, Response>)$less$colon$less$.MODULE$.refl());
                    if (this.attemptImmediateWrite(ctx, req.method(), exit)) {
                        this.releaseRequest().apply$mcV$sp();
                    } else {
                        this.writeResponse(ctx, this.runtime(), exit, req, this.releaseRequest());
                    }
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)httpRequest);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ctx.fireChannelRead((Object)httpContent);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String msg;
        if (cause instanceof IOException && (msg = ((IOException)cause).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.runtime() != null && this.config().logWarningOnFatalError()) {
            this.runtime().unsafeRunSync(ZIO$.MODULE$.logWarningCause((Function0 & Serializable)() -> "Fatal exception in Netty", (Function0 & Serializable)() -> Cause$.MODULE$.die(cause, Cause$.MODULE$.die$default$2()), this.trace), this.unsafe(), this.trace);
        }
        if (cause instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Method method2, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            Body.UnsafeBytes unsafeBytes = (Body.UnsafeBytes)body;
            try {
                return this.fastEncode$1(response, unsafeBytes.unsafeAsArray(this.unsafe()), method2, ctx);
            }
            catch (Throwable throwable) {
                if (NonFatal$.MODULE$.apply(throwable)) {
                    return this.fastEncode$1(this.withDefaultErrorResponse(throwable), Array$.MODULE$.emptyByteArray(), method2, ctx);
                }
                throw throwable;
            }
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, Request request) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> socketApp = ((Body.WebsocketBody)body).socketApp();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (status != null && status.equals(status$SwitchingProtocols$)) {
                return this.upgradeToWebSocket(ctx, request, socketApp, runtime).as((Function0 & Serializable)() -> None$.MODULE$, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function0 & Serializable)() -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(request.method(), response, this.unsafe());
            if (!(jResponse instanceof FullHttpResponse)) {
                Some some;
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (string == null) {
                            some = None$.MODULE$;
                            break;
                        }
                    }
                    default: {
                        some = new Some((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(string))));
                    }
                }
                Some contentLength = some;
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, $this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, Method method2, ZIO<Object, Response, Response> exit) {
        Response response;
        if (exit instanceof Exit.Success && (response = (Response)((Exit.Success)exit).value()) != null) {
            return this.attemptFastWrite(ctx, method2, response);
        }
        return false;
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion = HttpVersion.HTTP_1_0;
        if (!(httpVersion != null ? !httpVersion.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion2 = HttpVersion.HTTP_1_1;
            if (!(httpVersion2 != null ? !httpVersion2.equals(nettyHttpVersion) : nettyHttpVersion != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version$Http_1_0$ protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            none$2 = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates()));
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)inetSocketAddress.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<Header> contentTypeHeader = headers.get(Header$ContentType$.MODULE$);
        if (nettyReq instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyReq;
            Body x$1 = NettyBody$.MODULE$.fromByteBuf(fullHttpRequest.content(), contentTypeHeader);
            Method x$3 = Conversions$.MODULE$.methodFromNetty(fullHttpRequest.method());
            URL x$4 = (URL)URL$.MODULE$.decode(fullHttpRequest.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty());
            return new Request(protocolVersion, x$3, x$4, headers, x$1, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.length()));
        AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
        Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(Function1 & Serializable)async -> {
            handler.connect(async);
            return BoxedUnit.UNIT;
        }, (Option<Object>)knownContentLength, contentTypeHeader);
        Method x$10 = Conversions$.MODULE$.methodFromNetty(nettyReq.method());
        URL x$11 = (URL)URL$.MODULE$.decode(nettyReq.uri()).getOrElse((Function0 & Serializable)() -> URL$.MODULE$.empty());
        return new Request(protocolVersion, x$10, x$11, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, Request request, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        return Promise$.MODULE$.make(this.trace).flatMap((Function1 & Serializable)handshakeCompleted -> Queue$.MODULE$.unbounded($this.trace).tap((Function1 & Serializable)queue -> ZIO$.MODULE$.suspend((Function0 & Serializable)() -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx.channel());
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted);
            return webSocketApp.handler().runZIO(webSocketChannel).ignoreLogged($this.trace).forkDaemon($this.trace);
        }, $this.trace), $this.trace).flatMap((Function1 & Serializable)queue -> ZIO$.MODULE$.attempt((Function0 & Serializable)() -> {
            ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse((Function0 & Serializable)() -> this.config().webSocketConfig())).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Promise<Nothing$, Object>)handshakeCompleted, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, $this.trace));
            DefaultFullHttpRequest jReq = new DefaultFullHttpRequest(Conversions$.MODULE$.versionToNetty(request.version()), Conversions$.MODULE$.methodToNetty(request.method()), Conversions$.MODULE$.urlToNetty(request.url()));
            jReq.headers().setAll(Conversions$.MODULE$.headersToNetty(request.allHeaders()));
            return ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)jReq));
        }, $this.trace).map((Function1 & Serializable)x$6 -> {
            ServerInboundHandler.$anonfun$upgradeToWebSocket$8(x$6);
            return BoxedUnit.UNIT;
        }, $this.trace), $this.trace), this.trace);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Object, Response, Response> exit, Request req, Function0<BoxedUnit> ensured) {
        ZIO program = exit.foldCauseZIO((Function1 & Serializable)x$7 -> {
            boolean bl = false;
            Right right = null;
            Either either = x$7.failureOrCause();
            if (either instanceof Left) {
                Response resp = (Response)((Left)either).value();
                return this.writeResponse$1(resp, ctx, req, runtime);
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                if (((Cause)right.value()).isInterruptedOnly()) {
                    return this.closeChannel$1(ctx);
                }
            }
            if (bl) {
                Cause c = (Cause)right.value();
                return this.writeResponse$1(this.withDefaultErrorResponse((Throwable)new FiberFailure(c)), ctx, req, runtime);
            }
            throw new MatchError((Object)either);
        }, (Function1 & Serializable)response -> this.writeResponse$1((Response)response, ctx, req, runtime), this.trace);
        runtime.run(ctx, ensured, this.avoidCtxSwitching(), (ZIO<Object, Throwable, Object>)program, this.unsafe(), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return this.appRef();
            }
            case 1: {
                return this.config();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerInboundHandler;
    }

    public String productElementName(int x$1) {
        switch (x$1) {
            case 0: {
                return "appRef";
            }
            case 1: {
                return "config";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof ServerInboundHandler)) break block3;
                ServerInboundHandler serverInboundHandler = (ServerInboundHandler)x$1;
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
                AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
                if (atomicReference != null ? !atomicReference.equals(atomicReference2) : atomicReference2 != null) break block3;
                Server.Config config = this.config();
                Server.Config config2 = serverInboundHandler.config();
                if (config != null ? !((Object)config).equals(config2) : config2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    private final boolean fastEncode$1(Response response, byte[] bytes, Method method$1, ChannelHandlerContext ctx$1) {
        FullHttpResponse djResponse = NettyResponseEncoder$.MODULE$.fastEncode(method$1, response, bytes, this.unsafe()).retainedDuplicate();
        io.netty.channel.Channel ch = ctx$1.channel();
        ch.writeAndFlush((Object)djResponse, ch.voidPromise());
        return true;
    }

    public static final /* synthetic */ void $anonfun$upgradeToWebSocket$8(Future x$6) {
    }

    private final ZIO closeChannel$1(ChannelHandlerContext ctx$4) {
        return NettyFutureExecutor$.MODULE$.executed((Function0 & Serializable)() -> ctx$4.channel().close(), this.trace);
    }

    private final ZIO writeResponse$1(Response response, ChannelHandlerContext ctx$4, Request req$1, NettyRuntime runtime$2) {
        if (this.attemptFastWrite(ctx$4, req$1.method(), response)) {
            return Exit$.MODULE$.unit();
        }
        return this.attemptFullWrite(ctx$4, runtime$2, response, req$1).foldCauseZIO((Function1 & Serializable)cause -> {
            this.attemptFastWrite(ctx$4, req$1.method(), this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
            return Exit$.MODULE$.unit();
        }, (Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return Exit$.MODULE$.unit();
            }
            if (x0$1 instanceof Some) {
                return ((ZIO)((Some)x0$1).value()).orElse((Function0 & Serializable)() -> this.closeChannel$1(ctx$4), CanFail$.MODULE$.canFail(), $this.trace);
            }
            throw new MatchError(x0$1);
        }, this.trace);
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        Product.$init$((Product)this);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.inFlightRequests = new LongAdder();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.includeClientCert()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.avoidCtxSwitching = config.avoidContextSwitching();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.releaseRequest = (JFunction0.mcV.sp & Serializable)() -> this.inFlightRequests().decrement();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

