/*
 * Decompiled with CFR 0.152.
 */
package zio.http.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.QueryParams;
import zio.http.codec.HttpCodecError;
import zio.http.internal.ErrorConstructor;
import zio.http.internal.StringSchemaCodec;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.TypeId;
import zio.schema.codec.DecodeError;
import zio.schema.validation.Validation$;
import zio.schema.validation.ValidationError;

public final class StringSchemaCodec$ {
    public static final StringSchemaCodec$ MODULE$ = new StringSchemaCodec$();
    private static volatile boolean bitmap$init$0;

    public Schema.Field<?, ?> unlazyField(Schema.Field<?, ?> field) {
        if (field.schema() instanceof Schema.Lazy) {
            return Schema.Field$.MODULE$.apply(field.name(), ((Schema.Lazy)field.schema()).schema(), field.annotations(), field.validation(), field.get(), field.set());
        }
        return field;
    }

    public <A> A defaultValue(Schema<A> schema) {
        if (schema instanceof Schema.Collection) {
            return (A)Try$.MODULE$.apply((Function0 & Serializable)() -> ((Schema.Collection)schema).empty()).fold((Function1 & Serializable)x$5 -> null, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
        }
        Either either = schema.defaultValue();
        if (either instanceof Right) {
            return (A)((Right)either).value();
        }
        if (either instanceof Left) {
            if (schema instanceof Schema.Optional) {
                return (A)None$.MODULE$;
            }
            if (schema instanceof Schema.Collection) {
                Schema.Collection collection = (Schema.Collection)schema;
                return (A)Try$.MODULE$.apply((Function0 & Serializable)() -> collection.empty()).fold((Function1 & Serializable)x$6 -> null, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
            }
            return null;
        }
        throw new MatchError((Object)either);
    }

    public boolean isOptional(Schema<?> schema) {
        if (schema instanceof Schema.Optional) {
            return true;
        }
        if (schema instanceof Schema.Record) {
            Schema.Record record = (Schema.Record)schema;
            return record.fields().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.optional())) || record.defaultValue().isRight();
        }
        if (schema instanceof Schema.Collection) {
            Schema.Collection collection = (Schema.Collection)schema;
            return Try$.MODULE$.apply((Function0 & Serializable)() -> collection.empty()).isSuccess() || collection.defaultValue().isRight();
        }
        return false;
    }

    public boolean isOptionalSchema(Schema<?> schema) {
        if (schema instanceof Schema.Optional) {
            return true;
        }
        return schema instanceof Schema.Transform && ((Schema.Transform)schema).schema() instanceof Schema.Optional;
    }

    public Object zio$http$internal$StringSchemaCodec$$decodeAndUnwrap(Schema.Field<?, ?> field, StringSchemaCodec.PrimitiveCodec<Object> codec2, String value, Function2<String, DecodeError, HttpCodecError> ex) {
        try {
            return codec2.decode().apply((Object)value);
        }
        catch (Throwable throwable) {
            if (throwable instanceof DecodeError) {
                DecodeError decodeError = (DecodeError)throwable;
                throw (Throwable)ex.apply((Object)field.fieldName(), (Object)decodeError);
            }
            throw throwable;
        }
    }

    public Object zio$http$internal$StringSchemaCodec$$validateDecoded(StringSchemaCodec.PrimitiveCodec<Object> codec2, Object decoded, ErrorConstructor error2) {
        Chunk validationErrors = codec2.schema().validate(decoded, codec2.schema());
        if (validationErrors.nonEmpty()) {
            throw (Throwable)((Object)error2.invalid((Chunk<ValidationError>)validationErrors));
        }
        return decoded;
    }

    public boolean zio$http$internal$StringSchemaCodec$$emptyStringIsValue(Schema<?> schema) {
        while (true) {
            if (schema instanceof Schema.Optional) {
                schema = ((Schema.Optional)schema).schema();
                continue;
            }
            if (!(schema instanceof Schema.Transform)) break;
            schema = ((Schema.Transform)schema).schema();
        }
        StandardType standardType = ((Schema.Primitive)schema).standardType();
        if (StandardType.UnitType$.MODULE$.equals(standardType)) {
            return true;
        }
        if (StandardType.StringType$.MODULE$.equals(standardType)) {
            return true;
        }
        if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
            return true;
        }
        return StandardType.CharType$.MODULE$.equals(standardType);
    }

    public Schema.Field<?, ?> mapFieldName(Schema.Field<?, ?> field, boolean kebabCase) {
        return Schema.Field$.MODULE$.apply(!kebabCase ? field.fieldName() : this.camelToKebab(field.fieldName()), (Schema)field.annotations().foldLeft((Object)field.schema(), (Function2 & Serializable)(x$8, x$9) -> x$8.annotate(x$9)), field.annotations(), field.validation(), field.get(), field.set());
    }

    public <A> StringSchemaCodec<A, Headers> headerFromSchema(Schema<A> schema0, ErrorConstructor error0, String name) {
        Schema.Record record;
        boolean bl;
        while (true) {
            bl = false;
            record = null;
            if (schema0 instanceof Schema.Primitive) {
                Schema.Primitive primitive = (Schema.Primitive)schema0;
                return StringSchemaCodec$.stringSchemaCodec$1(this.recordSchema((Schema<A>)primitive, name), error0, name, schema0);
            }
            if (schema0 instanceof Schema.Optional) {
                Schema.Optional optional = (Schema.Optional)schema0;
                Schema schema = optional.schema();
                if (schema instanceof Schema.Collection ? true : schema instanceof Schema.Primitive) {
                    return StringSchemaCodec$.stringSchemaCodec$1(this.recordSchema(schema, name), error0, name, schema0);
                }
                if (schema instanceof Schema.Record) {
                    return StringSchemaCodec$.stringSchemaCodec$1(schema, error0, name, schema0);
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(optional).toString());
            }
            if (schema0 instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema0;
                Schema schema = transform.schema();
                if (schema instanceof Schema.Collection ? true : schema instanceof Schema.Primitive) {
                    return StringSchemaCodec$.stringSchemaCodec$1(this.recordSchema((Schema<A>)transform, name), error0, name, schema0);
                }
                if (schema instanceof Schema.Record) {
                    return StringSchemaCodec$.stringSchemaCodec$1((Schema)transform, error0, name, schema0);
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(transform).toString());
            }
            if (!(schema0 instanceof Schema.Lazy)) break;
            schema0 = (Schema)((Schema.Lazy)schema0).schema0$access$0().apply();
        }
        if (schema0 instanceof Schema.Collection) {
            return StringSchemaCodec$.stringSchemaCodec$1(this.recordSchema(schema0, name), error0, name, schema0);
        }
        if (schema0 instanceof Schema.Record) {
            bl = true;
            record = (Schema.Record)schema0;
            if (record.fields().size() == 1 && name != null) {
                return StringSchemaCodec$.stringSchemaCodec$1(this.recordSchema((Schema<A>)record, name), error0, name, schema0);
            }
        }
        if (bl) {
            return StringSchemaCodec$.stringSchemaCodec$1((Schema)record, error0, name, schema0);
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(schema0).toString());
    }

    public <A> StringSchemaCodec<A, QueryParams> queryFromSchema(Schema<A> schema0, ErrorConstructor error0, String name) {
        Schema.Record record;
        boolean bl;
        while (true) {
            bl = false;
            record = null;
            if (schema0 instanceof Schema.Primitive) {
                Schema.Primitive primitive = (Schema.Primitive)schema0;
                return StringSchemaCodec$.stringSchemaCodec$2(this.recordSchema((Schema<A>)primitive, name), error0, name, schema0);
            }
            if (schema0 instanceof Schema.Optional) {
                Schema.Optional optional = (Schema.Optional)schema0;
                Schema schema = optional.schema();
                if (schema instanceof Schema.Collection ? true : schema instanceof Schema.Primitive) {
                    return StringSchemaCodec$.stringSchemaCodec$2(this.recordSchema(schema, name), error0, name, schema0);
                }
                if (schema instanceof Schema.Record) {
                    return StringSchemaCodec$.stringSchemaCodec$2(schema, error0, name, schema0);
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(optional).toString());
            }
            if (schema0 instanceof Schema.Transform) {
                Schema.Transform transform = (Schema.Transform)schema0;
                Schema schema = transform.schema();
                if (schema instanceof Schema.Collection ? true : schema instanceof Schema.Primitive) {
                    return StringSchemaCodec$.stringSchemaCodec$2(this.recordSchema((Schema<A>)transform, name), error0, name, schema0);
                }
                if (schema instanceof Schema.Record) {
                    return StringSchemaCodec$.stringSchemaCodec$2((Schema)transform, error0, name, schema0);
                }
                throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(transform).toString());
            }
            if (!(schema0 instanceof Schema.Lazy)) break;
            schema0 = (Schema)((Schema.Lazy)schema0).schema0$access$0().apply();
        }
        if (schema0 instanceof Schema.Collection) {
            return StringSchemaCodec$.stringSchemaCodec$2(this.recordSchema(schema0, name), error0, name, schema0);
        }
        if (schema0 instanceof Schema.Record) {
            bl = true;
            record = (Schema.Record)schema0;
            if (record.fields().size() == 1 && name != null) {
                return StringSchemaCodec$.stringSchemaCodec$2(this.recordSchema((Schema<A>)record, name), error0, name, schema0);
            }
        }
        if (bl) {
            return StringSchemaCodec$.stringSchemaCodec$2((Schema)record, error0, name, schema0);
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported schema ").append(schema0).toString());
    }

    private <A> Schema<A> recordSchema(Schema<A> s, String name) {
        return Schema.CaseClass1$.MODULE$.apply((TypeId)TypeId.Structural$.MODULE$, Schema.Field$.MODULE$.apply(name, s, Chunk$.MODULE$.empty(), Validation$.MODULE$.succeed(), (Function1 & Serializable)x -> Predef$.MODULE$.identity(x), (Function2 & Serializable)(x$10, v) -> v), (Function1 & Serializable)x -> Predef$.MODULE$.identity(x), Schema.CaseClass1$.MODULE$.apply$default$4());
    }

    public Function1<String, Object> zio$http$internal$StringSchemaCodec$$parsePrimitive(StandardType<?> standardType) {
        if (StandardType.UnitType$.MODULE$.equals(standardType)) {
            return arg_0 -> StringSchemaCodec$.$anonfun$parsePrimitive$1("", arg_0);
        }
        if (StandardType.StringType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> s;
        }
        if (StandardType.BoolType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                block14: {
                    block15: {
                        String string = s.toLowerCase();
                        switch (string == null ? 0 : string.hashCode()) {
                            case 48: {
                                if (!"0".equals(string)) break block14;
                                break block15;
                            }
                            case 49: {
                                if ("1".equals(string)) {
                                    break;
                                }
                                break block14;
                            }
                            case 3521: {
                                if (!"no".equals(string)) break block14;
                                break block15;
                            }
                            case 3551: {
                                if ("on".equals(string)) {
                                    break;
                                }
                                break block14;
                            }
                            case 109935: {
                                if (!"off".equals(string)) break block14;
                                break block15;
                            }
                            case 119527: {
                                if ("yes".equals(string)) {
                                    break;
                                }
                                break block14;
                            }
                            case 3569038: {
                                if ("true".equals(string)) {
                                    break;
                                }
                                break block14;
                            }
                            case 97196323: {
                                if (!"false".equals(string)) break block14;
                                break block15;
                            }
                            default: {
                                break block14;
                            }
                        }
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                }
                throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)new Exception("Invalid boolean value"), Cause$.MODULE$.fail$default$2()), s);
            };
        }
        if (StandardType.ByteType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.ShortType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.IntType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.LongType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.FloatType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s)));
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
            return arg_0 -> StringSchemaCodec$.$anonfun$parsePrimitive$10(new DecodeError.UnsupportedSchema((Schema)new Schema.Primitive(standardType, Schema.Primitive$.MODULE$.apply$default$2()), "TextCodec"), arg_0);
        }
        if (StandardType.CharType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> BoxesRunTime.boxToCharacter((char)s.charAt(0));
        }
        if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return UUID.fromString(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return package$.MODULE$.BigDecimal().apply(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return package$.MODULE$.BigInt().apply(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return DayOfWeek.valueOf(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.MonthType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return Month.valueOf(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return MonthDay.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return Period.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.YearType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return Year.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return YearMonth.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return ZoneId.of(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return ZoneOffset.of(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.DurationType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return Duration.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.InstantType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return Instant.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return LocalDate.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return LocalTime.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return LocalDateTime.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return OffsetTime.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return OffsetDateTime.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return ZonedDateTime.parse(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        if (StandardType.CurrencyType$.MODULE$.equals(standardType)) {
            return (Function1 & Serializable)s -> {
                try {
                    return Currency.getInstance(s);
                }
                catch (Exception e) {
                    throw new DecodeError.ReadError(Cause$.MODULE$.fail((Object)e, Cause$.MODULE$.fail$default$2()), e.getMessage());
                }
            };
        }
        throw new MatchError(standardType);
    }

    private String camelToKebab(String s) {
        if (s.isEmpty()) {
            return "";
        }
        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))))) {
            return new StringBuilder(0).append(Character.toString(RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s)))))).append(this.camelToKebab(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(s)))).toString();
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), '-')) {
            return s;
        }
        return (String)StringOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.augmentString(s), (Object)"", (Function2 & Serializable)(acc, c) -> StringSchemaCodec$.$anonfun$camelToKebab$1(acc, BoxesRunTime.unboxToChar((Object)c)));
    }

    private static final StringSchemaCodec stringSchemaCodec$1(Schema schema1, ErrorConstructor error0$1, String name$1, Schema schema0$1) {
        return new StringSchemaCodec<A, Headers>(schema1, error0$1, name$1, schema0$1){
            private final A defaultValue;
            private final boolean isOptional;
            private final boolean isOptionalSchema;
            private Chunk<Tuple2<Schema.Field<?, ?>, StringSchemaCodec.PrimitiveCodec<Object>>> recordFields;
            private Schema.Record<Object> recordSchema;
            private volatile byte bitmap$init$0;
            private final Schema schema1$1;
            private final ErrorConstructor error0$1;
            private final String name$1;

            public Object decode(Object target) {
                return StringSchemaCodec.decode$(this, target);
            }

            public Object encode(Object input, Object target) {
                return StringSchemaCodec.encode$(this, input, target);
            }

            public Chunk<Tuple2<Schema.Field<?, ?>, StringSchemaCodec.PrimitiveCodec<Object>>> recordFields() {
                if ((byte)(this.bitmap$init$0 & 8) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 355");
                }
                return this.recordFields;
            }

            public Schema.Record<Object> recordSchema() {
                if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 355");
                }
                return this.recordSchema;
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordFields_$eq(Chunk<Tuple2<Schema.Field<?, ?>, StringSchemaCodec.PrimitiveCodec<Object>>> x$1) {
                this.recordFields = x$1;
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordSchema_$eq(Schema.Record<Object> x$1) {
                this.recordSchema = x$1;
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
            }

            public Schema<A> schema() {
                return this.schema1$1;
            }

            public Headers add(Headers headers, String key, String value) {
                return (Headers)headers.addHeaders(Headers$.MODULE$.apply(key, value));
            }

            public Headers addAll(Headers headers, String key, Iterable<String> values) {
                if (values.isEmpty()) {
                    return headers;
                }
                return (Headers)headers.addHeaders(Headers$.MODULE$.apply(key, values.mkString(",")));
            }

            public boolean contains(Headers headers, String key) {
                return headers.contains(key);
            }

            public String unsafeGet(Headers headers, String key) {
                return headers.getUnsafe(key);
            }

            public Chunk<String> getAll(Headers headers, String key) {
                return headers.rawHeaders(key).flatMap((Function1 & Serializable)header -> {
                    if (header.isEmpty()) {
                        return Chunk$.MODULE$.empty();
                    }
                    return Chunk$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])header.split(",")));
                });
            }

            public int count(Headers headers, String key) {
                return headers.rawHeaders(key).size();
            }

            public ErrorConstructor error() {
                return this.error0$1;
            }

            public StringSchemaCodec<Option<A>, Headers> optional() {
                return StringSchemaCodec$.MODULE$.headerFromSchema(this.schema().optional(), this.error0$1, this.name$1);
            }

            public boolean kebabCase() {
                return true;
            }

            public A defaultValue() {
                if ((byte)(this.bitmap$init$0 & 1) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 388");
                }
                return this.defaultValue;
            }

            public boolean isOptional() {
                if ((byte)(this.bitmap$init$0 & 2) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 390");
                }
                return this.isOptional;
            }

            public boolean isOptionalSchema() {
                if ((byte)(this.bitmap$init$0 & 4) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 392");
                }
                return this.isOptionalSchema;
            }
            {
                this.schema1$1 = schema1$1;
                this.error0$1 = error0$1;
                this.name$1 = name$1;
                StringSchemaCodec.$init$(this);
                this.defaultValue = StringSchemaCodec$.MODULE$.defaultValue(schema0$1);
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                this.isOptional = StringSchemaCodec$.MODULE$.isOptional(schema0$1);
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                this.isOptionalSchema = StringSchemaCodec$.MODULE$.isOptionalSchema(schema0$1);
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getAll$1(java.lang.String )}, serializedLambda);
            }
        };
    }

    private static final StringSchemaCodec stringSchemaCodec$2(Schema schema1, ErrorConstructor error0$2, String name$2, Schema schema0$2) {
        return new StringSchemaCodec<A, QueryParams>(schema1, error0$2, name$2, schema0$2){
            private final A defaultValue;
            private final boolean isOptional;
            private final boolean isOptionalSchema;
            private Chunk<Tuple2<Schema.Field<?, ?>, StringSchemaCodec.PrimitiveCodec<Object>>> recordFields;
            private Schema.Record<Object> recordSchema;
            private volatile byte bitmap$init$0;
            private final Schema schema1$2;
            private final ErrorConstructor error0$2;
            private final String name$2;

            public Object decode(Object target) {
                return StringSchemaCodec.decode$(this, target);
            }

            public Object encode(Object input, Object target) {
                return StringSchemaCodec.encode$(this, input, target);
            }

            public Chunk<Tuple2<Schema.Field<?, ?>, StringSchemaCodec.PrimitiveCodec<Object>>> recordFields() {
                if ((byte)(this.bitmap$init$0 & 8) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 438");
                }
                return this.recordFields;
            }

            public Schema.Record<Object> recordSchema() {
                if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 438");
                }
                return this.recordSchema;
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordFields_$eq(Chunk<Tuple2<Schema.Field<?, ?>, StringSchemaCodec.PrimitiveCodec<Object>>> x$1) {
                this.recordFields = x$1;
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
            }

            public void zio$http$internal$StringSchemaCodec$_setter_$recordSchema_$eq(Schema.Record<Object> x$1) {
                this.recordSchema = x$1;
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
            }

            public Schema<A> schema() {
                return this.schema1$2;
            }

            public QueryParams add(QueryParams queryParams2, String key, String value) {
                return (QueryParams)queryParams2.addQueryParam(key, value);
            }

            public QueryParams addAll(QueryParams queryParams2, String key, Iterable<String> values) {
                return (QueryParams)queryParams2.addQueryParams(key, (Chunk<String>)Chunk$.MODULE$.fromIterable(values));
            }

            public boolean contains(QueryParams queryParams2, String key) {
                return queryParams2.hasQueryParam(key);
            }

            public String unsafeGet(QueryParams queryParams2, String key) {
                return queryParams2.unsafeQueryParam(key);
            }

            public Chunk<String> getAll(QueryParams queryParams2, String key) {
                return queryParams2.getAll(key);
            }

            public int count(QueryParams queryParams2, String key) {
                return queryParams2.valueCount(key);
            }

            public ErrorConstructor error() {
                return this.error0$2;
            }

            public StringSchemaCodec<Option<A>, QueryParams> optional() {
                return StringSchemaCodec$.MODULE$.queryFromSchema(this.schema().optional(), this.error0$2, this.name$2);
            }

            public boolean kebabCase() {
                return false;
            }

            public A defaultValue() {
                if ((byte)(this.bitmap$init$0 & 1) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 471");
                }
                return this.defaultValue;
            }

            public boolean isOptional() {
                if ((byte)(this.bitmap$init$0 & 2) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 473");
                }
                return this.isOptional;
            }

            public boolean isOptionalSchema() {
                if ((byte)(this.bitmap$init$0 & 4) == 0) {
                    throw new UninitializedFieldError("Uninitialized field: StringSchemaCodec.scala: 475");
                }
                return this.isOptionalSchema;
            }
            {
                this.schema1$2 = schema1$2;
                this.error0$2 = error0$2;
                this.name$2 = name$2;
                StringSchemaCodec.$init$(this);
                this.defaultValue = StringSchemaCodec$.MODULE$.defaultValue(schema0$2);
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
                this.isOptional = StringSchemaCodec$.MODULE$.isOptional(schema0$2);
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
                this.isOptionalSchema = StringSchemaCodec$.MODULE$.isOptionalSchema(schema0$2);
                this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
                Statics.releaseFence();
            }
        };
    }

    public static final /* synthetic */ String $anonfun$parsePrimitive$1(String result$1, String x$11) {
        return result$1;
    }

    public static final /* synthetic */ Nothing$ $anonfun$parsePrimitive$10(DecodeError.UnsupportedSchema result$2, String x$12) {
        throw result$2;
    }

    public static final /* synthetic */ String $anonfun$camelToKebab$1(String acc, char c) {
        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(c))) {
            return new StringBuilder(1).append(acc).append("-").append(RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(c))).toString();
        }
        return new StringBuilder(0).append(acc).append(c).toString();
    }

    private StringSchemaCodec$() {
    }
}

