/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple3;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Using;
import zio.Config;
import zio.http.ClientSSLCertConfig;
import zio.http.ClientSSLConfig;
import zio.http.ClientSSLConfig$Default$;
import zio.http.ClientSSLConfig$FromJavaxNetSsl$Empty$;

public final class ClientSSLConverter$ {
    public static final ClientSSLConverter$ MODULE$ = new ClientSSLConverter$();

    private SslContextBuilder keyManagerTrustManagerToSslContext(Option<Tuple3<String, InputStream, Option<Config.Secret>>> keyManagerInfo, Option<Tuple3<String, InputStream, Option<Config.Secret>>> trustManagerInfo, SslContextBuilder sslContextBuilder) {
        Option mkeyManagerFactory = keyManagerInfo.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String keyStoreType = (String)x0$1._1();
                InputStream inputStream = (InputStream)x0$1._2();
                Option maybePassword = (Option)x0$1._3();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                char[] password = (char[])maybePassword.map((Function1 & Serializable)x$1 -> (char[])x$1.value().toArray((ClassTag)ClassTag$.MODULE$.Char())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                keyStore.load(inputStream, password);
                keyManagerFactory.init(keyStore, password);
                return keyManagerFactory;
            }
            throw new MatchError(null);
        });
        Option mtrustManagerFactory = trustManagerInfo.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String keyStoreType = (String)x0$2._1();
                InputStream inputStream = (InputStream)x0$2._2();
                Option maybePassword = (Option)x0$2._3();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                char[] password = (char[])maybePassword.map((Function1 & Serializable)x$2 -> (char[])x$2.value().toArray((ClassTag)ClassTag$.MODULE$.Char())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                keyStore.load(inputStream, password);
                trustManagerFactory.init(keyStore);
                return trustManagerFactory;
            }
            throw new MatchError(null);
        });
        ObjectRef bldr = ObjectRef.create((Object)SslContextBuilder.forClient());
        mkeyManagerFactory.foreach((Function1 & Serializable)kmf -> {
            bldr.elem = ((SslContextBuilder)bldr.elem).keyManager(kmf);
            return BoxedUnit.UNIT;
        });
        mtrustManagerFactory.foreach((Function1 & Serializable)tmf -> {
            bldr.elem = ((SslContextBuilder)bldr.elem).trustManager(tmf);
            return BoxedUnit.UNIT;
        });
        return (SslContextBuilder)bldr.elem;
    }

    private SslContextBuilder trustStoreToSslContext(InputStream trustStoreStream, Config.Secret trustStorePassword, SslContextBuilder sslContextBuilder) {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustStore.load(trustStoreStream, (char[])trustStorePassword.value().toArray((ClassTag)ClassTag$.MODULE$.Char()));
        trustManagerFactory.init(trustStore);
        return sslContextBuilder.trustManager(trustManagerFactory);
    }

    private SslContextBuilder buildNettySslContextBuilder(ClientSSLConfig sslConfig, SslContextBuilder sslContextBuilder) {
        boolean bl = false;
        ClientSSLConfig.FromClientAndServerCert fromClientAndServerCert = null;
        if (ClientSSLConfig$Default$.MODULE$.equals(sslConfig)) {
            return sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        if (sslConfig instanceof ClientSSLConfig.FromCertFile) {
            String certPath = ((ClientSSLConfig.FromCertFile)sslConfig).certPath();
            FileInputStream certStream = new FileInputStream(certPath);
            return sslContextBuilder.trustManager((InputStream)certStream);
        }
        if (sslConfig instanceof ClientSSLConfig.FromCertResource) {
            String certPath = ((ClientSSLConfig.FromCertResource)sslConfig).certPath();
            InputStream certStream = this.getClass().getClassLoader().getResourceAsStream(certPath);
            return sslContextBuilder.trustManager(certStream);
        }
        if (sslConfig instanceof ClientSSLConfig.FromTrustStoreResource) {
            ClientSSLConfig.FromTrustStoreResource fromTrustStoreResource = (ClientSSLConfig.FromTrustStoreResource)sslConfig;
            String trustStorePath = fromTrustStoreResource.trustStorePath();
            Config.Secret trustStorePassword = fromTrustStoreResource.trustStorePassword();
            InputStream trustStoreStream = this.getClass().getClassLoader().getResourceAsStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        if (sslConfig instanceof ClientSSLConfig.FromClientAndServerCert) {
            bl = true;
            fromClientAndServerCert = (ClientSSLConfig.FromClientAndServerCert)sslConfig;
            ClientSSLConfig serverCertConfig = fromClientAndServerCert.serverCertConfig();
            ClientSSLCertConfig clientSSLCertConfig = fromClientAndServerCert.clientCertConfig();
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertFile) {
                ClientSSLCertConfig.FromClientCertFile fromClientCertFile = (ClientSSLCertConfig.FromClientCertFile)clientSSLCertConfig;
                String certPath = fromClientCertFile.certPath();
                String keyPath = fromClientCertFile.keyPath();
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(certPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(new File(keyPath)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager((InputStream)certInputStream, (InputStream)keyInputStream);
                }).get();
            }
        }
        if (bl) {
            ClientSSLConfig serverCertConfig = fromClientAndServerCert.serverCertConfig();
            ClientSSLCertConfig clientSSLCertConfig = fromClientAndServerCert.clientCertConfig();
            if (clientSSLCertConfig instanceof ClientSSLCertConfig.FromClientCertResource) {
                ClientSSLCertConfig.FromClientCertResource fromClientCertResource = (ClientSSLCertConfig.FromClientCertResource)clientSSLCertConfig;
                String certPath = fromClientCertResource.certPath();
                String keyPath = fromClientCertResource.keyPath();
                SslContextBuilder newBuilder = this.buildNettySslContextBuilder(serverCertConfig, sslContextBuilder);
                return (SslContextBuilder)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                    ClassLoader classLoader = MODULE$.getClass().getClassLoader();
                    InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return newBuilder.keyManager(certInputStream, keyInputStream);
                }).get();
            }
        }
        if (sslConfig instanceof ClientSSLConfig.FromTrustStoreFile) {
            ClientSSLConfig.FromTrustStoreFile fromTrustStoreFile = (ClientSSLConfig.FromTrustStoreFile)sslConfig;
            String trustStorePath = fromTrustStoreFile.trustStorePath();
            Config.Secret trustStorePassword = fromTrustStoreFile.trustStorePassword();
            FileInputStream trustStoreStream = new FileInputStream(trustStorePath);
            return this.trustStoreToSslContext(trustStoreStream, trustStorePassword, sslContextBuilder);
        }
        if (sslConfig instanceof ClientSSLConfig.FromJavaxNetSsl) {
            None$ none$;
            None$ none$2;
            ClientSSLConfig.FromJavaxNetSsl fromJavaxNetSsl = (ClientSSLConfig.FromJavaxNetSsl)sslConfig;
            String keyManagerKeyStoreType = fromJavaxNetSsl.keyManagerKeyStoreType();
            ClientSSLConfig.FromJavaxNetSsl.Source keyManagerSource = fromJavaxNetSsl.keyManagerSource();
            Option<Config.Secret> keyManagerPassword = fromJavaxNetSsl.keyManagerPassword();
            String trustManagerKeyStoreType = fromJavaxNetSsl.trustManagerKeyStoreType();
            ClientSSLConfig.FromJavaxNetSsl.Source trustManagerSource = fromJavaxNetSsl.trustManagerSource();
            Option<Config.Secret> trustManagerPassword = fromJavaxNetSsl.trustManagerPassword();
            if (keyManagerSource instanceof ClientSSLConfig.FromJavaxNetSsl.File) {
                String path = ((ClientSSLConfig.FromJavaxNetSsl.File)keyManagerSource).file();
                none$2 = Option$.MODULE$.apply((Object)new FileInputStream(path)).map((Function1 & Serializable)inputStream -> new Tuple3((Object)keyManagerKeyStoreType, inputStream, (Object)keyManagerPassword));
            } else if (keyManagerSource instanceof ClientSSLConfig.FromJavaxNetSsl.Resource) {
                String path = ((ClientSSLConfig.FromJavaxNetSsl.Resource)keyManagerSource).resource();
                none$2 = Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream(path)).map((Function1 & Serializable)inputStream -> new Tuple3((Object)keyManagerKeyStoreType, inputStream, (Object)keyManagerPassword));
            } else if (ClientSSLConfig$FromJavaxNetSsl$Empty$.MODULE$.equals(keyManagerSource)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError((Object)keyManagerSource);
            }
            None$ keyManagerInfo = none$2;
            if (trustManagerSource instanceof ClientSSLConfig.FromJavaxNetSsl.File) {
                String path = ((ClientSSLConfig.FromJavaxNetSsl.File)trustManagerSource).file();
                none$ = Option$.MODULE$.apply((Object)new FileInputStream(path)).map((Function1 & Serializable)inputStream -> new Tuple3((Object)trustManagerKeyStoreType, inputStream, (Object)trustManagerPassword));
            } else if (trustManagerSource instanceof ClientSSLConfig.FromJavaxNetSsl.Resource) {
                String path = ((ClientSSLConfig.FromJavaxNetSsl.Resource)trustManagerSource).resource();
                none$ = Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream(path)).map((Function1 & Serializable)inputStream -> new Tuple3((Object)trustManagerKeyStoreType, inputStream, (Object)trustManagerPassword));
            } else if (ClientSSLConfig$FromJavaxNetSsl$Empty$.MODULE$.equals(trustManagerSource)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)trustManagerSource);
            }
            None$ trustManagerInfo = none$;
            return this.keyManagerTrustManagerToSslContext((Option<Tuple3<String, InputStream, Option<Config.Secret>>>)keyManagerInfo, (Option<Tuple3<String, InputStream, Option<Config.Secret>>>)trustManagerInfo, sslContextBuilder);
        }
        throw new MatchError((Object)sslConfig);
    }

    public SslContext toNettySSLContext(ClientSSLConfig sslConfig) {
        return this.buildNettySslContextBuilder(sslConfig, SslContextBuilder.forClient()).build();
    }

    private ClientSSLConverter$() {
    }
}

