/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Using;
import zio.Config;
import zio.http.ClientAuth;
import zio.http.ClientAuth$Optional$;
import zio.http.ClientAuth$Required$;
import zio.http.SSLConfig;
import zio.http.SSLConfig$Data$Generate$;
import zio.http.netty.server.SSLUtil;

public final class SSLUtil$ {
    public static final SSLUtil$ MODULE$ = new SSLUtil$();

    public SSLUtil.SslContextBuilderOps SslContextBuilderOps(SslContextBuilder self) {
        return new SSLUtil.SslContextBuilderOps(self);
    }

    public io.netty.handler.ssl.ClientAuth getClientAuth(ClientAuth clientAuth) {
        if (ClientAuth$Required$.MODULE$.equals(clientAuth)) {
            return io.netty.handler.ssl.ClientAuth.REQUIRE;
        }
        if (ClientAuth$Optional$.MODULE$.equals(clientAuth)) {
            return io.netty.handler.ssl.ClientAuth.OPTIONAL;
        }
        return io.netty.handler.ssl.ClientAuth.NONE;
    }

    public SslContext buildSslServerContext(SSLConfig sslConfig, InputStream certInputStream, InputStream keyInputStream, Option<InputStream> trustCertCollectionPath) {
        SslContextBuilder sslServerContext = SslContextBuilder.forServer((InputStream)certInputStream, (InputStream)keyInputStream);
        trustCertCollectionPath.foreach((Function1 & Serializable)stream -> sslServerContext.trustManager(stream));
        return this.SslContextBuilderOps(sslServerContext).buildWithDefaultOptions(sslConfig);
    }

    public SslContext sslConfigToSslContext(SSLConfig sslConfig) {
        SSLConfig.Data data = sslConfig.data();
        if (SSLConfig$Data$Generate$.MODULE$.equals(data)) {
            X509Bundle selfSigned = new CertificateBuilder().rsa2048().buildSelfSigned();
            return this.SslContextBuilderOps(SslContextBuilder.forServer((PrivateKey)selfSigned.getKeyPair().getPrivate(), (X509Certificate[])new X509Certificate[]{selfSigned.getCertificate()})).buildWithDefaultOptions(sslConfig);
        }
        if (data instanceof SSLConfig.Data.FromFile) {
            SSLConfig.Data.FromFile fromFile = (SSLConfig.Data.FromFile)data;
            String certPath = fromFile.certPath();
            String keyPath = fromFile.keyPath();
            Option<String> trustCertCollectionPath = fromFile.trustCertCollectionPath();
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                FileInputStream certInputStream = (FileInputStream)use.apply((Object)new FileInputStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                FileInputStream keyInputStream = (FileInputStream)use.apply((Object)new FileInputStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable)path -> (FileInputStream)use.apply((Object)new FileInputStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return MODULE$.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        if (data instanceof SSLConfig.Data.FromResource) {
            SSLConfig.Data.FromResource fromResource = (SSLConfig.Data.FromResource)data;
            String certPath = fromResource.certPath();
            String keyPath = fromResource.keyPath();
            Option<String> trustCertCollectionPath = fromResource.trustCertCollectionPath();
            ClassLoader classLoader = this.getClass().getClassLoader();
            return (SslContext)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                InputStream certInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(certPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                InputStream keyInputStream = (InputStream)use.apply((Object)classLoader.getResourceAsStream(keyPath), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Option trustCertInputStream = trustCertCollectionPath.map((Function1 & Serializable)path -> (InputStream)use.apply((Object)classLoader.getResourceAsStream((String)path), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
                return MODULE$.buildSslServerContext(sslConfig, certInputStream, keyInputStream, (Option<InputStream>)trustCertInputStream);
            }).get();
        }
        if (data instanceof SSLConfig.Data.FromJavaxNetSsl) {
            Tuple3 tuple3;
            SSLConfig.Data.FromJavaxNetSsl fromJavaxNetSsl = (SSLConfig.Data.FromJavaxNetSsl)data;
            String keyManagerKeyStoreType = fromJavaxNetSsl.keyManagerKeyStoreType();
            SSLConfig.Data.FromJavaxNetSsl.Source keyManagerSource = fromJavaxNetSsl.keyManagerSource();
            Option<Config.Secret> keyManagerPassword = fromJavaxNetSsl.keyManagerPassword();
            Option<SSLConfig.Data.TrustManagerKeyStore> trustManager2 = fromJavaxNetSsl.trustManagerKeyStore();
            if (keyManagerSource instanceof SSLConfig.Data.FromJavaxNetSsl.File) {
                String path = ((SSLConfig.Data.FromJavaxNetSsl.File)keyManagerSource).file();
                FileInputStream inputStream = new FileInputStream(path);
                tuple3 = new Tuple3((Object)keyManagerKeyStoreType, (Object)inputStream, keyManagerPassword);
            } else if (keyManagerSource instanceof SSLConfig.Data.FromJavaxNetSsl.Resource) {
                String path = ((SSLConfig.Data.FromJavaxNetSsl.Resource)keyManagerSource).resource();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
                tuple3 = new Tuple3((Object)keyManagerKeyStoreType, (Object)inputStream, keyManagerPassword);
            } else {
                throw new MatchError((Object)keyManagerSource);
            }
            Tuple3 keyManagerInfo = tuple3;
            Option trustManagerInfo = trustManager2.map((Function1 & Serializable)trustManager -> {
                InputStream inputStream;
                SSLConfig.Data.FromJavaxNetSsl.Source source = trustManager.trustManagerSource();
                if (source instanceof SSLConfig.Data.FromJavaxNetSsl.File) {
                    String path = ((SSLConfig.Data.FromJavaxNetSsl.File)source).file();
                    inputStream = new FileInputStream(path);
                } else if (source instanceof SSLConfig.Data.FromJavaxNetSsl.Resource) {
                    String path = ((SSLConfig.Data.FromJavaxNetSsl.Resource)source).resource();
                    inputStream = MODULE$.getClass().getClassLoader().getResourceAsStream(path);
                } else {
                    throw new MatchError((Object)source);
                }
                FileInputStream inputStream2 = inputStream;
                return new Tuple3((Object)trustManager.trustManagerKeyStoreType(), (Object)inputStream2, trustManager.trustManagerPassword());
            });
            return this.SslContextBuilderOps(this.keyManagerTrustManagerToSslContext((Tuple3<String, InputStream, Option<Config.Secret>>)keyManagerInfo, (Option<Tuple3<String, InputStream, Option<Config.Secret>>>)trustManagerInfo)).buildWithDefaultOptions(sslConfig);
        }
        throw new MatchError((Object)data);
    }

    /*
     * WARNING - void declaration
     */
    private SslContextBuilder keyManagerTrustManagerToSslContext(Tuple3<String, InputStream, Option<Config.Secret>> keyManagerInfo, Option<Tuple3<String, InputStream, Option<Config.Secret>>> trustManagerInfo) {
        void var7_7;
        if (keyManagerInfo == null) {
            throw new MatchError(null);
        }
        String keyStoreType = (String)keyManagerInfo._1();
        InputStream inputStream = (InputStream)keyManagerInfo._2();
        Option maybePassword = (Option)keyManagerInfo._3();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] password = (char[])maybePassword.map((Function1 & Serializable)x$1 -> (char[])x$1.value().toArray((ClassTag)ClassTag$.MODULE$.Char())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        keyStore.load(inputStream, password);
        keyManagerFactory.init(keyStore, password);
        Option mtrustManagerFactory = trustManagerInfo.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String keyStoreType = (String)x0$1._1();
                InputStream inputStream = (InputStream)x0$1._2();
                Option maybePassword = (Option)x0$1._3();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                char[] password = (char[])maybePassword.map((Function1 & Serializable)x$2 -> (char[])x$2.value().toArray((ClassTag)ClassTag$.MODULE$.Char())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                keyStore.load(inputStream, password);
                trustManagerFactory.init(keyStore);
                return trustManagerFactory;
            }
            throw new MatchError(null);
        });
        ObjectRef bldr = ObjectRef.create((Object)SslContextBuilder.forServer((KeyManagerFactory)var7_7));
        mtrustManagerFactory.foreach((Function1 & Serializable)tmf -> {
            bldr.elem = ((SslContextBuilder)bldr.elem).trustManager(tmf);
            return BoxedUnit.UNIT;
        });
        return (SslContextBuilder)bldr.elem;
    }

    private SSLUtil$() {
    }
}

