/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Cause;
import zio.Chunk;
import zio.Chunk$;
import zio.Exit$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body$;
import zio.http.Body$ArrayBody$;
import zio.http.Body$ChunkBody$;
import zio.http.Body$ContentType$;
import zio.http.Body$ErrorBody$;
import zio.http.Body$FileBody$;
import zio.http.Body$StreamBody$;
import zio.http.Body$WebsocketBody$;
import zio.http.Boundary;
import zio.http.Charsets$;
import zio.http.Form;
import zio.http.Form$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.MediaType;
import zio.http.ServerSentEvent;
import zio.http.ServerSentEvent$;
import zio.http.StreamingForm;
import zio.http.StreamingForm$;
import zio.http.WebSocketApp;
import zio.http.multipart.mixed.MultipartMixed;
import zio.http.multipart.mixed.MultipartMixed$;
import zio.schema.Schema;
import zio.schema.codec.BinaryCodec;
import zio.stream.ZPipeline;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public interface Body {
    public static Body empty() {
        return Body$.MODULE$.empty();
    }

    public static <A> Body from(A a, BinaryCodec<A> binaryCodec, Object object) {
        return Body$.MODULE$.from(a, binaryCodec, object);
    }

    public static Body fromArray(byte[] byArray) {
        return Body$.MODULE$.fromArray(byArray);
    }

    public static Body fromCharSequence(CharSequence charSequence, Charset charset) {
        return Body$.MODULE$.fromCharSequence(charSequence, charset);
    }

    public static Body fromCharSequenceStream(ZStream<Object, Throwable, CharSequence> zStream, long l, Charset charset, Object object) {
        return Body$.MODULE$.fromCharSequenceStream(zStream, l, charset, object);
    }

    public static Body fromCharSequenceStreamChunked(ZStream<Object, Throwable, CharSequence> zStream, Charset charset, Object object) {
        return Body$.MODULE$.fromCharSequenceStreamChunked(zStream, charset, object);
    }

    public static <R> ZIO<R, Throwable, Body> fromCharSequenceStreamChunkedEnv(ZStream<R, Throwable, CharSequence> zStream, Charset charset, Object object) {
        return Body$.MODULE$.fromCharSequenceStreamChunkedEnv(zStream, charset, object);
    }

    public static <R> ZIO<R, Throwable, Body> fromCharSequenceStreamEnv(ZStream<R, Throwable, CharSequence> zStream, long l, Charset charset, Object object) {
        return Body$.MODULE$.fromCharSequenceStreamEnv(zStream, l, charset, object);
    }

    public static Body fromChunk(Chunk<Object> chunk) {
        return Body$.MODULE$.fromChunk(chunk);
    }

    public static Body fromChunk(Chunk<Object> chunk, ContentType contentType) {
        return Body$.MODULE$.fromChunk(chunk, contentType);
    }

    public static Body fromChunk(Chunk<Object> chunk, MediaType mediaType) {
        return Body$.MODULE$.fromChunk(chunk, mediaType);
    }

    public static ZIO<Object, Nothing$, Body> fromFile(File file, int n, Object object) {
        return Body$.MODULE$.fromFile(file, n, object);
    }

    public static Body fromMultipartForm(Form form, Boundary boundary, Object object) {
        return Body$.MODULE$.fromMultipartForm(form, boundary, object);
    }

    public static ZIO<Object, Nothing$, Body> fromMultipartFormUUID(Form form, Object object) {
        return Body$.MODULE$.fromMultipartFormUUID(form, object);
    }

    public static WebsocketBody fromSocketApp(WebSocketApp<Object> webSocketApp) {
        return Body$.MODULE$.fromSocketApp(webSocketApp);
    }

    public static <A> Body fromStream(ZStream<Object, Throwable, A> zStream, BinaryCodec<A> binaryCodec, Object object) {
        return Body$.MODULE$.fromStream(zStream, binaryCodec, object);
    }

    public static Body fromStream(ZStream<Object, Throwable, Object> zStream, long l) {
        return Body$.MODULE$.fromStream(zStream, l);
    }

    public static Body fromStreamChunked(ZStream<Object, Throwable, Object> zStream) {
        return Body$.MODULE$.fromStreamChunked(zStream);
    }

    public static <R> ZIO<R, Throwable, Body> fromStreamChunkedEnv(ZStream<R, Throwable, Object> zStream, Object object) {
        return Body$.MODULE$.fromStreamChunkedEnv(zStream, object);
    }

    public static <A, R> ZIO<R, Throwable, Body> fromStreamEnv(ZStream<R, Throwable, A> zStream, BinaryCodec<A> binaryCodec, Object object) {
        return Body$.MODULE$.fromStreamEnv(zStream, binaryCodec, object);
    }

    public static <R> ZIO<R, Throwable, Body> fromStreamEnv(ZStream<R, Throwable, Object> zStream, long l, Object object) {
        return Body$.MODULE$.fromStreamEnv(zStream, l, object);
    }

    public static Body fromString(String string, Charset charset) {
        return Body$.MODULE$.fromString(string, charset);
    }

    public static Body fromURLEncodedForm(Form form, Charset charset) {
        return Body$.MODULE$.fromURLEncodedForm(form, charset);
    }

    public static Charset fromCharSequence$default$2() {
        return Body$.MODULE$.fromCharSequence$default$2();
    }

    public static Charset fromCharSequenceStreamChunked$default$2() {
        return Body$.MODULE$.fromCharSequenceStreamChunked$default$2();
    }

    public static <R> Charset fromCharSequenceStreamChunkedEnv$default$2() {
        return Body$.MODULE$.fromCharSequenceStreamChunkedEnv$default$2();
    }

    public static int fromFile$default$2() {
        return Body$.MODULE$.fromFile$default$2();
    }

    public static Charset fromString$default$2() {
        return Body$.MODULE$.fromString$default$2();
    }

    public static Charset fromURLEncodedForm$default$2() {
        return Body$.MODULE$.fromURLEncodedForm$default$2();
    }

    public static Charset fromCharSequenceStream$default$3() {
        return Body$.MODULE$.fromCharSequenceStream$default$3();
    }

    public static <R> Charset fromCharSequenceStreamEnv$default$3() {
        return Body$.MODULE$.fromCharSequenceStreamEnv$default$3();
    }

    public static Body $plus$plus$(Body $this, Body that) {
        return $this.$plus$plus(that);
    }

    default public Body $plus$plus(Body that) {
        if (that.isEmpty()) {
            return this;
        }
        return that;
    }

    public static ZIO to$(Body $this, BinaryCodec codec, Object trace) {
        return $this.to(codec, trace);
    }

    default public <A> ZIO<Object, Throwable, A> to(BinaryCodec<A> codec, Object trace) {
        return this.asChunk(trace).flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> Body.to$$anonfun$1$$anonfun$1(codec, bytes), trace), trace);
    }

    public ZIO<Object, Throwable, byte[]> asArray(Object var1);

    public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object var1);

    public static ZIO asMultipartForm$(Body $this, Object trace) {
        return $this.asMultipartForm(trace);
    }

    default public ZIO<Object, Throwable, Form> asMultipartForm(Object trace) {
        Option<Boundary> option = this.boundary();
        if (option instanceof Some) {
            Boundary boundary = (Boundary)((Some)option).value();
            return StreamingForm$.MODULE$.apply(this.asStream(trace), boundary, StreamingForm$.MODULE$.$lessinit$greater$default$3()).collectAll(trace);
        }
        return this.asChunk(trace).flatMap((Function1 & Serializable)bytes -> Form$.MODULE$.fromMultipartBytes((Chunk<Object>)bytes, Charsets$.MODULE$.Http(), this.boundary(), trace).map((Function1 & Serializable)form -> form, trace), trace);
    }

    public static ZIO asMultipartFormStream$(Body $this, Object trace) {
        return $this.asMultipartFormStream(trace);
    }

    default public ZIO<Object, Throwable, StreamingForm> asMultipartFormStream(Object trace) {
        Option<Boundary> option = this.boundary();
        if (option instanceof Some) {
            Boundary boundary = (Boundary)((Some)option).value();
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return StreamingForm$.MODULE$.apply(this.asStream(trace), boundary, StreamingForm$.MODULE$.$lessinit$greater$default$3());
            });
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(Body::asMultipartFormStream$$anonfun$2, trace);
        }
        throw new MatchError(option);
    }

    public static ZIO asMultipartMixed$(Body $this, Object trace) {
        return $this.asMultipartMixed(trace);
    }

    default public ZIO<Object, Throwable, MultipartMixed> asMultipartMixed(Object trace) {
        return ZIO$.MODULE$.fromOption(this::asMultipartMixed$$anonfun$1, trace).orElseFail(Body::asMultipartMixed$$anonfun$2, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public static ZStream asServerSentEvents$(Body $this, Schema evidence$1, Object trace) {
        return $this.asServerSentEvents(evidence$1, trace);
    }

    default public <T> ZStream<Object, Throwable, ServerSentEvent<T>> asServerSentEvents(Schema<T> evidence$1, Object trace) {
        BinaryCodec<ServerSentEvent<T>> codec = ServerSentEvent$.MODULE$.defaultBinaryCodec(evidence$1);
        return this.asStream(trace).$greater$greater$greater(() -> Body.asServerSentEvents$$anonfun$1(codec), trace);
    }

    public ZStream<Object, Throwable, Object> asStream(Object var1);

    public static ZIO asString$(Body $this, Object trace) {
        return $this.asString(trace);
    }

    default public ZIO<Object, Throwable, String> asString(Object trace) {
        return this.asArray(trace).map((Function1 & Serializable)_$1 -> new String((byte[])_$1, Charsets$.MODULE$.Http()), trace);
    }

    public static ZIO asString$(Body $this, Charset charset, Object trace) {
        return $this.asString(charset, trace);
    }

    default public ZIO<Object, Throwable, String> asString(Charset charset, Object trace) {
        return this.asArray(trace).map((Function1 & Serializable)_$2 -> new String((byte[])_$2, charset), trace);
    }

    public static ZIO asURLEncodedForm$(Body $this, Object trace) {
        return $this.asURLEncodedForm(trace);
    }

    default public ZIO<Object, Throwable, Form> asURLEncodedForm(Object trace) {
        return this.asString(trace).flatMap((Function1 & Serializable)string -> ZIO$.MODULE$.fromEither(() -> Body.asURLEncodedForm$$anonfun$1$$anonfun$1(string), trace), trace);
    }

    public boolean isComplete();

    public Option<Object> knownContentLength();

    public boolean isEmpty();

    public Option<ContentType> contentType();

    public Body contentType(ContentType var1);

    public static ZIO materialize$(Body $this, Object trace) {
        return $this.materialize(trace);
    }

    default public ZIO<Object, Nothing$, Body> materialize(Object trace) {
        return this.asArray(trace).foldCause((Function1 & Serializable)_$3 -> Body$ErrorBody$.MODULE$.apply((Cause<Throwable>)_$3), (Function1 & Serializable)_$4 -> Body$ArrayBody$.MODULE$.apply((byte[])_$4, this.contentType()), trace);
    }

    public static Option mediaType$(Body $this) {
        return $this.mediaType();
    }

    default public Option<MediaType> mediaType() {
        return this.contentType().map((Function1 & Serializable)_$5 -> _$5.mediaType());
    }

    public static Body contentType$(Body $this, MediaType newMediaType) {
        return $this.contentType(newMediaType);
    }

    default public Body contentType(MediaType newMediaType) {
        return this.contentType((ContentType)this.contentType().map((Function1 & Serializable)_$6 -> _$6.copy(newMediaType, _$6.copy$default$2(), _$6.copy$default$3())).getOrElse(() -> Body.contentType$$anonfun$2(newMediaType)));
    }

    public static Body contentType$(Body $this, MediaType newMediaType, Boundary newBoundary) {
        return $this.contentType(newMediaType, newBoundary);
    }

    default public Body contentType(MediaType newMediaType, Boundary newBoundary) {
        return this.contentType(Body$ContentType$.MODULE$.apply(newMediaType, (Option<Boundary>)Some$.MODULE$.apply((Object)newBoundary), Body$ContentType$.MODULE$.$lessinit$greater$default$3()));
    }

    public static Option boundary$(Body $this) {
        return $this.boundary();
    }

    default public Option<Boundary> boundary() {
        return this.contentType().flatMap((Function1 & Serializable)_$7 -> _$7.boundary());
    }

    private static Either to$$anonfun$1$$anonfun$1(BinaryCodec codec$2, Chunk bytes$1) {
        return codec$2.decode((Object)bytes$1);
    }

    private static IllegalStateException asMultipartFormStream$$anonfun$2() {
        return new IllegalStateException("Cannot decode body as streaming multipart/form-data without a known boundary");
    }

    private Option asMultipartMixed$$anonfun$1() {
        return MultipartMixed$.MODULE$.fromBody(this, MultipartMixed$.MODULE$.fromBody$default$2());
    }

    private static IllegalStateException asMultipartMixed$$anonfun$2() {
        return new IllegalStateException("Cannot decode body as multipart/mixed without a known boundary");
    }

    private static ZPipeline asServerSentEvents$$anonfun$1(BinaryCodec codec$3) {
        return codec$3.streamDecoder();
    }

    private static Either asURLEncodedForm$$anonfun$1$$anonfun$1(String string$1) {
        return Form$.MODULE$.fromURLEncoded(string$1, Charsets$.MODULE$.Http());
    }

    private static ContentType contentType$$anonfun$2(MediaType newMediaType$2) {
        return Body$ContentType$.MODULE$.apply(newMediaType$2, Body$ContentType$.MODULE$.$lessinit$greater$default$2(), Body$ContentType$.MODULE$.$lessinit$greater$default$3());
    }

    public static final class ArrayBody
    extends UnsafeBytes
    implements Product,
    Serializable {
        private final byte[] data;
        private final Option contentType;

        public static ArrayBody apply(byte[] byArray, Option<ContentType> option) {
            return Body$ArrayBody$.MODULE$.apply(byArray, option);
        }

        public static ArrayBody fromProduct(Product product) {
            return Body$ArrayBody$.MODULE$.fromProduct(product);
        }

        public static ArrayBody unapply(ArrayBody arrayBody) {
            return Body$ArrayBody$.MODULE$.unapply(arrayBody);
        }

        public static Option<ContentType> $lessinit$greater$default$2() {
            return Body$ArrayBody$.MODULE$.$lessinit$greater$default$2();
        }

        public ArrayBody(byte[] data, Option<ContentType> contentType) {
            this.data = data;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ArrayBody)) return false;
            ArrayBody arrayBody = (ArrayBody)object;
            if (this.data() != arrayBody.data()) return false;
            Option<ContentType> option = this.contentType();
            Option<ContentType> option2 = arrayBody.contentType();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ArrayBody;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ArrayBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "contentType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte[] data() {
            return this.data;
        }

        @Override
        public Option<ContentType> contentType() {
            return this.contentType;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return Exit$.MODULE$.succeed((Object)this.data());
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            Object object = Predef$.MODULE$.byteArrayOps(this.data());
            return ArrayOps$.MODULE$.isEmpty$extension(object);
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return Exit$.MODULE$.succeed((Object)Chunk$.MODULE$.fromArray((Object)this.data()));
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$3(trace), trace);
        }

        public String toString() {
            return new StringBuilder(16).append("Body.fromArray(").append(this.data()).append(")").toString();
        }

        @Override
        public byte[] unsafeAsArray(Unsafe unsafe) {
            return this.data();
        }

        @Override
        public Body contentType(ContentType newContentType) {
            Some some = Some$.MODULE$.apply((Object)newContentType);
            byte[] byArray = this.copy$default$1();
            return this.copy(byArray, (Option<ContentType>)some);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.data().length));
        }

        public ArrayBody copy(byte[] data, Option<ContentType> contentType) {
            return new ArrayBody(data, contentType);
        }

        public byte[] copy$default$1() {
            return this.data();
        }

        public Option<ContentType> copy$default$2() {
            return this.contentType();
        }

        public byte[] _1() {
            return this.data();
        }

        public Option<ContentType> _2() {
            return this.contentType();
        }

        private final Chunk asStream$$anonfun$3$$anonfun$1$$anonfun$1(Chunk _$9$1) {
            return _$9$1;
        }

        private final ZIO asStream$$anonfun$3(Object trace$10) {
            return this.asChunk(trace$10).map((Function1 & Serializable)_$9 -> ZStream$.MODULE$.fromChunk(() -> this.asStream$$anonfun$3$$anonfun$1$$anonfun$1(_$9), trace$10), trace$10);
        }
    }

    public static final class ChunkBody
    extends UnsafeBytes
    implements Product,
    Serializable {
        private final Chunk data;
        private final Option contentType;

        public static ChunkBody apply(Chunk<Object> chunk, Option<ContentType> option) {
            return Body$ChunkBody$.MODULE$.apply(chunk, option);
        }

        public static ChunkBody fromProduct(Product product) {
            return Body$ChunkBody$.MODULE$.fromProduct(product);
        }

        public static ChunkBody unapply(ChunkBody chunkBody) {
            return Body$ChunkBody$.MODULE$.unapply(chunkBody);
        }

        public static Option<ContentType> $lessinit$greater$default$2() {
            return Body$ChunkBody$.MODULE$.$lessinit$greater$default$2();
        }

        public ChunkBody(Chunk<Object> data, Option<ContentType> contentType) {
            this.data = data;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChunkBody)) return false;
            ChunkBody chunkBody = (ChunkBody)object;
            Chunk<Object> chunk = this.data();
            Chunk<Object> chunk2 = chunkBody.data();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Option<ContentType> option = this.contentType();
            Option<ContentType> option2 = chunkBody.contentType();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ChunkBody;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ChunkBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "contentType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<Object> data() {
            return this.data;
        }

        @Override
        public Option<ContentType> contentType() {
            return this.contentType;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return (byte[])this.data().toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
            });
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.data().isEmpty();
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return Exit$.MODULE$.succeed(this.data());
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$2(trace), trace);
        }

        public String toString() {
            return new StringBuilder(16).append("Body.fromChunk(").append(this.data()).append(")").toString();
        }

        @Override
        public byte[] unsafeAsArray(Unsafe unsafe) {
            return (byte[])this.data().toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        }

        @Override
        public Body contentType(ContentType newContentType) {
            Some some = Some$.MODULE$.apply((Object)newContentType);
            Chunk<Object> chunk = this.copy$default$1();
            return this.copy(chunk, (Option<ContentType>)some);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.data().length()));
        }

        public ChunkBody copy(Chunk<Object> data, Option<ContentType> contentType) {
            return new ChunkBody(data, contentType);
        }

        public Chunk<Object> copy$default$1() {
            return this.data();
        }

        public Option<ContentType> copy$default$2() {
            return this.contentType();
        }

        public Chunk<Object> _1() {
            return this.data();
        }

        public Option<ContentType> _2() {
            return this.contentType();
        }

        private final Chunk asStream$$anonfun$2$$anonfun$1$$anonfun$1(Chunk _$8$1) {
            return _$8$1;
        }

        private final ZIO asStream$$anonfun$2(Object trace$8) {
            return this.asChunk(trace$8).map((Function1 & Serializable)_$8 -> ZStream$.MODULE$.fromChunk(() -> this.asStream$$anonfun$2$$anonfun$1$$anonfun$1(_$8), trace$8), trace$8);
        }
    }

    public static final class ContentType
    implements Product,
    Serializable {
        private final MediaType mediaType;
        private final Option boundary;
        private final Option charset;

        public static ContentType apply(MediaType mediaType, Option<Boundary> option, Option<Charset> option2) {
            return Body$ContentType$.MODULE$.apply(mediaType, option, option2);
        }

        public static ContentType fromHeader(Header.ContentType contentType) {
            return Body$ContentType$.MODULE$.fromHeader(contentType);
        }

        public static ContentType fromProduct(Product product) {
            return Body$ContentType$.MODULE$.fromProduct(product);
        }

        public static ContentType unapply(ContentType contentType) {
            return Body$ContentType$.MODULE$.unapply(contentType);
        }

        public static Option<Boundary> $lessinit$greater$default$2() {
            return Body$ContentType$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Charset> $lessinit$greater$default$3() {
            return Body$ContentType$.MODULE$.$lessinit$greater$default$3();
        }

        public ContentType(MediaType mediaType, Option<Boundary> boundary, Option<Charset> charset) {
            this.mediaType = mediaType;
            this.boundary = boundary;
            this.charset = charset;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ContentType)) return false;
            ContentType contentType = (ContentType)object;
            MediaType mediaType = this.mediaType();
            MediaType mediaType2 = contentType.mediaType();
            if (mediaType == null) {
                if (mediaType2 != null) {
                    return false;
                }
            } else if (!((Object)mediaType).equals(mediaType2)) return false;
            Option<Boundary> option = this.boundary();
            Option<Boundary> option2 = contentType.boundary();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Charset> option3 = this.charset();
            Option<Charset> option4 = contentType.charset();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ContentType;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ContentType";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "mediaType";
                }
                case 1: {
                    return "boundary";
                }
                case 2: {
                    return "charset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public MediaType mediaType() {
            return this.mediaType;
        }

        public Option<Boundary> boundary() {
            return this.boundary;
        }

        public Option<Charset> charset() {
            return this.charset;
        }

        public Header.ContentType asHeader() {
            return Header$ContentType$.MODULE$.apply(this.mediaType(), this.boundary(), this.charset());
        }

        public ContentType copy(MediaType mediaType, Option<Boundary> boundary, Option<Charset> charset) {
            return new ContentType(mediaType, boundary, charset);
        }

        public MediaType copy$default$1() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$2() {
            return this.boundary();
        }

        public Option<Charset> copy$default$3() {
            return this.charset();
        }

        public MediaType _1() {
            return this.mediaType();
        }

        public Option<Boundary> _2() {
            return this.boundary();
        }

        public Option<Charset> _3() {
            return this.charset();
        }
    }

    public static final class ErrorBody
    implements Body,
    Product,
    Serializable {
        private final Cause cause;

        public static ErrorBody apply(Cause<Throwable> cause) {
            return Body$ErrorBody$.MODULE$.apply(cause);
        }

        public static ErrorBody fromProduct(Product product) {
            return Body$ErrorBody$.MODULE$.fromProduct(product);
        }

        public static ErrorBody unapply(ErrorBody errorBody) {
            return Body$ErrorBody$.MODULE$.unapply(errorBody);
        }

        public ErrorBody(Cause<Throwable> cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ErrorBody)) return false;
            ErrorBody errorBody = (ErrorBody)object;
            Cause<Throwable> cause = this.cause();
            Cause<Throwable> cause2 = errorBody.cause();
            if (cause != null) {
                if (!cause.equals(cause2)) return false;
                return true;
            }
            if (cause2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ErrorBody;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ErrorBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Cause<Throwable> cause() {
            return this.cause;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return Exit$.MODULE$.failCause(this.cause());
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return Exit$.MODULE$.failCause(this.cause());
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.failCause(this::asStream$$anonfun$1, trace);
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "Body.failed";
        }

        @Override
        public Body contentType(ContentType newContentType) {
            return this;
        }

        @Override
        public Option<ContentType> contentType() {
            return None$.MODULE$;
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L));
        }

        public ErrorBody copy(Cause<Throwable> cause) {
            return new ErrorBody(cause);
        }

        public Cause<Throwable> copy$default$1() {
            return this.cause();
        }

        public Cause<Throwable> _1() {
            return this.cause();
        }

        private final Cause asStream$$anonfun$1() {
            return this.cause();
        }
    }

    public static final class FileBody
    implements Body,
    Product,
    Serializable {
        private final File file;
        private final int chunkSize;
        private final long fileSize;
        private final Option contentType;

        public static FileBody apply(File file, int n, long l, Option<ContentType> option) {
            return Body$FileBody$.MODULE$.apply(file, n, l, option);
        }

        public static FileBody fromProduct(Product product) {
            return Body$FileBody$.MODULE$.fromProduct(product);
        }

        public static FileBody unapply(FileBody fileBody) {
            return Body$FileBody$.MODULE$.unapply(fileBody);
        }

        public static int $lessinit$greater$default$2() {
            return Body$FileBody$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<ContentType> $lessinit$greater$default$4() {
            return Body$FileBody$.MODULE$.$lessinit$greater$default$4();
        }

        public FileBody(File file, int chunkSize, long fileSize, Option<ContentType> contentType) {
            this.file = file;
            this.chunkSize = chunkSize;
            this.fileSize = fileSize;
            this.contentType = contentType;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.file()));
            n = Statics.mix((int)n, (int)this.chunkSize());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileSize()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.contentType()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FileBody)) return false;
            FileBody fileBody = (FileBody)object;
            if (this.chunkSize() != fileBody.chunkSize()) return false;
            if (this.fileSize() != fileBody.fileSize()) return false;
            File file = this.file();
            File file2 = fileBody.file();
            if (file == null) {
                if (file2 != null) {
                    return false;
                }
            } else if (!((Object)file).equals(file2)) return false;
            Option<ContentType> option = this.contentType();
            Option<ContentType> option2 = fileBody.contentType();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FileBody;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "FileBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "file";
                }
                case 1: {
                    return "chunkSize";
                }
                case 2: {
                    return "fileSize";
                }
                case 3: {
                    return "contentType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public File file() {
            return this.file;
        }

        public int chunkSize() {
            return this.chunkSize;
        }

        public long fileSize() {
            return this.fileSize;
        }

        @Override
        public Option<ContentType> contentType() {
            return this.contentType;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$4 -> Files.readAllBytes(this.file().toPath()), trace);
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return this.asArray(trace).map((Function1 & Serializable)array -> Chunk$.MODULE$.fromArray(array), trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$4(trace), trace).flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), trace);
        }

        @Override
        public Body contentType(ContentType newContentType) {
            Some some = Some$.MODULE$.apply((Object)newContentType);
            File file = this.copy$default$1();
            int n = this.copy$default$2();
            long l = this.copy$default$3();
            return this.copy(file, n, l, (Option<ContentType>)some);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.fileSize()));
        }

        public FileBody copy(File file, int chunkSize, long fileSize, Option<ContentType> contentType) {
            return new FileBody(file, chunkSize, fileSize, contentType);
        }

        public File copy$default$1() {
            return this.file();
        }

        public int copy$default$2() {
            return this.chunkSize();
        }

        public long copy$default$3() {
            return this.fileSize();
        }

        public Option<ContentType> copy$default$4() {
            return this.contentType();
        }

        public File _1() {
            return this.file();
        }

        public int _2() {
            return this.chunkSize();
        }

        public long _3() {
            return this.fileSize();
        }

        public Option<ContentType> _4() {
            return this.contentType();
        }

        private final None$ asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2() {
            return None$.MODULE$;
        }

        private final /* synthetic */ ZIO asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3(Object trace$18, byte[] buffer$2, int len) {
            ZIO zIO;
            if (len > 0) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                zIO = ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$18, (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$ = Unsafe$.MODULE$;
                    Object object = Predef$.MODULE$.byteArrayOps(buffer$2);
                    return Chunk$.MODULE$.fromArray(ArrayOps$.MODULE$.slice$extension(object, 0, len));
                });
            } else {
                zIO = ZIO$.MODULE$.fail(this::asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2, trace$18);
            }
            return zIO.map((Function1 & Serializable)bytes -> bytes, trace$18);
        }

        private final ZIO asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Object trace$16, int size$1, FileInputStream fs$2) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$16, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$ = Unsafe$.MODULE$;
                return new byte[size$1];
            }).flatMap((Function1 & Serializable)buffer -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$9 -> fs$2.read((byte[])buffer), trace$16).mapError((Function1 & Serializable)_$10 -> Some$.MODULE$.apply(_$10), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$16).flatMap((Function1 & Serializable)len -> this.asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3(trace$16, (byte[])buffer, BoxesRunTime.unboxToInt((Object)len)), trace$16), trace$16);
        }

        private final ZIO asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(FileInputStream fs$5, Object trace$19) {
            return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$11 -> fs$5.close(), trace$19).ignoreLogged(trace$19);
        }

        private final /* synthetic */ ZStream asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2(Object trace$15, FileInputStream fs$1, int size) {
            return ZStream$.MODULE$.repeatZIOOption(() -> this.asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(trace$15, size, fs$1), trace$15).ensuring(() -> this.asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(fs$1, trace$15), trace$15);
        }

        private final ZIO asStream$$anonfun$4(Object trace$12) {
            return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$5 -> this.file(), trace$12).flatMap((Function1 & Serializable)file -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$6 -> new FileInputStream((File)file), trace$12).flatMap((Function1 & Serializable)fs -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$7 -> (int)Math.min((long)this.chunkSize(), file.length()), trace$12).map((Function1 & Serializable)size -> this.asStream$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2(trace$12, (FileInputStream)fs, BoxesRunTime.unboxToInt((Object)size)), trace$12), trace$12), trace$12);
        }
    }

    public static final class StreamBody
    implements Body,
    Product,
    Serializable {
        private final ZStream stream;
        private final Option knownContentLength;
        private final Option contentType;

        public static StreamBody apply(ZStream<Object, Throwable, Object> zStream, Option<Object> option, Option<ContentType> option2) {
            return Body$StreamBody$.MODULE$.apply(zStream, option, option2);
        }

        public static StreamBody fromProduct(Product product) {
            return Body$StreamBody$.MODULE$.fromProduct(product);
        }

        public static StreamBody unapply(StreamBody streamBody) {
            return Body$StreamBody$.MODULE$.unapply(streamBody);
        }

        public static Option<ContentType> $lessinit$greater$default$3() {
            return Body$StreamBody$.MODULE$.$lessinit$greater$default$3();
        }

        public StreamBody(ZStream<Object, Throwable, Object> stream, Option<Object> knownContentLength, Option<ContentType> contentType) {
            this.stream = stream;
            this.knownContentLength = knownContentLength;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StreamBody)) return false;
            StreamBody streamBody = (StreamBody)object;
            ZStream<Object, Throwable, Object> zStream = this.stream();
            ZStream<Object, Throwable, Object> zStream2 = streamBody.stream();
            if (zStream == null) {
                if (zStream2 != null) {
                    return false;
                }
            } else if (!zStream.equals(zStream2)) return false;
            Option<Object> option = this.knownContentLength();
            Option<Object> option2 = streamBody.knownContentLength();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<ContentType> option3 = this.contentType();
            Option<ContentType> option4 = streamBody.contentType();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StreamBody;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "StreamBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "stream";
                }
                case 1: {
                    return "knownContentLength";
                }
                case 2: {
                    return "contentType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ZStream<Object, Throwable, Object> stream() {
            return this.stream;
        }

        @Override
        public Option<Object> knownContentLength() {
            return this.knownContentLength;
        }

        @Override
        public Option<ContentType> contentType() {
            return this.contentType;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return this.asChunk(trace).map((Function1 & Serializable)_$11 -> (byte[])_$11.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), trace);
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return this.stream().runCollect(trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return this.stream();
        }

        @Override
        public Body contentType(ContentType newContentType) {
            Some some = Some$.MODULE$.apply((Object)newContentType);
            ZStream<Object, Throwable, Object> zStream = this.copy$default$1();
            Option<Object> option = this.copy$default$2();
            return this.copy(zStream, option, (Option<ContentType>)some);
        }

        public StreamBody copy(ZStream<Object, Throwable, Object> stream, Option<Object> knownContentLength, Option<ContentType> contentType) {
            return new StreamBody(stream, knownContentLength, contentType);
        }

        public ZStream<Object, Throwable, Object> copy$default$1() {
            return this.stream();
        }

        public Option<Object> copy$default$2() {
            return this.knownContentLength();
        }

        public Option<ContentType> copy$default$3() {
            return this.contentType();
        }

        public ZStream<Object, Throwable, Object> _1() {
            return this.stream();
        }

        public Option<Object> _2() {
            return this.knownContentLength();
        }

        public Option<ContentType> _3() {
            return this.contentType();
        }
    }

    public static abstract class UnsafeBytes
    implements Body {
        public abstract byte[] unsafeAsArray(Unsafe var1);

        @Override
        public final ZIO<Object, Nothing$, Body> materialize(Object trace) {
            return Exit$.MODULE$.succeed((Object)this);
        }
    }

    public static final class WebsocketBody
    implements Body,
    Product,
    Serializable {
        private final WebSocketApp socketApp;

        public static WebsocketBody apply(WebSocketApp<Object> webSocketApp) {
            return Body$WebsocketBody$.MODULE$.apply(webSocketApp);
        }

        public static WebsocketBody fromProduct(Product product) {
            return Body$WebsocketBody$.MODULE$.fromProduct(product);
        }

        public static WebsocketBody unapply(WebsocketBody websocketBody) {
            return Body$WebsocketBody$.MODULE$.unapply(websocketBody);
        }

        public WebsocketBody(WebSocketApp<Object> socketApp) {
            this.socketApp = socketApp;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WebsocketBody)) return false;
            WebsocketBody websocketBody = (WebsocketBody)object;
            WebSocketApp<Object> webSocketApp = this.socketApp();
            WebSocketApp<Object> webSocketApp2 = websocketBody.socketApp();
            if (webSocketApp != null) {
                if (!((Object)webSocketApp).equals(webSocketApp2)) return false;
                return true;
            }
            if (webSocketApp2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WebsocketBody;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "WebsocketBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "socketApp";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public WebSocketApp<Object> socketApp() {
            return this.socketApp;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return Body$.zio$http$Body$$$zioEmptyArray;
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return Body$.zio$http$Body$$$zioEmptyChunk;
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.empty(trace);
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Option<ContentType> contentType() {
            return None$.MODULE$;
        }

        @Override
        public Body contentType(ContentType newContentType) {
            return this;
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L));
        }

        public WebsocketBody copy(WebSocketApp<Object> socketApp) {
            return new WebsocketBody(socketApp);
        }

        public WebSocketApp<Object> copy$default$1() {
            return this.socketApp();
        }

        public WebSocketApp<Object> _1() {
            return this.socketApp();
        }
    }
}

