/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.time.Duration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import zio.Chunk;
import zio.http.Cookie$;
import zio.http.Cookie$Request$;
import zio.http.Cookie$Response$;
import zio.http.Cookie$SameSite$;
import zio.http.Path;
import zio.http.internal.CookieEncoding$;

public interface Cookie {
    public static Response clear(String string) {
        return Cookie$.MODULE$.clear(string);
    }

    public static Either<Exception, Chunk<Request>> decodeRequest(String string, boolean bl) {
        return Cookie$.MODULE$.decodeRequest(string, bl);
    }

    public static Either<Exception, Response> decodeResponse(String string, boolean bl) {
        return Cookie$.MODULE$.decodeResponse(string, bl);
    }

    public static int ordinal(Cookie cookie) {
        return Cookie$.MODULE$.ordinal(cookie);
    }

    public static boolean decodeRequest$default$2() {
        return Cookie$.MODULE$.decodeRequest$default$2();
    }

    public static boolean decodeResponse$default$2() {
        return Cookie$.MODULE$.decodeResponse$default$2();
    }

    public String name();

    public String content();

    public static Either encode$(Cookie $this) {
        return $this.encode();
    }

    default public Either<Exception, String> encode() {
        return this.encodeValidate(false);
    }

    public Either<Exception, String> encodeValidate(boolean var1);

    public static Request toRequest$(Cookie $this) {
        return $this.toRequest();
    }

    default public Request toRequest() {
        return Cookie$Request$.MODULE$.apply(this.name(), this.content());
    }

    public static Response toResponse$(Cookie $this) {
        return $this.toResponse();
    }

    default public Response toResponse() {
        return this.toResponse(this.toResponse$default$1(), this.toResponse$default$2(), this.toResponse$default$3(), this.toResponse$default$4(), this.toResponse$default$5(), this.toResponse$default$6());
    }

    public static Response toResponse$(Cookie $this, Option domain, Option path, boolean isSecure, boolean isHttpOnly, Option maxAge, Option sameSite) {
        return $this.toResponse((Option<String>)domain, (Option<Path>)path, isSecure, isHttpOnly, (Option<Duration>)maxAge, (Option<SameSite>)sameSite);
    }

    default public Response toResponse(Option<String> domain, Option<Path> path, boolean isSecure, boolean isHttpOnly, Option<Duration> maxAge, Option<SameSite> sameSite) {
        Cookie cookie = this;
        if (cookie instanceof Request) {
            Request request = Cookie$Request$.MODULE$.unapply((Request)cookie);
            String string = request._1();
            String string2 = request._2();
            return Cookie$Response$.MODULE$.apply(this.name(), this.content(), domain, path, isSecure, isHttpOnly, maxAge, sameSite);
        }
        if (cookie instanceof Response) {
            Response x = (Response)cookie;
            return x;
        }
        throw new MatchError((Object)cookie);
    }

    public static Option toResponse$default$1$(Cookie $this) {
        return $this.toResponse$default$1();
    }

    default public Option<String> toResponse$default$1() {
        return None$.MODULE$;
    }

    public static Option toResponse$default$2$(Cookie $this) {
        return $this.toResponse$default$2();
    }

    default public Option<Path> toResponse$default$2() {
        return None$.MODULE$;
    }

    public static boolean toResponse$default$3$(Cookie $this) {
        return $this.toResponse$default$3();
    }

    default public boolean toResponse$default$3() {
        return false;
    }

    public static boolean toResponse$default$4$(Cookie $this) {
        return $this.toResponse$default$4();
    }

    default public boolean toResponse$default$4() {
        return false;
    }

    public static Option toResponse$default$5$(Cookie $this) {
        return $this.toResponse$default$5();
    }

    default public Option<Duration> toResponse$default$5() {
        return None$.MODULE$;
    }

    public static Option toResponse$default$6$(Cookie $this) {
        return $this.toResponse$default$6();
    }

    default public Option<SameSite> toResponse$default$6() {
        return None$.MODULE$;
    }

    public Cookie content(String var1);

    public Cookie name(String var1);

    public static final class Request
    implements Cookie,
    Product,
    Serializable {
        private final String name;
        private final String content;

        public static Request apply(String string, String string2) {
            return Cookie$Request$.MODULE$.apply(string, string2);
        }

        public static Either<Exception, Chunk<Request>> decode(String string, boolean bl) {
            return Cookie$Request$.MODULE$.decode(string, bl);
        }

        public static Request fromProduct(Product product) {
            return Cookie$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return Cookie$Request$.MODULE$.unapply(request);
        }

        public static boolean decode$default$2() {
            return Cookie$Request$.MODULE$.decode$default$2();
        }

        public Request(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            String string = this.name();
            String string2 = request.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.content();
            String string4 = request.content();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "content";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String content() {
            return this.content;
        }

        @Override
        public Either<Exception, String> encodeValidate(boolean validate) {
            Left left;
            try {
                left = package$.MODULE$.Right().apply((Object)CookieEncoding$.MODULE$.default().encodeRequestCookie(this, validate));
            }
            catch (Exception e) {
                left = package$.MODULE$.Left().apply((Object)e);
            }
            return left;
        }

        public Option<Request> unSign(String secret) {
            int index = this.content().lastIndexOf(46);
            String signature = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(this.content()), index + 1, this.content().length());
            String value = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(this.content()), 0, index);
            String string = Cookie$.MODULE$.zio$http$Cookie$$$signature(secret, value);
            String string2 = signature;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Some$.MODULE$.apply((Object)this.content(value));
            }
            return None$.MODULE$;
        }

        @Override
        public Request name(String name) {
            return this.copy(name, this.copy$default$2());
        }

        @Override
        public Request content(String content) {
            return this.copy(this.copy$default$1(), content);
        }

        public Request copy(String name, String content) {
            return new Request(name, content);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.content();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.content();
        }
    }

    public static final class Response
    implements Cookie,
    Product,
    Serializable {
        private final String name;
        private final String content;
        private final Option domain;
        private final Option path;
        private final boolean isSecure;
        private final boolean isHttpOnly;
        private final Option maxAge;
        private final Option sameSite;

        public static Response apply(String string, String string2, Option<String> option, Option<Path> option2, boolean bl, boolean bl2, Option<Duration> option3, Option<SameSite> option4) {
            return Cookie$Response$.MODULE$.apply(string, string2, option, option2, bl, bl2, option3, option4);
        }

        public static Either<Exception, Response> decode(String string, boolean bl) {
            return Cookie$Response$.MODULE$.decode(string, bl);
        }

        public static Response fromProduct(Product product) {
            return Cookie$Response$.MODULE$.fromProduct(product);
        }

        public static Response unapply(Response response) {
            return Cookie$Response$.MODULE$.unapply(response);
        }

        public static boolean decode$default$2() {
            return Cookie$Response$.MODULE$.decode$default$2();
        }

        public static Option<String> $lessinit$greater$default$3() {
            return Cookie$Response$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<Path> $lessinit$greater$default$4() {
            return Cookie$Response$.MODULE$.$lessinit$greater$default$4();
        }

        public static boolean $lessinit$greater$default$5() {
            return Cookie$Response$.MODULE$.$lessinit$greater$default$5();
        }

        public static boolean $lessinit$greater$default$6() {
            return Cookie$Response$.MODULE$.$lessinit$greater$default$6();
        }

        public static Option<Duration> $lessinit$greater$default$7() {
            return Cookie$Response$.MODULE$.$lessinit$greater$default$7();
        }

        public static Option<SameSite> $lessinit$greater$default$8() {
            return Cookie$Response$.MODULE$.$lessinit$greater$default$8();
        }

        public Response(String name, String content, Option<String> domain, Option<Path> path, boolean isSecure, boolean isHttpOnly, Option<Duration> maxAge, Option<SameSite> sameSite) {
            this.name = name;
            this.content = content;
            this.domain = domain;
            this.path = path;
            this.isSecure = isSecure;
            this.isHttpOnly = isHttpOnly;
            this.maxAge = maxAge;
            this.sameSite = sameSite;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.content()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.domain()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.path()));
            n = Statics.mix((int)n, (int)(this.isSecure() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.isHttpOnly() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.maxAge()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.sameSite()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Response)) return false;
            Response response = (Response)object;
            if (this.isSecure() != response.isSecure()) return false;
            if (this.isHttpOnly() != response.isHttpOnly()) return false;
            String string = this.name();
            String string2 = response.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.content();
            String string4 = response.content();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.domain();
            Option<String> option2 = response.domain();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Path> option3 = this.path();
            Option<Path> option4 = response.path();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Duration> option5 = this.maxAge();
            Option<Duration> option6 = response.maxAge();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<SameSite> option7 = this.sameSite();
            Option<SameSite> option8 = response.sameSite();
            if (option7 == null) {
                if (option8 == null) return true;
                return false;
            } else {
                if (!option7.equals(option8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Response;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "Response";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "content";
                }
                case 2: {
                    return "domain";
                }
                case 3: {
                    return "path";
                }
                case 4: {
                    return "isSecure";
                }
                case 5: {
                    return "isHttpOnly";
                }
                case 6: {
                    return "maxAge";
                }
                case 7: {
                    return "sameSite";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String content() {
            return this.content;
        }

        public Option<String> domain() {
            return this.domain;
        }

        public Option<Path> path() {
            return this.path;
        }

        public boolean isSecure() {
            return this.isSecure;
        }

        public boolean isHttpOnly() {
            return this.isHttpOnly;
        }

        public Option<Duration> maxAge() {
            return this.maxAge;
        }

        public Option<SameSite> sameSite() {
            return this.sameSite;
        }

        @Override
        public Either<Exception, String> encodeValidate(boolean validate) {
            Left left;
            try {
                left = package$.MODULE$.Right().apply((Object)CookieEncoding$.MODULE$.default().encodeResponseCookie(this, validate));
            }
            catch (Exception e) {
                left = package$.MODULE$.Left().apply((Object)e);
            }
            return left;
        }

        public Response sign(String secret) {
            return this.content(new StringBuilder().append(this.content()).append('.').append(Cookie$.MODULE$.zio$http$Cookie$$$signature(secret, this.content())).result());
        }

        @Override
        public Response name(String name) {
            return this.copy(name, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        @Override
        public Response content(String content) {
            return this.copy(this.copy$default$1(), content, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public Response copy(String name, String content, Option<String> domain, Option<Path> path, boolean isSecure, boolean isHttpOnly, Option<Duration> maxAge, Option<SameSite> sameSite) {
            return new Response(name, content, domain, path, isSecure, isHttpOnly, maxAge, sameSite);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.content();
        }

        public Option<String> copy$default$3() {
            return this.domain();
        }

        public Option<Path> copy$default$4() {
            return this.path();
        }

        public boolean copy$default$5() {
            return this.isSecure();
        }

        public boolean copy$default$6() {
            return this.isHttpOnly();
        }

        public Option<Duration> copy$default$7() {
            return this.maxAge();
        }

        public Option<SameSite> copy$default$8() {
            return this.sameSite();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.content();
        }

        public Option<String> _3() {
            return this.domain();
        }

        public Option<Path> _4() {
            return this.path();
        }

        public boolean _5() {
            return this.isSecure();
        }

        public boolean _6() {
            return this.isHttpOnly();
        }

        public Option<Duration> _7() {
            return this.maxAge();
        }

        public Option<SameSite> _8() {
            return this.sameSite();
        }
    }

    public static interface SameSite {
        public static int ordinal(SameSite sameSite) {
            return Cookie$SameSite$.MODULE$.ordinal(sameSite);
        }

        public static List<SameSite> values() {
            return Cookie$SameSite$.MODULE$.values();
        }
    }
}

