/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Chunk;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.ErrorResponseConfig;
import zio.http.ErrorResponseConfig$;
import zio.http.ErrorResponseConfig$ErrorFormat$Html$;
import zio.http.ErrorResponseConfig$ErrorFormat$Json$;
import zio.http.ErrorResponseConfig$ErrorFormat$Text$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Header$Location$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Response;
import zio.http.Response$Patch$;
import zio.http.ServerSentEvent;
import zio.http.ServerSentEvent$;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$GatewayTimeout$;
import zio.http.Status$HttpVersionNotSupported$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$NetworkAuthenticationRequired$;
import zio.http.Status$NotExtended$;
import zio.http.Status$NotFound$;
import zio.http.Status$NotImplemented$;
import zio.http.Status$Ok$;
import zio.http.Status$PermanentRedirect$;
import zio.http.Status$RequestTimeout$;
import zio.http.Status$SeeOther$;
import zio.http.Status$ServiceUnavailable$;
import zio.http.Status$SwitchingProtocols$;
import zio.http.Status$TemporaryRedirect$;
import zio.http.Status$Unauthorized$;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.internal.OutputEncoder$;
import zio.http.template.Html;
import zio.http.template.Html$;
import zio.http.template.IsAttributeValue$;
import zio.http.template.Template$;
import zio.http.template.package$;
import zio.schema.Schema;
import zio.schema.codec.BinaryCodec;
import zio.stream.ZStream;

public final class Response$
implements Mirror.Product,
Serializable {
    public static final Response$Patch$ Patch;
    private volatile Object contentTypeJson$lzy1;
    private volatile Object contentTypeHtml$lzy1;
    private volatile Object contentTypeText$lzy1;
    private volatile Object contentTypeEventStream$lzy1;
    public static final Response$ MODULE$;

    private Response$() {
    }

    static {
        MODULE$ = new Response$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Response$.class);
    }

    public Response apply(Status status, Headers headers, Body body) {
        return new Response(status, headers, body);
    }

    public Response unapply(Response x$1) {
        return x$1;
    }

    public Status $lessinit$greater$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers $lessinit$greater$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body $lessinit$greater$default$3() {
        return Body$.MODULE$.empty();
    }

    public Response badRequest() {
        return this.error(Status$BadRequest$.MODULE$);
    }

    public Response badRequest(String message) {
        return this.error((Status.Error)Status$BadRequest$.MODULE$, message);
    }

    public Response error(Status.Error status, String message) {
        Body body = Body$.MODULE$.fromString(OutputEncoder$.MODULE$.encodeHtml(message), Body$.MODULE$.fromString$default$2());
        Headers headers = this.$lessinit$greater$default$2();
        return this.apply(status, headers, body);
    }

    public Response error(Status.Error status, Body body) {
        Headers headers = body.mediaType().isEmpty() ? Headers$.MODULE$.empty() : Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply((MediaType)body.mediaType().get(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())}));
        return this.apply(status, headers, body);
    }

    public Response error(Status.Error status) {
        return this.apply(status, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3());
    }

    public Response forbidden() {
        return this.error(Status$Forbidden$.MODULE$);
    }

    public Response forbidden(String message) {
        return this.error((Status.Error)Status$Forbidden$.MODULE$, message);
    }

    public Response fromCause(Cause<Object> cause) {
        return this.fromCause(cause, ErrorResponseConfig$.MODULE$.default());
    }

    public Response fromCause(Cause<Object> cause, ErrorResponseConfig config) {
        Body body;
        Either either;
        while ((either = cause.failureOrCause()) instanceof Left) {
            Cause failure;
            Object object = ((Left)either).value();
            if (object instanceof Response) {
                Response failure2 = (Response)object;
                return failure2;
            }
            if (object instanceof Throwable) {
                Throwable failure3 = (Throwable)object;
                return this.fromThrowable(failure3, config);
            }
            if (!(object instanceof Cause)) break;
            cause = failure = (Cause)object;
        }
        Body body2 = body = config.withErrorBody() ? Body$.MODULE$.fromString(cause.prettyPrint(), Body$.MODULE$.fromString$default$2()).contentType(MediaType$.MODULE$.text().plain()) : Body$.MODULE$.empty();
        if (cause.isInterruptedOnly()) {
            return this.error((Status.Error)Status$RequestTimeout$.MODULE$, body);
        }
        return this.error((Status.Error)Status$InternalServerError$.MODULE$, body);
    }

    public <E> Response fromCauseWith(Cause<E> cause, ErrorResponseConfig config, Function1<E, Response> f) {
        Either either = cause.failureOrCause();
        if (either instanceof Left) {
            Object failure = ((Left)either).value();
            return (Response)f.apply(failure);
        }
        if (either instanceof Right) {
            Cause cause2 = (Cause)((Right)either).value();
            return this.fromCause((Cause<Object>)cause2, config);
        }
        throw new MatchError((Object)either);
    }

    public <T> Response fromServerSentEvents(ZStream<Object, Nothing$, ServerSentEvent<T>> data, Schema<T> evidence$1, Object trace) {
        BinaryCodec codec = ServerSentEvent$.MODULE$.defaultBinaryCodec(evidence$1);
        return this.apply(Status$Ok$.MODULE$, this.contentTypeEventStream(), Body$.MODULE$.fromCharSequenceStreamChunked((ZStream<Object, Throwable, CharSequence>)data.map((Function1 & Serializable)value -> (Chunk)codec.encode(value), trace).map((Function1 & Serializable)_$2 -> _$2.asString(Chunk.IsText$.MODULE$.byteIsText()), trace), Body$.MODULE$.fromCharSequenceStreamChunked$default$2(), trace));
    }

    public <R> ZIO<R, Nothing$, Response> fromSocketApp(WebSocketApp<R> app, Object trace) {
        return ZIO$.MODULE$.environment(trace).map((Function1 & Serializable)env -> this.apply(Status$SwitchingProtocols$.MODULE$, Headers$.MODULE$.empty(), Body$.MODULE$.fromSocketApp(app.provideEnvironment((ZEnvironment)env, trace))), trace);
    }

    public Response fromThrowable(Throwable throwable) {
        return this.fromThrowable(throwable, ErrorResponseConfig$.MODULE$.default());
    }

    public Response fromThrowable(Throwable throwable, ErrorResponseConfig config) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof AccessDeniedException) {
            return this.error((Status.Error)Status$Forbidden$.MODULE$, this.throwableToMessage(throwable, Status$Forbidden$.MODULE$, config));
        }
        if (throwable2 instanceof IllegalAccessException) {
            return this.error((Status.Error)Status$Forbidden$.MODULE$, this.throwableToMessage(throwable, Status$Forbidden$.MODULE$, config));
        }
        if (throwable2 instanceof IllegalAccessError) {
            return this.error((Status.Error)Status$Forbidden$.MODULE$, this.throwableToMessage(throwable, Status$Forbidden$.MODULE$, config));
        }
        if (throwable2 instanceof NotDirectoryException) {
            return this.error((Status.Error)Status$BadRequest$.MODULE$, this.throwableToMessage(throwable, Status$BadRequest$.MODULE$, config));
        }
        if (throwable2 instanceof IllegalArgumentException) {
            return this.error((Status.Error)Status$BadRequest$.MODULE$, this.throwableToMessage(throwable, Status$BadRequest$.MODULE$, config));
        }
        if (throwable2 instanceof FileNotFoundException) {
            return this.error((Status.Error)Status$NotFound$.MODULE$, this.throwableToMessage(throwable, Status$NotFound$.MODULE$, config));
        }
        if (throwable2 instanceof ConnectException) {
            return this.error((Status.Error)Status$ServiceUnavailable$.MODULE$, this.throwableToMessage(throwable, Status$ServiceUnavailable$.MODULE$, config));
        }
        if (throwable2 instanceof SocketTimeoutException) {
            return this.error((Status.Error)Status$GatewayTimeout$.MODULE$, this.throwableToMessage(throwable, Status$GatewayTimeout$.MODULE$, config));
        }
        return this.error((Status.Error)Status$InternalServerError$.MODULE$, this.throwableToMessage(throwable, Status$InternalServerError$.MODULE$, config));
    }

    private Body throwableToMessage(Throwable throwable, Status status, ErrorResponseConfig config) {
        String string;
        Object object;
        Object[] rawTrace;
        if (!config.withErrorBody()) {
            return Body$.MODULE$.empty();
        }
        Object[] objectArray = rawTrace = config.withStackTrace() ? throwable.getStackTrace() : (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class));
        if (config.withStackTrace() && ArrayOps$.MODULE$.nonEmpty$extension(object = Predef$.MODULE$.refArrayOps(rawTrace))) {
            Object[] objectArray2;
            if (config.maxStackTraceDepth() == 0) {
                objectArray2 = rawTrace;
            } else {
                Object object2 = Predef$.MODULE$.refArrayOps(rawTrace);
                objectArray2 = (Object[])ArrayOps$.MODULE$.take$extension(object2, config.maxStackTraceDepth());
            }
            string = Predef$.MODULE$.wrapRefArray(objectArray2).mkString("\n", "\n", "");
        } else {
            string = "";
        }
        String stackTrace = string;
        String message = throwable.getMessage() == null ? "" : throwable.getMessage();
        return this.bodyFromThrowable(message, stackTrace, status, config);
    }

    private Body bodyFromThrowable(String message, String stackTrace, Status status, ErrorResponseConfig config) {
        ErrorResponseConfig.ErrorFormat errorFormat = config.errorFormat();
        if (ErrorResponseConfig$ErrorFormat$Html$.MODULE$.equals(errorFormat)) {
            return this.htmlResponse$1(status, message, stackTrace).contentType(config.errorFormat().mediaType());
        }
        if (ErrorResponseConfig$ErrorFormat$Text$.MODULE$.equals(errorFormat)) {
            return this.textResponse$1(status, message, stackTrace).contentType(config.errorFormat().mediaType());
        }
        if (ErrorResponseConfig$ErrorFormat$Json$.MODULE$.equals(errorFormat)) {
            return this.jsonMessage$1(status, message, stackTrace).contentType(config.errorFormat().mediaType());
        }
        throw new MatchError((Object)errorFormat);
    }

    public Response gatewayTimeout() {
        return this.error(Status$GatewayTimeout$.MODULE$);
    }

    public Response gatewayTimeout(String message) {
        return this.error((Status.Error)Status$GatewayTimeout$.MODULE$, message);
    }

    public Response html(Html data, Status status) {
        return this.apply(status, this.contentTypeHtml(), Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2()));
    }

    public Status html$default$2() {
        return Status$Ok$.MODULE$;
    }

    public Response httpVersionNotSupported() {
        return this.error(Status$HttpVersionNotSupported$.MODULE$);
    }

    public Response httpVersionNotSupported(String message) {
        return this.error((Status.Error)Status$HttpVersionNotSupported$.MODULE$, message);
    }

    public Response internalServerError() {
        return this.error(Status$InternalServerError$.MODULE$);
    }

    public Response internalServerError(String message) {
        return this.error((Status.Error)Status$InternalServerError$.MODULE$, message);
    }

    public Response json(CharSequence data) {
        return this.apply(Status$Ok$.MODULE$, this.contentTypeJson(), Body$.MODULE$.fromCharSequence(data, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response networkAuthenticationRequired() {
        return this.error(Status$NetworkAuthenticationRequired$.MODULE$);
    }

    public Response networkAuthenticationRequired(String message) {
        return this.error((Status.Error)Status$NetworkAuthenticationRequired$.MODULE$, message);
    }

    public Response notExtended() {
        return this.error(Status$NotExtended$.MODULE$);
    }

    public Response notExtended(String message) {
        return this.error((Status.Error)Status$NotExtended$.MODULE$, message);
    }

    public Response notFound() {
        return this.error(Status$NotFound$.MODULE$);
    }

    public Response notFound(String message) {
        return this.error((Status.Error)Status$NotFound$.MODULE$, message);
    }

    public Response notImplemented() {
        return this.error(Status$NotImplemented$.MODULE$);
    }

    public Response notImplemented(String message) {
        return this.error((Status.Error)Status$NotImplemented$.MODULE$, message);
    }

    public Response ok() {
        return this.status(Status$Ok$.MODULE$);
    }

    public Response redirect(URL location, boolean isPermanent) {
        Status.Redirection status = (Status.Redirection)(isPermanent ? Status$PermanentRedirect$.MODULE$ : Status$TemporaryRedirect$.MODULE$);
        return this.apply(status, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$Location$.MODULE$.apply(location)})), this.$lessinit$greater$default$3());
    }

    public boolean redirect$default$2() {
        return false;
    }

    public Response seeOther(URL location) {
        return this.apply(Status$SeeOther$.MODULE$, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$Location$.MODULE$.apply(location)})), this.$lessinit$greater$default$3());
    }

    public Response serviceUnavailable() {
        return this.error(Status$ServiceUnavailable$.MODULE$);
    }

    public Response serviceUnavailable(String message) {
        return this.error((Status.Error)Status$ServiceUnavailable$.MODULE$, message);
    }

    public Response status(Status status) {
        return this.apply(status, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3());
    }

    public Response text(CharSequence text) {
        return this.apply(Status$Ok$.MODULE$, this.contentTypeText(), Body$.MODULE$.fromCharSequence(text, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response unauthorized() {
        return this.error(Status$Unauthorized$.MODULE$);
    }

    public Response unauthorized(String message) {
        return this.error((Status.Error)Status$Unauthorized$.MODULE$, message);
    }

    private Headers contentTypeJson() {
        Object object = this.contentTypeJson$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeJson$lzyINIT1();
    }

    private Object contentTypeJson$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeJson$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.application().json(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeJson$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeJson$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Headers contentTypeHtml() {
        Object object = this.contentTypeHtml$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeHtml$lzyINIT1();
    }

    private Object contentTypeHtml$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeHtml$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.text().html(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeHtml$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeHtml$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Headers contentTypeText() {
        Object object = this.contentTypeText$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeText$lzyINIT1();
    }

    private Object contentTypeText$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeText$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.text().plain(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeText$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeText$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Headers contentTypeEventStream() {
        Object object = this.contentTypeEventStream$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeEventStream$lzyINIT1();
    }

    private Object contentTypeEventStream$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeEventStream$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.text().event$minusstream(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeEventStream$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeEventStream$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Response fromProduct(Product x$0) {
        return new Response((Status)x$0.productElement(0), (Headers)x$0.productElement(1), (Body)x$0.productElement(2));
    }

    private final Body htmlResponse$1(Status status$4, String message$1, String stackTrace$1) {
        Html data = Template$.MODULE$.container(String.valueOf(status$4), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{package$.MODULE$.styles().$colon$eq("text-align: center", IsAttributeValue$.MODULE$.instanceString()), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(String.valueOf(BoxesRunTime.boxToInteger((int)status$4.code()))), package$.MODULE$.styles().$colon$eq("font-size: 20em", IsAttributeValue$.MODULE$.instanceString())}))), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(message$1)}))), Html$.MODULE$.fromDomElement(package$.MODULE$.div().apply((Seq<Html>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Html[]{Html$.MODULE$.fromString(stackTrace$1)})))})))}))));
        return Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2());
    }

    private final Body textResponse$1(Status status$5, String message$2, String stackTrace$2) {
        int statusCode = status$5.code();
        return Body$.MODULE$.fromString(new StringBuilder(16).append("\u001b[1m").append("\u001b[31m").append(status$5).append("\u001b[0m").append(" - ").append(new StringBuilder(16).append("\u001b[1m").append("\u001b[36m").append(statusCode).append("\u001b[0m").append(" - ").toString()).append(String.valueOf(message$2)).append(new StringBuilder(15).append("\u001b[1m").append("\u001b[31m").append(" ").append(stackTrace$2).append(" ").append("\u001b[0m").toString()).toString(), Body$.MODULE$.fromString$default$2());
    }

    private final Body jsonMessage$1(Status status$6, String message$3, String stackTrace$3) {
        return Body$.MODULE$.fromString(new StringBuilder(47).append("{\"status\": \"").append(status$6.code()).append("\", \"message\": \"").append(message$3).append("\", \"stackTrace\": \"").append(stackTrace$3).append("\"}").toString(), Body$.MODULE$.fromString$default$2());
    }
}

