/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.stream.ChunkedWriteHandler;
import zio.http.netty.package$Names$;

public class HybridContentLengthHandler
extends ChannelInboundHandlerAdapter {
    private final int maxAggregatedLength;
    private int maxLength;

    public HybridContentLengthHandler(int maxAggregatedLength) {
        this.maxAggregatedLength = maxAggregatedLength;
        this.maxLength = maxAggregatedLength;
    }

    public int maxLength() {
        return this.maxLength;
    }

    public void maxLength_$eq(int x$1) {
        this.maxLength = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof HttpMessage) {
            HttpMessage httpMessage = (HttpMessage)object;
            long contentLength = HttpUtil.getContentLength((HttpMessage)httpMessage, (long)-1L);
            if (contentLength > (long)this.maxAggregatedLength) {
                if (ctx.pipeline().get(HttpObjectAggregator.class) != null) {
                    ctx.pipeline().replace(HttpObjectAggregator.class, package$Names$.MODULE$.ChunkedWriteHandler(), (ChannelHandler)new ChunkedWriteHandler());
                }
            } else if (ctx.pipeline().get(ChunkedWriteHandler.class) != null) {
                ctx.pipeline().replace(ChunkedWriteHandler.class, package$Names$.MODULE$.HttpObjectAggregator(), (ChannelHandler)new HttpObjectAggregator(this.maxLength()));
            }
        }
        ctx.fireChannelRead(msg);
    }
}

