/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple4$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Handler;
import zio.http.Handler$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.MediaType;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Status;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public interface HandlerPlatformSpecific {
    public static Handler fromResource$(HandlerPlatformSpecific $this, String path, Object trace) {
        return $this.fromResource(path, trace);
    }

    default public Handler<Object, Throwable, Object, Response> fromResource(String path, Object trace) {
        return Handler$.MODULE$.fromZIO(() -> this.fromResource$$anonfun$1(path, trace)).flatten($less$colon$less$.MODULE$.refl(), trace);
    }

    public static Handler fromResourceWithURL$(HandlerPlatformSpecific $this, URL url, Object trace) {
        return $this.fromResourceWithURL(url, trace);
    }

    default public Handler<Object, Throwable, Object, Response> fromResourceWithURL(URL url, Object trace) {
        String string = url.getProtocol();
        if ("file".equals(string)) {
            return Handler$.MODULE$.fromFile((Function0<File>)((Function0 & Serializable)() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$1(url)), trace);
        }
        if ("jar".equals(string)) {
            String path = new URI(url.getPath()).getPath();
            int bangIndex = path.indexOf(33);
            String filePath = path.substring(0, bangIndex);
            String resourcePath = path.substring(bangIndex + 2);
            Option<MediaType> mediaType = ((Handler$)this).determineMediaType(resourcePath);
            ZIO openZip = ZIO$.MODULE$.attemptBlockingIO((Function1 & Serializable)evidence$2 -> new ZipFile(filePath), trace);
            Function1 & Serializable closeZip = (Function1 & Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$3 -> jar.close(), trace).ignoreLogged(trace);
            return Handler$.MODULE$.fromZIO(() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$2(openZip, closeZip, resourcePath, trace, mediaType));
        }
        String proto = string;
        return Handler$.MODULE$.fail(() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$3(proto));
    }

    public static Handler getResource$(HandlerPlatformSpecific $this, String path, Object trace) {
        return $this.getResource(path, trace);
    }

    default public Handler<Object, Throwable, Object, URL> getResource(String path, Object trace) {
        return Handler$.MODULE$.fromZIO(() -> this.getResource$$anonfun$1(path, trace)).flatMap((Function1 & Serializable)resource -> {
            if (resource == null) {
                return Handler$.MODULE$.fail(() -> HandlerPlatformSpecific.getResource$$anonfun$2$$anonfun$1(path));
            }
            return Handler$.MODULE$.succeed(() -> HandlerPlatformSpecific.getResource$$anonfun$2$$anonfun$2(resource));
        }, trace);
    }

    public static Handler getResourceAsFile$(HandlerPlatformSpecific $this, String path, Object trace) {
        return $this.getResourceAsFile(path, trace);
    }

    default public Handler<Object, Throwable, Object, File> getResourceAsFile(String path, Object trace) {
        return this.getResource(path, trace).map((Function1 & Serializable)url -> new File(url.getPath()), trace);
    }

    private static FileNotFoundException fromResource$$anonfun$1$$anonfun$2$$anonfun$1(String path$4) {
        return new FileNotFoundException(new StringBuilder(19).append("Resource ").append(path$4).append(" not found").toString());
    }

    private ZIO fromResource$$anonfun$1(String path$1, Object trace$1) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$1 -> this.getClass().getClassLoader().getResource(path$1), trace$1).map((Function1 & Serializable)resource -> {
            if (resource == null) {
                return Handler$.MODULE$.fail(() -> HandlerPlatformSpecific.fromResource$$anonfun$1$$anonfun$2$$anonfun$1(path$1));
            }
            return this.fromResourceWithURL((URL)resource, trace$1);
        }, trace$1);
    }

    private static File fromResourceWithURL$$anonfun$1(URL url$1) {
        return new File(url$1.getPath());
    }

    private static FileNotFoundException fileNotFound$1(String resourcePath$1) {
        return new FileNotFoundException(new StringBuilder(19).append("Resource ").append(resourcePath$1).append(" not found").toString());
    }

    private static IllegalArgumentException isDirectory$1(String resourcePath$2) {
        return new IllegalArgumentException(new StringBuilder(24).append("Resource ").append(resourcePath$2).append(" is a directory").toString());
    }

    private static ZIO fromResourceWithURL$$anonfun$2$$anonfun$1(ZIO openZip$2) {
        return openZip$2;
    }

    private static Throwable fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$2(String resourcePath$11) {
        return HandlerPlatformSpecific.fileNotFound$1(resourcePath$11);
    }

    private static boolean fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1(ZipEntry entry$1) {
        return entry$1.isDirectory();
    }

    private static IllegalArgumentException fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(String resourcePath$12) {
        return HandlerPlatformSpecific.isDirectory$1(resourcePath$12);
    }

    private static ZIO fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2(Object trace$7, String resourcePath$7) {
        return ZIO$.MODULE$.fail(() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(resourcePath$7), trace$7);
    }

    private static ZIO $anonfun$3(ZIO openZip$6) {
        return openZip$6;
    }

    private static InputStream $anonfun$5$$anonfun$1(ZipFile jar$4, ZipEntry entry$3) {
        return jar$4.getInputStream(entry$3);
    }

    private static int $anonfun$5$$anonfun$2() {
        return ZStream$.MODULE$.fromInputStream$default$2();
    }

    private static Response fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$1(Response response$1) {
        return response$1;
    }

    private static ZIO fromResourceWithURL$$anonfun$2(ZIO openZip$1, Function1 closeZip$1, String resourcePath$3, Object trace$4, Option mediaType$1) {
        Function0 function0 = ZIO$.MODULE$.acquireReleaseWith(() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$2$$anonfun$1(openZip$1));
        return ZIO.Acquire$.MODULE$.apply$extension(function0, closeZip$1).apply((Function1 & Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$4 -> Option$.MODULE$.apply((Object)jar.getEntry(resourcePath$3)), trace$4).collect(() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$2(resourcePath$3), (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    ZipEntry e = (ZipEntry)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    ZipEntry e = (ZipEntry)((Some)option).value();
                    return e;
                }
                return function1.apply((Object)x);
            }
        }, trace$4).flatMap((Function1 & Serializable)entry -> ZIO$.MODULE$.when(() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1(entry), () -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2(trace$4, resourcePath$3), trace$4).map((Function1 & Serializable)x$12 -> {
            Option option;
            Option $1$ = option = x$12;
            long contentLength = entry.getSize();
            ZStream inZStream = ZStream$.MODULE$.acquireReleaseWith(() -> HandlerPlatformSpecific.$anonfun$3(openZip$1), closeZip$1, trace$4).mapZIO((Function1 & Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$5 -> {
                ZipEntry zipEntry = (ZipEntry)Predef$.MODULE$.ArrowAssoc((Object)jar.getEntry(resourcePath$3));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)zipEntry, jar);
            }, trace$4), trace$4).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ZipEntry entry = (ZipEntry)tuple2._1();
                    ZipFile jar = (ZipFile)tuple2._2();
                    return ZStream$.MODULE$.fromInputStream(() -> HandlerPlatformSpecific.$anonfun$5$$anonfun$1(jar, entry), HandlerPlatformSpecific::$anonfun$5$$anonfun$2, trace$4);
                }
                throw new MatchError((Object)tuple2);
            }, trace$4);
            Body body = Body$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)inZStream, contentLength);
            Status status = Response$.MODULE$.$lessinit$greater$default$1();
            Headers headers = Response$.MODULE$.$lessinit$greater$default$2();
            Response response = Response$.MODULE$.apply(status, headers, body);
            return Tuple4$.MODULE$.apply((Object)$1$, (Object)BoxesRunTime.boxToLong((long)contentLength), (Object)inZStream, (Object)response);
        }, trace$4).map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                long contentLength = BoxesRunTime.unboxToLong((Object)tuple4._2());
                ZStream inZStream = (ZStream)tuple4._3();
                Response response = (Response)tuple4._4();
                return (Response)mediaType$1.fold(() -> HandlerPlatformSpecific.fromResourceWithURL$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$4$$anonfun$1(response), (Function1 & Serializable)t -> (Response)response.addHeader(Header$ContentType$.MODULE$.apply((MediaType)t, Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())));
            }
            throw new MatchError((Object)tuple4);
        }, trace$4), trace$4), trace$4);
    }

    private static IllegalArgumentException fromResourceWithURL$$anonfun$3(String proto$1) {
        return new IllegalArgumentException(new StringBuilder(22).append("Unsupported protocol: ").append(proto$1).toString());
    }

    private ZIO getResource$$anonfun$1(String path$5, Object trace$11) {
        return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$6 -> this.getClass().getClassLoader().getResource(path$5), trace$11);
    }

    private static IllegalArgumentException getResource$$anonfun$2$$anonfun$1(String path$8) {
        return new IllegalArgumentException(new StringBuilder(19).append("Resource ").append(path$8).append(" not found").toString());
    }

    private static URL getResource$$anonfun$2$$anonfun$2(URL resource$1) {
        return resource$1;
    }
}

