/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Path$;
import zio.http.Path$Flag$;
import zio.http.Path$Flag$LeadingSlash$;
import zio.http.Path$Flag$TrailingSlash$;
import zio.http.Path$Flags$;

public final class Path
implements Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Path.class.getDeclaredField("unapplyRight$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Path.class.getDeclaredField("unapply$lzy1"));
    private final int flags;
    private final Chunk segments;
    private volatile Object unapply$lzy1;
    private volatile Object unapplyRight$lzy1;

    public static Path apply(int n, Chunk<String> chunk) {
        return Path$.MODULE$.apply(n, chunk);
    }

    public static Path apply(String string) {
        return Path$.MODULE$.apply(string);
    }

    public static Path decode(String string) {
        return Path$.MODULE$.decode(string);
    }

    public static Path empty() {
        return Path$.MODULE$.empty();
    }

    public static Path fromProduct(Product product) {
        return Path$.MODULE$.fromProduct(product);
    }

    public static Path root() {
        return Path$.MODULE$.root();
    }

    public Path(int flags, Chunk<String> segments) {
        this.flags = flags;
        this.segments = segments;
    }

    public boolean canEqual(Object that) {
        return that instanceof Path;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Path";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToInteger((int)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "flags";
        }
        if (1 == n2) {
            return "segments";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int flags() {
        return this.flags;
    }

    public Chunk<String> segments() {
        return this.segments;
    }

    public Path $div(String name) {
        String string = name;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.addTrailingSlash();
        }
        if (this.isRoot()) {
            return Path$.MODULE$.apply(Path$Flags$.MODULE$.apply(Path$Flag$LeadingSlash$.MODULE$, (Seq<Flag>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Flag[0])), (Chunk<String>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name})));
        }
        return Path$.MODULE$.apply(Path$Flag$TrailingSlash$.MODULE$.remove(this.flags()), (Chunk<String>)((Chunk)this.segments().$colon$plus((Object)name)));
    }

    public Path $div$colon(String name) {
        String string = name;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.addLeadingSlash();
        }
        if (this.isRoot()) {
            return Path$.MODULE$.apply(Path$Flags$.MODULE$.apply(Path$Flag$TrailingSlash$.MODULE$, (Seq<Flag>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Flag[0])), (Chunk<String>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name})));
        }
        return Path$.MODULE$.apply(Path$Flag$LeadingSlash$.MODULE$.remove(this.flags()), (Chunk<String>)((Chunk)this.segments().$plus$colon((Object)name)));
    }

    public Path $plus$plus(Path that) {
        if (this.isEmpty()) {
            return that;
        }
        if (that.isEmpty()) {
            return this;
        }
        return Path$.MODULE$.apply(Path$Flags$.MODULE$.concat(this.normalize().flags(), that.normalize().flags()), (Chunk<String>)this.segments().$plus$plus(that.segments()));
    }

    public Path addLeadingSlash() {
        if (this.hasLeadingSlash()) {
            return this;
        }
        if (this.segments().isEmpty()) {
            return Path$.MODULE$.apply(Path$Flags$.MODULE$.apply(Path$Flag$LeadingSlash$.MODULE$, (Seq<Flag>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Flag[0])), (Chunk<String>)Chunk$.MODULE$.empty());
        }
        return Path$.MODULE$.apply(Path$Flag$LeadingSlash$.MODULE$.add(this.flags()), this.segments());
    }

    public Path addTrailingSlash() {
        if (this.hasTrailingSlash()) {
            return this;
        }
        if (this.segments().isEmpty()) {
            return Path$.MODULE$.apply(Path$Flags$.MODULE$.apply(Path$Flag$TrailingSlash$.MODULE$, (Seq<Flag>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Flag[0])), (Chunk<String>)Chunk$.MODULE$.empty());
        }
        return Path$.MODULE$.apply(Path$Flag$TrailingSlash$.MODULE$.add(this.flags()), this.segments());
    }

    public Path concat(Path other) {
        return this.$plus$plus(other);
    }

    public Path drop(int n) {
        while (true) {
            if (n <= 0) {
                return this_;
            }
            if (this_.isRoot()) {
                return Path$.MODULE$.empty();
            }
            if (!this_.hasLeadingSlash()) break;
            Path path = this_.dropLeadingSlash();
            int n2 = n - 1;
            Path this_ = path;
            n = n2;
        }
        Chunk chunk = this_.segments().drop(n);
        int n3 = this_.copy$default$1();
        return this_.copy(n3, (Chunk<String>)chunk);
    }

    public Path dropRight(int n) {
        return this.take(this.size() - n);
    }

    public Path dropLeadingSlash() {
        if (this.isRoot()) {
            return Path$.MODULE$.empty();
        }
        if (!Path$Flag$LeadingSlash$.MODULE$.check(this.flags())) {
            return this;
        }
        return this.copy(Path$Flag$LeadingSlash$.MODULE$.remove(this.flags()), this.copy$default$2());
    }

    public Path dropTrailingSlash() {
        if (this.isRoot()) {
            return Path$.MODULE$.empty();
        }
        if (!Path$Flag$TrailingSlash$.MODULE$.check(this.flags())) {
            return this;
        }
        return this.copy(Path$Flag$TrailingSlash$.MODULE$.remove(this.flags()), this.copy$default$2());
    }

    public String encode() {
        Path path = this;
        Path path2 = Path$.MODULE$.empty();
        if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
            return "";
        }
        Path path3 = this;
        Path path4 = Path$.MODULE$.root();
        if (!(path3 != null ? !((Object)path3).equals(path4) : path4 != null)) {
            return "/";
        }
        return this.segments().mkString(this.hasLeadingSlash() ? "/" : "", "/", this.hasTrailingSlash() ? "/" : "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Path)) return false;
        Path that2 = (Path)object;
        Path normalLeft = this.normalize();
        Path normalRight = that2.normalize();
        if (!Path$Flags$.MODULE$.equivalent(normalLeft.flags(), normalRight.flags())) return false;
        Chunk<String> chunk = normalLeft.segments();
        Chunk<String> chunk2 = normalRight.segments();
        if (chunk != null) {
            if (!chunk.equals(chunk2)) return false;
            return true;
        }
        if (chunk2 == null) return true;
        return false;
    }

    public boolean hasLeadingSlash() {
        return Path$Flag$LeadingSlash$.MODULE$.check(this.flags());
    }

    public boolean hasTrailingSlash() {
        return Path$Flag$TrailingSlash$.MODULE$.check(this.flags());
    }

    public int hashCode() {
        Path normalized = this.normalize();
        int result = 17;
        result = 31 * result + Path$Flags$.MODULE$.essential(normalized.flags());
        result = 31 * result + normalized.segments().hashCode();
        return result;
    }

    public boolean isEmpty() {
        return this.segments().isEmpty() && this.flags() == Path$Flags$.MODULE$.none();
    }

    public boolean isRoot() {
        return this.segments().isEmpty() && (this.hasLeadingSlash() || this.hasTrailingSlash());
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public Path normalize() {
        if (this.segments().isEmpty()) {
            if (this.hasLeadingSlash()) {
                return Path$.MODULE$.root();
            }
            if (this.hasTrailingSlash()) {
                return Path$.MODULE$.root();
            }
            return Path$.MODULE$.empty();
        }
        return this;
    }

    public Path removeDotSegments() {
        boolean loop;
        int i;
        Object[] segments = new String[this.segments().length()];
        int segmentCount = 0;
        int flags = this.flags();
        int max = this.segments().length();
        if (!Path$Flag$LeadingSlash$.MODULE$.check(flags)) {
            for (i = 0; i < max; ++i) {
                Object object = this.segments().apply(i);
                String string = ".";
                Object object2 = this.segments().apply(i);
                String string2 = "..";
                if (!(!(object != null ? !object.equals(string) : string != null) | !(object2 != null ? !object2.equals(string2) : string2 != null))) break;
            }
            if (i == max) {
                flags = Path$Flag$TrailingSlash$.MODULE$.remove(flags);
            }
        }
        boolean bl = loop = i < max;
        while (loop) {
            String segment = (String)this.segments().apply(i);
            loop = ++i < max;
            String string = segment;
            String string3 = "..";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                if ((segmentCount = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(segmentCount - 1), 0)) == 0) {
                    flags = Path$Flag$LeadingSlash$.MODULE$.add(flags);
                }
                if (i != max) continue;
                flags = Path$Flag$TrailingSlash$.MODULE$.add(flags);
                continue;
            }
            String string4 = segment;
            String string5 = ".";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                if (i != max) continue;
                flags = Path$Flag$TrailingSlash$.MODULE$.add(flags);
                continue;
            }
            segments[segmentCount] = segment;
            ++segmentCount;
        }
        Object object = Predef$.MODULE$.refArrayOps(segments);
        return Path$.MODULE$.apply(flags, (Chunk<String>)Chunk$.MODULE$.fromArray(ArrayOps$.MODULE$.take$extension(object, segmentCount)));
    }

    public Path reverse() {
        return Path$.MODULE$.apply(Path$Flags$.MODULE$.reverse(this.flags()), (Chunk<String>)((Chunk)this.segments().reverse()));
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isRoot()) {
            return 1;
        }
        return this.segments().length() + (this.hasLeadingSlash() ? 1 : 0) + (this.hasTrailingSlash() ? 1 : 0);
    }

    public boolean startsWith(Path other) {
        return this.hasLeadingSlash() == other.hasLeadingSlash() && this.segments().startsWith(other.segments(), this.segments().startsWith$default$2());
    }

    public Path take(int n) {
        if (n <= 0) {
            return Path$.MODULE$.empty();
        }
        if (n >= this.size()) {
            return this;
        }
        return Path$.MODULE$.apply(Path$Flag$TrailingSlash$.MODULE$.remove(this.flags()), (Chunk<String>)this.segments().take(n - (this.hasLeadingSlash() ? 1 : 0)));
    }

    public String toString() {
        return this.encode();
    }

    public Option<Tuple2<String, Path>> unapply() {
        Object object = this.unapply$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.unapply$lzyINIT1();
    }

    private Object unapply$lzyINIT1() {
        Object object;
        block12: {
            while (true) {
                if ((object = this.unapply$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Some some = null;
                    try {
                        Object object3;
                        if (this.hasLeadingSlash()) {
                            object3 = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"", (Object)this.drop(1)));
                        } else if (this.segments().nonEmpty()) {
                            Chunk chunk = this.segments().drop(1);
                            int n = this.copy$default$1();
                            object3 = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(this.segments().head(), (Object)this.copy(n, (Chunk<String>)chunk)));
                        } else {
                            object3 = some = this.hasTrailingSlash() ? Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"", (Object)Path$.MODULE$.empty())) : None$.MODULE$;
                        }
                        object2 = some == null ? LazyVals.NullValue$.MODULE$ : some;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.unapply$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return some;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block12;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<Tuple2<Path, String>> unapplyRight() {
        Object object = this.unapplyRight$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.unapplyRight$lzyINIT1();
    }

    private Object unapplyRight$lzyINIT1() {
        Object object;
        block12: {
            while (true) {
                if ((object = this.unapplyRight$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Some some = null;
                    try {
                        Object object3;
                        if (this.hasTrailingSlash()) {
                            object3 = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)this.dropRight(1), (Object)""));
                        } else if (this.segments().nonEmpty()) {
                            Chunk chunk = this.segments().dropRight(1);
                            int n = this.copy$default$1();
                            object3 = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)this.copy(n, (Chunk<String>)chunk), this.segments().last()));
                        } else {
                            object3 = some = this.hasLeadingSlash() ? Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)Path$.MODULE$.empty(), (Object)"")) : None$.MODULE$;
                        }
                        object2 = some == null ? LazyVals.NullValue$.MODULE$ : some;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.unapplyRight$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return some;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block12;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Path unnest(Path prefix) {
        if (this.startsWith(prefix)) {
            return this.drop(prefix.size());
        }
        return this;
    }

    public Path copy(int flags, Chunk<String> segments) {
        return new Path(flags, segments);
    }

    public int copy$default$1() {
        return this.flags();
    }

    public Chunk<String> copy$default$2() {
        return this.segments();
    }

    public int _1() {
        return this.flags();
    }

    public Chunk<String> _2() {
        return this.segments();
    }

    public static interface Flag {
        public static int ordinal(Flag flag) {
            return Path$Flag$.MODULE$.ordinal(flag);
        }

        public int shift();

        public int mask();

        public int invertMask();

        public static boolean check$(Flag $this, int flags) {
            return $this.check(flags);
        }

        default public boolean check(int flags) {
            return (flags & this.mask()) != 0;
        }

        public static int add$(Flag $this, int flags) {
            return $this.add(flags);
        }

        default public int add(int flags) {
            return flags | this.mask();
        }

        public static int remove$(Flag $this, int flags) {
            return $this.remove(flags);
        }

        default public int remove(int flags) {
            return flags & this.invertMask();
        }
    }
}

