/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NotDirectoryException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.ZEnvironment;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Header$Location$;
import zio.http.Header$Warning$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType$;
import zio.http.Response;
import zio.http.Response$Patch$;
import zio.http.ServerSentEvent;
import zio.http.Status;
import zio.http.Status$BadRequest$;
import zio.http.Status$Forbidden$;
import zio.http.Status$GatewayTimeout$;
import zio.http.Status$HttpVersionNotSupported$;
import zio.http.Status$InternalServerError$;
import zio.http.Status$NetworkAuthenticationRequired$;
import zio.http.Status$NotExtended$;
import zio.http.Status$NotFound$;
import zio.http.Status$NotImplemented$;
import zio.http.Status$Ok$;
import zio.http.Status$PermanentRedirect$;
import zio.http.Status$RequestTimeout$;
import zio.http.Status$SeeOther$;
import zio.http.Status$ServiceUnavailable$;
import zio.http.Status$SwitchingProtocols$;
import zio.http.Status$TemporaryRedirect$;
import zio.http.Status$Unauthorized$;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.internal.OutputEncoder$;
import zio.http.template.Html;
import zio.stream.ZStream;

public final class Response$
implements Mirror.Product,
Serializable {
    public static final Response$Patch$ Patch;
    private volatile Object contentTypeJson$lzy1;
    private volatile Object contentTypeHtml$lzy1;
    private volatile Object contentTypeText$lzy1;
    private volatile Object contentTypeEventStream$lzy1;
    public static final Response$ MODULE$;

    private Response$() {
    }

    static {
        MODULE$ = new Response$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Response$.class);
    }

    public Response apply(Status status, Headers headers, Body body) {
        return new Response(status, headers, body);
    }

    public Response unapply(Response x$1) {
        return x$1;
    }

    public Status $lessinit$greater$default$1() {
        return Status$Ok$.MODULE$;
    }

    public Headers $lessinit$greater$default$2() {
        return Headers$.MODULE$.empty();
    }

    public Body $lessinit$greater$default$3() {
        return Body$.MODULE$.empty();
    }

    public Response badRequest() {
        return this.error(Status$BadRequest$.MODULE$);
    }

    public Response badRequest(String message) {
        return this.error(Status$BadRequest$.MODULE$, message);
    }

    public Response error(Status.Error status, String message) {
        String message2 = OutputEncoder$.MODULE$.encodeHtml(message == null ? status.text() : message);
        return this.apply(status, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$Warning$.MODULE$.apply(199, "ZIO HTTP", message2, Header$Warning$.MODULE$.$lessinit$greater$default$4())})), this.$lessinit$greater$default$3());
    }

    public Response error(Status.Error status) {
        return this.error(status, status.text());
    }

    public Response forbidden() {
        return this.error(Status$Forbidden$.MODULE$);
    }

    public Response forbidden(String message) {
        return this.error(Status$Forbidden$.MODULE$, message);
    }

    public Response fromCause(Cause<Object> cause) {
        Either either;
        while ((either = cause.failureOrCause()) instanceof Left) {
            Cause failure;
            Object object = ((Left)either).value();
            if (object instanceof Response) {
                Response failure2 = (Response)object;
                return failure2;
            }
            if (object instanceof Throwable) {
                Throwable failure3 = (Throwable)object;
                return this.fromThrowable(failure3);
            }
            if (!(object instanceof Cause)) break;
            cause = failure = (Cause)object;
        }
        if (cause.isInterruptedOnly()) {
            return this.error(Status$RequestTimeout$.MODULE$, StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(cause.prettyPrint()), 100));
        }
        return this.error(Status$InternalServerError$.MODULE$, StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(cause.prettyPrint()), 100));
    }

    public <E> Response fromCauseWith(Cause<E> cause, Function1<E, Response> f) {
        Either either = cause.failureOrCause();
        if (either instanceof Left) {
            Object failure = ((Left)either).value();
            return (Response)f.apply(failure);
        }
        if (either instanceof Right) {
            Cause cause2 = (Cause)((Right)either).value();
            return this.fromCause((Cause<Object>)cause2);
        }
        throw new MatchError((Object)either);
    }

    public Response fromServerSentEvents(ZStream<Object, Nothing$, ServerSentEvent> data, Object trace) {
        return this.apply(Status$Ok$.MODULE$, this.contentTypeEventStream(), Body$.MODULE$.fromCharSequenceStreamChunked((ZStream<Object, Throwable, CharSequence>)data.map((Function1 & Serializable)_$3 -> _$3.encode(), trace), Body$.MODULE$.fromCharSequenceStreamChunked$default$2(), trace));
    }

    public <R> ZIO<R, Nothing$, Response> fromSocketApp(WebSocketApp<R> app, Object trace) {
        return ZIO$.MODULE$.environment(trace).map((Function1 & Serializable)env -> this.apply(Status$SwitchingProtocols$.MODULE$, Headers$.MODULE$.empty(), Body$.MODULE$.fromSocketApp(app.provideEnvironment((ZEnvironment)env, trace))), trace);
    }

    public Response fromThrowable(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof AccessDeniedException) {
            return this.error(Status$Forbidden$.MODULE$, throwable.getMessage());
        }
        if (throwable2 instanceof IllegalAccessException) {
            return this.error(Status$Forbidden$.MODULE$, throwable.getMessage());
        }
        if (throwable2 instanceof IllegalAccessError) {
            return this.error(Status$Forbidden$.MODULE$, throwable.getMessage());
        }
        if (throwable2 instanceof NotDirectoryException) {
            return this.error(Status$BadRequest$.MODULE$, throwable.getMessage());
        }
        if (throwable2 instanceof IllegalArgumentException) {
            return this.error(Status$BadRequest$.MODULE$, throwable.getMessage());
        }
        if (throwable2 instanceof FileNotFoundException) {
            return this.error(Status$NotFound$.MODULE$, throwable.getMessage());
        }
        if (throwable2 instanceof ConnectException) {
            return this.error(Status$ServiceUnavailable$.MODULE$, throwable.getMessage());
        }
        if (throwable2 instanceof SocketTimeoutException) {
            return this.error(Status$GatewayTimeout$.MODULE$, throwable.getMessage());
        }
        return this.error(Status$InternalServerError$.MODULE$, throwable.getMessage());
    }

    public Response gatewayTimeout() {
        return this.error(Status$GatewayTimeout$.MODULE$);
    }

    public Response gatewayTimeout(String message) {
        return this.error(Status$GatewayTimeout$.MODULE$, message);
    }

    public Response html(Html data, Status status) {
        return this.apply(status, this.contentTypeHtml(), Body$.MODULE$.fromString(new StringBuilder(15).append("<!DOCTYPE html>").append(data.encode()).toString(), Body$.MODULE$.fromString$default$2()));
    }

    public Status html$default$2() {
        return Status$Ok$.MODULE$;
    }

    public Response httpVersionNotSupported() {
        return this.error(Status$HttpVersionNotSupported$.MODULE$);
    }

    public Response httpVersionNotSupported(String message) {
        return this.error(Status$HttpVersionNotSupported$.MODULE$, message);
    }

    public Response internalServerError() {
        return this.error(Status$InternalServerError$.MODULE$);
    }

    public Response internalServerError(String message) {
        return this.error(Status$InternalServerError$.MODULE$, message);
    }

    public Response json(CharSequence data) {
        return this.apply(Status$Ok$.MODULE$, this.contentTypeJson(), Body$.MODULE$.fromCharSequence(data, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response networkAuthenticationRequired() {
        return this.error(Status$NetworkAuthenticationRequired$.MODULE$);
    }

    public Response networkAuthenticationRequired(String message) {
        return this.error(Status$NetworkAuthenticationRequired$.MODULE$, message);
    }

    public Response notExtended() {
        return this.error(Status$NotExtended$.MODULE$);
    }

    public Response notExtended(String message) {
        return this.error(Status$NotExtended$.MODULE$, message);
    }

    public Response notFound() {
        return this.error(Status$NotFound$.MODULE$);
    }

    public Response notFound(String message) {
        return this.error(Status$NotFound$.MODULE$, message);
    }

    public Response notImplemented() {
        return this.error(Status$NotImplemented$.MODULE$);
    }

    public Response notImplemented(String message) {
        return this.error(Status$NotImplemented$.MODULE$, message);
    }

    public Response ok() {
        return this.status(Status$Ok$.MODULE$);
    }

    public Response redirect(URL location, boolean isPermanent) {
        Status.Redirection status = (Status.Redirection)(isPermanent ? Status$PermanentRedirect$.MODULE$ : Status$TemporaryRedirect$.MODULE$);
        return this.apply(status, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$Location$.MODULE$.apply(location)})), this.$lessinit$greater$default$3());
    }

    public boolean redirect$default$2() {
        return false;
    }

    public Response seeOther(URL location) {
        return this.apply(Status$SeeOther$.MODULE$, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$Location$.MODULE$.apply(location)})), this.$lessinit$greater$default$3());
    }

    public Response serviceUnavailable() {
        return this.error(Status$ServiceUnavailable$.MODULE$);
    }

    public Response serviceUnavailable(String message) {
        return this.error(Status$ServiceUnavailable$.MODULE$, message);
    }

    public Response status(Status status) {
        return this.apply(status, this.$lessinit$greater$default$2(), this.$lessinit$greater$default$3());
    }

    public Response text(CharSequence text) {
        return this.apply(Status$Ok$.MODULE$, this.contentTypeText(), Body$.MODULE$.fromCharSequence(text, Body$.MODULE$.fromCharSequence$default$2()));
    }

    public Response unauthorized() {
        return this.error(Status$Unauthorized$.MODULE$);
    }

    public Response unauthorized(String message) {
        return this.error(Status$Unauthorized$.MODULE$, message);
    }

    private Headers contentTypeJson() {
        Object object = this.contentTypeJson$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeJson$lzyINIT1();
    }

    private Object contentTypeJson$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeJson$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.application().json(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeJson$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeJson$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Headers contentTypeHtml() {
        Object object = this.contentTypeHtml$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeHtml$lzyINIT1();
    }

    private Object contentTypeHtml$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeHtml$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.text().html(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeHtml$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeHtml$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Headers contentTypeText() {
        Object object = this.contentTypeText$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeText$lzyINIT1();
    }

    private Object contentTypeText$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeText$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.text().plain(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeText$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeText$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Headers contentTypeEventStream() {
        Object object = this.contentTypeEventStream$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.contentTypeEventStream$lzyINIT1();
    }

    private Object contentTypeEventStream$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.contentTypeEventStream$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.text().event$minusstream(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3()).untyped()}));
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeEventStream$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentTypeEventStream$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Response.OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Response fromProduct(Product x$0) {
        return new Response((Status)x$0.productElement(0), (Headers)x$0.productElement(1), (Body)x$0.productElement(2));
    }
}

