/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Boundary;
import zio.http.MediaType;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBody$AsciiStringBody$;
import zio.http.netty.NettyBody$AsyncBody$;
import zio.http.netty.NettyBody$ByteBufBody$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class NettyBody {
    public static Body fromAsciiString(AsciiString asciiString) {
        return NettyBody$.MODULE$.fromAsciiString(asciiString);
    }

    public static Body fromAsync(Function1<UnsafeAsync, BoxedUnit> function1, Option<Object> option, Option<String> option2) {
        return NettyBody$.MODULE$.fromAsync(function1, option, option2);
    }

    public static Body fromByteBuf(ByteBuf byteBuf, Option<String> option) {
        return NettyBody$.MODULE$.fromByteBuf(byteBuf, option);
    }

    public static Body fromCharSequence(CharSequence charSequence, Charset charset) {
        return NettyBody$.MODULE$.fromCharSequence(charSequence, charset);
    }

    public static Charset fromCharSequence$default$2() {
        return NettyBody$.MODULE$.fromCharSequence$default$2();
    }

    public static Option<String> fromAsync$default$3() {
        return NettyBody$.MODULE$.fromAsync$default$3();
    }

    public static final class AsciiStringBody
    implements Body,
    Body.UnsafeWriteable,
    Body.UnsafeBytes,
    Product,
    Serializable {
        private final AsciiString asciiString;
        private final Option mediaType;
        private final Option boundary;

        public static AsciiStringBody apply(AsciiString asciiString, Option<MediaType> option, Option<Boundary> option2) {
            return NettyBody$AsciiStringBody$.MODULE$.apply(asciiString, option, option2);
        }

        public static AsciiStringBody fromProduct(Product product) {
            return NettyBody$AsciiStringBody$.MODULE$.fromProduct(product);
        }

        public static AsciiStringBody unapply(AsciiStringBody asciiStringBody) {
            return NettyBody$AsciiStringBody$.MODULE$.unapply(asciiStringBody);
        }

        public static Option<MediaType> $lessinit$greater$default$2() {
            return NettyBody$AsciiStringBody$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Boundary> $lessinit$greater$default$3() {
            return NettyBody$AsciiStringBody$.MODULE$.$lessinit$greater$default$3();
        }

        public AsciiStringBody(AsciiString asciiString, Option<MediaType> mediaType, Option<Boundary> boundary) {
            this.asciiString = asciiString;
            this.mediaType = mediaType;
            this.boundary = boundary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AsciiStringBody)) return false;
            AsciiStringBody asciiStringBody = (AsciiStringBody)object;
            AsciiString asciiString = this.asciiString();
            AsciiString asciiString2 = asciiStringBody.asciiString();
            if (asciiString == null) {
                if (asciiString2 != null) {
                    return false;
                }
            } else if (!asciiString.equals(asciiString2)) return false;
            Option<MediaType> option = this.mediaType();
            Option<MediaType> option2 = asciiStringBody.mediaType();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Boundary> option3 = this.boundary();
            Option<Boundary> option4 = asciiStringBody.boundary();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof AsciiStringBody;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "AsciiStringBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "asciiString";
                }
                case 1: {
                    return "mediaType";
                }
                case 2: {
                    return "boundary";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AsciiString asciiString() {
            return this.asciiString;
        }

        @Override
        public Option<MediaType> mediaType() {
            return this.mediaType;
        }

        @Override
        public Option<Boundary> boundary() {
            return this.boundary;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.asciiString().array(), trace);
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.asciiString().isEmpty();
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> Chunk$.MODULE$.fromArray((Object)this.asciiString().array()), trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$1(trace), trace);
        }

        public String toString() {
            return new StringBuilder(22).append("Body.fromAsciiString(").append((CharSequence)this.asciiString()).append(")").toString();
        }

        @Override
        public byte[] unsafeAsArray(Unsafe unsafe) {
            return this.asciiString().array();
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            AsciiString asciiString = this.copy$default$1();
            Option<Boundary> option = this.copy$default$3();
            return this.copy(asciiString, (Option<MediaType>)some, option);
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Some some2 = Some$.MODULE$.apply((Object)newBoundary);
            AsciiString asciiString = this.copy$default$1();
            return this.copy(asciiString, (Option<MediaType>)some, (Option<Boundary>)some2);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.asciiString().length()));
        }

        public AsciiStringBody copy(AsciiString asciiString, Option<MediaType> mediaType, Option<Boundary> boundary) {
            return new AsciiStringBody(asciiString, mediaType, boundary);
        }

        public AsciiString copy$default$1() {
            return this.asciiString();
        }

        public Option<MediaType> copy$default$2() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$3() {
            return this.boundary();
        }

        public AsciiString _1() {
            return this.asciiString();
        }

        public Option<MediaType> _2() {
            return this.mediaType();
        }

        public Option<Boundary> _3() {
            return this.boundary();
        }

        private final Chunk asStream$$anonfun$1$$anonfun$1$$anonfun$1(Chunk _$3$1) {
            return _$3$1;
        }

        private final ZIO asStream$$anonfun$1(Object trace$1) {
            return this.asChunk(trace$1).map((Function1 & Serializable)_$3 -> ZStream$.MODULE$.fromChunk(() -> this.asStream$$anonfun$1$$anonfun$1$$anonfun$1(_$3), trace$1), trace$1);
        }
    }

    public static final class AsyncBody
    implements Body,
    Body.UnsafeWriteable,
    Product,
    Serializable {
        private final Function1 unsafeAsync;
        private final Option knownContentLength;
        private final Option mediaType;
        private final Option boundary;

        public static AsyncBody apply(Function1<UnsafeAsync, BoxedUnit> function1, Option<Object> option, Option<MediaType> option2, Option<Boundary> option3) {
            return NettyBody$AsyncBody$.MODULE$.apply(function1, option, option2, option3);
        }

        public static AsyncBody fromProduct(Product product) {
            return NettyBody$AsyncBody$.MODULE$.fromProduct(product);
        }

        public static AsyncBody unapply(AsyncBody asyncBody) {
            return NettyBody$AsyncBody$.MODULE$.unapply(asyncBody);
        }

        public static Option<MediaType> $lessinit$greater$default$3() {
            return NettyBody$AsyncBody$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<Boundary> $lessinit$greater$default$4() {
            return NettyBody$AsyncBody$.MODULE$.$lessinit$greater$default$4();
        }

        public AsyncBody(Function1<UnsafeAsync, BoxedUnit> unsafeAsync, Option<Object> knownContentLength, Option<MediaType> mediaType, Option<Boundary> boundary) {
            this.unsafeAsync = unsafeAsync;
            this.knownContentLength = knownContentLength;
            this.mediaType = mediaType;
            this.boundary = boundary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AsyncBody)) return false;
            AsyncBody asyncBody = (AsyncBody)object;
            Function1<UnsafeAsync, BoxedUnit> function1 = this.unsafeAsync();
            Function1<UnsafeAsync, BoxedUnit> function12 = asyncBody.unsafeAsync();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Option<Object> option = this.knownContentLength();
            Option<Object> option2 = asyncBody.knownContentLength();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<MediaType> option3 = this.mediaType();
            Option<MediaType> option4 = asyncBody.mediaType();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Boundary> option5 = this.boundary();
            Option<Boundary> option6 = asyncBody.boundary();
            if (option5 == null) {
                if (option6 == null) return true;
                return false;
            } else {
                if (!option5.equals(option6)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof AsyncBody;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "AsyncBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "unsafeAsync";
                }
                case 1: {
                    return "knownContentLength";
                }
                case 2: {
                    return "mediaType";
                }
                case 3: {
                    return "boundary";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<UnsafeAsync, BoxedUnit> unsafeAsync() {
            return this.unsafeAsync;
        }

        @Override
        public Option<Object> knownContentLength() {
            return this.knownContentLength;
        }

        @Override
        public Option<MediaType> mediaType() {
            return this.mediaType;
        }

        @Override
        public Option<Boundary> boundary() {
            return this.boundary;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return this.asChunk(trace).map((Function1 & Serializable)_$5 -> (byte[])_$5.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), trace);
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return this.asStream(trace).runCollect(trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.async((Function1)(JProcedure1 & Serializable)emit -> {
                try {
                    this.unsafeAsync().apply((Object)new UnsafeAsync((ZStream.Emit)emit, trace){
                        private final ZStream.Emit emit$1;
                        private final Object trace$5;
                        {
                            this.emit$1 = emit$2;
                            this.trace$5 = trace$7;
                        }

                        public void apply(Chunk message, boolean isLast) {
                            this.emit$1.apply(ZIO$.MODULE$.succeed(arg_0 -> NettyBody$.zio$http$netty$NettyBody$AsyncBody$$anon$1$$_$apply$$anonfun$1(message, arg_0), this.trace$5));
                            if (isLast) {
                                this.emit$1.apply(ZIO$.MODULE$.fail(NettyBody$::zio$http$netty$NettyBody$AsyncBody$$anon$1$$_$apply$$anonfun$2, this.trace$5));
                                return;
                            }
                        }

                        public void fail(Throwable cause) {
                            this.emit$1.apply(ZIO$.MODULE$.fail(() -> NettyBody$.zio$http$netty$NettyBody$AsyncBody$$anon$1$$_$fail$$anonfun$1(cause), this.trace$5));
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$http$netty$NettyBody$AsyncBody$$anon$1$$_$apply$$anonfun$1(zio.Chunk zio.Unsafe ), zio$http$netty$NettyBody$AsyncBody$$anon$1$$_$apply$$anonfun$2(), zio$http$netty$NettyBody$AsyncBody$$anon$1$$_$fail$$anonfun$1(java.lang.Throwable )}, serializedLambda);
                        }
                    });
                }
                catch (Throwable e) {
                    emit.apply(ZIO$.MODULE$.fail(() -> this.asStream$$anonfun$3$$anonfun$1(e), trace));
                }
            }, this::asStream$$anonfun$4, trace);
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public String toString() {
            return new StringBuilder(11).append("AsyncBody(").append(this.unsafeAsync()).append(")").toString();
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Function1<UnsafeAsync, BoxedUnit> function1 = this.copy$default$1();
            Option<Object> option = this.copy$default$2();
            Option<Boundary> option2 = this.copy$default$4();
            return this.copy(function1, option, (Option<MediaType>)some, option2);
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Some some2 = Some$.MODULE$.apply((Object)newBoundary);
            Function1<UnsafeAsync, BoxedUnit> function1 = this.copy$default$1();
            Option<Object> option = this.copy$default$2();
            return this.copy(function1, option, (Option<MediaType>)some, (Option<Boundary>)some2);
        }

        public AsyncBody copy(Function1<UnsafeAsync, BoxedUnit> unsafeAsync, Option<Object> knownContentLength, Option<MediaType> mediaType, Option<Boundary> boundary) {
            return new AsyncBody(unsafeAsync, knownContentLength, mediaType, boundary);
        }

        public Function1<UnsafeAsync, BoxedUnit> copy$default$1() {
            return this.unsafeAsync();
        }

        public Option<Object> copy$default$2() {
            return this.knownContentLength();
        }

        public Option<MediaType> copy$default$3() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$4() {
            return this.boundary();
        }

        public Function1<UnsafeAsync, BoxedUnit> _1() {
            return this.unsafeAsync();
        }

        public Option<Object> _2() {
            return this.knownContentLength();
        }

        public Option<MediaType> _3() {
            return this.mediaType();
        }

        public Option<Boundary> _4() {
            return this.boundary();
        }

        private final Option asStream$$anonfun$3$$anonfun$1(Throwable e$1) {
            return Option$.MODULE$.apply((Object)e$1);
        }

        private final int asStream$$anonfun$4() {
            return 4096;
        }
    }

    public static final class ByteBufBody
    implements Body,
    Body.UnsafeWriteable,
    Body.UnsafeBytes,
    Product,
    Serializable {
        private final ByteBuf byteBuf;
        private final Option mediaType;
        private final Option boundary;

        public static ByteBufBody apply(ByteBuf byteBuf, Option<MediaType> option, Option<Boundary> option2) {
            return NettyBody$ByteBufBody$.MODULE$.apply(byteBuf, option, option2);
        }

        public static ByteBufBody fromProduct(Product product) {
            return NettyBody$ByteBufBody$.MODULE$.fromProduct(product);
        }

        public static ByteBufBody unapply(ByteBufBody byteBufBody) {
            return NettyBody$ByteBufBody$.MODULE$.unapply(byteBufBody);
        }

        public static Option<MediaType> $lessinit$greater$default$2() {
            return NettyBody$ByteBufBody$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Boundary> $lessinit$greater$default$3() {
            return NettyBody$ByteBufBody$.MODULE$.$lessinit$greater$default$3();
        }

        public ByteBufBody(ByteBuf byteBuf, Option<MediaType> mediaType, Option<Boundary> boundary) {
            this.byteBuf = byteBuf;
            this.mediaType = mediaType;
            this.boundary = boundary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ByteBufBody)) return false;
            ByteBufBody byteBufBody = (ByteBufBody)object;
            ByteBuf byteBuf = this.byteBuf();
            ByteBuf byteBuf2 = byteBufBody.byteBuf();
            if (byteBuf == null) {
                if (byteBuf2 != null) {
                    return false;
                }
            } else if (!byteBuf.equals(byteBuf2)) return false;
            Option<MediaType> option = this.mediaType();
            Option<MediaType> option2 = byteBufBody.mediaType();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Boundary> option3 = this.boundary();
            Option<Boundary> option4 = byteBufBody.boundary();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ByteBufBody;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ByteBufBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "byteBuf";
                }
                case 1: {
                    return "mediaType";
                }
                case 2: {
                    return "boundary";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteBuf byteBuf() {
            return this.byteBuf;
        }

        @Override
        public Option<MediaType> mediaType() {
            return this.mediaType;
        }

        @Override
        public Option<Boundary> boundary() {
            return this.boundary;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> ByteBufUtil.getBytes((ByteBuf)this.byteBuf()), trace);
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return this.asArray(trace).map((Function1 & Serializable)array -> Chunk$.MODULE$.fromArray(array), trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$2(trace), trace);
        }

        public String toString() {
            return new StringBuilder(18).append("Body.fromByteBuf(").append(this.byteBuf()).append(")").toString();
        }

        @Override
        public byte[] unsafeAsArray(Unsafe unsafe) {
            return ByteBufUtil.getBytes((ByteBuf)this.byteBuf());
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            ByteBuf byteBuf = this.copy$default$1();
            Option<Boundary> option = this.copy$default$3();
            return this.copy(byteBuf, (Option<MediaType>)some, option);
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Some some2 = Some$.MODULE$.apply((Object)newBoundary);
            ByteBuf byteBuf = this.copy$default$1();
            return this.copy(byteBuf, (Option<MediaType>)some, (Option<Boundary>)some2);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.byteBuf().readableBytes()));
        }

        public ByteBufBody copy(ByteBuf byteBuf, Option<MediaType> mediaType, Option<Boundary> boundary) {
            return new ByteBufBody(byteBuf, mediaType, boundary);
        }

        public ByteBuf copy$default$1() {
            return this.byteBuf();
        }

        public Option<MediaType> copy$default$2() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$3() {
            return this.boundary();
        }

        public ByteBuf _1() {
            return this.byteBuf();
        }

        public Option<MediaType> _2() {
            return this.mediaType();
        }

        public Option<Boundary> _3() {
            return this.boundary();
        }

        private final Chunk asStream$$anonfun$2$$anonfun$1$$anonfun$1(Chunk _$4$1) {
            return _$4$1;
        }

        private final ZIO asStream$$anonfun$2(Object trace$3) {
            return this.asChunk(trace$3).map((Function1 & Serializable)_$4 -> ZStream$.MODULE$.fromChunk(() -> this.asStream$$anonfun$2$$anonfun$1$$anonfun$1(_$4), trace$3), trace$3);
        }
    }

    public static interface UnsafeAsync {
        public void apply(Chunk<Object> var1, boolean var2);

        public void fail(Throwable var1);
    }
}

