/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.util.concurrent.Future;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import zio.Fiber;
import zio.Promise;
import zio.Queue;
import zio.Queue$;
import zio.Scope;
import zio.Scope$;
import zio.Unsafe;
import zio.ZEnvironment$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ClientDriver;
import zio.http.ConnectionPool;
import zio.http.ConnectionPoolConfig;
import zio.http.DnsResolver;
import zio.http.Request;
import zio.http.Response;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.internal.ChannelState$Invalid$;
import zio.http.internal.ChannelState$Reusable$;
import zio.http.netty.EventLoopGroups;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.client.ClientFailureHandler;
import zio.http.netty.client.ClientInboundHandler;
import zio.http.netty.client.ClientInboundHandler$SendRequest$;
import zio.http.netty.client.NettyClientDriver$;
import zio.http.netty.client.NettyConnectionPool$;
import zio.http.netty.client.NettyRequestEncoder$;
import zio.http.netty.client.WebSocketClientInboundHandler;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.socket.NettySocketProtocol$;
import zio.package;

public final class NettyClientDriver
implements ClientDriver,
Product,
Serializable {
    private final ChannelFactory channelFactory;
    private final EventLoopGroup eventLoopGroup;
    private final NettyRuntime nettyRuntime;

    public static NettyClientDriver apply(ChannelFactory<io.netty.channel.Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime) {
        return NettyClientDriver$.MODULE$.apply(channelFactory, eventLoopGroup, nettyRuntime);
    }

    public static NettyClientDriver fromProduct(Product product) {
        return NettyClientDriver$.MODULE$.fromProduct(product);
    }

    public static ZLayer<EventLoopGroups.Config, Nothing$, ClientDriver> live() {
        return NettyClientDriver$.MODULE$.live();
    }

    public static NettyClientDriver unapply(NettyClientDriver nettyClientDriver) {
        return NettyClientDriver$.MODULE$.unapply(nettyClientDriver);
    }

    public NettyClientDriver(ChannelFactory<io.netty.channel.Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime) {
        this.channelFactory = channelFactory;
        this.eventLoopGroup = eventLoopGroup;
        this.nettyRuntime = nettyRuntime;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NettyClientDriver)) return false;
        NettyClientDriver nettyClientDriver = (NettyClientDriver)object;
        ChannelFactory<io.netty.channel.Channel> channelFactory = this.channelFactory();
        ChannelFactory<io.netty.channel.Channel> channelFactory2 = nettyClientDriver.channelFactory();
        if (channelFactory == null) {
            if (channelFactory2 != null) {
                return false;
            }
        } else if (!channelFactory.equals(channelFactory2)) return false;
        EventLoopGroup eventLoopGroup = this.eventLoopGroup();
        EventLoopGroup eventLoopGroup2 = nettyClientDriver.eventLoopGroup();
        if (eventLoopGroup == null) {
            if (eventLoopGroup2 != null) {
                return false;
            }
        } else if (!eventLoopGroup.equals(eventLoopGroup2)) return false;
        NettyRuntime nettyRuntime = this.nettyRuntime();
        NettyRuntime nettyRuntime2 = nettyClientDriver.nettyRuntime();
        if (nettyRuntime == null) {
            if (nettyRuntime2 == null) return true;
            return false;
        } else {
            if (!nettyRuntime.equals(nettyRuntime2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NettyClientDriver;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "NettyClientDriver";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "channelFactory";
            }
            case 1: {
                return "eventLoopGroup";
            }
            case 2: {
                return "nettyRuntime";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ChannelFactory<io.netty.channel.Channel> channelFactory() {
        return this.channelFactory;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public NettyRuntime nettyRuntime() {
        return this.nettyRuntime;
    }

    public ZIO<Scope, Throwable, ClientDriver.ChannelInterface> requestOnChannel(io.netty.channel.Channel channel, URL.Location.Absolute location, Request req, Promise<Throwable, Response> onResponse, Promise<Throwable, ChannelState> onComplete, boolean enableKeepAlive, Function0<WebSocketApp<Object>> createSocketApp, WebSocketConfig webSocketConfig, Object trace) {
        ZIO f = NettyRequestEncoder$.MODULE$.encode(req, trace).flatMap((Function1 & Serializable)jReq -> Scope$.MODULE$.addFinalizer(() -> NettyClientDriver.$anonfun$1$$anonfun$1(jReq, trace), trace).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Queue$.MODULE$.unbounded(trace).map((Function1 & Serializable)queue -> {
                NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(channel);
                Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue);
                WebSocketApp app = (WebSocketApp)createSocketApp.apply();
                return Tuple4$.MODULE$.apply(queue, nettyChannel, webSocketChannel, (Object)app);
            }, trace).flatMap((Function1 & Serializable)x$12 -> {
                Tuple4 tuple4 = x$12;
                if (tuple4 != null) {
                    Queue queue = (Queue)tuple4._1();
                    NettyChannel nettyChannel = (NettyChannel)tuple4._2();
                    Channel webSocketChannel = (Channel)tuple4._3();
                    WebSocketApp app = (WebSocketApp)tuple4._4();
                    return app.handler().runZIO(webSocketChannel).ignoreLogged(trace).interruptible(trace).forkScoped(trace).map((Function1 & Serializable)x$1 -> {
                        Fiber.Runtime runtime = x$1;
                        ChannelPipeline pipeline = channel.pipeline();
                        HashSet toRemove = new HashSet();
                        if (location.scheme().isWebSocket()) {
                            HttpObjectAggregator httpObjectAggregator = new HttpObjectAggregator(Integer.MAX_VALUE);
                            WebSocketClientInboundHandler inboundHandler = new WebSocketClientInboundHandler(onResponse, onComplete);
                            pipeline.addLast(package$Names$.MODULE$.HttpObjectAggregator(), (ChannelHandler)httpObjectAggregator);
                            pipeline.addLast(package$Names$.MODULE$.ClientInboundHandler(), (ChannelHandler)inboundHandler);
                            toRemove.add((Object)httpObjectAggregator);
                            toRemove.add((Object)inboundHandler);
                            HttpHeaders headers = Conversions$.MODULE$.headersToNetty(req.headers());
                            WebSocketClientProtocolConfig config = NettySocketProtocol$.MODULE$.clientBuilder((WebSocketConfig)app.customConfig().getOrElse(() -> NettyClientDriver.$anonfun$2(webSocketConfig))).customHeaders(headers).webSocketUri(req.url().encode()).build();
                            WebSocketClientProtocolHandler webSocketClientProtocol = new WebSocketClientProtocolHandler(config);
                            WebSocketAppHandler webSocket = new WebSocketAppHandler(this.nettyRuntime(), (Queue<ChannelEvent<WebSocketFrame>>)queue, (Option<Promise<Throwable, ChannelState>>)Some$.MODULE$.apply((Object)onComplete), trace);
                            pipeline.addLast(package$Names$.MODULE$.WebSocketClientProtocolHandler(), (ChannelHandler)webSocketClientProtocol);
                            pipeline.addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)webSocket);
                            toRemove.add((Object)webSocketClientProtocol);
                            toRemove.add((Object)webSocket);
                            pipeline.fireChannelRegistered();
                            pipeline.fireChannelActive();
                            return new ClientDriver.ChannelInterface(trace, channel){
                                private final Object trace$6;
                                private final io.netty.channel.Channel channel$6;
                                {
                                    this.trace$6 = trace$14;
                                    this.channel$6 = channel$11;
                                }

                                public ZIO resetChannel() {
                                    return ZIO$.MODULE$.succeed(NettyClientDriver::zio$http$netty$client$NettyClientDriver$$anon$1$$_$resetChannel$$anonfun$1, this.trace$6);
                                }

                                public ZIO interrupt() {
                                    return NettyFutureExecutor$.MODULE$.executed(this::interrupt$$anonfun$1, this.trace$6);
                                }

                                private final Future interrupt$$anonfun$1() {
                                    return this.channel$6.disconnect();
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{zio$http$netty$client$NettyClientDriver$$anon$1$$_$resetChannel$$anonfun$1(zio.Unsafe ), interrupt$$anonfun$1()}, serializedLambda);
                                }
                            };
                        }
                        ClientInboundHandler clientInbound = new ClientInboundHandler(this.nettyRuntime(), req, (HttpRequest)jReq, onResponse, onComplete, enableKeepAlive, trace);
                        pipeline.addLast(package$Names$.MODULE$.ClientInboundHandler(), (ChannelHandler)clientInbound);
                        toRemove.add((Object)clientInbound);
                        ClientFailureHandler clientFailureHandler = new ClientFailureHandler(onResponse, onComplete);
                        pipeline.addLast(package$Names$.MODULE$.ClientFailureHandler(), (ChannelHandler)clientFailureHandler);
                        toRemove.add((Object)clientFailureHandler);
                        pipeline.fireChannelRegistered();
                        pipeline.fireUserEventTriggered((Object)ClientInboundHandler$SendRequest$.MODULE$);
                        Set frozenToRemove = toRemove.toSet();
                        return new ClientDriver.ChannelInterface(frozenToRemove, pipeline, trace, channel){
                            private final Set frozenToRemove$1;
                            private final ChannelPipeline pipeline$1;
                            private final Object trace$7;
                            private final io.netty.channel.Channel channel$7;
                            {
                                this.frozenToRemove$1 = frozenToRemove$2;
                                this.pipeline$1 = pipeline$2;
                                this.trace$7 = trace$15;
                                this.channel$7 = channel$12;
                            }

                            public ZIO resetChannel() {
                                return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$3 -> {
                                    this.frozenToRemove$1.foreach((Function1 & Serializable)x$0 -> this.pipeline$1.remove(x$0));
                                    return ChannelState$Reusable$.MODULE$;
                                }, this.trace$7);
                            }

                            public ZIO interrupt() {
                                return NettyFutureExecutor$.MODULE$.executed(this::interrupt$$anonfun$2, this.trace$7);
                            }

                            private final Future interrupt$$anonfun$2() {
                                return this.channel$7.disconnect();
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{resetChannel$$anonfun$2(zio.Unsafe ), interrupt$$anonfun$2(), resetChannel$$anonfun$2$$anonfun$1(io.netty.channel.ChannelHandler )}, serializedLambda);
                            }
                        };
                    }, trace);
                }
                throw new MatchError((Object)tuple4);
            }, trace);
        }, trace), trace);
        return f.ensuring(() -> this.requestOnChannel$$anonfun$1(location, channel, onComplete, trace, onResponse), trace);
    }

    public ZIO<Scope, Nothing$, ConnectionPool<io.netty.channel.Channel>> createConnectionPool(DnsResolver dnsResolver, ConnectionPoolConfig config, Object trace) {
        return NettyConnectionPool$.MODULE$.fromConfig(config, trace).provideSomeEnvironment((Function1 & Serializable)_$2 -> _$2.$plus$plus(ZEnvironment$.MODULE$.apply((Object)this, (Object)dnsResolver, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30)))), Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(-736598261, "\u0002\u0000\u0002\u0003\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001\u0003\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace);
    }

    public NettyClientDriver copy(ChannelFactory<io.netty.channel.Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime) {
        return new NettyClientDriver(channelFactory, eventLoopGroup, nettyRuntime);
    }

    public ChannelFactory<io.netty.channel.Channel> copy$default$1() {
        return this.channelFactory();
    }

    public EventLoopGroup copy$default$2() {
        return this.eventLoopGroup();
    }

    public NettyRuntime copy$default$3() {
        return this.nettyRuntime();
    }

    public ChannelFactory<io.netty.channel.Channel> _1() {
        return this.channelFactory();
    }

    public EventLoopGroup _2() {
        return this.eventLoopGroup();
    }

    public NettyRuntime _3() {
        return this.nettyRuntime();
    }

    private static final ZIO $anonfun$1$$anonfun$1(HttpRequest jReq$1, Object trace$1) {
        return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> {
            HttpRequest httpRequest = jReq$1;
            if (httpRequest instanceof FullHttpRequest) {
                FullHttpRequest fullRequest = (FullHttpRequest)httpRequest;
                if (fullRequest.refCnt() > 0) {
                    fullRequest.release(fullRequest.refCnt());
                    return;
                }
                return;
            }
        }, trace$1).ignore(trace$1);
    }

    private static final WebSocketConfig $anonfun$2(WebSocketConfig webSocketConfig$5) {
        return webSocketConfig$5;
    }

    public static final /* synthetic */ ChannelState$Invalid$ zio$http$netty$client$NettyClientDriver$$anon$1$$_$resetChannel$$anonfun$1(Unsafe evidence$2) {
        return ChannelState$Invalid$.MODULE$;
    }

    private static final boolean requestOnChannel$$anonfun$1$$anonfun$1(URL.Location.Absolute location$6) {
        return location$6.scheme().isWebSocket();
    }

    private static final ZIO requestOnChannel$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Promise onComplete$9, Object trace$12) {
        return onComplete$9.interrupt(trace$12);
    }

    private static final ZIO requestOnChannel$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(Promise onResponse$9, Object trace$13) {
        return onResponse$9.fail((Object)new PrematureChannelClosureException("Channel closed while executing the request. This is likely caused due to a client connection misconfiguration"), trace$13);
    }

    private final ZIO requestOnChannel$$anonfun$1$$anonfun$2(io.netty.channel.Channel channel$9, Promise onComplete$6, Object trace$9, Promise onResponse$6) {
        return ZIO$.MODULE$.succeedUnsafe((Function1 & Serializable)u -> channel$9.closeFuture().addListener(_$1 -> {
            Function0 function0 = ZIO$.MODULE$.whenZIO(() -> NettyClientDriver.requestOnChannel$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(onComplete$6, trace$9));
            this.nettyRuntime().unsafeRunSync(ZIO.WhenZIO$.MODULE$.apply$extension(function0, () -> NettyClientDriver.requestOnChannel$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(onResponse$6, trace$9), trace$9).unit(trace$9), (Unsafe)u, trace$9);
        }), trace$9);
    }

    private final ZIO requestOnChannel$$anonfun$1(URL.Location.Absolute location$5, io.netty.channel.Channel channel$8, Promise onComplete$5, Object trace$8, Promise onResponse$5) {
        return ZIO$.MODULE$.unless(() -> NettyClientDriver.requestOnChannel$$anonfun$1$$anonfun$1(location$5), () -> this.requestOnChannel$$anonfun$1$$anonfun$2(channel$8, onComplete$5, trace$8, onResponse$5), trace$8);
    }
}

