/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Schedule;
import zio.Schedule$;
import zio.Scope;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZKeyedPool;
import zio.Zippable$;
import zio.http.ClientSSLConfig;
import zio.http.ConnectionPool;
import zio.http.ConnectionPoolConfig;
import zio.http.Decompression;
import zio.http.DnsResolver;
import zio.http.Proxy;
import zio.http.URL;
import zio.http.netty.NettyRuntime;
import zio.http.netty.client.NettyClientDriver;
import zio.http.netty.client.NettyConnectionPool$;
import zio.http.netty.client.NettyConnectionPool$BootstrapSyntax$;
import zio.http.netty.client.NettyConnectionPool$PoolKey$;

public interface NettyConnectionPool
extends ConnectionPool<Channel> {
    public static Bootstrap BootstrapSyntax(Bootstrap bootstrap) {
        return NettyConnectionPool$.MODULE$.BootstrapSyntax(bootstrap);
    }

    public static ZIO<NettyClientDriver, Nothing$, NettyConnectionPool> fromConfig(ConnectionPoolConfig connectionPoolConfig, Object object) {
        return NettyConnectionPool$.MODULE$.fromConfig(connectionPoolConfig, object);
    }

    public static final class BootstrapSyntax {
        private final Bootstrap bootstrap;

        public static boolean equals$extension(Bootstrap bootstrap, Object object) {
            return NettyConnectionPool$BootstrapSyntax$.MODULE$.equals$extension(bootstrap, object);
        }

        public static int hashCode$extension(Bootstrap bootstrap) {
            return NettyConnectionPool$BootstrapSyntax$.MODULE$.hashCode$extension(bootstrap);
        }

        public static <T> Bootstrap withOption$extension(Bootstrap bootstrap, ChannelOption<T> channelOption, Option<T> option) {
            return NettyConnectionPool$BootstrapSyntax$.MODULE$.withOption$extension(bootstrap, channelOption, option);
        }

        public BootstrapSyntax(Bootstrap bootstrap) {
            this.bootstrap = bootstrap;
        }

        public int hashCode() {
            return NettyConnectionPool$BootstrapSyntax$.MODULE$.hashCode$extension(this.bootstrap());
        }

        public boolean equals(Object x$0) {
            return NettyConnectionPool$BootstrapSyntax$.MODULE$.equals$extension(this.bootstrap(), x$0);
        }

        public Bootstrap bootstrap() {
            return this.bootstrap;
        }

        public <T> Bootstrap withOption(ChannelOption<T> option, Option<T> value) {
            return NettyConnectionPool$BootstrapSyntax$.MODULE$.withOption$extension(this.bootstrap(), option, value);
        }
    }

    public static final class NoNettyConnectionPool
    implements NettyConnectionPool {
        private final ChannelFactory<Channel> channelFactory;
        private final EventLoopGroup eventLoopGroup;
        private final NettyRuntime nettyRuntime;
        private final DnsResolver dnsResolver;

        public NoNettyConnectionPool(ChannelFactory<Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime, DnsResolver dnsResolver) {
            this.channelFactory = channelFactory;
            this.eventLoopGroup = eventLoopGroup;
            this.nettyRuntime = nettyRuntime;
            this.dnsResolver = dnsResolver;
        }

        @Override
        public ZIO<Scope, Throwable, Channel> get(URL.Location.Absolute location, Option<Proxy> proxy, ClientSSLConfig sslOptions, int maxInitialLineLength, int maxHeaderSize, Decompression decompression, Option<Duration> idleTimeout, Option<Duration> connectionTimeout, Option<InetSocketAddress> localAddress, Object trace) {
            return NettyConnectionPool$.MODULE$.createChannel(this.channelFactory, this.eventLoopGroup, this.nettyRuntime, location, proxy, sslOptions, maxInitialLineLength, maxHeaderSize, decompression, idleTimeout, connectionTimeout, localAddress, this.dnsResolver, trace);
        }

        @Override
        public Option<InetSocketAddress> get$default$9() {
            return None$.MODULE$;
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> invalidate(Channel channel, Object trace) {
            return ZIO$.MODULE$.unit();
        }

        @Override
        public boolean enableKeepAlive() {
            return false;
        }
    }

    public static class PoolKey
    implements Product,
    Serializable {
        private final URL.Location.Absolute location;
        private final Option proxy;
        private final ClientSSLConfig sslOptions;
        private final int maxInitialLineLength;
        private final int maxHeaderSize;
        private final Decompression decompression;
        private final Option idleTimeout;
        private final Option connectionTimeout;

        public static PoolKey apply(URL.Location.Absolute absolute, Option<Proxy> option, ClientSSLConfig clientSSLConfig, int n, int n2, Decompression decompression, Option<Duration> option2, Option<Duration> option3) {
            return NettyConnectionPool$PoolKey$.MODULE$.apply(absolute, option, clientSSLConfig, n, n2, decompression, option2, option3);
        }

        public static PoolKey fromProduct(Product product) {
            return NettyConnectionPool$PoolKey$.MODULE$.fromProduct(product);
        }

        public static PoolKey unapply(PoolKey poolKey) {
            return NettyConnectionPool$PoolKey$.MODULE$.unapply(poolKey);
        }

        public PoolKey(URL.Location.Absolute location, Option<Proxy> proxy, ClientSSLConfig sslOptions, int maxInitialLineLength, int maxHeaderSize, Decompression decompression, Option<Duration> idleTimeout, Option<Duration> connectionTimeout) {
            this.location = location;
            this.proxy = proxy;
            this.sslOptions = sslOptions;
            this.maxInitialLineLength = maxInitialLineLength;
            this.maxHeaderSize = maxHeaderSize;
            this.decompression = decompression;
            this.idleTimeout = idleTimeout;
            this.connectionTimeout = connectionTimeout;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.location()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.proxy()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sslOptions()));
            n = Statics.mix((int)n, (int)this.maxInitialLineLength());
            n = Statics.mix((int)n, (int)this.maxHeaderSize());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.decompression()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idleTimeout()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.connectionTimeout()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PoolKey)) return false;
            PoolKey poolKey = (PoolKey)object;
            if (this.maxInitialLineLength() != poolKey.maxInitialLineLength()) return false;
            if (this.maxHeaderSize() != poolKey.maxHeaderSize()) return false;
            URL.Location.Absolute absolute = this.location();
            URL.Location.Absolute absolute2 = poolKey.location();
            if (absolute == null) {
                if (absolute2 != null) {
                    return false;
                }
            } else if (!((Object)absolute).equals(absolute2)) return false;
            Option<Proxy> option = this.proxy();
            Option<Proxy> option2 = poolKey.proxy();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            ClientSSLConfig clientSSLConfig = this.sslOptions();
            ClientSSLConfig clientSSLConfig2 = poolKey.sslOptions();
            if (clientSSLConfig == null) {
                if (clientSSLConfig2 != null) {
                    return false;
                }
            } else if (!clientSSLConfig.equals(clientSSLConfig2)) return false;
            Decompression decompression = this.decompression();
            Decompression decompression2 = poolKey.decompression();
            if (decompression == null) {
                if (decompression2 != null) {
                    return false;
                }
            } else if (!decompression.equals(decompression2)) return false;
            Option<Duration> option3 = this.idleTimeout();
            Option<Duration> option4 = poolKey.idleTimeout();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Duration> option5 = this.connectionTimeout();
            Option<Duration> option6 = poolKey.connectionTimeout();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            if (!poolKey.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PoolKey;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "PoolKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "location";
                }
                case 1: {
                    return "proxy";
                }
                case 2: {
                    return "sslOptions";
                }
                case 3: {
                    return "maxInitialLineLength";
                }
                case 4: {
                    return "maxHeaderSize";
                }
                case 5: {
                    return "decompression";
                }
                case 6: {
                    return "idleTimeout";
                }
                case 7: {
                    return "connectionTimeout";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public URL.Location.Absolute location() {
            return this.location;
        }

        public Option<Proxy> proxy() {
            return this.proxy;
        }

        public ClientSSLConfig sslOptions() {
            return this.sslOptions;
        }

        public int maxInitialLineLength() {
            return this.maxInitialLineLength;
        }

        public int maxHeaderSize() {
            return this.maxHeaderSize;
        }

        public Decompression decompression() {
            return this.decompression;
        }

        public Option<Duration> idleTimeout() {
            return this.idleTimeout;
        }

        public Option<Duration> connectionTimeout() {
            return this.connectionTimeout;
        }

        public PoolKey copy(URL.Location.Absolute location, Option<Proxy> proxy, ClientSSLConfig sslOptions, int maxInitialLineLength, int maxHeaderSize, Decompression decompression, Option<Duration> idleTimeout, Option<Duration> connectionTimeout) {
            return new PoolKey(location, proxy, sslOptions, maxInitialLineLength, maxHeaderSize, decompression, idleTimeout, connectionTimeout);
        }

        public URL.Location.Absolute copy$default$1() {
            return this.location();
        }

        public Option<Proxy> copy$default$2() {
            return this.proxy();
        }

        public ClientSSLConfig copy$default$3() {
            return this.sslOptions();
        }

        public int copy$default$4() {
            return this.maxInitialLineLength();
        }

        public int copy$default$5() {
            return this.maxHeaderSize();
        }

        public Decompression copy$default$6() {
            return this.decompression();
        }

        public Option<Duration> copy$default$7() {
            return this.idleTimeout();
        }

        public Option<Duration> copy$default$8() {
            return this.connectionTimeout();
        }

        public URL.Location.Absolute _1() {
            return this.location();
        }

        public Option<Proxy> _2() {
            return this.proxy();
        }

        public ClientSSLConfig _3() {
            return this.sslOptions();
        }

        public int _4() {
            return this.maxInitialLineLength();
        }

        public int _5() {
            return this.maxHeaderSize();
        }

        public Decompression _6() {
            return this.decompression();
        }

        public Option<Duration> _7() {
            return this.idleTimeout();
        }

        public Option<Duration> _8() {
            return this.connectionTimeout();
        }
    }

    public static final class ReadTimeoutErrorHandler
    extends ChannelInboundHandlerAdapter {
        private final NettyRuntime nettyRuntime;
        private final Object trace;
        private final Unsafe unsafe;

        public ReadTimeoutErrorHandler(NettyRuntime nettyRuntime, Object trace) {
            this.nettyRuntime = nettyRuntime;
            this.trace = trace;
            this.unsafe = Unsafe$.MODULE$.unsafe();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Throwable throwable = cause;
            if (throwable instanceof ReadTimeoutException) {
                this.nettyRuntime.run(ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}, this.nettyRuntime.run$default$3(), (ZIO<Object, Throwable, Object>)ZIO$.MODULE$.logDebug(this::exceptionCaught$$anonfun$2, this.trace), this.unsafe, this.trace);
                return;
            }
            super.exceptionCaught(ctx, cause);
        }

        private final String exceptionCaught$$anonfun$2() {
            return "ReadTimeoutException caught";
        }
    }

    public static final class ZioNettyConnectionPool
    implements NettyConnectionPool {
        private final ZKeyedPool<Throwable, PoolKey, Channel> pool;
        private final Function1<PoolKey, Object> maxItems;

        public ZioNettyConnectionPool(ZKeyedPool<Throwable, PoolKey, Channel> pool, Function1<PoolKey, Object> maxItems) {
            this.pool = pool;
            this.maxItems = maxItems;
        }

        @Override
        public ZIO<Scope, Throwable, Channel> get(URL.Location.Absolute location, Option<Proxy> proxy, ClientSSLConfig sslOptions, int maxInitialLineLength, int maxHeaderSize, Decompression decompression, Option<Duration> idleTimeout, Option<Duration> connectionTimeout, Option<InetSocketAddress> localAddress, Object trace) {
            return ZIO$.MODULE$.uninterruptibleMask((Function1 & Serializable)restore -> {
                PoolKey key = NettyConnectionPool$PoolKey$.MODULE$.apply(location, proxy, sslOptions, maxInitialLineLength, maxHeaderSize, decompression, idleTimeout, connectionTimeout);
                return restore.apply(() -> this.get$$anonfun$1$$anonfun$1(key, trace), trace).withEarlyRelease(trace).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        ZIO release = (ZIO)tuple2._1();
                        Channel channel = (Channel)tuple2._2();
                        if (channel.isOpen() && BoxesRunTime.unboxToBoolean((Object)idleTimeout.fold(this::get$$anonfun$1$$anonfun$2$$anonfun$1, (Function1 & Serializable)_$2 -> NettyConnectionPool$.MODULE$.zio$http$netty$client$NettyConnectionPool$$$refreshIdleTimeoutHandler(channel, (Duration)_$2)))) {
                            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> channel, trace);
                        }
                        return this.invalidate(channel, trace).$times$greater(() -> this.get$$anonfun$1$$anonfun$2$$anonfun$4(release, trace), trace).$times$greater(() -> this.get$$anonfun$1$$anonfun$2$$anonfun$5(trace), trace);
                    }
                    throw new MatchError((Object)tuple2);
                }, trace).retry(() -> this.get$$anonfun$1$$anonfun$3(key, trace), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).catchAll((Function1 & Serializable)x$1 -> {
                    Serializable serializable = x$1;
                    if (None$.MODULE$.equals(serializable)) {
                        return this.pool.get((Object)key, trace);
                    }
                    if (serializable instanceof Throwable) {
                        Throwable e = (Throwable)serializable;
                        return ZIO$.MODULE$.fail(() -> this.get$$anonfun$1$$anonfun$4$$anonfun$1(e), trace);
                    }
                    throw new MatchError((Object)serializable);
                }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).withFinalizer((Function1 & Serializable)c -> ZIO$.MODULE$.unless(() -> this.get$$anonfun$1$$anonfun$5$$anonfun$1(c), () -> this.get$$anonfun$1$$anonfun$5$$anonfun$2(c, trace), trace), trace);
            }, trace);
        }

        @Override
        public Option<InetSocketAddress> get$default$9() {
            return None$.MODULE$;
        }

        @Override
        public ZIO<Object, Nothing$, BoxedUnit> invalidate(Channel channel, Object trace) {
            return this.pool.invalidate((Object)channel, trace);
        }

        @Override
        public boolean enableKeepAlive() {
            return true;
        }

        private <E> Schedule retrySchedule(PoolKey key, Object trace) {
            return Schedule$.MODULE$.recurWhile((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                return None$.MODULE$.equals(object);
            }, trace).$amp$amp(Schedule$.MODULE$.recurs(BoxesRunTime.unboxToInt((Object)this.maxItems.apply((Object)key)), trace), Zippable$.MODULE$.Zippable2());
        }

        private final ZIO get$$anonfun$1$$anonfun$1(PoolKey key$1, Object trace$9) {
            return this.pool.get((Object)key$1, trace$9);
        }

        private final boolean get$$anonfun$1$$anonfun$2$$anonfun$1() {
            return true;
        }

        private final ZIO get$$anonfun$1$$anonfun$2$$anonfun$4(ZIO release$1, Object trace$11) {
            return release$1.forkDaemon(trace$11);
        }

        private final None$ get$$anonfun$1$$anonfun$2$$anonfun$5$$anonfun$1() {
            return None$.MODULE$;
        }

        private final ZIO get$$anonfun$1$$anonfun$2$$anonfun$5(Object trace$12) {
            return ZIO$.MODULE$.fail(this::get$$anonfun$1$$anonfun$2$$anonfun$5$$anonfun$1, trace$12);
        }

        private final Schedule get$$anonfun$1$$anonfun$3(PoolKey key$2, Object trace$13) {
            return this.retrySchedule(key$2, trace$13);
        }

        private final Throwable get$$anonfun$1$$anonfun$4$$anonfun$1(Throwable e$1) {
            return e$1;
        }

        private final boolean get$$anonfun$1$$anonfun$5$$anonfun$1(Channel c$1) {
            return c$1.isOpen();
        }

        private final ZIO get$$anonfun$1$$anonfun$5$$anonfun$2(Channel c$2, Object trace$15) {
            return this.invalidate(c$2, trace$15);
        }
    }
}

