/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.NotGiven$;
import scala.util.control.NonFatal$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Exit;
import zio.Exit$;
import zio.FiberFailure$;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Body$WebsocketBody$;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.Header$AcceptEncoding$;
import zio.http.Header$ContentLength$;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Method;
import zio.http.Request;
import zio.http.Request$;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Routes;
import zio.http.Server;
import zio.http.Status;
import zio.http.Status$SwitchingProtocols$;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$Http_1_0$;
import zio.http.Version$Http_1_1$;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.netty.AsyncBodyReader;
import zio.http.netty.NettyBody;
import zio.http.netty.NettyBody$;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyResponseEncoder$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.server.ServerAsyncBodyHandler;
import zio.http.netty.server.ServerInboundHandler$;
import zio.http.netty.socket.NettySocketProtocol$;

@ChannelHandler.Sharable
public final class ServerInboundHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Product,
Serializable {
    private final AtomicReference appRef;
    private final Server.Config config;
    private final Object trace;
    private final Unsafe unsafe;
    private Routes<Object, Response> app;
    private NettyRuntime runtime;
    private final LongAdder inFlightRequests;
    private final boolean readClientCert;

    public static ServerInboundHandler apply(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference, Server.Config config, Object object) {
        return ServerInboundHandler$.MODULE$.apply(atomicReference, config, object);
    }

    public static ZLayer<AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>>, Nothing$, ServerInboundHandler> live() {
        return ServerInboundHandler$.MODULE$.live();
    }

    public static ServerInboundHandler unapply(ServerInboundHandler serverInboundHandler) {
        return ServerInboundHandler$.MODULE$.unapply(serverInboundHandler);
    }

    public ServerInboundHandler(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        this.appRef = appRef;
        this.config = config;
        this.trace = trace;
        super(false);
        this.unsafe = Unsafe$.MODULE$.unsafe();
        this.inFlightRequests = new LongAdder();
        this.readClientCert = config.sslConfig().exists((Function1 & Serializable)_$3 -> _$3.includeClientCert());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ServerInboundHandler)) return false;
        ServerInboundHandler serverInboundHandler = (ServerInboundHandler)object;
        AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference = this.appRef();
        AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> atomicReference2 = serverInboundHandler.appRef();
        if (atomicReference == null) {
            if (atomicReference2 != null) {
                return false;
            }
        } else if (!atomicReference.equals(atomicReference2)) return false;
        Server.Config config = this.config();
        Server.Config config2 = serverInboundHandler.config();
        if (config == null) {
            if (config2 == null) return true;
            return false;
        } else {
            if (!((Object)config).equals(config2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ServerInboundHandler;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ServerInboundHandler";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "appRef";
        }
        if (1 == n2) {
            return "config";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef() {
        return this.appRef;
    }

    public Server.Config config() {
        return this.config;
    }

    public LongAdder inFlightRequests() {
        return this.inFlightRequests;
    }

    public boolean readClientCert() {
        return this.readClientCert;
    }

    public void refreshApp() {
        Tuple2<Routes<Object, Response>, Runtime<Object>> pair = this.appRef().get();
        this.app = (Routes)pair._1();
        this.runtime = new NettyRuntime((Runtime<Object>)((Runtime)pair._2()));
    }

    private void ensureHasApp() {
        if (this.runtime == null) {
            this.refreshApp();
            return;
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        HttpObject httpObject = msg;
        if (httpObject instanceof HttpRequest) {
            Exit exit;
            Exit exit2;
            HttpRequest jReq = (HttpRequest)httpObject;
            Request req = this.makeZioRequest(ctx, jReq);
            this.inFlightRequests().increment();
            JFunction0.mcV.sp & Serializable releaseRequest = (JFunction0.mcV.sp & Serializable)() -> {
                block0: {
                    FullHttpRequest jFullReq;
                    this.inFlightRequests().decrement();
                    HttpRequest httpRequest = jReq;
                    if (!(httpRequest instanceof FullHttpRequest) || (jFullReq = (FullHttpRequest)httpRequest).refCnt() <= 0) break block0;
                    boolean bl = jFullReq.release();
                }
            };
            this.ensureHasApp();
            if (jReq.decoderResult().isFailure()) {
                Throwable throwable = jReq.decoderResult().cause();
                exit2 = Exit$.MODULE$.succeed((Object)Response$.MODULE$.fromThrowable(throwable));
            } else {
                exit2 = exit = this.app.apply(req, (.less.colon.less<Response, Response>)$less$colon$less$.MODULE$.refl());
            }
            if (!this.attemptImmediateWrite(ctx, (ZIO<Object, Response, Response>)exit)) {
                this.writeResponse(ctx, this.runtime, (ZIO<Object, Response, Response>)exit, jReq, (Function0<BoxedUnit>)releaseRequest);
                return;
            }
            releaseRequest.apply$mcV$sp();
            return;
        }
        if (httpObject instanceof HttpContent) {
            HttpContent msg2 = (HttpContent)httpObject;
            ChannelHandlerContext channelHandlerContext = ctx.fireChannelRead((Object)msg2);
            return;
        }
        throw new IllegalStateException(new StringBuilder(25).append("Unexpected message type: ").append(msg.getClass().getName()).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Throwable throwable;
        IOException ioe;
        String msg;
        Throwable throwable2 = cause;
        if (throwable2 instanceof IOException && (msg = (ioe = (IOException)throwable2).getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        Throwable t = throwable2;
        if (this.runtime != null) {
            NettyRuntime nettyRuntime = this.runtime;
            nettyRuntime.run(ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {}, nettyRuntime.run$default$3(), (ZIO<Object, Throwable, Object>)ZIO$.MODULE$.logWarningCause(ServerInboundHandler::exceptionCaught$$anonfun$2, () -> ServerInboundHandler.exceptionCaught$$anonfun$3(t), this.trace).when(this::exceptionCaught$$anonfun$4, this.trace), this.unsafe, this.trace);
        }
        if ((throwable = cause) instanceof ReadTimeoutException) {
            ctx.close();
            return;
        }
        super.exceptionCaught(ctx, t);
    }

    private AsyncBodyReader addAsyncBodyHandler(ChannelHandlerContext ctx) {
        ServerAsyncBodyHandler handler = new ServerAsyncBodyHandler();
        ctx.channel().pipeline().addAfter(package$Names$.MODULE$.HttpRequestHandler(), package$Names$.MODULE$.HttpContentHandler(), (ChannelHandler)handler);
        return handler;
    }

    private boolean attemptFastWrite(ChannelHandlerContext ctx, Response response) {
        Body body = response.body();
        if (body instanceof Body.UnsafeBytes) {
            boolean bl;
            Body.UnsafeBytes body2 = (Body.UnsafeBytes)body;
            try {
                bl = this.fastEncode$1(ctx, response, body2.unsafeAsArray(this.unsafe));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    bl = this.fastEncode$1(ctx, this.withDefaultErrorResponse(e), Array$.MODULE$.emptyByteArray());
                }
                throw throwable;
            }
            return bl;
        }
        return false;
    }

    private ZIO<Object, Throwable, Option<ZIO<Object, Throwable, BoxedUnit>>> attemptFullWrite(ChannelHandlerContext ctx, NettyRuntime runtime, Response response, HttpRequest jRequest) {
        Body body = response.body();
        if (body instanceof Body.WebsocketBody) {
            WebSocketApp<Object> webSocketApp;
            Body.WebsocketBody websocketBody = Body$WebsocketBody$.MODULE$.unapply((Body.WebsocketBody)body);
            WebSocketApp<Object> socketApp = webSocketApp = websocketBody._1();
            Status status = response.status();
            Status$SwitchingProtocols$ status$SwitchingProtocols$ = Status$SwitchingProtocols$.MODULE$;
            if (!(status != null ? !status.equals(status$SwitchingProtocols$) : status$SwitchingProtocols$ != null)) {
                return this.upgradeToWebSocket(ctx, jRequest, socketApp, runtime).as(ServerInboundHandler::attemptFullWrite$$anonfun$1, this.trace);
            }
        }
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$1 -> {
            HttpResponse jResponse = NettyResponseEncoder$.MODULE$.encode(response, (Unsafe)evidence$1);
            if (!(jResponse instanceof FullHttpResponse)) {
                None$ none$;
                String string = jResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                if (string == null) {
                    none$ = None$.MODULE$;
                } else {
                    String value = string;
                    none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value))));
                }
                None$ contentLength = none$;
                ctx.writeAndFlush((Object)jResponse);
                return NettyBodyWriter$.MODULE$.writeAndFlush(response.body(), (Option<Object>)contentLength, ctx, this.isResponseCompressible(jRequest), this.trace);
            }
            ctx.writeAndFlush((Object)jResponse);
            return None$.MODULE$;
        }, this.trace);
    }

    private boolean attemptImmediateWrite(ChannelHandlerContext ctx, ZIO<Object, Response, Response> exit) {
        Exit.Success success;
        Response response;
        Response response2;
        ZIO<Object, Response, Response> zIO = exit;
        if (zIO instanceof Exit.Success && (response2 = (response = (Response)(success = Exit.Success$.MODULE$.unapply((Exit.Success)zIO))._1())) != null) {
            return this.attemptFastWrite(ctx, response2);
        }
        return false;
    }

    private boolean isResponseCompressible(HttpRequest req) {
        Option<Server.Config.ResponseCompressionConfig> option = this.config().responseCompression();
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            Server.Config.ResponseCompressionConfig cfg = (Server.Config.ResponseCompressionConfig)((Some)option).value();
            HttpHeaders headers = req.headers();
            String headerName = Header$AcceptEncoding$.MODULE$.name();
            return cfg.options().exists((Function1 & Serializable)opt -> headers.containsValue((CharSequence)headerName, (CharSequence)opt.name(), true));
        }
        throw new MatchError(option);
    }

    private Request makeZioRequest(ChannelHandlerContext ctx, HttpRequest nettyReq) {
        None$ none$;
        None$ none$2;
        Version version;
        HttpVersion nettyHttpVersion;
        HttpVersion httpVersion = nettyHttpVersion = nettyReq.protocolVersion();
        HttpVersion httpVersion2 = HttpVersion.HTTP_1_0;
        HttpVersion httpVersion3 = httpVersion;
        if (!(httpVersion2 != null ? !httpVersion2.equals(httpVersion3) : httpVersion3 != null)) {
            version = Version$Http_1_0$.MODULE$;
        } else {
            HttpVersion httpVersion4 = HttpVersion.HTTP_1_1;
            HttpVersion httpVersion5 = httpVersion;
            if (!(httpVersion4 != null ? !httpVersion4.equals(httpVersion5) : httpVersion5 != null)) {
                version = Version$Http_1_1$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported HTTP version: ").append(nettyHttpVersion).toString());
            }
        }
        Version protocolVersion = version;
        if (this.readClientCert()) {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            Object object = Predef$.MODULE$.refArrayOps((Object[])sslHandler.engine().getSession().getPeerCertificates());
            none$2 = ArrayOps$.MODULE$.headOption$extension(object);
        } else {
            none$2 = None$.MODULE$;
        }
        None$ clientCert = none$2;
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress m = (InetSocketAddress)socketAddress;
            none$ = Option$.MODULE$.apply((Object)m.getAddress());
        } else {
            none$ = None$.MODULE$;
        }
        None$ remoteAddress = none$;
        Headers headers = Conversions$.MODULE$.headersFromNetty(nettyReq.headers());
        Option<String> contentTypeHeader = headers.headers().get(Header$ContentType$.MODULE$.name());
        HttpRequest httpRequest = nettyReq;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest nettyReq2 = (FullHttpRequest)httpRequest;
            Body body = NettyBody$.MODULE$.fromByteBuf(nettyReq2.content(), contentTypeHeader);
            Method method = Conversions$.MODULE$.methodFromNetty(nettyReq2.method());
            URL uRL = (URL)URL$.MODULE$.decode(nettyReq2.uri()).getOrElse(ServerInboundHandler::$anonfun$2);
            return Request$.MODULE$.apply(protocolVersion, method, uRL, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        if (httpRequest != null) {
            HttpRequest nettyReq3 = httpRequest;
            Option knownContentLength = headers.get(Header$ContentLength$.MODULE$).map((Function1 & Serializable)_$4 -> _$4.length());
            AsyncBodyReader handler = this.addAsyncBodyHandler(ctx);
            Body body = NettyBody$.MODULE$.fromAsync((Function1<NettyBody.UnsafeAsync, BoxedUnit>)(JProcedure1 & Serializable)async -> handler.connect((NettyBody.UnsafeAsync)async), (Option<Object>)knownContentLength, contentTypeHeader);
            Method method = Conversions$.MODULE$.methodFromNetty(nettyReq3.method());
            URL uRL = (URL)URL$.MODULE$.decode(nettyReq3.uri()).getOrElse(ServerInboundHandler::$anonfun$5);
            return Request$.MODULE$.apply(protocolVersion, method, uRL, headers, body, (Option<InetAddress>)remoteAddress, (Option<Certificate>)clientCert);
        }
        throw new MatchError((Object)httpRequest);
    }

    private ZIO<Object, Throwable, BoxedUnit> upgradeToWebSocket(ChannelHandlerContext ctx, HttpRequest jReq, WebSocketApp<Object> webSocketApp, NettyRuntime runtime) {
        HttpRequest httpRequest = jReq;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest jReq2 = (FullHttpRequest)httpRequest;
            return Queue$.MODULE$.unbounded(this.trace).tap((Function1 & Serializable)queue -> ZIO$.MODULE$.suspend(() -> this.upgradeToWebSocket$$anonfun$1$$anonfun$1(ctx, queue, webSocketApp), this.trace), this.trace).flatMap((Function1 & Serializable)queue -> ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$2 -> {
                ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(NettySocketProtocol$.MODULE$.serverBuilder((WebSocketConfig)webSocketApp.customConfig().getOrElse(this::upgradeToWebSocket$$anonfun$2$$anonfun$1$$anonfun$1)).build())}).addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)new WebSocketAppHandler(runtime, (Queue<ChannelEvent<WebSocketFrame>>)queue, (Option<Promise<Throwable, ChannelState>>)None$.MODULE$, this.trace));
                FullHttpRequest retained = jReq2.retainedDuplicate();
                Future future = ctx.channel().eventLoop().submit(() -> ctx.fireChannelRead((Object)retained));
            }, this.trace), this.trace);
        }
        if (httpRequest != null) {
            HttpRequest jReq3 = httpRequest;
            return ZIO$.MODULE$.suspend(() -> this.upgradeToWebSocket$$anonfun$3(jReq3, ctx, webSocketApp, runtime), this.trace);
        }
        throw new MatchError((Object)httpRequest);
    }

    private void writeNotFound(ChannelHandlerContext ctx, HttpRequest jReq) {
        Response response = Response$.MODULE$.notFound(jReq.uri());
        this.attemptFastWrite(ctx, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, NettyRuntime runtime, ZIO<Object, Response, Response> exit, HttpRequest jReq, Function0<BoxedUnit> ensured) {
        runtime.run(ctx, ensured, runtime.run$default$3(), (ZIO<Object, Throwable, Object>)exit.sandbox(this.trace).catchAll((Function1 & Serializable)error -> (ZIO)error.failureOrCause().fold((Function1 & Serializable)response -> ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> response, this.trace), (Function1 & Serializable)cause -> {
            if (cause.isInterruptedOnly()) {
                return this.interrupted(ctx).as(ServerInboundHandler::writeResponse$$anonfun$1$$anonfun$2$$anonfun$1, this.trace);
            }
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> this.withDefaultErrorResponse((Throwable)FiberFailure$.MODULE$.apply(cause)), this.trace);
        }), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), this.trace).flatMap((Function1 & Serializable)response -> ZIO$.MODULE$.suspend(() -> this.writeResponse$$anonfun$2$$anonfun$1(response, ctx, runtime, jReq), this.trace).foldCauseZIO((Function1 & Serializable)cause -> ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$5 -> this.attemptFastWrite(ctx, this.withDefaultErrorResponse(cause.squash(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl())))), this.trace), (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return ZIO$.MODULE$.unit();
            }
            if (option instanceof Some) {
                ZIO task = (ZIO)((Some)option).value();
                return task.orElse(() -> this.writeResponse$$anonfun$2$$anonfun$3$$anonfun$1(ctx), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), this.trace);
            }
            throw new MatchError((Object)option);
        }, this.trace), this.trace), this.unsafe, this.trace);
    }

    private ZIO<Object, Nothing$, BoxedUnit> interrupted(ChannelHandlerContext ctx) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$7 -> ctx.channel().close(), this.trace).unit(this.trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), this.trace);
    }

    private Response withDefaultErrorResponse(Throwable cause) {
        return Response$.MODULE$.internalServerError(cause.getMessage());
    }

    public ServerInboundHandler copy(AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> appRef, Server.Config config, Object trace) {
        return new ServerInboundHandler(appRef, config, trace);
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> copy$default$1() {
        return this.appRef();
    }

    public Server.Config copy$default$2() {
        return this.config();
    }

    public AtomicReference<Tuple2<Routes<Object, Response>, Runtime<Object>>> _1() {
        return this.appRef();
    }

    public Server.Config _2() {
        return this.config();
    }

    private static final String exceptionCaught$$anonfun$2() {
        return "Fatal exception in Netty";
    }

    private static final Cause exceptionCaught$$anonfun$3(Throwable t$1) {
        return Cause$.MODULE$.die(t$1, Cause$.MODULE$.die$default$2());
    }

    private final boolean exceptionCaught$$anonfun$4() {
        return this.config().logWarningOnFatalError();
    }

    private final boolean fastEncode$1(ChannelHandlerContext ctx$1, Response response, byte[] bytes) {
        FullHttpResponse jResponse = NettyResponseEncoder$.MODULE$.fastEncode(response, bytes, this.unsafe);
        FullHttpResponse djResponse = jResponse.retainedDuplicate();
        ctx$1.writeAndFlush((Object)djResponse, ctx$1.voidPromise());
        return true;
    }

    private static final None$ attemptFullWrite$$anonfun$1() {
        return None$.MODULE$;
    }

    private static final URL $anonfun$2() {
        return URL$.MODULE$.empty();
    }

    private static final URL $anonfun$5() {
        return URL$.MODULE$.empty();
    }

    private final ZIO upgradeToWebSocket$$anonfun$1$$anonfun$1(ChannelHandlerContext ctx$4, Queue queue$1, WebSocketApp webSocketApp$2) {
        NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(ctx$4.channel());
        Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue$1);
        return webSocketApp$2.handler().runZIO(webSocketChannel).ignoreLogged(this.trace).forkDaemon(this.trace);
    }

    private final WebSocketConfig upgradeToWebSocket$$anonfun$2$$anonfun$1$$anonfun$1() {
        return this.config().webSocketConfig();
    }

    private final ZIO upgradeToWebSocket$$anonfun$3(HttpRequest jReq$4, ChannelHandlerContext ctx$8, WebSocketApp webSocketApp$5, NettyRuntime runtime$3) {
        DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(jReq$4.protocolVersion(), jReq$4.method(), jReq$4.uri());
        fullRequest.headers().setAll(jReq$4.headers());
        return this.upgradeToWebSocket(ctx$8, (HttpRequest)fullRequest, webSocketApp$5, runtime$3);
    }

    private static final Null$ writeResponse$$anonfun$1$$anonfun$2$$anonfun$1() {
        return null;
    }

    private final ZIO writeResponse$$anonfun$2$$anonfun$1(Response response$3, ChannelHandlerContext ctx$11, NettyRuntime runtime$4, HttpRequest jReq$5) {
        if (response$3 != null) {
            boolean done = this.attemptFastWrite(ctx$11, response$3);
            if (!done) {
                return this.attemptFullWrite(ctx$11, runtime$4, response$3, jReq$5);
            }
            return ZIO$.MODULE$.none();
        }
        if (ctx$11.channel().isOpen()) {
            this.writeNotFound(ctx$11, jReq$5);
        }
        return ZIO$.MODULE$.none();
    }

    private final ZIO writeResponse$$anonfun$2$$anonfun$3$$anonfun$1(ChannelHandlerContext ctx$16) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$6 -> ctx$16.close(), this.trace);
    }
}

