/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body$;
import zio.http.Body$ArrayBody$;
import zio.http.Body$ChunkBody$;
import zio.http.Body$FileBody$;
import zio.http.Body$StreamBody$;
import zio.http.Body$WebsocketBody$;
import zio.http.Boundary;
import zio.http.Charsets$;
import zio.http.Form;
import zio.http.Form$;
import zio.http.MediaType;
import zio.http.StreamingForm;
import zio.http.StreamingForm$;
import zio.http.WebSocketApp;
import zio.http.multipart.mixed.MultipartMixed;
import zio.http.multipart.mixed.MultipartMixed$;
import zio.schema.codec.BinaryCodec;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public interface Body {
    public static Body empty() {
        return Body$.MODULE$.empty();
    }

    public static <A> Body from(A a, BinaryCodec<A> binaryCodec, Object object) {
        return Body$.MODULE$.from(a, binaryCodec, object);
    }

    public static Body fromArray(byte[] byArray) {
        return Body$.MODULE$.fromArray(byArray);
    }

    public static Body fromCharSequence(CharSequence charSequence, Charset charset) {
        return Body$.MODULE$.fromCharSequence(charSequence, charset);
    }

    public static Body fromCharSequenceStream(ZStream<Object, Throwable, CharSequence> zStream, long l, Charset charset, Object object) {
        return Body$.MODULE$.fromCharSequenceStream(zStream, l, charset, object);
    }

    public static Body fromCharSequenceStreamChunked(ZStream<Object, Throwable, CharSequence> zStream, Charset charset, Object object) {
        return Body$.MODULE$.fromCharSequenceStreamChunked(zStream, charset, object);
    }

    public static Body fromChunk(Chunk<Object> chunk) {
        return Body$.MODULE$.fromChunk(chunk);
    }

    public static Body fromChunk(Chunk<Object> chunk, MediaType mediaType) {
        return Body$.MODULE$.fromChunk(chunk, mediaType);
    }

    public static ZIO<Object, Nothing$, Body> fromFile(File file, int n, Object object) {
        return Body$.MODULE$.fromFile(file, n, object);
    }

    public static Body fromMultipartForm(Form form, Boundary boundary, Object object) {
        return Body$.MODULE$.fromMultipartForm(form, boundary, object);
    }

    public static ZIO<Object, Nothing$, Body> fromMultipartFormUUID(Form form, Object object) {
        return Body$.MODULE$.fromMultipartFormUUID(form, object);
    }

    public static WebsocketBody fromSocketApp(WebSocketApp<Object> webSocketApp) {
        return Body$.MODULE$.fromSocketApp(webSocketApp);
    }

    public static <A> Body fromStream(ZStream<Object, Throwable, A> zStream, BinaryCodec<A> binaryCodec, Object object) {
        return Body$.MODULE$.fromStream(zStream, binaryCodec, object);
    }

    public static Body fromStream(ZStream<Object, Throwable, Object> zStream, long l) {
        return Body$.MODULE$.fromStream(zStream, l);
    }

    public static Body fromStreamChunked(ZStream<Object, Throwable, Object> zStream) {
        return Body$.MODULE$.fromStreamChunked(zStream);
    }

    public static Body fromString(String string, Charset charset) {
        return Body$.MODULE$.fromString(string, charset);
    }

    public static Body fromURLEncodedForm(Form form, Charset charset) {
        return Body$.MODULE$.fromURLEncodedForm(form, charset);
    }

    public static Charset fromCharSequence$default$2() {
        return Body$.MODULE$.fromCharSequence$default$2();
    }

    public static Charset fromCharSequenceStreamChunked$default$2() {
        return Body$.MODULE$.fromCharSequenceStreamChunked$default$2();
    }

    public static int fromFile$default$2() {
        return Body$.MODULE$.fromFile$default$2();
    }

    public static Charset fromString$default$2() {
        return Body$.MODULE$.fromString$default$2();
    }

    public static Charset fromURLEncodedForm$default$2() {
        return Body$.MODULE$.fromURLEncodedForm$default$2();
    }

    public static Charset fromCharSequenceStream$default$3() {
        return Body$.MODULE$.fromCharSequenceStream$default$3();
    }

    public static Body $plus$plus$(Body $this, Body that) {
        return $this.$plus$plus(that);
    }

    default public Body $plus$plus(Body that) {
        if (that.isEmpty()) {
            return this;
        }
        return that;
    }

    public static ZIO to$(Body $this, BinaryCodec codec, Object trace) {
        return $this.to(codec, trace);
    }

    default public <A> ZIO<Object, Throwable, A> to(BinaryCodec<A> codec, Object trace) {
        return this.asChunk(trace).flatMap((Function1 & Serializable)bytes -> ZIO$.MODULE$.fromEither(() -> Body.to$$anonfun$1$$anonfun$1(codec, bytes), trace), trace);
    }

    public ZIO<Object, Throwable, byte[]> asArray(Object var1);

    public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object var1);

    public static ZIO asMultipartForm$(Body $this, Object trace) {
        return $this.asMultipartForm(trace);
    }

    default public ZIO<Object, Throwable, Form> asMultipartForm(Object trace) {
        Option<Boundary> option = this.boundary();
        if (option instanceof Some) {
            Boundary boundary = (Boundary)((Some)option).value();
            return StreamingForm$.MODULE$.apply(this.asStream(trace), boundary, StreamingForm$.MODULE$.$lessinit$greater$default$3()).collectAll(trace);
        }
        return this.asChunk(trace).flatMap((Function1 & Serializable)bytes -> Form$.MODULE$.fromMultipartBytes((Chunk<Object>)bytes, Charsets$.MODULE$.Http(), this.boundary(), trace).map((Function1 & Serializable)form -> form, trace), trace);
    }

    public static ZIO asMultipartFormStream$(Body $this, Object trace) {
        return $this.asMultipartFormStream(trace);
    }

    default public ZIO<Object, Throwable, StreamingForm> asMultipartFormStream(Object trace) {
        Option<Boundary> option = this.boundary();
        if (option instanceof Some) {
            Boundary boundary = (Boundary)((Some)option).value();
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> StreamingForm$.MODULE$.apply(this.asStream(trace), boundary, StreamingForm$.MODULE$.$lessinit$greater$default$3()), trace);
        }
        if (None$.MODULE$.equals(option)) {
            return ZIO$.MODULE$.fail(Body::asMultipartFormStream$$anonfun$2, trace);
        }
        throw new MatchError(option);
    }

    public static ZIO asMultipartMixed$(Body $this, Object trace) {
        return $this.asMultipartMixed(trace);
    }

    default public ZIO<Object, Throwable, MultipartMixed> asMultipartMixed(Object trace) {
        return ZIO$.MODULE$.fromOption(this::asMultipartMixed$$anonfun$1, trace).orElseFail(Body::asMultipartMixed$$anonfun$2, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
    }

    public ZStream<Object, Throwable, Object> asStream(Object var1);

    public static ZIO asString$(Body $this, Object trace) {
        return $this.asString(trace);
    }

    default public ZIO<Object, Throwable, String> asString(Object trace) {
        return this.asArray(trace).map((Function1 & Serializable)_$1 -> new String((byte[])_$1, Charsets$.MODULE$.Http()), trace);
    }

    public static ZIO asString$(Body $this, Charset charset, Object trace) {
        return $this.asString(charset, trace);
    }

    default public ZIO<Object, Throwable, String> asString(Charset charset, Object trace) {
        return this.asArray(trace).map((Function1 & Serializable)_$2 -> new String((byte[])_$2, charset), trace);
    }

    public static ZIO asURLEncodedForm$(Body $this, Object trace) {
        return $this.asURLEncodedForm(trace);
    }

    default public ZIO<Object, Throwable, Form> asURLEncodedForm(Object trace) {
        return this.asString(trace).flatMap((Function1 & Serializable)string -> ZIO$.MODULE$.fromEither(() -> Body.asURLEncodedForm$$anonfun$1$$anonfun$1(string), trace), trace);
    }

    public boolean isComplete();

    public Option<Object> knownContentLength();

    public boolean isEmpty();

    public Option<MediaType> mediaType();

    public Body contentType(MediaType var1);

    public Body contentType(MediaType var1, Boundary var2);

    public Option<Boundary> boundary();

    private static Either to$$anonfun$1$$anonfun$1(BinaryCodec codec$2, Chunk bytes$1) {
        return codec$2.decode((Object)bytes$1);
    }

    private static IllegalStateException asMultipartFormStream$$anonfun$2() {
        return new IllegalStateException("Cannot decode body as streaming multipart/form-data without a known boundary");
    }

    private Option asMultipartMixed$$anonfun$1() {
        return MultipartMixed$.MODULE$.fromBody(this, MultipartMixed$.MODULE$.fromBody$default$2());
    }

    private static IllegalStateException asMultipartMixed$$anonfun$2() {
        return new IllegalStateException("Cannot decode body as multipart/mixed without a known boundary");
    }

    private static Either asURLEncodedForm$$anonfun$1$$anonfun$1(String string$1) {
        return Form$.MODULE$.fromURLEncoded(string$1, Charsets$.MODULE$.Http());
    }

    public static final class ArrayBody
    implements Body,
    UnsafeBytes,
    Product,
    Serializable {
        private final byte[] data;
        private final Option mediaType;
        private final Option boundary;

        public static ArrayBody apply(byte[] byArray, Option<MediaType> option, Option<Boundary> option2) {
            return Body$ArrayBody$.MODULE$.apply(byArray, option, option2);
        }

        public static ArrayBody fromProduct(Product product) {
            return Body$ArrayBody$.MODULE$.fromProduct(product);
        }

        public static ArrayBody unapply(ArrayBody arrayBody) {
            return Body$ArrayBody$.MODULE$.unapply(arrayBody);
        }

        public static Option<MediaType> $lessinit$greater$default$2() {
            return Body$ArrayBody$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Boundary> $lessinit$greater$default$3() {
            return Body$ArrayBody$.MODULE$.$lessinit$greater$default$3();
        }

        public ArrayBody(byte[] data, Option<MediaType> mediaType, Option<Boundary> boundary) {
            this.data = data;
            this.mediaType = mediaType;
            this.boundary = boundary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ArrayBody)) return false;
            ArrayBody arrayBody = (ArrayBody)object;
            if (this.data() != arrayBody.data()) return false;
            Option<MediaType> option = this.mediaType();
            Option<MediaType> option2 = arrayBody.mediaType();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Boundary> option3 = this.boundary();
            Option<Boundary> option4 = arrayBody.boundary();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ArrayBody;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ArrayBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "data";
                }
                case 1: {
                    return "mediaType";
                }
                case 2: {
                    return "boundary";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte[] data() {
            return this.data;
        }

        @Override
        public Option<MediaType> mediaType() {
            return this.mediaType;
        }

        @Override
        public Option<Boundary> boundary() {
            return this.boundary;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$7 -> this.data(), trace);
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            Object object = Predef$.MODULE$.byteArrayOps(this.data());
            return ArrayOps$.MODULE$.isEmpty$extension(object);
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$8 -> Chunk$.MODULE$.fromArray((Object)this.data()), trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$2(trace), trace);
        }

        public String toString() {
            return new StringBuilder(16).append("Body.fromArray(").append(this.data()).append(")").toString();
        }

        @Override
        public byte[] unsafeAsArray(Unsafe unsafe) {
            return this.data();
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            byte[] byArray = this.copy$default$1();
            Option<Boundary> option = this.copy$default$3();
            return this.copy(byArray, (Option<MediaType>)some, option);
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Option option = this.boundary().orElse(() -> this.$anonfun$2(newBoundary));
            byte[] byArray = this.copy$default$1();
            return this.copy(byArray, (Option<MediaType>)some, (Option<Boundary>)option);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.data().length));
        }

        public ArrayBody copy(byte[] data, Option<MediaType> mediaType, Option<Boundary> boundary) {
            return new ArrayBody(data, mediaType, boundary);
        }

        public byte[] copy$default$1() {
            return this.data();
        }

        public Option<MediaType> copy$default$2() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$3() {
            return this.boundary();
        }

        public byte[] _1() {
            return this.data();
        }

        public Option<MediaType> _2() {
            return this.mediaType();
        }

        public Option<Boundary> _3() {
            return this.boundary();
        }

        private final Chunk asStream$$anonfun$2$$anonfun$1$$anonfun$1(Chunk _$4$1) {
            return _$4$1;
        }

        private final ZIO asStream$$anonfun$2(Object trace$7) {
            return this.asChunk(trace$7).map((Function1 & Serializable)_$4 -> ZStream$.MODULE$.fromChunk(() -> this.asStream$$anonfun$2$$anonfun$1$$anonfun$1(_$4), trace$7), trace$7);
        }

        private final Option $anonfun$2(Boundary newBoundary$2) {
            return Some$.MODULE$.apply((Object)newBoundary$2);
        }
    }

    public static final class ChunkBody
    implements Body,
    UnsafeBytes,
    Product,
    Serializable {
        private final Chunk data;
        private final Option mediaType;
        private final Option boundary;

        public static ChunkBody apply(Chunk<Object> chunk, Option<MediaType> option, Option<Boundary> option2) {
            return Body$ChunkBody$.MODULE$.apply(chunk, option, option2);
        }

        public static ChunkBody fromProduct(Product product) {
            return Body$ChunkBody$.MODULE$.fromProduct(product);
        }

        public static ChunkBody unapply(ChunkBody chunkBody) {
            return Body$ChunkBody$.MODULE$.unapply(chunkBody);
        }

        public static Option<MediaType> $lessinit$greater$default$2() {
            return Body$ChunkBody$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Boundary> $lessinit$greater$default$3() {
            return Body$ChunkBody$.MODULE$.$lessinit$greater$default$3();
        }

        public ChunkBody(Chunk<Object> data, Option<MediaType> mediaType, Option<Boundary> boundary) {
            this.data = data;
            this.mediaType = mediaType;
            this.boundary = boundary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChunkBody)) return false;
            ChunkBody chunkBody = (ChunkBody)object;
            Chunk<Object> chunk = this.data();
            Chunk<Object> chunk2 = chunkBody.data();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Option<MediaType> option = this.mediaType();
            Option<MediaType> option2 = chunkBody.mediaType();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Boundary> option3 = this.boundary();
            Option<Boundary> option4 = chunkBody.boundary();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ChunkBody;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ChunkBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "data";
                }
                case 1: {
                    return "mediaType";
                }
                case 2: {
                    return "boundary";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<Object> data() {
            return this.data;
        }

        @Override
        public Option<MediaType> mediaType() {
            return this.mediaType;
        }

        @Override
        public Option<Boundary> boundary() {
            return this.boundary;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> (byte[])this.data().toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), trace);
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.data().isEmpty();
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$6 -> this.data(), trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$1(trace), trace);
        }

        public String toString() {
            return new StringBuilder(16).append("Body.fromChunk(").append(this.data()).append(")").toString();
        }

        @Override
        public byte[] unsafeAsArray(Unsafe unsafe) {
            return (byte[])this.data().toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Chunk<Object> chunk = this.copy$default$1();
            Option<Boundary> option = this.copy$default$3();
            return this.copy(chunk, (Option<MediaType>)some, option);
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Option option = this.boundary().orElse(() -> this.$anonfun$1(newBoundary));
            Chunk<Object> chunk = this.copy$default$1();
            return this.copy(chunk, (Option<MediaType>)some, (Option<Boundary>)option);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.data().length()));
        }

        public ChunkBody copy(Chunk<Object> data, Option<MediaType> mediaType, Option<Boundary> boundary) {
            return new ChunkBody(data, mediaType, boundary);
        }

        public Chunk<Object> copy$default$1() {
            return this.data();
        }

        public Option<MediaType> copy$default$2() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$3() {
            return this.boundary();
        }

        public Chunk<Object> _1() {
            return this.data();
        }

        public Option<MediaType> _2() {
            return this.mediaType();
        }

        public Option<Boundary> _3() {
            return this.boundary();
        }

        private final Chunk asStream$$anonfun$1$$anonfun$1$$anonfun$1(Chunk _$3$1) {
            return _$3$1;
        }

        private final ZIO asStream$$anonfun$1(Object trace$5) {
            return this.asChunk(trace$5).map((Function1 & Serializable)_$3 -> ZStream$.MODULE$.fromChunk(() -> this.asStream$$anonfun$1$$anonfun$1$$anonfun$1(_$3), trace$5), trace$5);
        }

        private final Option $anonfun$1(Boundary newBoundary$1) {
            return Some$.MODULE$.apply((Object)newBoundary$1);
        }
    }

    public static final class FileBody
    implements Body,
    Product,
    Serializable {
        private final File file;
        private final int chunkSize;
        private final long fileSize;
        private final Option mediaType;
        private final Option boundary;

        public static FileBody apply(File file, int n, long l, Option<MediaType> option, Option<Boundary> option2) {
            return Body$FileBody$.MODULE$.apply(file, n, l, option, option2);
        }

        public static FileBody fromProduct(Product product) {
            return Body$FileBody$.MODULE$.fromProduct(product);
        }

        public static FileBody unapply(FileBody fileBody) {
            return Body$FileBody$.MODULE$.unapply(fileBody);
        }

        public static int $lessinit$greater$default$2() {
            return Body$FileBody$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<MediaType> $lessinit$greater$default$4() {
            return Body$FileBody$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<Boundary> $lessinit$greater$default$5() {
            return Body$FileBody$.MODULE$.$lessinit$greater$default$5();
        }

        public FileBody(File file, int chunkSize, long fileSize, Option<MediaType> mediaType, Option<Boundary> boundary) {
            this.file = file;
            this.chunkSize = chunkSize;
            this.fileSize = fileSize;
            this.mediaType = mediaType;
            this.boundary = boundary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.file()));
            n = Statics.mix((int)n, (int)this.chunkSize());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileSize()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.mediaType()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.boundary()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FileBody)) return false;
            FileBody fileBody = (FileBody)object;
            if (this.chunkSize() != fileBody.chunkSize()) return false;
            if (this.fileSize() != fileBody.fileSize()) return false;
            File file = this.file();
            File file2 = fileBody.file();
            if (file == null) {
                if (file2 != null) {
                    return false;
                }
            } else if (!((Object)file).equals(file2)) return false;
            Option<MediaType> option = this.mediaType();
            Option<MediaType> option2 = fileBody.mediaType();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Boundary> option3 = this.boundary();
            Option<Boundary> option4 = fileBody.boundary();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FileBody;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "FileBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "file";
                }
                case 1: {
                    return "chunkSize";
                }
                case 2: {
                    return "fileSize";
                }
                case 3: {
                    return "mediaType";
                }
                case 4: {
                    return "boundary";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public File file() {
            return this.file;
        }

        public int chunkSize() {
            return this.chunkSize;
        }

        public long fileSize() {
            return this.fileSize;
        }

        @Override
        public Option<MediaType> mediaType() {
            return this.mediaType;
        }

        @Override
        public Option<Boundary> boundary() {
            return this.boundary;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$9 -> Files.readAllBytes(this.file().toPath()), trace);
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return this.asArray(trace).map((Function1 & Serializable)array -> Chunk$.MODULE$.fromArray(array), trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.unwrap(() -> this.asStream$$anonfun$3(trace), trace).flattenChunks((.less.colon.less)$less$colon$less$.MODULE$.refl(), trace);
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            File file = this.copy$default$1();
            int n = this.copy$default$2();
            long l = this.copy$default$3();
            Option<Boundary> option = this.copy$default$5();
            return this.copy(file, n, l, (Option<MediaType>)some, option);
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Option option = this.boundary().orElse(() -> this.$anonfun$3(newBoundary));
            File file = this.copy$default$1();
            int n = this.copy$default$2();
            long l = this.copy$default$3();
            return this.copy(file, n, l, (Option<MediaType>)some, (Option<Boundary>)option);
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.fileSize()));
        }

        public FileBody copy(File file, int chunkSize, long fileSize, Option<MediaType> mediaType, Option<Boundary> boundary) {
            return new FileBody(file, chunkSize, fileSize, mediaType, boundary);
        }

        public File copy$default$1() {
            return this.file();
        }

        public int copy$default$2() {
            return this.chunkSize();
        }

        public long copy$default$3() {
            return this.fileSize();
        }

        public Option<MediaType> copy$default$4() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$5() {
            return this.boundary();
        }

        public File _1() {
            return this.file();
        }

        public int _2() {
            return this.chunkSize();
        }

        public long _3() {
            return this.fileSize();
        }

        public Option<MediaType> _4() {
            return this.mediaType();
        }

        public Option<Boundary> _5() {
            return this.boundary();
        }

        private final None$ asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2() {
            return None$.MODULE$;
        }

        private final /* synthetic */ ZIO asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3(byte[] buffer$2, Object trace$15, int len) {
            return (len > 0 ? ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$15 -> {
                Object object = Predef$.MODULE$.byteArrayOps(buffer$2);
                return Chunk$.MODULE$.fromArray(ArrayOps$.MODULE$.slice$extension(object, 0, len));
            }, trace$15) : ZIO$.MODULE$.fail(this::asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2, trace$15)).map((Function1 & Serializable)bytes -> bytes, trace$15);
        }

        private final ZIO asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(int size$1, Object trace$12, FileInputStream fs$1) {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$13 -> new byte[size$1], trace$12).flatMap((Function1 & Serializable)buffer -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$14 -> fs$1.read((byte[])buffer), trace$12).mapError((Function1 & Serializable)_$5 -> Some$.MODULE$.apply(_$5), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$12).flatMap((Function1 & Serializable)len -> this.asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3((byte[])buffer, trace$12, BoxesRunTime.unboxToInt((Object)len)), trace$12), trace$12);
        }

        private final ZIO asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(FileInputStream fs$5, Object trace$16) {
            return ZIO$.MODULE$.attemptBlocking((Function1)(JProcedure1 & Serializable)evidence$16 -> fs$5.close(), trace$16).ignoreLogged(trace$16);
        }

        private final /* synthetic */ ZStream asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2(Object trace$13, FileInputStream fs$2, int size) {
            return ZStream$.MODULE$.repeatZIOOption(() -> this.asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(size, trace$13, fs$2), trace$13).ensuring(() -> this.asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2(fs$2, trace$13), trace$13);
        }

        private final ZIO asStream$$anonfun$3(Object trace$9) {
            return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$10 -> this.file(), trace$9).flatMap((Function1 & Serializable)file -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$11 -> new FileInputStream((File)file), trace$9).flatMap((Function1 & Serializable)fs -> ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$12 -> (int)Math.min((long)this.chunkSize(), file.length()), trace$9).map((Function1 & Serializable)size -> this.asStream$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2(trace$9, (FileInputStream)fs, BoxesRunTime.unboxToInt((Object)size)), trace$9), trace$9), trace$9);
        }

        private final Option $anonfun$3(Boundary newBoundary$3) {
            return Some$.MODULE$.apply((Object)newBoundary$3);
        }
    }

    public static final class StreamBody
    implements Body,
    Product,
    Serializable {
        private final ZStream stream;
        private final Option knownContentLength;
        private final Option mediaType;
        private final Option boundary;

        public static StreamBody apply(ZStream<Object, Throwable, Object> zStream, Option<Object> option, Option<MediaType> option2, Option<Boundary> option3) {
            return Body$StreamBody$.MODULE$.apply(zStream, option, option2, option3);
        }

        public static StreamBody fromProduct(Product product) {
            return Body$StreamBody$.MODULE$.fromProduct(product);
        }

        public static StreamBody unapply(StreamBody streamBody) {
            return Body$StreamBody$.MODULE$.unapply(streamBody);
        }

        public static Option<MediaType> $lessinit$greater$default$3() {
            return Body$StreamBody$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<Boundary> $lessinit$greater$default$4() {
            return Body$StreamBody$.MODULE$.$lessinit$greater$default$4();
        }

        public StreamBody(ZStream<Object, Throwable, Object> stream, Option<Object> knownContentLength, Option<MediaType> mediaType, Option<Boundary> boundary) {
            this.stream = stream;
            this.knownContentLength = knownContentLength;
            this.mediaType = mediaType;
            this.boundary = boundary;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StreamBody)) return false;
            StreamBody streamBody = (StreamBody)object;
            ZStream<Object, Throwable, Object> zStream = this.stream();
            ZStream<Object, Throwable, Object> zStream2 = streamBody.stream();
            if (zStream == null) {
                if (zStream2 != null) {
                    return false;
                }
            } else if (!zStream.equals(zStream2)) return false;
            Option<Object> option = this.knownContentLength();
            Option<Object> option2 = streamBody.knownContentLength();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<MediaType> option3 = this.mediaType();
            Option<MediaType> option4 = streamBody.mediaType();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Boundary> option5 = this.boundary();
            Option<Boundary> option6 = streamBody.boundary();
            if (option5 == null) {
                if (option6 == null) return true;
                return false;
            } else {
                if (!option5.equals(option6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StreamBody;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "StreamBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "stream";
                }
                case 1: {
                    return "knownContentLength";
                }
                case 2: {
                    return "mediaType";
                }
                case 3: {
                    return "boundary";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ZStream<Object, Throwable, Object> stream() {
            return this.stream;
        }

        @Override
        public Option<Object> knownContentLength() {
            return this.knownContentLength;
        }

        @Override
        public Option<MediaType> mediaType() {
            return this.mediaType;
        }

        @Override
        public Option<Boundary> boundary() {
            return this.boundary;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return this.asChunk(trace).map((Function1 & Serializable)_$6 -> (byte[])_$6.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), trace);
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return this.stream().runCollect(trace);
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return this.stream();
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            ZStream<Object, Throwable, Object> zStream = this.copy$default$1();
            Option<Object> option = this.copy$default$2();
            Option<Boundary> option2 = this.copy$default$4();
            return this.copy(zStream, option, (Option<MediaType>)some, option2);
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            Some some = Some$.MODULE$.apply((Object)newMediaType);
            Option option = this.boundary().orElse(() -> this.$anonfun$4(newBoundary));
            ZStream<Object, Throwable, Object> zStream = this.copy$default$1();
            Option<Object> option2 = this.copy$default$2();
            return this.copy(zStream, option2, (Option<MediaType>)some, (Option<Boundary>)option);
        }

        public StreamBody copy(ZStream<Object, Throwable, Object> stream, Option<Object> knownContentLength, Option<MediaType> mediaType, Option<Boundary> boundary) {
            return new StreamBody(stream, knownContentLength, mediaType, boundary);
        }

        public ZStream<Object, Throwable, Object> copy$default$1() {
            return this.stream();
        }

        public Option<Object> copy$default$2() {
            return this.knownContentLength();
        }

        public Option<MediaType> copy$default$3() {
            return this.mediaType();
        }

        public Option<Boundary> copy$default$4() {
            return this.boundary();
        }

        public ZStream<Object, Throwable, Object> _1() {
            return this.stream();
        }

        public Option<Object> _2() {
            return this.knownContentLength();
        }

        public Option<MediaType> _3() {
            return this.mediaType();
        }

        public Option<Boundary> _4() {
            return this.boundary();
        }

        private final Option $anonfun$4(Boundary newBoundary$4) {
            return Some$.MODULE$.apply((Object)newBoundary$4);
        }
    }

    public static interface UnsafeBytes
    extends Body {
        public byte[] unsafeAsArray(Unsafe var1);
    }

    public static final class WebsocketBody
    implements Body,
    Product,
    Serializable {
        private final WebSocketApp socketApp;

        public static WebsocketBody apply(WebSocketApp<Object> webSocketApp) {
            return Body$WebsocketBody$.MODULE$.apply(webSocketApp);
        }

        public static WebsocketBody fromProduct(Product product) {
            return Body$WebsocketBody$.MODULE$.fromProduct(product);
        }

        public static WebsocketBody unapply(WebsocketBody websocketBody) {
            return Body$WebsocketBody$.MODULE$.unapply(websocketBody);
        }

        public WebsocketBody(WebSocketApp<Object> socketApp) {
            this.socketApp = socketApp;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WebsocketBody)) return false;
            WebsocketBody websocketBody = (WebsocketBody)object;
            WebSocketApp<Object> webSocketApp = this.socketApp();
            WebSocketApp<Object> webSocketApp2 = websocketBody.socketApp();
            if (webSocketApp != null) {
                if (!((Object)webSocketApp).equals(webSocketApp2)) return false;
                return true;
            }
            if (webSocketApp2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WebsocketBody;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "WebsocketBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "socketApp";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public WebSocketApp<Object> socketApp() {
            return this.socketApp;
        }

        @Override
        public ZIO<Object, Throwable, byte[]> asArray(Object trace) {
            return Body$.zio$http$Body$$$zioEmptyArray;
        }

        @Override
        public ZIO<Object, Throwable, Chunk<Object>> asChunk(Object trace) {
            return Body$.zio$http$Body$$$zioEmptyChunk;
        }

        @Override
        public ZStream<Object, Throwable, Object> asStream(Object trace) {
            return ZStream$.MODULE$.empty(trace);
        }

        @Override
        public Option<Boundary> boundary() {
            return None$.MODULE$;
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Option<MediaType> mediaType() {
            return None$.MODULE$;
        }

        @Override
        public Body contentType(MediaType newMediaType) {
            return this;
        }

        @Override
        public Body contentType(MediaType newMediaType, Boundary newBoundary) {
            return this;
        }

        @Override
        public Option<Object> knownContentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L));
        }

        public WebsocketBody copy(WebSocketApp<Object> socketApp) {
            return new WebsocketBody(socketApp);
        }

        public WebSocketApp<Object> copy$default$1() {
            return this.socketApp();
        }

        public WebSocketApp<Object> _1() {
            return this.socketApp();
        }
    }
}

