/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Chunk;
import zio.Chunk$;
import zio.http.Path;
import zio.http.Path$;
import zio.http.Path$Flag$TrailingSlash$;
import zio.http.Path$Flags$;
import zio.http.Response;
import zio.http.Routes;
import zio.http.codec.Combiner;
import zio.http.codec.Combiner$;
import zio.http.codec.Doc;
import zio.http.codec.Doc$;
import zio.http.codec.PathCodec;
import zio.http.codec.PathCodec$;
import zio.http.codec.PathCodec$Annotated$;
import zio.http.codec.PathCodec$Concat$;
import zio.http.codec.PathCodec$Fallback$;
import zio.http.codec.PathCodec$MetaData$;
import zio.http.codec.PathCodec$MetaData$Documented$;
import zio.http.codec.PathCodec$MetaData$Examples$;
import zio.http.codec.PathCodec$Opt$;
import zio.http.codec.PathCodec$Opt$BoolOpt$;
import zio.http.codec.PathCodec$Opt$Combine$;
import zio.http.codec.PathCodec$Opt$IntOpt$;
import zio.http.codec.PathCodec$Opt$LongOpt$;
import zio.http.codec.PathCodec$Opt$MapOrFail$;
import zio.http.codec.PathCodec$Opt$Match$;
import zio.http.codec.PathCodec$Opt$MatchAny$;
import zio.http.codec.PathCodec$Opt$StringOpt$;
import zio.http.codec.PathCodec$Opt$TrailingOpt$;
import zio.http.codec.PathCodec$Opt$UUIDOpt$;
import zio.http.codec.PathCodec$Opt$Unit$;
import zio.http.codec.PathCodec$Segment$;
import zio.http.codec.PathCodec$SegmentSubtree$;
import zio.http.codec.PathCodec$TransformOrFail$;
import zio.http.codec.SegmentCodec;
import zio.http.codec.SegmentCodec$;
import zio.http.codec.SegmentCodec$BoolSeg$;
import zio.http.codec.SegmentCodec$Empty$;
import zio.http.codec.SegmentCodec$IntSeg$;
import zio.http.codec.SegmentCodec$Literal$;
import zio.http.codec.SegmentCodec$LongSeg$;
import zio.http.codec.SegmentCodec$Text$;
import zio.http.codec.SegmentCodec$Trailing$;
import zio.http.codec.SegmentCodec$UUID$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public interface PathCodec<A> {
    public static PathCodec<BoxedUnit> apply(String string) {
        return PathCodec$.MODULE$.apply(string);
    }

    public static PathCodec<Object> bool(String string) {
        return PathCodec$.MODULE$.bool(string);
    }

    public static PathCodec<BoxedUnit> empty() {
        return PathCodec$.MODULE$.empty();
    }

    public static PathCodec<Object> int(String string) {
        return PathCodec$.MODULE$.int(string);
    }

    public static PathCodec<BoxedUnit> literal(String string) {
        return PathCodec$.MODULE$.literal(string);
    }

    public static PathCodec<Object> long(String string) {
        return PathCodec$.MODULE$.long(string);
    }

    public static int ordinal(PathCodec<?> pathCodec) {
        return PathCodec$.MODULE$.ordinal(pathCodec);
    }

    public static PathCodec<BoxedUnit> path(String string) {
        return PathCodec$.MODULE$.path(string);
    }

    public static Some<BoxedUnit> someUnit() {
        return PathCodec$.MODULE$.someUnit();
    }

    public static PathCodec<String> string(String string) {
        return PathCodec$.MODULE$.string(string);
    }

    public static PathCodec<Path> trailing() {
        return PathCodec$.MODULE$.trailing();
    }

    public static PathCodec<UUID> uuid(String string) {
        return PathCodec$.MODULE$.uuid(string);
    }

    public static void $init$(PathCodec $this) {
        $this.zio$http$codec$PathCodec$$_optimize_$eq(null);
    }

    public static PathCodec $qmark$qmark$(PathCodec $this, Doc doc) {
        return $this.$qmark$qmark(doc);
    }

    default public PathCodec<A> $qmark$qmark(Doc doc) {
        return this.annotate(PathCodec$MetaData$Documented$.MODULE$.apply(doc));
    }

    public static PathCodec $plus$plus$(PathCodec $this, PathCodec that, Combiner combiner) {
        return $this.$plus$plus(that, combiner);
    }

    default public <B> PathCodec<Object> $plus$plus(PathCodec<B> that, Combiner<A, B> combiner) {
        return PathCodec$Concat$.MODULE$.apply(this, that, combiner);
    }

    public static PathCodec $div$(PathCodec $this, PathCodec that, Combiner combiner) {
        return $this.$div(that, combiner);
    }

    default public <B> PathCodec<Object> $div(PathCodec<B> that, Combiner<A, B> combiner) {
        return this.$plus$plus(that, combiner);
    }

    public static Routes $div$(PathCodec $this, Routes routes, .less.colon.less ev) {
        return $this.$div(routes, ev);
    }

    default public <Env> Routes<Env, Response> $div(Routes<Env, Response> routes, .less.colon.less<PathCodec<A>, PathCodec<BoxedUnit>> ev) {
        return routes.nest((PathCodec)ev.apply((Object)this), "zio.http.codec.PathCodec./(PathCodec.scala:56)", (.less.colon.less<Response, Response>)$less$colon$less$.MODULE$.refl());
    }

    public static PathCodec annotate$(PathCodec $this, MetaData metaData) {
        return $this.annotate(metaData);
    }

    default public PathCodec<A> annotate(MetaData<A> metaData) {
        PathCodec pathCodec = this;
        if (pathCodec instanceof Annotated) {
            Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
            PathCodec pathCodec2 = annotated._1();
            Chunk chunk = annotated._2();
            PathCodec codc = pathCodec2;
            Chunk annotations = chunk;
            return PathCodec$Annotated$.MODULE$.apply(codc, (Chunk)annotations.$colon$plus(metaData));
        }
        return PathCodec$Annotated$.MODULE$.apply(this, Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetaData[]{metaData})));
    }

    public static PathCodec orElse$(PathCodec $this, PathCodec value, .eq.colon.eq ev) {
        return $this.orElse(value, ev);
    }

    default public PathCodec<BoxedUnit> orElse(PathCodec<BoxedUnit> value, .eq.colon.eq<A, BoxedUnit> ev) {
        return PathCodec$Fallback$.MODULE$.apply(this, value);
    }

    private List<PathCodec<Object>> fallbackAlternatives(Fallback<?> f) {
        return PathCodec.loop$1((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathCodec[]{f.left(), f.right()})), package$.MODULE$.List().empty());
    }

    public static List alternatives$(PathCodec $this) {
        return $this.alternatives();
    }

    default public List<PathCodec<A>> alternatives() {
        ObjectRef alts = ObjectRef.create((Object)package$.MODULE$.List().empty());
        this.loop$2(alts, this, Combiner$.MODULE$.leftUnit());
        return (List)alts.elem;
    }

    public static PathCodec asType$(PathCodec $this, .eq.colon.eq ev) {
        return $this.asType(ev);
    }

    default public <B> PathCodec<B> asType(.eq.colon.eq<A, B> ev) {
        return this;
    }

    public static Either decode$(PathCodec $this, Path path) {
        return $this.decode(path);
    }

    default public Either<String, A> decode(Path path) {
        Opt[] instructions = this.optimize();
        Chunk<String> segments = path.segments();
        int j = 0;
        String fail = "";
        ArrayDeque<Object> stack = new ArrayDeque<Object>(2);
        stack.push(BoxedUnit.UNIT);
        for (int i = 0; i < instructions.length; ++i) {
            Opt opt;
            block33: {
                block35: {
                    String value;
                    block34: {
                        String string;
                        Opt opt2 = instructions[i];
                        opt = opt2;
                        if (!(opt instanceof Opt.Match)) break block33;
                        Opt.Match match = PathCodec$Opt$Match$.MODULE$.unapply((Opt.Match)opt);
                        value = string = match._1();
                        if (j >= segments.length()) break block34;
                        Object object = segments.apply(j);
                        String string2 = value;
                        if (!(object == null ? string2 != null : !object.equals(string2))) break block35;
                    }
                    fail = new StringBuilder(46).append("Expected path segment \"").append(value).append("\" but found end of path").toString();
                    i = instructions.length;
                    continue;
                }
                stack.push(BoxedUnit.UNIT);
                ++j;
                continue;
            }
            if (opt instanceof Opt.MatchAny) {
                Set<String> set;
                Opt.MatchAny matchAny = PathCodec$Opt$MatchAny$.MODULE$.unapply((Opt.MatchAny)opt);
                Set<String> values = set = matchAny._1();
                if (j >= segments.length() || !values.contains(segments.apply(j))) {
                    fail = new StringBuilder(67).append("Expected one of the following path segments: ").append(values.mkString(", ")).append(" but found end of path").toString();
                    i = instructions.length;
                    continue;
                }
                stack.push(BoxedUnit.UNIT);
                ++j;
                continue;
            }
            if (opt instanceof Opt.Combine) {
                Combiner<?, ?> combiner;
                Combiner<?, ?> combiner0;
                Opt.Combine combine = PathCodec$Opt$Combine$.MODULE$.unapply((Opt.Combine)opt);
                Combiner<?, ?> combiner2 = combiner0 = (combiner = combine._1());
                Object right = stack.pop();
                Object left = stack.pop();
                stack.push(combiner2.combine(left, right));
                continue;
            }
            if (PathCodec$Opt$IntOpt$.MODULE$.equals(opt)) {
                if (j >= segments.length()) {
                    fail = "Expected integer path segment but found end of path";
                    i = instructions.length;
                    continue;
                }
                String segment = (String)segments.apply(j);
                ++j;
                try {
                    stack.push(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segment))));
                }
                catch (NumberFormatException numberFormatException) {
                    fail = new StringBuilder(42).append("Expected integer path segment but found \"").append(segment).append("\"").toString();
                    i = instructions.length;
                }
                continue;
            }
            if (PathCodec$Opt$LongOpt$.MODULE$.equals(opt)) {
                if (j >= segments.length()) {
                    fail = "Expected long path segment but found end of path";
                    i = instructions.length;
                    continue;
                }
                String segment = (String)segments.apply(j);
                ++j;
                try {
                    stack.push(BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(segment))));
                }
                catch (NumberFormatException numberFormatException) {
                    fail = new StringBuilder(37).append("Expected long path segment but found ").append(segment).toString();
                    i = instructions.length;
                }
                continue;
            }
            if (PathCodec$Opt$StringOpt$.MODULE$.equals(opt)) {
                if (j >= segments.length()) {
                    fail = "Expected text path segment but found end of path";
                    i = instructions.length;
                    continue;
                }
                String segment = (String)segments.apply(j);
                ++j;
                stack.push(segment);
                continue;
            }
            if (PathCodec$Opt$UUIDOpt$.MODULE$.equals(opt)) {
                if (j >= segments.length()) {
                    fail = "Expected UUID path segment but found end of path";
                    i = instructions.length;
                    continue;
                }
                String segment = (String)segments.apply(j);
                ++j;
                try {
                    stack.push(UUID.fromString(segment.toString()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    fail = new StringBuilder(37).append("Expected UUID path segment but found ").append(segment).toString();
                    i = instructions.length;
                }
                continue;
            }
            if (PathCodec$Opt$BoolOpt$.MODULE$.equals(opt)) {
                if (j >= segments.length()) {
                    fail = "Expected boolean path segment but found end of path";
                    i = instructions.length;
                    continue;
                }
                String segment = (String)segments.apply(j);
                ++j;
                String string = segment;
                String string3 = "true";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    stack.push(BoxesRunTime.boxToBoolean((boolean)true));
                    continue;
                }
                String string4 = segment;
                String string5 = "false";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    stack.push(BoxesRunTime.boxToBoolean((boolean)false));
                    continue;
                }
                fail = new StringBuilder(40).append("Expected boolean path segment but found ").append(segment).toString();
                i = instructions.length;
                continue;
            }
            if (PathCodec$Opt$TrailingOpt$.MODULE$.equals(opt)) {
                if (j >= segments.length()) {
                    Path result = path.hasTrailingSlash() ? Path$.MODULE$.root() : Path$.MODULE$.empty();
                    stack.push(result);
                    continue;
                }
                int flags = j == 0 ? path.flags() : (path.hasTrailingSlash() ? Path$Flags$.MODULE$.apply(Path$Flag$TrailingSlash$.MODULE$, (Seq<Path.Flag>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path.Flag[0])) : 0);
                stack.push(Path$.MODULE$.apply(flags, (Chunk<String>)segments.drop(j)));
                j = segments.length();
                continue;
            }
            if (PathCodec$Opt$Unit$.MODULE$.equals(opt)) {
                stack.push(BoxedUnit.UNIT);
                continue;
            }
            if (opt instanceof Opt.MapOrFail) {
                Opt.MapOrFail mapOrFail = PathCodec$Opt$MapOrFail$.MODULE$.unapply((Opt.MapOrFail)opt);
                Function1<Object, Either<String, Object>> function1 = mapOrFail._1();
                Function1<Object, Either<String, Object>> f = function1;
                Either either = (Either)f.apply(stack.pop());
                if (either instanceof Left) {
                    String failure;
                    fail = failure = (String)((Left)either).value();
                    i = instructions.length;
                    continue;
                }
                if (either instanceof Right) {
                    Object value = ((Right)either).value();
                    stack.push(value);
                    continue;
                }
                throw new MatchError((Object)either);
            }
            throw new MatchError((Object)opt);
        }
        String string = fail;
        String string6 = "";
        if (string == null ? string6 != null : !string.equals(string6)) {
            return package$.MODULE$.Left().apply((Object)fail);
        }
        if (j < segments.length()) {
            String rest = segments.drop(j).mkString("/");
            return package$.MODULE$.Left().apply((Object)new StringBuilder(32).append("Expected end of path but found: ").append(rest).toString());
        }
        return package$.MODULE$.Right().apply(stack.pop());
    }

    public static Doc doc$(PathCodec $this) {
        return $this.doc();
    }

    default public Doc doc() {
        PathCodec pathCodec = this;
        if (pathCodec instanceof Segment) {
            Segment segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
            SegmentCodec segmentCodec = segment._1();
            return Doc$.MODULE$.empty();
        }
        if (pathCodec instanceof TransformOrFail) {
            TransformOrFail transformOrFail = PathCodec$TransformOrFail$.MODULE$.unapply((TransformOrFail)pathCodec);
            PathCodec pathCodec2 = transformOrFail._1();
            Function1 function1 = transformOrFail._2();
            Function1 function12 = transformOrFail._3();
            PathCodec api = pathCodec2;
            return api.doc();
        }
        if (pathCodec instanceof Concat) {
            Concat concat = PathCodec$Concat$.MODULE$.unapply((Concat)pathCodec);
            PathCodec pathCodec3 = concat._1();
            PathCodec pathCodec4 = concat._2();
            Combiner combiner = concat._3();
            PathCodec left = pathCodec3;
            PathCodec right = pathCodec4;
            return left.doc().$plus(right.doc());
        }
        if (pathCodec instanceof Annotated) {
            Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
            PathCodec pathCodec5 = annotated._1();
            Chunk chunk = annotated._2();
            PathCodec codec = pathCodec5;
            Chunk annotations = chunk;
            return codec.doc().$plus((Doc)annotations.collectFirst((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(MetaData x) {
                    MetaData metaData = x;
                    if (metaData instanceof MetaData.Documented) {
                        Doc doc;
                        MetaData.Documented<A> documented = PathCodec$MetaData$Documented$.MODULE$.unapply((MetaData.Documented)metaData);
                        Doc doc2 = doc = documented._1();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(MetaData x, Function1 function1) {
                    MetaData metaData = x;
                    if (metaData instanceof MetaData.Documented) {
                        Doc doc;
                        MetaData.Documented<A> documented = PathCodec$MetaData$Documented$.MODULE$.unapply((MetaData.Documented)metaData);
                        Doc doc2 = doc = documented._1();
                        return doc2;
                    }
                    return function1.apply((Object)x);
                }
            }).getOrElse(PathCodec::doc$$anonfun$1));
        }
        if (pathCodec instanceof Fallback) {
            Fallback fallback = PathCodec$Fallback$.MODULE$.unapply((Fallback)pathCodec);
            PathCodec<BoxedUnit> pathCodec6 = fallback._1();
            PathCodec<BoxedUnit> pathCodec7 = fallback._2();
            PathCodec<BoxedUnit> left = pathCodec6;
            PathCodec<BoxedUnit> right = pathCodec7;
            return left.doc().$plus(right.doc());
        }
        throw new MatchError((Object)pathCodec);
    }

    public static Either encode$(PathCodec $this, Object value) {
        return $this.encode(value);
    }

    default public Either<String, Path> encode(A value) {
        return this.format(value);
    }

    public static PathCodec erase$(PathCodec $this) {
        return $this.erase();
    }

    default public PathCodec<Object> erase() {
        return this;
    }

    public static PathCodec example$(PathCodec $this, String name, Object example) {
        return $this.example(name, example);
    }

    default public PathCodec<A> example(String name, A example) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, example);
        return this.annotate(PathCodec$MetaData$Examples$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    public static PathCodec examples$(PathCodec $this, Seq examples) {
        return $this.examples(examples);
    }

    default public PathCodec<A> examples(Seq<Tuple2<String, A>> examples) {
        return this.annotate(PathCodec$MetaData$Examples$.MODULE$.apply(examples.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public static Either format$(PathCodec $this, Object value) {
        return $this.format(value);
    }

    default public Either<String, Path> format(A value) {
        return PathCodec.loop$3(this, value).map((Function1 & Serializable)path -> {
            if (path.nonEmpty()) {
                return path.addLeadingSlash();
            }
            return path;
        });
    }

    public static boolean matches$(PathCodec $this, Path path) {
        return $this.matches(path);
    }

    default public boolean matches(Path path) {
        return this.decode(path).isRight();
    }

    public Opt[] zio$http$codec$PathCodec$$_optimize();

    public void zio$http$codec$PathCodec$$_optimize_$eq(Opt[] var1);

    public static Opt[] optimize$(PathCodec $this) {
        return $this.optimize();
    }

    default public Opt[] optimize() {
        if (this.zio$http$codec$PathCodec$$_optimize() == null) {
            this.zio$http$codec$PathCodec$$_optimize_$eq((Opt[])this.loop$4(this).toArray(ClassTag$.MODULE$.apply(Opt.class)));
        }
        return this.zio$http$codec$PathCodec$$_optimize();
    }

    private Set<String> fallbacks(Fallback<?> f) {
        return PathCodec.loop$5((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathCodec[]{f.left(), f.right()})), Predef$.MODULE$.Set().empty());
    }

    public static String render$(PathCodec $this) {
        return $this.render();
    }

    default public String render() {
        return this.render("{", "}");
    }

    public static String render$(PathCodec $this, String prefix, String suffix) {
        return $this.render(prefix, suffix);
    }

    default public String render(String prefix, String suffix) {
        return PathCodec.loop$6(prefix, suffix, this);
    }

    public static String renderIgnoreTrailing$(PathCodec $this) {
        return $this.renderIgnoreTrailing();
    }

    default public String renderIgnoreTrailing() {
        return this.renderIgnoreTrailing("{", "}");
    }

    public static String renderIgnoreTrailing$(PathCodec $this, String prefix, String suffix) {
        return $this.renderIgnoreTrailing(prefix, suffix);
    }

    default public String renderIgnoreTrailing(String prefix, String suffix) {
        return PathCodec.loop$7(prefix, suffix, this);
    }

    public static Chunk segments$(PathCodec $this) {
        return $this.segments();
    }

    default public Chunk<SegmentCodec<?>> segments() {
        return PathCodec.loop$8(this);
    }

    public static String toString$(PathCodec $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.render();
    }

    public static PathCodec transform$(PathCodec $this, Function1 f, Function1 g) {
        return $this.transform(f, g);
    }

    default public <A2> PathCodec<A2> transform(Function1<A, A2> f, Function1<A2, A> g) {
        return PathCodec$TransformOrFail$.MODULE$.apply(this, (Function1 & Serializable)in -> package$.MODULE$.Right().apply(f.apply(in)), (Function1 & Serializable)output -> package$.MODULE$.Right().apply(g.apply(output)));
    }

    public static PathCodec transformOrFail$(PathCodec $this, Function1 f, Function1 g) {
        return $this.transformOrFail(f, g);
    }

    default public <A2> PathCodec<A2> transformOrFail(Function1<A, Either<String, A2>> f, Function1<A2, Either<String, A>> g) {
        return PathCodec$TransformOrFail$.MODULE$.apply(this, f, g);
    }

    public static PathCodec transformOrFailLeft$(PathCodec $this, Function1 f, Function1 g) {
        return $this.transformOrFailLeft(f, g);
    }

    default public <A2> PathCodec<A2> transformOrFailLeft(Function1<A, Either<String, A2>> f, Function1<A2, A> g) {
        return PathCodec$TransformOrFail$.MODULE$.apply(this, f, (Function1 & Serializable)output -> package$.MODULE$.Right().apply(g.apply(output)));
    }

    public static PathCodec transformOrFailRight$(PathCodec $this, Function1 f, Function1 g) {
        return $this.transformOrFailRight(f, g);
    }

    default public <A2> PathCodec<A2> transformOrFailRight(Function1<A, A2> f, Function1<A2, Either<String, A>> g) {
        return PathCodec$TransformOrFail$.MODULE$.apply(this, (Function1 & Serializable)in -> package$.MODULE$.Right().apply(f.apply(in)), g);
    }

    private static List loop$1(List codecs, List result) {
        PathCodec pathCodec;
        while (true) {
            if (codecs.isEmpty()) {
                return result;
            }
            pathCodec = (PathCodec)codecs.head();
            if (pathCodec instanceof Annotated) {
                Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
                PathCodec pathCodec2 = annotated._1();
                Chunk chunk = annotated._2();
                PathCodec codec = pathCodec2;
                codecs = ((List)codecs.tail()).$colon$colon(codec);
                continue;
            }
            if (pathCodec instanceof Segment) {
                Segment segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
                SegmentCodec segmentCodec = segment._1();
                if (segmentCodec instanceof SegmentCodec.Literal) {
                    SegmentCodec.Literal literal = SegmentCodec$Literal$.MODULE$.unapply((SegmentCodec.Literal)segmentCodec);
                    String string = literal._1();
                    List list = (List)codecs.tail();
                    List list2 = (List)result.$colon$plus(codecs.head());
                    codecs = list;
                    result = list2;
                    continue;
                }
                if (((Object)SegmentCodec$Empty$.MODULE$).equals(segmentCodec)) {
                    codecs = (List)codecs.tail();
                    continue;
                }
            }
            if (!(pathCodec instanceof Fallback)) break;
            Fallback fallback = PathCodec$Fallback$.MODULE$.unapply((Fallback)pathCodec);
            PathCodec<BoxedUnit> pathCodec3 = fallback._1();
            PathCodec<BoxedUnit> pathCodec4 = fallback._2();
            PathCodec<BoxedUnit> left = pathCodec3;
            PathCodec<BoxedUnit> right = pathCodec4;
            codecs = ((List)codecs.tail()).$colon$colon(right).$colon$colon(left);
        }
        PathCodec other = pathCodec;
        throw new IllegalStateException(new StringBuilder(63).append("Alternative path segments should only contain literals, found: ").append(other).toString());
    }

    private void loop$2(ObjectRef alts$1, PathCodec codec, Combiner combiner) {
        Segment segment;
        SegmentCodec segmentCodec;
        PathCodec pathCodec;
        while ((pathCodec = codec) instanceof Concat) {
            Concat concat = PathCodec$Concat$.MODULE$.unapply((Concat)pathCodec);
            PathCodec pathCodec2 = concat._1();
            PathCodec pathCodec3 = concat._2();
            Combiner combiner2 = concat._3();
            PathCodec left = pathCodec2;
            PathCodec right = pathCodec3;
            Combiner combiner3 = combiner2;
            this.loop$2(alts$1, left, combiner3);
            PathCodec pathCodec4 = right;
            Combiner combiner4 = combiner3;
            codec = pathCodec4;
            combiner = combiner4;
        }
        if (pathCodec instanceof Fallback) {
            Fallback f = (Fallback)pathCodec;
            if (((List)alts$1.elem).isEmpty()) {
                List list;
                alts$1.elem = list = this.fallbackAlternatives(f);
                list = null;
                return;
            }
            List list = (List)((List)alts$1.elem).$plus$plus((IterableOnce)((List)alts$1.elem).flatMap((Function1 & Serializable)alt -> this.fallbackAlternatives(f).map((Function1 & Serializable)fa -> PathCodec$Concat$.MODULE$.apply(alt, fa, combiner))));
            alts$1.elem = list;
            list = null;
            return;
        }
        if (pathCodec instanceof Segment && ((Object)SegmentCodec$Empty$.MODULE$).equals(segmentCodec = (segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec))._1())) {
            List list = (List)((List)alts$1.elem).$colon$plus((Object)codec);
            alts$1.elem = list;
            list = null;
            return;
        }
        PathCodec pc = pathCodec;
        if (((List)alts$1.elem).isEmpty()) {
            List list = (List)((List)alts$1.elem).$colon$plus((Object)pc);
            alts$1.elem = list;
            list = null;
            return;
        }
        List list = ((List)alts$1.elem).map((Function1 & Serializable)l -> PathCodec$Concat$.MODULE$.apply(l, pc, combiner));
        alts$1.elem = list;
        list = null;
    }

    private static Doc doc$$anonfun$1() {
        return Doc$.MODULE$.empty();
    }

    private static Either loop$3(PathCodec path, Object value) {
        PathCodec pathCodec;
        while (true) {
            if ((pathCodec = path) instanceof Annotated) {
                PathCodec codec;
                Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
                PathCodec pathCodec2 = annotated._1();
                Chunk chunk = annotated._2();
                path = codec = pathCodec2;
                continue;
            }
            if (pathCodec instanceof Concat) {
                Concat concat = PathCodec$Concat$.MODULE$.unapply((Concat)pathCodec);
                PathCodec pathCodec3 = concat._1();
                PathCodec pathCodec4 = concat._2();
                Combiner combiner = concat._3();
                PathCodec left = pathCodec3;
                PathCodec right = pathCodec4;
                Combiner combiner2 = combiner;
                Tuple2 tuple2 = combiner2.separate(value);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object leftValue = tuple2._1();
                Object rightValue = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(leftValue, rightValue);
                Object leftValue2 = tuple22._1();
                Object rightValue2 = tuple22._2();
                return PathCodec.loop$3(left, leftValue2).flatMap((Function1 & Serializable)leftPath -> PathCodec.loop$3(right, rightValue2).map((Function1 & Serializable)rightPath -> leftPath.$plus$plus((Path)rightPath)));
            }
            if (pathCodec instanceof Segment) {
                SegmentCodec<Object> segmentCodec;
                Segment segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
                SegmentCodec<Object> segment2 = segmentCodec = segment._1();
                return package$.MODULE$.Right().apply((Object)segment2.format(value));
            }
            if (pathCodec instanceof TransformOrFail) {
                TransformOrFail transformOrFail = PathCodec$TransformOrFail$.MODULE$.unapply((TransformOrFail)pathCodec);
                PathCodec pathCodec5 = transformOrFail._1();
                Function1 function1 = transformOrFail._2();
                Function1 function12 = transformOrFail._3();
                PathCodec api = pathCodec5;
                Function1 g = function12;
                return ((Either)g.apply(value)).flatMap((Function1 & Serializable)_$1 -> PathCodec.loop$3(api, _$1));
            }
            if (!(pathCodec instanceof Fallback)) break;
            Fallback fallback = PathCodec$Fallback$.MODULE$.unapply((Fallback)pathCodec);
            PathCodec<BoxedUnit> pathCodec6 = fallback._1();
            PathCodec<BoxedUnit> pathCodec7 = fallback._2();
            PathCodec<BoxedUnit> left = pathCodec6;
            path = left;
        }
        throw new MatchError(pathCodec);
    }

    private Chunk loop$4(PathCodec pattern) {
        PathCodec pathCodec;
        while ((pathCodec = pattern) instanceof Annotated) {
            PathCodec codec;
            Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
            PathCodec pathCodec2 = annotated._1();
            Chunk chunk = annotated._2();
            pattern = codec = pathCodec2;
        }
        if (pathCodec instanceof Segment) {
            Product product;
            SegmentCodec segmentCodec;
            Segment segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
            SegmentCodec segment2 = segmentCodec = segment._1();
            Object[] objectArray = new Opt[1];
            SegmentCodec segmentCodec2 = segment2;
            if (((Object)SegmentCodec$Empty$.MODULE$).equals(segmentCodec2)) {
                product = PathCodec$Opt$Unit$.MODULE$;
            } else if (segmentCodec2 instanceof SegmentCodec.Literal) {
                String string;
                SegmentCodec.Literal literal = SegmentCodec$Literal$.MODULE$.unapply((SegmentCodec.Literal)segmentCodec2);
                String value = string = literal._1();
                product = PathCodec$Opt$Match$.MODULE$.apply(value);
            } else if (segmentCodec2 instanceof SegmentCodec.IntSeg) {
                SegmentCodec.IntSeg intSeg = SegmentCodec$IntSeg$.MODULE$.unapply((SegmentCodec.IntSeg)segmentCodec2);
                String string = intSeg._1();
                product = PathCodec$Opt$IntOpt$.MODULE$;
            } else if (segmentCodec2 instanceof SegmentCodec.LongSeg) {
                SegmentCodec.LongSeg longSeg = SegmentCodec$LongSeg$.MODULE$.unapply((SegmentCodec.LongSeg)segmentCodec2);
                String string = longSeg._1();
                product = PathCodec$Opt$LongOpt$.MODULE$;
            } else if (segmentCodec2 instanceof SegmentCodec.Text) {
                SegmentCodec.Text text = SegmentCodec$Text$.MODULE$.unapply((SegmentCodec.Text)segmentCodec2);
                String string = text._1();
                product = PathCodec$Opt$StringOpt$.MODULE$;
            } else if (segmentCodec2 instanceof SegmentCodec.UUID) {
                SegmentCodec.UUID uUID = SegmentCodec$UUID$.MODULE$.unapply((SegmentCodec.UUID)segmentCodec2);
                String string = uUID._1();
                product = PathCodec$Opt$UUIDOpt$.MODULE$;
            } else if (segmentCodec2 instanceof SegmentCodec.BoolSeg) {
                SegmentCodec.BoolSeg boolSeg = SegmentCodec$BoolSeg$.MODULE$.unapply((SegmentCodec.BoolSeg)segmentCodec2);
                String string = boolSeg._1();
                product = PathCodec$Opt$BoolOpt$.MODULE$;
            } else if (((Object)SegmentCodec$Trailing$.MODULE$).equals(segmentCodec2)) {
                product = PathCodec$Opt$TrailingOpt$.MODULE$;
            } else {
                throw new MatchError(segmentCodec2);
            }
            objectArray[0] = product;
            return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (pathCodec instanceof Fallback) {
            Fallback f = (Fallback)pathCodec;
            return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opt.MatchAny[]{PathCodec$Opt$MatchAny$.MODULE$.apply(this.fallbacks(f))}));
        }
        if (pathCodec instanceof Concat) {
            Concat concat = PathCodec$Concat$.MODULE$.unapply((Concat)pathCodec);
            PathCodec pathCodec3 = concat._1();
            PathCodec pathCodec4 = concat._2();
            Combiner combiner = concat._3();
            PathCodec left = pathCodec3;
            PathCodec right = pathCodec4;
            Combiner combiner2 = combiner;
            return this.loop$4(left).$plus$plus(this.loop$4(right)).$plus$plus(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Opt.Combine[]{PathCodec$Opt$Combine$.MODULE$.apply(combiner2)})));
        }
        if (pathCodec instanceof TransformOrFail) {
            TransformOrFail transformOrFail = PathCodec$TransformOrFail$.MODULE$.unapply((TransformOrFail)pathCodec);
            PathCodec pathCodec5 = transformOrFail._1();
            Function1 function1 = transformOrFail._2();
            Function1 function12 = transformOrFail._3();
            PathCodec api = pathCodec5;
            Function1 f = function1;
            return (Chunk)this.loop$4(api).$colon$plus((Object)PathCodec$Opt$MapOrFail$.MODULE$.apply(f));
        }
        throw new MatchError(pathCodec);
    }

    private static Set loop$5(List codecs, Set result) {
        PathCodec pathCodec;
        while (true) {
            if (codecs.isEmpty()) {
                return result;
            }
            pathCodec = (PathCodec)codecs.head();
            if (pathCodec instanceof Annotated) {
                Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
                PathCodec pathCodec2 = annotated._1();
                Chunk chunk = annotated._2();
                PathCodec codec = pathCodec2;
                codecs = ((List)codecs.tail()).$colon$colon(codec);
                continue;
            }
            if (pathCodec instanceof Segment) {
                Segment segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
                SegmentCodec segmentCodec = segment._1();
                if (segmentCodec instanceof SegmentCodec.Literal) {
                    String string;
                    SegmentCodec.Literal literal = SegmentCodec$Literal$.MODULE$.unapply((SegmentCodec.Literal)segmentCodec);
                    String value = string = literal._1();
                    List list = (List)codecs.tail();
                    Set set = (Set)result.$plus((Object)value);
                    codecs = list;
                    result = set;
                    continue;
                }
                if (((Object)SegmentCodec$Empty$.MODULE$).equals(segmentCodec)) {
                    codecs = (List)codecs.tail();
                    continue;
                }
            }
            if (!(pathCodec instanceof Fallback)) break;
            Fallback fallback = PathCodec$Fallback$.MODULE$.unapply((Fallback)pathCodec);
            PathCodec<BoxedUnit> pathCodec3 = fallback._1();
            PathCodec<BoxedUnit> pathCodec4 = fallback._2();
            PathCodec<BoxedUnit> left = pathCodec3;
            PathCodec<BoxedUnit> right = pathCodec4;
            codecs = ((List)codecs.tail()).$colon$colon(right).$colon$colon(left);
        }
        PathCodec other = pathCodec;
        throw new IllegalStateException(new StringBuilder(63).append("Alternative path segments should only contain literals, found: ").append(other).toString());
    }

    private static String loop$6(String prefix$1, String suffix$1, PathCodec path) {
        PathCodec pathCodec;
        while (true) {
            if ((pathCodec = path) instanceof Annotated) {
                PathCodec codec;
                Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
                PathCodec pathCodec2 = annotated._1();
                Chunk chunk = annotated._2();
                path = codec = pathCodec2;
                continue;
            }
            if (pathCodec instanceof Concat) {
                Concat concat = PathCodec$Concat$.MODULE$.unapply((Concat)pathCodec);
                PathCodec pathCodec3 = concat._1();
                PathCodec pathCodec4 = concat._2();
                Combiner combiner = concat._3();
                PathCodec left = pathCodec3;
                PathCodec right = pathCodec4;
                return new StringBuilder(0).append(PathCodec.loop$6(prefix$1, suffix$1, left)).append(PathCodec.loop$6(prefix$1, suffix$1, right)).toString();
            }
            if (pathCodec instanceof Segment) {
                SegmentCodec segmentCodec;
                Segment segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
                SegmentCodec segment2 = segmentCodec = segment._1();
                return segment2.render(prefix$1, suffix$1);
            }
            if (pathCodec instanceof TransformOrFail) {
                TransformOrFail transformOrFail = PathCodec$TransformOrFail$.MODULE$.unapply((TransformOrFail)pathCodec);
                PathCodec pathCodec5 = transformOrFail._1();
                Function1 function1 = transformOrFail._2();
                Function1 function12 = transformOrFail._3();
                PathCodec api = pathCodec5;
                path = api;
                continue;
            }
            if (!(pathCodec instanceof Fallback)) break;
            Fallback fallback = PathCodec$Fallback$.MODULE$.unapply((Fallback)pathCodec);
            PathCodec<BoxedUnit> pathCodec6 = fallback._1();
            PathCodec<BoxedUnit> pathCodec7 = fallback._2();
            PathCodec<BoxedUnit> left = pathCodec6;
            path = left;
        }
        throw new MatchError(pathCodec);
    }

    private static String loop$7(String prefix$2, String suffix$2, PathCodec path) {
        PathCodec pathCodec;
        while (true) {
            Segment segment;
            SegmentCodec segmentCodec;
            if ((pathCodec = path) instanceof Annotated) {
                PathCodec codec;
                Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
                PathCodec pathCodec2 = annotated._1();
                Chunk chunk = annotated._2();
                path = codec = pathCodec2;
                continue;
            }
            if (pathCodec instanceof Concat) {
                Concat concat = PathCodec$Concat$.MODULE$.unapply((Concat)pathCodec);
                PathCodec pathCodec3 = concat._1();
                PathCodec pathCodec4 = concat._2();
                Combiner combiner = concat._3();
                PathCodec left = pathCodec3;
                PathCodec right = pathCodec4;
                return new StringBuilder(0).append(PathCodec.loop$7(prefix$2, suffix$2, left)).append(PathCodec.loop$7(prefix$2, suffix$2, right)).toString();
            }
            if (pathCodec instanceof Segment && ((Object)SegmentCodec$Trailing$.MODULE$).equals(segmentCodec = (segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec))._1())) {
                return "";
            }
            if (pathCodec instanceof Segment) {
                SegmentCodec segmentCodec2;
                Segment segment2 = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
                SegmentCodec segment3 = segmentCodec2 = segment2._1();
                return segment3.render(prefix$2, suffix$2);
            }
            if (pathCodec instanceof TransformOrFail) {
                TransformOrFail transformOrFail = PathCodec$TransformOrFail$.MODULE$.unapply((TransformOrFail)pathCodec);
                PathCodec pathCodec5 = transformOrFail._1();
                Function1 function1 = transformOrFail._2();
                Function1 function12 = transformOrFail._3();
                PathCodec api = pathCodec5;
                path = api;
                continue;
            }
            if (!(pathCodec instanceof Fallback)) break;
            Fallback fallback = PathCodec$Fallback$.MODULE$.unapply((Fallback)pathCodec);
            PathCodec<BoxedUnit> pathCodec6 = fallback._1();
            PathCodec<BoxedUnit> pathCodec7 = fallback._2();
            PathCodec<BoxedUnit> left = pathCodec6;
            path = left;
        }
        throw new MatchError(pathCodec);
    }

    private static Chunk loop$8(PathCodec path) {
        PathCodec pathCodec;
        while (true) {
            if ((pathCodec = path) instanceof Annotated) {
                PathCodec codec;
                Annotated annotated = PathCodec$Annotated$.MODULE$.unapply((Annotated)pathCodec);
                PathCodec pathCodec2 = annotated._1();
                Chunk chunk = annotated._2();
                path = codec = pathCodec2;
                continue;
            }
            if (pathCodec instanceof Segment) {
                SegmentCodec segmentCodec;
                Segment segment = PathCodec$Segment$.MODULE$.unapply((Segment)pathCodec);
                SegmentCodec segment2 = segmentCodec = segment._1();
                return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SegmentCodec[]{segment2}));
            }
            if (pathCodec instanceof Concat) {
                Concat concat = PathCodec$Concat$.MODULE$.unapply((Concat)pathCodec);
                PathCodec pathCodec3 = concat._1();
                PathCodec pathCodec4 = concat._2();
                Combiner combiner = concat._3();
                PathCodec left = pathCodec3;
                PathCodec right = pathCodec4;
                return PathCodec.loop$8(left).$plus$plus(PathCodec.loop$8(right));
            }
            if (pathCodec instanceof TransformOrFail) {
                TransformOrFail transformOrFail = PathCodec$TransformOrFail$.MODULE$.unapply((TransformOrFail)pathCodec);
                PathCodec pathCodec5 = transformOrFail._1();
                Function1 function1 = transformOrFail._2();
                Function1 function12 = transformOrFail._3();
                PathCodec api = pathCodec5;
                path = api;
                continue;
            }
            if (!(pathCodec instanceof Fallback)) break;
            Fallback fallback = PathCodec$Fallback$.MODULE$.unapply((Fallback)pathCodec);
            PathCodec<BoxedUnit> pathCodec6 = fallback._1();
            PathCodec<BoxedUnit> pathCodec7 = fallback._2();
            PathCodec<BoxedUnit> left = pathCodec6;
            path = left;
        }
        throw new MatchError(pathCodec);
    }

    public static final class Annotated<A>
    implements PathCodec<A>,
    Product,
    Serializable {
        private Opt[] zio$http$codec$PathCodec$$_optimize;
        private final PathCodec codec;
        private final Chunk annotations;

        public static <A> Annotated<A> apply(PathCodec<A> pathCodec, Chunk<MetaData<A>> chunk) {
            return PathCodec$Annotated$.MODULE$.apply(pathCodec, chunk);
        }

        public static Annotated<?> fromProduct(Product product) {
            return PathCodec$Annotated$.MODULE$.fromProduct(product);
        }

        public static <A> Annotated<A> unapply(Annotated<A> annotated) {
            return PathCodec$Annotated$.MODULE$.unapply(annotated);
        }

        public Annotated(PathCodec<A> codec, Chunk<MetaData<A>> annotations) {
            this.codec = codec;
            this.annotations = annotations;
            PathCodec.$init$(this);
        }

        @Override
        public Opt[] zio$http$codec$PathCodec$$_optimize() {
            return this.zio$http$codec$PathCodec$$_optimize;
        }

        @Override
        public void zio$http$codec$PathCodec$$_optimize_$eq(Opt[] x$1) {
            this.zio$http$codec$PathCodec$$_optimize = x$1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Annotated;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Annotated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "codec";
            }
            if (1 == n2) {
                return "annotations";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PathCodec<A> codec() {
            return this.codec;
        }

        public Chunk<MetaData<A>> annotations() {
            return this.annotations;
        }

        public boolean equals(Object that) {
            return this.codec().equals(that);
        }

        public <A> Annotated<A> copy(PathCodec<A> codec, Chunk<MetaData<A>> annotations) {
            return new Annotated<A>(codec, annotations);
        }

        public <A> PathCodec<A> copy$default$1() {
            return this.codec();
        }

        public <A> Chunk<MetaData<A>> copy$default$2() {
            return this.annotations();
        }

        public PathCodec<A> _1() {
            return this.codec();
        }

        public Chunk<MetaData<A>> _2() {
            return this.annotations();
        }
    }

    public static final class Concat<A, B, C>
    implements PathCodec<C>,
    Product,
    Serializable {
        private Opt[] zio$http$codec$PathCodec$$_optimize;
        private final PathCodec left;
        private final PathCodec right;
        private final Combiner combiner;

        public static <A, B, C> Concat<A, B, C> apply(PathCodec<A> pathCodec, PathCodec<B> pathCodec2, Combiner combiner) {
            return PathCodec$Concat$.MODULE$.apply(pathCodec, pathCodec2, combiner);
        }

        public static Concat<?, ?, ?> fromProduct(Product product) {
            return PathCodec$Concat$.MODULE$.fromProduct(product);
        }

        public static <A, B, C> Concat<A, B, C> unapply(Concat<A, B, C> concat) {
            return PathCodec$Concat$.MODULE$.unapply(concat);
        }

        public Concat(PathCodec<A> left, PathCodec<B> right, Combiner combiner) {
            this.left = left;
            this.right = right;
            this.combiner = combiner;
            PathCodec.$init$(this);
        }

        @Override
        public Opt[] zio$http$codec$PathCodec$$_optimize() {
            return this.zio$http$codec$PathCodec$$_optimize;
        }

        @Override
        public void zio$http$codec$PathCodec$$_optimize_$eq(Opt[] x$1) {
            this.zio$http$codec$PathCodec$$_optimize = x$1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Concat)) return false;
            Concat concat = (Concat)object;
            PathCodec<A> pathCodec = this.left();
            PathCodec<A> pathCodec2 = concat.left();
            if (pathCodec == null) {
                if (pathCodec2 != null) {
                    return false;
                }
            } else if (!pathCodec.equals(pathCodec2)) return false;
            PathCodec<B> pathCodec3 = this.right();
            PathCodec<B> pathCodec4 = concat.right();
            if (pathCodec3 == null) {
                if (pathCodec4 != null) {
                    return false;
                }
            } else if (!pathCodec3.equals(pathCodec4)) return false;
            Combiner combiner = this.combiner();
            Combiner combiner2 = concat.combiner();
            if (combiner == null) {
                if (combiner2 == null) return true;
                return false;
            } else {
                if (!combiner.equals(combiner2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Concat;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Concat";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "left";
                }
                case 1: {
                    return "right";
                }
                case 2: {
                    return "combiner";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PathCodec<A> left() {
            return this.left;
        }

        public PathCodec<B> right() {
            return this.right;
        }

        public Combiner combiner() {
            return this.combiner;
        }

        public <A, B, C> Concat<A, B, C> copy(PathCodec<A> left, PathCodec<B> right, Combiner combiner) {
            return new Concat<A, B, C>(left, right, combiner);
        }

        public <A, B, C> PathCodec<A> copy$default$1() {
            return this.left();
        }

        public <A, B, C> PathCodec<B> copy$default$2() {
            return this.right();
        }

        public <A, B, C> Combiner copy$default$3() {
            return this.combiner();
        }

        public PathCodec<A> _1() {
            return this.left();
        }

        public PathCodec<B> _2() {
            return this.right();
        }

        public Combiner _3() {
            return this.combiner();
        }
    }

    public static final class Fallback<A>
    implements PathCodec<A>,
    Product,
    Serializable {
        private Opt[] zio$http$codec$PathCodec$$_optimize;
        private final PathCodec left;
        private final PathCodec right;

        public static <A> Fallback<A> apply(PathCodec<BoxedUnit> pathCodec, PathCodec<BoxedUnit> pathCodec2) {
            return PathCodec$Fallback$.MODULE$.apply(pathCodec, pathCodec2);
        }

        public static Fallback<?> fromProduct(Product product) {
            return PathCodec$Fallback$.MODULE$.fromProduct(product);
        }

        public static <A> Fallback<A> unapply(Fallback<A> fallback) {
            return PathCodec$Fallback$.MODULE$.unapply(fallback);
        }

        public Fallback(PathCodec<BoxedUnit> left, PathCodec<BoxedUnit> right) {
            this.left = left;
            this.right = right;
            PathCodec.$init$(this);
        }

        @Override
        public Opt[] zio$http$codec$PathCodec$$_optimize() {
            return this.zio$http$codec$PathCodec$$_optimize;
        }

        @Override
        public void zio$http$codec$PathCodec$$_optimize_$eq(Opt[] x$1) {
            this.zio$http$codec$PathCodec$$_optimize = x$1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Fallback)) return false;
            Fallback fallback = (Fallback)object;
            PathCodec<BoxedUnit> pathCodec = this.left();
            PathCodec<BoxedUnit> pathCodec2 = fallback.left();
            if (pathCodec == null) {
                if (pathCodec2 != null) {
                    return false;
                }
            } else if (!pathCodec.equals(pathCodec2)) return false;
            PathCodec<BoxedUnit> pathCodec3 = this.right();
            PathCodec<BoxedUnit> pathCodec4 = fallback.right();
            if (pathCodec3 == null) {
                if (pathCodec4 == null) return true;
                return false;
            } else {
                if (!pathCodec3.equals(pathCodec4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Fallback;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Fallback";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "left";
            }
            if (1 == n2) {
                return "right";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PathCodec<BoxedUnit> left() {
            return this.left;
        }

        public PathCodec<BoxedUnit> right() {
            return this.right;
        }

        public <A> Fallback<A> copy(PathCodec<BoxedUnit> left, PathCodec<BoxedUnit> right) {
            return new Fallback<A>(left, right);
        }

        public <A> PathCodec<BoxedUnit> copy$default$1() {
            return this.left();
        }

        public <A> PathCodec<BoxedUnit> copy$default$2() {
            return this.right();
        }

        public PathCodec<BoxedUnit> _1() {
            return this.left();
        }

        public PathCodec<BoxedUnit> _2() {
            return this.right();
        }
    }

    public static interface MetaData<A>
    extends Product,
    Serializable {
        public static int ordinal(MetaData<?> metaData) {
            return PathCodec$MetaData$.MODULE$.ordinal(metaData);
        }
    }

    public static interface Opt {
        public static int ordinal(Opt opt) {
            return PathCodec$Opt$.MODULE$.ordinal(opt);
        }
    }

    public static final class Segment<A>
    implements PathCodec<A>,
    Product,
    Serializable {
        private Opt[] zio$http$codec$PathCodec$$_optimize;
        private final SegmentCodec segment;

        public static <A> Segment<A> apply(SegmentCodec<A> segmentCodec) {
            return PathCodec$Segment$.MODULE$.apply(segmentCodec);
        }

        public static Segment<?> fromProduct(Product product) {
            return PathCodec$Segment$.MODULE$.fromProduct(product);
        }

        public static <A> Segment<A> unapply(Segment<A> segment) {
            return PathCodec$Segment$.MODULE$.unapply(segment);
        }

        public Segment(SegmentCodec<A> segment) {
            this.segment = segment;
            PathCodec.$init$(this);
        }

        @Override
        public Opt[] zio$http$codec$PathCodec$$_optimize() {
            return this.zio$http$codec$PathCodec$$_optimize;
        }

        @Override
        public void zio$http$codec$PathCodec$$_optimize_$eq(Opt[] x$1) {
            this.zio$http$codec$PathCodec$$_optimize = x$1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Segment)) return false;
            Segment segment = (Segment)object;
            SegmentCodec<A> segmentCodec = this.segment();
            SegmentCodec<A> segmentCodec2 = segment.segment();
            if (segmentCodec != null) {
                if (!((Object)segmentCodec).equals(segmentCodec2)) return false;
                return true;
            }
            if (segmentCodec2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Segment;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Segment";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "segment";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SegmentCodec<A> segment() {
            return this.segment;
        }

        public <A> Segment<A> copy(SegmentCodec<A> segment) {
            return new Segment<A>(segment);
        }

        public <A> SegmentCodec<A> copy$default$1() {
            return this.segment();
        }

        public SegmentCodec<A> _1() {
            return this.segment();
        }
    }

    public static final class SegmentSubtree<A>
    implements Product,
    Serializable {
        private final ListMap literals;
        private final ListMap others;
        private final Chunk value;
        private Chunk<Tuple2<SegmentCodec<?>, SegmentSubtree<Object>>> _othersFlat;

        public static <A> SegmentSubtree<A> apply(ListMap<String, SegmentSubtree<A>> listMap, ListMap<SegmentCodec<?>, SegmentSubtree<A>> listMap2, Chunk<A> chunk) {
            return PathCodec$SegmentSubtree$.MODULE$.apply(listMap, listMap2, chunk);
        }

        public static SegmentSubtree<Nothing$> empty() {
            return PathCodec$SegmentSubtree$.MODULE$.empty();
        }

        public static SegmentSubtree<?> fromProduct(Product product) {
            return PathCodec$SegmentSubtree$.MODULE$.fromProduct(product);
        }

        public static <A> SegmentSubtree<A> single(Iterable<SegmentCodec<?>> iterable, A a) {
            return PathCodec$SegmentSubtree$.MODULE$.single(iterable, a);
        }

        public static <A> SegmentSubtree<A> unapply(SegmentSubtree<A> segmentSubtree) {
            return PathCodec$SegmentSubtree$.MODULE$.unapply(segmentSubtree);
        }

        public SegmentSubtree(ListMap<String, SegmentSubtree<A>> literals, ListMap<SegmentCodec<?>, SegmentSubtree<A>> others, Chunk<A> value) {
            this.literals = literals;
            this.others = others;
            this.value = value;
            this._othersFlat = null;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SegmentSubtree)) return false;
            SegmentSubtree segmentSubtree = (SegmentSubtree)object;
            ListMap<String, SegmentSubtree<A>> listMap = this.literals();
            ListMap<String, SegmentSubtree<A>> listMap2 = segmentSubtree.literals();
            if (listMap == null) {
                if (listMap2 != null) {
                    return false;
                }
            } else if (!listMap.equals(listMap2)) return false;
            ListMap<SegmentCodec<?>, SegmentSubtree<A>> listMap3 = this.others();
            ListMap<SegmentCodec<?>, SegmentSubtree<A>> listMap4 = segmentSubtree.others();
            if (listMap3 == null) {
                if (listMap4 != null) {
                    return false;
                }
            } else if (!listMap3.equals(listMap4)) return false;
            Chunk<A> chunk = this.value();
            Chunk<A> chunk2 = segmentSubtree.value();
            if (chunk == null) {
                if (chunk2 == null) return true;
                return false;
            } else {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SegmentSubtree;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SegmentSubtree";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "literals";
                }
                case 1: {
                    return "others";
                }
                case 2: {
                    return "value";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ListMap<String, SegmentSubtree<A>> literals() {
            return this.literals;
        }

        public ListMap<SegmentCodec<?>, SegmentSubtree<A>> others() {
            return this.others;
        }

        public Chunk<A> value() {
            return this.value;
        }

        public <A1> SegmentSubtree<A1> $plus$plus(SegmentSubtree<A1> that) {
            return PathCodec$SegmentSubtree$.MODULE$.apply(PathCodec$.MODULE$.zio$http$codec$PathCodec$$$mergeMaps(this.literals(), that.literals(), (Function2 & Serializable)(_$2, _$3) -> _$2.$plus$plus((SegmentSubtree)_$3)), PathCodec$.MODULE$.zio$http$codec$PathCodec$$$mergeMaps(this.others(), that.others(), (Function2 & Serializable)(_$4, _$5) -> _$4.$plus$plus((SegmentSubtree)_$5)), this.value().$plus$plus(that.value()));
        }

        public <A1> SegmentSubtree<A1> add(Iterable<SegmentCodec<?>> segments, A1 value) {
            return this.$plus$plus(PathCodec$SegmentSubtree$.MODULE$.single(segments, value));
        }

        public Chunk<A> get(Path path) {
            return this.get(path, 0);
        }

        private Chunk<A> get(Path path, int from) {
            Chunk<String> segments = path.segments();
            int nSegments = segments.length();
            SegmentSubtree subtree = this;
            Chunk<A> result = subtree.value();
            int i = from;
            while (i < nSegments) {
                String segment = (String)segments.apply(i);
                if (subtree.literals().contains((Object)segment)) {
                    subtree = (SegmentSubtree)subtree.literals().apply((Object)segment);
                    result = subtree.value();
                    ++i;
                    continue;
                }
                Chunk<Tuple2<SegmentCodec<?>, SegmentSubtree<A>>> flattened = subtree.othersFlat();
                subtree = null;
                int n = flattened.length();
                if (0 != n) {
                    if (1 == n) {
                        Tuple2 tuple2 = (Tuple2)flattened.apply(0);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        SegmentCodec codec = (SegmentCodec)tuple2._1();
                        SegmentSubtree subtree0 = (SegmentSubtree)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)codec, (Object)subtree0);
                        SegmentCodec codec2 = (SegmentCodec)tuple22._1();
                        SegmentSubtree subtree02 = (SegmentSubtree)tuple22._2();
                        int matched = codec2.matches(segments, i);
                        if (matched > 0) {
                            subtree = subtree02;
                            result = subtree02.value();
                            i += matched;
                        }
                    } else {
                        int index;
                        int n2 = n;
                        int[] matches = new int[n2];
                        int nPositive = 0;
                        int lastPositiveIdx = -1;
                        for (index = 0; index < n2; ++index) {
                            Tuple2 tuple2 = (Tuple2)flattened.apply(index);
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            SegmentCodec codec = (SegmentCodec)tuple2._1();
                            SegmentCodec codec3 = codec;
                            int n3 = codec3.matches(segments, i);
                            if (n3 <= 0) continue;
                            matches[index] = n3;
                            ++nPositive;
                            lastPositiveIdx = index;
                        }
                        int n4 = nPositive;
                        if (0 != n4) {
                            if (1 == n4) {
                                subtree = (SegmentSubtree)((Tuple2)flattened.apply(lastPositiveIdx))._2();
                                result = subtree.value();
                                i += matches[lastPositiveIdx];
                            } else {
                                for (index = 0; index < n2 && subtree == null; ++index) {
                                    int matched = matches[index];
                                    if (matched <= 0) continue;
                                    Tuple2 tuple2 = (Tuple2)flattened.apply(index);
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    SegmentSubtree subtree0 = (SegmentSubtree)tuple2._2();
                                    SegmentSubtree subtree03 = subtree0;
                                    if (!subtree03.get(path, i + matched).nonEmpty()) continue;
                                    subtree = subtree03;
                                    result = subtree.value();
                                    i += matched;
                                }
                            }
                        }
                    }
                }
                if (subtree != null) continue;
                result = Chunk$.MODULE$.empty();
                i = nSegments;
            }
            if (subtree != null) {
                Option option = subtree.others().get(SegmentCodec$.MODULE$.trailing());
                if (option instanceof Some) {
                    SegmentSubtree subtree2 = (SegmentSubtree)((Some)option).value();
                    result = result.$plus$plus(subtree2.value());
                } else if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
            }
            return result;
        }

        public <B> SegmentSubtree<B> map(Function1<A, B> f) {
            return PathCodec$SegmentSubtree$.MODULE$.apply((ListMap)this.literals().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    SegmentSubtree v = (SegmentSubtree)tuple2._2();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, v.map(f));
                }
                throw new MatchError((Object)tuple2);
            }), (ListMap)ListMap$.MODULE$.apply((Seq)this.others().toSeq().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    SegmentCodec k = (SegmentCodec)tuple2._1();
                    SegmentSubtree v = (SegmentSubtree)tuple2._2();
                    SegmentCodec segmentCodec = (SegmentCodec)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)segmentCodec, v.map(f));
                }
                throw new MatchError((Object)tuple2);
            })), this.value().map(f));
        }

        private Chunk<Tuple2<SegmentCodec<?>, SegmentSubtree<A>>> othersFlat() {
            if (this._othersFlat == null) {
                this._othersFlat = Chunk$.MODULE$.fromIterable(this.others());
            }
            return this._othersFlat;
        }

        public <A> SegmentSubtree<A> copy(ListMap<String, SegmentSubtree<A>> literals, ListMap<SegmentCodec<?>, SegmentSubtree<A>> others, Chunk<A> value) {
            return new SegmentSubtree<A>(literals, others, value);
        }

        public <A> ListMap<String, SegmentSubtree<A>> copy$default$1() {
            return this.literals();
        }

        public <A> ListMap<SegmentCodec<?>, SegmentSubtree<A>> copy$default$2() {
            return this.others();
        }

        public <A> Chunk<A> copy$default$3() {
            return this.value();
        }

        public ListMap<String, SegmentSubtree<A>> _1() {
            return this.literals();
        }

        public ListMap<SegmentCodec<?>, SegmentSubtree<A>> _2() {
            return this.others();
        }

        public Chunk<A> _3() {
            return this.value();
        }
    }

    public static final class TransformOrFail<X, A>
    implements PathCodec<A>,
    Product,
    Serializable {
        private Opt[] zio$http$codec$PathCodec$$_optimize;
        private final PathCodec api;
        private final Function1 f;
        private final Function1 g;

        public static <X, A> TransformOrFail<X, A> apply(PathCodec<X> pathCodec, Function1<X, Either<String, A>> function1, Function1<A, Either<String, X>> function12) {
            return PathCodec$TransformOrFail$.MODULE$.apply(pathCodec, function1, function12);
        }

        public static TransformOrFail<?, ?> fromProduct(Product product) {
            return PathCodec$TransformOrFail$.MODULE$.fromProduct(product);
        }

        public static <X, A> TransformOrFail<X, A> unapply(TransformOrFail<X, A> transformOrFail) {
            return PathCodec$TransformOrFail$.MODULE$.unapply(transformOrFail);
        }

        public TransformOrFail(PathCodec<X> api, Function1<X, Either<String, A>> f, Function1<A, Either<String, X>> g) {
            this.api = api;
            this.f = f;
            this.g = g;
            PathCodec.$init$(this);
        }

        @Override
        public Opt[] zio$http$codec$PathCodec$$_optimize() {
            return this.zio$http$codec$PathCodec$$_optimize;
        }

        @Override
        public void zio$http$codec$PathCodec$$_optimize_$eq(Opt[] x$1) {
            this.zio$http$codec$PathCodec$$_optimize = x$1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TransformOrFail)) return false;
            TransformOrFail transformOrFail = (TransformOrFail)object;
            PathCodec<X> pathCodec = this.api();
            PathCodec<X> pathCodec2 = transformOrFail.api();
            if (pathCodec == null) {
                if (pathCodec2 != null) {
                    return false;
                }
            } else if (!pathCodec.equals(pathCodec2)) return false;
            Function1<X, Either<String, A>> function1 = this.f();
            Function1<X, Either<String, A>> function12 = transformOrFail.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function1<A, Either<String, X>> function13 = this.g();
            Function1<A, Either<String, X>> function14 = transformOrFail.g();
            if (function13 == null) {
                if (function14 == null) return true;
                return false;
            } else {
                if (!function13.equals(function14)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof TransformOrFail;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "TransformOrFail";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "api";
                }
                case 1: {
                    return "f";
                }
                case 2: {
                    return "g";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PathCodec<X> api() {
            return this.api;
        }

        public Function1<X, Either<String, A>> f() {
            return this.f;
        }

        public Function1<A, Either<String, X>> g() {
            return this.g;
        }

        public <X, A> TransformOrFail<X, A> copy(PathCodec<X> api, Function1<X, Either<String, A>> f, Function1<A, Either<String, X>> g) {
            return new TransformOrFail<X, A>(api, f, g);
        }

        public <X, A> PathCodec<X> copy$default$1() {
            return this.api();
        }

        public <X, A> Function1<X, Either<String, A>> copy$default$2() {
            return this.f();
        }

        public <X, A> Function1<A, Either<String, X>> copy$default$3() {
            return this.g();
        }

        public PathCodec<X> _1() {
            return this.api();
        }

        public Function1<X, Either<String, A>> _2() {
            return this.f();
        }

        public Function1<A, Either<String, X>> _3() {
            return this.g();
        }
    }
}

