/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec.internal;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.Try$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.IsSubtypeOfError$;
import zio.Promise;
import zio.Promise$;
import zio.Trace$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Boundary;
import zio.http.Boundary$;
import zio.http.Charsets$;
import zio.http.Form;
import zio.http.Form$;
import zio.http.FormField;
import zio.http.FormField$;
import zio.http.FormField$Binary$;
import zio.http.FormField$Simple$;
import zio.http.FormField$StreamingBinary$;
import zio.http.FormField$Text$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Method;
import zio.http.Path;
import zio.http.Path$;
import zio.http.QueryParams;
import zio.http.QueryParams$;
import zio.http.ServerSentEvent$;
import zio.http.Status;
import zio.http.StreamingForm;
import zio.http.URL;
import zio.http.URL$;
import zio.http.codec.BinaryCodecWithSchema;
import zio.http.codec.HttpCodec;
import zio.http.codec.HttpCodecError;
import zio.http.codec.HttpCodecError$;
import zio.http.codec.HttpCodecError$CustomError$;
import zio.http.codec.HttpCodecError$MalformedBody$;
import zio.http.codec.HttpCodecError$MalformedHeader$;
import zio.http.codec.HttpCodecError$MalformedMethod$;
import zio.http.codec.HttpCodecError$MalformedPath$;
import zio.http.codec.HttpCodecError$MalformedStatus$;
import zio.http.codec.HttpCodecError$MissingHeader$;
import zio.http.codec.HttpCodecError$MissingQueryParam$;
import zio.http.codec.HttpCodecError$UnsupportedContentType$;
import zio.http.codec.HttpContentCodec;
import zio.http.codec.PathCodec;
import zio.http.codec.SimpleCodec;
import zio.http.codec.SimpleCodec$Specified$;
import zio.http.codec.internal.Atomized;
import zio.http.codec.internal.AtomizedCodecs;
import zio.http.codec.internal.AtomizedCodecs$;
import zio.http.codec.internal.BodyCodec;
import zio.http.codec.internal.BodyCodec$Empty$;
import zio.http.codec.internal.BodyCodec$Multiple$;
import zio.http.codec.internal.BodyCodec$Single$;
import zio.http.codec.internal.EncoderDecoder$;
import zio.http.codec.internal.EncoderDecoder$Multiple$;
import zio.http.codec.internal.EncoderDecoder$Single$;
import zio.http.codec.internal.EncoderDecoder$Undefined$;
import zio.http.codec.internal.Mechanic$;
import zio.schema.Schema;
import zio.schema.Schema$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public interface EncoderDecoder<AtomTypes, Value> {
    public static <AtomTypes, Value> EncoderDecoder<AtomTypes, Value> apply(HttpCodec<AtomTypes, Value> httpCodec) {
        return EncoderDecoder$.MODULE$.apply(httpCodec);
    }

    public ZIO<Object, Throwable, Value> decode(URL var1, Status var2, Method var3, Headers var4, Body var5, Object var6);

    public <Z> Z encodeWith(Value var1, Chunk<Header.Accept.MediaTypeWithQFactor> var2, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> var3);

    public static final class Multiple<AtomTypes, Value>
    implements EncoderDecoder<AtomTypes, Value>,
    Product,
    Serializable {
        private final Chunk httpCodecs;
        private final Chunk singles;

        public static <AtomTypes, Value> Multiple<AtomTypes, Value> apply(Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> chunk) {
            return EncoderDecoder$Multiple$.MODULE$.apply(chunk);
        }

        public static Multiple<?, ?> fromProduct(Product product) {
            return EncoderDecoder$Multiple$.MODULE$.fromProduct(product);
        }

        public static <AtomTypes, Value> Multiple<AtomTypes, Value> unapply(Multiple<AtomTypes, Value> multiple) {
            return EncoderDecoder$Multiple$.MODULE$.unapply(multiple);
        }

        public Multiple(Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> httpCodecs) {
            this.httpCodecs = httpCodecs;
            this.singles = httpCodecs.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    HttpCodec httpCodec = (HttpCodec)tuple2._1();
                    HttpCodec.Fallback.Condition condition = (HttpCodec.Fallback.Condition)tuple2._2();
                    Single single = (Single)Predef$.MODULE$.ArrowAssoc(EncoderDecoder$Single$.MODULE$.apply(httpCodec));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)single, (Object)condition);
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Multiple)) return false;
            Multiple multiple = (Multiple)object;
            Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> chunk = this.httpCodecs();
            Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> chunk2 = multiple.httpCodecs();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Multiple;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Multiple";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "httpCodecs";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> httpCodecs() {
            return this.httpCodecs;
        }

        public Chunk<Tuple2<Single<AtomTypes, Value>, HttpCodec.Fallback.Condition>> singles() {
            return this.singles;
        }

        @Override
        public ZIO<Object, Throwable, Value> decode(URL url, Status status, Method method, Headers headers, Body body, Object trace) {
            return this.tryDecode$1(trace, url, status, method, headers, body, 0, Cause$.MODULE$.empty());
        }

        @Override
        public <Z> Z encodeWith(Value value, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> f) {
            Z encoded = null;
            Throwable lastError = null;
            for (int i = 0; i < this.singles().length(); ++i) {
                Tuple2 tuple2 = (Tuple2)this.singles().apply(i);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Single current = (Single)tuple2._1();
                Single current2 = current;
                try {
                    encoded = current2.encodeWith(value, outputTypes, f);
                    i = this.singles().length();
                    continue;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof HttpCodecError) {
                        HttpCodecError error = (HttpCodecError)((Object)throwable2);
                        lastError = (Throwable)((Object)error);
                        continue;
                    }
                    throw throwable;
                }
            }
            if (encoded == null) {
                throw lastError;
            }
            return encoded;
        }

        public <AtomTypes, Value> Multiple<AtomTypes, Value> copy(Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> httpCodecs) {
            return new Multiple<AtomTypes, Value>(httpCodecs);
        }

        public <AtomTypes, Value> Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> copy$default$1() {
            return this.httpCodecs();
        }

        public Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> _1() {
            return this.httpCodecs();
        }

        private final ZIO tryDecode$1(Object trace$1, URL url$1, Status status$1, Method method$1, Headers headers$1, Body body$1, int i, Cause lastError) {
            Single codec;
            while (true) {
                if (i >= this.singles().length()) {
                    return ZIO$.MODULE$.refailCause(lastError, trace$1);
                }
                Tuple2 tuple2 = (Tuple2)this.singles().apply(i);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Single codec2 = (Single)tuple2._1();
                HttpCodec.Fallback.Condition condition = (HttpCodec.Fallback.Condition)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)codec2, (Object)condition);
                codec = (Single)tuple22._1();
                HttpCodec.Fallback.Condition condition2 = (HttpCodec.Fallback.Condition)tuple22._2();
                if (!condition2.isMissingDataOnly() || HttpCodecError$.MODULE$.isMissingDataOnly((Cause<Object>)lastError)) break;
                ++i;
            }
            return codec.decode(url$1, status$1, method$1, headers$1, body$1, trace$1).catchAllCause((Function1 & Serializable)cause -> {
                if (HttpCodecError$.MODULE$.isHttpCodecError((Cause<Object>)cause)) {
                    return this.tryDecode$1(trace$1, url$1, status$1, method$1, headers$1, body$1, i + 1, lastError.$amp$amp(cause));
                }
                return ZIO$.MODULE$.refailCause(cause, trace$1);
            }, trace$1);
        }
    }

    public static final class Single<AtomTypes, Value>
    implements EncoderDecoder<AtomTypes, Value>,
    Product,
    Serializable {
        private final HttpCodec httpCodec;
        private final Function1<Atomized<Object[]>, Value> constructor;
        private final Function1<Value, Atomized<Object[]>> deconstructor;
        private final AtomizedCodecs flattened;
        private final Chunk<Function2<String, Object, FormField>> formFieldEncoders;
        private final Object trace;
        private final Chunk<Function1<FormField, ZIO<Object, Throwable, Object>>> formFieldDecoders;
        private final Boundary formBoundary;
        private final Map<String, Object> indexByName;
        private final Map<Object, String> nameByIndex;
        private final boolean isByteStream;
        private final boolean isEventStream;
        private final boolean onlyTheLastFieldIsStreaming;

        public static <AtomTypes, Value> Single<AtomTypes, Value> apply(HttpCodec<AtomTypes, Value> httpCodec) {
            return EncoderDecoder$Single$.MODULE$.apply(httpCodec);
        }

        public static Single<?, ?> fromProduct(Product product) {
            return EncoderDecoder$Single$.MODULE$.fromProduct(product);
        }

        public static <AtomTypes, Value> Single<AtomTypes, Value> unapply(Single<AtomTypes, Value> single) {
            return EncoderDecoder$Single$.MODULE$.unapply(single);
        }

        public Single(HttpCodec<AtomTypes, Value> httpCodec) {
            this.httpCodec = httpCodec;
            this.constructor = Mechanic$.MODULE$.makeConstructor(httpCodec);
            this.deconstructor = Mechanic$.MODULE$.makeDeconstructor(httpCodec);
            this.flattened = AtomizedCodecs$.MODULE$.flatten(httpCodec);
            this.formFieldEncoders = this.flattened.content().map((Function1 & Serializable)bodyCodec -> (Function2 & Serializable)(name, value) -> {
                None$ none$;
                BodyCodec bodyCodec = bodyCodec;
                if (bodyCodec instanceof BodyCodec.Single) {
                    BodyCodec.Single single = BodyCodec$Single$.MODULE$.unapply((BodyCodec.Single)bodyCodec);
                    HttpContentCodec httpContentCodec = single._1();
                    Option<String> option = single._2();
                    HttpContentCodec codec = httpContentCodec;
                    none$ = codec.choices().headOption();
                } else if (bodyCodec instanceof BodyCodec.Multiple) {
                    BodyCodec.Multiple multiple = BodyCodec$Multiple$.MODULE$.unapply((BodyCodec.Multiple)bodyCodec);
                    HttpContentCodec httpContentCodec = multiple._1();
                    Option<String> option = multiple._2();
                    HttpContentCodec codec = httpContentCodec;
                    none$ = codec.choices().headOption();
                } else {
                    none$ = None$.MODULE$;
                }
                Tuple2 tuple2 = (Tuple2)none$.getOrElse(() -> this.$anonfun$1(name));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                MediaType mediaType = (MediaType)tuple2._1();
                BinaryCodecWithSchema codec = (BinaryCodecWithSchema)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)mediaType, (Object)codec);
                MediaType mediaType2 = (MediaType)tuple22._1();
                BinaryCodecWithSchema codec2 = (BinaryCodecWithSchema)tuple22._2();
                if (mediaType2.binary()) {
                    return FormField$.MODULE$.binaryField((String)name, (Chunk<Object>)((Chunk)codec2.codec().encode(value)), mediaType2, FormField$.MODULE$.binaryField$default$4(), FormField$.MODULE$.binaryField$default$5());
                }
                return FormField$.MODULE$.textField((String)name, ((Chunk)codec2.codec().encode(value)).asString(Chunk.IsText$.MODULE$.byteIsText()), mediaType2);
            });
            this.trace = Trace$.MODULE$.empty();
            this.formFieldDecoders = this.flattened.content().map((Function1 & Serializable)bodyCodec -> (Function1 & Serializable)field -> {
                Object object;
                MediaType mediaType = field.contentType();
                BodyCodec bodyCodec = bodyCodec;
                if (BodyCodec$Empty$.MODULE$.equals(bodyCodec)) {
                    object = None$.MODULE$;
                } else if (bodyCodec instanceof BodyCodec.Single) {
                    BodyCodec.Single single = BodyCodec$Single$.MODULE$.unapply((BodyCodec.Single)bodyCodec);
                    HttpContentCodec httpContentCodec = single._1();
                    Option<String> option = single._2();
                    HttpContentCodec codec = httpContentCodec;
                    object = codec.lookup(mediaType);
                } else if (bodyCodec instanceof BodyCodec.Multiple) {
                    BodyCodec.Multiple multiple = BodyCodec$Multiple$.MODULE$.unapply((BodyCodec.Multiple)bodyCodec);
                    HttpContentCodec httpContentCodec = multiple._1();
                    Option<String> option = multiple._2();
                    HttpContentCodec codec = httpContentCodec;
                    object = codec.lookup(mediaType);
                } else {
                    throw new MatchError((Object)bodyCodec);
                }
                BinaryCodecWithSchema codec = (BinaryCodecWithSchema)object.getOrElse(() -> this.$anonfun$2(mediaType));
                return field.asChunk(this.trace()).flatMap((Function1 & Serializable)chunk -> ZIO$.MODULE$.fromEither(() -> this.$init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(codec, chunk), this.trace()), this.trace());
            });
            this.formBoundary = Boundary$.MODULE$.apply("----zio-http-boundary-D4792A5C-93E0-43B5-9A1F-48E38FDE5714");
            this.indexByName = this.flattened.content().zipWithIndex().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    BodyCodec codec = (BodyCodec)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    String string = (String)Predef$.MODULE$.ArrowAssoc(codec.name().getOrElse(() -> this.$init$$$anonfun$4$$anonfun$1(idx)));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)idx));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.nameByIndex = (Map)this.indexByName.map((Function1 & Serializable)_$1 -> _$1.swap());
            this.isByteStream = this.flattened.content().length() == 1 ? this.isByteStreamBody((BodyCodec)this.flattened.content().apply(0)) : false;
            boolean bl = this.isEventStream = this.flattened.content().length() == 1 ? this.isEventStreamBody((BodyCodec)this.flattened.content().apply(0)) : false;
            this.onlyTheLastFieldIsStreaming = this.flattened.content().size() > 1 ? !((Chunk)this.flattened.content().init()).exists((Function1 & Serializable)codec -> this.isByteStreamBody((BodyCodec<?>)codec)) && this.isByteStreamBody((BodyCodec)this.flattened.content().last()) : false;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Single)) return false;
            Single single = (Single)object;
            HttpCodec<AtomTypes, Value> httpCodec = this.httpCodec();
            HttpCodec<AtomTypes, Value> httpCodec2 = single.httpCodec();
            if (httpCodec != null) {
                if (!httpCodec.equals(httpCodec2)) return false;
                return true;
            }
            if (httpCodec2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Single;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Single";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "httpCodec";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpCodec<AtomTypes, Value> httpCodec() {
            return this.httpCodec;
        }

        public Object trace() {
            return this.trace;
        }

        @Override
        public ZIO<Object, Throwable, Value> decode(URL url, Status status, Method method, Headers headers, Body body, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.decode$$anonfun$2(url, status, method, headers, body, trace), trace);
        }

        @Override
        public final <Z> Z encodeWith(Value value, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> f) {
            Atomized inputs = (Atomized)this.deconstructor.apply(value);
            Path path = this.encodePath((Object[])inputs.path());
            QueryParams query = this.encodeQuery((Object[])inputs.query());
            Option<Status> status = this.encodeStatus((Object[])inputs.status());
            Option<Method> method = this.encodeMethod((Object[])inputs.method());
            Headers headers = this.encodeHeaders((Object[])inputs.header());
            Body body = this.encodeBody((Object[])inputs.content(), outputTypes);
            Headers headers0 = headers.contains("content-type") ? headers : headers.$plus$plus(this.contentTypeHeaders$1(inputs, outputTypes));
            return (Z)f.apply((Object)URL$.MODULE$.apply(path, URL$.MODULE$.$lessinit$greater$default$2(), query, URL$.MODULE$.$lessinit$greater$default$4()), status, method, (Object)headers0, (Object)body);
        }

        private void decodePaths(Path path, Object[] inputs) {
            if (this.flattened.path().length() != inputs.length) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            for (int i = 0; i < inputs.length; ++i) {
                PathCodec<Object> pathCodec = ((PathCodec)this.flattened.path().apply(i)).erase();
                Either<String, Object> decoded = pathCodec.decode(path);
                Either<String, Object> either = decoded;
                if (either instanceof Left) {
                    String error = (String)((Left)either).value();
                    throw HttpCodecError$MalformedPath$.MODULE$.apply(path, pathCodec, error);
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Object value = ((Right)either).value();
                inputs[i] = value;
            }
        }

        private void decodeQuery(QueryParams queryParams, Object[] inputs) {
            Chunk<HttpCodec.Query<?>> queries = this.flattened.query();
            for (int i = 0; i < queries.length(); ++i) {
                HttpCodec.Query<Object> query = ((HttpCodec.Query)queries.apply(i)).erase();
                Chunk<String> params = queryParams.queryParamsOrElse(query.name(), (Function0<Iterable<String>>)((Function0 & Serializable)this::$anonfun$3));
                if (params.isEmpty()) {
                    throw HttpCodecError$MissingQueryParam$.MODULE$.apply(query.name());
                }
                Chunk parsedParams = params.collect(query.textCodec());
                inputs[i] = parsedParams;
            }
        }

        private void decodeStatus(Status status, Object[] inputs) {
            for (int i = 0; i < inputs.length; ++i) {
                Status status2;
                SimpleCodec simpleCodec = (SimpleCodec)this.flattened.status().apply(i);
                if (simpleCodec instanceof SimpleCodec.Unspecified) {
                    status2 = status;
                } else if (simpleCodec instanceof SimpleCodec.Specified) {
                    Status status3;
                    SimpleCodec.Specified specified = SimpleCodec$Specified$.MODULE$.unapply((SimpleCodec.Specified)simpleCodec);
                    Status expected = status3 = (Status)specified._1();
                    Status status4 = status;
                    Status status5 = expected;
                    if (status4 == null ? status5 != null : !status4.equals(status5)) {
                        throw HttpCodecError$MalformedStatus$.MODULE$.apply(expected, status);
                    }
                    status2 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)simpleCodec);
                }
                inputs[i] = status2;
            }
        }

        private void decodeMethod(Method method, Object[] inputs) {
            for (int i = 0; i < inputs.length; ++i) {
                Method method2;
                SimpleCodec simpleCodec = (SimpleCodec)this.flattened.method().apply(i);
                if (simpleCodec instanceof SimpleCodec.Unspecified) {
                    method2 = method;
                } else if (simpleCodec instanceof SimpleCodec.Specified) {
                    Method method3;
                    SimpleCodec.Specified specified = SimpleCodec$Specified$.MODULE$.unapply((SimpleCodec.Specified)simpleCodec);
                    Method expected = method3 = (Method)specified._1();
                    Method method4 = method;
                    Method method5 = expected;
                    if (method4 == null ? method5 != null : !method4.equals(method5)) {
                        throw HttpCodecError$MalformedMethod$.MODULE$.apply(expected, method);
                    }
                    method2 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)simpleCodec);
                }
                inputs[i] = method2;
            }
        }

        private void decodeHeaders(Headers headers, Object[] inputs) {
            for (int i = 0; i < this.flattened.header().length(); ++i) {
                HttpCodec.Header<Object> header = ((HttpCodec.Header)this.flattened.header().apply(i)).erase();
                Option<String> option = headers.get(header.name());
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw HttpCodecError$MissingHeader$.MODULE$.apply(header.name());
                    }
                    throw new MatchError(option);
                }
                String value = (String)((Some)option).value();
                inputs[i] = header.textCodec().decode(value).getOrElse(() -> this.decodeHeaders$$anonfun$1(header));
            }
        }

        private ZIO<Object, Throwable, BoxedUnit> decodeBody(Body body, Object[] inputs, Object trace) {
            if (this.isByteStream) {
                return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> {
                    inputs$2[0] = body.asStream(trace).orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
                }, trace);
            }
            if (this.flattened.content().isEmpty()) {
                return ZIO$.MODULE$.unit();
            }
            if (this.flattened.content().size() == 1) {
                BodyCodec bodyCodec = (BodyCodec)this.flattened.content().apply(0);
                return bodyCodec.decodeFromBody(body, trace).mapBoth((Function1 & Serializable)err -> HttpCodecError$MalformedBody$.MODULE$.apply(err.getMessage(), (Option<Throwable>)Some$.MODULE$.apply(err)), (Function1)(JProcedure1 & Serializable)result -> {
                    inputs$3[0] = result;
                }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
            }
            return body.asMultipartFormStream(trace).flatMap((Function1 & Serializable)form -> {
                if (this.onlyTheLastFieldIsStreaming) {
                    return this.processStreamingForm((StreamingForm)form, inputs, trace);
                }
                return this.collectAndProcessForm((StreamingForm)form, inputs, trace);
            }, trace).zipRight(() -> this.decodeBody$$anonfun$5(inputs, trace), trace);
        }

        private ZIO<Object, Throwable, BoxedUnit> processStreamingForm(StreamingForm form, Object[] inputs, Object trace) {
            return Promise$.MODULE$.make(trace).flatMap((Function1 & Serializable)ready -> form.fields(trace).mapZIO((Function1 & Serializable)field -> {
                ZIO zIO;
                Option option = this.indexByName.get((Object)field.name());
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    return ready.fail((Object)HttpCodecError$MalformedBody$.MODULE$.apply(new StringBuilder(38).append("Unexpected multipart/form-data field: ").append(field.name()).toString(), HttpCodecError$MalformedBody$.MODULE$.$lessinit$greater$default$2()), trace);
                }
                int idx = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                BodyCodec bodyCodec = (BodyCodec)this.flattened.content().apply(idx);
                if (bodyCodec instanceof BodyCodec.Multiple) {
                    BodyCodec.Multiple multiple = BodyCodec$Multiple$.MODULE$.unapply((BodyCodec.Multiple)bodyCodec);
                    HttpContentCodec httpContentCodec = multiple._1();
                    Option<String> option2 = multiple._2();
                    HttpContentCodec codec = httpContentCodec;
                    if (codec.defaultMediaType().binary()) {
                        FormField formField = field;
                        if (formField instanceof FormField.Binary) {
                            FormField.Binary binary = FormField$Binary$.MODULE$.unapply((FormField.Binary)formField);
                            String string = binary._1();
                            Chunk<Object> chunk = binary._2();
                            MediaType mediaType = binary._3();
                            Option<Header.ContentTransferEncoding> option3 = binary._4();
                            Option<String> option4 = binary._5();
                            Chunk<Object> data = chunk;
                            inputs$8[idx] = ZStream$.MODULE$.fromChunk(() -> this.processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$1(data), trace);
                        } else if (formField instanceof FormField.StreamingBinary) {
                            ZStream<Object, Nothing$, Object> zStream;
                            ZStream<Object, Nothing$, Object> data;
                            FormField.StreamingBinary streamingBinary = FormField$StreamingBinary$.MODULE$.unapply((FormField.StreamingBinary)formField);
                            String string = streamingBinary._1();
                            MediaType mediaType = streamingBinary._2();
                            Option<Header.ContentTransferEncoding> option5 = streamingBinary._3();
                            Option<String> option6 = streamingBinary._4();
                            inputs$8[idx] = data = (zStream = streamingBinary._5());
                        } else if (formField instanceof FormField.Text) {
                            FormField.Text text = FormField$Text$.MODULE$.unapply((FormField.Text)formField);
                            String string = text._1();
                            String string2 = text._2();
                            MediaType mediaType = text._3();
                            Option<String> option7 = text._4();
                            String value = string2;
                            inputs$8[idx] = ZStream$.MODULE$.fromChunk(() -> this.processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$2(value), trace);
                        } else {
                            String string;
                            if (!(formField instanceof FormField.Simple)) throw new MatchError((Object)formField);
                            FormField.Simple simple = FormField$Simple$.MODULE$.unapply((FormField.Simple)formField);
                            String string3 = simple._1();
                            String value = string = simple._2();
                            inputs$8[idx] = ZStream$.MODULE$.fromChunk(() -> this.processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$3(value), trace);
                        }
                        zIO = ZIO$.MODULE$.unit();
                        return zIO.zipRight(() -> this.processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$5(ready, trace, inputs), trace);
                    }
                }
                zIO = ((ZIO)((Function1)this.formFieldDecoders.apply(idx)).apply(field)).map((Function1)(JProcedure1 & Serializable)result -> {
                    inputs$9[idx$3] = result;
                }, trace);
                return zIO.zipRight(() -> this.processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$5(ready, trace, inputs), trace);
            }, trace).runDrain(trace).intoPromise(() -> this.processStreamingForm$$anonfun$1$$anonfun$2(ready), trace).forkDaemon(trace).zipRight(() -> this.processStreamingForm$$anonfun$1$$anonfun$3(ready, trace), trace), trace);
        }

        private ZIO<Object, Throwable, BoxedUnit> collectAndProcessForm(StreamingForm form, Object[] inputs, Object trace) {
            return form.collectAll(trace).flatMap((Function1 & Serializable)collectedForm -> ZIO$.MODULE$.foreachDiscard(() -> this.collectAndProcessForm$$anonfun$1$$anonfun$1(collectedForm), (Function1 & Serializable)field -> {
                Option option = this.indexByName.get((Object)field.name());
                if (option instanceof Some) {
                    int idx = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                    BodyCodec bodyCodec = (BodyCodec)this.flattened.content().apply(idx);
                    if (bodyCodec instanceof BodyCodec.Multiple) {
                        BodyCodec.Multiple multiple = BodyCodec$Multiple$.MODULE$.unapply((BodyCodec.Multiple)bodyCodec);
                        HttpContentCodec httpContentCodec = multiple._1();
                        Option<String> option2 = multiple._2();
                        HttpContentCodec codec = httpContentCodec;
                        if (codec.defaultMediaType().binary()) {
                            FormField formField = field;
                            if (formField instanceof FormField.Binary) {
                                FormField.Binary binary = FormField$Binary$.MODULE$.unapply((FormField.Binary)formField);
                                String string = binary._1();
                                Chunk<Object> chunk = binary._2();
                                MediaType mediaType = binary._3();
                                Option<Header.ContentTransferEncoding> option3 = binary._4();
                                Option<String> option4 = binary._5();
                                Chunk<Object> data = chunk;
                                inputs$13[idx] = ZStream$.MODULE$.fromChunk(() -> this.collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$1(data), trace);
                            } else if (formField instanceof FormField.StreamingBinary) {
                                ZStream<Object, Nothing$, Object> zStream;
                                ZStream<Object, Nothing$, Object> data;
                                FormField.StreamingBinary streamingBinary = FormField$StreamingBinary$.MODULE$.unapply((FormField.StreamingBinary)formField);
                                String string = streamingBinary._1();
                                MediaType mediaType = streamingBinary._2();
                                Option<Header.ContentTransferEncoding> option5 = streamingBinary._3();
                                Option<String> option6 = streamingBinary._4();
                                inputs$13[idx] = data = (zStream = streamingBinary._5());
                            } else if (formField instanceof FormField.Text) {
                                FormField.Text text = FormField$Text$.MODULE$.unapply((FormField.Text)formField);
                                String string = text._1();
                                String string2 = text._2();
                                MediaType mediaType = text._3();
                                Option<String> option7 = text._4();
                                String value = string2;
                                inputs$13[idx] = ZStream$.MODULE$.fromChunk(() -> this.collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$2(value), trace);
                            } else if (formField instanceof FormField.Simple) {
                                String string;
                                FormField.Simple simple = FormField$Simple$.MODULE$.unapply((FormField.Simple)formField);
                                String string3 = simple._1();
                                String value = string = simple._2();
                                inputs$13[idx] = ZStream$.MODULE$.fromChunk(() -> this.collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$3(value), trace);
                            } else {
                                throw new MatchError((Object)formField);
                            }
                            return ZIO$.MODULE$.unit();
                        }
                    }
                    return ((ZIO)((Function1)this.formFieldDecoders.apply(idx)).apply(field)).map((Function1)(JProcedure1 & Serializable)result -> {
                        inputs$14[idx$4] = result;
                    }, trace);
                }
                if (None$.MODULE$.equals(option)) {
                    return ZIO$.MODULE$.fail(() -> this.collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$5(field), trace);
                }
                throw new MatchError((Object)option);
            }, trace), trace);
        }

        private Path encodePath(Object[] inputs) {
            Path path = Path$.MODULE$.empty();
            for (int i = 0; i < inputs.length; ++i) {
                Object input;
                PathCodec<Object> pathCodec = ((PathCodec)this.flattened.path().apply(i)).erase();
                Either<String, Path> either = pathCodec.encode(input = inputs[i]);
                if (either instanceof Left) {
                    String error = (String)((Left)either).value();
                    throw HttpCodecError$MalformedPath$.MODULE$.apply(path, pathCodec, error);
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Path value = (Path)((Right)either).value();
                Path encoded = value;
                path = path.$plus$plus(encoded);
            }
            return path;
        }

        private QueryParams encodeQuery(Object[] inputs) {
            ObjectRef queryParams = ObjectRef.create((Object)QueryParams$.MODULE$.empty());
            for (int i = 0; i < inputs.length; ++i) {
                Object object;
                HttpCodec.Query<Object> query = ((HttpCodec.Query)this.flattened.query().apply(i)).erase();
                Object input = inputs[i];
                Chunk inputCoerced = (Chunk)input;
                if (inputCoerced.isEmpty()) {
                    object = ((QueryParams)queryParams.elem).addQueryParams(query.name(), (Chunk<String>)Chunk$.MODULE$.empty());
                    continue;
                }
                inputCoerced.foreach((Function1)(JProcedure1 & Serializable)in -> {
                    String value = query.textCodec().encode(in);
                    QueryParams queryParams = (QueryParams)((QueryParams)queryParams$1.elem).addQueryParam(query.name(), value);
                    queryParams$1.elem = queryParams;
                    queryParams = null;
                });
                object = BoxedUnit.UNIT;
            }
            return (QueryParams)queryParams.elem;
        }

        private Option<Status> encodeStatus(Object[] inputs) {
            if (this.flattened.status().length() == 0) {
                return None$.MODULE$;
            }
            SimpleCodec simpleCodec = (SimpleCodec)this.flattened.status().apply(0);
            if (simpleCodec instanceof SimpleCodec.Unspecified) {
                return Some$.MODULE$.apply((Object)((Status)inputs[0]));
            }
            if (simpleCodec instanceof SimpleCodec.Specified) {
                Status status;
                SimpleCodec.Specified specified = SimpleCodec$Specified$.MODULE$.unapply((SimpleCodec.Specified)simpleCodec);
                Status status2 = status = (Status)specified._1();
                return Some$.MODULE$.apply((Object)status2);
            }
            throw new MatchError((Object)simpleCodec);
        }

        private Headers encodeHeaders(Object[] inputs) {
            Headers headers = Headers$.MODULE$.empty();
            for (int i = 0; i < inputs.length; ++i) {
                HttpCodec.Header<Object> header = ((HttpCodec.Header)this.flattened.header().apply(i)).erase();
                Object input = inputs[i];
                String value = header.textCodec().encode(input);
                headers = headers.$plus$plus(Headers$.MODULE$.apply(header.name(), value));
            }
            return headers;
        }

        private Option<Method> encodeMethod(Object[] inputs) {
            if (this.flattened.method().nonEmpty()) {
                SimpleCodec simpleCodec = (SimpleCodec)this.flattened.method().head();
                if (simpleCodec instanceof SimpleCodec.Unspecified) {
                    return Some$.MODULE$.apply((Object)((Method)inputs[0]));
                }
                if (simpleCodec instanceof SimpleCodec.Specified) {
                    Method method;
                    SimpleCodec.Specified specified = SimpleCodec$Specified$.MODULE$.unapply((SimpleCodec.Specified)simpleCodec);
                    Method method2 = method = (Method)specified._1();
                    return Some$.MODULE$.apply((Object)method2);
                }
                throw new MatchError((Object)simpleCodec);
            }
            return None$.MODULE$;
        }

        private Body encodeBody(Object[] inputs, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes) {
            if (this.isByteStream) {
                return Body$.MODULE$.fromStreamChunked((ZStream<Object, Throwable, Object>)((ZStream)inputs[0]));
            }
            if (inputs.length > 1) {
                return Body$.MODULE$.fromMultipartForm(this.encodeMultipartFormData(inputs, outputTypes), this.formBoundary, this.trace());
            }
            if (this.isEventStream) {
                return Body$.MODULE$.fromCharSequenceStreamChunked((ZStream<Object, Throwable, CharSequence>)((ZStream)inputs[0]).map((Function1 & Serializable)_$3 -> _$3.encode(), this.trace()), Body$.MODULE$.fromCharSequenceStreamChunked$default$2(), this.trace());
            }
            if (inputs.length < 1) {
                return Body$.MODULE$.empty();
            }
            BodyCodec bodyCodec = (BodyCodec)this.flattened.content().apply(0);
            return bodyCodec.erase().encodeToBody(inputs[0], outputTypes, this.trace());
        }

        private Form encodeMultipartFormData(Object[] inputs, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes) {
            return Form$.MODULE$.apply((Seq<FormField>)this.flattened.content().zipWithIndex().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    BodyCodec bodyCodec = (BodyCodec)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Object input = inputs[idx];
                    String name = (String)this.nameByIndex.apply((Object)BoxesRunTime.boxToInteger((int)idx));
                    BodyCodec bodyCodec2 = bodyCodec;
                    if (bodyCodec2 instanceof BodyCodec.Multiple) {
                        BodyCodec.Multiple multiple = BodyCodec$Multiple$.MODULE$.unapply((BodyCodec.Multiple)bodyCodec2);
                        HttpContentCodec httpContentCodec = multiple._1();
                        Option<String> option = multiple._2();
                        HttpContentCodec codec = httpContentCodec;
                        if (codec.defaultMediaType().binary()) {
                            return FormField$.MODULE$.streamingBinaryField(name, (ZStream<Object, Nothing$, Object>)((ZStream)input), (MediaType)bodyCodec.mediaType(outputTypes).getOrElse(this::encodeMultipartFormData$$anonfun$1$$anonfun$1), FormField$.MODULE$.streamingBinaryField$default$4(), FormField$.MODULE$.streamingBinaryField$default$5());
                        }
                    }
                    return (FormField)((Function2)this.formFieldEncoders.apply(idx)).apply((Object)name, input);
                }
                throw new MatchError((Object)tuple2);
            }));
        }

        private Headers encodeContentType(Object[] inputs, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes) {
            if (this.isByteStream) {
                MediaType mediaType = (MediaType)((BodyCodec)this.flattened.content().apply(0)).mediaType(outputTypes).getOrElse(this::$anonfun$4);
                return Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(mediaType, Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())}));
            }
            if (inputs.length > 1) {
                return Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.multipart().form$minusdata(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())}));
            }
            if (this.isEventStream) {
                return Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.text().event$minusstream(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())}));
            }
            if (this.flattened.content().length() < 1) {
                return Headers$.MODULE$.empty();
            }
            MediaType mediaType = (MediaType)((BodyCodec)this.flattened.content().apply(0)).mediaType(outputTypes).getOrElse(this::$anonfun$5);
            return Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(mediaType, Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())}));
        }

        private boolean isByteStreamBody(BodyCodec<?> codec) {
            BodyCodec<?> bodyCodec = codec;
            if (bodyCodec instanceof BodyCodec.Multiple) {
                BodyCodec.Multiple multiple = BodyCodec$Multiple$.MODULE$.unapply((BodyCodec.Multiple)bodyCodec);
                HttpContentCodec httpContentCodec = multiple._1();
                Option<String> option = multiple._2();
                HttpContentCodec codec2 = httpContentCodec;
                if (codec2.defaultMediaType().binary()) {
                    return true;
                }
            }
            return false;
        }

        private boolean isEventStreamBody(BodyCodec<?> codec) {
            BodyCodec<?> bodyCodec = codec;
            if (bodyCodec instanceof BodyCodec.Multiple) {
                BodyCodec.Multiple multiple = BodyCodec$Multiple$.MODULE$.unapply((BodyCodec.Multiple)bodyCodec);
                HttpContentCodec httpContentCodec = multiple._1();
                Option<String> option = multiple._2();
                HttpContentCodec codec2 = httpContentCodec;
                if (codec2.lookup(MediaType$.MODULE$.text().event$minusstream()).exists((Function1 & Serializable)_$4 -> {
                    Schema schema = _$4.schema();
                    Schema schema2 = Schema$.MODULE$.apply(ServerSentEvent$.MODULE$.schema());
                    return !(schema != null ? !schema.equals(schema2) : schema2 != null);
                })) {
                    return true;
                }
            }
            return false;
        }

        public <AtomTypes, Value> Single<AtomTypes, Value> copy(HttpCodec<AtomTypes, Value> httpCodec) {
            return new Single<AtomTypes, Value>(httpCodec);
        }

        public <AtomTypes, Value> HttpCodec<AtomTypes, Value> copy$default$1() {
            return this.httpCodec();
        }

        public HttpCodec<AtomTypes, Value> _1() {
            return this.httpCodec();
        }

        private final Tuple2 $anonfun$1(String name$1) {
            throw HttpCodecError$CustomError$.MODULE$.apply("CodecNotFound", new StringBuilder(56).append("Cannot encode multipart/form-data field ").append(name$1).append(": no codec found").toString());
        }

        private final BinaryCodecWithSchema $anonfun$2(MediaType mediaType$1) {
            throw HttpCodecError$UnsupportedContentType$.MODULE$.apply(mediaType$1.fullType());
        }

        private final Either $init$$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1(BinaryCodecWithSchema codec$2, Chunk chunk$1) {
            return codec$2.codec().decode((Object)chunk$1);
        }

        private final String $init$$$anonfun$4$$anonfun$1(int idx$1) {
            return new StringBuilder(5).append("field").append(BoxesRunTime.boxToInteger((int)idx$1).toString()).toString();
        }

        private final Object decode$$anonfun$2$$anonfun$1(Atomized inputsBuilder$1) {
            return this.constructor.apply((Object)inputsBuilder$1);
        }

        private final ZIO decode$$anonfun$2(URL url$3, Status status$3, Method method$3, Headers headers$3, Body body$3, Object trace$3) {
            Atomized<Object[]> inputsBuilder = this.flattened.makeInputsBuilder();
            this.decodePaths(url$3.path(), inputsBuilder.path());
            this.decodeQuery(url$3.queryParams(), inputsBuilder.query());
            this.decodeStatus(status$3, inputsBuilder.status());
            this.decodeMethod(method$3, inputsBuilder.method());
            this.decodeHeaders(headers$3, inputsBuilder.header());
            return this.decodeBody(body$3, inputsBuilder.content(), trace$3).as(() -> this.decode$$anonfun$2$$anonfun$1(inputsBuilder), trace$3);
        }

        private final Headers contentTypeHeaders$1(Atomized inputs$1, Chunk outputTypes$1) {
            return this.encodeContentType((Object[])inputs$1.content(), (Chunk<Header.Accept.MediaTypeWithQFactor>)outputTypes$1);
        }

        private final Iterable $anonfun$3() {
            return package$.MODULE$.Nil();
        }

        private final Object decodeHeaders$$anonfun$1(HttpCodec.Header header$1) {
            throw HttpCodecError$MalformedHeader$.MODULE$.apply(header$1.name(), header$1.textCodec());
        }

        private final String decodeBody$$anonfun$5$$anonfun$1$$anonfun$1(IntRef idx$2) {
            return (String)this.nameByIndex.apply((Object)BoxesRunTime.boxToInteger((int)idx$2.elem));
        }

        private final ZIO decodeBody$$anonfun$5(Object[] inputs$5, Object trace$6) {
            return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$2 -> {
                IntRef idx = IntRef.create((int)0);
                while (idx.elem < inputs$5.length) {
                    int n;
                    if (inputs$5[idx.elem] == null) {
                        throw HttpCodecError$MalformedBody$.MODULE$.apply(new StringBuilder(35).append("Missing multipart/form-data field (").append(Try$.MODULE$.apply(() -> this.decodeBody$$anonfun$5$$anonfun$1$$anonfun$1(idx))).toString(), HttpCodecError$MalformedBody$.MODULE$.$lessinit$greater$default$2());
                    }
                    idx.elem = n = idx.elem + 1;
                }
            }, trace$6);
        }

        private final Chunk processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$1(Chunk data$1) {
            return data$1;
        }

        private final Chunk processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$2(String value$1) {
            return Chunk$.MODULE$.fromArray((Object)value$1.getBytes(Charsets$.MODULE$.Utf8()));
        }

        private final Chunk processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$3(String value$2) {
            return Chunk$.MODULE$.fromArray((Object)value$2.getBytes(Charsets$.MODULE$.Utf8()));
        }

        private final boolean processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1(Object[] inputs$11) {
            Object object = Predef$.MODULE$.genericArrayOps((Object)inputs$11);
            return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)_$2 -> _$2 == null);
        }

        private final ZIO processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$5(Promise ready$2, Object trace$9, Object[] inputs$10) {
            return ready$2.succeed((Object)BoxedUnit.UNIT, trace$9).unless(() -> this.processStreamingForm$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1(inputs$10), trace$9);
        }

        private final Promise processStreamingForm$$anonfun$1$$anonfun$2(Promise ready$3) {
            return ready$3;
        }

        private final ZIO processStreamingForm$$anonfun$1$$anonfun$3(Promise ready$4, Object trace$10) {
            return ready$4.await(trace$10);
        }

        private final Iterable collectAndProcessForm$$anonfun$1$$anonfun$1(Form collectedForm$1) {
            return collectedForm$1.formData();
        }

        private final Chunk collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$1(Chunk data$2) {
            return data$2;
        }

        private final Chunk collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$2(String value$3) {
            return Chunk$.MODULE$.fromArray((Object)value$3.getBytes(Charsets$.MODULE$.Utf8()));
        }

        private final Chunk collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$3(String value$4) {
            return Chunk$.MODULE$.fromArray((Object)value$4.getBytes(Charsets$.MODULE$.Utf8()));
        }

        private final HttpCodecError.MalformedBody collectAndProcessForm$$anonfun$1$$anonfun$2$$anonfun$5(FormField field$1) {
            return HttpCodecError$MalformedBody$.MODULE$.apply(new StringBuilder(38).append("Unexpected multipart/form-data field: ").append(field$1.name()).toString(), HttpCodecError$MalformedBody$.MODULE$.$lessinit$greater$default$2());
        }

        private final MediaType encodeMultipartFormData$$anonfun$1$$anonfun$1() {
            return MediaType$.MODULE$.application().octet$minusstream();
        }

        private final MediaType $anonfun$4() {
            return MediaType$.MODULE$.application().octet$minusstream();
        }

        private final MediaType $anonfun$5() {
            throw HttpCodecError$CustomError$.MODULE$.apply("InvalidHttpContentCodec", "No codecs found.");
        }
    }

    public static final class Undefined<AtomTypes, Value>
    implements EncoderDecoder<AtomTypes, Value>,
    Product,
    Serializable {
        private final String encodeWithErrorMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |Trying to encode with Undefined codec. That means that encode was invoked for object of type Nothing - which cannot exist.\n        |Verify that middleware and endpoint have proper types or submit bug report at https://github.com/zio/zio-http/issues\n    ")).trim();
        private final String decodeErrorMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |Trying to decode with Undefined codec. That means that decode was invoked for object of type Nothing - which cannot exist.\n        |Verify that middleware and endpoint have proper types or submit bug report at https://github.com/zio/zio-http/issues\n    ")).trim();

        public static <AtomTypes, Value> Undefined<AtomTypes, Value> apply() {
            return EncoderDecoder$Undefined$.MODULE$.apply();
        }

        public static Undefined<?, ?> fromProduct(Product product) {
            return EncoderDecoder$Undefined$.MODULE$.fromProduct(product);
        }

        public static <AtomTypes, Value> boolean unapply(Undefined<AtomTypes, Value> undefined) {
            return EncoderDecoder$Undefined$.MODULE$.unapply(undefined);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Undefined)) return false;
            Undefined undefined = (Undefined)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Undefined;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "Undefined";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String encodeWithErrorMessage() {
            return this.encodeWithErrorMessage;
        }

        public String decodeErrorMessage() {
            return this.decodeErrorMessage;
        }

        @Override
        public <Z> Z encodeWith(Value value, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> f) {
            throw new IllegalStateException(this.encodeWithErrorMessage());
        }

        @Override
        public ZIO<Object, Throwable, Value> decode(URL url, Status status, Method method, Headers headers, Body body, Object trace) {
            return ZIO$.MODULE$.fail(this::decode$$anonfun$1, trace);
        }

        public <AtomTypes, Value> Undefined<AtomTypes, Value> copy() {
            return new Undefined<AtomTypes, Value>();
        }

        private final IllegalStateException decode$$anonfun$1() {
            return new IllegalStateException(this.decodeErrorMessage());
        }
    }
}

