/*
 * Decompiled with CFR 0.152.
 */
package zio.http.endpoint.http;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.http.Method;
import zio.http.Method$ANY$;
import zio.http.endpoint.http.HttpEndpoint$;
import zio.http.endpoint.http.HttpVariable;
import zio.http.endpoint.openapi.JsonSchema;
import zio.http.endpoint.openapi.JsonSchema$AllOfSchema$;
import zio.http.endpoint.openapi.JsonSchema$AnnotatedSchema$;
import zio.http.endpoint.openapi.JsonSchema$AnyJson$;
import zio.http.endpoint.openapi.JsonSchema$AnyOfSchema$;
import zio.http.endpoint.openapi.JsonSchema$ArrayType$;
import zio.http.endpoint.openapi.JsonSchema$Boolean$;
import zio.http.endpoint.openapi.JsonSchema$Enum$;
import zio.http.endpoint.openapi.JsonSchema$Integer$;
import zio.http.endpoint.openapi.JsonSchema$Null$;
import zio.http.endpoint.openapi.JsonSchema$Number$;
import zio.http.endpoint.openapi.JsonSchema$Object$;
import zio.http.endpoint.openapi.JsonSchema$OneOfSchema$;
import zio.http.endpoint.openapi.JsonSchema$RefSchema$;
import zio.http.endpoint.openapi.JsonSchema$String$;

public final class HttpEndpoint
implements Product,
Serializable {
    private final Method method;
    private final String path;
    private final Seq headers;
    private final Option requestBody;
    private final Seq variables;
    private final Option docString;

    public static HttpEndpoint apply(Method method, String string, Seq<String> seq, Option<JsonSchema> option, Seq<HttpVariable> seq2, Option<String> option2) {
        return HttpEndpoint$.MODULE$.apply(method, string, seq, option, seq2, option2);
    }

    public static HttpEndpoint fromProduct(Product product) {
        return HttpEndpoint$.MODULE$.fromProduct(product);
    }

    public static HttpEndpoint unapply(HttpEndpoint httpEndpoint) {
        return HttpEndpoint$.MODULE$.unapply(httpEndpoint);
    }

    public HttpEndpoint(Method method, String path, Seq<String> headers, Option<JsonSchema> requestBody, Seq<HttpVariable> variables, Option<String> docString) {
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.requestBody = requestBody;
        this.variables = variables;
        this.docString = docString;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HttpEndpoint)) return false;
        HttpEndpoint httpEndpoint = (HttpEndpoint)object;
        Method method = this.method();
        Method method2 = httpEndpoint.method();
        if (method == null) {
            if (method2 != null) {
                return false;
            }
        } else if (!method.equals(method2)) return false;
        String string = this.path();
        String string2 = httpEndpoint.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Seq<String> seq = this.headers();
        Seq<String> seq2 = httpEndpoint.headers();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<JsonSchema> option = this.requestBody();
        Option<JsonSchema> option2 = httpEndpoint.requestBody();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<HttpVariable> seq3 = this.variables();
        Seq<HttpVariable> seq4 = httpEndpoint.variables();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Option<String> option3 = this.docString();
        Option<String> option4 = httpEndpoint.docString();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof HttpEndpoint;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "HttpEndpoint";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "method";
            }
            case 1: {
                return "path";
            }
            case 2: {
                return "headers";
            }
            case 3: {
                return "requestBody";
            }
            case 4: {
                return "variables";
            }
            case 5: {
                return "docString";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Method method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public Seq<String> headers() {
        return this.headers;
    }

    public Option<JsonSchema> requestBody() {
        return this.requestBody;
    }

    public Seq<HttpVariable> variables() {
        return this.variables;
    }

    public Option<String> docString() {
        return this.docString;
    }

    public String render() {
        return new StringBuilder(0).append(this.renderDoc()).append(this.renderVariables()).append(this.renderPath()).append(this.renderHeaders()).append(this.renderRequestBody()).toString();
    }

    private String renderRequestBody() {
        Option<JsonSchema> option = this.requestBody();
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        if (option instanceof Some) {
            JsonSchema schema = (JsonSchema)((Some)option).value();
            return this.renderSchema(schema, this.renderSchema$default$2());
        }
        throw new MatchError(option);
    }

    private String renderSchema(JsonSchema schema, Option<String> name) {
        JsonSchema jsonSchema;
        while ((jsonSchema = schema) instanceof JsonSchema.AnnotatedSchema) {
            JsonSchema schema2;
            JsonSchema.AnnotatedSchema annotatedSchema = JsonSchema$AnnotatedSchema$.MODULE$.unapply((JsonSchema.AnnotatedSchema)jsonSchema);
            JsonSchema jsonSchema2 = annotatedSchema._1();
            JsonSchema.MetaData metaData = annotatedSchema._2();
            JsonSchema jsonSchema3 = schema2 = jsonSchema2;
            Option<String> option = this.renderSchema$default$2();
            schema = jsonSchema3;
            name = option;
        }
        if (jsonSchema instanceof JsonSchema.RefSchema) {
            JsonSchema.RefSchema refSchema = JsonSchema$RefSchema$.MODULE$.unapply((JsonSchema.RefSchema)jsonSchema);
            String string = refSchema._1();
            throw new Exception("RefSchema not supported");
        }
        if (jsonSchema instanceof JsonSchema.OneOfSchema) {
            JsonSchema.OneOfSchema oneOfSchema = JsonSchema$OneOfSchema$.MODULE$.unapply((JsonSchema.OneOfSchema)jsonSchema);
            Chunk<JsonSchema> chunk = oneOfSchema._1();
            throw new Exception("OneOfSchema not supported");
        }
        if (jsonSchema instanceof JsonSchema.AllOfSchema) {
            JsonSchema.AllOfSchema allOfSchema = JsonSchema$AllOfSchema$.MODULE$.unapply((JsonSchema.AllOfSchema)jsonSchema);
            Chunk<JsonSchema> chunk = allOfSchema._1();
            throw new Exception("AllOfSchema not supported");
        }
        if (jsonSchema instanceof JsonSchema.AnyOfSchema) {
            JsonSchema.AnyOfSchema anyOfSchema = JsonSchema$AnyOfSchema$.MODULE$.unapply((JsonSchema.AnyOfSchema)jsonSchema);
            Chunk<JsonSchema> chunk = anyOfSchema._1();
            throw new Exception("AnyOfSchema not supported");
        }
        if (jsonSchema instanceof JsonSchema.Number) {
            JsonSchema.Number number = JsonSchema$Number$.MODULE$.unapply((JsonSchema.Number)jsonSchema);
            JsonSchema.NumberFormat numberFormat = number._1();
            return new StringBuilder(8).append("\"").append(this.getName(name)).append("\": {{").append(this.getName(name)).append("}}").toString();
        }
        if (jsonSchema instanceof JsonSchema.Integer) {
            JsonSchema.Integer integer = JsonSchema$Integer$.MODULE$.unapply((JsonSchema.Integer)jsonSchema);
            JsonSchema.IntegerFormat integerFormat = integer._1();
            return new StringBuilder(8).append("\"").append(this.getName(name)).append("\": {{").append(this.getName(name)).append("}}").toString();
        }
        if (jsonSchema instanceof JsonSchema.String) {
            JsonSchema.String string = JsonSchema$String$.MODULE$.unapply((JsonSchema.String)jsonSchema);
            Option<JsonSchema.StringFormat> option = string._1();
            Option<JsonSchema.Pattern> option2 = string._2();
            return new StringBuilder(8).append("\"").append(this.getName(name)).append("\": {{").append(this.getName(name)).append("}}").toString();
        }
        if (JsonSchema$Boolean$.MODULE$.equals(jsonSchema)) {
            return new StringBuilder(8).append("\"").append(this.getName(name)).append("\": {{").append(this.getName(name)).append("}}").toString();
        }
        if (jsonSchema instanceof JsonSchema.ArrayType) {
            JsonSchema.ArrayType arrayType = JsonSchema$ArrayType$.MODULE$.unapply((JsonSchema.ArrayType)jsonSchema);
            Option<JsonSchema> option = arrayType._1();
            return new StringBuilder(8).append("\"").append(this.getName(name)).append("\": {{").append(this.getName(name)).append("}}").toString();
        }
        if (jsonSchema instanceof JsonSchema.Object) {
            JsonSchema.Object object = JsonSchema$Object$.MODULE$.unapply((JsonSchema.Object)jsonSchema);
            Map<String, JsonSchema> map = object._1();
            Either<Object, JsonSchema> either = object._2();
            Chunk<String> chunk = object._3();
            Map<String, JsonSchema> properties = map;
            if (properties.isEmpty()) {
                return "";
            }
            String fields = ((IterableOnceOps)properties.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    JsonSchema schema = (JsonSchema)tuple2._2();
                    return this.renderSchema(schema, (Option<String>)Some$.MODULE$.apply((Object)name));
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",\n");
            if (name.isEmpty()) {
                return new StringBuilder(37).append("\nContent-type: application/json\n\n{\n").append(fields).append("\n}").toString();
            }
            return new StringBuilder(8).append("\"").append(this.getName(name)).append("\": {\n").append(fields).append("\n}").toString();
        }
        if (jsonSchema instanceof JsonSchema.Enum) {
            JsonSchema.Enum enum_ = JsonSchema$Enum$.MODULE$.unapply((JsonSchema.Enum)jsonSchema);
            Chunk<JsonSchema.EnumValue> chunk = enum_._1();
            return new StringBuilder(8).append("\"").append(this.getName(name)).append("\": {{").append(this.getName(name)).append("}}").toString();
        }
        if (JsonSchema$Null$.MODULE$.equals(jsonSchema)) {
            return "";
        }
        if (JsonSchema$AnyJson$.MODULE$.equals(jsonSchema)) {
            return "";
        }
        throw new MatchError((Object)jsonSchema);
    }

    private Option<String> renderSchema$default$2() {
        return None$.MODULE$;
    }

    private String getName(Option<String> name) {
        return (String)name.getOrElse(HttpEndpoint::getName$$anonfun$1);
    }

    private String renderDoc() {
        Option<String> option = this.docString();
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        if (option instanceof Some) {
            String doc = (String)((Some)option).value();
            Object object = Predef$.MODULE$.refArrayOps((Object[])doc.split("\n"));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)line -> new StringBuilder(2).append("# ").append((String)line).toString(), ClassTag$.MODULE$.apply(String.class))).mkString("\n", "\n", "\n");
        }
        throw new MatchError(option);
    }

    private String renderVariables() {
        if (this.variables().isEmpty()) {
            return "";
        }
        return ((IterableOnceOps)((IterableOps)this.variables().distinct()).map((Function1 & Serializable)_$2 -> _$2.render())).mkString("\n", "\n", "\n\n");
    }

    private String renderHeaders() {
        if (this.headers().isEmpty()) {
            return "";
        }
        return ((IterableOnceOps)this.headers().map((Function1 & Serializable)h -> new StringBuilder(6).append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(h))).append(": {{").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(h))).append("}}").toString())).mkString("\n", "\n", "");
    }

    private String renderPath() {
        Method method = this.method();
        Method$ANY$ method$ANY$ = Method$ANY$.MODULE$;
        if (!(method != null ? !method.equals(method$ANY$) : method$ANY$ != null)) {
            return new StringBuilder(5).append("POST ").append(this.path()).toString();
        }
        return new StringBuilder(1).append(this.method().render()).append(" ").append(this.path()).toString();
    }

    public HttpEndpoint copy(Method method, String path, Seq<String> headers, Option<JsonSchema> requestBody, Seq<HttpVariable> variables, Option<String> docString) {
        return new HttpEndpoint(method, path, headers, requestBody, variables, docString);
    }

    public Method copy$default$1() {
        return this.method();
    }

    public String copy$default$2() {
        return this.path();
    }

    public Seq<String> copy$default$3() {
        return this.headers();
    }

    public Option<JsonSchema> copy$default$4() {
        return this.requestBody();
    }

    public Seq<HttpVariable> copy$default$5() {
        return this.variables();
    }

    public Option<String> copy$default$6() {
        return this.docString();
    }

    public Method _1() {
        return this.method();
    }

    public String _2() {
        return this.path();
    }

    public Seq<String> _3() {
        return this.headers();
    }

    public Option<JsonSchema> _4() {
        return this.requestBody();
    }

    public Seq<HttpVariable> _5() {
        return this.variables();
    }

    public Option<String> _6() {
        return this.docString();
    }

    private static final String getName$$anonfun$1() {
        throw new IllegalArgumentException("name is required");
    }
}

