/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.util.ResourceLeakDetector;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.Config;
import zio.http.netty.ChannelType;
import zio.http.netty.EventLoopGroups;
import zio.http.netty.NettyConfig$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$ADVANCED$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$DISABLED$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$PARANOID$;
import zio.http.netty.NettyConfig$LeakDetectionLevel$SIMPLE$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NettyConfig
implements EventLoopGroups.Config,
Product,
Serializable {
    private final LeakDetectionLevel leakDetectionLevel;
    private final ChannelType channelType;
    private final int nThreads;
    private final Duration shutdownQuietPeriodDuration;
    private final Duration shutdownTimeoutDuration;
    private final TimeUnit shutdownTimeUnit;
    private final long shutdownQuietPeriod;
    private final long shutdownTimeOut;
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(NettyConfig$.class.getDeclaredField("defaultWithFastShutdown$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(NettyConfig$.class.getDeclaredField("default$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(NettyConfig$.class.getDeclaredField("config$lzy1"));

    public static NettyConfig apply(LeakDetectionLevel leakDetectionLevel, ChannelType channelType, int n, Duration duration, Duration duration2) {
        return NettyConfig$.MODULE$.apply(leakDetectionLevel, channelType, n, duration, duration2);
    }

    public static Config<NettyConfig> config() {
        return NettyConfig$.MODULE$.config();
    }

    public static NettyConfig default() {
        return NettyConfig$.MODULE$.default();
    }

    public static NettyConfig defaultWithFastShutdown() {
        return NettyConfig$.MODULE$.defaultWithFastShutdown();
    }

    public static NettyConfig fromProduct(Product product) {
        return NettyConfig$.MODULE$.fromProduct(product);
    }

    public static NettyConfig unapply(NettyConfig nettyConfig) {
        return NettyConfig$.MODULE$.unapply(nettyConfig);
    }

    public NettyConfig(LeakDetectionLevel leakDetectionLevel, ChannelType channelType, int nThreads, Duration shutdownQuietPeriodDuration, Duration shutdownTimeoutDuration) {
        this.leakDetectionLevel = leakDetectionLevel;
        this.channelType = channelType;
        this.nThreads = nThreads;
        this.shutdownQuietPeriodDuration = shutdownQuietPeriodDuration;
        this.shutdownTimeoutDuration = shutdownTimeoutDuration;
        this.shutdownTimeUnit = TimeUnit.MILLISECONDS;
        this.shutdownQuietPeriod = shutdownQuietPeriodDuration.toMillis();
        this.shutdownTimeOut = shutdownTimeoutDuration.toMillis();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.leakDetectionLevel()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.channelType()));
        n = Statics.mix((int)n, (int)this.nThreads());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shutdownQuietPeriodDuration()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shutdownTimeoutDuration()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NettyConfig)) return false;
        NettyConfig nettyConfig = (NettyConfig)object;
        if (this.nThreads() != nettyConfig.nThreads()) return false;
        LeakDetectionLevel leakDetectionLevel = this.leakDetectionLevel();
        LeakDetectionLevel leakDetectionLevel2 = nettyConfig.leakDetectionLevel();
        if (leakDetectionLevel == null) {
            if (leakDetectionLevel2 != null) {
                return false;
            }
        } else if (!leakDetectionLevel.equals(leakDetectionLevel2)) return false;
        ChannelType channelType = this.channelType();
        ChannelType channelType2 = nettyConfig.channelType();
        if (channelType == null) {
            if (channelType2 != null) {
                return false;
            }
        } else if (!channelType.equals(channelType2)) return false;
        Duration duration = this.shutdownQuietPeriodDuration();
        Duration duration2 = nettyConfig.shutdownQuietPeriodDuration();
        if (duration == null) {
            if (duration2 != null) {
                return false;
            }
        } else if (!((Object)duration).equals(duration2)) return false;
        Duration duration3 = this.shutdownTimeoutDuration();
        Duration duration4 = nettyConfig.shutdownTimeoutDuration();
        if (duration3 == null) {
            if (duration4 == null) return true;
            return false;
        } else {
            if (!((Object)duration3).equals(duration4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NettyConfig;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "NettyConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "leakDetectionLevel";
            }
            case 1: {
                return "channelType";
            }
            case 2: {
                return "nThreads";
            }
            case 3: {
                return "shutdownQuietPeriodDuration";
            }
            case 4: {
                return "shutdownTimeoutDuration";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public LeakDetectionLevel leakDetectionLevel() {
        return this.leakDetectionLevel;
    }

    @Override
    public ChannelType channelType() {
        return this.channelType;
    }

    @Override
    public int nThreads() {
        return this.nThreads;
    }

    public Duration shutdownQuietPeriodDuration() {
        return this.shutdownQuietPeriodDuration;
    }

    public Duration shutdownTimeoutDuration() {
        return this.shutdownTimeoutDuration;
    }

    public NettyConfig channelType(ChannelType channelType) {
        return this.copy(this.copy$default$1(), channelType, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public NettyConfig leakDetection(LeakDetectionLevel level) {
        return this.copy(level, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public NettyConfig maxThreads(int nThreads) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), nThreads, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public TimeUnit shutdownTimeUnit() {
        return this.shutdownTimeUnit;
    }

    @Override
    public long shutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }

    @Override
    public long shutdownTimeOut() {
        return this.shutdownTimeOut;
    }

    public NettyConfig copy(LeakDetectionLevel leakDetectionLevel, ChannelType channelType, int nThreads, Duration shutdownQuietPeriodDuration, Duration shutdownTimeoutDuration) {
        return new NettyConfig(leakDetectionLevel, channelType, nThreads, shutdownQuietPeriodDuration, shutdownTimeoutDuration);
    }

    public LeakDetectionLevel copy$default$1() {
        return this.leakDetectionLevel();
    }

    public ChannelType copy$default$2() {
        return this.channelType();
    }

    public int copy$default$3() {
        return this.nThreads();
    }

    public Duration copy$default$4() {
        return this.shutdownQuietPeriodDuration();
    }

    public Duration copy$default$5() {
        return this.shutdownTimeoutDuration();
    }

    public LeakDetectionLevel _1() {
        return this.leakDetectionLevel();
    }

    public ChannelType _2() {
        return this.channelType();
    }

    public int _3() {
        return this.nThreads();
    }

    public Duration _4() {
        return this.shutdownQuietPeriodDuration();
    }

    public Duration _5() {
        return this.shutdownTimeoutDuration();
    }

    public static interface LeakDetectionLevel {
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(NettyConfig$LeakDetectionLevel$.class.getDeclaredField("config$lzy2"));

        public static Config<LeakDetectionLevel> config() {
            return NettyConfig$LeakDetectionLevel$.MODULE$.config();
        }

        public static int ordinal(LeakDetectionLevel leakDetectionLevel) {
            return NettyConfig$LeakDetectionLevel$.MODULE$.ordinal(leakDetectionLevel);
        }

        public static ResourceLeakDetector.Level toNetty$(LeakDetectionLevel $this) {
            return $this.toNetty();
        }

        default public ResourceLeakDetector.Level toNetty() {
            LeakDetectionLevel leakDetectionLevel = this;
            if (NettyConfig$LeakDetectionLevel$DISABLED$.MODULE$.equals(leakDetectionLevel)) {
                return ResourceLeakDetector.Level.DISABLED;
            }
            if (NettyConfig$LeakDetectionLevel$SIMPLE$.MODULE$.equals(leakDetectionLevel)) {
                return ResourceLeakDetector.Level.SIMPLE;
            }
            if (NettyConfig$LeakDetectionLevel$ADVANCED$.MODULE$.equals(leakDetectionLevel)) {
                return ResourceLeakDetector.Level.ADVANCED;
            }
            if (NettyConfig$LeakDetectionLevel$PARANOID$.MODULE$.equals(leakDetectionLevel)) {
                return ResourceLeakDetector.Level.PARANOID;
            }
            throw new MatchError((Object)leakDetectionLevel);
        }
    }
}

