/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import zio.Exit$;
import zio.Fiber;
import zio.Promise;
import zio.Queue;
import zio.Queue$;
import zio.Scope;
import zio.Scope$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZEnvironment$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Channel;
import zio.http.ChannelEvent;
import zio.http.ClientDriver;
import zio.http.ConnectionPool;
import zio.http.ConnectionPoolConfig;
import zio.http.DnsResolver;
import zio.http.Request;
import zio.http.Response;
import zio.http.URL;
import zio.http.WebSocketApp;
import zio.http.WebSocketConfig;
import zio.http.WebSocketFrame;
import zio.http.internal.ChannelState;
import zio.http.internal.ChannelState$Invalid$;
import zio.http.internal.ChannelState$Reusable$;
import zio.http.netty.EventLoopGroups;
import zio.http.netty.NettyChannel;
import zio.http.netty.NettyChannel$;
import zio.http.netty.NettyFutureExecutor$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.WebSocketAppHandler;
import zio.http.netty.WebSocketChannel$;
import zio.http.netty.client.ClientFailureHandler;
import zio.http.netty.client.ClientInboundHandler;
import zio.http.netty.client.ClientInboundHandler$SendRequest$;
import zio.http.netty.client.NettyClientDriver$;
import zio.http.netty.client.NettyConnectionPool$;
import zio.http.netty.client.NettyRequestEncoder$;
import zio.http.netty.client.WebSocketClientInboundHandler;
import zio.http.netty.model.Conversions$;
import zio.http.netty.package$Names$;
import zio.http.netty.socket.NettySocketProtocol$;
import zio.package;

public final class NettyClientDriver
implements ClientDriver,
Product,
Serializable {
    private final ChannelFactory channelFactory;
    private final EventLoopGroup eventLoopGroup;
    private final NettyRuntime nettyRuntime;

    public static NettyClientDriver apply(ChannelFactory<io.netty.channel.Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime) {
        return NettyClientDriver$.MODULE$.apply(channelFactory, eventLoopGroup, nettyRuntime);
    }

    public static NettyClientDriver fromProduct(Product product) {
        return NettyClientDriver$.MODULE$.fromProduct(product);
    }

    public static ZLayer<EventLoopGroups.Config, Nothing$, ClientDriver> live() {
        return NettyClientDriver$.MODULE$.live();
    }

    public static NettyClientDriver unapply(NettyClientDriver nettyClientDriver) {
        return NettyClientDriver$.MODULE$.unapply(nettyClientDriver);
    }

    public NettyClientDriver(ChannelFactory<io.netty.channel.Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime) {
        this.channelFactory = channelFactory;
        this.eventLoopGroup = eventLoopGroup;
        this.nettyRuntime = nettyRuntime;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NettyClientDriver)) return false;
        NettyClientDriver nettyClientDriver = (NettyClientDriver)object;
        ChannelFactory<io.netty.channel.Channel> channelFactory = this.channelFactory();
        ChannelFactory<io.netty.channel.Channel> channelFactory2 = nettyClientDriver.channelFactory();
        if (channelFactory == null) {
            if (channelFactory2 != null) {
                return false;
            }
        } else if (!channelFactory.equals(channelFactory2)) return false;
        EventLoopGroup eventLoopGroup = this.eventLoopGroup();
        EventLoopGroup eventLoopGroup2 = nettyClientDriver.eventLoopGroup();
        if (eventLoopGroup == null) {
            if (eventLoopGroup2 != null) {
                return false;
            }
        } else if (!eventLoopGroup.equals(eventLoopGroup2)) return false;
        NettyRuntime nettyRuntime = this.nettyRuntime();
        NettyRuntime nettyRuntime2 = nettyClientDriver.nettyRuntime();
        if (nettyRuntime == null) {
            if (nettyRuntime2 == null) return true;
            return false;
        } else {
            if (!nettyRuntime.equals(nettyRuntime2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NettyClientDriver;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "NettyClientDriver";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "channelFactory";
            }
            case 1: {
                return "eventLoopGroup";
            }
            case 2: {
                return "nettyRuntime";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ChannelFactory<io.netty.channel.Channel> channelFactory() {
        return this.channelFactory;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public NettyRuntime nettyRuntime() {
        return this.nettyRuntime;
    }

    public ZIO<Scope, Throwable, ClientDriver.ChannelInterface> requestOnChannel(io.netty.channel.Channel channel, URL.Location.Absolute location, Request req, Promise<Throwable, Response> onResponse, Promise<Throwable, ChannelState> onComplete, boolean enableKeepAlive, Function0<WebSocketApp<Object>> createSocketApp, WebSocketConfig webSocketConfig, Object trace) {
        if (location.scheme().isWebSocket()) {
            return this.requestWebsocket(channel, req, onResponse, onComplete, createSocketApp, webSocketConfig, trace);
        }
        return this.requestHttp(channel, req, onResponse, onComplete, enableKeepAlive, trace);
    }

    private ZIO<Scope, Throwable, ClientDriver.ChannelInterface> requestHttp(io.netty.channel.Channel channel, Request req, Promise<Throwable, Response> onResponse, Promise<Throwable, ChannelState> onComplete, boolean enableKeepAlive, Object trace) {
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> NettyRequestEncoder$.MODULE$.encode(req), trace).tapSome((PartialFunction)new Serializable(trace){
            private final Object trace$1;
            {
                this.trace$1 = trace$9;
            }

            public final boolean isDefinedAt(HttpRequest x) {
                HttpRequest httpRequest = x;
                if (httpRequest instanceof FullHttpRequest) {
                    FullHttpRequest fullReq = (FullHttpRequest)httpRequest;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(HttpRequest x, Function1 function1) {
                HttpRequest httpRequest = x;
                if (httpRequest instanceof FullHttpRequest) {
                    FullHttpRequest fullReq = (FullHttpRequest)httpRequest;
                    return Scope$.MODULE$.addFinalizer(() -> this.applyOrElse$$anonfun$1(fullReq), this.trace$1);
                }
                return function1.apply((Object)x);
            }

            private final ZIO applyOrElse$$anonfun$1(FullHttpRequest fullReq$1) {
                return ZIO$.MODULE$.succeed(arg_0 -> NettyClientDriver.zio$http$netty$client$NettyClientDriver$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(fullReq$1, arg_0), this.trace$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(io.netty.handler.codec.http.FullHttpRequest ), zio$http$netty$client$NettyClientDriver$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(io.netty.handler.codec.http.FullHttpRequest zio.Unsafe )}, serializedLambda);
            }
        }, trace).map((Function1 & Serializable)jReq -> {
            GenericFutureListener closeListener = _$1 -> {
                ZIO zIO = ZIO$.MODULE$.ZIOBooleanOps(onComplete.interrupt(trace));
                this.nettyRuntime().unsafeRunSync(ZIO.ZIOBooleanOps$.MODULE$.$amp$amp$extension(zIO, () -> NettyClientDriver.$anonfun$1$$anonfun$1(onResponse, trace), trace), Unsafe$.MODULE$.unsafe(), trace);
            };
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(package$Names$.MODULE$.ClientInboundHandler(), (ChannelHandler)new ClientInboundHandler(this.nettyRuntime(), req, (HttpRequest)jReq, onResponse, onComplete, enableKeepAlive, trace));
            pipeline.addLast(package$Names$.MODULE$.ClientFailureHandler(), (ChannelHandler)new ClientFailureHandler(onResponse, onComplete));
            pipeline.fireChannelRegistered().fireUserEventTriggered((Object)ClientInboundHandler$SendRequest$.MODULE$);
            channel.closeFuture().addListener(closeListener);
            return new ClientDriver.ChannelInterface(channel, closeListener, pipeline, trace){
                private final io.netty.channel.Channel channel$2;
                private final GenericFutureListener closeListener$1;
                private final ChannelPipeline pipeline$1;
                private final Object trace$5;
                {
                    this.channel$2 = channel$7;
                    this.closeListener$1 = closeListener$2;
                    this.pipeline$1 = pipeline$2;
                    this.trace$5 = trace$10;
                }

                public ZIO resetChannel() {
                    return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$3 -> {
                        this.channel$2.closeFuture().removeListener(this.closeListener$1);
                        this.pipeline$1.remove(package$Names$.MODULE$.ClientInboundHandler());
                        this.pipeline$1.remove(package$Names$.MODULE$.ClientFailureHandler());
                        return ChannelState$Reusable$.MODULE$;
                    }, this.trace$5);
                }

                public ZIO interrupt() {
                    return ZIO$.MODULE$.suspendSucceed(this::interrupt$$anonfun$1, this.trace$5);
                }

                private final Future interrupt$$anonfun$1$$anonfun$1() {
                    return this.channel$2.disconnect();
                }

                private final ZIO interrupt$$anonfun$1() {
                    this.channel$2.closeFuture().removeListener(this.closeListener$1);
                    return NettyFutureExecutor$.MODULE$.executed(this::interrupt$$anonfun$1$$anonfun$1, this.trace$5);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{resetChannel$$anonfun$1(zio.Unsafe ), interrupt$$anonfun$1(), interrupt$$anonfun$1$$anonfun$1()}, serializedLambda);
                }
            };
        }, trace);
    }

    private ZIO<Scope, Throwable, ClientDriver.ChannelInterface> requestWebsocket(io.netty.channel.Channel channel, Request req, Promise<Throwable, Response> onResponse, Promise<Throwable, ChannelState> onComplete, Function0<WebSocketApp<Object>> createSocketApp, WebSocketConfig webSocketConfig, Object trace) {
        return Queue$.MODULE$.unbounded(trace).map((Function1 & Serializable)queue -> {
            NettyChannel<io.netty.handler.codec.http.websocketx.WebSocketFrame> nettyChannel = NettyChannel$.MODULE$.make(channel);
            Channel<ChannelEvent<WebSocketFrame>, ChannelEvent<WebSocketFrame>> webSocketChannel = WebSocketChannel$.MODULE$.make(nettyChannel, (Queue<ChannelEvent<WebSocketFrame>>)queue);
            WebSocketApp app = (WebSocketApp)createSocketApp.apply();
            return Tuple4$.MODULE$.apply(queue, nettyChannel, webSocketChannel, (Object)app);
        }, trace).flatMap((Function1 & Serializable)x$12 -> {
            Tuple4 tuple4 = x$12;
            if (tuple4 != null) {
                Queue queue = (Queue)tuple4._1();
                NettyChannel nettyChannel = (NettyChannel)tuple4._2();
                Channel webSocketChannel = (Channel)tuple4._3();
                WebSocketApp app = (WebSocketApp)tuple4._4();
                return app.handler().runZIO(webSocketChannel).ignoreLogged(trace).interruptible(trace).forkScoped(trace).map((Function1 & Serializable)x$1 -> {
                    Fiber.Runtime runtime = x$1;
                    ChannelPipeline pipeline = channel.pipeline();
                    HttpObjectAggregator httpObjectAggregator = new HttpObjectAggregator(Integer.MAX_VALUE);
                    WebSocketClientInboundHandler inboundHandler = new WebSocketClientInboundHandler(onResponse, onComplete);
                    pipeline.addLast(package$Names$.MODULE$.HttpObjectAggregator(), (ChannelHandler)httpObjectAggregator);
                    pipeline.addLast(package$Names$.MODULE$.ClientInboundHandler(), (ChannelHandler)inboundHandler);
                    HttpHeaders headers = Conversions$.MODULE$.headersToNetty(req.headers());
                    WebSocketClientProtocolConfig config = NettySocketProtocol$.MODULE$.clientBuilder((WebSocketConfig)app.customConfig().getOrElse(() -> NettyClientDriver.$anonfun$2(webSocketConfig))).customHeaders(headers).webSocketUri(req.url().encode()).build();
                    WebSocketClientProtocolHandler webSocketClientProtocol = new WebSocketClientProtocolHandler(config);
                    WebSocketAppHandler webSocket = new WebSocketAppHandler(this.nettyRuntime(), (Queue<ChannelEvent<WebSocketFrame>>)queue, (Option<Promise<Throwable, ChannelState>>)Some$.MODULE$.apply((Object)onComplete), trace);
                    pipeline.addLast(package$Names$.MODULE$.WebSocketClientProtocolHandler(), (ChannelHandler)webSocketClientProtocol);
                    pipeline.addLast(package$Names$.MODULE$.WebSocketHandler(), (ChannelHandler)webSocket);
                    pipeline.fireChannelRegistered();
                    pipeline.fireChannelActive();
                    return new ClientDriver.ChannelInterface(channel, trace){
                        private final io.netty.channel.Channel channel$6;
                        private final Object trace$8;
                        {
                            this.channel$6 = channel$8;
                            this.trace$8 = trace$11;
                        }

                        public ZIO resetChannel() {
                            return Exit$.MODULE$.succeed((Object)ChannelState$Invalid$.MODULE$);
                        }

                        public ZIO interrupt() {
                            return NettyFutureExecutor$.MODULE$.executed(this::interrupt$$anonfun$2, this.trace$8);
                        }

                        private final Future interrupt$$anonfun$2() {
                            return this.channel$6.disconnect();
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{interrupt$$anonfun$2()}, serializedLambda);
                        }
                    };
                }, trace);
            }
            throw new MatchError((Object)tuple4);
        }, trace);
    }

    public ZIO<Scope, Nothing$, ConnectionPool<io.netty.channel.Channel>> createConnectionPool(DnsResolver dnsResolver, ConnectionPoolConfig config, Object trace) {
        return NettyConnectionPool$.MODULE$.fromConfig(config, trace).provideSomeEnvironment((Function1 & Serializable)_$2 -> _$2.$plus$plus(ZEnvironment$.MODULE$.apply((Object)this, (Object)dnsResolver, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(NettyClientDriver.class, LightTypeTag$.MODULE$.parse(940870809, "\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(DnsResolver.class, LightTypeTag$.MODULE$.parse(499331248, "\u0004\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001", "\u0000\u0000\u0000", 30)))), Tag$.MODULE$.apply(Object.class, LightTypeTag$.MODULE$.parse(-736598261, "\u0002\u0000\u0002\u0003\u0000\u0001\u0014zio.http.DnsResolver\u0001\u0001\u0003\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001'zio.http.netty.client.NettyClientDriver\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0015zio.http.ClientDriver\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30))), trace);
    }

    public NettyClientDriver copy(ChannelFactory<io.netty.channel.Channel> channelFactory, EventLoopGroup eventLoopGroup, NettyRuntime nettyRuntime) {
        return new NettyClientDriver(channelFactory, eventLoopGroup, nettyRuntime);
    }

    public ChannelFactory<io.netty.channel.Channel> copy$default$1() {
        return this.channelFactory();
    }

    public EventLoopGroup copy$default$2() {
        return this.eventLoopGroup();
    }

    public NettyRuntime copy$default$3() {
        return this.nettyRuntime();
    }

    public ChannelFactory<io.netty.channel.Channel> _1() {
        return this.channelFactory();
    }

    public EventLoopGroup _2() {
        return this.eventLoopGroup();
    }

    public NettyRuntime _3() {
        return this.nettyRuntime();
    }

    public static final /* synthetic */ Object zio$http$netty$client$NettyClientDriver$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(FullHttpRequest fullReq$2, Unsafe evidence$2) {
        int refCount = fullReq$2.refCnt();
        if (refCount > 0) {
            return BoxesRunTime.boxToBoolean((boolean)fullReq$2.release(refCount));
        }
        return BoxedUnit.UNIT;
    }

    private static final ZIO $anonfun$1$$anonfun$1(Promise onResponse$3, Object trace$4) {
        return onResponse$3.fail((Object)NettyClientDriver$.zio$http$netty$client$NettyClientDriver$$$PrematureChannelClosure, trace$4);
    }

    private static final WebSocketConfig $anonfun$2(WebSocketConfig webSocketConfig$3) {
        return webSocketConfig$3;
    }
}

