/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.nio.charset.Charset;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkBuilder;
import zio.Dequeue;
import zio.Exit;
import zio.Fiber;
import zio.Promise;
import zio.Promise$;
import zio.Queue;
import zio.Queue$;
import zio.Runtime;
import zio.Scope$;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Boundary;
import zio.http.Form;
import zio.http.Form$;
import zio.http.FormDecodingError;
import zio.http.FormField;
import zio.http.FormField$;
import zio.http.MediaType;
import zio.http.StreamingForm$;
import zio.http.internal.FormAST;
import zio.http.internal.FormAST$Content$;
import zio.http.internal.FormState;
import zio.http.internal.FormState$BoundaryClosed$;
import zio.http.internal.FormState$BoundaryEncapsulated$;
import zio.http.internal.FormState$Phase$Part2$;
import zio.stream.Take;
import zio.stream.Take$;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class StreamingForm
implements Product,
Serializable {
    private final ZStream source;
    private final Boundary boundary;
    private final int bufferSize;

    public static StreamingForm apply(ZStream<Object, Throwable, Object> zStream, Boundary boundary, int n) {
        return StreamingForm$.MODULE$.apply(zStream, boundary, n);
    }

    public static StreamingForm fromProduct(Product product) {
        return StreamingForm$.MODULE$.fromProduct(product);
    }

    public static StreamingForm unapply(StreamingForm streamingForm) {
        return StreamingForm$.MODULE$.unapply(streamingForm);
    }

    public static int $lessinit$greater$default$3() {
        return StreamingForm$.MODULE$.$lessinit$greater$default$3();
    }

    public StreamingForm(ZStream<Object, Throwable, Object> source, Boundary boundary, int bufferSize) {
        this.source = source;
        this.boundary = boundary;
        this.bufferSize = bufferSize;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.source()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.boundary()));
        n = Statics.mix((int)n, (int)this.bufferSize());
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof StreamingForm)) return false;
        StreamingForm streamingForm = (StreamingForm)object;
        if (this.bufferSize() != streamingForm.bufferSize()) return false;
        ZStream<Object, Throwable, Object> zStream = this.source();
        ZStream<Object, Throwable, Object> zStream2 = streamingForm.source();
        if (zStream == null) {
            if (zStream2 != null) {
                return false;
            }
        } else if (!zStream.equals(zStream2)) return false;
        Boundary boundary = this.boundary();
        Boundary boundary2 = streamingForm.boundary();
        if (boundary == null) {
            if (boundary2 == null) return true;
            return false;
        } else {
            if (!((Object)boundary).equals(boundary2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof StreamingForm;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "StreamingForm";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "source";
            }
            case 1: {
                return "boundary";
            }
            case 2: {
                return "bufferSize";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ZStream<Object, Throwable, Object> source() {
        return this.source;
    }

    public Boundary boundary() {
        return this.boundary;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Charset charset() {
        return this.boundary().charset();
    }

    public ZIO<Object, Throwable, Form> collectAll(Object trace) {
        return this.streamFormFields(true, trace).mapZIO((Function1 & Serializable)x$1 -> {
            FormField formField = x$1;
            if (formField instanceof FormField.StreamingBinary) {
                FormField.StreamingBinary sb = (FormField.StreamingBinary)formField;
                return sb.collect(trace);
            }
            if (formField != null) {
                FormField other = formField;
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                    return other;
                });
            }
            throw new MatchError((Object)formField);
        }, trace).runCollect(trace).map((Function1 & Serializable)formData -> Form$.MODULE$.apply((Chunk<FormField>)formData), trace);
    }

    public ZStream<Object, Throwable, FormField> fields(Object trace) {
        return this.streamFormFields(false, trace);
    }

    private ZStream<Object, Throwable, FormField> streamFormFields(boolean bufferUpToBoundary, Object trace) {
        boolean bl = ZStream$.MODULE$.unwrapScoped();
        return ZStream.UnwrapScopedPartiallyApplied$.MODULE$.apply$extension(bl, () -> this.streamFormFields$$anonfun$1(trace, bufferUpToBoundary), trace);
    }

    private State initialState() {
        return StreamingForm$.MODULE$.zio$http$StreamingForm$$$initialState(this.boundary());
    }

    private byte[] crlfBoundary() {
        Object object = Predef$.MODULE$.byteArrayOps(new byte[]{13, 10});
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, this.boundary().encapsulationBoundaryBytes().toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public StreamingForm copy(ZStream<Object, Throwable, Object> source, Boundary boundary, int bufferSize) {
        return new StreamingForm(source, boundary, bufferSize);
    }

    public ZStream<Object, Throwable, Object> copy$default$1() {
        return this.source();
    }

    public Boundary copy$default$2() {
        return this.boundary();
    }

    public int copy$default$3() {
        return this.bufferSize();
    }

    public ZStream<Object, Throwable, Object> _1() {
        return this.source();
    }

    public Boundary _2() {
        return this.boundary();
    }

    public int _3() {
        return this.bufferSize();
    }

    private static final int streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1() {
        return 4;
    }

    private final Option handleBoundary$1(State state$2, Buffer buffer$3, Chunk ast) {
        if (state$2.inNonStreamingPart()) {
            Either<FormDecodingError, FormField> either = FormField$.MODULE$.fromFormAST((Chunk<FormAST>)ast, this.charset());
            if (either instanceof Right) {
                FormField formData = (FormField)((Right)either).value();
                buffer$3.reset();
                state$2.reset();
                return Some$.MODULE$.apply((Object)formData);
            }
            if (either instanceof Left) {
                FormDecodingError e = (FormDecodingError)((Left)either).value();
                throw e.asException();
            }
            throw new MatchError(either);
        }
        buffer$3.reset();
        state$2.reset();
        return None$.MODULE$;
    }

    private static final ZIO handleByte$1$$anonfun$1(Promise abort$4, Object trace$9) {
        return abort$4.await(trace$9);
    }

    private static final int handleByte$1$$anonfun$2() {
        return 3;
    }

    private static final /* synthetic */ ZIO handleByte$1$$anonfun$3$$anonfun$1(FormState.FormStateBuffer newFormState$2, Queue newQueue$1, Object trace$11, State state$5, boolean x$12) {
        boolean bl = x$12;
        return FormField$.MODULE$.incomingStreamingBinary(newFormState$2.tree(), (Queue<Exit>)newQueue$1, trace$11).mapError((Function1 & Serializable)_$1 -> _$1.asException(), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace$11).map((Function1 & Serializable)streamingFormData -> {
            State state;
            State $2$;
            State $2$2 = $2$ = (state = state$5.withCurrentQueue((Queue<Exit>)newQueue$1));
            return Tuple2$.MODULE$.apply(streamingFormData, (Object)$2$2);
        }, trace$11).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                FormField streamingFormData = (FormField)tuple2._1();
                return Some$.MODULE$.apply((Object)streamingFormData);
            }
            throw new MatchError((Object)tuple2);
        }, trace$11);
    }

    private final Option handleByte$1(State state$3, Buffer buffer$5, Runtime runtime$5, Object trace$8, Promise abort$3, Unsafe unsafe$6, byte by, boolean isLastByte) {
        FormState formState = state$3.formState();
        if (formState instanceof FormState.FormStateBuffer) {
            FormState.FormStateBuffer formState2 = (FormState.FormStateBuffer)formState;
            FormState nextFormState = formState2.append(by);
            Option<Queue<Exit>> option = state$3.currentQueue();
            if (option instanceof Some) {
                Queue queue = (Queue)((Some)option).value();
                Chunk<Exit> takes = buffer$5.addByte(by, isLastByte);
                if (takes.nonEmpty()) {
                    runtime$5.unsafe().run(queue.offerAll(takes, trace$8).raceFirst(() -> StreamingForm.handleByte$1$$anonfun$1(abort$3, trace$8), trace$8), trace$8, unsafe$6).getOrThrowFiberFailure(unsafe$6);
                }
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
            FormState formState3 = nextFormState;
            if (formState3 instanceof FormState.FormStateBuffer) {
                FormState.FormStateBuffer newFormState = (FormState.FormStateBuffer)formState3;
                if (state$3.currentQueue().isEmpty() && newFormState.phase() == FormState$Phase$Part2$.MODULE$ && !state$3.inNonStreamingPart()) {
                    MediaType contentType = FormField$.MODULE$.getContentType(newFormState.tree());
                    if (contentType.binary()) {
                        return (Option)runtime$5.unsafe().run(Queue$.MODULE$.bounded(StreamingForm::handleByte$1$$anonfun$2, trace$8).flatMap((Function1 & Serializable)newQueue -> newQueue.offer((Object)new Take(Take$.MODULE$.chunk(newFormState.tree().collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(FormAST x) {
                                FormAST formAST = x;
                                if (formAST instanceof FormAST.Content) {
                                    Chunk<Object> chunk;
                                    FormAST.Content content = FormAST$Content$.MODULE$.unapply((FormAST.Content)formAST);
                                    Chunk<Object> bytes = chunk = content._1();
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(FormAST x, Function1 function1) {
                                FormAST formAST = x;
                                if (formAST instanceof FormAST.Content) {
                                    Chunk<Object> chunk;
                                    FormAST.Content content = FormAST$Content$.MODULE$.unapply((FormAST.Content)formAST);
                                    Chunk<Object> bytes = chunk = content._1();
                                    return bytes;
                                }
                                return function1.apply((Object)x);
                            }
                        }).flatten(Predef$.MODULE$.$conforms()))), trace$8).flatMap((Function1 & Serializable)x$1 -> StreamingForm.handleByte$1$$anonfun$3$$anonfun$1(newFormState, newQueue, trace$8, state$3, BoxesRunTime.unboxToBoolean((Object)x$1)), trace$8), trace$8), trace$8, unsafe$6).getOrThrowFiberFailure(unsafe$6);
                    }
                    State state = state$3.withInNonStreamingPart(true);
                    return None$.MODULE$;
                }
                return None$.MODULE$;
            }
            if (formState3 instanceof FormState.BoundaryEncapsulated) {
                Chunk<FormAST> chunk;
                FormState.BoundaryEncapsulated boundaryEncapsulated = FormState$BoundaryEncapsulated$.MODULE$.unapply((FormState.BoundaryEncapsulated)formState3);
                Chunk<FormAST> ast = chunk = boundaryEncapsulated._1();
                return this.handleBoundary$1(state$3, buffer$5, ast);
            }
            if (formState3 instanceof FormState.BoundaryClosed) {
                Chunk<FormAST> chunk;
                FormState.BoundaryClosed boundaryClosed = FormState$BoundaryClosed$.MODULE$.unapply((FormState.BoundaryClosed)formState3);
                Chunk<FormAST> ast = chunk = boundaryClosed._1();
                return this.handleBoundary$1(state$3, buffer$5, ast);
            }
            throw new MatchError((Object)formState3);
        }
        return None$.MODULE$;
    }

    private static final boolean $anonfun$1$$anonfun$1(Chunk fields$1) {
        return fields$1.nonEmpty();
    }

    private static final ZIO streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(ZIO reader$1) {
        return reader$1;
    }

    private static final ZIO streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$3(Queue fieldQueue$3, Object trace$14) {
        return fieldQueue$3.offer((Object)new Take(Take$.MODULE$.end()), trace$14);
    }

    private static final boolean streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$4$$anonfun$1$$anonfun$1(Exit exit$1) {
        return exit$1.isFailure();
    }

    private static final Dequeue $anonfun$2(Queue fieldQueue$6) {
        return fieldQueue$6;
    }

    private static final int $anonfun$3() {
        return ZStream$.MODULE$.fromQueue$default$2();
    }

    private final ZIO streamFormFields$$anonfun$1(Object trace$2, boolean bufferUpToBoundary$1) {
        Unsafe unsafe = Unsafe$.MODULE$.unsafe();
        return ZIO$.MODULE$.runtime(trace$2).flatMap((Function1 & Serializable)runtime -> {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$2, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return new Buffer(this.bufferSize(), this.crlfBoundary(), bufferUpToBoundary$1);
            }).flatMap((Function1 & Serializable)buffer -> Promise$.MODULE$.make(trace$2).flatMap((Function1 & Serializable)abort -> Queue$.MODULE$.bounded(StreamingForm::streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1, trace$2).map((Function1 & Serializable)fieldQueue -> {
                State state = this.initialState();
                ZIO reader = this.source().runForeachChunk((Function1 & Serializable)bytes -> {
                    ChunkBuilder builder = Chunk$.MODULE$.newBuilder();
                    Iterator it = bytes.iterator();
                    boolean hasNext = it.hasNext();
                    while (hasNext) {
                        byte by = BoxesRunTime.unboxToByte((Object)it.next());
                        Option option = this.handleByte$1(state, (Buffer)buffer, (Runtime)runtime, trace$2, (Promise)abort, unsafe, by, !(hasNext = it.hasNext()));
                        if (!(option instanceof Some)) continue;
                        FormField field = (FormField)((Some)option).value();
                        builder.$plus$eq((Object)field);
                    }
                    Chunk fields = (Chunk)builder.result();
                    return fieldQueue.offer((Object)new Take(Take$.MODULE$.chunk(fields)), trace$2).when(() -> StreamingForm.$anonfun$1$$anonfun$1(fields), trace$2);
                }, trace$2);
                return Tuple3$.MODULE$.apply(fieldQueue, (Object)state, (Object)reader);
            }, trace$2).flatMap((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    Queue fieldQueue = (Queue)tuple3._1();
                    State state = (State)tuple3._2();
                    ZIO reader = (ZIO)tuple3._3();
                    return ZIO$.MODULE$.blocking(() -> StreamingForm.streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(reader), trace$2).catchAllCause((Function1 & Serializable)cause -> fieldQueue.offer((Object)new Take(Take$.MODULE$.failCause(cause)), trace$2), trace$2).ensuring(() -> StreamingForm.streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$3(fieldQueue, trace$2), trace$2).forkScoped(trace$2).interruptible(trace$2).flatMap((Function1 & Serializable)x$12 -> {
                        Fiber.Runtime runtime = x$12;
                        return Scope$.MODULE$.addFinalizerExit((Function1 & Serializable)exit -> abort.succeed((Object)BoxedUnit.UNIT, trace$2).when(() -> StreamingForm.streamFormFields$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$4$$anonfun$1$$anonfun$1(exit), trace$2), trace$2).map((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit;
                            BoxedUnit $1$ = boxedUnit = BoxedUnit.UNIT;
                            ZStream fieldStream = ZStream$.MODULE$.fromQueue(() -> StreamingForm.$anonfun$2(fieldQueue), StreamingForm::$anonfun$3, trace$2).flattenTake((.less.colon.less)$less$colon$less$.MODULE$.refl(), trace$2);
                            return Tuple2$.MODULE$.apply((Object)$1$, (Object)fieldStream);
                        }, trace$2).map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                ZStream fieldStream = (ZStream)tuple2._2();
                                return fieldStream;
                            }
                            throw new MatchError((Object)tuple2);
                        }, trace$2);
                    }, trace$2);
                }
                throw new MatchError((Object)tuple3);
            }, trace$2), trace$2), trace$2);
        }, trace$2);
    }

    public static final class Buffer {
        private final byte[] crlfBoundary;
        private final boolean bufferUpToBoundary;
        private byte[] buffer;
        private int index;
        private final int boundarySize;

        public Buffer(int bufferSize, byte[] crlfBoundary, boolean bufferUpToBoundary) {
            this.crlfBoundary = crlfBoundary;
            this.bufferUpToBoundary = bufferUpToBoundary;
            this.buffer = new byte[bufferSize];
            this.index = 0;
            this.boundarySize = crlfBoundary.length;
        }

        private void ensureHasCapacity(int requiredCapacity) {
            int l = this.buffer.length;
            if (l <= requiredCapacity) {
                byte[] newArray = new byte[this.calculateNewCapacity$1(l, requiredCapacity)];
                System.arraycopy(this.buffer, 0, newArray, 0, l);
                this.buffer = newArray;
                return;
            }
        }

        private boolean matchesPartialBoundary(int idx) {
            int bs = this.boundarySize;
            boolean result = false;
            for (int i = 0; i < bs && i <= idx && !result; ++i) {
                int i0 = idx - i;
                for (int i1 = 0; i >= i1 && this.buffer[i0 + i1] == this.crlfBoundary[i1] && !result; ++i1) {
                    if (i != i1) continue;
                    result = true;
                }
            }
            return result;
        }

        public Chunk<Exit> addByte(byte by, boolean isLastByte) {
            boolean foundFullBoundary;
            int idx = this.index++;
            this.ensureHasCapacity(idx + this.boundarySize + 1);
            this.buffer[idx] = by;
            boolean bl = foundFullBoundary = idx >= this.boundarySize - 1;
            for (int i = 0; i < this.boundarySize && foundFullBoundary; ++i) {
                if (this.buffer[idx + 1 - this.crlfBoundary.length + i] == this.crlfBoundary[i]) continue;
                foundFullBoundary = false;
            }
            if (foundFullBoundary) {
                this.reset();
                int toTake = idx + 1 - this.boundarySize;
                if (toTake == 0) {
                    return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Take[]{new Take(Take$.MODULE$.end())}));
                }
                Take[] takeArray = new Take[2];
                Object object = Predef$.MODULE$.byteArrayOps(this.buffer);
                takeArray[0] = new Take(Take$.MODULE$.chunk(Chunk$.MODULE$.fromArray(ArrayOps$.MODULE$.take$extension(object, toTake))));
                takeArray[1] = new Take(Take$.MODULE$.end());
                return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)takeArray));
            }
            if (!this.bufferUpToBoundary && isLastByte && by != 45 && !this.matchesPartialBoundary(idx)) {
                this.reset();
                Take[] takeArray = new Take[1];
                Object object = Predef$.MODULE$.byteArrayOps(this.buffer);
                takeArray[0] = new Take(Take$.MODULE$.chunk(Chunk$.MODULE$.fromArray(ArrayOps$.MODULE$.take$extension(object, idx + 1))));
                return Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)takeArray));
            }
            return Chunk$.MODULE$.empty();
        }

        public void reset() {
            this.index = 0;
        }

        private final int calculateNewCapacity$1(int existing, int required) {
            int newCap;
            while ((newCap = existing * 2) < required) {
                existing = newCap;
            }
            return newCap;
        }
    }

    public static final class State {
        private final FormState formState;
        private Option _currentQueue;
        private boolean _inNonStreamingPart;

        public State(FormState formState, Option<Queue<Exit>> _currentQueue, boolean _inNonStreamingPart) {
            this.formState = formState;
            this._currentQueue = _currentQueue;
            this._inNonStreamingPart = _inNonStreamingPart;
        }

        public FormState formState() {
            return this.formState;
        }

        private Option<Queue<Exit>> _currentQueue() {
            return this._currentQueue;
        }

        private void _currentQueue_$eq(Option<Queue<Exit>> x$0) {
            this._currentQueue = x$0;
        }

        private boolean _inNonStreamingPart() {
            return this._inNonStreamingPart;
        }

        private void _inNonStreamingPart_$eq(boolean x$0) {
            this._inNonStreamingPart = x$0;
        }

        public Option<Queue<Exit>> currentQueue() {
            return this._currentQueue();
        }

        public boolean inNonStreamingPart() {
            return this._inNonStreamingPart();
        }

        public State withCurrentQueue(Queue<Exit> queue) {
            this._currentQueue_$eq((Option<Queue<Exit>>)Some$.MODULE$.apply(queue));
            return this;
        }

        public State withInNonStreamingPart(boolean value) {
            this._inNonStreamingPart_$eq(value);
            return this;
        }

        public State reset() {
            this._currentQueue_$eq((Option<Queue<Exit>>)None$.MODULE$);
            this._inNonStreamingPart_$eq(false);
            this.formState().reset();
            return this;
        }
    }
}

