/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec;

import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NoStackTrace;
import zio.Cause;
import zio.Chunk;
import zio.http.Method;
import zio.http.Path;
import zio.http.Status;
import zio.http.codec.HttpCodecError$;
import zio.http.codec.HttpCodecError$CustomError$;
import zio.http.codec.HttpCodecError$InvalidEntity$;
import zio.http.codec.HttpCodecError$InvalidQueryParamCount$;
import zio.http.codec.HttpCodecError$MalformedBody$;
import zio.http.codec.HttpCodecError$MalformedHeader$;
import zio.http.codec.HttpCodecError$MalformedMethod$;
import zio.http.codec.HttpCodecError$MalformedPath$;
import zio.http.codec.HttpCodecError$MalformedQueryParam$;
import zio.http.codec.HttpCodecError$MalformedStatus$;
import zio.http.codec.HttpCodecError$MissingHeader$;
import zio.http.codec.HttpCodecError$MissingQueryParam$;
import zio.http.codec.HttpCodecError$MissingQueryParams$;
import zio.http.codec.HttpCodecError$PathTooShort$;
import zio.http.codec.HttpCodecError$UnsupportedContentType$;
import zio.http.codec.PathCodec;
import zio.http.codec.TextCodec;
import zio.schema.codec.DecodeError;
import zio.schema.validation.ValidationError;

public interface HttpCodecError
extends NoStackTrace,
Product,
Serializable {
    public static Option<HttpCodecError> asHttpCodecError(Cause<Object> cause) {
        return HttpCodecError$.MODULE$.asHttpCodecError(cause);
    }

    public static boolean isHttpCodecError(Cause<Object> cause) {
        return HttpCodecError$.MODULE$.isHttpCodecError(cause);
    }

    public static boolean isMissingDataOnly(Cause<Object> cause) {
        return HttpCodecError$.MODULE$.isMissingDataOnly(cause);
    }

    public static int ordinal(HttpCodecError httpCodecError) {
        return HttpCodecError$.MODULE$.ordinal(httpCodecError);
    }

    public static String getMessage$(HttpCodecError $this) {
        return $this.getMessage();
    }

    default public String getMessage() {
        return this.message();
    }

    public String message();

    public static final class CustomError
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String name;
        private final String message;

        public static CustomError apply(String string, String string2) {
            return HttpCodecError$CustomError$.MODULE$.apply(string, string2);
        }

        public static CustomError fromProduct(Product product) {
            return HttpCodecError$CustomError$.MODULE$.fromProduct(product);
        }

        public static CustomError unapply(CustomError customError) {
            return HttpCodecError$CustomError$.MODULE$.unapply(customError);
        }

        public CustomError(String name, String message) {
            this.name = name;
            this.message = message;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CustomError)) return false;
            CustomError customError = (CustomError)object;
            String string = this.name();
            String string2 = customError.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.message();
            String string4 = customError.message();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof CustomError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CustomError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "message";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        @Override
        public String message() {
            return this.message;
        }

        public CustomError copy(String name, String message) {
            return new CustomError(name, message);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.message();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.message();
        }
    }

    public static final class InvalidEntity
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String details;
        private final Chunk cause;

        public static InvalidEntity apply(String string, Chunk<ValidationError> chunk) {
            return HttpCodecError$InvalidEntity$.MODULE$.apply(string, chunk);
        }

        public static InvalidEntity fromProduct(Product product) {
            return HttpCodecError$InvalidEntity$.MODULE$.fromProduct(product);
        }

        public static InvalidEntity unapply(InvalidEntity invalidEntity) {
            return HttpCodecError$InvalidEntity$.MODULE$.unapply(invalidEntity);
        }

        public static InvalidEntity wrap(Chunk<ValidationError> chunk) {
            return HttpCodecError$InvalidEntity$.MODULE$.wrap(chunk);
        }

        public static Chunk<ValidationError> $lessinit$greater$default$2() {
            return HttpCodecError$InvalidEntity$.MODULE$.$lessinit$greater$default$2();
        }

        public InvalidEntity(String details, Chunk<ValidationError> cause) {
            this.details = details;
            this.cause = cause;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidEntity)) return false;
            InvalidEntity invalidEntity = (InvalidEntity)object;
            String string = this.details();
            String string2 = invalidEntity.details();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Chunk<ValidationError> chunk = this.cause();
            Chunk<ValidationError> chunk2 = invalidEntity.cause();
            if (chunk == null) {
                if (chunk2 == null) return true;
                return false;
            } else {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidEntity;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InvalidEntity";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "details";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String details() {
            return this.details;
        }

        public Chunk<ValidationError> cause() {
            return this.cause;
        }

        @Override
        public String message() {
            return new StringBuilder(40).append("A well-formed entity failed validation: ").append(this.details()).toString();
        }

        public InvalidEntity copy(String details, Chunk<ValidationError> cause) {
            return new InvalidEntity(details, cause);
        }

        public String copy$default$1() {
            return this.details();
        }

        public Chunk<ValidationError> copy$default$2() {
            return this.cause();
        }

        public String _1() {
            return this.details();
        }

        public Chunk<ValidationError> _2() {
            return this.cause();
        }
    }

    public static final class InvalidQueryParamCount
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String name;
        private final int expected;
        private final int actual;

        public static InvalidQueryParamCount apply(String string, int n, int n2) {
            return HttpCodecError$InvalidQueryParamCount$.MODULE$.apply(string, n, n2);
        }

        public static InvalidQueryParamCount fromProduct(Product product) {
            return HttpCodecError$InvalidQueryParamCount$.MODULE$.fromProduct(product);
        }

        public static InvalidQueryParamCount unapply(InvalidQueryParamCount invalidQueryParamCount) {
            return HttpCodecError$InvalidQueryParamCount$.MODULE$.unapply(invalidQueryParamCount);
        }

        public InvalidQueryParamCount(String name, int expected, int actual) {
            this.name = name;
            this.expected = expected;
            this.actual = actual;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.expected());
            n = Statics.mix((int)n, (int)this.actual());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidQueryParamCount)) return false;
            InvalidQueryParamCount invalidQueryParamCount = (InvalidQueryParamCount)object;
            if (this.expected() != invalidQueryParamCount.expected()) return false;
            if (this.actual() != invalidQueryParamCount.actual()) return false;
            String string = this.name();
            String string2 = invalidQueryParamCount.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidQueryParamCount;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "InvalidQueryParamCount";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "expected";
                }
                case 2: {
                    return "actual";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public int expected() {
            return this.expected;
        }

        public int actual() {
            return this.actual;
        }

        @Override
        public String message() {
            return new StringBuilder(57).append("Invalid query parameter count for ").append(this.name()).append(": expected ").append(this.expected()).append(" but found ").append(this.actual()).append(".").toString();
        }

        public InvalidQueryParamCount copy(String name, int expected, int actual) {
            return new InvalidQueryParamCount(name, expected, actual);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.expected();
        }

        public int copy$default$3() {
            return this.actual();
        }

        public String _1() {
            return this.name();
        }

        public int _2() {
            return this.expected();
        }

        public int _3() {
            return this.actual();
        }
    }

    public static final class MalformedBody
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String details;
        private final Option cause;

        public static MalformedBody apply(String string, Option<Throwable> option) {
            return HttpCodecError$MalformedBody$.MODULE$.apply(string, option);
        }

        public static MalformedBody fromProduct(Product product) {
            return HttpCodecError$MalformedBody$.MODULE$.fromProduct(product);
        }

        public static MalformedBody unapply(MalformedBody malformedBody) {
            return HttpCodecError$MalformedBody$.MODULE$.unapply(malformedBody);
        }

        public static Option<Throwable> $lessinit$greater$default$2() {
            return HttpCodecError$MalformedBody$.MODULE$.$lessinit$greater$default$2();
        }

        public MalformedBody(String details, Option<Throwable> cause) {
            this.details = details;
            this.cause = cause;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MalformedBody)) return false;
            MalformedBody malformedBody = (MalformedBody)object;
            String string = this.details();
            String string2 = malformedBody.details();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Throwable> option = this.cause();
            Option<Throwable> option2 = malformedBody.cause();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof MalformedBody;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MalformedBody";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "details";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String details() {
            return this.details;
        }

        public Option<Throwable> cause() {
            return this.cause;
        }

        @Override
        public String message() {
            return new StringBuilder(41).append("Malformed request body failed to decode: ").append(this.details()).toString();
        }

        public MalformedBody copy(String details, Option<Throwable> cause) {
            return new MalformedBody(details, cause);
        }

        public String copy$default$1() {
            return this.details();
        }

        public Option<Throwable> copy$default$2() {
            return this.cause();
        }

        public String _1() {
            return this.details();
        }

        public Option<Throwable> _2() {
            return this.cause();
        }
    }

    public static final class MalformedHeader
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String headerName;
        private final TextCodec textCodec;

        public static MalformedHeader apply(String string, TextCodec<?> textCodec) {
            return HttpCodecError$MalformedHeader$.MODULE$.apply(string, textCodec);
        }

        public static MalformedHeader fromProduct(Product product) {
            return HttpCodecError$MalformedHeader$.MODULE$.fromProduct(product);
        }

        public static MalformedHeader unapply(MalformedHeader malformedHeader) {
            return HttpCodecError$MalformedHeader$.MODULE$.unapply(malformedHeader);
        }

        public MalformedHeader(String headerName, TextCodec<?> textCodec) {
            this.headerName = headerName;
            this.textCodec = textCodec;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MalformedHeader)) return false;
            MalformedHeader malformedHeader = (MalformedHeader)object;
            String string = this.headerName();
            String string2 = malformedHeader.headerName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TextCodec<?> textCodec = this.textCodec();
            TextCodec<?> textCodec2 = malformedHeader.textCodec();
            if (textCodec == null) {
                if (textCodec2 == null) return true;
                return false;
            } else {
                if (!textCodec.equals(textCodec2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof MalformedHeader;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MalformedHeader";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "headerName";
            }
            if (1 == n2) {
                return "textCodec";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String headerName() {
            return this.headerName;
        }

        public TextCodec<?> textCodec() {
            return this.textCodec;
        }

        @Override
        public String message() {
            return new StringBuilder(41).append("Malformed header ").append(this.headerName()).append(" failed to decode using ").append(this.textCodec()).toString();
        }

        public MalformedHeader copy(String headerName, TextCodec<?> textCodec) {
            return new MalformedHeader(headerName, textCodec);
        }

        public String copy$default$1() {
            return this.headerName();
        }

        public TextCodec<?> copy$default$2() {
            return this.textCodec();
        }

        public String _1() {
            return this.headerName();
        }

        public TextCodec<?> _2() {
            return this.textCodec();
        }
    }

    public static final class MalformedMethod
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final Method expected;
        private final Method actual;

        public static MalformedMethod apply(Method method, Method method2) {
            return HttpCodecError$MalformedMethod$.MODULE$.apply(method, method2);
        }

        public static MalformedMethod fromProduct(Product product) {
            return HttpCodecError$MalformedMethod$.MODULE$.fromProduct(product);
        }

        public static MalformedMethod unapply(MalformedMethod malformedMethod) {
            return HttpCodecError$MalformedMethod$.MODULE$.unapply(malformedMethod);
        }

        public MalformedMethod(Method expected, Method actual) {
            this.expected = expected;
            this.actual = actual;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MalformedMethod)) return false;
            MalformedMethod malformedMethod = (MalformedMethod)object;
            Method method = this.expected();
            Method method2 = malformedMethod.expected();
            if (method == null) {
                if (method2 != null) {
                    return false;
                }
            } else if (!method.equals(method2)) return false;
            Method method3 = this.actual();
            Method method4 = malformedMethod.actual();
            if (method3 == null) {
                if (method4 == null) return true;
                return false;
            } else {
                if (!method3.equals(method4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof MalformedMethod;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MalformedMethod";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "expected";
            }
            if (1 == n2) {
                return "actual";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Method expected() {
            return this.expected;
        }

        public Method actual() {
            return this.actual;
        }

        @Override
        public String message() {
            return new StringBuilder(20).append("Expected ").append(this.expected()).append(" but found ").append(this.actual()).toString();
        }

        public MalformedMethod copy(Method expected, Method actual) {
            return new MalformedMethod(expected, actual);
        }

        public Method copy$default$1() {
            return this.expected();
        }

        public Method copy$default$2() {
            return this.actual();
        }

        public Method _1() {
            return this.expected();
        }

        public Method _2() {
            return this.actual();
        }
    }

    public static final class MalformedPath
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final Path path;
        private final PathCodec pathCodec;
        private final String error;

        public static MalformedPath apply(Path path, PathCodec<?> pathCodec, String string) {
            return HttpCodecError$MalformedPath$.MODULE$.apply(path, pathCodec, string);
        }

        public static MalformedPath fromProduct(Product product) {
            return HttpCodecError$MalformedPath$.MODULE$.fromProduct(product);
        }

        public static MalformedPath unapply(MalformedPath malformedPath) {
            return HttpCodecError$MalformedPath$.MODULE$.unapply(malformedPath);
        }

        public MalformedPath(Path path, PathCodec<?> pathCodec, String error) {
            this.path = path;
            this.pathCodec = pathCodec;
            this.error = error;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MalformedPath)) return false;
            MalformedPath malformedPath = (MalformedPath)object;
            Path path = this.path();
            Path path2 = malformedPath.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            PathCodec<?> pathCodec = this.pathCodec();
            PathCodec<?> pathCodec2 = malformedPath.pathCodec();
            if (pathCodec == null) {
                if (pathCodec2 != null) {
                    return false;
                }
            } else if (!pathCodec.equals(pathCodec2)) return false;
            String string = this.error();
            String string2 = malformedPath.error();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof MalformedPath;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MalformedPath";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "pathCodec";
                }
                case 2: {
                    return "error";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path path() {
            return this.path;
        }

        public PathCodec<?> pathCodec() {
            return this.pathCodec;
        }

        public String error() {
            return this.error;
        }

        @Override
        public String message() {
            return new StringBuilder(41).append("Malformed path ").append(this.path()).append(" failed to decode using ").append(this.pathCodec()).append(": ").append(this.error()).toString();
        }

        public MalformedPath copy(Path path, PathCodec<?> pathCodec, String error) {
            return new MalformedPath(path, pathCodec, error);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public PathCodec<?> copy$default$2() {
            return this.pathCodec();
        }

        public String copy$default$3() {
            return this.error();
        }

        public Path _1() {
            return this.path();
        }

        public PathCodec<?> _2() {
            return this.pathCodec();
        }

        public String _3() {
            return this.error();
        }
    }

    public static final class MalformedQueryParam
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String queryParamName;
        private final DecodeError cause;

        public static MalformedQueryParam apply(String string, DecodeError decodeError) {
            return HttpCodecError$MalformedQueryParam$.MODULE$.apply(string, decodeError);
        }

        public static MalformedQueryParam fromProduct(Product product) {
            return HttpCodecError$MalformedQueryParam$.MODULE$.fromProduct(product);
        }

        public static MalformedQueryParam unapply(MalformedQueryParam malformedQueryParam) {
            return HttpCodecError$MalformedQueryParam$.MODULE$.unapply(malformedQueryParam);
        }

        public MalformedQueryParam(String queryParamName, DecodeError cause) {
            this.queryParamName = queryParamName;
            this.cause = cause;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MalformedQueryParam)) return false;
            MalformedQueryParam malformedQueryParam = (MalformedQueryParam)object;
            String string = this.queryParamName();
            String string2 = malformedQueryParam.queryParamName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            DecodeError decodeError = this.cause();
            DecodeError decodeError2 = malformedQueryParam.cause();
            if (decodeError == null) {
                if (decodeError2 == null) return true;
                return false;
            } else {
                if (!decodeError.equals(decodeError2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof MalformedQueryParam;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MalformedQueryParam";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return (Serializable)this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "queryParamName";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String queryParamName() {
            return this.queryParamName;
        }

        public DecodeError cause() {
            return this.cause;
        }

        @Override
        public String message() {
            return new StringBuilder(49).append("Malformed query parameter ").append(this.queryParamName()).append(" could not be decoded: ").append(this.cause()).toString();
        }

        public MalformedQueryParam copy(String queryParamName, DecodeError cause) {
            return new MalformedQueryParam(queryParamName, cause);
        }

        public String copy$default$1() {
            return this.queryParamName();
        }

        public DecodeError copy$default$2() {
            return this.cause();
        }

        public String _1() {
            return this.queryParamName();
        }

        public DecodeError _2() {
            return this.cause();
        }
    }

    public static final class MalformedStatus
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final Status expected;
        private final Status actual;

        public static MalformedStatus apply(Status status, Status status2) {
            return HttpCodecError$MalformedStatus$.MODULE$.apply(status, status2);
        }

        public static MalformedStatus fromProduct(Product product) {
            return HttpCodecError$MalformedStatus$.MODULE$.fromProduct(product);
        }

        public static MalformedStatus unapply(MalformedStatus malformedStatus) {
            return HttpCodecError$MalformedStatus$.MODULE$.unapply(malformedStatus);
        }

        public MalformedStatus(Status expected, Status actual) {
            this.expected = expected;
            this.actual = actual;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MalformedStatus)) return false;
            MalformedStatus malformedStatus = (MalformedStatus)object;
            Status status = this.expected();
            Status status2 = malformedStatus.expected();
            if (status == null) {
                if (status2 != null) {
                    return false;
                }
            } else if (!status.equals(status2)) return false;
            Status status3 = this.actual();
            Status status4 = malformedStatus.actual();
            if (status3 == null) {
                if (status4 == null) return true;
                return false;
            } else {
                if (!status3.equals(status4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof MalformedStatus;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MalformedStatus";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "expected";
            }
            if (1 == n2) {
                return "actual";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Status expected() {
            return this.expected;
        }

        public Status actual() {
            return this.actual;
        }

        @Override
        public String message() {
            return new StringBuilder(32).append("Expected status code ").append(this.expected()).append(" but found ").append(this.actual()).toString();
        }

        public MalformedStatus copy(Status expected, Status actual) {
            return new MalformedStatus(expected, actual);
        }

        public Status copy$default$1() {
            return this.expected();
        }

        public Status copy$default$2() {
            return this.actual();
        }

        public Status _1() {
            return this.expected();
        }

        public Status _2() {
            return this.actual();
        }
    }

    public static final class MissingHeader
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String headerName;

        public static MissingHeader apply(String string) {
            return HttpCodecError$MissingHeader$.MODULE$.apply(string);
        }

        public static MissingHeader fromProduct(Product product) {
            return HttpCodecError$MissingHeader$.MODULE$.fromProduct(product);
        }

        public static MissingHeader unapply(MissingHeader missingHeader) {
            return HttpCodecError$MissingHeader$.MODULE$.unapply(missingHeader);
        }

        public MissingHeader(String headerName) {
            this.headerName = headerName;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingHeader)) return false;
            MissingHeader missingHeader = (MissingHeader)object;
            String string = this.headerName();
            String string2 = missingHeader.headerName();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingHeader;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MissingHeader";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "headerName";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String headerName() {
            return this.headerName;
        }

        @Override
        public String message() {
            return new StringBuilder(15).append("Missing header ").append(this.headerName()).toString();
        }

        public MissingHeader copy(String headerName) {
            return new MissingHeader(headerName);
        }

        public String copy$default$1() {
            return this.headerName();
        }

        public String _1() {
            return this.headerName();
        }
    }

    public static final class MissingQueryParam
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String queryParamName;

        public static MissingQueryParam apply(String string) {
            return HttpCodecError$MissingQueryParam$.MODULE$.apply(string);
        }

        public static MissingQueryParam fromProduct(Product product) {
            return HttpCodecError$MissingQueryParam$.MODULE$.fromProduct(product);
        }

        public static MissingQueryParam unapply(MissingQueryParam missingQueryParam) {
            return HttpCodecError$MissingQueryParam$.MODULE$.unapply(missingQueryParam);
        }

        public MissingQueryParam(String queryParamName) {
            this.queryParamName = queryParamName;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingQueryParam)) return false;
            MissingQueryParam missingQueryParam = (MissingQueryParam)object;
            String string = this.queryParamName();
            String string2 = missingQueryParam.queryParamName();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingQueryParam;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MissingQueryParam";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "queryParamName";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String queryParamName() {
            return this.queryParamName;
        }

        @Override
        public String message() {
            return new StringBuilder(24).append("Missing query parameter ").append(this.queryParamName()).toString();
        }

        public MissingQueryParam copy(String queryParamName) {
            return new MissingQueryParam(queryParamName);
        }

        public String copy$default$1() {
            return this.queryParamName();
        }

        public String _1() {
            return this.queryParamName();
        }
    }

    public static final class MissingQueryParams
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final Chunk queryParamNames;

        public static MissingQueryParams apply(Chunk<String> chunk) {
            return HttpCodecError$MissingQueryParams$.MODULE$.apply(chunk);
        }

        public static MissingQueryParams fromProduct(Product product) {
            return HttpCodecError$MissingQueryParams$.MODULE$.fromProduct(product);
        }

        public static MissingQueryParams unapply(MissingQueryParams missingQueryParams) {
            return HttpCodecError$MissingQueryParams$.MODULE$.unapply(missingQueryParams);
        }

        public MissingQueryParams(Chunk<String> queryParamNames) {
            this.queryParamNames = queryParamNames;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingQueryParams)) return false;
            MissingQueryParams missingQueryParams = (MissingQueryParams)object;
            Chunk<String> chunk = this.queryParamNames();
            Chunk<String> chunk2 = missingQueryParams.queryParamNames();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingQueryParams;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MissingQueryParams";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "queryParamNames";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<String> queryParamNames() {
            return this.queryParamNames;
        }

        @Override
        public String message() {
            return new StringBuilder(25).append("Missing query parameters ").append(this.queryParamNames().mkString(", ")).toString();
        }

        public MissingQueryParams copy(Chunk<String> queryParamNames) {
            return new MissingQueryParams(queryParamNames);
        }

        public Chunk<String> copy$default$1() {
            return this.queryParamNames();
        }

        public Chunk<String> _1() {
            return this.queryParamNames();
        }
    }

    public static final class PathTooShort
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final Path path;
        private final TextCodec textCodec;

        public static PathTooShort apply(Path path, TextCodec<?> textCodec) {
            return HttpCodecError$PathTooShort$.MODULE$.apply(path, textCodec);
        }

        public static PathTooShort fromProduct(Product product) {
            return HttpCodecError$PathTooShort$.MODULE$.fromProduct(product);
        }

        public static PathTooShort unapply(PathTooShort pathTooShort) {
            return HttpCodecError$PathTooShort$.MODULE$.unapply(pathTooShort);
        }

        public PathTooShort(Path path, TextCodec<?> textCodec) {
            this.path = path;
            this.textCodec = textCodec;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PathTooShort)) return false;
            PathTooShort pathTooShort = (PathTooShort)object;
            Path path = this.path();
            Path path2 = pathTooShort.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            TextCodec<?> textCodec = this.textCodec();
            TextCodec<?> textCodec2 = pathTooShort.textCodec();
            if (textCodec == null) {
                if (textCodec2 == null) return true;
                return false;
            } else {
                if (!textCodec.equals(textCodec2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof PathTooShort;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PathTooShort";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "textCodec";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path path() {
            return this.path;
        }

        public TextCodec<?> textCodec() {
            return this.textCodec;
        }

        @Override
        public String message() {
            return new StringBuilder(55).append("Expected to find ").append(this.textCodec()).append(" but found pre-mature end to the path ").append(this.path()).toString();
        }

        public PathTooShort copy(Path path, TextCodec<?> textCodec) {
            return new PathTooShort(path, textCodec);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public TextCodec<?> copy$default$2() {
            return this.textCodec();
        }

        public Path _1() {
            return this.path();
        }

        public TextCodec<?> _2() {
            return this.textCodec();
        }
    }

    public static final class UnsupportedContentType
    extends Exception
    implements NoStackTrace,
    Product,
    HttpCodecError {
        private final String contentType;

        public static UnsupportedContentType apply(String string) {
            return HttpCodecError$UnsupportedContentType$.MODULE$.apply(string);
        }

        public static UnsupportedContentType fromProduct(Product product) {
            return HttpCodecError$UnsupportedContentType$.MODULE$.fromProduct(product);
        }

        public static UnsupportedContentType unapply(UnsupportedContentType unsupportedContentType) {
            return HttpCodecError$UnsupportedContentType$.MODULE$.unapply(unsupportedContentType);
        }

        public UnsupportedContentType(String contentType) {
            this.contentType = contentType;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnsupportedContentType)) return false;
            UnsupportedContentType unsupportedContentType = (UnsupportedContentType)object;
            String string = this.contentType();
            String string2 = unsupportedContentType.contentType();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnsupportedContentType;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnsupportedContentType";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "contentType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String contentType() {
            return this.contentType;
        }

        @Override
        public String message() {
            return new StringBuilder(25).append("Unsupported content type ").append(this.contentType()).toString();
        }

        public UnsupportedContentType copy(String contentType) {
            return new UnsupportedContentType(contentType);
        }

        public String copy$default$1() {
            return this.contentType();
        }

        public String _1() {
            return this.contentType();
        }
    }
}

