/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Cause;
import zio.Exit;
import zio.Fiber;
import zio.FiberRef;
import zio.Runtime;
import zio.Unsafe;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.netty.NettyRuntime$;

public final class NettyRuntime {
    private final Runtime<Object> zioRuntime;
    private final Runtime.UnsafeAPI rtm;

    public static ZLayer<Object, Nothing$, NettyRuntime> live() {
        return NettyRuntime$.MODULE$.live();
    }

    public static Function0<BoxedUnit> noopEnsuring() {
        return NettyRuntime$.MODULE$.noopEnsuring();
    }

    public NettyRuntime(Runtime<Object> zioRuntime) {
        this.zioRuntime = zioRuntime;
        this.rtm = zioRuntime.unsafe();
    }

    public <A> A getRef(FiberRef<A> ref) {
        return (A)this.zioRuntime.fiberRefs().getOrDefault(ref);
    }

    public void run(ChannelHandlerContext ctx, Function0<BoxedUnit> ensured, boolean preferOnCurrentThread, ZIO<Object, Throwable, Object> program, Unsafe unsafe, Object trace) {
        Object forkOrExit = preferOnCurrentThread ? ((Runtime.UnsafeAPI3)this.rtm).runOrFork(program, trace, unsafe) : package$.MODULE$.Left().apply((Object)this.rtm.fork(program, trace, unsafe));
        Either either = forkOrExit;
        if (either instanceof Left) {
            Fiber.Runtime fiber = (Fiber.Runtime)((Left)either).value();
            GenericFutureListener<Future<? super Void>> close = this.closeListener(fiber, unsafe, trace);
            ctx.channel().closeFuture().addListener(close);
            fiber.unsafe().addObserver((Function1)(JProcedure1 & Serializable)exit -> {
                NettyRuntime.removeListener$1(ctx, close);
                NettyRuntime.onExit$1(ensured, ctx, exit);
            }, unsafe);
            return;
        }
        if (either instanceof Right) {
            Exit exit2 = (Exit)((Right)either).value();
            NettyRuntime.onExit$1(ensured, ctx, exit2);
            return;
        }
        throw new MatchError((Object)either);
    }

    public <A> A unsafeRunSync(ZIO<Object, Throwable, A> program, Unsafe unsafe, Object trace) throws Throwable {
        return (A)this.rtm.run(program, trace, unsafe).getOrThrowFiberFailure(unsafe);
    }

    private GenericFutureListener<Future<? super Void>> closeListener(Fiber.Runtime<?, ?> fiber, Unsafe unsafe, Object trace) {
        return _$1 -> this.unsafeRunSync(ZIO$.MODULE$.fiberIdWith((Function1 & Serializable)fiberId -> fiber.interruptAsFork(fiberId, trace), trace), unsafe, trace);
    }

    private static final Option onExit$1$$anonfun$1(Cause cause$1) {
        return cause$1.dieOption();
    }

    private static final void onExit$1(Function0 ensured$1, ChannelHandlerContext ctx$1, Exit exit) {
        ensured$1.apply$mcV$sp();
        Exit exit2 = exit;
        if (exit2 instanceof Exit.Success) {
            Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit2);
            Object object = success._1();
            return;
        }
        if (exit2 instanceof Exit.Failure) {
            BoxedUnit boxedUnit;
            Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit2);
            Cause cause = failure._1();
            Cause cause2 = cause;
            Option option = cause2.failureOption().orElse(() -> NettyRuntime.onExit$1$$anonfun$1(cause2));
            if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                Throwable error = (Throwable)((Some)option).value();
                boxedUnit = ctx$1.fireExceptionCaught(error);
            } else {
                throw new MatchError((Object)option);
            }
            if (ctx$1.channel().isOpen()) {
                ctx$1.close();
                return;
            }
            return;
        }
        throw new MatchError((Object)exit2);
    }

    private static final void removeListener$1(ChannelHandlerContext ctx$2, GenericFutureListener close) {
        ctx$2.channel().closeFuture().removeListener(close);
    }
}

