/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.runtime.function.JProcedure1;
import zio.Exit$;
import zio.Promise;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.http.Request;
import zio.http.Response;
import zio.http.internal.ChannelState;
import zio.http.netty.NettyBodyWriter$;
import zio.http.netty.NettyResponse$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.NettyRuntime$;
import zio.http.netty.client.ClientInboundHandler$SendRequest$;

public final class ClientInboundHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final NettyRuntime rtm;
    private final Request req;
    private final HttpRequest jReq;
    private final Promise<Throwable, Response> onResponse;
    private final Promise<Throwable, ChannelState> onComplete;
    private final boolean enableKeepAlive;
    private final Object trace;
    private final Unsafe unsafeClass;

    public ClientInboundHandler(NettyRuntime rtm, Request req, HttpRequest jReq, Promise<Throwable, Response> onResponse, Promise<Throwable, ChannelState> onComplete, boolean enableKeepAlive, Object trace) {
        this.rtm = rtm;
        this.req = req;
        this.jReq = jReq;
        this.onResponse = onResponse;
        this.onComplete = onComplete;
        this.enableKeepAlive = enableKeepAlive;
        this.trace = trace;
        super(false);
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (ClientInboundHandler$SendRequest$.MODULE$.equals(object)) {
            this.sendRequest(ctx);
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void sendRequest(ChannelHandlerContext ctx) {
        HttpRequest httpRequest = this.jReq;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest fullRequest = (FullHttpRequest)httpRequest;
            ctx.writeAndFlush((Object)fullRequest);
            return;
        }
        if (httpRequest != null) {
            ctx.write((Object)this.jReq);
            NettyBodyWriter$.MODULE$.writeAndFlush(this.req.body(), (Option<Object>)None$.MODULE$, ctx, this.trace).foreach((Function1)(JProcedure1 & Serializable)effect -> this.rtm.run(ctx, NettyRuntime$.MODULE$.noopEnsuring(), true, (ZIO<Object, Throwable, Object>)effect, Unsafe$.MODULE$.unsafe(), this.trace));
            return;
        }
        throw new MatchError((Object)httpRequest);
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        HttpObject httpObject = msg;
        if (httpObject instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)httpObject;
            boolean keepAlive = this.enableKeepAlive && HttpUtil.isKeepAlive((HttpMessage)response);
            Response resp = NettyResponse$.MODULE$.make(ctx, response, this.onComplete, keepAlive, this.unsafeClass, this.trace);
            this.onResponse.unsafe().done((ZIO)Exit$.MODULE$.succeed((Object)resp), this.unsafeClass);
            return;
        }
        if (httpObject instanceof HttpContent) {
            HttpContent content = (HttpContent)httpObject;
            ctx.fireChannelRead((Object)content);
            return;
        }
        HttpObject err = httpObject;
        throw new IllegalStateException(new StringBuilder(32).append("Client unexpected message type: ").append(err).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        ctx.fireExceptionCaught(error);
    }
}

