/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Chunk;
import zio.Chunk$;
import zio.Clock$;
import zio.Config;
import zio.FiberId;
import zio.NonEmptyChunk;
import zio.Promise;
import zio.Ref;
import zio.Scope;
import zio.Semaphore;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.DnsResolver;
import zio.http.DnsResolver$;
import zio.http.DnsResolver$CacheEntry$;
import zio.http.DnsResolver$CachePatch$;
import zio.http.DnsResolver$CachePatch$Remove$;
import zio.http.DnsResolver$CachePatch$Update$;
import zio.http.DnsResolver$CachingResolver$;
import zio.http.DnsResolver$Config$;
import zio.http.DnsResolver$ExpireAction$;
import zio.http.DnsResolver$ExpireAction$Refresh$;
import zio.http.DnsResolver$SystemResolver$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public interface DnsResolver {
    public static ZLayer<Object, Config.Error, DnsResolver> configured(NonEmptyChunk<String> nonEmptyChunk, Object object) {
        return DnsResolver$.MODULE$.configured(nonEmptyChunk, object);
    }

    public static ZLayer<Object, Nothing$, DnsResolver> default() {
        return DnsResolver$.MODULE$.default();
    }

    public static ZLayer<Object, Nothing$, DnsResolver> explicit(Duration duration, Duration duration2, int n, int n2, ExpireAction expireAction, Duration duration3, DnsResolver dnsResolver) {
        return DnsResolver$.MODULE$.explicit(duration, duration2, n, n2, expireAction, duration3, dnsResolver);
    }

    public static ZLayer<Config, Nothing$, DnsResolver> live() {
        return DnsResolver$.MODULE$.live();
    }

    public static ZIO<DnsResolver, Nothing$, Map<String, CacheEntry>> snapshot(Object object) {
        return DnsResolver$.MODULE$.snapshot(object);
    }

    public static ZLayer<Object, Nothing$, DnsResolver> system() {
        return DnsResolver$.MODULE$.system();
    }

    public static NonEmptyChunk<String> configured$default$1() {
        return DnsResolver$.MODULE$.configured$default$1();
    }

    public static Duration explicit$default$1() {
        return DnsResolver$.MODULE$.explicit$default$1();
    }

    public static Duration explicit$default$2() {
        return DnsResolver$.MODULE$.explicit$default$2();
    }

    public static int explicit$default$3() {
        return DnsResolver$.MODULE$.explicit$default$3();
    }

    public static int explicit$default$4() {
        return DnsResolver$.MODULE$.explicit$default$4();
    }

    public static ExpireAction explicit$default$5() {
        return DnsResolver$.MODULE$.explicit$default$5();
    }

    public static Duration explicit$default$6() {
        return DnsResolver$.MODULE$.explicit$default$6();
    }

    public static DnsResolver explicit$default$7() {
        return DnsResolver$.MODULE$.explicit$default$7();
    }

    public ZIO<Object, UnknownHostException, Chunk<InetAddress>> resolve(String var1, Object var2);

    public static final class CacheEntry
    implements Product,
    Serializable {
        private final Promise resolvedAddresses;
        private final Option previousAddresses;
        private final Instant lastUpdatedAt;

        public static CacheEntry apply(Promise<UnknownHostException, Chunk<InetAddress>> promise, Option<Chunk<InetAddress>> option, Instant instant) {
            return DnsResolver$CacheEntry$.MODULE$.apply(promise, option, instant);
        }

        public static CacheEntry fromProduct(Product product) {
            return DnsResolver$CacheEntry$.MODULE$.fromProduct(product);
        }

        public static CacheEntry unapply(CacheEntry cacheEntry) {
            return DnsResolver$CacheEntry$.MODULE$.unapply(cacheEntry);
        }

        public CacheEntry(Promise<UnknownHostException, Chunk<InetAddress>> resolvedAddresses, Option<Chunk<InetAddress>> previousAddresses, Instant lastUpdatedAt) {
            this.resolvedAddresses = resolvedAddresses;
            this.previousAddresses = previousAddresses;
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CacheEntry)) return false;
            CacheEntry cacheEntry = (CacheEntry)object;
            Promise<UnknownHostException, Chunk<InetAddress>> promise = this.resolvedAddresses();
            Promise<UnknownHostException, Chunk<InetAddress>> promise2 = cacheEntry.resolvedAddresses();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            Option<Chunk<InetAddress>> option = this.previousAddresses();
            Option<Chunk<InetAddress>> option2 = cacheEntry.previousAddresses();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Instant instant = this.lastUpdatedAt();
            Instant instant2 = cacheEntry.lastUpdatedAt();
            if (instant == null) {
                if (instant2 == null) return true;
                return false;
            } else {
                if (!((Object)instant).equals(instant2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CacheEntry;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "CacheEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "resolvedAddresses";
                }
                case 1: {
                    return "previousAddresses";
                }
                case 2: {
                    return "lastUpdatedAt";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<UnknownHostException, Chunk<InetAddress>> resolvedAddresses() {
            return this.resolvedAddresses;
        }

        public Option<Chunk<InetAddress>> previousAddresses() {
            return this.previousAddresses;
        }

        public Instant lastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public CacheEntry copy(Promise<UnknownHostException, Chunk<InetAddress>> resolvedAddresses, Option<Chunk<InetAddress>> previousAddresses, Instant lastUpdatedAt) {
            return new CacheEntry(resolvedAddresses, previousAddresses, lastUpdatedAt);
        }

        public Promise<UnknownHostException, Chunk<InetAddress>> copy$default$1() {
            return this.resolvedAddresses();
        }

        public Option<Chunk<InetAddress>> copy$default$2() {
            return this.previousAddresses();
        }

        public Instant copy$default$3() {
            return this.lastUpdatedAt();
        }

        public Promise<UnknownHostException, Chunk<InetAddress>> _1() {
            return this.resolvedAddresses();
        }

        public Option<Chunk<InetAddress>> _2() {
            return this.previousAddresses();
        }

        public Instant _3() {
            return this.lastUpdatedAt();
        }
    }

    public static interface CachePatch {
        public static int ordinal(CachePatch cachePatch) {
            return DnsResolver$CachePatch$.MODULE$.ordinal(cachePatch);
        }
    }

    public static class CachingResolver
    implements DnsResolver {
        private final DnsResolver resolver;
        private final Duration ttl;
        private final Duration unknownHostTtl;
        private final int maxCount;
        private final ExpireAction expireAction;
        private final Semaphore semaphore;
        private final Ref<Map<String, CacheEntry>> entries;

        public static ZIO<Scope, Nothing$, DnsResolver> make(DnsResolver dnsResolver, Duration duration, Duration duration2, int n, int n2, ExpireAction expireAction, Duration duration3, Object object) {
            return DnsResolver$CachingResolver$.MODULE$.make(dnsResolver, duration, duration2, n, n2, expireAction, duration3, object);
        }

        public CachingResolver(DnsResolver resolver, Duration ttl, Duration unknownHostTtl, int maxCount, ExpireAction expireAction, Semaphore semaphore, Ref<Map<String, CacheEntry>> entries) {
            this.resolver = resolver;
            this.ttl = ttl;
            this.unknownHostTtl = unknownHostTtl;
            this.maxCount = maxCount;
            this.expireAction = expireAction;
            this.semaphore = semaphore;
            this.entries = entries;
        }

        @Override
        public ZIO<Object, UnknownHostException, Chunk<InetAddress>> resolve(String host, Object trace) {
            return Clock$.MODULE$.instant(trace).flatMap((Function1 & Serializable)now -> ZIO$.MODULE$.fiberId(trace).flatMap((Function1 & Serializable)fiberId -> this.entries.modify((Function1 & Serializable)entries -> {
                Option option = entries.get((Object)host);
                if (option instanceof Some) {
                    CacheEntry entry = (CacheEntry)((Some)option).value();
                    Option<Chunk<InetAddress>> option2 = entry.previousAddresses();
                    if (option2 instanceof Some) {
                        Chunk previous = (Chunk)((Some)option2).value();
                        Function0 function0 = ZIO$.MODULE$.ifZIO(() -> this.resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(entry, trace));
                        return Tuple2$.MODULE$.apply((Object)ZIO.IfZIO$.MODULE$.apply$extension(function0, () -> this.resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$2(entry, trace), () -> this.resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$3(trace, previous), trace), entries);
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return Tuple2$.MODULE$.apply((Object)entry.resolvedAddresses().await(trace), entries);
                    }
                    throw new MatchError(option2);
                }
                if (None$.MODULE$.equals(option)) {
                    Promise newPromise = Promise.unsafe$.MODULE$.make((FiberId)fiberId, Unsafe$.MODULE$.unsafe());
                    return Tuple2$.MODULE$.apply((Object)this.startResolvingHost(host, (Promise<UnknownHostException, Chunk<InetAddress>>)newPromise, trace).zipRight(() -> this.resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$4(newPromise, trace), trace), (Object)entries.updated((Object)host, (Object)DnsResolver$CacheEntry$.MODULE$.apply((Promise<UnknownHostException, Chunk<InetAddress>>)newPromise, (Option<Chunk<InetAddress>>)None$.MODULE$, (Instant)now)));
                }
                throw new MatchError((Object)option);
            }, trace).flatMap((Function1 & Serializable)getResult -> getResult.map((Function1 & Serializable)result -> result, trace), trace), trace), trace);
        }

        @Override
        public ZIO<DnsResolver, Nothing$, Map<String, CacheEntry>> snapshot(Object trace) {
            return this.entries.get(trace);
        }

        private ZIO<Object, Nothing$, BoxedUnit> startResolvingHost(String host, Promise<UnknownHostException, Chunk<InetAddress>> targetPromise, Object trace) {
            return this.semaphore.withPermit(this.resolver.resolve(host, trace).intoPromise(() -> this.startResolvingHost$$anonfun$1(targetPromise), trace), trace).fork(trace).unit(trace);
        }

        public ZIO<Object, Nothing$, BoxedUnit> zio$http$DnsResolver$CachingResolver$$refreshAndCleanup(Object trace) {
            return ZIO$.MODULE$.fiberId(trace).flatMap((Function1 & Serializable)fiberId -> this.entries.get(trace).flatMap((Function1 & Serializable)snapshot -> this.refreshOrDropEntries((FiberId)fiberId, (Map<String, CacheEntry>)snapshot, trace).flatMap((Function1 & Serializable)refreshPatches -> this.ensureMaxSize(this.applyPatches((Map<String, CacheEntry>)snapshot, (Chunk<CachePatch>)refreshPatches), trace).flatMap((Function1 & Serializable)sizeControlPatches -> this.entries.update((Function1 & Serializable)_$2 -> this.applyPatches((Map<String, CacheEntry>)_$2, (Chunk<CachePatch>)refreshPatches.$plus$plus(sizeControlPatches)), trace).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }, trace), trace), trace), trace), trace);
        }

        private ZIO<Object, Nothing$, Chunk<CachePatch>> refreshOrDropEntries(FiberId fiberId, Map<String, CacheEntry> entries, Object trace) {
            return Clock$.MODULE$.instant(trace).flatMap((Function1 & Serializable)now -> ZIO$.MODULE$.foreach((Iterable)Chunk$.MODULE$.fromIterable((Iterable)entries), (Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    CacheEntry entry = (CacheEntry)tuple2._2();
                    return entry.resolvedAddresses().poll(trace).flatMap((Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            ZIO getResolvedAddresses = (ZIO)((Some)option).value();
                            return getResolvedAddresses.foldZIO((Function1 & Serializable)_$3 -> {
                                if (entry.lastUpdatedAt().plus(this.unknownHostTtl).isBefore((Instant)now)) {
                                    ExpireAction expireAction = this.expireAction;
                                    DnsResolver$ExpireAction$Refresh$ dnsResolver$ExpireAction$Refresh$ = DnsResolver$ExpireAction$Refresh$.MODULE$;
                                    if (!(expireAction != null ? !expireAction.equals(dnsResolver$ExpireAction$Refresh$) : dnsResolver$ExpireAction$Refresh$ != null)) {
                                        CacheEntry newEntry = DnsResolver$CacheEntry$.MODULE$.apply((Promise<UnknownHostException, Chunk<InetAddress>>)Promise.unsafe$.MODULE$.make(fiberId, Unsafe$.MODULE$.unsafe()), (Option<Chunk<InetAddress>>)None$.MODULE$, (Instant)now);
                                        return this.startResolvingHost(host, newEntry.resolvedAddresses(), trace).as(() -> this.refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(host, newEntry), trace);
                                    }
                                    return ZIO$.MODULE$.some(() -> this.refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(host), trace);
                                }
                                return ZIO$.MODULE$.none();
                            }, (Function1 & Serializable)addresses -> {
                                if (entry.lastUpdatedAt().plus(this.ttl).isBefore((Instant)now)) {
                                    ExpireAction expireAction = this.expireAction;
                                    DnsResolver$ExpireAction$Refresh$ dnsResolver$ExpireAction$Refresh$ = DnsResolver$ExpireAction$Refresh$.MODULE$;
                                    if (!(expireAction != null ? !expireAction.equals(dnsResolver$ExpireAction$Refresh$) : dnsResolver$ExpireAction$Refresh$ != null)) {
                                        CacheEntry newEntry = DnsResolver$CacheEntry$.MODULE$.apply((Promise<UnknownHostException, Chunk<InetAddress>>)Promise.unsafe$.MODULE$.make(fiberId, Unsafe$.MODULE$.unsafe()), (Option<Chunk<InetAddress>>)Some$.MODULE$.apply(addresses), (Instant)now);
                                        return this.startResolvingHost(host, newEntry.resolvedAddresses(), trace).as(() -> this.refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(host, newEntry), trace);
                                    }
                                    return ZIO$.MODULE$.some(() -> this.refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(host), trace);
                                }
                                return ZIO$.MODULE$.none();
                            }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace);
                        }
                        if (None$.MODULE$.equals(option)) {
                            return ZIO$.MODULE$.none();
                        }
                        throw new MatchError((Object)option);
                    }, trace);
                }
                throw new MatchError((Object)tuple2);
            }, BuildFrom$.MODULE$.buildFromIterableOps(), trace).map((Function1 & Serializable)_$4 -> _$4.flatten(Predef$.MODULE$.$conforms()), trace), trace);
        }

        private ZIO<Object, Nothing$, Chunk<CachePatch>> ensureMaxSize(Map<String, CacheEntry> entries, Object trace) {
            if (entries.size() > this.maxCount) {
                Chunk toDrop = ((Chunk)Chunk$.MODULE$.fromIterable(entries).sortBy((Function1 & Serializable)_$5 -> ((CacheEntry)_$5._2()).lastUpdatedAt(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).take(entries.size() - this.maxCount);
                return ZIO$.MODULE$.foreach((Iterable)toDrop, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String host = (String)tuple2._1();
                        CacheEntry entry = (CacheEntry)tuple2._2();
                        return entry.resolvedAddresses().interrupt(trace).as(() -> this.ensureMaxSize$$anonfun$1$$anonfun$1(host), trace);
                    }
                    throw new MatchError((Object)tuple2);
                }, BuildFrom$.MODULE$.buildFromIterableOps(), trace);
            }
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return Chunk$.MODULE$.empty();
            });
        }

        private Map<String, CacheEntry> applyPatches(Map<String, CacheEntry> entries, Chunk<CachePatch> patches) {
            return (Map)patches.foldLeft(entries, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Map entries = (Map)tuple2._1();
                    CachePatch patch = (CachePatch)tuple2._2();
                    CachePatch cachePatch = patch;
                    if (cachePatch instanceof CachePatch.Remove) {
                        String string;
                        CachePatch.Remove remove = DnsResolver$CachePatch$Remove$.MODULE$.unapply((CachePatch.Remove)cachePatch);
                        String host = string = remove._1();
                        return (Map)entries.$minus((Object)host);
                    }
                    if (cachePatch instanceof CachePatch.Update) {
                        CachePatch.Update update = DnsResolver$CachePatch$Update$.MODULE$.unapply((CachePatch.Update)cachePatch);
                        String string = update._1();
                        CacheEntry cacheEntry = update._2();
                        String host = string;
                        CacheEntry updatedEntry = cacheEntry;
                        return (Map)entries.updated((Object)host, (Object)updatedEntry);
                    }
                    throw new MatchError((Object)cachePatch);
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private final ZIO resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(CacheEntry entry$1, Object trace$7) {
            return entry$1.resolvedAddresses().isDone(trace$7);
        }

        private final ZIO resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$2(CacheEntry entry$2, Object trace$8) {
            return entry$2.resolvedAddresses().await(trace$8);
        }

        private final ZIO resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$3(Object trace$9, Chunk previous$1) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$9, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return previous$1;
            });
        }

        private final ZIO resolve$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$4(Promise newPromise$1, Object trace$10) {
            return newPromise$1.await(trace$10);
        }

        private final Promise startResolvingHost$$anonfun$1(Promise targetPromise$1) {
            return targetPromise$1;
        }

        private final Some refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String host$8, CacheEntry newEntry$1) {
            return Some$.MODULE$.apply((Object)DnsResolver$CachePatch$Update$.MODULE$.apply(host$8, newEntry$1));
        }

        private final CachePatch.Remove refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(String host$9) {
            return DnsResolver$CachePatch$Remove$.MODULE$.apply(host$9);
        }

        private final Some refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(String host$11, CacheEntry newEntry$2) {
            return Some$.MODULE$.apply((Object)DnsResolver$CachePatch$Update$.MODULE$.apply(host$11, newEntry$2));
        }

        private final CachePatch.Remove refreshOrDropEntries$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(String host$12) {
            return DnsResolver$CachePatch$Remove$.MODULE$.apply(host$12);
        }

        private final CachePatch.Remove ensureMaxSize$$anonfun$1$$anonfun$1(String host$13) {
            return DnsResolver$CachePatch$Remove$.MODULE$.apply(host$13);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Config
    implements Product,
    Serializable {
        private final Duration ttl;
        private final Duration unknownHostTtl;
        private final int maxCount;
        private final int maxConcurrentResolutions;
        private final ExpireAction expireAction;
        private final Duration refreshRate;

        public static Config apply(Duration duration, Duration duration2, int n, int n2, ExpireAction expireAction, Duration duration3) {
            return DnsResolver$Config$.MODULE$.apply(duration, duration2, n, n2, expireAction, duration3);
        }

        public static zio.Config<Config> config() {
            return DnsResolver$Config$.MODULE$.config();
        }

        public static Config default() {
            return DnsResolver$Config$.MODULE$.default();
        }

        public static Config fromProduct(Product product) {
            return DnsResolver$Config$.MODULE$.fromProduct(product);
        }

        public static Config unapply(Config config) {
            return DnsResolver$Config$.MODULE$.unapply(config);
        }

        public Config(Duration ttl, Duration unknownHostTtl, int maxCount, int maxConcurrentResolutions, ExpireAction expireAction, Duration refreshRate) {
            this.ttl = ttl;
            this.unknownHostTtl = unknownHostTtl;
            this.maxCount = maxCount;
            this.maxConcurrentResolutions = maxConcurrentResolutions;
            this.expireAction = expireAction;
            this.refreshRate = refreshRate;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ttl()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.unknownHostTtl()));
            n = Statics.mix((int)n, (int)this.maxCount());
            n = Statics.mix((int)n, (int)this.maxConcurrentResolutions());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.expireAction()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.refreshRate()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Config)) return false;
            Config config = (Config)object;
            if (this.maxCount() != config.maxCount()) return false;
            if (this.maxConcurrentResolutions() != config.maxConcurrentResolutions()) return false;
            Duration duration = this.ttl();
            Duration duration2 = config.ttl();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!((Object)duration).equals(duration2)) return false;
            Duration duration3 = this.unknownHostTtl();
            Duration duration4 = config.unknownHostTtl();
            if (duration3 == null) {
                if (duration4 != null) {
                    return false;
                }
            } else if (!((Object)duration3).equals(duration4)) return false;
            ExpireAction expireAction = this.expireAction();
            ExpireAction expireAction2 = config.expireAction();
            if (expireAction == null) {
                if (expireAction2 != null) {
                    return false;
                }
            } else if (!expireAction.equals(expireAction2)) return false;
            Duration duration5 = this.refreshRate();
            Duration duration6 = config.refreshRate();
            if (duration5 == null) {
                if (duration6 == null) return true;
                return false;
            } else {
                if (!((Object)duration5).equals(duration6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Config;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Config";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "ttl";
                }
                case 1: {
                    return "unknownHostTtl";
                }
                case 2: {
                    return "maxCount";
                }
                case 3: {
                    return "maxConcurrentResolutions";
                }
                case 4: {
                    return "expireAction";
                }
                case 5: {
                    return "refreshRate";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Duration ttl() {
            return this.ttl;
        }

        public Duration unknownHostTtl() {
            return this.unknownHostTtl;
        }

        public int maxCount() {
            return this.maxCount;
        }

        public int maxConcurrentResolutions() {
            return this.maxConcurrentResolutions;
        }

        public ExpireAction expireAction() {
            return this.expireAction;
        }

        public Duration refreshRate() {
            return this.refreshRate;
        }

        public Config copy(Duration ttl, Duration unknownHostTtl, int maxCount, int maxConcurrentResolutions, ExpireAction expireAction, Duration refreshRate) {
            return new Config(ttl, unknownHostTtl, maxCount, maxConcurrentResolutions, expireAction, refreshRate);
        }

        public Duration copy$default$1() {
            return this.ttl();
        }

        public Duration copy$default$2() {
            return this.unknownHostTtl();
        }

        public int copy$default$3() {
            return this.maxCount();
        }

        public int copy$default$4() {
            return this.maxConcurrentResolutions();
        }

        public ExpireAction copy$default$5() {
            return this.expireAction();
        }

        public Duration copy$default$6() {
            return this.refreshRate();
        }

        public Duration _1() {
            return this.ttl();
        }

        public Duration _2() {
            return this.unknownHostTtl();
        }

        public int _3() {
            return this.maxCount();
        }

        public int _4() {
            return this.maxConcurrentResolutions();
        }

        public ExpireAction _5() {
            return this.expireAction();
        }

        public Duration _6() {
            return this.refreshRate();
        }
    }

    public static interface ExpireAction {
        public static zio.Config<ExpireAction> config() {
            return DnsResolver$ExpireAction$.MODULE$.config();
        }

        public static int ordinal(ExpireAction expireAction) {
            return DnsResolver$ExpireAction$.MODULE$.ordinal(expireAction);
        }
    }

    public static final class SystemResolver
    implements DnsResolver,
    Product,
    Serializable {
        public static SystemResolver apply() {
            return DnsResolver$SystemResolver$.MODULE$.apply();
        }

        public static SystemResolver fromProduct(Product product) {
            return DnsResolver$SystemResolver$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(SystemResolver systemResolver) {
            return DnsResolver$SystemResolver$.MODULE$.unapply(systemResolver);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SystemResolver)) return false;
            SystemResolver systemResolver = (SystemResolver)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SystemResolver;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "SystemResolver";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ZIO<Object, UnknownHostException, Chunk<InetAddress>> resolve(String host, Object trace) {
            ZIO zIO = ZIO$.MODULE$.ZioRefineToOrDieOps(ZIO$.MODULE$.attemptBlocking((Function1 & Serializable)evidence$1 -> InetAddress.getAllByName(host), trace));
            return ZIO.ZioRefineToOrDieOps$.MODULE$.refineToOrDie$extension(zIO, ClassTag$.MODULE$.apply(UnknownHostException.class), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace).map((Function1 & Serializable)array -> Chunk$.MODULE$.fromArray(array), trace);
        }

        public SystemResolver copy() {
            return new SystemResolver();
        }
    }
}

