/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.time.Duration;
import java.time.Instant;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import zio.CanFail$;
import zio.Chunk$;
import zio.Clock$;
import zio.Config;
import zio.Console$;
import zio.Exit$;
import zio.IsSubtypeOfError$;
import zio.LogAnnotation;
import zio.LogAnnotation$;
import zio.LogLevel;
import zio.LogLevel$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.Zippable$;
import zio.http.Body;
import zio.http.Cookie;
import zio.http.Credentials;
import zio.http.Credentials$;
import zio.http.Handler;
import zio.http.Handler$;
import zio.http.Handler$FromFunction$;
import zio.http.Handler$FromFunctionExit$;
import zio.http.Handler$FromFunctionZIO$;
import zio.http.HandlerAspect;
import zio.http.HandlerAspect$;
import zio.http.HandlerAspect$InterceptPatch$;
import zio.http.HandlerAspect$InterceptPatchZIO$;
import zio.http.Header;
import zio.http.Header$Authorization$;
import zio.http.Header$Authorization$Basic$;
import zio.http.Header$Authorization$Bearer$;
import zio.http.Header$Custom$;
import zio.http.Header$SetCookie$;
import zio.http.Header$WWWAuthenticate$Basic$;
import zio.http.Header$WWWAuthenticate$Bearer$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.Method;
import zio.http.Path;
import zio.http.ProtocolStack;
import zio.http.ProtocolStack$;
import zio.http.ProtocolStack$CondBuilder$;
import zio.http.ProtocolStack$CondZIOBuilder$;
import zio.http.ProtocolStack$CondZIOBuilder1$;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Response$Patch$;
import zio.http.Status;
import zio.http.Status$Unauthorized$;
import zio.http.URL;
import zio.http.Version;
import zio.http.internal.HeaderModifier;
import zio.metrics.MetricKeyType;

public interface HandlerAspects
extends HeaderModifier<HandlerAspect<Object, BoxedUnit>> {
    public static void $init$(HandlerAspects $this) {
        $this.zio$http$HandlerAspects$_setter_$identity_$eq($this.interceptHandler(Handler$.MODULE$.identity().map((Function1 & Serializable)_$8 -> Tuple2$.MODULE$.apply(_$8, (Object)BoxedUnit.UNIT), "zio.http.HandlerAspects.identity(HandlerAspect.scala:449)"), Handler$.MODULE$.identity()));
        $this.zio$http$HandlerAspects$_setter_$defaultBoundaries_$eq(MetricKeyType.Histogram$.Boundaries$.MODULE$.fromChunk(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0}))));
    }

    public static HandlerAspect addCookie$(HandlerAspects $this, Cookie.Response cookie) {
        return $this.addCookie(cookie);
    }

    default public HandlerAspect<Object, BoxedUnit> addCookie(Cookie.Response cookie) {
        return (HandlerAspect)this.addHeader(Header$SetCookie$.MODULE$.apply(cookie));
    }

    public static HandlerAspect addCookieZIO$(HandlerAspects $this, ZIO cookie, Object trace) {
        return $this.addCookieZIO(cookie, trace);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> addCookieZIO(ZIO<Env, Nothing$, Cookie.Response> cookie, Object trace) {
        return this.updateResponseZIO((Function1 & Serializable)response -> cookie.map((Function1 & Serializable)cookie -> response.addCookie((Cookie.Response)cookie), trace));
    }

    public static BoxedUnit allow$(HandlerAspects $this) {
        return $this.allow();
    }

    default public BoxedUnit allow() {
        return BoxedUnit.UNIT;
    }

    public static BoxedUnit allowZIO$(HandlerAspects $this) {
        return $this.allowZIO();
    }

    default public BoxedUnit allowZIO() {
        return BoxedUnit.UNIT;
    }

    public static HandlerAspect basicAuth$(HandlerAspects $this, Function1 f) {
        return $this.basicAuth((Function1<Credentials, Object>)f);
    }

    default public HandlerAspect<Object, BoxedUnit> basicAuth(Function1<Credentials, Object> f) {
        return this.customAuth((Function1<Request, Object>)(Function1 & Serializable)_$4 -> {
            Header.Authorization authorization;
            Option option = _$4.header(Header$Authorization$.MODULE$);
            if (option instanceof Some && (authorization = (Header.Authorization)((Some)option).value()) instanceof Header.Authorization.Basic) {
                Header.Authorization.Basic basic = Header$Authorization$Basic$.MODULE$.unapply((Header.Authorization.Basic)authorization);
                String string = basic._1();
                Config.Secret secret = basic._2();
                String userName = string;
                Config.Secret password = secret;
                return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)Credentials$.MODULE$.apply(userName, password)));
            }
            return false;
        }, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$WWWAuthenticate$Basic$.MODULE$.apply(Header$WWWAuthenticate$Basic$.MODULE$.$lessinit$greater$default$1(), Header$WWWAuthenticate$Basic$.MODULE$.$lessinit$greater$default$2())})), this.customAuth$default$3());
    }

    public static HandlerAspect basicAuth$(HandlerAspects $this, String u, String p) {
        return $this.basicAuth(u, p);
    }

    default public HandlerAspect<Object, BoxedUnit> basicAuth(String u, String p) {
        return this.basicAuth((Function1<Credentials, Object>)(Function1 & Serializable)credentials -> {
            Config.Secret passwd = Config.Secret$.MODULE$.apply(p);
            Config.Secret dummy = Config.Secret$.MODULE$.apply(p.isEmpty() ? "a" : "");
            if (HandlerAspects.userComparison$1(credentials, u)) {
                return HandlerAspects.passwdComparison$1(credentials, passwd);
            }
            return HandlerAspects.dummyComparison$1(passwd, dummy);
        });
    }

    public static HandlerAspect basicAuthZIO$(HandlerAspects $this, Function1 f, Object trace) {
        return $this.basicAuthZIO(f, trace);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> basicAuthZIO(Function1<Credentials, ZIO<Env, Response, Object>> f, Object trace) {
        return this.customAuthZIO((Function1 & Serializable)_$5 -> {
            Header.Authorization authorization;
            Option option = _$5.header(Header$Authorization$.MODULE$);
            if (option instanceof Some && (authorization = (Header.Authorization)((Some)option).value()) instanceof Header.Authorization.Basic) {
                Header.Authorization.Basic basic = Header$Authorization$Basic$.MODULE$.unapply((Header.Authorization.Basic)authorization);
                String string = basic._1();
                Config.Secret secret = basic._2();
                String userName = string;
                Config.Secret password = secret;
                return (ZIO)f.apply((Object)Credentials$.MODULE$.apply(userName, password));
            }
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return false;
            });
        }, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$WWWAuthenticate$Basic$.MODULE$.apply(Header$WWWAuthenticate$Basic$.MODULE$.$lessinit$greater$default$1(), Header$WWWAuthenticate$Basic$.MODULE$.$lessinit$greater$default$2())})), this.customAuthZIO$default$3());
    }

    public static HandlerAspect bearerAuth$(HandlerAspects $this, Function1 f) {
        return $this.bearerAuth((Function1<Config.Secret, Object>)f);
    }

    default public HandlerAspect<Object, BoxedUnit> bearerAuth(Function1<Config.Secret, Object> f) {
        return this.customAuth((Function1<Request, Object>)(Function1 & Serializable)_$6 -> {
            Header.Authorization authorization;
            Option option = _$6.header(Header$Authorization$.MODULE$);
            if (option instanceof Some && (authorization = (Header.Authorization)((Some)option).value()) instanceof Header.Authorization.Bearer) {
                Config.Secret secret;
                Header.Authorization.Bearer bearer = Header$Authorization$Bearer$.MODULE$.unapply((Header.Authorization.Bearer)authorization);
                Config.Secret token = secret = bearer._1();
                return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)token));
            }
            return false;
        }, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$WWWAuthenticate$Bearer$.MODULE$.apply("Access", Header$WWWAuthenticate$Bearer$.MODULE$.$lessinit$greater$default$2(), Header$WWWAuthenticate$Bearer$.MODULE$.$lessinit$greater$default$3(), Header$WWWAuthenticate$Bearer$.MODULE$.$lessinit$greater$default$4())})), this.customAuth$default$3());
    }

    public static HandlerAspect bearerAuthZIO$(HandlerAspects $this, Function1 f, Object trace) {
        return $this.bearerAuthZIO(f, trace);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> bearerAuthZIO(Function1<Config.Secret, ZIO<Env, Response, Object>> f, Object trace) {
        return this.customAuthZIO((Function1 & Serializable)_$7 -> {
            Header.Authorization authorization;
            Option option = _$7.header(Header$Authorization$.MODULE$);
            if (option instanceof Some && (authorization = (Header.Authorization)((Some)option).value()) instanceof Header.Authorization.Bearer) {
                Config.Secret secret;
                Header.Authorization.Bearer bearer = Header$Authorization$Bearer$.MODULE$.unapply((Header.Authorization.Bearer)authorization);
                Config.Secret token = secret = bearer._1();
                return (ZIO)f.apply((Object)token);
            }
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace, (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return false;
            });
        }, Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$WWWAuthenticate$Bearer$.MODULE$.apply("Access", Header$WWWAuthenticate$Bearer$.MODULE$.$lessinit$greater$default$2(), Header$WWWAuthenticate$Bearer$.MODULE$.$lessinit$greater$default$3(), Header$WWWAuthenticate$Bearer$.MODULE$.$lessinit$greater$default$4())})), this.customAuthZIO$default$3());
    }

    public static HandlerAspect customAuth$(HandlerAspects $this, Function1 verify, Headers responseHeaders, Status responseStatus) {
        return $this.customAuth((Function1<Request, Object>)verify, responseHeaders, responseStatus);
    }

    default public HandlerAspect<Object, BoxedUnit> customAuth(Function1<Request, Object> verify, Headers responseHeaders, Status responseStatus) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionExit();
        return HandlerAspect$.MODULE$.interceptIncomingHandler(Handler$FromFunctionExit$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> {
            if (BoxesRunTime.unboxToBoolean((Object)verify.apply(request))) {
                return Exit$.MODULE$.succeed((Object)Tuple2$.MODULE$.apply(request, (Object)BoxedUnit.UNIT));
            }
            return Exit$.MODULE$.fail(Response$.MODULE$.status(responseStatus).addHeaders(responseHeaders));
        }));
    }

    public static Headers customAuth$default$2$(HandlerAspects $this) {
        return $this.customAuth$default$2();
    }

    default public Headers customAuth$default$2() {
        return Headers$.MODULE$.empty();
    }

    public static Status customAuth$default$3$(HandlerAspects $this) {
        return $this.customAuth$default$3();
    }

    default public Status customAuth$default$3() {
        return Status$Unauthorized$.MODULE$;
    }

    public static HandlerAspect customAuthProviding$(HandlerAspects $this, Function1 provide, Headers responseHeaders, Status responseStatus) {
        return $this.customAuthProviding(provide, responseHeaders, responseStatus);
    }

    default public <Context> HandlerAspect<Object, Context> customAuthProviding(Function1<Request, Option<Context>> provide, Headers responseHeaders, Status responseStatus) {
        return this.customAuthProvidingZIO((Function1 & Serializable)request -> Exit$.MODULE$.succeed(provide.apply(request)), responseHeaders, responseStatus);
    }

    public static Headers customAuthProviding$default$2$(HandlerAspects $this) {
        return $this.customAuthProviding$default$2();
    }

    default public <Context> Headers customAuthProviding$default$2() {
        return Headers$.MODULE$.empty();
    }

    public static Status customAuthProviding$default$3$(HandlerAspects $this) {
        return $this.customAuthProviding$default$3();
    }

    default public <Context> Status customAuthProviding$default$3() {
        return Status$Unauthorized$.MODULE$;
    }

    public static HandlerAspect customAuthProvidingZIO$(HandlerAspects $this, Function1 provide, Headers responseHeaders, Status responseStatus) {
        return $this.customAuthProvidingZIO(provide, responseHeaders, responseStatus);
    }

    default public <Env, Context> HandlerAspect<Env, Context> customAuthProvidingZIO(Function1<Request, ZIO<Env, Response, Option<Context>>> provide, Headers responseHeaders, Status responseStatus) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.interceptIncomingHandler(Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)req -> ((ZIO)provide.apply(req)).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Object context = ((Some)option).value();
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.http.HandlerAspects.customAuthProvidingZIO(HandlerAspect.scala:373)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                    return Tuple2$.MODULE$.apply(req, context);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return ZIO$.MODULE$.fail(() -> HandlerAspects.customAuthProvidingZIO$$anonfun$1$$anonfun$1$$anonfun$2(responseStatus, responseHeaders), (Object)"zio.http.HandlerAspects.customAuthProvidingZIO(HandlerAspect.scala:374)");
            }
            throw new MatchError((Object)option);
        }, (Object)"zio.http.HandlerAspects.customAuthProvidingZIO(HandlerAspect.scala:375)")));
    }

    public static Headers customAuthProvidingZIO$default$2$(HandlerAspects $this) {
        return $this.customAuthProvidingZIO$default$2();
    }

    default public <Env, Context> Headers customAuthProvidingZIO$default$2() {
        return Headers$.MODULE$.empty();
    }

    public static Status customAuthProvidingZIO$default$3$(HandlerAspects $this) {
        return $this.customAuthProvidingZIO$default$3();
    }

    default public <Env, Context> Status customAuthProvidingZIO$default$3() {
        return Status$Unauthorized$.MODULE$;
    }

    public static HandlerAspect customAuthZIO$(HandlerAspects $this, Function1 verify, Headers responseHeaders, Status responseStatus) {
        return $this.customAuthZIO(verify, responseHeaders, responseStatus);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> customAuthZIO(Function1<Request, ZIO<Env, Response, Object>> verify, Headers responseHeaders, Status responseStatus) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.interceptIncomingHandler(Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> ((ZIO)verify.apply(request)).flatMap((Function1 & Serializable)x$1 -> HandlerAspects.customAuthZIO$$anonfun$1$$anonfun$1(request, responseStatus, responseHeaders, BoxesRunTime.unboxToBoolean((Object)x$1)), (Object)"zio.http.HandlerAspects.customAuthZIO(HandlerAspect.scala:393)")));
    }

    public static Headers customAuthZIO$default$2$(HandlerAspects $this) {
        return $this.customAuthZIO$default$2();
    }

    default public <Env> Headers customAuthZIO$default$2() {
        return Headers$.MODULE$.empty();
    }

    public static Status customAuthZIO$default$3$(HandlerAspects $this) {
        return $this.customAuthZIO$default$3();
    }

    default public <Env> Status customAuthZIO$default$3() {
        return Status$Unauthorized$.MODULE$;
    }

    public static HandlerAspect debug$(HandlerAspects $this) {
        return $this.debug();
    }

    default public HandlerAspect<Object, BoxedUnit> debug() {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        BoxedUnit boxedUnit2 = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.interceptHandlerStateful(Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> Clock$.MODULE$.instant((Object)"zio.http.HandlerAspects.debug(HandlerAspect.scala:401)").map((Function1 & Serializable)now -> Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(now, request), (Object)Tuple2$.MODULE$.apply(request, (Object)BoxedUnit.UNIT)), (Object)"zio.http.HandlerAspects.debug(HandlerAspect.scala:401)")), Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Instant start = (Instant)tuple2._1();
                Request request = (Request)tuple2._2();
                Response response = (Response)tuple22._2();
                return Clock$.MODULE$.instant((Object)"zio.http.HandlerAspects.debug(HandlerAspect.scala:403)").flatMap((Function1 & Serializable)end -> {
                    Duration duration = Duration.between(start, end);
                    return Console$.MODULE$.printLine(() -> HandlerAspects.debug$$anonfun$2$$anonfun$1$$anonfun$1(response, request, duration), (Object)"zio.http.HandlerAspects.debug(HandlerAspect.scala:407)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.http.HandlerAspects.debug(HandlerAspect.scala:408)").as(() -> HandlerAspects.debug$$anonfun$2$$anonfun$1$$anonfun$2(response), (Object)"zio.http.HandlerAspects.debug(HandlerAspect.scala:409)");
                }, (Object)"zio.http.HandlerAspects.debug(HandlerAspect.scala:410)");
            }
            throw new MatchError((Object)tuple22);
        }));
    }

    public static HandlerAspect dropTrailingSlash$(HandlerAspects $this) {
        return $this.dropTrailingSlash();
    }

    default public HandlerAspect<Object, BoxedUnit> dropTrailingSlash() {
        return this.dropTrailingSlash(false);
    }

    public static HandlerAspect dropTrailingSlash$(HandlerAspects $this, boolean onlyIfNoQueryParams) {
        return $this.dropTrailingSlash(onlyIfNoQueryParams);
    }

    default public HandlerAspect<Object, BoxedUnit> dropTrailingSlash(boolean onlyIfNoQueryParams) {
        return this.updateRequest((Function1<Request, Request>)(Function1 & Serializable)request -> {
            if (!onlyIfNoQueryParams || request.url().queryParams().isEmpty()) {
                return request.dropTrailingSlash();
            }
            return request;
        });
    }

    public static HandlerAspect fail$(HandlerAspects $this, Response response) {
        return $this.fail(response);
    }

    default public HandlerAspect<Object, BoxedUnit> fail(Response response) {
        return HandlerAspect$.MODULE$.apply(ProtocolStack$.MODULE$.interceptHandler(Handler$.MODULE$.fail(() -> HandlerAspects.fail$$anonfun$1(response)), Handler$.MODULE$.identity(), "zio.http.HandlerAspects.fail(HandlerAspect.scala:434)"));
    }

    public static HandlerAspect failWith$(HandlerAspects $this, Function1 f) {
        return $this.failWith((Function1<Request, Response>)f);
    }

    default public HandlerAspect<Object, BoxedUnit> failWith(Function1<Request, Response> f) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionExit();
        return HandlerAspect$.MODULE$.apply(ProtocolStack$.MODULE$.interceptHandler(Handler$FromFunctionExit$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)in -> Exit$.MODULE$.fail(f.apply(in))), Handler$.MODULE$.identity(), "zio.http.HandlerAspects.failWith(HandlerAspect.scala:442)"));
    }

    public HandlerAspect<Object, BoxedUnit> identity();

    public void zio$http$HandlerAspects$_setter_$identity_$eq(HandlerAspect var1);

    public static HandlerAspect ifHeaderThenElse$(HandlerAspects $this, Function1 condition, HandlerAspect ifTrue, HandlerAspect ifFalse) {
        return $this.ifHeaderThenElse((Function1<Headers, Object>)condition, ifTrue, ifFalse);
    }

    default public <Env, Ctx> HandlerAspect<Env, Ctx> ifHeaderThenElse(Function1<Headers, Object> condition, HandlerAspect<Env, Ctx> ifTrue, HandlerAspect<Env, Ctx> ifFalse) {
        return this.ifRequestThenElse((Function1<Request, Object>)(Function1 & Serializable)request -> BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)request.headers())), ifTrue, ifFalse);
    }

    public static HandlerAspect ifMethodThenElse$(HandlerAspects $this, Function1 condition, HandlerAspect ifTrue, HandlerAspect ifFalse) {
        return $this.ifMethodThenElse((Function1<Method, Object>)condition, ifTrue, ifFalse);
    }

    default public <Env, Ctx> HandlerAspect<Env, Ctx> ifMethodThenElse(Function1<Method, Object> condition, HandlerAspect<Env, Ctx> ifTrue, HandlerAspect<Env, Ctx> ifFalse) {
        return this.ifRequestThenElse((Function1<Request, Object>)(Function1 & Serializable)request -> BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)request.method())), ifTrue, ifFalse);
    }

    public static HandlerAspect ifRequestThenElse$(HandlerAspects $this, Function1 predicate, HandlerAspect ifTrue, HandlerAspect ifFalse) {
        return $this.ifRequestThenElse((Function1<Request, Object>)predicate, ifTrue, ifFalse);
    }

    default public <Env, CtxOut> HandlerAspect<Env, CtxOut> ifRequestThenElse(Function1<Request, Object> predicate, HandlerAspect<Env, CtxOut> ifTrue, HandlerAspect<Env, CtxOut> ifFalse) {
        ProtocolStack<Env, Request, Tuple2<Request, CtxOut>, Response, Response> ifTrue2 = ifTrue.protocol();
        ProtocolStack<Env, Request, Tuple2<Request, CtxOut>, Response, Response> ifFalse2 = ifFalse.protocol();
        Function1 function1 = ProtocolStack$.MODULE$.cond(predicate);
        return HandlerAspect$.MODULE$.apply(ProtocolStack$CondBuilder$.MODULE$.apply$extension(function1, ifTrue2, ifFalse2));
    }

    public static HandlerAspect ifRequestThenElseZIO$(HandlerAspects $this, Function1 predicate, HandlerAspect ifTrue, HandlerAspect ifFalse) {
        return $this.ifRequestThenElseZIO(predicate, ifTrue, ifFalse);
    }

    default public <Env, CtxOut> HandlerAspect<Env, CtxOut> ifRequestThenElseZIO(Function1<Request, ZIO<Env, Response, Object>> predicate, HandlerAspect<Env, CtxOut> ifTrue, HandlerAspect<Env, CtxOut> ifFalse) {
        ProtocolStack<Env, Request, Tuple2<Request, CtxOut>, Response, Response> ifTrue2 = ifTrue.protocol();
        ProtocolStack<Env, Request, Tuple2<Request, CtxOut>, Response, Response> ifFalse2 = ifFalse.protocol();
        BoxedUnit boxedUnit = ProtocolStack$.MODULE$.condZIO();
        Function1 function1 = ProtocolStack$CondZIOBuilder$.MODULE$.apply$extension(boxedUnit, predicate);
        return HandlerAspect$.MODULE$.apply(ProtocolStack$CondZIOBuilder1$.MODULE$.apply$extension(function1, ifTrue2, ifFalse2));
    }

    public static HandlerAspect intercept$(HandlerAspects $this, Function2 fromRequestAndResponse) {
        return $this.intercept((Function2<Request, Response, Response>)fromRequestAndResponse);
    }

    default public HandlerAspect<Object, BoxedUnit> intercept(Function2<Request, Response, Response> fromRequestAndResponse) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunction();
        return this.interceptHandlerStateful(Handler$.MODULE$.identity().map((Function1 & Serializable)req -> Tuple2$.MODULE$.apply(req, (Object)Tuple2$.MODULE$.apply(req, (Object)BoxedUnit.UNIT)), "zio.http.HandlerAspects.intercept(HandlerAspect.scala:518)"), Handler$FromFunction$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Request req = (Request)tuple2._1();
                Response res = (Response)tuple2._2();
                return (Response)fromRequestAndResponse.apply((Object)req, (Object)res);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public static HandlerAspect interceptHandler$(HandlerAspects $this, Handler incoming0, Handler outgoing0) {
        return $this.interceptHandler(incoming0, outgoing0);
    }

    default public <Env, CtxOut> HandlerAspect<Env, CtxOut> interceptHandler(Handler<Env, Response, Request, Tuple2<Request, CtxOut>> incoming0, Handler<Env, Nothing$, Response, Response> outgoing0) {
        return HandlerAspect$.MODULE$.apply(ProtocolStack$.MODULE$.interceptHandler(incoming0, outgoing0, "zio.http.HandlerAspects.interceptHandler(HandlerAspect.scala:532)"));
    }

    public static HandlerAspect interceptHandlerStateful$(HandlerAspects $this, Handler incoming0, Handler outgoing0) {
        return $this.interceptHandlerStateful(incoming0, outgoing0);
    }

    default public <Env, State0, CtxOut> HandlerAspect<Env, CtxOut> interceptHandlerStateful(Handler<Env, Response, Request, Tuple2<State0, Tuple2<Request, CtxOut>>> incoming0, Handler<Env, Nothing$, Tuple2<State0, Response>, Response> outgoing0) {
        return HandlerAspect$.MODULE$.apply(ProtocolStack$.MODULE$.interceptHandlerStateful(incoming0, outgoing0));
    }

    public static HandlerAspect interceptIncomingHandler$(HandlerAspects $this, Handler handler) {
        return $this.interceptIncomingHandler(handler);
    }

    default public <Env, CtxOut> HandlerAspect<Env, CtxOut> interceptIncomingHandler(Handler<Env, Response, Request, Tuple2<Request, CtxOut>> handler) {
        return this.interceptHandler(handler, Handler$.MODULE$.identity());
    }

    public static HandlerAspect interceptOutgoingHandler$(HandlerAspects $this, Handler handler) {
        return $this.interceptOutgoingHandler(handler);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> interceptOutgoingHandler(Handler<Env, Nothing$, Response, Response> handler) {
        return this.interceptHandler(Handler$.MODULE$.identity().map((Function1 & Serializable)_$9 -> Tuple2$.MODULE$.apply(_$9, (Object)BoxedUnit.UNIT), "zio.http.HandlerAspects.interceptOutgoingHandler(HandlerAspect.scala:567)"), handler);
    }

    public static Function1 interceptPatch$(HandlerAspects $this, Function1 fromRequest) {
        return $this.interceptPatch(fromRequest);
    }

    default public <S> Function1 interceptPatch(Function1<Request, S> fromRequest) {
        return fromRequest;
    }

    public static Function1 interceptPatchZIO$(HandlerAspects $this, Function1 fromRequest) {
        return $this.interceptPatchZIO(fromRequest);
    }

    default public <Env, S> Function1 interceptPatchZIO(Function1<Request, ZIO<Env, Response, S>> fromRequest) {
        return fromRequest;
    }

    public static HandlerAspect patch$(HandlerAspects $this, Function1 f) {
        return $this.patch((Function1<Response, Response.Patch>)f);
    }

    default public HandlerAspect<Object, BoxedUnit> patch(Function1<Response, Response.Patch> f) {
        Function1 function1 = this.interceptPatch((Function1)(JProcedure1 & Serializable)_$10 -> {});
        return HandlerAspect$InterceptPatch$.MODULE$.apply$extension(function1, (Function2 & Serializable)(response, _$11) -> (Response.Patch)f.apply(response));
    }

    public static HandlerAspect patchZIO$(HandlerAspects $this, Function1 f) {
        return $this.patchZIO(f);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> patchZIO(Function1<Response, ZIO<Env, Response, Response.Patch>> f) {
        Function1 function1 = this.interceptPatchZIO((Function1 & Serializable)_$12 -> ZIO$.MODULE$.unit());
        return HandlerAspect$InterceptPatchZIO$.MODULE$.apply$extension(function1, (Function2 & Serializable)(response, _$13) -> (ZIO)f.apply(response));
    }

    public static HandlerAspect redirect$(HandlerAspects $this, URL url, boolean isPermanent) {
        return $this.redirect(url, isPermanent);
    }

    default public HandlerAspect<Object, BoxedUnit> redirect(URL url, boolean isPermanent) {
        return this.fail(Response$.MODULE$.redirect(url, isPermanent));
    }

    public static boolean redirect$default$2$(HandlerAspects $this) {
        return $this.redirect$default$2();
    }

    default public boolean redirect$default$2() {
        return false;
    }

    public static HandlerAspect redirectTrailingSlash$(HandlerAspects $this, boolean isPermanent) {
        return $this.redirectTrailingSlash(isPermanent);
    }

    default public HandlerAspect<Object, BoxedUnit> redirectTrailingSlash(boolean isPermanent) {
        return this.ifRequestThenElse((Function1<Request, Object>)(Function1 & Serializable)request -> request.url().path().hasTrailingSlash() && request.url().queryParams().isEmpty(), this.updatePath((Function1<Path, Path>)(Function1 & Serializable)_$14 -> _$14.dropTrailingSlash()).$plus$plus(this.failWith((Function1<Request, Response>)(Function1 & Serializable)request -> Response$.MODULE$.redirect(request.url(), isPermanent)), Zippable$.MODULE$.ZippableLeftIdentity()), HandlerAspect$.MODULE$.identity());
    }

    public static boolean redirectTrailingSlash$default$1$(HandlerAspects $this) {
        return $this.redirectTrailingSlash$default$1();
    }

    default public boolean redirectTrailingSlash$default$1() {
        return false;
    }

    public static HandlerAspect requestLogging$(HandlerAspects $this, Function1 level, scala.collection.immutable.Set loggedRequestHeaders, scala.collection.immutable.Set loggedResponseHeaders, boolean logRequestBody, boolean logResponseBody, Charset requestCharset, Charset responseCharset, Object trace) {
        return $this.requestLogging((Function1<Status, LogLevel>)level, (scala.collection.immutable.Set<Header.HeaderType>)loggedRequestHeaders, (scala.collection.immutable.Set<Header.HeaderType>)loggedResponseHeaders, logRequestBody, logResponseBody, requestCharset, responseCharset, trace);
    }

    default public HandlerAspect<Object, BoxedUnit> requestLogging(Function1<Status, LogLevel> level, scala.collection.immutable.Set<Header.HeaderType> loggedRequestHeaders, scala.collection.immutable.Set<Header.HeaderType> loggedResponseHeaders, boolean logRequestBody, boolean logResponseBody, Charset requestCharset, Charset responseCharset, Object trace) {
        scala.collection.immutable.Set loggedRequestHeaderNames = (scala.collection.immutable.Set)loggedRequestHeaders.map((Function1 & Serializable)_$16 -> _$16.name().toLowerCase());
        scala.collection.immutable.Set loggedResponseHeaderNames = (scala.collection.immutable.Set)loggedResponseHeaders.map((Function1 & Serializable)_$17 -> _$17.name().toLowerCase());
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        BoxedUnit boxedUnit2 = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.interceptHandlerStateful(Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> Clock$.MODULE$.instant(trace).map((Function1 & Serializable)now -> Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(now, request), (Object)Tuple2$.MODULE$.apply(request, (Object)BoxedUnit.UNIT)), trace)), Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Instant start = (Instant)tuple2._1();
                Request request = (Request)tuple2._2();
                Response response = (Response)tuple22._2();
                return Clock$.MODULE$.instant(trace).flatMap((Function1 & Serializable)end -> {
                    Duration duration = Duration.between(start, end);
                    ZIO requestBody = request.body().isComplete() ? request.body().asChunk(trace).option(CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace) : ZIO$.MODULE$.none();
                    ZIO responseBody = response.body().isComplete() ? response.body().asChunk(trace).option(CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace) : ZIO$.MODULE$.none();
                    return ZIO$.MODULE$.logLevel((LogLevel)level.apply((Object)response.status())).apply(requestBody.flatMap((Function1 & Serializable)requestBodyChunk -> responseBody.flatMap((Function1 & Serializable)responseBodyChunk -> {
                        scala.collection.immutable.Set bodyAnnotations = (scala.collection.immutable.Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{requestBodyChunk.map((Function1 & Serializable)chunk -> LogAnnotation$.MODULE$.apply("request_size", BoxesRunTime.boxToInteger((int)chunk.size()).toString())), requestBodyChunk.flatMap((Function1 & Serializable)chunk -> {
                            if (logRequestBody) {
                                return Some$.MODULE$.apply((Object)LogAnnotation$.MODULE$.apply("request", new String((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), requestCharset)));
                            }
                            return None$.MODULE$;
                        }), responseBodyChunk.map((Function1 & Serializable)chunk -> LogAnnotation$.MODULE$.apply("response_size", BoxesRunTime.boxToInteger((int)chunk.size()).toString())), responseBodyChunk.flatMap((Function1 & Serializable)chunk -> {
                            if (logResponseBody) {
                                return Some$.MODULE$.apply((Object)LogAnnotation$.MODULE$.apply("response", new String((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), responseCharset)));
                            }
                            return None$.MODULE$;
                        })}))).flatten(Predef$.MODULE$.$conforms());
                        return ZIO$.MODULE$.logAnnotate(() -> HandlerAspects.requestLogging$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(response, request, duration, bodyAnnotations, loggedRequestHeaderNames, loggedResponseHeaderNames)).apply(ZIO$.MODULE$.log(HandlerAspects::requestLogging$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2, trace).as(() -> HandlerAspects.requestLogging$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(response), trace), trace);
                    }, trace), trace), trace);
                }, trace);
            }
            throw new MatchError((Object)tuple22);
        }));
    }

    public static Function1 requestLogging$default$1$(HandlerAspects $this) {
        return $this.requestLogging$default$1();
    }

    default public Function1<Status, LogLevel> requestLogging$default$1() {
        return (Function1 & Serializable)_$15 -> LogLevel$.MODULE$.Info();
    }

    public static scala.collection.immutable.Set requestLogging$default$2$(HandlerAspects $this) {
        return $this.requestLogging$default$2();
    }

    default public scala.collection.immutable.Set<Header.HeaderType> requestLogging$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public static scala.collection.immutable.Set requestLogging$default$3$(HandlerAspects $this) {
        return $this.requestLogging$default$3();
    }

    default public scala.collection.immutable.Set<Header.HeaderType> requestLogging$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public static boolean requestLogging$default$4$(HandlerAspects $this) {
        return $this.requestLogging$default$4();
    }

    default public boolean requestLogging$default$4() {
        return false;
    }

    public static boolean requestLogging$default$5$(HandlerAspects $this) {
        return $this.requestLogging$default$5();
    }

    default public boolean requestLogging$default$5() {
        return false;
    }

    public static Charset requestLogging$default$6$(HandlerAspects $this) {
        return $this.requestLogging$default$6();
    }

    default public Charset requestLogging$default$6() {
        return StandardCharsets.UTF_8;
    }

    public static Charset requestLogging$default$7$(HandlerAspects $this) {
        return $this.requestLogging$default$7();
    }

    default public Charset requestLogging$default$7() {
        return StandardCharsets.UTF_8;
    }

    public static HandlerAspect runAfter$(HandlerAspects $this, ZIO effect, Object trace) {
        return $this.runAfter(effect, trace);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> runAfter(ZIO<Env, Nothing$, Object> effect, Object trace) {
        return this.updateResponseZIO((Function1 & Serializable)response -> effect.as(() -> HandlerAspects.runAfter$$anonfun$1$$anonfun$1(response), trace));
    }

    public static HandlerAspect runBefore$(HandlerAspects $this, ZIO effect, Object trace) {
        return $this.runBefore(effect, trace);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> runBefore(ZIO<Env, Nothing$, Object> effect, Object trace) {
        return this.updateRequestZIO((Function1 & Serializable)request -> effect.as(() -> HandlerAspects.runBefore$$anonfun$1$$anonfun$1(request), trace));
    }

    public static HandlerAspect signCookies$(HandlerAspects $this, String secret) {
        return $this.signCookies(secret);
    }

    default public HandlerAspect<Object, BoxedUnit> signCookies(String secret) {
        return this.updateHeaders((Function1<Headers, Headers>)(Function1 & Serializable)headers -> headers.modify((Function1<Header, Header>)(Function1 & Serializable)x$1 -> {
            Header header = x$1;
            if (header instanceof Header.SetCookie) {
                Cookie.Response response;
                Header.SetCookie setCookie = Header$SetCookie$.MODULE$.unapply((Header.SetCookie)header);
                Cookie.Response cookie = response = setCookie._1();
                return Header$SetCookie$.MODULE$.apply(cookie.sign(secret));
            }
            if (header instanceof Header.Custom) {
                Header.Custom custom = (Header.Custom)header;
                Header.Custom custom2 = Header$Custom$.MODULE$.unapply(custom);
                CharSequence charSequence = custom2._1();
                CharSequence charSequence2 = custom2._2();
                CharSequence name = charSequence;
                CharSequence value = charSequence2;
                Header.Custom header2 = custom;
                String string = name.toString();
                String string2 = Header$SetCookie$.MODULE$.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Product product;
                    Either<String, Header.SetCookie> either = Header$SetCookie$.MODULE$.parse(value.toString());
                    if (either instanceof Left) {
                        product = header2;
                    } else if (either instanceof Right) {
                        Header.SetCookie responseCookie = (Header.SetCookie)((Right)either).value();
                        product = Header$SetCookie$.MODULE$.apply(responseCookie.value().sign(secret));
                    } else {
                        throw new MatchError(either);
                    }
                    return product;
                }
            }
            if (header != null) {
                Header header3 = header;
                return header3;
            }
            throw new MatchError((Object)header);
        }), "zio.http.HandlerAspects.signCookies(HandlerAspect.scala:716)");
    }

    public static HandlerAspect status$(HandlerAspects $this, Status status) {
        return $this.status(status);
    }

    default public HandlerAspect<Object, BoxedUnit> status(Status status) {
        return this.patch((Function1<Response, Response.Patch>)(Function1 & Serializable)_$18 -> Response$Patch$.MODULE$.status(status));
    }

    public static HandlerAspect updateHeaders$(HandlerAspects $this, Function1 update, Object trace) {
        return $this.updateHeaders((Function1<Headers, Headers>)update, trace);
    }

    @Override
    default public HandlerAspect<Object, BoxedUnit> updateHeaders(Function1<Headers, Headers> update, Object trace) {
        return this.updateResponse((Function1<Response, Response>)(Function1 & Serializable)_$19 -> _$19.updateHeaders((Function1)update, trace));
    }

    public static HandlerAspect updateMethod$(HandlerAspects $this, Function1 update) {
        return $this.updateMethod((Function1<Method, Method>)update);
    }

    default public HandlerAspect<Object, BoxedUnit> updateMethod(Function1<Method, Method> update) {
        return this.updateRequest((Function1<Request, Request>)(Function1 & Serializable)request -> {
            Method method = (Method)update.apply((Object)request.method());
            Version version = request.copy$default$1();
            URL uRL = request.copy$default$3();
            Headers headers = request.copy$default$4();
            Body body = request.copy$default$5();
            Option<InetAddress> option = request.copy$default$6();
            Option<Certificate> option2 = request.copy$default$7();
            return request.copy(version, method, uRL, headers, body, option, option2);
        });
    }

    public static HandlerAspect updatePath$(HandlerAspects $this, Function1 update) {
        return $this.updatePath((Function1<Path, Path>)update);
    }

    default public HandlerAspect<Object, BoxedUnit> updatePath(Function1<Path, Path> update) {
        return this.updateRequest((Function1<Request, Request>)(Function1 & Serializable)request -> {
            URL uRL = request.url().copy((Path)update.apply((Object)request.url().path()), request.url().copy$default$2(), request.url().copy$default$3(), request.url().copy$default$4());
            Version version = request.copy$default$1();
            Method method = request.copy$default$2();
            Headers headers = request.copy$default$4();
            Body body = request.copy$default$5();
            Option<InetAddress> option = request.copy$default$6();
            Option<Certificate> option2 = request.copy$default$7();
            return request.copy(version, method, uRL, headers, body, option, option2);
        });
    }

    public static HandlerAspect updateRequest$(HandlerAspects $this, Function1 update) {
        return $this.updateRequest((Function1<Request, Request>)update);
    }

    default public HandlerAspect<Object, BoxedUnit> updateRequest(Function1<Request, Request> update) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunction();
        return HandlerAspect$.MODULE$.interceptIncomingHandler(Handler$FromFunction$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> Tuple2$.MODULE$.apply(update.apply(request), (Object)BoxedUnit.UNIT)));
    }

    public static HandlerAspect updateRequestZIO$(HandlerAspects $this, Function1 update) {
        return $this.updateRequestZIO(update);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> updateRequestZIO(Function1<Request, ZIO<Env, Response, Request>> update) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.interceptIncomingHandler(Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)request -> ((ZIO)update.apply(request)).map((Function1 & Serializable)_$20 -> Tuple2$.MODULE$.apply(_$20, (Object)BoxedUnit.UNIT), (Object)"zio.http.HandlerAspects.updateRequestZIO(HandlerAspect.scala:758)")));
    }

    public static HandlerAspect updateResponse$(HandlerAspects $this, Function1 update) {
        return $this.updateResponse((Function1<Response, Response>)update);
    }

    default public HandlerAspect<Object, BoxedUnit> updateResponse(Function1<Response, Response> update) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunction();
        return HandlerAspect$.MODULE$.interceptOutgoingHandler(Handler$FromFunction$.MODULE$.apply$extension(boxedUnit, update));
    }

    public static HandlerAspect updateResponseZIO$(HandlerAspects $this, Function1 update) {
        return $this.updateResponseZIO(update);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> updateResponseZIO(Function1<Response, ZIO<Env, Nothing$, Response>> update) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.interceptOutgoingHandler((Handler)Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, update));
    }

    public static HandlerAspect updateURL$(HandlerAspects $this, Function1 update) {
        return $this.updateURL((Function1<URL, URL>)update);
    }

    default public HandlerAspect<Object, BoxedUnit> updateURL(Function1<URL, URL> update) {
        return this.updateRequest((Function1<Request, Request>)(Function1 & Serializable)request -> {
            URL uRL = (URL)update.apply((Object)request.url());
            Version version = request.copy$default$1();
            Method method = request.copy$default$2();
            Headers headers = request.copy$default$4();
            Body body = request.copy$default$5();
            Option<InetAddress> option = request.copy$default$6();
            Option<Certificate> option2 = request.copy$default$7();
            return request.copy(version, method, uRL, headers, body, option, option2);
        });
    }

    public static HandlerAspect whenHeader$(HandlerAspects $this, Function1 condition, HandlerAspect middleware) {
        return $this.whenHeader((Function1<Headers, Object>)condition, middleware);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> whenHeader(Function1<Headers, Object> condition, HandlerAspect<Env, BoxedUnit> middleware) {
        return this.ifHeaderThenElse(condition, middleware, this.identity());
    }

    public static HandlerAspect whenResponse$(HandlerAspects $this, Function1 condition, Function1 f) {
        return $this.whenResponse((Function1<Response, Object>)condition, (Function1<Response, Response>)f);
    }

    default public HandlerAspect<Object, BoxedUnit> whenResponse(Function1<Response, Object> condition, Function1<Response, Response> f) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.apply(ProtocolStack$.MODULE$.interceptHandler(Handler$.MODULE$.identity().map((Function1 & Serializable)_$21 -> Tuple2$.MODULE$.apply(_$21, (Object)BoxedUnit.UNIT), "zio.http.HandlerAspects.whenResponse(HandlerAspect.scala:796)"), Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)response -> {
            if (BoxesRunTime.unboxToBoolean((Object)condition.apply(response))) {
                ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
                return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.http.HandlerAspects.whenResponse(HandlerAspect.scala:798)", (Function0 & Serializable)() -> {
                    Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                    return (Response)f.apply(response);
                });
            }
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.http.HandlerAspects.whenResponse(HandlerAspect.scala:798)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return response;
            });
        }), "zio.http.HandlerAspects.whenResponse(HandlerAspect.scala:799)"));
    }

    public static HandlerAspect whenResponseZIO$(HandlerAspects $this, Function1 condition, Function1 f) {
        return $this.whenResponseZIO(condition, f);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> whenResponseZIO(Function1<Response, ZIO<Env, Response, Object>> condition, Function1<Response, ZIO<Env, Response, Response>> f) {
        BoxedUnit boxedUnit = Handler$.MODULE$.fromFunctionZIO();
        return HandlerAspect$.MODULE$.apply(ProtocolStack$.MODULE$.interceptHandler(Handler$.MODULE$.identity().map((Function1 & Serializable)_$22 -> Tuple2$.MODULE$.apply(_$22, (Object)BoxedUnit.UNIT), "zio.http.HandlerAspects.whenResponseZIO(HandlerAspect.scala:811)"), Handler$FromFunctionZIO$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)response -> ((ZIO)condition.apply(response)).flatMap((Function1 & Serializable)bool -> HandlerAspects.whenResponseZIO$$anonfun$2$$anonfun$1(f, response, BoxesRunTime.unboxToBoolean((Object)bool)), (Object)"zio.http.HandlerAspects.whenResponseZIO(HandlerAspect.scala:814)").merge(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"zio.http.HandlerAspects.whenResponseZIO(HandlerAspect.scala:815)")), "zio.http.HandlerAspects.whenResponseZIO(HandlerAspect.scala:816)"));
    }

    public static HandlerAspect when$(HandlerAspects $this, Function1 condition, HandlerAspect middleware) {
        return $this.when((Function1<Request, Object>)condition, middleware);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> when(Function1<Request, Object> condition, HandlerAspect<Env, BoxedUnit> middleware) {
        return this.ifRequestThenElse(condition, middleware, this.identity());
    }

    public static HandlerAspect whenZIO$(HandlerAspects $this, Function1 condition, HandlerAspect middleware) {
        return $this.whenZIO(condition, middleware);
    }

    default public <Env> HandlerAspect<Env, BoxedUnit> whenZIO(Function1<Request, ZIO<Env, Response, Object>> condition, HandlerAspect<Env, BoxedUnit> middleware) {
        return this.ifRequestThenElseZIO(condition, middleware, this.identity());
    }

    public MetricKeyType.Histogram.Boundaries defaultBoundaries();

    public void zio$http$HandlerAspects$_setter_$defaultBoundaries_$eq(MetricKeyType.Histogram.Boundaries var1);

    private static boolean userComparison$1(Credentials credentials$1, String u$2) {
        Config.Secret secret = Config.Secret$.MODULE$.apply(credentials$1.uname());
        Config.Secret secret2 = Config.Secret$.MODULE$.apply(u$2);
        return !(secret != null ? !secret.equals(secret2) : secret2 != null);
    }

    private static boolean passwdComparison$1(Credentials credentials$2, Config.Secret passwd$1) {
        Config.Secret secret = credentials$2.upassword();
        Config.Secret secret2 = passwd$1;
        return !(secret != null ? !secret.equals(secret2) : secret2 != null);
    }

    private static boolean dummyComparison$1(Config.Secret passwd$2, Config.Secret dummy$1) {
        Config.Secret secret = passwd$2;
        Config.Secret secret2 = dummy$1;
        return !(secret != null ? !secret.equals(secret2) : secret2 != null);
    }

    private static Response customAuthProvidingZIO$$anonfun$1$$anonfun$1$$anonfun$2(Status responseStatus$4, Headers responseHeaders$4) {
        return (Response)Response$.MODULE$.status(responseStatus$4).addHeaders(responseHeaders$4);
    }

    private static Response customAuthZIO$$anonfun$1$$anonfun$1$$anonfun$2(Status responseStatus$7, Headers responseHeaders$7) {
        return (Response)Response$.MODULE$.status(responseStatus$7).addHeaders(responseHeaders$7);
    }

    private static /* synthetic */ ZIO customAuthZIO$$anonfun$1$$anonfun$1(Request request$5, Status responseStatus$6, Headers responseHeaders$6, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
            return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.http.HandlerAspects.customAuthZIO(HandlerAspect.scala:391)", (Function0 & Serializable)() -> {
                Unsafe$ unsafe$2 = Unsafe$.MODULE$;
                return Tuple2$.MODULE$.apply((Object)request$5, (Object)BoxedUnit.UNIT);
            });
        }
        if (!bl) {
            return ZIO$.MODULE$.fail(() -> HandlerAspects.customAuthZIO$$anonfun$1$$anonfun$1$$anonfun$2(responseStatus$6, responseHeaders$6), (Object)"zio.http.HandlerAspects.customAuthZIO(HandlerAspect.scala:392)");
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static Object debug$$anonfun$2$$anonfun$1$$anonfun$1(Response response$10, Request request$9, Duration duration$1) {
        return new StringBuilder(5).append(response$10.status().code()).append(" ").append(request$9.method()).append(" ").append(request$9.url().encode()).append(" ").append(duration$1.toMillis()).append("ms").toString();
    }

    private static Response debug$$anonfun$2$$anonfun$1$$anonfun$2(Response response$11) {
        return response$11;
    }

    private static Response fail$$anonfun$1(Response response$12) {
        return response$12;
    }

    private static scala.collection.immutable.Set requestHeaders$1(Request request$12, scala.collection.immutable.Set loggedRequestHeaderNames$3) {
        return ((IterableOnceOps)request$12.headers().collect((PartialFunction)new Serializable(loggedRequestHeaderNames$3){
            private final scala.collection.immutable.Set loggedRequestHeaderNames$4;
            {
                this.loggedRequestHeaderNames$4 = loggedRequestHeaderNames$8;
            }

            public final boolean isDefinedAt(Header x) {
                Header header;
                Header header2 = x;
                return header2 != null && this.loggedRequestHeaderNames$4.contains((Object)(header = header2).headerName().toLowerCase());
            }

            public final Object applyOrElse(Header x, Function1 function1) {
                Header header;
                Header header2 = x;
                if (header2 != null && this.loggedRequestHeaderNames$4.contains((Object)(header = header2).headerName().toLowerCase())) {
                    return LogAnnotation$.MODULE$.apply(header.headerName(), header.renderedValue());
                }
                return function1.apply((Object)x);
            }
        })).toSet();
    }

    private static scala.collection.immutable.Set responseHeaders$9(Response response$14, scala.collection.immutable.Set loggedResponseHeaderNames$3) {
        return ((IterableOnceOps)response$14.headers().collect((PartialFunction)new Serializable(loggedResponseHeaderNames$3){
            private final scala.collection.immutable.Set loggedResponseHeaderNames$4;
            {
                this.loggedResponseHeaderNames$4 = loggedResponseHeaderNames$8;
            }

            public final boolean isDefinedAt(Header x) {
                Header header;
                Header header2 = x;
                return header2 != null && this.loggedResponseHeaderNames$4.contains((Object)(header = header2).headerName().toLowerCase());
            }

            public final Object applyOrElse(Header x, Function1 function1) {
                Header header;
                Header header2 = x;
                if (header2 != null && this.loggedResponseHeaderNames$4.contains((Object)(header = header2).headerName().toLowerCase())) {
                    return LogAnnotation$.MODULE$.apply(header.headerName(), header.renderedValue());
                }
                return function1.apply((Object)x);
            }
        })).toSet();
    }

    private static scala.collection.immutable.Set requestLogging$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Response response$17, Request request$15, Duration duration$4, scala.collection.immutable.Set bodyAnnotations$1, scala.collection.immutable.Set loggedRequestHeaderNames$7, scala.collection.immutable.Set loggedResponseHeaderNames$7) {
        return (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogAnnotation[]{LogAnnotation$.MODULE$.apply("status_code", response$17.status().text()), LogAnnotation$.MODULE$.apply("method", request$15.method().toString()), LogAnnotation$.MODULE$.apply("url", request$15.url().encode()), LogAnnotation$.MODULE$.apply("duration_ms", BoxesRunTime.boxToLong((long)duration$4.toMillis()).toString())}))).union((Set)HandlerAspects.requestHeaders$1(request$15, loggedRequestHeaderNames$7)).union((Set)HandlerAspects.responseHeaders$9(response$17, loggedResponseHeaderNames$7)).union((Set)bodyAnnotations$1);
    }

    private static String requestLogging$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "Http request served";
    }

    private static Response requestLogging$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(Response response$18) {
        return response$18;
    }

    private static Response runAfter$$anonfun$1$$anonfun$1(Response response$19) {
        return response$19;
    }

    private static Request runBefore$$anonfun$1$$anonfun$1(Request request$16) {
        return request$16;
    }

    private static /* synthetic */ ZIO whenResponseZIO$$anonfun$2$$anonfun$1(Function1 f$12, Response response$22, boolean bool) {
        if (bool) {
            return (ZIO)f$12.apply((Object)response$22);
        }
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply((Object)"zio.http.HandlerAspects.whenResponseZIO(HandlerAspect.scala:814)", (Function0 & Serializable)() -> {
            Unsafe$ unsafe$2 = Unsafe$.MODULE$;
            return response$22;
        });
    }
}

