/*
 * Decompiled with CFR 0.152.
 */
package zio.http.codec.internal;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.Try$;
import zio.CanFail$;
import zio.Cause;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.Trace$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Boundary;
import zio.http.Boundary$;
import zio.http.Charsets$;
import zio.http.Form;
import zio.http.Form$;
import zio.http.FormField;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Method;
import zio.http.Path;
import zio.http.Path$;
import zio.http.QueryParams;
import zio.http.QueryParams$;
import zio.http.Status;
import zio.http.StreamingForm;
import zio.http.URL;
import zio.http.URL$;
import zio.http.codec.BinaryCodecWithSchema;
import zio.http.codec.BinaryCodecWithSchema$;
import zio.http.codec.CodecConfig;
import zio.http.codec.HttpCodec;
import zio.http.codec.HttpCodec$Query$QueryType$Collection$;
import zio.http.codec.HttpCodec$Query$QueryType$Primitive$;
import zio.http.codec.HttpCodec$Query$QueryType$Record$;
import zio.http.codec.HttpCodecError;
import zio.http.codec.HttpCodecError$;
import zio.http.codec.HttpCodecError$CustomError$;
import zio.http.codec.HttpCodecError$InvalidEntity$;
import zio.http.codec.HttpCodecError$InvalidQueryParamCount$;
import zio.http.codec.HttpCodecError$MalformedBody$;
import zio.http.codec.HttpCodecError$MalformedHeader$;
import zio.http.codec.HttpCodecError$MalformedMethod$;
import zio.http.codec.HttpCodecError$MalformedPath$;
import zio.http.codec.HttpCodecError$MalformedQueryParam$;
import zio.http.codec.HttpCodecError$MalformedStatus$;
import zio.http.codec.HttpCodecError$MissingHeader$;
import zio.http.codec.HttpCodecError$MissingQueryParam$;
import zio.http.codec.HttpCodecError$MissingQueryParams$;
import zio.http.codec.PathCodec;
import zio.http.codec.SimpleCodec;
import zio.http.codec.SimpleCodec$Specified$;
import zio.http.codec.internal.Atomized;
import zio.http.codec.internal.AtomizedCodecs;
import zio.http.codec.internal.AtomizedCodecs$;
import zio.http.codec.internal.BodyCodec;
import zio.http.codec.internal.EncoderDecoder$;
import zio.http.codec.internal.EncoderDecoder$Multiple$;
import zio.http.codec.internal.EncoderDecoder$Single$;
import zio.http.codec.internal.EncoderDecoder$Undefined$;
import zio.http.codec.internal.Mechanic$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.codec.DecodeError;
import zio.schema.validation.ValidationError;

public interface EncoderDecoder<AtomTypes, Value> {
    public static <AtomTypes, Value> EncoderDecoder<AtomTypes, Value> apply(HttpCodec<AtomTypes, Value> httpCodec) {
        return EncoderDecoder$.MODULE$.apply(httpCodec);
    }

    public ZIO<Object, Throwable, Value> decode(CodecConfig var1, URL var2, Status var3, Method var4, Headers var5, Body var6, Object var7);

    public <Z> Z encodeWith(CodecConfig var1, Value var2, Chunk<Header.Accept.MediaTypeWithQFactor> var3, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> var4);

    public static final class Multiple<AtomTypes, Value>
    implements EncoderDecoder<AtomTypes, Value>,
    Product,
    Serializable {
        private final Chunk httpCodecs;
        private final Chunk singles;

        public static <AtomTypes, Value> Multiple<AtomTypes, Value> apply(Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> chunk) {
            return EncoderDecoder$Multiple$.MODULE$.apply(chunk);
        }

        public static Multiple<?, ?> fromProduct(Product product) {
            return EncoderDecoder$Multiple$.MODULE$.fromProduct(product);
        }

        public static <AtomTypes, Value> Multiple<AtomTypes, Value> unapply(Multiple<AtomTypes, Value> multiple) {
            return EncoderDecoder$Multiple$.MODULE$.unapply(multiple);
        }

        public Multiple(Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> httpCodecs) {
            this.httpCodecs = httpCodecs;
            this.singles = httpCodecs.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    HttpCodec httpCodec = (HttpCodec)tuple2._1();
                    HttpCodec.Fallback.Condition condition = (HttpCodec.Fallback.Condition)tuple2._2();
                    Single single = (Single)Predef$.MODULE$.ArrowAssoc(EncoderDecoder$Single$.MODULE$.apply(httpCodec));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)single, (Object)condition);
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Multiple)) return false;
            Multiple multiple = (Multiple)object;
            Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> chunk = this.httpCodecs();
            Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> chunk2 = multiple.httpCodecs();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Multiple;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Multiple";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "httpCodecs";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> httpCodecs() {
            return this.httpCodecs;
        }

        public Chunk<Tuple2<Single<AtomTypes, Value>, HttpCodec.Fallback.Condition>> singles() {
            return this.singles;
        }

        @Override
        public ZIO<Object, Throwable, Value> decode(CodecConfig config, URL url, Status status, Method method, Headers headers, Body body, Object trace) {
            return this.tryDecode$1(trace, config, url, status, method, headers, body, 0, Cause$.MODULE$.empty());
        }

        @Override
        public <Z> Z encodeWith(CodecConfig config, Value value, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> f) {
            Z encoded = null;
            Throwable lastError = null;
            for (int i = 0; i < this.singles().length(); ++i) {
                Tuple2 tuple2 = (Tuple2)this.singles().apply(i);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Single current = (Single)tuple2._1();
                Single current2 = current;
                try {
                    encoded = current2.encodeWith(config, value, outputTypes, f);
                    i = this.singles().length();
                    continue;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof HttpCodecError) {
                        HttpCodecError error = (HttpCodecError)((Object)throwable2);
                        lastError = (Throwable)((Object)error);
                        continue;
                    }
                    throw throwable;
                }
            }
            if (encoded == null) {
                throw lastError;
            }
            return encoded;
        }

        public <AtomTypes, Value> Multiple<AtomTypes, Value> copy(Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> httpCodecs) {
            return new Multiple<AtomTypes, Value>(httpCodecs);
        }

        public <AtomTypes, Value> Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> copy$default$1() {
            return this.httpCodecs();
        }

        public Chunk<Tuple2<HttpCodec<AtomTypes, Value>, HttpCodec.Fallback.Condition>> _1() {
            return this.httpCodecs();
        }

        private final ZIO tryDecode$1(Object trace$1, CodecConfig config$1, URL url$1, Status status$1, Method method$1, Headers headers$1, Body body$1, int i, Cause lastError) {
            Single codec;
            while (true) {
                if (i >= this.singles().length()) {
                    return ZIO$.MODULE$.refailCause(lastError, trace$1);
                }
                Tuple2 tuple2 = (Tuple2)this.singles().apply(i);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Single codec2 = (Single)tuple2._1();
                HttpCodec.Fallback.Condition condition = (HttpCodec.Fallback.Condition)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)codec2, (Object)condition);
                codec = (Single)tuple22._1();
                HttpCodec.Fallback.Condition condition2 = (HttpCodec.Fallback.Condition)tuple22._2();
                if (!condition2.isMissingDataOnly() || HttpCodecError$.MODULE$.isMissingDataOnly((Cause<Object>)lastError)) break;
                ++i;
            }
            return codec.decode(config$1, url$1, status$1, method$1, headers$1, body$1, trace$1).catchAllCause((Function1 & Serializable)cause -> {
                if (HttpCodecError$.MODULE$.isHttpCodecError((Cause<Object>)cause)) {
                    return this.tryDecode$1(trace$1, config$1, url$1, status$1, method$1, headers$1, body$1, i + 1, lastError.$amp$amp(cause));
                }
                return ZIO$.MODULE$.refailCause(cause, trace$1);
            }, trace$1);
        }
    }

    public static final class Single<AtomTypes, Value>
    implements EncoderDecoder<AtomTypes, Value>,
    Product,
    Serializable {
        public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(Single.class.getDeclaredField("nameByIndex$lzy1"));
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Single.class.getDeclaredField("indexByName$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Single.class.getDeclaredField("formBoundary$lzy1"));
        private final HttpCodec httpCodec;
        private final Function1<Atomized<Object[]>, Value> constructor;
        private final Function1<Value, Atomized<Object[]>> deconstructor;
        private final AtomizedCodecs flattened;
        private final Object trace;
        private volatile Object formBoundary$lzy1;
        private volatile Object indexByName$lzy1;
        private volatile Object nameByIndex$lzy1;

        public static <AtomTypes, Value> Single<AtomTypes, Value> apply(HttpCodec<AtomTypes, Value> httpCodec) {
            return EncoderDecoder$Single$.MODULE$.apply(httpCodec);
        }

        public static Single<?, ?> fromProduct(Product product) {
            return EncoderDecoder$Single$.MODULE$.fromProduct(product);
        }

        public static <AtomTypes, Value> Single<AtomTypes, Value> unapply(Single<AtomTypes, Value> single) {
            return EncoderDecoder$Single$.MODULE$.unapply(single);
        }

        public Single(HttpCodec<AtomTypes, Value> httpCodec) {
            this.httpCodec = httpCodec;
            this.constructor = Mechanic$.MODULE$.makeConstructor(httpCodec);
            this.deconstructor = Mechanic$.MODULE$.makeDeconstructor(httpCodec);
            this.flattened = AtomizedCodecs$.MODULE$.flatten(httpCodec);
            this.trace = Trace$.MODULE$.empty();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Single)) return false;
            Single single = (Single)object;
            HttpCodec<AtomTypes, Value> httpCodec = this.httpCodec();
            HttpCodec<AtomTypes, Value> httpCodec2 = single.httpCodec();
            if (httpCodec != null) {
                if (!httpCodec.equals(httpCodec2)) return false;
                return true;
            }
            if (httpCodec2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Single;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Single";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "httpCodec";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpCodec<AtomTypes, Value> httpCodec() {
            return this.httpCodec;
        }

        public Object trace() {
            return this.trace;
        }

        private Boundary formBoundary() {
            Object object = this.formBoundary$lzy1;
            if (object instanceof Boundary) {
                return (Boundary)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Boundary)this.formBoundary$lzyINIT1();
        }

        private Object formBoundary$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.formBoundary$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Boundary boundary = null;
                        try {
                            boundary = Boundary$.MODULE$.apply("----zio-http-boundary-D4792A5C-93E0-43B5-9A1F-48E38FDE5714");
                            object2 = boundary == null ? LazyVals.NullValue$.MODULE$ : boundary;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.formBoundary$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return boundary;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private Map<String, Object> indexByName() {
            Object object = this.indexByName$lzy1;
            if (object instanceof Map) {
                return (Map)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Map)this.indexByName$lzyINIT1();
        }

        private Object indexByName$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.indexByName$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Map map = null;
                        try {
                            map = this.flattened.content().zipWithIndex().map((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    BodyCodec codec = (BodyCodec)tuple2._1();
                                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                    String string = (String)Predef$.MODULE$.ArrowAssoc(codec.name().getOrElse(() -> this.indexByName$lzyINIT1$$anonfun$1$$anonfun$1(idx)));
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)idx));
                                }
                                throw new MatchError((Object)tuple2);
                            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                            object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.indexByName$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return map;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private Map<Object, String> nameByIndex() {
            Object object = this.nameByIndex$lzy1;
            if (object instanceof Map) {
                return (Map)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Map)this.nameByIndex$lzyINIT1();
        }

        private Object nameByIndex$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.nameByIndex$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Map map = null;
                        try {
                            map = (Map)this.indexByName().map((Function1 & Serializable)_$1 -> _$1.swap());
                            object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.nameByIndex$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return map;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public ZIO<Object, Throwable, Value> decode(CodecConfig config, URL url, Status status, Method method, Headers headers, Body body, Object trace) {
            return ZIO$.MODULE$.suspendSucceed(() -> this.decode$$anonfun$2(url, config, status, method, headers, body, trace), trace);
        }

        @Override
        public <Z> Z encodeWith(CodecConfig config, Value value, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> f) {
            Atomized inputs = (Atomized)this.deconstructor.apply(value);
            Path path = this.encodePath((Object[])inputs.path());
            QueryParams query = this.encodeQuery(config, (Object[])inputs.query());
            Option<Status> status = this.encodeStatus((Object[])inputs.status());
            Option<Method> method = this.encodeMethod((Object[])inputs.method());
            Headers headers = this.encodeHeaders((Object[])inputs.header());
            Body body = this.encodeBody(config, (Object[])inputs.content(), outputTypes);
            Headers headers0 = headers.contains("content-type") ? headers : headers.$plus$plus(this.contentTypeHeaders$1(inputs, outputTypes));
            return (Z)f.apply((Object)URL$.MODULE$.apply(path, URL$.MODULE$.$lessinit$greater$default$2(), query, URL$.MODULE$.$lessinit$greater$default$4()), status, method, (Object)headers0, (Object)body);
        }

        private <A, Codec> void genericDecode(A a, Chunk<Codec> codecs, Object[] inputs, Function2<Codec, A, Object> decode) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), inputs.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Object codec = codecs.apply(i);
                inputs$2[i] = decode.apply(codec, a);
            });
        }

        private void decodePaths(Path path2, Object[] inputs) {
            this.genericDecode(path2, this.flattened.path(), inputs, (Function2 & Serializable)(codec, path) -> {
                Either<String, Object> either = codec.erase().decode((Path)path);
                if (either instanceof Left) {
                    String error = (String)((Left)either).value();
                    throw HttpCodecError$MalformedPath$.MODULE$.apply((Path)path, (PathCodec<?>)codec, error);
                }
                if (either instanceof Right) {
                    Object value = ((Right)either).value();
                    return value;
                }
                throw new MatchError(either);
            });
        }

        private void decodeQuery(CodecConfig config, QueryParams queryParams2, Object[] inputs) {
            this.genericDecode(queryParams2, this.flattened.query(), inputs, (Function2 & Serializable)(codec, queryParams) -> {
                HttpCodec.Query<Object, Object> query = codec.erase();
                boolean isOptional = query.isOptional();
                HttpCodec.Query.QueryType<Object> queryType = query.queryType();
                if (queryType instanceof HttpCodec.Query.QueryType.Primitive) {
                    HttpCodec.Query.QueryType.Primitive primitive = HttpCodec$Query$QueryType$Primitive$.MODULE$.unapply((HttpCodec.Query.QueryType.Primitive)queryType);
                    String string = primitive._1();
                    BinaryCodecWithSchema binaryCodecWithSchema = primitive._2();
                    String name = string;
                    if (binaryCodecWithSchema != null) {
                        Schema schema;
                        BinaryCodecWithSchema binaryCodecWithSchema2 = BinaryCodecWithSchema$.MODULE$.unapply(binaryCodecWithSchema);
                        Function1 function1 = binaryCodecWithSchema2._1();
                        Schema schema2 = schema = binaryCodecWithSchema2._2();
                        BinaryCodecWithSchema bc = binaryCodecWithSchema;
                        int count = queryParams.valueCount(name);
                        boolean hasParam = queryParams.hasQueryParam(name);
                        if (!hasParam && isOptional) {
                            return None$.MODULE$;
                        }
                        if (!hasParam) {
                            throw HttpCodecError$MissingQueryParam$.MODULE$.apply(name);
                        }
                        if (count != 1) {
                            throw HttpCodecError$InvalidQueryParamCount$.MODULE$.apply(name, 1, count);
                        }
                        Either either = bc.codec(config).decode((Object)Chunk$.MODULE$.fromArray((Object)queryParams.unsafeQueryParam(name).getBytes(Charsets$.MODULE$.Utf8())));
                        if (either instanceof Left) {
                            DecodeError error = (DecodeError)((Left)either).value();
                            throw HttpCodecError$MalformedQueryParam$.MODULE$.apply(name, error);
                        }
                        if (!(either instanceof Right)) {
                            throw new MatchError((Object)either);
                        }
                        Object value2 = ((Right)either).value();
                        Object decoded = value2;
                        Chunk validationErrors = schema2.validate(decoded, schema2);
                        if (validationErrors.nonEmpty()) {
                            throw HttpCodecError$InvalidEntity$.MODULE$.wrap((Chunk<ValidationError>)validationErrors);
                        }
                        if (isOptional) {
                            Object object = decoded;
                            None$ none$ = None$.MODULE$;
                            if (!(object != null ? !object.equals(none$) : none$ != null) && this.emptyStringIsValue(((Schema.Optional)schema2).schema())) {
                                return Some$.MODULE$.apply((Object)"");
                            }
                        }
                        return decoded;
                    }
                }
                if (queryType instanceof HttpCodec.Query.QueryType.Collection) {
                    HttpCodec.Query.QueryType.Collection collection = (HttpCodec.Query.QueryType.Collection)queryType;
                    HttpCodec.Query.QueryType.Collection collection2 = HttpCodec$Query$QueryType$Collection$.MODULE$.unapply(collection);
                    Schema.Collection<?, ?> collection3 = collection2._1();
                    HttpCodec.Query.QueryType.Primitive primitive = collection2._2();
                    boolean bl = collection2._3();
                    if (primitive != null) {
                        HttpCodec.Query.QueryType.Primitive primitive2 = HttpCodec$Query$QueryType$Primitive$.MODULE$.unapply(primitive);
                        String string = primitive2._1();
                        BinaryCodecWithSchema binaryCodecWithSchema = primitive2._2();
                        String name = string;
                        BinaryCodecWithSchema bc = binaryCodecWithSchema;
                        boolean optional = bl;
                        HttpCodec.Query.QueryType.Collection c = collection;
                        if (!queryParams.hasQueryParam(name)) {
                            if (!optional) {
                                return c.toCollection((Chunk<Object>)Chunk$.MODULE$.empty());
                            }
                            return None$.MODULE$;
                        }
                        Chunk<String> values = queryParams.queryParams(name);
                        Object decoded = c.toCollection((Chunk<Object>)values.map((Function1 & Serializable)value -> {
                            Either either = bc.codec(config).decode((Object)Chunk$.MODULE$.fromArray((Object)value.getBytes(Charsets$.MODULE$.Utf8())));
                            if (either instanceof Left) {
                                DecodeError error = (DecodeError)((Left)either).value();
                                throw HttpCodecError$MalformedQueryParam$.MODULE$.apply(name, error);
                            }
                            if (either instanceof Right) {
                                Object value2 = ((Right)either).value();
                                return value2;
                            }
                            throw new MatchError((Object)either);
                        }));
                        Schema erasedSchema = (Schema)c.colSchema();
                        Chunk validationErrors = erasedSchema.validate(decoded, erasedSchema);
                        if (validationErrors.nonEmpty()) {
                            throw HttpCodecError$InvalidEntity$.MODULE$.wrap((Chunk<ValidationError>)validationErrors);
                        }
                        if (optional) {
                            return Some$.MODULE$.apply(decoded);
                        }
                        return decoded;
                    }
                }
                if (queryType instanceof HttpCodec.Query.QueryType.Record) {
                    Schema schema;
                    HttpCodec.Query.QueryType.Record record = (HttpCodec.Query.QueryType.Record)queryType;
                    HttpCodec.Query.QueryType.Record record2 = HttpCodec$Query$QueryType$Record$.MODULE$.unapply(record);
                    Schema recordSchema = schema = record2._1();
                    HttpCodec.Query.QueryType.Record query2 = record;
                    boolean hasAllParams = query2.fieldAndCodecs().forall((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Schema.Field field = (Schema.Field)tuple2._1();
                            return queryParams.hasQueryParam(field.name()) || field.optional() || field.defaultValue().isDefined();
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    if (!hasAllParams && recordSchema instanceof Schema.Optional) {
                        return None$.MODULE$;
                    }
                    if (!hasAllParams && isOptional) {
                        Either either = recordSchema.defaultValue();
                        if (either instanceof Left) {
                            String err = (String)((Left)either).value();
                            throw new IllegalStateException(new StringBuilder(46).append("Cannot compute default value for ").append(recordSchema).append(". Error was: ").append(err).toString());
                        }
                        if (either instanceof Right) {
                            Object value3 = ((Right)either).value();
                            return value3;
                        }
                        throw new MatchError((Object)either);
                    }
                    if (!hasAllParams) {
                        throw HttpCodecError$MissingQueryParams$.MODULE$.apply((Chunk<String>)query2.fieldAndCodecs().collect((PartialFunction)new Serializable((QueryParams)queryParams){
                            private final QueryParams queryParams$2;
                            {
                                this.queryParams$2 = queryParams$4;
                            }

                            public final boolean isDefinedAt(Tuple2 x) {
                                Schema.Field field;
                                Tuple2 tuple2 = x;
                                return tuple2 != null && !this.queryParams$2.hasQueryParam((field = (Schema.Field)tuple2._1()).name()) && !field.optional() && !field.defaultValue().isDefined();
                            }

                            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                                Schema.Field field;
                                Tuple2 tuple2 = x;
                                if (!(tuple2 == null || this.queryParams$2.hasQueryParam((field = (Schema.Field)tuple2._1()).name()) || field.optional() || field.defaultValue().isDefined())) {
                                    return field.name();
                                }
                                return function1.apply((Object)x);
                            }
                        }));
                    }
                    Chunk decoded = query2.fieldAndCodecs().map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Object object;
                            Schema.Field field = (Schema.Field)tuple2._1();
                            BinaryCodecWithSchema binaryCodecWithSchema = (BinaryCodecWithSchema)tuple2._2();
                            Schema.Field field2 = field;
                            BinaryCodecWithSchema codec = binaryCodecWithSchema;
                            if (field2.schema() instanceof Schema.Collection) {
                                Object object2;
                                if (!queryParams.hasQueryParam(field2.name()) && field2.defaultValue().nonEmpty()) {
                                    return field2.defaultValue().get();
                                }
                                Chunk<String> values = queryParams.queryParams(field2.name());
                                Chunk decoded = values.map((Function1 & Serializable)value -> {
                                    Either either = codec.codec(config).decode((Object)Chunk$.MODULE$.fromArray((Object)value.getBytes(Charsets$.MODULE$.Utf8())));
                                    if (either instanceof Left) {
                                        DecodeError error = (DecodeError)((Left)either).value();
                                        throw HttpCodecError$MalformedQueryParam$.MODULE$.apply(field2.name(), error);
                                    }
                                    if (either instanceof Right) {
                                        Object value2 = ((Right)either).value();
                                        return value2;
                                    }
                                    throw new MatchError((Object)either);
                                });
                                Schema schema = field2.schema();
                                if (schema instanceof Schema.Sequence) {
                                    Schema.Sequence sequence = (Schema.Sequence)schema;
                                    Schema.Sequence sequence2 = Schema.Sequence$.MODULE$.unapply(sequence);
                                    Schema schema2 = sequence2._1();
                                    Function1 function1 = sequence2._2();
                                    Function1 function12 = sequence2._3();
                                    Chunk chunk = sequence2._4();
                                    Object object3 = sequence2._5();
                                    Schema.Sequence s = sequence;
                                    Schema erasedSchema = (Schema)s;
                                    Function1 fromChunk = function1;
                                    Object collection = fromChunk.apply((Object)decoded);
                                    Chunk validationErrors = erasedSchema.validate(collection, erasedSchema);
                                    if (validationErrors.nonEmpty()) {
                                        throw HttpCodecError$InvalidEntity$.MODULE$.wrap((Chunk<ValidationError>)validationErrors);
                                    }
                                    object2 = collection;
                                } else if (schema instanceof Schema.Set) {
                                    Schema.Set set = Schema.Set$.MODULE$.unapply((Schema.Set)schema);
                                    Schema schema3 = set._1();
                                    Chunk chunk = set._2();
                                    Schema.Set s = (Schema.Set)schema;
                                    Schema.Set erasedSchema = s;
                                    Set collection = decoded.toSet();
                                    Chunk validationErrors = erasedSchema.validate((Object)collection, (Schema)erasedSchema);
                                    if (validationErrors.nonEmpty()) {
                                        throw HttpCodecError$InvalidEntity$.MODULE$.wrap((Chunk<ValidationError>)validationErrors);
                                    }
                                    object2 = collection;
                                } else {
                                    throw new IllegalStateException("Only Sequence and Set are supported.");
                                }
                                Set decodedCollection = object2;
                                return decodedCollection;
                            }
                            Schema.Field field3 = field;
                            BinaryCodecWithSchema codec2 = binaryCodecWithSchema;
                            String value2 = queryParams.queryParamOrElse(field3.name(), (Function0<String>)((Function0 & Serializable)this::$anonfun$5));
                            if (value2 == null) {
                                object = field3.defaultValue().get();
                            } else {
                                Either either = codec2.codec(config).decode((Object)Chunk$.MODULE$.fromArray((Object)value2.getBytes(Charsets$.MODULE$.Utf8())));
                                if (either instanceof Left) {
                                    DecodeError error = (DecodeError)((Left)either).value();
                                    throw HttpCodecError$MalformedQueryParam$.MODULE$.apply(field3.name(), error);
                                }
                                if (either instanceof Right) {
                                    Object value3;
                                    object = value3 = ((Right)either).value();
                                } else {
                                    throw new MatchError((Object)either);
                                }
                            }
                            Object decoded = object;
                            Chunk validationErrors = codec2.schema().validate(decoded, codec2.schema());
                            if (validationErrors.nonEmpty()) {
                                throw HttpCodecError$InvalidEntity$.MODULE$.wrap((Chunk<ValidationError>)validationErrors);
                            }
                            return decoded;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    if (recordSchema instanceof Schema.Optional) {
                        Schema.Record schema3 = (Schema.Record)((Schema.Optional)recordSchema).schema();
                        Either constructed = schema3.construct(decoded, Unsafe$.MODULE$.unsafe());
                        Either either = constructed;
                        if (either instanceof Left) {
                            String value4 = (String)((Left)either).value();
                            throw HttpCodecError$MalformedQueryParam$.MODULE$.apply(String.valueOf(schema3.id()), (DecodeError)DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.empty(), value4));
                        }
                        if (either instanceof Right) {
                            Object value5 = ((Right)either).value();
                            Chunk chunk = schema3.validate(value5, (Schema)schema3);
                            Chunk errors = chunk;
                            if (errors.nonEmpty()) {
                                throw HttpCodecError$InvalidEntity$.MODULE$.wrap((Chunk<ValidationError>)errors);
                            }
                            return Some$.MODULE$.apply(value5);
                        }
                        throw new MatchError((Object)either);
                    }
                    Schema.Record schema4 = (Schema.Record)recordSchema;
                    Either constructed = schema4.construct(decoded, Unsafe$.MODULE$.unsafe());
                    Either either = constructed;
                    if (either instanceof Left) {
                        String value6 = (String)((Left)either).value();
                        throw HttpCodecError$MalformedQueryParam$.MODULE$.apply(String.valueOf(schema4.id()), (DecodeError)DecodeError.ReadError$.MODULE$.apply(Cause$.MODULE$.empty(), value6));
                    }
                    if (either instanceof Right) {
                        Object value7 = ((Right)either).value();
                        Chunk chunk = schema4.validate(value7, (Schema)schema4);
                        Chunk errors = chunk;
                        if (errors.nonEmpty()) {
                            throw HttpCodecError$InvalidEntity$.MODULE$.wrap((Chunk<ValidationError>)errors);
                        }
                        return value7;
                    }
                    throw new MatchError((Object)either);
                }
                throw new MatchError(queryType);
            });
        }

        private boolean emptyStringIsValue(Schema<?> schema) {
            StandardType standardType = ((Schema.Primitive)schema).standardType();
            if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                return true;
            }
            if (StandardType.StringType$.MODULE$.equals(standardType)) {
                return true;
            }
            if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                return true;
            }
            return StandardType.CharType$.MODULE$.equals(standardType);
        }

        private void decodeHeaders(Headers headers2, Object[] inputs) {
            this.genericDecode(headers2, this.flattened.header(), inputs, (Function2 & Serializable)(codec, headers) -> {
                Option<String> option = headers.get(codec.name());
                if (option instanceof Some) {
                    String value = (String)((Some)option).value();
                    return codec.erase().textCodec().decode(value).getOrElse(() -> this.decodeHeaders$$anonfun$1$$anonfun$1(codec));
                }
                if (None$.MODULE$.equals(option)) {
                    throw HttpCodecError$MissingHeader$.MODULE$.apply(codec.name());
                }
                throw new MatchError(option);
            });
        }

        private void decodeStatus(Status status2, Object[] inputs) {
            this.genericDecode(status2, this.flattened.status(), inputs, (Function2 & Serializable)(codec, status) -> {
                SimpleCodec simpleCodec = codec;
                if (simpleCodec instanceof SimpleCodec.Specified) {
                    Status status2;
                    Status expected;
                    SimpleCodec.Specified specified = SimpleCodec$Specified$.MODULE$.unapply((SimpleCodec.Specified)simpleCodec);
                    Status status3 = expected = (status2 = (Status)specified._1());
                    Status status4 = status;
                    if (status3 == null ? status4 != null : !status3.equals(status4)) {
                        throw HttpCodecError$MalformedStatus$.MODULE$.apply(expected, (Status)status);
                    }
                }
                if (simpleCodec instanceof SimpleCodec.Unspecified) {
                    return status;
                }
                return BoxedUnit.UNIT;
            });
        }

        private void decodeMethod(Method method2, Object[] inputs) {
            this.genericDecode(method2, this.flattened.method(), inputs, (Function2 & Serializable)(codec, method) -> {
                SimpleCodec simpleCodec = codec;
                if (simpleCodec instanceof SimpleCodec.Specified) {
                    Method method2;
                    Method expected;
                    SimpleCodec.Specified specified = SimpleCodec$Specified$.MODULE$.unapply((SimpleCodec.Specified)simpleCodec);
                    Method method3 = expected = (method2 = (Method)specified._1());
                    Method method4 = method;
                    if (method3 == null ? method4 != null : !method3.equals(method4)) {
                        throw HttpCodecError$MalformedMethod$.MODULE$.apply(expected, (Method)method);
                    }
                }
                if (simpleCodec instanceof SimpleCodec.Unspecified) {
                    return method;
                }
                return BoxedUnit.UNIT;
            });
        }

        private ZIO<Object, Throwable, BoxedUnit> decodeBody(CodecConfig config, Body body, Object[] inputs, Object trace) {
            Chunk<BodyCodec<?>> codecs = this.flattened.content();
            if (inputs.length < 2) {
                return (ZIO)codecs.headOption().map((Function1 & Serializable)codec -> codec.decodeFromBody(body, config, trace).mapBoth((Function1 & Serializable)err -> HttpCodecError$MalformedBody$.MODULE$.apply(err.getMessage(), (Option<Throwable>)Some$.MODULE$.apply(err)), (Function1)(JProcedure1 & Serializable)result -> {
                    inputs$4[0] = result;
                }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), trace)).getOrElse(this::decodeBody$$anonfun$2);
            }
            return this.decodeForm(body.asMultipartFormStream(trace), inputs, config).$times$greater(() -> this.decodeBody$$anonfun$3(inputs), trace);
        }

        private ZIO<Object, Throwable, BoxedUnit> decodeForm(ZIO<Object, Throwable, StreamingForm> form, Object[] inputs, CodecConfig config) {
            return form.flatMap((Function1 & Serializable)_$2 -> _$2.collectAll(this.trace()), this.trace()).flatMap((Function1 & Serializable)collectedForm -> ZIO$.MODULE$.foreachDiscard(() -> this.decodeForm$$anonfun$2$$anonfun$1(collectedForm), (Function1 & Serializable)field -> {
                Chunk<BodyCodec<?>> codecs = this.flattened.content();
                int i = BoxesRunTime.unboxToInt((Object)this.indexByName().get((Object)field.name()).getOrElse(() -> this.$anonfun$6(field)));
                BodyCodec<Object> codec = ((BodyCodec)codecs.apply(i)).erase();
                return codec.decodeFromField((FormField)field, config, this.trace()).flatMap((Function1 & Serializable)decoded -> ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$1 -> {
                    inputs$9[i$2] = decoded;
                }, this.trace()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, this.trace()), this.trace());
            }, this.trace()), this.trace());
        }

        private ZIO<Object, Throwable, BoxedUnit> check(Object[] inputs) {
            return ZIO$.MODULE$.attempt((Function1)(JProcedure1 & Serializable)evidence$2 -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), inputs.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (inputs[i] == null) {
                    throw HttpCodecError$MalformedBody$.MODULE$.apply(new StringBuilder(35).append("Missing multipart/form-data field (").append(Try$.MODULE$.apply(() -> this.check$$anonfun$1$$anonfun$1$$anonfun$1(i))).toString(), HttpCodecError$MalformedBody$.MODULE$.$lessinit$greater$default$2());
                }
            }), this.trace());
        }

        private <A, Codec> A genericEncode(Chunk<Codec> codecs, Object[] inputs, A init, Function3<Codec, Object, A, A> encoding) {
            ObjectRef res = ObjectRef.create(init);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), inputs.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Object object;
                Object codec = codecs.apply(i);
                Object input = inputs[i];
                res$1.elem = object = encoding.apply(codec, input, res$1.elem);
                object = null;
            });
            return (A)res.elem;
        }

        private <A> Option<A> simpleEncode(Chunk<SimpleCodec<A, ?>> codecs, Object[] inputs) {
            return codecs.headOption().map((Function1 & Serializable)codec -> {
                SimpleCodec simpleCodec = codec;
                if (simpleCodec instanceof SimpleCodec.Unspecified) {
                    return inputs[0];
                }
                if (simpleCodec instanceof SimpleCodec.Specified) {
                    Object a;
                    SimpleCodec.Specified specified = SimpleCodec$Specified$.MODULE$.unapply((SimpleCodec.Specified)simpleCodec);
                    Object elem = a = specified._1();
                    return elem;
                }
                throw new MatchError((Object)simpleCodec);
            });
        }

        private Path encodePath(Object[] inputs) {
            return this.genericEncode(this.flattened.path(), inputs, Path$.MODULE$.empty(), (Function3 & Serializable)(codec, a, acc) -> {
                Either<String, Path> either = codec.erase().encode(a);
                if (either instanceof Left) {
                    String error = (String)((Left)either).value();
                    throw HttpCodecError$MalformedPath$.MODULE$.apply((Path)acc, (PathCodec<?>)codec, error);
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Path value = (Path)((Right)either).value();
                Path encoded = value;
                return acc.$plus$plus(encoded);
            });
        }

        private QueryParams encodeQuery(CodecConfig config, Object[] inputs) {
            return this.genericEncode(this.flattened.query(), inputs, QueryParams$.MODULE$.empty(), (Function3 & Serializable)(codec, input, queryParams) -> {
                HttpCodec.Query<Object, Object> query = codec.erase();
                HttpCodec.Query.QueryType<Object> queryType = query.queryType();
                if (queryType instanceof HttpCodec.Query.QueryType.Primitive) {
                    HttpCodec.Query.QueryType.Primitive primitive = HttpCodec$Query$QueryType$Primitive$.MODULE$.unapply((HttpCodec.Query.QueryType.Primitive)queryType);
                    String string = primitive._1();
                    BinaryCodecWithSchema binaryCodecWithSchema = primitive._2();
                    String name = string;
                    BinaryCodecWithSchema codec2 = binaryCodecWithSchema;
                    Schema schema = codec2.schema();
                    if (schema instanceof Schema.Primitive) {
                        if (((Schema.Primitive)schema).standardType() == StandardType.UnitType$.MODULE$) {
                            return (QueryParams)queryParams.addQueryParams(name, (Chunk<String>)Chunk$.MODULE$.empty());
                        }
                        String encoded = ((Chunk)codec2.codec(config).encode(input)).asString(Chunk.IsText$.MODULE$.byteIsText());
                        return (QueryParams)queryParams.addQueryParams(name, (Chunk<String>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{encoded})));
                    }
                    if (schema instanceof Schema.Optional) {
                        String encoded = ((Chunk)codec2.codec(config).encode(input)).asString(Chunk.IsText$.MODULE$.byteIsText());
                        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(encoded))) {
                            return (QueryParams)queryParams.addQueryParams(name, (Chunk<String>)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{encoded})));
                        }
                        return queryParams;
                    }
                    throw new IllegalStateException("Only primitive schema is supported for query parameters of type Primitive");
                }
                if (queryType instanceof HttpCodec.Query.QueryType.Collection) {
                    HttpCodec.Query.QueryType.Collection collection = HttpCodec$Query$QueryType$Collection$.MODULE$.unapply((HttpCodec.Query.QueryType.Collection)queryType);
                    Schema.Collection<?, ?> collection2 = collection._1();
                    HttpCodec.Query.QueryType.Primitive primitive = collection._2();
                    boolean bl = collection._3();
                    if (primitive != null) {
                        Iterable values;
                        HttpCodec.Query.QueryType.Primitive primitive2 = HttpCodec$Query$QueryType$Primitive$.MODULE$.unapply(primitive);
                        String string = primitive2._1();
                        BinaryCodecWithSchema binaryCodecWithSchema = primitive2._2();
                        String name = string;
                        BinaryCodecWithSchema codec3 = binaryCodecWithSchema;
                        boolean optional = bl;
                        Object in = input;
                        if (optional) {
                            in = ((Option)input).getOrElse(this::encodeQuery$$anonfun$1$$anonfun$1);
                        }
                        if ((values = (Iterable)input).nonEmpty()) {
                            return (QueryParams)queryParams.addQueryParams(name, (Chunk<String>)Chunk$.MODULE$.fromIterable((Iterable)values.map((Function1 & Serializable)value -> ((Chunk)codec3.codec(config).encode(value)).asString(Chunk.IsText$.MODULE$.byteIsText()))));
                        }
                        return queryParams;
                    }
                }
                if (queryType instanceof HttpCodec.Query.QueryType.Record) {
                    Schema schema;
                    HttpCodec.Query.QueryType.Record record = (HttpCodec.Query.QueryType.Record)queryType;
                    HttpCodec.Query.QueryType.Record record2 = HttpCodec$Query$QueryType$Record$.MODULE$.unapply(record);
                    Schema recordSchema = schema = record2._1();
                    HttpCodec.Query.QueryType.Record query2 = record;
                    if (recordSchema instanceof Schema.Optional) {
                        Object object = input;
                        if (None$.MODULE$.equals(object)) {
                            return queryParams;
                        }
                        if (object instanceof Some) {
                            Object value2 = ((Some)object).value();
                            Schema.Record innerSchema = (Schema.Record)((Schema.Optional)recordSchema).schema();
                            Chunk fieldValues = innerSchema.deconstruct(value2, Unsafe$.MODULE$.unsafe());
                            QueryParams qp = queryParams;
                            for (int j = 0; j < fieldValues.size(); ++j) {
                                Object value3;
                                Object object2;
                                Tuple2 tuple2 = (Tuple2)query2.fieldAndCodecs().apply(j);
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                Schema.Field field = (Schema.Field)tuple2._1();
                                BinaryCodecWithSchema codec4 = (BinaryCodecWithSchema)tuple2._2();
                                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)field, (Object)codec4);
                                Schema.Field field2 = (Schema.Field)tuple22._1();
                                BinaryCodecWithSchema codec5 = (BinaryCodecWithSchema)tuple22._2();
                                String name = field2.name();
                                Option option = (Option)fieldValues.apply(j);
                                if (option instanceof Some) {
                                    Object value4;
                                    object2 = value4 = ((Some)option).value();
                                } else if (None$.MODULE$.equals(option)) {
                                    object2 = field2.defaultValue();
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                Object object3 = value3 = object2;
                                if (object3 instanceof Iterable) {
                                    Iterable values = (Iterable)object3;
                                    qp = (QueryParams)qp.addQueryParams(name, (Chunk<String>)Chunk$.MODULE$.fromIterable((Iterable)values.map((Function1 & Serializable)v -> ((Chunk)codec5.codec(config).encode(v)).asString(Chunk.IsText$.MODULE$.byteIsText()))));
                                    continue;
                                }
                                String encoded = ((Chunk)codec5.codec(config).encode(value3)).asString(Chunk.IsText$.MODULE$.byteIsText());
                                qp = (QueryParams)qp.addQueryParam(name, encoded);
                            }
                            return qp;
                        }
                        throw new MatchError(object);
                    }
                    Schema recordSchema2 = schema;
                    HttpCodec.Query.QueryType.Record query3 = record;
                    Schema.Record innerSchema = (Schema.Record)recordSchema2;
                    Chunk fieldValues = innerSchema.deconstruct(input, Unsafe$.MODULE$.unsafe());
                    QueryParams qp = queryParams;
                    for (int j = 0; j < fieldValues.size(); ++j) {
                        Object value5;
                        Object object;
                        Object object4;
                        Tuple2 tuple2 = (Tuple2)query3.fieldAndCodecs().apply(j);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Schema.Field field = (Schema.Field)tuple2._1();
                        BinaryCodecWithSchema codec6 = (BinaryCodecWithSchema)tuple2._2();
                        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)field, (Object)codec6);
                        Schema.Field field3 = (Schema.Field)tuple23._1();
                        BinaryCodecWithSchema codec7 = (BinaryCodecWithSchema)tuple23._2();
                        String name = field3.name();
                        Option option = (Option)fieldValues.apply(j);
                        if (option instanceof Some) {
                            Object value6;
                            object4 = value6 = ((Some)option).value();
                        } else if (None$.MODULE$.equals(option)) {
                            object4 = field3.defaultValue();
                        } else {
                            throw new MatchError((Object)option);
                        }
                        Object values = object = (value5 = object4);
                        if (values instanceof Iterable) {
                            qp = (QueryParams)qp.addQueryParams(name, (Chunk<String>)Chunk$.MODULE$.fromIterable((Iterable)((Iterable)values).map((Function1 & Serializable)v -> ((Chunk)codec7.codec(config).encode(v)).asString(Chunk.IsText$.MODULE$.byteIsText()))));
                            continue;
                        }
                        String encoded = ((Chunk)codec7.codec(config).encode(value5)).asString(Chunk.IsText$.MODULE$.byteIsText());
                        qp = (QueryParams)qp.addQueryParam(name, encoded);
                    }
                    return qp;
                }
                throw new MatchError(queryType);
            });
        }

        private Headers encodeHeaders(Object[] inputs) {
            return this.genericEncode(this.flattened.header(), inputs, Headers$.MODULE$.empty(), (Function3 & Serializable)(codec, input, headers) -> headers.$plus$plus(Headers$.MODULE$.apply(codec.name(), codec.erase().textCodec().encode(input))));
        }

        private Option<Status> encodeStatus(Object[] inputs) {
            return this.simpleEncode(this.flattened.status(), inputs);
        }

        private Option<Method> encodeMethod(Object[] inputs) {
            return this.simpleEncode(this.flattened.method(), inputs);
        }

        private Body encodeBody(CodecConfig config, Object[] inputs, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes) {
            int n = inputs.length;
            if (0 == n) {
                return Body$.MODULE$.empty();
            }
            if (1 == n) {
                BodyCodec bodyCodec = (BodyCodec)this.flattened.content().apply(0);
                return bodyCodec.erase().encodeToBody(inputs[0], outputTypes, config, this.trace());
            }
            return Body$.MODULE$.fromMultipartForm(this.encodeMultipartFormData(inputs, outputTypes, config), this.formBoundary(), this.trace());
        }

        private Form encodeMultipartFormData(Object[] inputs, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes, CodecConfig config) {
            Chunk formFields = this.flattened.content().zipWithIndex().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    BodyCodec bodyCodec = (BodyCodec)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Object input = inputs[idx];
                    String name = (String)this.nameByIndex().apply((Object)BoxesRunTime.boxToInteger((int)idx));
                    return bodyCodec.erase().encodeToField(input, outputTypes, name, config, this.trace());
                }
                throw new MatchError((Object)tuple2);
            });
            return Form$.MODULE$.apply((Seq<FormField>)formFields);
        }

        private Headers encodeContentType(Object[] inputs, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes) {
            int n = inputs.length;
            if (0 == n) {
                return Headers$.MODULE$.empty();
            }
            if (1 == n) {
                MediaType mediaType = (MediaType)((BodyCodec)this.flattened.content().apply(0)).mediaType(outputTypes).getOrElse(this::$anonfun$8);
                return Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(mediaType, Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())}));
            }
            return Headers$.MODULE$.apply((Seq<Header>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{Header$ContentType$.MODULE$.apply(MediaType$.MODULE$.multipart().form$minusdata(), Header$ContentType$.MODULE$.$lessinit$greater$default$2(), Header$ContentType$.MODULE$.$lessinit$greater$default$3())}));
        }

        public <AtomTypes, Value> Single<AtomTypes, Value> copy(HttpCodec<AtomTypes, Value> httpCodec) {
            return new Single<AtomTypes, Value>(httpCodec);
        }

        public <AtomTypes, Value> HttpCodec<AtomTypes, Value> copy$default$1() {
            return this.httpCodec();
        }

        public HttpCodec<AtomTypes, Value> _1() {
            return this.httpCodec();
        }

        private final String indexByName$lzyINIT1$$anonfun$1$$anonfun$1(int idx$1) {
            return new StringBuilder(5).append("field").append(BoxesRunTime.boxToInteger((int)idx$1).toString()).toString();
        }

        private final Object decode$$anonfun$2$$anonfun$1(Atomized inputsBuilder$1) {
            return this.constructor.apply((Object)inputsBuilder$1);
        }

        private final ZIO decode$$anonfun$2(URL url$3, CodecConfig config$3, Status status$3, Method method$3, Headers headers$3, Body body$3, Object trace$3) {
            Atomized<Object[]> inputsBuilder = this.flattened.makeInputsBuilder();
            this.decodePaths(url$3.path(), inputsBuilder.path());
            this.decodeQuery(config$3, url$3.queryParams(), inputsBuilder.query());
            this.decodeStatus(status$3, inputsBuilder.status());
            this.decodeMethod(method$3, inputsBuilder.method());
            this.decodeHeaders(headers$3, inputsBuilder.header());
            return this.decodeBody(config$3, body$3, inputsBuilder.content(), trace$3).as(() -> this.decode$$anonfun$2$$anonfun$1(inputsBuilder), trace$3);
        }

        private final Headers contentTypeHeaders$1(Atomized inputs$1, Chunk outputTypes$1) {
            return this.encodeContentType((Object[])inputs$1.content(), (Chunk<Header.Accept.MediaTypeWithQFactor>)outputTypes$1);
        }

        private final String $anonfun$5() {
            return null;
        }

        private final Object decodeHeaders$$anonfun$1$$anonfun$1(HttpCodec.Header codec$2) {
            throw HttpCodecError$MalformedHeader$.MODULE$.apply(codec$2.name(), codec$2.textCodec());
        }

        private final ZIO decodeBody$$anonfun$2() {
            return ZIO$.MODULE$.unit();
        }

        private final ZIO decodeBody$$anonfun$3(Object[] inputs$5) {
            return this.check(inputs$5);
        }

        private final Iterable decodeForm$$anonfun$2$$anonfun$1(Form collectedForm$1) {
            return collectedForm$1.formData();
        }

        private final int $anonfun$6(FormField field$2) {
            throw HttpCodecError$MalformedBody$.MODULE$.apply(new StringBuilder(38).append("Unexpected multipart/form-data field: ").append(field$2.name()).toString(), HttpCodecError$MalformedBody$.MODULE$.$lessinit$greater$default$2());
        }

        private final String check$$anonfun$1$$anonfun$1$$anonfun$1(int i$3) {
            return (String)this.nameByIndex().apply((Object)BoxesRunTime.boxToInteger((int)i$3));
        }

        private final Object encodeQuery$$anonfun$1$$anonfun$1() {
            return Chunk$.MODULE$.empty();
        }

        private final MediaType $anonfun$8() {
            throw HttpCodecError$CustomError$.MODULE$.apply("InvalidHttpContentCodec", "No codecs found.");
        }
    }

    public static final class Undefined<AtomTypes, Value>
    implements EncoderDecoder<AtomTypes, Value>,
    Product,
    Serializable {
        private final String encodeWithErrorMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |Trying to encode with Undefined codec. That means that encode was invoked for object of type Nothing - which cannot exist.\n        |Verify that middleware and endpoint have proper types or submit bug report at https://github.com/zio/zio-http/issues\n    ")).trim();
        private final String decodeErrorMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |Trying to decode with Undefined codec. That means that decode was invoked for object of type Nothing - which cannot exist.\n        |Verify that middleware and endpoint have proper types or submit bug report at https://github.com/zio/zio-http/issues\n    ")).trim();

        public static <AtomTypes, Value> Undefined<AtomTypes, Value> apply() {
            return EncoderDecoder$Undefined$.MODULE$.apply();
        }

        public static Undefined<?, ?> fromProduct(Product product) {
            return EncoderDecoder$Undefined$.MODULE$.fromProduct(product);
        }

        public static <AtomTypes, Value> boolean unapply(Undefined<AtomTypes, Value> undefined) {
            return EncoderDecoder$Undefined$.MODULE$.unapply(undefined);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Undefined)) return false;
            Undefined undefined = (Undefined)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Undefined;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "Undefined";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String encodeWithErrorMessage() {
            return this.encodeWithErrorMessage;
        }

        public String decodeErrorMessage() {
            return this.decodeErrorMessage;
        }

        @Override
        public <Z> Z encodeWith(CodecConfig config, Value value, Chunk<Header.Accept.MediaTypeWithQFactor> outputTypes, Function5<URL, Option<Status>, Option<Method>, Headers, Body, Z> f) {
            throw new IllegalStateException(this.encodeWithErrorMessage());
        }

        @Override
        public ZIO<Object, Throwable, Value> decode(CodecConfig config, URL url, Status status, Method method, Headers headers, Body body, Object trace) {
            return ZIO$.MODULE$.fail(this::decode$$anonfun$1, trace);
        }

        public <AtomTypes, Value> Undefined<AtomTypes, Value> copy() {
            return new Undefined<AtomTypes, Value>();
        }

        private final IllegalStateException decode$$anonfun$1() {
            return new IllegalStateException(this.decodeErrorMessage());
        }
    }
}

