/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.proxy.HttpProxyHandler;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.runtime.BoxesRunTime;
import zio.Chunk;
import zio.Config;
import zio.http.Credentials;
import zio.http.Proxy;
import zio.http.netty.NettyProxy$;
import zio.http.netty.model.Conversions$;

public class NettyProxy {
    private final Proxy proxy;

    public static NettyProxy fromProxy(Proxy proxy) {
        return NettyProxy$.MODULE$.fromProxy(proxy);
    }

    public NettyProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Option<HttpProxyHandler> encode() {
        return (Option)this.proxy.credentials().fold(this::encode$$anonfun$1, (Function1 & Serializable)credentials -> this.authorizedProxy((Credentials)credentials));
    }

    private Option<HttpProxyHandler> authorizedProxy(Credentials credentials) {
        return this.buildProxyAddress().map((Function1 & Serializable)proxyAddress -> {
            String uname = credentials.uname();
            Config.Secret upassword = credentials.upassword();
            HttpHeaders encodedHeaders = Conversions$.MODULE$.headersToNetty(this.proxy.headers());
            return Tuple4$.MODULE$.apply(proxyAddress, (Object)uname, (Object)upassword, (Object)encodedHeaders);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 != null) {
                InetSocketAddress proxyAddress = (InetSocketAddress)tuple4._1();
                String uname = (String)tuple4._2();
                Config.Secret upassword = (Config.Secret)tuple4._3();
                HttpHeaders encodedHeaders = (HttpHeaders)tuple4._4();
                return new HttpProxyHandler((SocketAddress)proxyAddress, uname, upassword.value().asString(Chunk.IsText$.MODULE$.charIsText()), encodedHeaders);
            }
            throw new MatchError((Object)tuple4);
        });
    }

    private Option<HttpProxyHandler> unauthorizedProxy() {
        return this.buildProxyAddress().map((Function1 & Serializable)proxyAddress -> {
            HttpHeaders encodedHeaders = Conversions$.MODULE$.headersToNetty(this.proxy.headers());
            return Tuple2$.MODULE$.apply(proxyAddress, (Object)encodedHeaders);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                InetSocketAddress proxyAddress = (InetSocketAddress)tuple2._1();
                HttpHeaders encodedHeaders = (HttpHeaders)tuple2._2();
                return new HttpProxyHandler((SocketAddress)proxyAddress, encodedHeaders);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Option<InetSocketAddress> buildProxyAddress() {
        return this.proxy.url().host().flatMap((Function1 & Serializable)proxyHost -> this.proxy.url().port().map((Function1 & Serializable)proxyPort -> NettyProxy.buildProxyAddress$$anonfun$1$$anonfun$1(proxyHost, BoxesRunTime.unboxToInt((Object)proxyPort))));
    }

    private final Option encode$$anonfun$1() {
        return this.unauthorizedProxy();
    }

    private static final /* synthetic */ InetSocketAddress buildProxyAddress$$anonfun$1$$anonfun$1(String proxyHost$1, int proxyPort) {
        return new InetSocketAddress(proxyHost$1, proxyPort);
    }
}

